/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.facade;

import ghidra.features.bsim.query.protocol.BSimFilter;
import ghidra.features.bsim.query.protocol.FilterAtom;
import ghidra.features.bsim.query.protocol.PreFilter;
import ghidra.features.bsim.query.protocol.QueryNearest;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.listing.Program;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class SFQueryInfo {
    public static final int DEFAULT_QUERIES_PER_STAGE = 10;
    private Set<FunctionSymbol> functions;
    private Program program;
    private QueryNearest queryNearest;
    private BSimFilter bsimFilter;
    private PreFilter preFilter;

    public SFQueryInfo(Set<FunctionSymbol> functions) {
        if (functions == null) {
            throw new IllegalArgumentException("Function list cannot be null");
        }
        if (functions.isEmpty()) {
            throw new IllegalArgumentException("Function list cannot be empty");
        }
        this.functions = functions;
        for (FunctionSymbol s : functions) {
            if (this.program == null) {
                this.program = s.getProgram();
                continue;
            }
            if (this.program == s.getProgram()) continue;
            throw new IllegalArgumentException("all function symbols are not from the same program");
        }
        this.queryNearest = new QueryNearest();
        this.bsimFilter = new BSimFilter();
        this.preFilter = new PreFilter();
    }

    public Program getProgram() {
        return this.program;
    }

    public double getSimilarityThreshold() {
        return this.queryNearest.thresh;
    }

    public void setSimilarityThreshold(double similarityThreshold) {
        this.queryNearest.thresh = similarityThreshold;
    }

    public double getSignificanceThreshold() {
        return this.queryNearest.signifthresh;
    }

    public void setSignificanceThreshold(double significanceThreshold) {
        this.queryNearest.signifthresh = significanceThreshold;
    }

    public int getMaximumResults() {
        return this.queryNearest.max;
    }

    public void setMaximumResults(int maximumResults) {
        this.queryNearest.max = maximumResults;
    }

    public QueryNearest buildQueryNearest() {
        this.queryNearest.bsimFilter = this.bsimFilter.isEmpty() ? null : this.bsimFilter;
        return this.queryNearest;
    }

    public Set<FunctionSymbol> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Set<FunctionSymbol> functions) {
        this.functions = functions;
    }

    public BSimFilter getBsimFilter() {
        return this.bsimFilter;
    }

    public PreFilter getPreFilter() {
        return this.preFilter;
    }

    public Collection<String> getFilterInfoStrings() {
        ArrayList<String> arrlist = new ArrayList<String>();
        for (int i = 0; i < this.bsimFilter.numAtoms(); ++i) {
            FilterAtom atom = this.bsimFilter.getAtom(i);
            String str = atom.getInfoString();
            if (str == null) continue;
            arrlist.add(str);
        }
        return arrlist;
    }

    public int getNumberOfStages(int queries_per_stage) {
        if (this.functions == null || this.functions.size() == 0) {
            return 1;
        }
        if (queries_per_stage == 0) {
            queries_per_stage = 10;
        }
        return (this.functions.size() + (queries_per_stage - 1)) / queries_per_stage;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "\n\tsimilarity: " + this.queryNearest.thresh + "\n\tsignificance: " + this.queryNearest.signifthresh + "\n\tmax results: " + this.queryNearest.max + "\n\tfunction count: " + this.functions.size();
    }
}

