/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.external;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.external.ExternalLocationDB;
import ghidra.program.database.external.OldExtNameAdapter;
import ghidra.program.database.external.OldExtRefAdapter;
import ghidra.program.database.function.FunctionDB;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.references.ReferenceDBManager;
import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.database.symbol.LibrarySymbol;
import ghidra.program.database.symbol.MemorySymbol;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Library;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalLocationIterator;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ExternalManagerDB
implements ManagerDB,
ExternalManager {
    private AddressMap addrMap;
    private SymbolManager symbolMgr;
    private FunctionManagerDB functionMgr;
    private ProgramDB program;
    private Lock lock;
    private OldExtNameAdapter oldNameAdapter;
    private OldExtRefAdapter oldExtRefAdapter;

    public ExternalManagerDB(DBHandle handle, AddressMap addrMap, OpenMode openMode, Lock lock, TaskMonitor monitor) throws CancelledException, IOException, VersionException {
        this.addrMap = addrMap;
        this.lock = lock;
        this.initializeOldAdapters(handle, openMode, monitor);
    }

    private void initializeOldAdapters(DBHandle handle, OpenMode openMode, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        try {
            this.oldNameAdapter = OldExtNameAdapter.getAdapter(handle, openMode, monitor);
            this.oldExtRefAdapter = OldExtRefAdapter.getAdapter(handle, openMode, monitor);
        }
        catch (VersionException versionException) {
            // empty catch block
        }
        if (this.oldNameAdapter != null && this.oldExtRefAdapter != null && openMode != OpenMode.UPGRADE) {
            throw new VersionException(true);
        }
    }

    @Override
    public void setProgram(ProgramDB program) {
        this.program = program;
        this.symbolMgr = program.getSymbolTable();
        this.functionMgr = program.getFunctionManager();
    }

    @Override
    public void programReady(OpenMode openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
        if (openMode != OpenMode.UPGRADE) {
            return;
        }
        if (this.upgradeOldExtRefAdapter(monitor)) {
            return;
        }
    }

    private boolean upgradeOldExtRefAdapter(TaskMonitor monitor) throws IOException, CancelledException {
        if (this.oldNameAdapter == null || this.oldExtRefAdapter == null) {
            return false;
        }
        monitor.setMessage("Processing Old External Names...");
        monitor.initialize((long)this.oldNameAdapter.getRecordCount());
        int cnt = 0;
        HashMap<Long, String> nameMap = new HashMap<Long, String>();
        RecordIterator iter = this.oldNameAdapter.getRecords();
        while (iter.hasNext()) {
            monitor.checkCancelled();
            DBRecord rec = iter.next();
            String name = rec.getString(0);
            try {
                this.addExternalName(name, rec.getString(1), SourceType.USER_DEFINED);
                nameMap.put(rec.getKey(), name);
            }
            catch (DuplicateNameException duplicateNameException) {
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            monitor.setProgress((long)(++cnt));
        }
        AddressMap oldAddrMap = this.addrMap.getOldAddressMap();
        ReferenceDBManager refMgr = this.program.getReferenceManager();
        monitor.setMessage("Processing Old External References...");
        monitor.initialize((long)this.oldExtRefAdapter.getRecordCount());
        cnt = 0;
        iter = this.oldExtRefAdapter.getRecords();
        while (iter.hasNext()) {
            monitor.checkCancelled();
            DBRecord rec = iter.next();
            Address fromAddr = oldAddrMap.decodeAddress(rec.getLongValue(0));
            short opIndex = rec.getShortValue(1);
            boolean userDefined = rec.getBooleanValue(2);
            String extLibraryName = (String)nameMap.get(rec.getLongValue(3));
            if (extLibraryName == null) continue;
            String label = rec.getString(4);
            Address addr = rec.getBooleanValue(6) ? oldAddrMap.decodeAddress(rec.getLongValue(5)) : null;
            try {
                refMgr.addExternalReference(fromAddr, extLibraryName, label, addr, userDefined ? SourceType.USER_DEFINED : SourceType.IMPORTED, (int)opIndex, RefType.DATA);
            }
            catch (DuplicateNameException | InvalidInputException e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
            monitor.setProgress((long)(++cnt));
        }
        this.oldExtRefAdapter = null;
        return true;
    }

    @Override
    public void invalidateCache(boolean all) throws IOException {
    }

    @Override
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
    }

    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalLocation addExtLocation(String extLibraryName, String extLabel, Address extAddr, SourceType sourceType) throws InvalidInputException, DuplicateNameException {
        SourceType locSourceType = this.checkExternalLabel(extLabel, extAddr, sourceType);
        this.lock.acquire();
        try {
            Library libraryScope = this.getLibraryScope(extLibraryName);
            if (libraryScope == null) {
                libraryScope = this.addExternalName(extLibraryName, null, sourceType);
            }
            ExternalLocation externalLocation = this.addExtLocation(libraryScope, extLabel, extAddr, false, locSourceType, true);
            return externalLocation;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalLocation addExtLocation(Namespace extParentNamespace, String extLabel, Address extAddr, SourceType sourceType) throws InvalidInputException {
        this.lock.acquire();
        try {
            ExternalLocation externalLocation = this.addExtLocation(extParentNamespace, extLabel, extAddr, false, sourceType, true);
            return externalLocation;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalLocation addExtLocation(Namespace extParentNamespace, String extLabel, Address extAddr, SourceType sourceType, boolean reuseExisting) throws InvalidInputException {
        this.lock.acquire();
        try {
            ExternalLocation externalLocation = this.addExtLocation(extParentNamespace, extLabel, extAddr, false, sourceType, reuseExisting);
            return externalLocation;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalLocation addExtFunction(String extLibraryName, String extLabel, Address extAddr, SourceType sourceType) throws InvalidInputException, DuplicateNameException {
        SourceType locSourceType = this.checkExternalLabel(extLabel, extAddr, sourceType);
        this.lock.acquire();
        try {
            Library libraryScope = this.getLibraryScope(extLibraryName);
            if (libraryScope == null) {
                libraryScope = this.addExternalName(extLibraryName, null, sourceType != SourceType.DEFAULT ? sourceType : SourceType.ANALYSIS);
            }
            ExternalLocation externalLocation = this.addExtLocation(libraryScope, extLabel, extAddr, true, locSourceType, true);
            return externalLocation;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalLocation addExtFunction(Namespace extParentNamespace, String extLabel, Address extAddr, SourceType sourceType) throws InvalidInputException {
        this.lock.acquire();
        try {
            ExternalLocation externalLocation = this.addExtLocation(extParentNamespace, extLabel, extAddr, true, sourceType, true);
            return externalLocation;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalLocation addExtFunction(Namespace extNamespace, String extLabel, Address extAddr, SourceType sourceType, boolean reuseExisting) throws InvalidInputException {
        this.lock.acquire();
        try {
            ExternalLocation externalLocation = this.addExtLocation(extNamespace, extLabel, extAddr, true, sourceType, reuseExisting);
            return externalLocation;
        }
        finally {
            this.lock.release();
        }
    }

    private SourceType checkExternalLabel(String extLabel, Address extAddr, SourceType source) throws InvalidInputException {
        if (StringUtils.isBlank((CharSequence)extLabel) || SymbolUtilities.isReservedExternalDefaultName(extLabel, this.addrMap.getAddressFactory())) {
            extLabel = null;
        }
        if (extLabel == null && extAddr == null) {
            throw new InvalidInputException("Either an external label or address is required");
        }
        return extLabel == null ? SourceType.DEFAULT : source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalLocation addExtLocation(Namespace extNamespace, String extLabel, Address extAddr, boolean isFunction, SourceType sourceType, boolean reuseExisting) throws InvalidInputException {
        if (extNamespace == null) {
            extNamespace = this.getLibraryScope("<EXTERNAL>");
            if (extNamespace == null) {
                try {
                    extNamespace = this.addExternalLibraryName("<EXTERNAL>", SourceType.ANALYSIS);
                }
                catch (DuplicateNameException e) {
                    throw new InvalidInputException("Failed to establish <EXTERNAL> library");
                }
            }
        } else if (!extNamespace.isExternal()) {
            throw new InvalidInputException("The namespace must be an external namespace.");
        }
        sourceType = this.checkExternalLabel(extLabel, extAddr, sourceType);
        if (extAddr != null) {
            if (!extAddr.isLoadedMemoryAddress()) {
                throw new InvalidInputException("Invalid memory address: " + String.valueOf(extAddr));
            }
            AddressSpace space = extAddr.getAddressSpace();
            if (!space.equals(this.program.getAddressFactory().getAddressSpace(space.getName()))) {
                throw new InvalidInputException("Memory address not defined for program: " + String.valueOf(extAddr));
            }
        }
        this.lock.acquire();
        try {
            MemorySymbol s;
            ExternalLocationDB extLoc;
            if (sourceType == SourceType.DEFAULT) {
                extLabel = null;
            } else if (StringUtils.isBlank((CharSequence)extLabel) || SymbolUtilities.isReservedExternalDefaultName(extLabel, this.addrMap.getAddressFactory())) {
                extLabel = null;
            }
            if ((extAddr != null || reuseExisting) && (extLoc = (ExternalLocationDB)this.getExtLocation(extNamespace, extLabel, extAddr, reuseExisting)) != null) {
                if (extLabel != null && !extLabel.equals(extLoc.getLabel())) {
                    extLoc.setLabel(extLabel, sourceType);
                }
                if (isFunction) {
                    extLoc = (ExternalLocationDB)this.createFunction(extLoc).getExternalLocation();
                }
                ExternalLocationDB externalLocationDB = extLoc;
                return externalLocationDB;
            }
            Address externalSpaceAddress = this.symbolMgr.getNextExternalSymbolAddress();
            if (isFunction) {
                FunctionDB function = this.functionMgr.createExternalFunction(externalSpaceAddress, extLabel, extNamespace, null, extAddr, sourceType);
                s = (FunctionSymbol)function.getSymbol();
            } else {
                s = this.symbolMgr.createExternalCodeSymbol(externalSpaceAddress, extLabel, extNamespace, sourceType, null, extAddr);
            }
            ExternalLocationDB externalLocationDB = new ExternalLocationDB(this, s);
            return externalLocationDB;
        }
        catch (IOException e) {
            this.program.dbError(e);
            ExternalLocation externalLocation = null;
            return externalLocation;
        }
        finally {
            this.lock.release();
        }
    }

    private ExternalLocation getExtLocation(Namespace library, String extLabel, Address extAddr, boolean reuseExisting) throws InvalidInputException {
        ExternalLocation match = this.findMatchingLocationByName(library, extLabel, extAddr, reuseExisting);
        if (match != null) {
            return match;
        }
        if (extLabel == null) {
            return this.findMatchingLocationByAddress(extAddr, reuseExisting);
        }
        return null;
    }

    private ExternalLocation findMatchingLocationByName(Namespace namespace, String extLabel, Address extAddr, boolean reuseExisting) {
        if (StringUtils.isBlank((CharSequence)extLabel)) {
            return null;
        }
        Set<ExternalLocation> externalLocations = this.getExternalLocations(namespace, extLabel);
        if (externalLocations.isEmpty()) {
            return null;
        }
        if (extAddr != null) {
            for (ExternalLocation externalLocation : externalLocations) {
                if (!extAddr.equals(externalLocation.getAddress())) continue;
                return externalLocation;
            }
            if (reuseExisting) {
                for (ExternalLocation externalLocation : externalLocations) {
                    if (externalLocation.getAddress() != null) continue;
                    return externalLocation;
                }
            }
            return null;
        }
        ExternalLocation possibleExtLoc = null;
        for (ExternalLocation externalLocation : externalLocations) {
            if (externalLocation.getAddress() == null) {
                return externalLocation;
            }
            possibleExtLoc = externalLocation;
        }
        return reuseExisting ? possibleExtLoc : null;
    }

    private ExternalLocation findMatchingLocationByAddress(Address extAddr, boolean reuseExisting) {
        for (Symbol symbol : this.symbolMgr.getExternalSymbolByMemoryAddress(null, extAddr)) {
            ExternalLocation externalLocation = this.getExternalLocation(symbol);
            if (!reuseExisting && externalLocation.getLabel() != null) continue;
            return externalLocation;
        }
        return null;
    }

    @Override
    public Set<ExternalLocation> getExternalLocations(Namespace namespace, String extLabel) {
        ExternalLocation externalLocation;
        if (namespace != null && !namespace.isExternal()) {
            return Set.of();
        }
        HashSet<ExternalLocation> externalLocations = new HashSet<ExternalLocation>();
        if (namespace == null || namespace instanceof Library) {
            SymbolIterator matchingSymbols = this.symbolMgr.getExternalSymbolByOriginalImportName((Library)namespace, extLabel);
            for (Symbol symbol : matchingSymbols) {
                externalLocation = this.getExternalLocation(symbol);
                if (externalLocation == null) continue;
                externalLocations.add(externalLocation);
            }
        }
        if (namespace != null) {
            List<Symbol> symbols = this.symbolMgr.getSymbols(extLabel, namespace);
            for (Symbol symbol : symbols) {
                externalLocation = this.getExternalLocation(symbol);
                if (externalLocation == null) continue;
                externalLocations.add(externalLocation);
            }
        } else {
            for (Symbol symbol : this.symbolMgr.getExternalSymbols(extLabel)) {
                ExternalLocation externalLocation2 = this.getExternalLocation(symbol);
                if (externalLocation2 == null) continue;
                externalLocations.add(externalLocation2);
            }
        }
        return Collections.unmodifiableSet(externalLocations);
    }

    @Override
    public Set<ExternalLocation> getExternalLocations(String libraryName, String label) {
        Library library = this.getLibraryScope(libraryName);
        if (library == null && !StringUtils.isBlank((CharSequence)libraryName)) {
            return Set.of();
        }
        return this.getExternalLocations(library, label);
    }

    @Override
    public ExternalLocation getUniqueExternalLocation(Namespace namespace, String label) {
        Set<ExternalLocation> externalLocations = this.getExternalLocations(namespace, label);
        if (externalLocations.size() == 1) {
            return externalLocations.iterator().next();
        }
        return null;
    }

    @Override
    public ExternalLocation getUniqueExternalLocation(String libraryName, String label) {
        Library library = this.getLibraryScope(libraryName);
        if (library == null && !StringUtils.isBlank((CharSequence)libraryName)) {
            return null;
        }
        return this.getUniqueExternalLocation(library, label);
    }

    public static String getDefaultExternalName(SymbolDB sym) {
        if (!(sym instanceof MemorySymbol) && !sym.isExternal()) {
            throw new IllegalArgumentException("External label or function symbol required");
        }
        Address addr = ((MemorySymbol)sym).getExternalProgramAddress();
        if (addr == null) {
            throw new IllegalArgumentException("Default External requires memory address");
        }
        if (sym instanceof FunctionSymbol) {
            return SymbolUtilities.getDefaultExternalFunctionName(addr);
        }
        long dataTypeID = sym.getDataTypeId();
        DataType dt = dataTypeID < 0L ? null : sym.getProgram().getDataTypeManager().getDataType(dataTypeID);
        return SymbolUtilities.getDefaultExternalName(addr, dt);
    }

    ProgramDB getProgram() {
        return this.program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalLocation getExtLocation(Address externalAddr) {
        if (externalAddr.getAddressSpace() != AddressSpace.EXTERNAL_SPACE) {
            throw new IllegalArgumentException("Expected external address");
        }
        this.lock.acquire();
        try {
            Symbol[] symbols = this.symbolMgr.getSymbols(externalAddr);
            if (symbols.length == 1) {
                ExternalLocationDB externalLocationDB = new ExternalLocationDB(this, (MemorySymbol)symbols[0]);
                return externalLocationDB;
            }
            if (symbols.length > 2) {
                throw new AssertException("More than two symbols are not expected for external addresses: " + String.valueOf(externalAddr));
            }
            ExternalLocation externalLocation = null;
            return externalLocation;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public ExternalLocation getExternalLocation(Symbol symbol) {
        if (!(symbol instanceof SymbolDB) || !symbol.isExternal()) {
            return null;
        }
        SymbolType symbolType = symbol.getSymbolType();
        if (symbolType == SymbolType.LABEL || symbolType == SymbolType.FUNCTION) {
            return this.getExtLocation(symbol.getAddress());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeExternalLocation(Address externalAddr) {
        this.lock.acquire();
        try {
            ExternalLocationDB loc = (ExternalLocationDB)this.getExtLocation(externalAddr);
            if (loc != null) {
                loc.getSymbol().delete();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    SymbolManager getSymbolManager() {
        return this.symbolMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeExternalLibrary(String name) {
        this.lock.acquire();
        try {
            LibrarySymbol s = this.symbolMgr.getLibrarySymbol(name);
            if (s != null) {
                if (this.symbolMgr.getChildren(s).hasNext()) {
                    boolean bl = false;
                    return bl;
                }
                s.delete();
            }
        }
        finally {
            this.lock.release();
        }
        return true;
    }

    @Override
    public void updateExternalLibraryName(String oldName, String newName, SourceType source) throws DuplicateNameException, InvalidInputException {
        LibrarySymbol s = this.symbolMgr.getLibrarySymbol(oldName);
        if (s != null) {
            s.setName(newName, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Library addExternalLibraryName(String name, SourceType source) throws DuplicateNameException, InvalidInputException {
        this.lock.acquire();
        try {
            LibrarySymbol librarySymbol = this.symbolMgr.getLibrarySymbol(name);
            if (librarySymbol != null) {
                Library library = (Library)librarySymbol.getObject();
                return library;
            }
            Library library = this.addExternalName(name, null, source);
            return library;
        }
        finally {
            this.lock.release();
        }
    }

    private Library addExternalName(String name, String pathname, SourceType source) throws DuplicateNameException, InvalidInputException {
        LibrarySymbol s = this.symbolMgr.createLibrarySymbol(name, pathname, source);
        return (Library)s.getObject();
    }

    private Library getLibraryScope(String name) {
        LibrarySymbol s = this.symbolMgr.getLibrarySymbol(name);
        return s == null ? null : s.getObject();
    }

    @Override
    public boolean contains(String libraryName) {
        return this.symbolMgr.getLibrarySymbol(libraryName) != null;
    }

    @Override
    public String[] getExternalLibraryNames() {
        Symbol[] syms;
        ArrayList<String> list = new ArrayList<String>();
        for (Symbol s : syms = this.symbolMgr.getSymbols(Address.NO_ADDRESS)) {
            if (s.getSymbolType() != SymbolType.LIBRARY) continue;
            list.add(s.getName());
        }
        String[] names = new String[list.size()];
        list.toArray(names);
        return names;
    }

    @Override
    public Library getExternalLibrary(String name) {
        LibrarySymbol s = this.symbolMgr.getLibrarySymbol(name);
        return s != null ? (Library)s.getObject() : null;
    }

    @Override
    public String getExternalLibraryPath(String externalName) {
        LibrarySymbol s = this.symbolMgr.getLibrarySymbol(externalName);
        if (s != null) {
            return s.getExternalLibraryPath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExternalPath(String externalName, String externalPath, boolean userDefined) throws InvalidInputException {
        block7: {
            if ("<EXTERNAL>".equals(externalName)) {
                Msg.warn((Object)this, (Object)("Ignoring external library path for " + externalName));
                return;
            }
            this.validateExternalPath(externalPath);
            this.lock.acquire();
            try {
                LibrarySymbol s = this.symbolMgr.getLibrarySymbol(externalName);
                if (s == null) {
                    try {
                        this.addExternalName(externalName, externalPath, userDefined ? SourceType.USER_DEFINED : SourceType.IMPORTED);
                        break block7;
                    }
                    catch (DuplicateNameException e) {
                        throw new AssertException((Throwable)e);
                    }
                }
                s.setExternalLibraryPath(externalPath);
            }
            finally {
                this.lock.release();
            }
        }
    }

    private void validateExternalPath(String path) throws InvalidInputException {
        if (path == null) {
            return;
        }
        int len = path.length();
        if (len == 0 || path.charAt(0) != '/') {
            throw new InvalidInputException("Absolute path must begin with '/'");
        }
    }

    Function createFunction(ExternalLocationDB extLoc) {
        if (extLoc.isFunction()) {
            return extLoc.getFunction();
        }
        this.lock.acquire();
        try {
            SymbolDB symbol = (SymbolDB)extLoc.getSymbol();
            if (!(symbol instanceof CodeSymbol)) {
                throw new IllegalStateException("Expected external code symbol");
            }
            Address extProgAddr = extLoc.getAddress();
            String origImpName = extLoc.getOriginalImportedName();
            String name = symbol.getName();
            Namespace namespace = symbol.getParentNamespace();
            Address extAddr = symbol.getAddress();
            SourceType source = symbol.getSource();
            ((CodeSymbol)symbol).delete(true);
            FunctionDB functionDB = this.functionMgr.createExternalFunction(extAddr, name, namespace, origImpName, extProgAddr, source);
            return functionDB;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        finally {
            this.lock.release();
        }
    }

    AddressMap getAddressMap() {
        return this.addrMap;
    }

    @Override
    public ExternalLocationIterator getExternalLocations(Address memoryAddress) {
        return new ExternalLocationDBIterator(null, memoryAddress);
    }

    @Override
    public ExternalLocationIterator getExternalLocations(String externalName) {
        Library scope = this.getLibraryScope(externalName);
        if (scope != null) {
            return new ExternalLocationDBIterator(this.symbolMgr.getSymbols(scope));
        }
        return new ExternalLocationDBIterator();
    }

    private class ExternalLocationDBIterator
    implements ExternalLocationIterator {
        private SymbolIterator symIter;
        private Address matchingAddress;
        private ExternalLocation nextExtLoc;

        ExternalLocationDBIterator() {
        }

        ExternalLocationDBIterator(Library library, Address matchingAddress) {
            this.symIter = ExternalManagerDB.this.symbolMgr.getExternalSymbolByMemoryAddress(library, matchingAddress);
            this.matchingAddress = matchingAddress;
        }

        ExternalLocationDBIterator(SymbolIterator symIter) {
            this.symIter = symIter;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private ExternalLocation getValidExternalLocation(SymbolDB s) {
            ExternalLocation externalLocation = ExternalManagerDB.this.getExternalLocation(s);
            if (externalLocation == null) {
                return null;
            }
            if (this.matchingAddress == null) {
                return externalLocation;
            }
            if (this.matchingAddress.equals(externalLocation.getAddress())) {
                return externalLocation;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            if (this.symIter != null) {
                while (this.nextExtLoc == null && this.symIter.hasNext()) {
                    SymbolDB s = (SymbolDB)this.symIter.next();
                    this.nextExtLoc = this.getValidExternalLocation(s);
                }
            }
            return this.nextExtLoc != null;
        }

        @Override
        public ExternalLocation next() {
            if (this.hasNext()) {
                ExternalLocation tmpExtLoc = this.nextExtLoc;
                this.nextExtLoc = null;
                return tmpExtLoc;
            }
            return null;
        }
    }
}

