/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.lang.ParameterPieces;
import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.protorules.AndFilter;
import ghidra.program.model.lang.protorules.AssignAction;
import ghidra.program.model.lang.protorules.DatatypeFilter;
import ghidra.program.model.lang.protorules.QualifierFilter;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.exception.InvalidInputException;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;

public class ModelRule {
    private DatatypeFilter filter;
    private QualifierFilter qualifier;
    private AssignAction assign;
    private AssignAction[] preconditions;
    private AssignAction[] sideeffects;

    public ModelRule() {
        this.filter = null;
        this.qualifier = null;
        this.assign = null;
    }

    public ModelRule(ModelRule op2, ParamListStandard res) throws InvalidInputException {
        int i;
        this.filter = op2.filter != null ? op2.filter.clone() : null;
        this.qualifier = op2.qualifier != null ? op2.qualifier.clone() : null;
        this.assign = op2.assign != null ? op2.assign.clone(res) : null;
        this.preconditions = new AssignAction[op2.preconditions.length];
        for (i = 0; i < op2.preconditions.length; ++i) {
            this.preconditions[i] = op2.preconditions[i].clone(res);
        }
        this.sideeffects = new AssignAction[op2.sideeffects.length];
        for (i = 0; i < op2.sideeffects.length; ++i) {
            this.sideeffects[i] = op2.sideeffects[i].clone(res);
        }
    }

    public ModelRule(DatatypeFilter typeFilter, AssignAction action, ParamListStandard res) throws InvalidInputException {
        this.filter = typeFilter.clone();
        this.qualifier = null;
        this.assign = action.clone(res);
        this.preconditions = new AssignAction[0];
        this.sideeffects = new AssignAction[0];
    }

    public boolean isEquivalent(ModelRule op) {
        int i;
        if (this.assign != null || op.assign != null) {
            if (this.assign != null && op.assign != null) {
                if (!this.assign.isEquivalent(op.assign)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.filter != null || op.filter != null) {
            if (this.filter != null && op.filter != null) {
                if (!this.filter.isEquivalent(op.filter)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.qualifier != null || op.qualifier != null) {
            if (this.qualifier != null && op.qualifier != null) {
                if (!this.qualifier.isEquivalent(op.qualifier)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.preconditions.length != op.preconditions.length) {
            return false;
        }
        for (i = 0; i < this.preconditions.length; ++i) {
            if (this.preconditions[i].isEquivalent(op.preconditions[i])) continue;
            return false;
        }
        if (this.sideeffects.length != op.sideeffects.length) {
            return false;
        }
        for (i = 0; i < this.sideeffects.length; ++i) {
            if (this.sideeffects[i].isEquivalent(op.sideeffects[i])) continue;
            return false;
        }
        return true;
    }

    public int assignAddress(DataType dt, PrototypePieces proto, int pos, DataTypeManager dtManager, int[] status, ParameterPieces res) {
        if (!this.filter.filter(dt)) {
            return 1;
        }
        if (this.qualifier != null && !this.qualifier.filter(proto, pos)) {
            return 1;
        }
        int[] tmpStatus = (int[])status.clone();
        for (int i = 0; i < this.preconditions.length; ++i) {
            this.preconditions[i].assignAddress(dt, proto, pos, dtManager, tmpStatus, res);
        }
        int response = this.assign.assignAddress(dt, proto, pos, dtManager, tmpStatus, res);
        if (response != 1) {
            System.arraycopy(tmpStatus, 0, status, 0, tmpStatus.length);
            for (int i = 0; i < this.sideeffects.length; ++i) {
                this.sideeffects[i].assignAddress(dt, proto, pos, dtManager, status, res);
            }
        }
        return response;
    }

    public void encode(Encoder encoder) throws IOException {
        int i;
        encoder.openElement(ElementId.ELEM_RULE);
        this.filter.encode(encoder);
        if (this.qualifier != null) {
            this.qualifier.encode(encoder);
        }
        for (i = 0; i < this.preconditions.length; ++i) {
            this.preconditions[i].encode(encoder);
        }
        this.assign.encode(encoder);
        for (i = 0; i < this.sideeffects.length; ++i) {
            this.sideeffects[i].encode(encoder);
        }
        encoder.closeElement(ElementId.ELEM_RULE);
    }

    public void restoreXml(XmlPullParser parser, ParamListStandard res) throws XmlParseException {
        XmlElement subEl;
        AssignAction preAction;
        QualifierFilter tmpFilter;
        XmlElement elemId = parser.start(new String[]{ElementId.ELEM_RULE.name()});
        this.filter = DatatypeFilter.restoreFilterXml(parser);
        ArrayList<QualifierFilter> qualifierList = new ArrayList<QualifierFilter>();
        while ((tmpFilter = QualifierFilter.restoreFilterXml(parser)) != null) {
            qualifierList.add(tmpFilter);
        }
        if (qualifierList.size() == 0) {
            this.qualifier = null;
        } else if (qualifierList.size() == 1) {
            this.qualifier = (QualifierFilter)qualifierList.get(0);
            qualifierList.clear();
        } else {
            this.qualifier = new AndFilter(qualifierList);
        }
        ArrayList<AssignAction> preList = new ArrayList<AssignAction>();
        while ((preAction = AssignAction.restorePreconditionXml(parser, res)) != null) {
            preList.add(preAction);
        }
        this.preconditions = new AssignAction[preList.size()];
        preList.toArray(this.preconditions);
        this.assign = AssignAction.restoreActionXml(parser, res);
        ArrayList<AssignAction> sideList = new ArrayList<AssignAction>();
        while ((subEl = parser.peek()).isStart()) {
            sideList.add(AssignAction.restoreSideeffectXml(parser, res));
        }
        this.sideeffects = new AssignAction[sideList.size()];
        sideList.toArray(this.sideeffects);
        parser.end(elemId);
    }
}

