/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.pcodeCPort.opcodes.OpCode;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.CachedEncoder;
import ghidra.program.model.pcode.ElementId;
import ghidra.util.xml.SpecXmlUtils;
import java.io.IOException;
import java.io.OutputStream;

public class XmlEncode
implements CachedEncoder {
    private static final int TAG_START = 0;
    private static final int TAG_CONTENT = 1;
    private static final int TAG_STOP = 2;
    private static final char[] spaces = new char[]{'\n', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private StringBuilder buffer = new StringBuilder();
    private int tagStatus = 2;
    private int depth = 0;
    private boolean doFormatting;

    public XmlEncode() {
        this.doFormatting = true;
    }

    public XmlEncode(boolean doFormat) {
        this.doFormatting = doFormat;
    }

    private void newLine() {
        if (!this.doFormatting) {
            return;
        }
        int numSpaces = this.depth * 2 + 1;
        if (numSpaces > spaces.length) {
            numSpaces = spaces.length;
        }
        this.buffer.append(spaces, 0, numSpaces);
    }

    public String toString() {
        return this.buffer.toString();
    }

    @Override
    public void clear() {
        this.buffer = new StringBuilder();
        this.tagStatus = 2;
        this.depth = 0;
    }

    @Override
    public void openElement(ElementId elemId) throws IOException {
        if (this.tagStatus == 0) {
            this.buffer.append('>');
        } else {
            this.tagStatus = 0;
        }
        this.newLine();
        this.buffer.append('<');
        this.buffer.append(elemId.name());
        ++this.depth;
    }

    @Override
    public void closeElement(ElementId elemId) throws IOException {
        --this.depth;
        if (this.tagStatus == 0) {
            this.buffer.append("/>");
            this.tagStatus = 2;
            return;
        }
        if (this.tagStatus != 1) {
            this.newLine();
        } else {
            this.tagStatus = 2;
        }
        this.buffer.append("</");
        this.buffer.append(elemId.name());
        this.buffer.append('>');
    }

    @Override
    public void writeBool(AttributeId attribId, boolean val) throws IOException {
        if (attribId == AttributeId.ATTRIB_CONTENT) {
            if (this.tagStatus == 0) {
                this.buffer.append('>');
            }
            this.buffer.append(val ? "true" : "false");
            this.tagStatus = 1;
            return;
        }
        this.buffer.append(' ');
        this.buffer.append(attribId.name());
        this.buffer.append("=\"");
        this.buffer.append(val ? "true" : "false");
        this.buffer.append("\"");
    }

    @Override
    public void writeSignedInteger(AttributeId attribId, long val) throws IOException {
        if (attribId == AttributeId.ATTRIB_CONTENT) {
            if (this.tagStatus == 0) {
                this.buffer.append('>');
            }
            this.buffer.append(Long.toString(val, 10));
            this.tagStatus = 1;
            return;
        }
        this.buffer.append(' ');
        this.buffer.append(attribId.name());
        this.buffer.append("=\"");
        this.buffer.append(Long.toString(val, 10));
        this.buffer.append("\"");
    }

    @Override
    public void writeUnsignedInteger(AttributeId attribId, long val) throws IOException {
        if (attribId == AttributeId.ATTRIB_CONTENT) {
            if (this.tagStatus == 0) {
                this.buffer.append('>');
            }
            this.buffer.append("0x");
            this.buffer.append(Long.toHexString(val));
            this.tagStatus = 1;
            return;
        }
        this.buffer.append(' ');
        this.buffer.append(attribId.name());
        this.buffer.append("=\"0x");
        this.buffer.append(Long.toHexString(val));
        this.buffer.append("\"");
    }

    @Override
    public void writeString(AttributeId attribId, String val) throws IOException {
        if (attribId == AttributeId.ATTRIB_CONTENT) {
            if (this.tagStatus == 0) {
                this.buffer.append('>');
            }
            SpecXmlUtils.xmlEscape((StringBuilder)this.buffer, (String)val);
            this.tagStatus = 1;
            return;
        }
        this.buffer.append(' ');
        this.buffer.append(attribId.name());
        this.buffer.append("=\"");
        SpecXmlUtils.xmlEscape((StringBuilder)this.buffer, (String)val);
        this.buffer.append("\"");
    }

    @Override
    public void writeStringIndexed(AttributeId attribId, int index, String val) throws IOException {
        this.buffer.append(' ');
        this.buffer.append(attribId.name());
        this.buffer.append(index + 1);
        this.buffer.append("=\"");
        SpecXmlUtils.xmlEscape((StringBuilder)this.buffer, (String)val);
        this.buffer.append("\"");
    }

    @Override
    public void writeSpace(AttributeId attribId, AddressSpace spc) throws IOException {
        String spcName = spc.getType() == 11 ? "join" : spc.getName();
        if (attribId == AttributeId.ATTRIB_CONTENT) {
            if (this.tagStatus == 0) {
                this.buffer.append('>');
            }
            SpecXmlUtils.xmlEscape((StringBuilder)this.buffer, (String)spcName);
            this.tagStatus = 1;
            return;
        }
        this.buffer.append(' ');
        this.buffer.append(attribId.name());
        this.buffer.append("=\"");
        SpecXmlUtils.xmlEscape((StringBuilder)this.buffer, (String)spcName);
        this.buffer.append("\"");
    }

    @Override
    public void writeSpace(AttributeId attribId, int index, String name) throws IOException {
        if (attribId == AttributeId.ATTRIB_CONTENT) {
            if (this.tagStatus == 0) {
                this.buffer.append('>');
            }
            SpecXmlUtils.xmlEscape((StringBuilder)this.buffer, (String)name);
            this.tagStatus = 1;
            return;
        }
        this.buffer.append(' ');
        this.buffer.append(attribId.name());
        this.buffer.append("=\"");
        SpecXmlUtils.xmlEscape((StringBuilder)this.buffer, (String)name);
        this.buffer.append("\"");
    }

    @Override
    public void writeOpcode(AttributeId attribId, OpCode opcode) throws IOException {
        String name = opcode.getName();
        if (attribId == AttributeId.ATTRIB_CONTENT) {
            if (this.tagStatus == 0) {
                this.buffer.append('>');
            }
            this.buffer.append(name);
            this.tagStatus = 1;
            return;
        }
        this.buffer.append(' ');
        this.buffer.append(attribId.name());
        this.buffer.append("=\"");
        this.buffer.append(name);
        this.buffer.append("\"");
    }

    @Override
    public void writeTo(OutputStream stream) throws IOException {
        byte[] res = this.buffer.toString().getBytes();
        stream.write(res);
    }

    @Override
    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }
}

