/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.sevenzip;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.sevenzip.SZByteProviderStream;
import ghidra.file.formats.sevenzip.SevenZipFileSystemFactory;
import ghidra.formats.gfilesystem.AbstractFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileCache;
import ghidra.formats.gfilesystem.FileSystemIndexHelper;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.crypto.CryptoSession;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.formats.gfilesystem.fileinfo.FileType;
import ghidra.framework.generic.auth.Password;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.sevenzipjbinding.ArchiveFormat;
import net.sf.sevenzipjbinding.ExtractAskMode;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IArchiveExtractCallback;
import net.sf.sevenzipjbinding.ICryptoGetTextPassword;
import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;
import org.apache.commons.io.FilenameUtils;

@FileSystemInfo(type="7zip", description="7Zip", factory=SevenZipFileSystemFactory.class)
public class SevenZipFileSystem
extends AbstractFileSystem<ISimpleInArchiveItem> {
    private Map<Integer, String> passwords = new HashMap<Integer, String>();
    private IInArchive archive;
    private SZByteProviderStream szBPStream;
    private ISimpleInArchiveItem[] items;
    private ArchiveFormat archiveFormat;

    public SevenZipFileSystem(FSRLRoot fsrl, FileSystemService fsService) {
        super(fsrl, fsService);
    }

    public void mount(ByteProvider byteProvider, TaskMonitor monitor) throws CancelledException, IOException {
        if (!SevenZipFileSystemFactory.initNativeLibraries()) {
            throw new IOException("Could not initialize 7zip native libraries");
        }
        try {
            this.szBPStream = new SZByteProviderStream(byteProvider);
            this.archive = SevenZip.openInArchive(null, (IInStream)this.szBPStream);
            this.archiveFormat = this.archive.getArchiveFormat();
            this.items = this.archive.getSimpleInterface().getArchiveItems();
            this.indexFiles(monitor);
            this.ensurePasswords(monitor);
        }
        catch (SevenZipException e) {
            throw new IOException("Failed to open archive: " + String.valueOf(this.fsFSRL), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        FileSystemIndexHelper fileSystemIndexHelper = this.fsIndex;
        synchronized (fileSystemIndexHelper) {
            this.refManager.onClose();
            FSUtilities.uncheckedClose((AutoCloseable)this.archive, (String)"Problem closing 7-Zip archive");
            this.archive = null;
            FSUtilities.uncheckedClose((AutoCloseable)((Object)this.szBPStream), null);
            this.szBPStream = null;
            this.fsIndex.clear();
            this.items = null;
        }
    }

    private void indexFiles(TaskMonitor monitor) throws CancelledException, SevenZipException {
        monitor.initialize((long)this.items.length, "Indexing files");
        for (ISimpleInArchiveItem item : this.items) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            long itemSize = Objects.requireNonNullElse(item.getSize(), -1L);
            this.fsIndex.storeFile(this.fixupItemPath(item), (long)item.getItemIndex(), item.isFolder(), itemSize, (Object)item);
        }
    }

    private String fixupItemPath(ISimpleInArchiveItem item) throws SevenZipException {
        String itemPath = item.getPath();
        if (this.items.length == 1 && itemPath.isBlank()) {
            itemPath = FilenameUtils.getBaseName((String)this.fsFSRL.getContainer().getName());
        }
        if (itemPath.isEmpty()) {
            itemPath = "<blank>";
        }
        return itemPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPasswordForFile(GFile file, ISimpleInArchiveItem encryptedItem, TaskMonitor monitor) {
        FSRL containerFSRL = this.fsFSRL.getContainer();
        int itemIndex = encryptedItem.getItemIndex();
        if (this.passwords.containsKey(itemIndex)) return this.passwords.get(itemIndex);
        try (CryptoSession cryptoSession = this.fsService.newCryptoSession();){
            String prompt = this.passwords.isEmpty() ? containerFSRL.getName() : "%s in %s".formatted(file.getName(), containerFSRL.getName());
            Iterator pwIt = cryptoSession.getPasswordsFor(containerFSRL, prompt);
            while (pwIt.hasNext()) {
                try {
                    Password passwordValue = (Password)pwIt.next();
                    try {
                        monitor.setMessage("Testing password for " + file.getName());
                        String password = String.valueOf(passwordValue.getPasswordChars());
                        int[] encryptedItemIndexes = this.getEncryptedItemIndexes();
                        TestPasswordsCallback testCB = new TestPasswordsCallback(password, encryptedItemIndexes[0], monitor);
                        this.archive.extract(encryptedItemIndexes, true, (IArchiveExtractCallback)testCB);
                        List<Integer> successFileIndexes = testCB.getSuccessFileIndexes();
                        for (Integer unlockedFileIndex : successFileIndexes) {
                            this.passwords.put(unlockedFileIndex, password);
                        }
                        if (!successFileIndexes.isEmpty()) {
                            cryptoSession.addSuccessfulPassword(containerFSRL, passwordValue);
                        }
                        if (!this.passwords.containsKey(itemIndex)) continue;
                        return this.passwords.get(itemIndex);
                    }
                    finally {
                        if (passwordValue == null) continue;
                        passwordValue.close();
                    }
                }
                catch (SevenZipException e) {
                    Msg.error((Object)((Object)this), (Object)("Error when testing password for " + String.valueOf(file.getFSRL())), (Throwable)e);
                    String string = null;
                    if (cryptoSession == null) return string;
                    cryptoSession.close();
                    return string;
                }
            }
            return this.passwords.get(itemIndex);
        }
    }

    private int[] getEncryptedItemIndexes() throws SevenZipException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (ISimpleInArchiveItem item : this.items) {
            if (!item.isEncrypted() || this.passwords.containsKey(item.getItemIndex())) continue;
            result.add(item.getItemIndex());
        }
        int[] arrayResult = new int[result.size()];
        int arrayResultIndex = 0;
        for (Integer i : result) {
            arrayResult[arrayResultIndex++] = i;
        }
        return arrayResult;
    }

    private void ensurePasswords(TaskMonitor monitor) throws IOException {
        try (CryptoSession cryptoSession = this.fsService.newCryptoSession();){
            List<ISimpleInArchiveItem> noPasswordFoundList;
            List<ISimpleInArchiveItem> encryptedItems = this.getEncryptedItemsWithoutPasswords();
            ISimpleInArchiveItem encryptedItem = null;
            while ((encryptedItem = this.getFirstItemWithoutPassword(encryptedItems)) != null && !monitor.isCancelled()) {
                GFile gFile = this.fsIndex.getFileByIndex((long)encryptedItem.getItemIndex());
                if (gFile == null) {
                    throw new IOException("Unable to retrieve file " + encryptedItem.getPath());
                }
                this.getPasswordForFile(gFile, encryptedItem, monitor);
                if (this.passwords.isEmpty()) break;
                encryptedItems.remove(encryptedItem);
            }
            if (!(noPasswordFoundList = this.getEncryptedItemsWithoutPasswords()).isEmpty()) {
                Msg.warn((Object)((Object)this), (Object)("Unable to find password for " + noPasswordFoundList.size() + " file(s) in " + this.fsFSRL.getContainer().getName()));
            }
        }
    }

    private ISimpleInArchiveItem getFirstItemWithoutPassword(List<ISimpleInArchiveItem> encryptedItems) {
        for (ISimpleInArchiveItem item : encryptedItems) {
            if (this.passwords.containsKey(item.getItemIndex())) continue;
            return item;
        }
        return null;
    }

    private List<ISimpleInArchiveItem> getEncryptedItemsWithoutPasswords() throws SevenZipException {
        LinkedList<ISimpleInArchiveItem> result = new LinkedList<ISimpleInArchiveItem>();
        for (ISimpleInArchiveItem item : this.items) {
            if (!item.isEncrypted() || this.passwords.containsKey(item.getItemIndex())) continue;
            result.add(item);
        }
        return result;
    }

    public boolean isClosed() {
        return this.szBPStream == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        FileSystemIndexHelper fileSystemIndexHelper = this.fsIndex;
        synchronized (fileSystemIndexHelper) {
            FileAttributes result = new FileAttributes();
            if (this.fsIndex.getRootDir().equals((Object)file)) {
                result.add(FileAttributeType.NAME_ATTR, (Object)"/");
                result.add("Archive Format", (Object)this.archiveFormat.toString());
            } else {
                ISimpleInArchiveItem item = (ISimpleInArchiveItem)this.fsIndex.getMetadata(file);
                if (item == null) {
                    return result;
                }
                result.add(FileAttributeType.NAME_ATTR, (Object)FilenameUtils.getName((String)SevenZipFileSystem.uncheckedGet(() -> ((ISimpleInArchiveItem)item).getPath(), "unknown")));
                result.add(FileAttributeType.FILE_TYPE_ATTR, (Object)(SevenZipFileSystem.uncheckedGet(() -> ((ISimpleInArchiveItem)item).isFolder(), false) != false ? FileType.DIRECTORY : FileType.FILE));
                boolean encrypted = SevenZipFileSystem.uncheckedGet(() -> ((ISimpleInArchiveItem)item).isEncrypted(), false);
                result.add(FileAttributeType.IS_ENCRYPTED_ATTR, (Object)encrypted);
                if (encrypted) {
                    result.add(FileAttributeType.HAS_GOOD_PASSWORD_ATTR, (Object)(this.passwords.get(item.getItemIndex()) != null ? 1 : 0));
                }
                String comment = SevenZipFileSystem.uncheckedGet(() -> ((ISimpleInArchiveItem)item).getComment(), null);
                result.add(FileAttributeType.COMMENT_ATTR, (Object)(!comment.isBlank() ? comment : null));
                result.add(FileAttributeType.COMPRESSED_SIZE_ATTR, SevenZipFileSystem.uncheckedGet(() -> ((ISimpleInArchiveItem)item).getPackedSize(), null));
                result.add(FileAttributeType.SIZE_ATTR, SevenZipFileSystem.uncheckedGet(() -> ((ISimpleInArchiveItem)item).getSize(), null));
                Integer crc = SevenZipFileSystem.uncheckedGet(() -> ((ISimpleInArchiveItem)item).getCRC(), null);
                result.add("CRC", crc != null ? "%08X".formatted(crc) : null);
                result.add("Compression Method", SevenZipFileSystem.uncheckedGet(() -> ((ISimpleInArchiveItem)item).getMethod(), null));
                result.add(FileAttributeType.CREATE_DATE_ATTR, SevenZipFileSystem.uncheckedGet(() -> ((ISimpleInArchiveItem)item).getCreationTime(), null));
                result.add(FileAttributeType.MODIFIED_DATE_ATTR, SevenZipFileSystem.uncheckedGet(() -> ((ISimpleInArchiveItem)item).getLastWriteTime(), null));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        ByteProvider byteProvider;
        String password;
        ISimpleInArchiveItem item = (ISimpleInArchiveItem)this.fsIndex.getMetadata(file);
        if (item == null) {
            return null;
        }
        int itemIndex = item.getItemIndex();
        if (item.isFolder()) {
            throw new IOException("Not a file: " + file.getName());
        }
        if (item.isEncrypted() && (password = this.getPasswordForFile(file, item, monitor)) == null) {
            throw new CryptoException("Unable to extract encrypted file, missing password: " + item.getPath());
        }
        SZExtractCallback szCallback = new SZExtractCallback(monitor, itemIndex, true);
        try {
            FileSystemIndexHelper fileSystemIndexHelper = this.fsIndex;
            synchronized (fileSystemIndexHelper) {
                this.archive.extract(new int[]{itemIndex}, false, (IArchiveExtractCallback)szCallback);
            }
            FileCache.FileCacheEntry result = szCallback.getExtractResult(itemIndex);
            if (result == null) {
                throw new IOException("Unable to extract " + String.valueOf(file.getFSRL()));
            }
            byteProvider = result.asByteProvider(file.getFSRL());
        }
        catch (Throwable throwable) {
            try {
                try {
                    szCallback.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SevenZipException e) {
                throw this.unwrapSZException(e);
            }
        }
        szCallback.close();
        return byteProvider;
    }

    private static <T> T uncheckedGet(SZGetter<T> getter, T defaultValue) {
        try {
            return getter.get();
        }
        catch (SevenZipException e) {
            return defaultValue;
        }
    }

    private IOException unwrapSZException(SevenZipException e) {
        SevenZipException tmp;
        for (tmp = e; tmp != null && tmp.getCause() instanceof SevenZipException; tmp = (SevenZipException)tmp.getCause()) {
        }
        return tmp != null && tmp.getCause() instanceof IOException ? (IOException)tmp.getCause() : new IOException(e);
    }

    private class TestPasswordsCallback
    implements IArchiveExtractCallback,
    ICryptoGetTextPassword {
        private int currentIndex;
        private String currentPassword;
        private List<Integer> successFileIndexes = new ArrayList<Integer>();
        private TaskMonitor monitor;

        TestPasswordsCallback(String currentPassword, int initialIndex, TaskMonitor monitor) {
            this.currentPassword = currentPassword;
            this.currentIndex = initialIndex;
            this.monitor = monitor;
        }

        List<Integer> getSuccessFileIndexes() {
            return this.successFileIndexes;
        }

        public ISequentialOutStream getStream(int index, ExtractAskMode extractAskMode) throws SevenZipException {
            this.currentIndex = index;
            ISimpleInArchiveItem item = SevenZipFileSystem.this.items[this.currentIndex];
            this.monitor.setMessage("Testing password for " + item.getPath());
            return null;
        }

        public void prepareOperation(ExtractAskMode extractAskMode) throws SevenZipException {
        }

        public String cryptoGetTextPassword() throws SevenZipException {
            return this.currentPassword;
        }

        public void setOperationResult(ExtractOperationResult extractOperationResult) throws SevenZipException {
            ISimpleInArchiveItem item = SevenZipFileSystem.this.items[this.currentIndex];
            if (item.isEncrypted() && extractOperationResult == ExtractOperationResult.OK && !SevenZipFileSystem.this.passwords.containsKey(this.currentIndex)) {
                this.successFileIndexes.add(this.currentIndex);
            }
            ++this.currentIndex;
        }

        public void setTotal(long total) throws SevenZipException {
            this.monitor.initialize(total);
        }

        public void setCompleted(long complete) throws SevenZipException {
            this.monitor.setProgress(complete);
        }
    }

    static interface SZGetter<T> {
        public T get() throws SevenZipException;
    }

    private class SZExtractCallback
    implements IArchiveExtractCallback,
    ISequentialOutStream,
    ICryptoGetTextPassword,
    Closeable {
        private TaskMonitor monitor;
        private int currentIndex;
        private ISimpleInArchiveItem currentItem;
        private String currentName = "unknown";
        private FileCache.FileCacheEntryBuilder currentCacheEntryBuilder;
        private boolean saveResults;
        private Map<Integer, FileCache.FileCacheEntry> extractResults = new HashMap<Integer, FileCache.FileCacheEntry>();

        public SZExtractCallback(TaskMonitor monitor, int initalIndex, boolean saveResults) {
            this.monitor = monitor;
            this.currentIndex = initalIndex;
            this.saveResults = saveResults;
        }

        FileCache.FileCacheEntry getExtractResult(int itemIndex) {
            return this.extractResults.get(itemIndex);
        }

        @Override
        public void close() throws IOException {
            if (this.currentCacheEntryBuilder != null) {
                this.currentCacheEntryBuilder.close();
            }
        }

        public ISequentialOutStream getStream(int index, ExtractAskMode extractAskMode) throws SevenZipException {
            this.currentIndex = index;
            this.currentItem = SevenZipFileSystem.this.items[this.currentIndex];
            this.currentName = this.currentItem.getPath();
            if (this.currentItem.isFolder() || extractAskMode != ExtractAskMode.EXTRACT) {
                return null;
            }
            if (this.currentItem.isEncrypted() && !SevenZipFileSystem.this.passwords.containsKey(this.currentIndex)) {
                Msg.debug((Object)((Object)SevenZipFileSystem.this), (Object)"No password for file[%d] %s of %s, unable to extract.".formatted(this.currentIndex, this.currentName, SevenZipFileSystem.this.fsFSRL.getContainer().getName()));
                return null;
            }
            return this;
        }

        public void prepareOperation(ExtractAskMode extractAskMode) throws SevenZipException {
            if (!this.currentItem.isFolder() && extractAskMode == ExtractAskMode.EXTRACT) {
                try {
                    long size = Objects.requireNonNullElse(this.currentItem.getSize(), -1L);
                    this.currentCacheEntryBuilder = SevenZipFileSystem.this.fsService.createTempFile(size);
                    this.monitor.initialize(size, "Extracting " + this.currentName);
                }
                catch (IOException e) {
                    throw new SevenZipException((Throwable)e);
                }
            }
        }

        public String cryptoGetTextPassword() throws SevenZipException {
            String password = SevenZipFileSystem.this.passwords.get(this.currentIndex);
            if (password == null) {
                Msg.debug((Object)((Object)SevenZipFileSystem.this), (Object)"No password for file[%d] %s of %s".formatted(this.currentIndex, this.currentName, SevenZipFileSystem.this.fsFSRL.getContainer().getName()));
                password = "";
            }
            return password;
        }

        public int write(byte[] data) throws SevenZipException {
            if (this.currentCacheEntryBuilder == null) {
                throw new SevenZipException("Bad Sevenzip Extract Callback state, %d, %s".formatted(this.currentIndex, this.currentName));
            }
            try {
                this.currentCacheEntryBuilder.write(data);
                this.monitor.incrementProgress((long)data.length);
                return data.length;
            }
            catch (IOException e) {
                throw new SevenZipException((Throwable)e);
            }
        }

        public void setOperationResult(ExtractOperationResult extractOperationResult) throws SevenZipException {
            if (this.currentCacheEntryBuilder == null) {
                return;
            }
            try {
                FileCache.FileCacheEntry fce = this.currentCacheEntryBuilder.finish();
                if (extractOperationResult == ExtractOperationResult.OK) {
                    GFile gFile = SevenZipFileSystem.this.fsIndex.getFileByIndex((long)this.currentIndex);
                    if (gFile != null && gFile.getFSRL().getMD5() == null) {
                        SevenZipFileSystem.this.fsIndex.updateFSRL(gFile, gFile.getFSRL().withMD5(fce.getMD5()));
                    }
                    if (this.saveResults) {
                        this.extractResults.put(this.currentIndex, fce);
                    }
                    Msg.debug((Object)((Object)SevenZipFileSystem.this), (Object)("Wrote file to cache: " + String.valueOf(gFile) + ", " + FSUtilities.formatSize((Long)fce.length())));
                } else {
                    Msg.warn((Object)((Object)SevenZipFileSystem.this), (Object)"Failed to push file[%d] %s to cache: %s".formatted(this.currentIndex, this.currentName, extractOperationResult));
                    this.extractOperationResultToException(extractOperationResult);
                }
            }
            catch (IOException e) {
                throw new SevenZipException((Throwable)e);
            }
            finally {
                FSUtilities.uncheckedClose((AutoCloseable)this.currentCacheEntryBuilder, null);
                this.currentCacheEntryBuilder = null;
                ++this.currentIndex;
            }
        }

        public void setTotal(long total) throws SevenZipException {
        }

        public void setCompleted(long complete) throws SevenZipException {
        }

        private void extractOperationResultToException(ExtractOperationResult operationResult) throws IOException {
            if (operationResult == null) {
                throw new IOException("7-Zip returned null operation result");
            }
            switch (operationResult) {
                case CRCERROR: {
                    throw new IOException("7-Zip returned CRC error");
                }
                case DATAERROR: {
                    throw new IOException("7-Zip returned data error");
                }
                case UNSUPPORTEDMETHOD: {
                    throw new IOException("Unexpected: 7-Zip returned unsupported method");
                }
                case UNKNOWN_OPERATION_RESULT: {
                    throw new IOException("Unexpected: 7-Zip returned unknown operation result");
                }
                case WRONG_PASSWORD: {
                    throw new IOException("7-Zip wrong password");
                }
                default: {
                    throw new IOException("7-Zip unknown error " + String.valueOf(operationResult));
                }
                case OK: 
            }
        }
    }
}

