/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import ghidra.app.plugin.core.debug.disassemble.DisassemblyInject;
import ghidra.app.plugin.core.debug.disassemble.TraceDisassembleCommand;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOpinion;
import ghidra.debug.api.platform.DebuggerPlatformMapper;
import ghidra.debug.api.platform.DisassemblyResult;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Endian;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.listing.TraceInstruction;
import ghidra.trace.model.memory.TraceMemoryOperations;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;

public abstract class AbstractDebuggerPlatformMapper
implements DebuggerPlatformMapper {
    protected final PluginTool tool;
    protected final Trace trace;

    public AbstractDebuggerPlatformMapper(PluginTool tool, Trace trace) {
        this.tool = tool;
        this.trace = trace;
    }

    protected boolean canInterpret(TraceObject newFocus, long snap, TraceObject env, String debugger, String arch, String os, Endian endian) {
        return true;
    }

    public boolean canInterpret(TraceObject newFocus, long snap) {
        TraceObject env = DebuggerPlatformOpinion.getEnvironment(newFocus, snap);
        if (env == null) {
            return this.canInterpret(newFocus, snap, env, null, null, null, null);
        }
        String debugger = DebuggerPlatformOpinion.getDebugggerFromEnv(env, snap);
        String arch = DebuggerPlatformOpinion.getArchitectureFromEnv(env, snap);
        String os = DebuggerPlatformOpinion.getOperatingSystemFromEnv(env, snap);
        Endian endian = DebuggerPlatformOpinion.getEndianFromEnv(env, snap);
        return this.canInterpret(newFocus, snap, env, debugger, arch, os, endian);
    }

    protected boolean isCancelSilently(Address start, long snap) {
        TraceInstruction exists = (TraceInstruction)this.trace.getCodeManager().instructions().getAt(snap, start);
        if (exists == null) {
            return false;
        }
        Collection states = this.trace.getMemoryManager().getStates(snap, exists.getRange());
        return TraceMemoryOperations.isStateEntirely((AddressRange)exists.getRange(), (Collection)states, (TraceMemoryState)TraceMemoryState.KNOWN);
    }

    protected TracePlatform getDisassemblyPlatform(TraceObject object, Address start, long snap) {
        return this.trace.getPlatformManager().getPlatform(this.getCompilerSpec(object, snap));
    }

    protected Collection<DisassemblyInject> getDisassemblyInjections(TracePlatform platform) {
        return ClassSearcher.getInstances(DisassemblyInject.class).stream().filter(i -> i.isApplicable(platform)).sorted(Comparator.comparing(i -> i.getPriority())).collect(Collectors.toList());
    }

    public DisassemblyResult disassemble(TraceThread thread, TraceObject object, Address start, AddressSetView restricted, long snap, TaskMonitor monitor) {
        if (this.isCancelSilently(start, snap)) {
            return DisassemblyResult.CANCELLED;
        }
        TracePlatform platform = this.getDisassemblyPlatform(object, start, snap);
        Collection<DisassemblyInject> injects = this.getDisassemblyInjections(platform);
        TraceDisassembleCommand dis = new TraceDisassembleCommand(platform, start, restricted);
        AddressSet startSet = new AddressSet(start);
        for (DisassemblyInject i : injects) {
            i.pre(this.tool, dis, platform, snap, thread, (AddressSetView)startSet, restricted);
        }
        boolean result = dis.applyTo(this.trace.getFixedProgramView(snap), monitor);
        if (!result) {
            return DisassemblyResult.failed((String)dis.getStatusMsg());
        }
        AddressSetView actualSet = dis.getDisassembledAddressSet();
        for (DisassemblyInject i : injects) {
            i.post(this.tool, platform, snap, actualSet);
        }
        return DisassemblyResult.success((actualSet != null && !actualSet.isEmpty() ? 1 : 0) != 0);
    }
}

