/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.AbstractElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.RISCV_ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.RISCV_ElfRelocationType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import java.util.Map;

public class RISCV_ElfRelocationHandler
extends AbstractElfRelocationHandler<RISCV_ElfRelocationType, RISCV_ElfRelocationContext> {
    public RISCV_ElfRelocationHandler() {
        super(RISCV_ElfRelocationType.class);
    }

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 243;
    }

    public RISCV_ElfRelocationContext createRelocationContext(ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        return new RISCV_ElfRelocationContext(this, loadHelper, symbolMap);
    }

    public int getRelrRelocationType() {
        return RISCV_ElfRelocationType.R_RISCV_RELATIVE.typeId;
    }

    static int getHi20(int target) {
        int target_h = target & 0xFFFFF000;
        if ((target & 0x800) == 2048) {
            target_h += 4096;
        }
        return target_h;
    }

    static int getLo12(int target) {
        return target & 0xFFF;
    }

    private static int getSymbolValueIndirect(RISCV_ElfRelocationContext elfRelocationContext, ElfSymbol hi20Symbol, long relocAddrOffsetAdj) {
        ElfRelocation hi20Reloc = elfRelocationContext.getHi20Relocation(hi20Symbol);
        if (hi20Reloc == null) {
            return 0;
        }
        int symIndex = hi20Reloc.getSymbolIndex();
        ElfSymbol sym = elfRelocationContext.getSymbol(symIndex);
        long symOffset = elfRelocationContext.getSymbolValue(sym);
        long targetOffset = symOffset + hi20Reloc.getAddend();
        long hi20RelocOffset = hi20Reloc.getOffset() + relocAddrOffsetAdj;
        return (int)(targetOffset - hi20RelocOffset);
    }

    protected RelocationResult relocate(RISCV_ElfRelocationContext elfRelocationContext, ElfRelocation relocation, RISCV_ElfRelocationType type, Address relocationAddress, ElfSymbol sym, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        if (!relocation.hasAddend()) {
            return RelocationResult.UNSUPPORTED;
        }
        ElfHeader elf = elfRelocationContext.getElfHeader();
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        long addend = relocation.getAddend();
        long offset = relocationAddress.getOffset();
        long base = elfRelocationContext.getImageBaseWordAdjustmentOffset();
        int symbolIndex = relocation.getSymbolIndex();
        long value64 = 0L;
        int value32 = 0;
        short value16 = 0;
        byte value8 = 0;
        int target = 0;
        int byteLength = 4;
        switch (type) {
            case R_RISCV_RELATIVE: {
                if (elf.is32Bit()) {
                    value32 = (int)(base + addend);
                    memory.setInt(relocationAddress, value32);
                } else {
                    value64 = base + addend;
                    memory.setLong(relocationAddress, value64);
                    byteLength = 8;
                }
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
            case R_RISCV_PCREL_LO12_S: {
                target = RISCV_ElfRelocationHandler.getSymbolValueIndirect(elfRelocationContext, sym, relocationAddress.getOffset() - relocation.getOffset());
                if (target == 0) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed to locate HI20 relocation", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                value32 = (target & 0x7F) << 25 | target & 0xF80 | memory.getInt(relocationAddress) & 0x1FFF07F;
                memory.setInt(relocationAddress, value32);
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
            case R_RISCV_PCREL_LO12_I: {
                target = RISCV_ElfRelocationHandler.getSymbolValueIndirect(elfRelocationContext, sym, relocationAddress.getOffset() - relocation.getOffset());
                if (target == 0) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed to locate HI20 relocation", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                value32 = (target & 0xFFF) << 20 | memory.getInt(relocationAddress) & 0xFFFFF;
                memory.setInt(relocationAddress, value32);
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
            case R_RISCV_COPY: {
                this.markAsUnsupportedCopy(program, relocationAddress, type, symbolName, symbolIndex, sym.getSize(), elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        if (this.handleUnresolvedSymbol(elfRelocationContext, relocation, relocationAddress)) {
            return RelocationResult.FAILURE;
        }
        switch (type) {
            case R_RISCV_32: {
                value32 = (int)(symbolValue + addend);
                memory.setInt(relocationAddress, value32);
                if (symbolIndex == 0 || addend == 0L || sym.isSection()) break;
                RISCV_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                if (!elf.is32Bit()) break;
                RISCV_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case R_RISCV_64: {
                value64 = symbolValue + addend;
                memory.setLong(relocationAddress, value64);
                byteLength = 8;
                if (symbolIndex == 0 || addend == 0L || sym.isSection()) break;
                RISCV_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                if (!elf.is64Bit()) break;
                RISCV_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case R_RISCV_JUMP_SLOT: {
                if (elf.is32Bit()) {
                    value32 = (int)symbolValue;
                    memory.setInt(relocationAddress, value32);
                    break;
                }
                value64 = symbolValue;
                memory.setLong(relocationAddress, value64);
                byteLength = 8;
                break;
            }
            case R_RISCV_BRANCH: {
                target = (int)(addend + symbolValue - offset);
                value32 = RISCV_ElfRelocationHandler.encodeSBTypeImm(target) | memory.getInt(relocationAddress) & ~RISCV_ElfRelocationHandler.encodeSBTypeImm(-1);
                memory.setInt(relocationAddress, value32);
                break;
            }
            case R_RISCV_JAL: {
                target = (int)(addend + symbolValue - offset);
                value32 = RISCV_ElfRelocationHandler.encodeUJTypeImm(target) | memory.getInt(relocationAddress) & ~RISCV_ElfRelocationHandler.encodeUJTypeImm(-1);
                memory.setInt(relocationAddress, value32);
                break;
            }
            case R_RISCV_CALL: 
            case R_RISCV_CALL_PLT: {
                target = (int)(addend + symbolValue - offset);
                memory.setInt(relocationAddress, RISCV_ElfRelocationHandler.getHi20(target) | memory.getInt(relocationAddress) & 0xFFF);
                memory.setInt(relocationAddress.add(4L), RISCV_ElfRelocationHandler.getLo12(target) << 20 | memory.getInt(relocationAddress.add(4L)) & 0xFFFFF);
                byteLength = 8;
                break;
            }
            case R_RISCV_GOT_HI20: 
            case R_RISCV_PCREL_HI20: {
                target = (int)(addend + symbolValue - offset);
                memory.setInt(relocationAddress, RISCV_ElfRelocationHandler.getHi20(target) | memory.getInt(relocationAddress) & 0xFFF);
                break;
            }
            case R_RISCV_HI20: {
                value32 = (int)(addend + symbolValue + 2048L & 0xFFFFFFFFFFFFF000L) | memory.getInt(relocationAddress) & 0xFFF;
                memory.setInt(relocationAddress, value32);
                break;
            }
            case R_RISCV_LO12_I: {
                value32 = (int)(addend + symbolValue & 0xFFFL) << 20 | memory.getInt(relocationAddress) & 0xFFFFF;
                memory.setInt(relocationAddress, value32);
                break;
            }
            case R_RISCV_LO12_S: {
                value32 = (int)(addend + symbolValue & 0xFFFL);
                value32 = (value32 & 0x1F) << 7 | (value32 & 0xFE0) << 20 | memory.getInt(relocationAddress) & 0x1FFF07F;
                memory.setInt(relocationAddress, value32);
                break;
            }
            case R_RISCV_ADD8: {
                value8 = memory.getByte(relocationAddress);
                value8 = (byte)(value8 + (byte)(symbolValue + addend));
                memory.setByte(relocationAddress, value8);
                byteLength = 1;
                break;
            }
            case R_RISCV_ADD16: {
                value16 = memory.getShort(relocationAddress);
                value16 = (short)(value16 + (short)(symbolValue + addend));
                memory.setShort(relocationAddress, value16);
                byteLength = 2;
                break;
            }
            case R_RISCV_ADD32: {
                value32 = memory.getInt(relocationAddress);
                memory.setInt(relocationAddress, value32 += (int)(symbolValue + addend));
                break;
            }
            case R_RISCV_ADD64: {
                value64 = memory.getLong(relocationAddress);
                memory.setLong(relocationAddress, value64 += symbolValue + addend);
                byteLength = 8;
                break;
            }
            case R_RISCV_SUB8: {
                value8 = memory.getByte(relocationAddress);
                value8 = (byte)(value8 - (byte)(symbolValue + addend));
                memory.setByte(relocationAddress, value8);
                byteLength = 1;
                break;
            }
            case R_RISCV_SUB16: {
                value16 = memory.getShort(relocationAddress);
                value16 = (short)(value16 - (short)(symbolValue + addend));
                memory.setShort(relocationAddress, value16);
                byteLength = 2;
                break;
            }
            case R_RISCV_SUB32: {
                value32 = memory.getInt(relocationAddress);
                memory.setInt(relocationAddress, value32 -= (int)(symbolValue + addend));
                break;
            }
            case R_RISCV_SUB64: {
                value64 = memory.getLong(relocationAddress);
                memory.setLong(relocationAddress, value64 -= symbolValue + addend);
                byteLength = 8;
                break;
            }
            case R_RISCV_RVC_BRANCH: {
                short target_s = (short)(addend + symbolValue - offset);
                value16 = (short)(RISCV_ElfRelocationHandler.encodeCBTypeImm(target_s) | memory.getShort(relocationAddress) & ~RISCV_ElfRelocationHandler.encodeCBTypeImm(-1));
                memory.setShort(relocationAddress, value16);
                byteLength = 2;
                break;
            }
            case R_RISCV_RVC_JUMP: {
                short target_s = (short)(addend + symbolValue - offset);
                value16 = (short)(RISCV_ElfRelocationHandler.encodeCJTypeImm(target_s) | memory.getShort(relocationAddress) & ~RISCV_ElfRelocationHandler.encodeCJTypeImm(-1));
                memory.setShort(relocationAddress, value16);
                byteLength = 2;
                break;
            }
            case R_RISCV_RELAX: {
                return RelocationResult.SKIPPED;
            }
            case R_RISCV_SUB6: {
                byte loc8 = memory.getByte(relocationAddress);
                value8 = (byte)(symbolValue + addend);
                value8 = (byte)(loc8 & 0xC0 | (loc8 & 0x3F) - value8 & 0x3F);
                memory.setByte(relocationAddress, value8);
                byteLength = 1;
                break;
            }
            case R_RISCV_SET6: {
                byte loc8 = memory.getByte(relocationAddress);
                value8 = (byte)(symbolValue + addend);
                value8 = (byte)(loc8 & 0xC0 | value8 & 0x3F);
                memory.setByte(relocationAddress, value8);
                byteLength = 1;
                break;
            }
            case R_RISCV_SET8: {
                value8 = (byte)(symbolValue + addend);
                memory.setByte(relocationAddress, value8);
                byteLength = 1;
                break;
            }
            case R_RISCV_SET16: {
                value16 = (short)(symbolValue + addend);
                memory.setShort(relocationAddress, (short)value8);
                byteLength = 2;
                break;
            }
            case R_RISCV_32_PCREL: 
            case R_RISCV_SET32: {
                value32 = (int)(symbolValue + addend);
                memory.setInt(relocationAddress, (int)value8);
                break;
            }
            default: {
                this.markAsUnhandled(program, relocationAddress, type, symbolIndex, symbolName, elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }

    private static int getBitField(int val, int shiftRight, int bitSize) {
        return val >> shiftRight & (1 << bitSize) - 1;
    }

    private static int encodeSBTypeImm(int val) {
        return RISCV_ElfRelocationHandler.getBitField(val, 1, 4) << 8 | RISCV_ElfRelocationHandler.getBitField(val, 5, 6) << 25 | RISCV_ElfRelocationHandler.getBitField(val, 11, 1) << 7 | RISCV_ElfRelocationHandler.getBitField(val, 12, 1) << 31;
    }

    private static int encodeUJTypeImm(int val) {
        return RISCV_ElfRelocationHandler.getBitField(val, 1, 10) << 21 | RISCV_ElfRelocationHandler.getBitField(val, 11, 1) << 20 | RISCV_ElfRelocationHandler.getBitField(val, 12, 8) << 12 | RISCV_ElfRelocationHandler.getBitField(val, 20, 1) << 31;
    }

    private static int encodeCBTypeImm(int val) {
        return RISCV_ElfRelocationHandler.getBitField(val, 1, 2) << 3 | RISCV_ElfRelocationHandler.getBitField(val, 3, 2) << 10 | RISCV_ElfRelocationHandler.getBitField(val, 5, 1) << 2 | RISCV_ElfRelocationHandler.getBitField(val, 6, 2) << 5 | RISCV_ElfRelocationHandler.getBitField(val, 8, 1) << 12;
    }

    private static int encodeCJTypeImm(int val) {
        return RISCV_ElfRelocationHandler.getBitField(val, 1, 3) << 3 | RISCV_ElfRelocationHandler.getBitField(val, 4, 1) << 11 | RISCV_ElfRelocationHandler.getBitField(val, 5, 1) << 2 | RISCV_ElfRelocationHandler.getBitField(val, 6, 1) << 7 | RISCV_ElfRelocationHandler.getBitField(val, 7, 1) << 6 | RISCV_ElfRelocationHandler.getBitField(val, 8, 2) << 9 | RISCV_ElfRelocationHandler.getBitField(val, 10, 1) << 8 | RISCV_ElfRelocationHandler.getBitField(val, 11, 1) << 12;
    }
}

