/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.plugin;

import docking.action.DockingActionIf;
import docking.wizard.WizardDialog;
import docking.wizard.WizardModel;
import generic.theme.GIcon;
import ghidra.app.plugin.core.codebrowser.CodeBrowserPlugin;
import ghidra.app.plugin.core.colorizer.ColorizingService;
import ghidra.app.util.viewer.options.ListingDisplayOptionsEditor;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.actions.AddToVersionTrackingSessionAction;
import ghidra.feature.vt.gui.actions.AutoVersionTrackingAction;
import ghidra.feature.vt.gui.actions.CloseVersionTrackingSessionAction;
import ghidra.feature.vt.gui.actions.CreateVersionTrackingSessionAction;
import ghidra.feature.vt.gui.actions.HelpAction;
import ghidra.feature.vt.gui.actions.OpenVersionTrackingSessionAction;
import ghidra.feature.vt.gui.actions.RedoAction;
import ghidra.feature.vt.gui.actions.ResetToolAction;
import ghidra.feature.vt.gui.actions.SaveVersionTrackingSessionAction;
import ghidra.feature.vt.gui.actions.UndoAction;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTControllerImpl;
import ghidra.feature.vt.gui.plugin.VTSubToolManager;
import ghidra.feature.vt.gui.provider.functionassociation.VTFunctionAssociationProvider;
import ghidra.feature.vt.gui.provider.impliedmatches.ImpliedMatchAssociationHook;
import ghidra.feature.vt.gui.provider.impliedmatches.MatchStatusUpdaterAssociationHook;
import ghidra.feature.vt.gui.provider.impliedmatches.VTImpliedMatchesTableProvider;
import ghidra.feature.vt.gui.provider.markuptable.VTMarkupItemsTableProvider;
import ghidra.feature.vt.gui.provider.matchtable.VTMatchTableProvider;
import ghidra.feature.vt.gui.wizard.session.VTNewSessionWizardModel;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsEditor;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.preferences.Preferences;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import help.Help;
import help.HelpService;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JFrame;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.HIDDEN, packageName="Version Tracking", category="Version Tracking", shortDescription="Version Tracking", description="This plugin provides the Version Tracking Feature.", servicesProvided={VTController.class})
public class VTPlugin
extends Plugin {
    public static final String WINDOW_GROUP = "VTResults";
    public static final String HELP_TOPIC_NAME = "VersionTrackingPlugin";
    private static final String SHOW_HELP_PREFERENCE = "VersionTrackingShowHelp";
    public static String OWNER;
    public static final String MATCH_POPUP_MENU_NAME = "Version Tracking Match";
    public static final String MARKUP_POPUP_MENU_NAME = "Version Tracking Markup";
    public static final String VT_MAIN_MENU_GROUP = "AAA_VT_Main";
    public static final String ADDRESS_EDIT_MENU_GROUP = "A_VT_X_AddressEdit";
    public static final String APPLY_EDIT_MENU_GROUP = "A_VT_Apply_Edit";
    public static final String EDIT_MENU_GROUP = "A_VT_Edit_1";
    public static final String TAG_MENU_GROUP = "A_VT_Edit_2";
    public static final String UNEDIT_MENU_GROUP = "A_VT_UnEdit";
    public static final String VT_SETTINGS_MENU_GROUP = "ZZ_VT_SETTINGS";
    public static final Icon UNFILTERED_ICON;
    public static final Icon FILTERED_ICON;
    public static final Icon REPLACED_ICON;
    private VTController controller;
    private Set<String> additionalPluginNames = new HashSet<String>(Set.of("ghidra.features.codecompare.plugin.FunctionComparisonPlugin"));
    private VTMatchTableProvider matchesProvider;
    private VTMarkupItemsTableProvider markupProvider;
    private VTSubToolManager toolManager;
    private VTImpliedMatchesTableProvider impliedMatchesTable;
    private VTFunctionAssociationProvider functionAssociationProvider;

    public VTPlugin(PluginTool tool) {
        super(tool);
        tool.setUnconfigurable();
        OWNER = this.getName();
        this.controller = new VTControllerImpl(this);
        this.registerServiceProvided(VTController.class, this.controller);
        this.toolManager = new VTSubToolManager(this);
        this.createActions();
        DockingActionIf saveAs = this.getToolAction("Save Tool As");
        tool.removeAction(saveAs);
        DockingActionIf export = this.getToolAction("Export Tool");
        tool.removeAction(export);
        this.initializeOptions();
    }

    private DockingActionIf getToolAction(String actionName) {
        Set actions = this.tool.getDockingActionsByOwnerName("Tool");
        for (DockingActionIf action : actions) {
            if (!action.getName().equals(actionName)) continue;
            return action;
        }
        throw new IllegalArgumentException("Unable to find Tool action '" + actionName + "'");
    }

    private void initializeOptions() {
        ToolOptions options = this.tool.getOptions("Listing Display");
        options.registerOptionsEditor(() -> VTPlugin.lambda$initializeOptions$0((Options)options));
        options.setOptionsHelpLocation(new HelpLocation(CodeBrowserPlugin.class.getSimpleName(), "Listing Display"));
    }

    protected void init() {
        this.removeUnwantedPlugins();
        this.addCustomPlugins();
        this.matchesProvider = new VTMatchTableProvider(this.controller);
        this.markupProvider = new VTMarkupItemsTableProvider(this.controller);
        this.impliedMatchesTable = new VTImpliedMatchesTableProvider(this.controller);
        this.functionAssociationProvider = new VTFunctionAssociationProvider(this.controller);
        new MatchStatusUpdaterAssociationHook(this.controller);
        new ImpliedMatchAssociationHook(this.controller);
        this.maybeShowHelp();
    }

    private void removeUnwantedPlugins() {
        List allPlugins = this.tool.getManagedPlugins();
        ArrayList toRemove = new ArrayList(allPlugins);
        toRemove.remove((Object)this);
        this.tool.removePlugins(toRemove);
    }

    private void addCustomPlugins() {
        List plugins = this.tool.getManagedPlugins();
        HashSet existingNames = new HashSet(plugins.stream().map(c -> c.getName()).collect(Collectors.toSet()));
        try {
            for (String className : this.additionalPluginNames) {
                if (existingNames.contains(className)) continue;
                this.tool.addPlugin(className);
            }
        }
        catch (PluginException e) {
            Msg.error((Object)((Object)this), (Object)"Unable to load plugin", (Throwable)e);
        }
    }

    private void maybeShowHelp() {
        if (SystemUtilities.isInDevelopmentMode() || SystemUtilities.isInTestingMode()) {
            return;
        }
        HelpService help = Help.getHelpService();
        String preference = Preferences.getProperty((String)SHOW_HELP_PREFERENCE);
        if (preference != null) {
            return;
        }
        Preferences.setProperty((String)SHOW_HELP_PREFERENCE, (String)"No");
        Preferences.store();
        URL url = ResourceManager.getResource((String)"help/topics/VersionTrackingPlugin/VT_Workflow.html");
        if (url == null) {
            Msg.showError((Object)((Object)this), null, (String)"Help Not Found", (Object)"Unable to find the Version Tracking workflow help");
            return;
        }
        help.showHelp(url);
    }

    private void createActions() {
        this.tool.addAction((DockingActionIf)new CreateVersionTrackingSessionAction(this.controller));
        this.tool.addAction((DockingActionIf)new OpenVersionTrackingSessionAction(this.controller));
        this.tool.addAction((DockingActionIf)new AddToVersionTrackingSessionAction(this.controller));
        this.tool.addAction((DockingActionIf)new CloseVersionTrackingSessionAction(this.controller));
        this.tool.addAction((DockingActionIf)new SaveVersionTrackingSessionAction(this.controller));
        this.tool.addAction((DockingActionIf)new UndoAction(this.controller));
        this.tool.addAction((DockingActionIf)new RedoAction(this.controller));
        this.tool.addAction((DockingActionIf)new ResetToolAction(this.controller, this.toolManager));
        this.tool.addAction((DockingActionIf)new HelpAction());
        this.tool.addAction((DockingActionIf)new AutoVersionTrackingAction(this.controller));
    }

    protected void close() {
        this.controller.closeCurrentSessionIgnoringChanges();
        this.matchesProvider.setVisible(false);
        this.markupProvider.setVisible(false);
        this.impliedMatchesTable.setVisible(false);
        this.functionAssociationProvider.setVisible(false);
        super.close();
    }

    protected void dispose() {
        this.controller.dispose();
        super.dispose();
    }

    public Class<?>[] getSupportedDataTypes() {
        return new Class[]{VTSession.class, Program.class};
    }

    public boolean acceptData(DomainFile[] data) {
        if (data == null || data.length == 0) {
            return false;
        }
        for (DomainFile domainFile : data) {
            if (domainFile == null || !VTSession.class.isAssignableFrom(domainFile.getDomainObjectClass())) continue;
            return this.controller.openVersionTrackingSession(domainFile);
        }
        DomainFile programFile1 = null;
        DomainFile programFile2 = null;
        for (DomainFile domainFile : data) {
            if (domainFile == null || !Program.class.isAssignableFrom(domainFile.getDomainObjectClass())) continue;
            if (programFile1 == null) {
                programFile1 = domainFile;
                continue;
            }
            if (programFile2 != null) continue;
            programFile2 = domainFile;
        }
        if (programFile1 != null) {
            if (!this.controller.closeVersionTrackingSession()) {
                return false;
            }
            VTNewSessionWizardModel model = new VTNewSessionWizardModel(this.controller, programFile1, programFile2);
            WizardDialog wizardDialog = new WizardDialog((WizardModel)model);
            wizardDialog.show((Component)this.tool.getToolFrame());
            return true;
        }
        return false;
    }

    public void readConfigState(SaveState saveState) {
        this.controller.readConfigState(saveState);
        this.matchesProvider.readConfigState(saveState);
        this.markupProvider.readConfigState(saveState);
        this.impliedMatchesTable.readConfigState(saveState);
        this.functionAssociationProvider.readConfigState(saveState);
    }

    public void writeConfigState(SaveState saveState) {
        this.controller.writeConfigState(saveState);
        this.matchesProvider.writeConfigState(saveState);
        this.markupProvider.writeConfigState(saveState);
        this.impliedMatchesTable.writeConfigState(saveState);
        this.functionAssociationProvider.writeConfigState(saveState);
    }

    public void readDataState(SaveState saveState) {
        String pathname = saveState.getString("PATHNAME", null);
        if (pathname == null) {
            return;
        }
        Project project = this.tool.getProject();
        if (project == null) {
            return;
        }
        ProjectData projectData = project.getProjectData();
        DomainFile domainFile = projectData.getFile(pathname);
        if (domainFile == null) {
            return;
        }
        this.controller.openVersionTrackingSession(domainFile);
    }

    public void writeDataState(SaveState saveState) {
        VTSessionDB session = (VTSessionDB)this.controller.getSession();
        if (session == null) {
            return;
        }
        DomainFile domainFile = session.getDomainFile();
        saveState.putString("PATHNAME", domainFile.getPathname());
    }

    protected boolean saveData() {
        return this.controller.checkForUnSavedChanges();
    }

    protected boolean canClose() {
        PluginTool sourceTool = this.toolManager.getSourceTool();
        PluginTool destinationTool = this.toolManager.getDestinationTool();
        if (this.toolManager.isToolExecutingCommand(sourceTool)) {
            VTPlugin.showBusyToolMessage(sourceTool);
            return false;
        }
        if (this.toolManager.isToolExecutingCommand(destinationTool)) {
            VTPlugin.showBusyToolMessage(destinationTool);
            return false;
        }
        return true;
    }

    public AddressSetView getSelectionInSourceTool() {
        return this.toolManager.getSelectionInSourceTool();
    }

    public AddressSetView getSelectionInDestinationTool() {
        return this.toolManager.getSelectionInDestinationTool();
    }

    public void setSelectionInDestinationTool(AddressSetView destinationSet) {
        this.toolManager.setSelectionInDestinationTool(destinationSet);
    }

    public void setSelectionInSourceTool(AddressSetView sourceSet) {
        this.toolManager.setSelectionInSourceTool(sourceSet);
    }

    public List<DomainFile> getChangedProgramsInSourceTool() {
        return this.toolManager.getChangedProgramsInSourceTool();
    }

    public List<DomainFile> getChangedProgramsInDestinationTool() {
        return this.toolManager.getChangedProgramsInDestinationTool();
    }

    public void gotoSourceLocation(ProgramLocation location) {
        this.toolManager.gotoSourceLocation(location);
    }

    public void gotoDestinationLocation(ProgramLocation location) {
        this.toolManager.gotoDestinationLocation(location);
    }

    public void updateUndoActions() {
        this.tool.contextChanged(null);
    }

    public VTController getController() {
        return this.controller;
    }

    public VTSubToolManager getToolManager() {
        return this.toolManager;
    }

    public VTMatchTableProvider getMatchesProvider() {
        return this.matchesProvider;
    }

    public ColorizingService getSourceColorizingService() {
        return this.toolManager.getSourceColorizingService();
    }

    public ColorizingService getDestinationColorizingService() {
        return this.toolManager.getDestinationColorizingService();
    }

    static void showBusyToolMessage(PluginTool tool) {
        JFrame toolFrame = tool.getToolFrame();
        tool.beep();
        Msg.showInfo(VTPlugin.class, (Component)toolFrame, (String)("Tool \"" + tool.getName() + "\" Busy"), (Object)"You must stop all background tasks before exiting.");
    }

    private static /* synthetic */ OptionsEditor lambda$initializeOptions$0(Options options) {
        return new ListingDisplayOptionsEditor(options);
    }

    static {
        UNFILTERED_ICON = new GIcon("icon.version.tracking.unfiltered");
        FILTERED_ICON = new GIcon("icon.version.tracking.filtered");
        REPLACED_ICON = new GIcon("icon.version.tracking.replaced");
    }
}

