/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import ghidra.framework.data.LinkHandler;
import ghidra.framework.data.LinkedGhidraFolder;
import ghidra.framework.data.NullFolderDomainObject;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.LinkFileInfo;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.protocol.ghidra.GhidraURLResultHandler;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class GhidraURLQuery {
    private static final ThreadLocal<Set<URL>> linkedUrlSet = ThreadLocal.withInitial(() -> null);
    private final URL ghidraUrl;
    private final boolean readOnly;
    private final GhidraURLResultHandler resultHandler;
    private final LinkFileControl linkFileControl;
    private Class<? extends DomainObject> contentClass;
    private boolean cleanupUrlSetUponReturn = false;

    private GhidraURLQuery(URL ghidraUrl, Class<? extends DomainObject> contentClass, boolean readOnly, LinkFileControl linkFileControl, GhidraURLResultHandler resultHandler) {
        this.ghidraUrl = ghidraUrl;
        this.contentClass = contentClass;
        this.readOnly = readOnly;
        this.resultHandler = resultHandler;
        this.linkFileControl = linkFileControl;
    }

    public static void queryUrl(URL ghidraUrl, Class<? extends DomainObject> contentClass, GhidraURLResultHandler resultHandler, LinkFileControl linkFileControl, TaskMonitor monitor) throws IOException, CancelledException {
        GhidraURLQuery ghidraUrlQuery = new GhidraURLQuery(ghidraUrl, contentClass, true, linkFileControl, resultHandler);
        ghidraUrlQuery.query(monitor);
    }

    public static void queryRepositoryUrl(URL ghidraUrl, boolean readOnly, GhidraURLResultHandler resultHandler, LinkFileControl linkFileControl, TaskMonitor monitor) throws IOException, CancelledException {
        if (!GhidraURL.isServerRepositoryURL(ghidraUrl)) {
            throw new IllegalArgumentException("Unsupported repository URL: " + String.valueOf(ghidraUrl));
        }
        GhidraURLQuery ghidraUrlQuery = new GhidraURLQuery(ghidraUrl, NullFolderDomainObject.class, readOnly, linkFileControl, resultHandler);
        ghidraUrlQuery.query(monitor);
    }

    private void query(TaskMonitor monitor) throws IOException, CancelledException {
        try {
            this.doQuery(monitor);
        }
        finally {
            if (this.cleanupUrlSetUponReturn) {
                linkedUrlSet.set(null);
            }
            this.cleanupUrlSetUponReturn = false;
        }
    }

    /*
     * Exception decompiling
     */
    private void doQuery(TaskMonitor monitor) throws IOException, CancelledException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processContent(Object content, TaskMonitor monitor) throws IOException, CancelledException {
        if (content instanceof DomainFile) {
            DomainFile file = (DomainFile)content;
            if (!this.checkContentClass(file)) {
                return;
            }
            if (this.linkFileControl != LinkFileControl.NO_FOLLOW && file.isLink()) {
                if (this.contentClass == null) {
                    this.contentClass = file.getDomainObjectClass();
                }
                if ((file = this.followLink(file, monitor)) == null) {
                    return;
                }
                LinkFileInfo linkInfo = file.getLinkInfo();
                if (linkInfo != null && linkInfo.isFolderLink()) {
                    LinkedGhidraFolder folder = linkInfo.getLinkedFolder();
                    if (folder == null) {
                        this.resultHandler.handleError("Link Resolution Failed", "Unable to follow invalid folder-link", this.ghidraUrl, null);
                    } else {
                        this.resultHandler.processResult(folder, this.ghidraUrl, monitor);
                    }
                    return;
                }
            }
            this.resultHandler.processResult(file, this.ghidraUrl, monitor);
        } else if (content instanceof DomainFolder) {
            DomainFolder folder = (DomainFolder)content;
            if (this.contentClass != null && this.contentClass != NullFolderDomainObject.class) {
                URL url = folder.getLocalProjectURL();
                if (url == null) {
                    url = folder.getSharedProjectURL();
                }
                this.resultHandler.handleError("Unexpected Content", "Unexpected folder", url, null);
            } else {
                this.resultHandler.processResult(folder, this.ghidraUrl, monitor);
            }
        } else {
            this.resultHandler.handleError("Unsupported Content", "Content class: " + content.getClass().getName(), this.ghidraUrl, null);
        }
    }

    private boolean checkContentClass(DomainFile file) throws IOException {
        Class<? extends DomainObject> domainObjectClass = file.getDomainObjectClass();
        if (this.contentClass != null && !this.contentClass.isAssignableFrom(file.getDomainObjectClass())) {
            URL url = file.getLocalProjectURL(null);
            if (url == null) {
                url = file.getSharedProjectURL(null);
            }
            this.resultHandler.handleError("Unexpected Content", "File content is " + domainObjectClass.getSimpleName(), url, null);
            return false;
        }
        return true;
    }

    private DomainFile followLink(DomainFile file, TaskMonitor monitor) throws CancelledException, IOException {
        AtomicReference linkStatus = new AtomicReference();
        AtomicReference errMsg = new AtomicReference();
        file = LinkHandler.followInternalLinkage(file, s -> linkStatus.set(s), err -> errMsg.set(err));
        LinkHandler.LinkStatus s2 = (LinkHandler.LinkStatus)((Object)linkStatus.get());
        if (s2 == LinkHandler.LinkStatus.BROKEN) {
            String msg = (String)errMsg.get();
            if (msg == null) {
                msg = "Unable to follow broken link";
            }
            this.resultHandler.handleError("Link Resolution Failed", msg, this.ghidraUrl, null);
            return null;
        }
        if (s2 == LinkHandler.LinkStatus.EXTERNAL) {
            if (this.linkFileControl == LinkFileControl.FOLLOW_EXTERNAL) {
                URL linkURL = LinkHandler.getLinkURL(file);
                GhidraURLQuery.queryUrl(linkURL, this.contentClass, this.resultHandler, this.linkFileControl, monitor);
                return null;
            }
            this.resultHandler.externalLinkIgnored(this.ghidraUrl);
            return null;
        }
        return file;
    }

    public static enum LinkFileControl {
        NO_FOLLOW,
        FOLLOW_EXTERNAL,
        FOLLOW_INTERNAL;

    }
}

