/*
 * Decompiled with CFR 0.152.
 */
package docking.actions;

import docking.ActionContext;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import ghidra.framework.options.ActionTrigger;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.util.Msg;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.lang3.StringUtils;
import utilities.util.reflection.ReflectionUtilities;

public class SharedStubKeyBindingAction
extends DockingAction
implements OptionsChangeListener {
    static final String SHARED_OWNER = "Shared";
    private WeakHashMap<DockingActionIf, ActionTrigger> clientActions = new WeakHashMap();
    private ToolOptions keyBindingOptions;
    private Bag<String> actionOwners = new HashBag();

    SharedStubKeyBindingAction(String name, ActionTrigger defaultActionTrigger, ToolOptions options) {
        super(name, SHARED_OWNER, KeyBindingType.INDIVIDUAL);
        this.keyBindingOptions = options;
        DockingWindowManager.getHelpService().excludeFromHelp((Object)this);
        this.setKeyBindingData(this, defaultActionTrigger);
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    void addActionOwner(String owner) {
        if ("DockingWindows".equals(owner)) {
            return;
        }
        this.actionOwners.add((Object)owner);
    }

    void removeClientAction(DockingActionIf action) {
        this.clientActions.remove(action);
        this.actionOwners.remove((Object)action.getOwner());
    }

    void addClientAction(DockingActionIf action) {
        ActionTrigger defaultTrigger = this.validateActionsHaveTheSameDefaultKeyStroke(action);
        this.clientActions.put(action, defaultTrigger);
        this.updateActionKeyStrokeFromOptions(action, defaultTrigger);
        if (defaultTrigger != null) {
            KeyBindingData defaultKbd = new KeyBindingData(defaultTrigger);
            this.setDefaultKeyBindingData(defaultKbd);
        }
    }

    @Override
    public String getOwnerDescription() {
        LinkedList<String> owners = new LinkedList<String>(this.actionOwners.uniqueSet());
        if (owners.size() == 1) {
            return (String)owners.get(0);
        }
        boolean hasTool = owners.remove(SHARED_OWNER);
        Collections.sort(owners);
        if (hasTool) {
            owners.add(0, SHARED_OWNER);
        }
        return StringUtils.join(owners, (String)", ");
    }

    @Override
    public String getDescription() {
        Set<DockingActionIf> actions = this.clientActions.keySet();
        for (DockingActionIf action : actions) {
            String description = action.getDescription();
            if (StringUtils.isBlank((CharSequence)description)) continue;
            return description;
        }
        return super.getDescription();
    }

    private ActionTrigger validateActionsHaveTheSameDefaultKeyStroke(DockingActionIf newAction) {
        KeyBindingData defaultBinding = newAction.getDefaultKeyBindingData();
        ActionTrigger newDefaulTrigger = this.getActionTrigger(defaultBinding);
        Set<Map.Entry<DockingActionIf, ActionTrigger>> entries = this.clientActions.entrySet();
        for (Map.Entry<DockingActionIf, ActionTrigger> entry : entries) {
            DockingActionIf existingAction = entry.getKey();
            ActionTrigger existingDefaultTrigger = entry.getValue();
            if (Objects.equals(existingDefaultTrigger, newDefaulTrigger)) continue;
            SharedStubKeyBindingAction.logDifferentKeyBindingsWarnigMessage(newAction, existingAction, existingDefaultTrigger);
            newAction.setKeyBindingData(existingAction.getKeyBindingData());
            return existingDefaultTrigger;
        }
        return newDefaulTrigger;
    }

    private void updateActionKeyStrokeFromOptions(DockingActionIf action, ActionTrigger defaultTrigger) {
        ActionTrigger stubTrigger = defaultTrigger;
        ActionTrigger optionsTrigger = this.getActionTriggerFromOptions(defaultTrigger);
        if (!Objects.equals(defaultTrigger, optionsTrigger)) {
            this.setKeyBindingData(action, optionsTrigger);
            stubTrigger = optionsTrigger;
        }
        this.setKeyBindingData(this, stubTrigger);
    }

    private void setKeyBindingData(DockingActionIf action, ActionTrigger actionTrigger) {
        KeyBindingData currentKbData;
        KeyBindingData newKbData = null;
        if (actionTrigger != null) {
            newKbData = new KeyBindingData(actionTrigger);
        }
        if (Objects.equals(currentKbData = action.getKeyBindingData(), newKbData)) {
            return;
        }
        action.setUnvalidatedKeyBindingData(newKbData);
    }

    private ActionTrigger getActionTriggerFromOptions(ActionTrigger validatedTrigger) {
        return this.keyBindingOptions.getActionTrigger(this.getFullName(), validatedTrigger);
    }

    private ActionTrigger getActionTrigger(KeyBindingData data) {
        if (data == null) {
            return null;
        }
        return data.getActionTrigger();
    }

    @Override
    public void setUnvalidatedKeyBindingData(KeyBindingData newKeyBindingData) {
        super.setUnvalidatedKeyBindingData(newKeyBindingData);
        ActionTrigger newTrigger = this.getActionTrigger(newKeyBindingData);
        for (DockingActionIf action : this.clientActions.keySet()) {
            this.setKeyBindingData(action, newTrigger);
        }
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (!optionName.equals(this.getFullName())) {
            return;
        }
        ActionTrigger newTrigger = (ActionTrigger)newValue;
        this.setKeyBindingData(this, newTrigger);
        for (DockingActionIf action : this.clientActions.keySet()) {
            this.setKeyBindingData(action, newTrigger);
        }
    }

    @Override
    public void actionPerformed(ActionContext context) {
    }

    @Override
    public boolean isAddToPopup(ActionContext context) {
        return false;
    }

    @Override
    public boolean isValidContext(ActionContext context) {
        return false;
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.clientActions.clear();
        this.keyBindingOptions.removeOptionsChangeListener((OptionsChangeListener)this);
    }

    @Override
    public String toString() {
        return "Shared Stub Action: " + super.toString();
    }

    private static void logDifferentKeyBindingsWarnigMessage(DockingActionIf newAction, DockingActionIf existingAction, ActionTrigger existingDefaultTrigger) {
        String s = "Shared Key Binding Actions have different default values.  These must be the same.\n\tAction name: '" + existingAction.getName() + "'\n\tAction 1: " + existingAction.getInceptionInformation() + "\n\t\tAction Trigger: " + String.valueOf(existingDefaultTrigger) + "\n\tAction 2: " + newAction.getInceptionInformation() + "\n\t\tAction Trigger: " + String.valueOf(newAction.getKeyBinding()) + "\nUsing the first value set - " + String.valueOf(existingDefaultTrigger);
        Msg.warn(SharedStubKeyBindingAction.class, (Object)s, (Throwable)ReflectionUtilities.createJavaFilteredThrowable());
    }
}

