/*
 * Decompiled with CFR 0.152.
 */
package docking.util;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TextShaper {
    private List<TextShaperLine> lines = new ArrayList<TextShaperLine>();
    private Dimension textSize = new Dimension(0, 0);
    private String originalText;
    private String clippedText;
    private Dimension displaySize = new Dimension(0, 0);
    private Graphics2D g2d;

    public TextShaper(String text, Dimension displaySize, Graphics2D g2d) {
        this.originalText = text;
        this.clippedText = text;
        this.displaySize = displaySize;
        this.g2d = g2d;
        text = this.removeNewlinesAroundText(text);
        text = text.replaceAll("\t", "    ");
        this.init(text);
    }

    private String removeNewlinesAroundText(String s) {
        int last;
        int first = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') continue;
            first = i;
            break;
        }
        s = s.substring(first);
        for (int i = last = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (c == '\n') continue;
            last = i;
            break;
        }
        return s.substring(0, last + 1);
    }

    private void init(String currentText) {
        if (this.displaySize.width <= 0) {
            return;
        }
        AttributedString as = new AttributedString(currentText);
        int length = currentText.length();
        Font font = this.g2d.getFont();
        as.addAttribute(TextAttribute.FONT, font, 0, length);
        AttributedCharacterIterator paragraph = as.getIterator();
        FontRenderContext frc = this.g2d.getFontRenderContext();
        LineBreakMeasurer measurer = new LineBreakMeasurer(paragraph, frc);
        measurer.setPosition(paragraph.getBeginIndex());
        int totalHeight = 0;
        int largestWidth = 0;
        int position = 0;
        while ((position = measurer.getPosition()) < paragraph.getEndIndex()) {
            TextShaperLine line = this.createLine(currentText, measurer);
            float rowHeight = line.getHeight();
            if ((totalHeight = (int)((float)totalHeight + rowHeight)) > this.displaySize.height) {
                int lineCount = this.lines.size();
                this.lines.clear();
                if (lineCount == 0) {
                    return;
                }
                int end = position;
                int newEnd = end - 3;
                this.clippedText = currentText.substring(0, newEnd) + "...";
                this.init(this.clippedText);
                return;
            }
            this.lines.add(line);
            largestWidth = Math.max(largestWidth, (int)line.getWidth());
        }
        this.textSize = new Dimension(largestWidth, totalHeight);
    }

    private TextShaperLine createLine(String currentText, LineBreakMeasurer measurer) {
        int position = measurer.getPosition();
        int wrappingWidth = this.displaySize.width;
        int nextEnd = measurer.nextOffset(wrappingWidth);
        int limit = this.updateLimitForNewline(currentText, position, nextEnd);
        TextShaperLine line = null;
        if (limit == 0) {
            Font font = this.g2d.getFont();
            FontRenderContext frc = this.g2d.getFontRenderContext();
            LineMetrics lm = font.getLineMetrics("W", frc);
            line = new BlankLine(this, lm.getHeight());
            measurer.nextLayout(wrappingWidth, position + 1, false);
        } else {
            TextLayout layout = measurer.nextLayout(wrappingWidth, position + limit, false);
            int nextPosition = measurer.getPosition();
            String lineText = currentText.substring(position, nextPosition);
            line = new TextLayoutLine(this, lineText, layout);
        }
        this.movePastTrailingNewline(currentText, measurer);
        return line;
    }

    private int updateLimitForNewline(String text, int position, int limit) {
        int newline = text.indexOf(10, position);
        if (newline != -1 && newline >= position && newline < limit) {
            return newline - position;
        }
        return limit;
    }

    private void movePastTrailingNewline(String text, LineBreakMeasurer measurer) {
        char nextChar;
        int newPosition = measurer.getPosition();
        if (newPosition < text.length() && (nextChar = text.charAt(newPosition)) == '\n') {
            measurer.setPosition(newPosition + 1);
        }
    }

    public Dimension getTextSize() {
        return this.textSize;
    }

    public boolean isClipped() {
        return !Objects.equals(this.originalText, this.clippedText);
    }

    public List<TextShaperLine> getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    public void drawText(Graphics2D g) {
        float dy = 0.0f;
        for (TextShaperLine line : this.lines) {
            float y = dy + line.getAscent();
            line.draw(g, 0.0f, y);
            dy += line.getHeight();
        }
    }

    abstract class TextShaperLine {
        TextShaperLine(TextShaper this$0) {
        }

        abstract float getHeight();

        abstract float getWidth();

        abstract float getAscent();

        abstract String getText();

        abstract boolean isBlank();

        abstract void draw(Graphics2D var1, float var2, float var3);
    }

    private class BlankLine
    extends TextShaperLine {
        private float lineHeight;

        BlankLine(TextShaper textShaper, float lineHeight) {
            super(textShaper);
            this.lineHeight = lineHeight;
        }

        @Override
        float getAscent() {
            return 0.0f;
        }

        @Override
        float getHeight() {
            return this.lineHeight;
        }

        @Override
        float getWidth() {
            return 0.0f;
        }

        @Override
        boolean isBlank() {
            return true;
        }

        @Override
        String getText() {
            return "\n";
        }

        @Override
        void draw(Graphics2D g, float x, float y) {
        }

        public String toString() {
            return "Blank Line";
        }
    }

    private class TextLayoutLine
    extends TextShaperLine {
        private String lineText;
        private TextLayout layout;

        TextLayoutLine(TextShaper textShaper, String text, TextLayout layout) {
            super(textShaper);
            this.lineText = text;
            this.layout = layout;
        }

        @Override
        float getAscent() {
            return this.layout.getAscent();
        }

        @Override
        float getHeight() {
            return (int)(this.layout.getAscent() + this.layout.getDescent() + this.layout.getLeading());
        }

        @Override
        float getWidth() {
            return (float)this.layout.getBounds().getWidth();
        }

        @Override
        String getText() {
            return this.lineText;
        }

        @Override
        void draw(Graphics2D g, float x, float y) {
            this.layout.draw(g, x, y);
        }

        @Override
        boolean isBlank() {
            return false;
        }

        public String toString() {
            return this.lineText;
        }
    }
}

