/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.support;

import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.util.exception.AssertException;
import java.math.BigInteger;
import org.jdom.Content;
import org.jdom.Element;

public class FieldRange
implements Comparable<FieldRange> {
    FieldLocation start;
    FieldLocation end;

    public FieldRange(FieldLocation start, FieldLocation end) {
        if (start.compareTo(end) > 0) {
            this.start = new FieldLocation(end);
            this.end = new FieldLocation(start);
        } else {
            this.start = new FieldLocation(start);
            this.end = new FieldLocation(end);
        }
    }

    public FieldRange(FieldRange range) {
        this.start = new FieldLocation(range.start);
        this.end = new FieldLocation(range.end);
    }

    public FieldRange(Element element) {
        this.start = new FieldLocation(element.getChild("START"));
        this.end = new FieldLocation(element.getChild("END"));
    }

    public Element getElement() {
        Element element = new Element("RANGE");
        element.addContent((Content)this.start.getElement("START"));
        element.addContent((Content)this.end.getElement("END"));
        return element;
    }

    public FieldLocation getStart() {
        return this.start;
    }

    public FieldLocation getEnd() {
        return this.end;
    }

    public String toString() {
        return "FieldRange: (" + String.valueOf(this.start) + " :: " + String.valueOf(this.end) + ")";
    }

    public boolean contains(FieldLocation loc) {
        return loc.compareTo(this.start) >= 0 && loc.compareTo(this.end) < 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        FieldRange other = (FieldRange)obj;
        return this.start.equals(other.start) && this.end.equals(other.end);
    }

    public int hashCode() {
        return this.start.hashCode() << 16 + this.end.hashCode();
    }

    @Override
    public int compareTo(FieldRange o) {
        int result = this.start.compareTo(o.start);
        if (result == 0) {
            result = this.end.compareTo(o.end);
        }
        return result;
    }

    public boolean canMerge(FieldRange newRange) {
        if (this.compareTo(newRange) > 0) {
            return newRange.canMerge(this);
        }
        return this.end.compareTo(newRange.start) >= 0;
    }

    public void merge(FieldRange newRange) {
        if (!this.canMerge(newRange)) {
            throw new AssertException("Attempted to merge a range that can't be merged!");
        }
        if (this.start.compareTo(newRange.start) > 0) {
            this.start = newRange.start;
        }
        if (this.end.compareTo(newRange.end) < 0) {
            this.end = newRange.end;
        }
    }

    public boolean isEmpty() {
        return this.start.equals(this.end);
    }

    public boolean intersects(FieldRange range) {
        if (this.compareTo(range) > 0) {
            return range.intersects(this);
        }
        return this.end.compareTo(range.start) > 0;
    }

    public FieldRange intersect(FieldRange range) {
        FieldLocation minEnd;
        FieldLocation maxStart = this.start.compareTo(range.start) >= 0 ? this.start : range.start;
        FieldLocation fieldLocation = minEnd = this.end.compareTo(range.end) <= 0 ? this.end : range.end;
        if (maxStart.compareTo(minEnd) >= 0) {
            return null;
        }
        return new FieldRange(maxStart, minEnd);
    }

    public FieldRange subtract(FieldRange deleteRange) {
        if (!this.intersects(deleteRange)) {
            return null;
        }
        int compareStarts = this.start.compareTo(deleteRange.start);
        int compareEnds = this.end.compareTo(deleteRange.end);
        if (compareStarts < 0 && compareEnds > 0) {
            FieldRange tailPiece = new FieldRange(deleteRange.end, this.end);
            this.end = deleteRange.start;
            return tailPiece;
        }
        if (compareStarts >= 0 && compareEnds <= 0) {
            this.end = this.start;
            return null;
        }
        if (compareStarts < 0) {
            this.end = deleteRange.start;
            return null;
        }
        this.start = deleteRange.end;
        return null;
    }

    public boolean containsEntirely(int index) {
        if (this.start.getIndex().intValue() > index || this.start.getIndex().intValue() == index && (this.start.fieldNum != 0 || this.start.row != 0 || this.start.col != 0)) {
            return false;
        }
        return this.end.getIndex().intValue() > index;
    }

    public boolean containsEntirely(BigInteger index) {
        int compareTo = this.start.getIndex().compareTo(index);
        if (compareTo > 0 || compareTo == 0 && (this.start.fieldNum != 0 || this.start.row != 0 || this.start.col != 0)) {
            return false;
        }
        return this.end.getIndex().compareTo(index) > 0;
    }
}

