/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import ghidra.service.graph.AttributedVertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class GroupVertex
extends AttributedVertex {
    private static final int MAX_IDS_TO_COMBINE = 6;
    private Set<AttributedVertex> children;
    private AttributedVertex first;

    public static GroupVertex groupVertices(Collection<AttributedVertex> vertices) {
        Set<AttributedVertex> set = GroupVertex.flatten(vertices);
        ArrayList<AttributedVertex> list = new ArrayList<AttributedVertex>(set);
        Collections.sort(list, Comparator.comparing(AttributedVertex::getName));
        return new GroupVertex(set, GroupVertex.getUniqueId(list), (AttributedVertex)list.get(0));
    }

    private GroupVertex(Set<AttributedVertex> children, String id, AttributedVertex first) {
        super(id);
        this.first = first;
        this.children = children;
        this.setVertexType("Collapsed Group");
    }

    public static Set<AttributedVertex> flatten(Collection<AttributedVertex> vertices) {
        HashSet<AttributedVertex> set = new HashSet<AttributedVertex>();
        for (AttributedVertex vertex : vertices) {
            if (vertex instanceof GroupVertex) {
                set.addAll(((GroupVertex)vertex).children);
                continue;
            }
            set.add(vertex);
        }
        return set;
    }

    private static String getUniqueId(List<AttributedVertex> vertexList) {
        if (vertexList.size() > 6) {
            int idsNotShownCount = vertexList.size() - 6;
            return GroupVertex.combineIds(vertexList.subList(0, 6)) + "\n...\n + " + idsNotShownCount + " Others";
        }
        return GroupVertex.combineIds(vertexList);
    }

    private static String combineIds(Collection<AttributedVertex> vertices) {
        return vertices.stream().map(AttributedVertex::getName).collect(Collectors.joining("\n"));
    }

    public Set<AttributedVertex> getContainedVertices() {
        return Collections.unmodifiableSet(this.children);
    }

    public AttributedVertex getFirst() {
        return this.first;
    }
}

