/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import db.Transaction;
import ghidra.app.plugin.core.debug.mapping.AbstractDebuggerPlatformMapper;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TraceGuestPlatform;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.guest.TracePlatformManager;
import ghidra.trace.model.target.TraceObject;
import ghidra.util.MathUtilities;
import ghidra.util.Msg;

public class DefaultDebuggerPlatformMapper
extends AbstractDebuggerPlatformMapper {
    protected final PluginTool tool;
    protected final CompilerSpec cSpec;

    protected static boolean isHarvard(Language language) {
        return language.getDefaultSpace() != language.getDefaultDataSpace();
    }

    public DefaultDebuggerPlatformMapper(PluginTool tool, Trace trace, CompilerSpec cSpec) {
        super(tool, trace);
        this.validate(cSpec);
        this.tool = tool;
        this.cSpec = cSpec;
    }

    protected void validate(CompilerSpec cSpec) {
        if (DefaultDebuggerPlatformMapper.isHarvard(cSpec.getLanguage())) {
            throw new IllegalArgumentException("This mapper cannot handle Harvard guests");
        }
    }

    public CompilerSpec getCompilerSpec(TraceObject object, long snap) {
        return this.cSpec;
    }

    protected TracePlatform addOrGetPlatform(CompilerSpec cSpec, long snap) {
        String description = "Add guest " + String.valueOf(cSpec.getLanguage().getLanguageDescription()) + "/" + String.valueOf(cSpec.getCompilerSpecDescription());
        try (Transaction tx = this.trace.openTransaction(description);){
            TracePlatformManager platformManager = this.trace.getPlatformManager();
            TracePlatform platform = platformManager.getOrAddPlatform(cSpec);
            if (!platform.isHost()) {
                this.addMappedRanges((TraceGuestPlatform)platform);
            }
            TracePlatform tracePlatform = platform;
            return tracePlatform;
        }
    }

    public TracePlatform addToTrace(TraceObject newFocus, long snap) {
        return this.addOrGetPlatform(this.cSpec, snap);
    }

    protected void addMappedRanges(TraceGuestPlatform platform) {
        Trace trace = platform.getTrace();
        AddressSpace hostSpace = trace.getBaseAddressFactory().getDefaultAddressSpace();
        AddressSpace guestSpace = platform.getAddressFactory().getDefaultAddressSpace();
        long min = MathUtilities.unsignedMax((long)hostSpace.getMinAddress().getOffset(), (long)guestSpace.getMinAddress().getOffset());
        long max = MathUtilities.unsignedMin((long)hostSpace.getMaxAddress().getOffset(), (long)guestSpace.getMaxAddress().getOffset());
        Address hostStart = hostSpace.getAddress(min);
        Address guestStart = guestSpace.getAddress(min);
        if (platform.getHostAddressSet().contains(hostStart)) {
            return;
        }
        try {
            platform.addMappedRange(hostStart, guestStart, max - min + 1L);
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
        try {
            platform.addMappedRegisterRange();
        }
        catch (AddressOverflowException e) {
            Msg.showError((Object)this, null, (String)"Map Registers", (Object)("The host language cannot accomodate register storage for the guest platform (language: " + String.valueOf(platform.getLanguage()) + ")"));
        }
    }
}

