/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.picking.GPickedState;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class VertexMouseInfo<V extends VisualVertex, E extends VisualEdge<V>> {
    private static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    private static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    private final MouseEvent originalMouseEvent;
    private final GraphViewer<V, E> viewer;
    private final V vertex;
    private MouseEvent translatedMouseEvent;
    private Component mousedDestinationComponent;
    private Point2D vertexBasedClickPoint;

    public VertexMouseInfo(MouseEvent originalMouseEvent, V vertex, Point2D vertexBasedClickPoint, GraphViewer<V, E> viewer) {
        this.vertexBasedClickPoint = vertexBasedClickPoint;
        this.originalMouseEvent = Objects.requireNonNull(originalMouseEvent);
        this.vertex = (VisualVertex)Objects.requireNonNull(vertex);
        this.viewer = Objects.requireNonNull(viewer);
        JComponent component = vertex.getComponent();
        Component deepestComponent = SwingUtilities.getDeepestComponentAt(component, (int)vertexBasedClickPoint.getX(), (int)vertexBasedClickPoint.getY());
        this.setClickedComponent(deepestComponent, vertexBasedClickPoint);
    }

    public Point2D getVertexRelativeClickPoint() {
        return this.vertexBasedClickPoint;
    }

    public boolean isScaledPastInteractionThreshold() {
        RenderContext renderContext = this.viewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = renderContext.getMultiLayerTransformer();
        MutableTransformer viewTransformer = multiLayerTransformer.getTransformer(Layer.VIEW);
        double scale = viewTransformer.getScale();
        return scale < 0.2;
    }

    public Cursor getCursorForClickedComponent() {
        if (this.isGrabArea()) {
            return HAND_CURSOR;
        }
        if (!this.isVertexSelected()) {
            return HAND_CURSOR;
        }
        if (this.mousedDestinationComponent != null) {
            return this.mousedDestinationComponent.getCursor();
        }
        return DEFAULT_CURSOR;
    }

    public boolean isGrabArea() {
        if (this.isButtonClick()) {
            return false;
        }
        return this.vertex.isGrabbable(this.getClickedComponent());
    }

    public boolean isButtonClick() {
        Component clickedComponent = this.getClickedComponent();
        return clickedComponent instanceof JButton;
    }

    public boolean isVertexSelected() {
        PickedState pickedVertexState = this.viewer.getPickedVertexState();
        return pickedVertexState.isPicked(this.vertex);
    }

    public void selectVertex(boolean addToSelection) {
        PickedState pickedEdgeState = this.viewer.getPickedEdgeState();
        pickedEdgeState.clear();
        if (this.isVertexSelected()) {
            return;
        }
        GPickedState<V> pickedState = this.viewer.getGPickedVertexState();
        pickedState.pickToSync(this.vertex, addToSelection);
    }

    Component getVertexComponent() {
        return this.vertex.getComponent();
    }

    public Component getClickedComponent() {
        return this.mousedDestinationComponent;
    }

    public GraphViewer<V, E> getViewer() {
        return this.viewer;
    }

    public V getVertex() {
        return this.vertex;
    }

    public Point getDeepestComponentBasedClickPoint() {
        return this.translatedMouseEvent.getPoint();
    }

    public void setClickedComponent(Component clickedComponent, Point2D vertexBasedPoint) {
        this.mousedDestinationComponent = clickedComponent;
        Point componentPoint = new Point((int)vertexBasedPoint.getX(), (int)vertexBasedPoint.getY());
        Component newEventSource = this.vertex.getComponent();
        Point pointInClickedComponentCoordinates = componentPoint;
        if (clickedComponent != null) {
            newEventSource = clickedComponent;
            pointInClickedComponentCoordinates = SwingUtilities.convertPoint(this.getVertexComponent(), componentPoint, clickedComponent);
        }
        this.translatedMouseEvent = this.createMouseEventFromSource(newEventSource, this.originalMouseEvent, pointInClickedComponentCoordinates);
    }

    public Object getEventSource() {
        return this.originalMouseEvent.getSource();
    }

    public MouseEvent getOriginalMouseEvent() {
        return this.originalMouseEvent;
    }

    public MouseEvent getTranslatedMouseEvent() {
        return this.translatedMouseEvent;
    }

    public void forwardEvent() {
        if (this.mousedDestinationComponent == null) {
            return;
        }
        this.mousedDestinationComponent.dispatchEvent(this.translatedMouseEvent);
        if (!this.isPopupClick()) {
            this.originalMouseEvent.consume();
        }
    }

    public void simulateMouseEnteredEvent() {
        if (this.mousedDestinationComponent == null) {
            return;
        }
        MouseEvent mouseEnteredEvent = this.createMouseEnteredEvent();
        this.mousedDestinationComponent.dispatchEvent(mouseEnteredEvent);
        this.viewer.repaint();
    }

    public void simulateMouseExitedEvent() {
        if (this.mousedDestinationComponent == null) {
            return;
        }
        MouseEvent mouseExitedEvent = this.createMouseExitedEvent();
        this.mousedDestinationComponent.dispatchEvent(mouseExitedEvent);
        this.viewer.repaint();
    }

    private MouseEvent createMouseEnteredEvent() {
        return new MouseEvent(this.mousedDestinationComponent, 504, System.currentTimeMillis(), 0, 0, 0, 0, false);
    }

    private MouseEvent createMouseExitedEvent() {
        return new MouseEvent(this.mousedDestinationComponent, 505, System.currentTimeMillis(), 0, 0, 0, 0, false);
    }

    private MouseEvent createMouseEventFromSource(Component source, MouseEvent ev, Point2D clickPoint) {
        if (ev instanceof MouseWheelEvent) {
            MouseWheelEvent wheelEvent = (MouseWheelEvent)ev;
            int scrollType = wheelEvent.getScrollType();
            int scrollAmount = wheelEvent.getScrollAmount();
            int wheelRotation = wheelEvent.getWheelRotation();
            return new MouseWheelEvent(source, ev.getID(), ev.getWhen(), ev.getModifiers() | ev.getModifiersEx(), (int)clickPoint.getX(), (int)clickPoint.getY(), ev.getClickCount(), ev.isPopupTrigger(), scrollType, scrollAmount, wheelRotation);
        }
        return new MouseEvent(source, ev.getID(), ev.getWhen(), ev.getModifiers() | ev.getModifiersEx(), (int)clickPoint.getX(), (int)clickPoint.getY(), ev.getClickCount(), ev.isPopupTrigger(), ev.getButton());
    }

    public boolean isPopupClick() {
        return this.getOriginalMouseEvent().getButton() == 3;
    }

    public String toString() {
        return "{\n\tvertex: " + String.valueOf(this.vertex) + ",\n\tclickedComponent: " + String.valueOf(this.mousedDestinationComponent) + ",\n\tevent: " + String.valueOf(this.originalMouseEvent) + ",\n\ttranslatedEvent: " + String.valueOf(this.translatedMouseEvent) + "\n}";
    }
}

