/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.util.AbstractVTMatchTableModel;
import ghidra.program.model.address.Address;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class VTMatchTableModel
extends AbstractVTMatchTableModel {
    private static final String TITLE = "VTMatch Table Model";

    public VTMatchTableModel(VTController controller) {
        super(TITLE, controller);
    }

    protected TableColumnDescriptor<VTMatch> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.TagTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.SessionNumberTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.StatusTableColumn(), 1, true);
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.AppliedMarkupStatusTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.MatchTypeTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.ScoreTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.ConfidenceScoreTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.ImpliedMatchCountColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.RelatedMatchCountColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.MultipleSourceLabelsTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.SourceNamespaceTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.SourceLabelTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.SourceLabelSourceTypeTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.SourceAddressTableColumn(), 2, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.MultipleDestinationLabelsTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.DestinationNamespaceTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.DestinationLabelTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.DestinationLabelSourceTypeTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.DestinationAddressTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.SourceLengthTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.DestinationLengthTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new AbstractVTMatchTableModel.LengthDeltaTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AbstractVTMatchTableModel.AlgorithmTableColumn());
        return descriptor;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        int tagColumnIndex = this.getColumnIndex(AbstractVTMatchTableModel.TagTableColumn.class);
        if (columnIndex == tagColumnIndex) {
            return true;
        }
        return super.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public Address getAddress(int row) {
        VTMatch match = (VTMatch)this.getRowObject(row);
        VTAssociation association = match.getAssociation();
        return association.getSourceAddress();
    }

    @Override
    protected void doLoad(Accumulator<VTMatch> accumulator, TaskMonitor monitor) throws CancelledException {
        monitor.initialize((long)this.getMatchCount());
        List<VTMatchSet> matchSets = this.session.getMatchSets();
        for (VTMatchSet matchSet : matchSets) {
            monitor.checkCancelled();
            Collection<VTMatch> matches = matchSet.getMatches();
            for (VTMatch match : matches) {
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
                accumulator.add((Object)match);
            }
        }
    }

    private int getMatchCount() {
        int count = 0;
        List<VTMatchSet> matchSets = this.session.getMatchSets();
        for (VTMatchSet matchSet : matchSets) {
            count += matchSet.getMatchCount();
        }
        return count;
    }

    protected Comparator<VTMatch> createSortComparator(int columnIndex) {
        int destinationAddressColumnIndex = this.getColumnIndex(AbstractVTMatchTableModel.DestinationAddressTableColumn.class);
        if (destinationAddressColumnIndex == columnIndex) {
            return new AbstractVTMatchTableModel.DestinationAddressComparator();
        }
        int sourceColumnAddressIndex = this.getColumnIndex(AbstractVTMatchTableModel.SourceAddressTableColumn.class);
        if (sourceColumnAddressIndex == columnIndex) {
            return new AbstractVTMatchTableModel.SourceAddressComparator();
        }
        int markupStatusColumnIndex = this.getColumnIndex(AbstractVTMatchTableModel.AppliedMarkupStatusBatteryTableColumn.class);
        if (markupStatusColumnIndex == columnIndex) {
            return this.markupStatusColumnComparator;
        }
        markupStatusColumnIndex = this.getColumnIndex(AbstractVTMatchTableModel.AppliedMarkupStatusTableColumn.class);
        if (markupStatusColumnIndex == columnIndex) {
            return this.markupStatusColumnComparator;
        }
        return super.createSortComparator(columnIndex);
    }
}

