/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;

public class RemoveFunctionTagCmd
implements Command<Program> {
    private Address entryPoint;
    private String tagName;

    public RemoveFunctionTagCmd(String tagName, Address entryPoint) {
        this.tagName = tagName;
        this.entryPoint = entryPoint;
    }

    public boolean applyTo(Program program) {
        FunctionManager functionManager = program.getFunctionManager();
        Function function = functionManager.getFunctionAt(this.entryPoint);
        function.removeTag(this.tagName);
        return true;
    }

    public String getName() {
        return "Remove Tag From Function";
    }

    public String getStatusMsg() {
        return null;
    }
}

