/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ThreadInfo
implements StructConverter {
    public static final String NAME = "MINIDUMP_THREAD_INFO";
    private int threadId;
    private int dumpFlags;
    private int dumpError;
    private int exitStatus;
    private long createTime;
    private long exitTime;
    private long kernelTime;
    private long userTime;
    private long startAddress;
    private long affinity;
    private DumpFileReader reader;
    private long index;

    ThreadInfo(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setThreadId(this.reader.readNextInt());
        this.setDumpFlags(this.reader.readNextInt());
        this.setDumpError(this.reader.readNextInt());
        this.setExitStatus(this.reader.readNextInt());
        this.setCreateTime(this.reader.readNextLong());
        this.setExitTime(this.reader.readNextLong());
        this.setKernelTime(this.reader.readNextLong());
        this.setUserTime(this.reader.readNextLong());
        this.setStartAddress(this.reader.readNextLong());
        this.setAffinity(this.reader.readNextLong());
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "ThreadId", null);
        struct.add(DWORD, 4, "DumpFlags", null);
        struct.add(DWORD, 4, "DumpError", null);
        struct.add(DWORD, 4, "ExitStatus", null);
        struct.add(QWORD, 8, "CreateTime", null);
        struct.add(QWORD, 8, "ExitTime", null);
        struct.add(QWORD, 8, "KernelTime", null);
        struct.add(QWORD, 8, "UserTime", null);
        struct.add(QWORD, 8, "StartAddress", null);
        struct.add(QWORD, 8, "Affinity", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void setThreadId(int threadId) {
        this.threadId = threadId;
    }

    public int getDumpFlags() {
        return this.dumpFlags;
    }

    public void setDumpFlags(int dumpFlags) {
        this.dumpFlags = dumpFlags;
    }

    public int getDumpError() {
        return this.dumpError;
    }

    public void setDumpError(int dumpError) {
        this.dumpError = dumpError;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(int exitStatus) {
        this.exitStatus = exitStatus;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getExitTime() {
        return this.exitTime;
    }

    public void setExitTime(long exitTime) {
        this.exitTime = exitTime;
    }

    public long getKernelTime() {
        return this.kernelTime;
    }

    public void setKernelTime(long kernelTime) {
        this.kernelTime = kernelTime;
    }

    public long getUserTime() {
        return this.userTime;
    }

    public void setUserTime(long userTime) {
        this.userTime = userTime;
    }

    public long getStartAddress() {
        return this.startAddress;
    }

    public void setStartAddress(long startAddress) {
        this.startAddress = startAddress;
    }

    public long getAffinity() {
        return this.affinity;
    }

    public void setAffinity(long affinity) {
        this.affinity = affinity;
    }
}

