/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.pagedump;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class TriageStorage
implements StructConverter {
    public static final String NAME = "_MI_TRIAGE_STORAGE";
    private int version;
    private int size;
    private int mmSpecialPoolTag;
    private int miTriageActionTaken;
    private int mmVerifyDriverLevel;
    private int kernelVerifier;
    private long mmMaximumNonPagedPool;
    private long mmAllocatedNonPagedPool;
    private long pagedPoolMaximum;
    private long pagePoolAllocated;
    private long commitedPages;
    private long commitedPagesPeak;
    private long commitedPagesMaximum;
    private DumpFileReader reader;
    private long index;
    private int psz;

    TriageStorage(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.psz = reader.getPointerSize();
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setVersion(this.reader.readNextInt());
        this.setSize(this.reader.readNextInt());
        this.setMmSpecialPoolTag(this.reader.readNextInt());
        this.setMiTriageActionTaken(this.reader.readNextInt());
        this.setMmVerifyDriverLevel(this.reader.readNextInt());
        this.setKernelVerifier(this.reader.readNextInt());
        this.setMmMaximumNonPagedPool(this.reader.readNextLong());
        this.setMmAllocatedNonPagedPool(this.reader.readNextLong());
        this.setPagedPoolMaximum(this.reader.readNextLong());
        this.setPagePoolAllocated(this.reader.readNextLong());
        this.setCommitedPages(this.reader.readNextLong());
        this.setCommitedPagesPeak(this.reader.readNextLong());
        this.setCommitedPagesMaximum(this.reader.readNextLong());
    }

    public DataType toDataType() {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "Version", null);
        struct.add(DWORD, 4, "Size", null);
        struct.add(DWORD, 4, "MmSpecialPoolTag", null);
        struct.add(DWORD, 4, "MiTriageActionTaken", null);
        struct.add(DWORD, 4, "MmVerifyDriverLevel", null);
        struct.add(DWORD, 4, "KernelVerifier", null);
        struct.add(QWORD, this.psz, "MmMaximumNonPagedPool", null);
        struct.add(QWORD, this.psz, "MmAllocatedNonPagedPool", null);
        struct.add(QWORD, this.psz, "PagedPoolMaximum", null);
        struct.add(QWORD, this.psz, "PagePoolAllocated", null);
        struct.add(QWORD, this.psz, "CommitedPages", null);
        struct.add(QWORD, this.psz, "CommitedPagesPeak", null);
        struct.add(QWORD, this.psz, "CommitedPagesMaximum", null);
        struct.setCategoryPath(new CategoryPath("/PDMP"));
        return struct;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getMmSpecialPoolTag() {
        return this.mmSpecialPoolTag;
    }

    public void setMmSpecialPoolTag(int mmSpecialPoolTag) {
        this.mmSpecialPoolTag = mmSpecialPoolTag;
    }

    public int getMiTriageActionTaken() {
        return this.miTriageActionTaken;
    }

    public void setMiTriageActionTaken(int miTriageActionTaken) {
        this.miTriageActionTaken = miTriageActionTaken;
    }

    public int getMmVerifyDriverLevel() {
        return this.mmVerifyDriverLevel;
    }

    public void setMmVerifyDriverLevel(int mmVerifyDriverLevel) {
        this.mmVerifyDriverLevel = mmVerifyDriverLevel;
    }

    public long getMmMaximumNonPagedPool() {
        return this.mmMaximumNonPagedPool;
    }

    public void setMmMaximumNonPagedPool(long mmMaximumNonPagedPool) {
        this.mmMaximumNonPagedPool = mmMaximumNonPagedPool;
    }

    public int getKernelVerifier() {
        return this.kernelVerifier;
    }

    public void setKernelVerifier(int kernelVerifier) {
        this.kernelVerifier = kernelVerifier;
    }

    public long getMmAllocatedNonPagedPool() {
        return this.mmAllocatedNonPagedPool;
    }

    public void setMmAllocatedNonPagedPool(long mmAllocatedNonPagedPool) {
        this.mmAllocatedNonPagedPool = mmAllocatedNonPagedPool;
    }

    public long getPagedPoolMaximum() {
        return this.pagedPoolMaximum;
    }

    public void setPagedPoolMaximum(long pagedPoolMaximum) {
        this.pagedPoolMaximum = pagedPoolMaximum;
    }

    public long getPagePoolAllocated() {
        return this.pagePoolAllocated;
    }

    public void setPagePoolAllocated(long pagePoolAllocated) {
        this.pagePoolAllocated = pagePoolAllocated;
    }

    public long getCommitedPages() {
        return this.commitedPages;
    }

    public void setCommitedPages(long commitedPages) {
        this.commitedPages = commitedPages;
    }

    public long getCommitedPagesPeak() {
        return this.commitedPagesPeak;
    }

    public void setCommitedPagesPeak(long commitedPagesPeak) {
        this.commitedPagesPeak = commitedPagesPeak;
    }

    public long getCommitedPagesMaximum() {
        return this.commitedPagesMaximum;
    }

    public void setCommitedPagesMaximum(long commitedPagesMaximum) {
        this.commitedPagesMaximum = commitedPagesMaximum;
    }
}

