/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.memstate;

import java.util.Arrays;

public class MemoryPage {
    public final byte[] data;
    private byte[] initializedMask;

    public MemoryPage(int pageSize) {
        this.data = new byte[pageSize];
    }

    public MemoryPage(byte[] bytes) {
        this.data = bytes;
    }

    public byte[] getInitializedMask() {
        return this.initializedMask;
    }

    public void setUninitialized() {
        this.initializedMask = MemoryPage.getInitializedMask(this.data.length, false);
    }

    public void setInitialized() {
        this.initializedMask = MemoryPage.getInitializedMask(this.data.length, true);
    }

    public void setInitialized(int pageOffset, int size, byte[] maskUpdate) {
        int maskOffset = pageOffset / 8;
        int firstBit = pageOffset % 8;
        while (size > 0) {
            int mask;
            int s = Math.min(size, 8 - firstBit);
            size -= s;
            int val = mask = 255 << firstBit & (1 << firstBit + s) - 1;
            if (maskUpdate != null) {
                val &= maskUpdate[maskOffset];
            }
            if (this.initializedMask == null) {
                byte test = (byte)(val | ~mask);
                if (test == -1) {
                    ++maskOffset;
                    firstBit = 0;
                    continue;
                }
                this.initializedMask = MemoryPage.getInitializedMask(this.data.length, true);
            }
            this.initializedMask[maskOffset] = (byte)(this.initializedMask[maskOffset] & ~mask | val);
            ++maskOffset;
            firstBit = 0;
        }
    }

    public void setInitialized(int pageOffset, int size) {
        if (this.initializedMask == null) {
            return;
        }
        if (pageOffset == 0 && size == this.data.length) {
            this.initializedMask = null;
            return;
        }
        MemoryPage.setInitialized(this.initializedMask, pageOffset, size);
    }

    public void setUninitialized(int pageOffset, int size) {
        if (this.initializedMask == null) {
            this.initializedMask = MemoryPage.getInitializedMask(this.data.length, true);
        }
        MemoryPage.setUninitialized(this.initializedMask, pageOffset, size);
    }

    public int getInitializedByteCount(int pageOffset, int size) {
        return MemoryPage.getInitializedByteCount(this.initializedMask, pageOffset, size);
    }

    public static byte[] getInitializedMask(int pageSize, boolean initialized) {
        byte[] mask = new byte[(pageSize + 7) / 8];
        if (initialized) {
            Arrays.fill(mask, (byte)-1);
        }
        return mask;
    }

    public static byte[] getInitializedMask(int pageSize, int offset, int size, boolean initialized) {
        byte[] mask = MemoryPage.getInitializedMask(pageSize, true);
        if (initialized) {
            int end;
            if (offset != 0) {
                MemoryPage.setUninitialized(mask, 0, offset);
            }
            if ((end = offset + size) < pageSize) {
                MemoryPage.setUninitialized(mask, end, pageSize - end);
            }
        } else if (size != 0) {
            MemoryPage.setUninitialized(mask, offset, size);
        }
        return mask;
    }

    public static void setInitialized(byte[] initializedMask, int pageOffset, int size) {
        int maskOffset = pageOffset / 8;
        int firstBit = pageOffset % 8;
        while (size > 0) {
            int s = Math.min(size, 8 - firstBit);
            size -= s;
            int mask = 255 << firstBit & (1 << firstBit + s) - 1;
            int n = maskOffset++;
            initializedMask[n] = (byte)(initializedMask[n] | (byte)mask);
            firstBit = 0;
        }
    }

    public static void setUninitialized(byte[] initializedMask, int pageOffset, int size) {
        int maskOffset = pageOffset / 8;
        int firstBit = pageOffset % 8;
        while (size > 0) {
            int s = Math.min(size, 8 - firstBit);
            size -= s;
            int mask = 255 << firstBit & (1 << firstBit + s) - 1;
            int n = maskOffset++;
            initializedMask[n] = (byte)(initializedMask[n] & (byte)(~mask));
            firstBit = 0;
        }
    }

    public static int getInitializedByteCount(byte[] initializedMask, int pageOffset, int size) {
        if (initializedMask == null) {
            return size;
        }
        int initializedSize = 0;
        int maskOffset = pageOffset / 8;
        int firstBit = pageOffset % 8;
        while (size > 0) {
            int s = Math.min(size, 8 - firstBit);
            size -= s;
            int mask = 255 << firstBit & (1 << firstBit + s) - 1;
            int result = initializedMask[maskOffset] & mask;
            if (result != mask) {
                result >>= firstBit;
                while ((result & 1) != 0) {
                    ++initializedSize;
                    result >>= 1;
                }
                return initializedSize;
            }
            initializedSize += s;
            ++maskOffset;
            firstBit = 0;
        }
        return initializedSize;
    }
}

