/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VtShapeDescriptorMsProperty;
import java.util.ArrayList;
import java.util.List;

public class VtShapeMsType
extends AbstractMsType {
    public static final int PDB_ID = 10;
    private int count;
    private List<VtShapeDescriptorMsProperty> descriptorList = new ArrayList<VtShapeDescriptorMsProperty>();

    public VtShapeMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        VtShapeDescriptorMsProperty descriptor;
        int value;
        this.count = reader.parseUnsignedShortVal();
        int byteVal = 0;
        for (int i = 0; i < this.count / 2; ++i) {
            byteVal = reader.parseUnsignedByteVal();
            value = byteVal >> 4;
            descriptor = VtShapeDescriptorMsProperty.fromValue(value);
            this.descriptorList.add(descriptor);
            value = byteVal & 0xF;
            descriptor = VtShapeDescriptorMsProperty.fromValue(value);
            this.descriptorList.add(descriptor);
        }
        if (this.count % 2 == 1) {
            byteVal = reader.parseUnsignedByteVal();
            value = byteVal >> 4;
            descriptor = VtShapeDescriptorMsProperty.fromValue(value);
            this.descriptorList.add(descriptor);
        }
        reader.skipPadding();
    }

    @Override
    public int getPdbId() {
        return 10;
    }

    public int getCount() {
        return this.count;
    }

    public List<VtShapeDescriptorMsProperty> getDescriptorList() {
        return this.descriptorList;
    }

    public boolean hasDescriptor(VtShapeDescriptorMsProperty descriptor) {
        return this.descriptorList.contains((Object)descriptor);
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        DelimiterState ds = new DelimiterState("", ",");
        builder.append("vtshape: {");
        for (VtShapeDescriptorMsProperty descriptor : this.descriptorList) {
            builder.append(ds.out(true, (Object)descriptor));
        }
        builder.append("}");
    }
}

