/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.analyzers;

import generic.jar.ResourceFile;
import ghidra.app.analyzers.Patterns;
import ghidra.app.analyzers.PossibleDelayedFunctionCreator;
import ghidra.app.cmd.function.CreateThunkFunctionCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.Analyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.PseudoDisassemblerContext;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.AddressSetPropertyMap;
import ghidra.util.Msg;
import ghidra.util.bytesearch.AlignRule;
import ghidra.util.bytesearch.Match;
import ghidra.util.bytesearch.MatchAction;
import ghidra.util.bytesearch.MemoryBytePatternSearcher;
import ghidra.util.bytesearch.Pattern;
import ghidra.util.bytesearch.PatternFactory;
import ghidra.util.bytesearch.PostRule;
import ghidra.util.bytesearch.SequenceSearchState;
import ghidra.util.constraint.ProgramDecisionTree;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;

public class FunctionStartAnalyzer
extends AbstractAnalyzer
implements PatternFactory {
    protected static final String FUNCTION_START_SEARCH = "Function Start Search";
    protected static final String NAME = "Function Start Search";
    private static final String DESCRIPTION = "Search for architecture specific byte patterns: typically starts of functions";
    private static final String PRE_FUNCTION_MATCH_PROPERTY_NAME = "PreFunctionMatch";
    private static final String OPTION_NAME_DATABLOCKS = "Search Data Blocks";
    private static final String OPTION_DESCRIPTION_DATABLOCKS = "Search for byte patterns in blocks that are not executable";
    private static final boolean OPTION_DEFAULT_DATABLOCKS = false;
    private static final String OPTION_NAME_BOOKMARKS = "Bookmark Functions";
    private static final String OPTION_DESCRIPTION_BOOKMARKS = "Place a bookmark at functions that were discovered by a pattern";
    private static final boolean OPTION_DEFAULT_BOOKMARKS = false;
    private static ProgramDecisionTree patternDecisitionTree;
    SequenceSearchState rootState = null;
    SequenceSearchState explicitState = null;
    private boolean executableBlocksOnly = true;
    private boolean setbookmark = false;
    protected boolean hasDataConstraints = false;
    protected boolean hasCodeConstraints = false;
    protected boolean hasFunctionStartConstraints = false;
    protected AddressSetPropertyMap potentialMatchAddressSetPropertyMap;
    private AddressSet funcResult = null;
    private AddressSet potentialFuncResult = null;
    private AddressSet disassemResult = null;
    private AddressSet codeLocations = null;
    protected AddressSet postreqFailedResult = null;
    protected ArrayList<RegisterValue> contextValueList = null;

    private static ProgramDecisionTree initializePatternDecisionTree() {
        if (patternDecisitionTree == null) {
            patternDecisitionTree = Patterns.getPatternDecisionTree();
        }
        return patternDecisitionTree;
    }

    public ProgramDecisionTree getPatternDecisionTree() {
        return FunctionStartAnalyzer.initializePatternDecisionTree();
    }

    public FunctionStartAnalyzer() {
        this("Function Start Search", AnalyzerType.BYTE_ANALYZER);
    }

    public FunctionStartAnalyzer(String name, AnalyzerType analyzerType) {
        this(name, DESCRIPTION, analyzerType);
    }

    public FunctionStartAnalyzer(String name, String description, AnalyzerType analyzerType) {
        super(name, description, analyzerType);
        this.setPriority(AnalysisPriority.CODE_ANALYSIS.after().after());
        this.setDefaultEnablement(true);
        this.setSupportsOneTimeAnalysis();
    }

    public void setExplicitState(SequenceSearchState explicit) {
        this.explicitState = explicit;
    }

    public void clearExplicitState() {
        this.explicitState = null;
    }

    private void setCurrentContext(Program program, Address addr) {
        if (this.contextValueList == null) {
            return;
        }
        ProgramContext programContext = program.getProgramContext();
        for (RegisterValue contextValue : this.contextValueList) {
            try {
                programContext.setRegisterValue(addr, addr, contextValue);
            }
            catch (ContextChangeException contextChangeException) {}
        }
        this.contextValueList = null;
    }

    private void setDisassemblerContext(Program program, PseudoDisassemblerContext pcont, Address addr) {
        if (this.contextValueList == null) {
            return;
        }
        for (RegisterValue contextValue : this.contextValueList) {
            pcont.setValue(contextValue.getRegister(), addr, contextValue.getUnsignedValue());
        }
    }

    public boolean canAnalyze(Program program) {
        ProgramDecisionTree patternDecisionTree = this.getPatternDecisionTree();
        boolean hasPatterns = Patterns.hasPatternFiles(program, patternDecisionTree);
        return hasPatterns;
    }

    public AddressSetPropertyMap getOrCreatePotentialMatchPropertyMap(Program program) {
        if (this.potentialMatchAddressSetPropertyMap != null) {
            return this.potentialMatchAddressSetPropertyMap;
        }
        this.potentialMatchAddressSetPropertyMap = program.getAddressSetPropertyMap(PRE_FUNCTION_MATCH_PROPERTY_NAME);
        if (this.potentialMatchAddressSetPropertyMap != null) {
            return this.potentialMatchAddressSetPropertyMap;
        }
        try {
            this.potentialMatchAddressSetPropertyMap = program.createAddressSetPropertyMap(PRE_FUNCTION_MATCH_PROPERTY_NAME);
        }
        catch (DuplicateNameException e) {
            throw new AssertException("Can't get DuplicateNameException since we tried to get it first");
        }
        return this.potentialMatchAddressSetPropertyMap;
    }

    public boolean added(final Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        SequenceSearchState root = this.initialize(program);
        if (root == null) {
            String message = "Could not initialize a search state.";
            log.appendMsg(this.getName(), message);
            log.setStatus(message);
            return false;
        }
        boolean doExecutableBlocksOnly = this.checkForExecuteBlock(program) && this.executableBlocksOnly;
        this.getOrCreatePotentialMatchPropertyMap(program).remove(set);
        MemoryBytePatternSearcher patternSearcher = new MemoryBytePatternSearcher("Function Starts", root){

            public void preMatchApply(MatchAction[] actions, Address addr) {
                FunctionStartAnalyzer.this.contextValueList = null;
            }

            public void postMatchApply(MatchAction[] actions, Address addr) {
                if (!FunctionStartAnalyzer.this.postreqFailedResult.contains(addr)) {
                    FunctionStartAnalyzer.this.setCurrentContext(program, addr);
                }
                FunctionStartAnalyzer.this.contextValueList = null;
            }
        };
        patternSearcher.setSearchExecutableOnly(doExecutableBlocksOnly);
        patternSearcher.search(program, set, monitor);
        AutoAnalysisManager analysisManager = AutoAnalysisManager.getAnalysisManager((Program)program);
        if (!this.disassemResult.isEmpty()) {
            AddressSet doNowDisassembly = this.disassemResult.intersect((AddressSetView)this.funcResult);
            analysisManager.disassemble((AddressSetView)doNowDisassembly);
            AddressSet delayedDisassembly = this.disassemResult.subtract((AddressSetView)this.funcResult);
            analysisManager.disassemble((AddressSetView)delayedDisassembly, AnalysisPriority.DISASSEMBLY);
        }
        analysisManager.setProtectedLocations(this.codeLocations);
        if (!this.potentialFuncResult.isEmpty()) {
            this.potentialFuncResult = this.potentialFuncResult.subtract((AddressSetView)this.funcResult);
            PossibleDelayedFunctionCreator analyzer = new PossibleDelayedFunctionCreator();
            analysisManager.scheduleOneTimeAnalysis((Analyzer)analyzer, (AddressSetView)this.potentialFuncResult);
        }
        if (!this.funcResult.isEmpty()) {
            analysisManager.createFunction((AddressSetView)this.funcResult, false);
        }
        return true;
    }

    private boolean checkForExecuteBlock(Program program) {
        MemoryBlock[] blocks;
        for (MemoryBlock block : blocks = program.getMemory().getBlocks()) {
            if (!block.isExecute()) continue;
            return true;
        }
        return false;
    }

    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_DATABLOCKS, (Object)false, null, OPTION_DESCRIPTION_DATABLOCKS);
        options.registerOption(OPTION_NAME_BOOKMARKS, (Object)this.setbookmark, null, OPTION_DESCRIPTION_BOOKMARKS);
    }

    public void optionsChanged(Options options, Program program) {
        boolean datablocks = options.getBoolean(OPTION_NAME_DATABLOCKS, false);
        this.executableBlocksOnly = !datablocks;
        this.setbookmark = options.getBoolean(OPTION_NAME_BOOKMARKS, this.setbookmark);
    }

    protected SequenceSearchState initialize(Program program) {
        this.potentialFuncResult = new AddressSet();
        this.disassemResult = new AddressSet();
        this.codeLocations = new AddressSet();
        this.postreqFailedResult = new AddressSet();
        this.funcResult = new AddressSet();
        if (this.explicitState != null) {
            return this.explicitState;
        }
        if (this.rootState != null) {
            return this.rootState;
        }
        ArrayList<Object> patternlist = new ArrayList();
        try {
            ProgramDecisionTree patternDecisionTree = this.getPatternDecisionTree();
            ResourceFile[] fileList = Patterns.findPatternFiles(program, patternDecisionTree);
            patternlist = this.readPatterns(fileList, program);
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)"Couldn't load pattern files", (Throwable)e);
            return null;
        }
        if (patternlist == null) {
            return null;
        }
        if (patternlist.size() == 0) {
            return null;
        }
        SequenceSearchState root = SequenceSearchState.buildStateMachine(patternlist);
        return root;
    }

    private ArrayList<Pattern> readPatterns(ResourceFile[] filelist, Program program) {
        ArrayList<Pattern> patlist = new ArrayList<Pattern>();
        boolean success = true;
        for (ResourceFile element : filelist) {
            try {
                Pattern.readPatterns((ResourceFile)element, patlist, (PatternFactory)this);
            }
            catch (Exception e) {
                Msg.error((Object)((Object)this), (Object)("Pattern file error (" + element.getAbsolutePath() + ")"), (Throwable)e);
                success = false;
            }
        }
        if (!success) {
            return null;
        }
        return patlist;
    }

    public MatchAction getMatchActionByName(String nm) {
        if (nm.equals("funcstart")) {
            return new FunctionStartAction();
        }
        if (nm.equals("possiblefuncstart")) {
            return new PossibleFunctionStartAction();
        }
        if (nm.equals("codeboundary")) {
            return new CodeBoundaryAction();
        }
        if (nm.equals("setcontext")) {
            return new ContextAction();
        }
        return null;
    }

    public PostRule getPostRuleByName(String nm) {
        if (nm.equals("align")) {
            return new AlignRule();
        }
        return null;
    }

    public class FunctionStartAction
    implements MatchAction {
        private static final int MUST_HAVE_VALID_INSTRUCTIONS_NO_MIN = -1;
        private static final int VALID_INSTRUCTIONS_NO_MAX = -1;
        private static final int NO_VALID_INSTRUCTIONS_REQUIRED = 0;
        private String afterName = null;
        private int validCodeMin = 0;
        private int validCodeMax = -1;
        private String label = null;
        private boolean isThunk = false;
        private boolean noreturn = false;
        private java.util.regex.Pattern sectionNamePattern = null;
        boolean validFunction = false;
        private boolean contiguous = true;

        public void apply(Program program, Address addr, Match match) {
            if (!this.checkPreRequisites(program, addr)) {
                FunctionStartAnalyzer.this.contextValueList = null;
                return;
            }
            this.applyActionToSet(program, addr, FunctionStartAnalyzer.this.funcResult, match);
            FunctionStartAnalyzer.this.contextValueList = null;
        }

        protected boolean checkPreRequisites(Program program, Address addr) {
            Function func;
            if (this.sectionNamePattern != null) {
                MemoryBlock block = program.getMemory().getBlock(addr);
                if (block == null) {
                    return false;
                }
                Matcher m = this.sectionNamePattern.matcher(block.getName());
                if (!m.matches()) {
                    return false;
                }
            }
            if (this.validFunction && (func = program.getFunctionManager().getFunctionAt(addr)) == null) {
                FunctionStartAnalyzer.this.postreqFailedResult.add(addr);
                FunctionStartAnalyzer.this.potentialMatchAddressSetPropertyMap.add(addr, addr);
                return false;
            }
            if (!this.checkAfterName(program, addr)) {
                FunctionStartAnalyzer.this.postreqFailedResult.add(addr);
                return false;
            }
            if (this.validCodeMin != 0) {
                PseudoDisassembler pseudoDisassembler = new PseudoDisassembler(program);
                PseudoDisassemblerContext pcont = new PseudoDisassemblerContext(program.getProgramContext());
                FunctionStartAnalyzer.this.setDisassemblerContext(program, pcont, addr);
                boolean isvalid = false;
                if (this.validCodeMin == -1) {
                    if (this.validCodeMax > 0) {
                        pseudoDisassembler.setMaxInstructions(this.validCodeMax);
                    }
                    isvalid = pseudoDisassembler.checkValidSubroutine(addr, pcont, true, true, this.contiguous);
                } else {
                    if (this.validCodeMax > 0) {
                        pseudoDisassembler.setMaxInstructions(this.validCodeMax);
                    }
                    isvalid = pseudoDisassembler.checkValidSubroutine(addr, pcont, true, false, this.contiguous);
                    int instrCount = pseudoDisassembler.getLastCheckValidInstructionCount();
                    if (instrCount < this.validCodeMin) {
                        isvalid = false;
                    }
                }
                return isvalid;
            }
            return true;
        }

        protected void applyActionToSet(Program program, Address addr, AddressSet resultSet, Match match) {
            String labelStr;
            if (addr.getOffset() % (long)program.getLanguage().getInstructionAlignment() != 0L) {
                return;
            }
            Listing listing = program.getListing();
            CodeUnit cu = listing.getCodeUnitContaining(addr);
            Function func = listing.getFunctionContaining(addr);
            if (cu != null) {
                if (cu instanceof Data) {
                    if (!((Data)cu).isDefined()) {
                        FunctionStartAnalyzer.this.setCurrentContext(program, addr);
                        FunctionStartAnalyzer.this.disassemResult.add(addr);
                        FunctionStartAnalyzer.this.codeLocations.add(addr);
                        resultSet.add(addr);
                        this.bookmarkAction(program, addr, match);
                    }
                } else {
                    if (func == null && !this.checkAlreadyInFunctionAbove(program, addr)) {
                        resultSet.add(addr);
                        this.bookmarkAction(program, addr, match);
                    }
                    FunctionStartAnalyzer.this.codeLocations.add(addr);
                }
            }
            if (func != null && this.noreturn) {
                func.setNoReturn(true);
            }
            if (func != null && this.isThunk && !func.isThunk()) {
                CreateThunkFunctionCmd createThunkFunctionCmd = new CreateThunkFunctionCmd(addr, false);
                createThunkFunctionCmd.applyTo((DomainObject)program);
            }
            if (this.label != null && this.setFunctionLabel(program, addr, labelStr = this.label) && func != null) {
                AutoAnalysisManager analysisManager = AutoAnalysisManager.getAnalysisManager((Program)program);
                analysisManager.functionDefined((AddressSetView)new AddressSet(addr));
            }
        }

        private boolean setFunctionLabel(Program program, Address addr, String labelStr) {
            boolean createdSym = false;
            SymbolTable symTable = program.getSymbolTable();
            Symbol sym = null;
            try {
                Symbol[] symbols;
                for (Symbol symbol : symbols = symTable.getSymbols(addr)) {
                    if (!symbol.getName().contains(labelStr)) continue;
                    return false;
                }
                sym = symTable.createLabel(addr, labelStr, null, SourceType.ANALYSIS);
                createdSym = true;
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            if (sym != null) {
                sym.setPrimary();
            }
            return createdSym;
        }

        private boolean checkAfterName(Program program, Address addr) {
            if (this.afterName != null) {
                Address addrToCheck = addr.previous();
                if (addrToCheck == null || !program.getMemory().contains(addrToCheck)) {
                    return true;
                }
                MemoryBlock block = program.getMemory().getBlock(addr);
                if (block.getStart().equals((Object)addr)) {
                    return true;
                }
                String name = this.afterName;
                if (name.startsWith("func")) {
                    Function funcAbove = this.getFunctionAbove(program, addr);
                    if (funcAbove == null) {
                        return false;
                    }
                    if (this.checkAlreadyInFunctionAbove(program, addr, funcAbove)) {
                        return false;
                    }
                } else if (name.startsWith("inst")) {
                    Instruction instr = program.getListing().getInstructionContaining(addrToCheck);
                    if (instr == null) {
                        return false;
                    }
                } else if (name.startsWith("data")) {
                    Data data = program.getListing().getDefinedDataContaining(addrToCheck);
                    if (data == null) {
                        return false;
                    }
                } else {
                    if (name.startsWith("ptr")) {
                        return this.pureDataReferencesOnly(program, addr);
                    }
                    if (name.startsWith("def")) {
                        Instruction instr = program.getListing().getInstructionContaining(addrToCheck);
                        if (instr != null) {
                            return !this.checkAlreadyInFunctionAbove(program, addr);
                        }
                        Data data = program.getListing().getDefinedDataContaining(addrToCheck);
                        if (data != null) {
                            return true;
                        }
                        return this.pureDataReferencesOnly(program, addr);
                    }
                }
            }
            return true;
        }

        private boolean pureDataReferencesOnly(Program program, Address addrToCheck) {
            ReferenceIterator referencesTo = program.getReferenceManager().getReferencesTo(addrToCheck);
            if (!referencesTo.hasNext()) {
                return false;
            }
            for (Reference reference : referencesTo) {
                RefType refType = reference.getReferenceType();
                if (refType.isFlow()) {
                    return false;
                }
                if (refType.isRead() || refType.isWrite()) {
                    return false;
                }
                if (refType.isData()) continue;
                return false;
            }
            return true;
        }

        private boolean checkAlreadyInFunctionAbove(Program program, Address addr) {
            Function funcAbove = this.getFunctionAbove(program, addr);
            return this.checkAlreadyInFunctionAbove(program, addr, funcAbove);
        }

        private boolean checkAlreadyInFunctionAbove(Program program, Address addr, Function funcAbove) {
            Address addrBefore = addr.previous();
            if (addrBefore == null) {
                return false;
            }
            if (funcAbove != null) {
                Function myfunc = program.getFunctionManager().getFunctionContaining(addr);
                return myfunc != null && myfunc.getEntryPoint().equals((Object)funcAbove.getEntryPoint());
            }
            Instruction instr = program.getListing().getInstructionContaining(addrBefore);
            if (instr != null && addr.equals((Object)instr.getFallThrough())) {
                return true;
            }
            ReferenceIterator referencesTo = program.getReferenceManager().getReferencesTo(addr);
            for (Reference reference : referencesTo) {
                RefType referenceType = reference.getReferenceType();
                if (referenceType.isData() && !referenceType.isRead() && !referenceType.isWrite()) continue;
                return true;
            }
            return false;
        }

        private Function getFunctionAbove(Program program, Address addr) {
            Function func = null;
            Address addrBefore = addr.previous();
            if (addrBefore == null) {
                return null;
            }
            func = program.getFunctionManager().getFunctionContaining(addrBefore);
            return func;
        }

        void bookmarkAction(Program program, Address addr, Match match) {
            if (FunctionStartAnalyzer.this.setbookmark) {
                BookmarkManager bookmarkManager = program.getBookmarkManager();
                bookmarkManager.setBookmark(addr, "Analysis", FunctionStartAnalyzer.this.getName(), "Match pattern " + match.getSequenceIndex());
            }
        }

        public void restoreXml(XmlPullParser parser) {
            XmlElement el = parser.start(new String[]{"funcstart"});
            this.restoreXmlAttributes(el);
            parser.end();
        }

        protected void restoreXmlAttributes(XmlElement el) {
            Map attributes = el.getAttributes();
            Set keySet = attributes.keySet();
            block20: for (String attrName : keySet) {
                String attrValue = (String)attributes.get(attrName);
                switch (attrName = attrName.toLowerCase()) {
                    case "after": {
                        this.afterName = attrValue;
                        if (this.afterName.startsWith("func")) {
                            FunctionStartAnalyzer.this.hasCodeConstraints = true;
                            continue block20;
                        }
                        if (this.afterName.startsWith("inst")) {
                            FunctionStartAnalyzer.this.hasCodeConstraints = true;
                            continue block20;
                        }
                        if (this.afterName.startsWith("data")) {
                            FunctionStartAnalyzer.this.hasDataConstraints = true;
                            continue block20;
                        }
                        if (this.afterName.startsWith("ptr")) {
                            FunctionStartAnalyzer.this.hasDataConstraints = true;
                            continue block20;
                        }
                        if (this.afterName.startsWith("def")) {
                            FunctionStartAnalyzer.this.hasDataConstraints = true;
                            FunctionStartAnalyzer.this.hasCodeConstraints = true;
                            continue block20;
                        }
                        Msg.error((Object)this, (Object)"funcstart pattern attribute 'after' must be one of 'function', 'instruction', 'data', 'defined'");
                        continue block20;
                    }
                    case "validcode": {
                        String validcodeStr = attrValue;
                        if (validcodeStr.equals("0") || validcodeStr.equals("false")) {
                            this.validCodeMin = 0;
                        } else if (validcodeStr.equalsIgnoreCase("true") || validcodeStr.equalsIgnoreCase("subroutine")) {
                            this.validCodeMin = -1;
                        } else if (validcodeStr.equalsIgnoreCase("function")) {
                            this.validFunction = true;
                            FunctionStartAnalyzer.this.hasFunctionStartConstraints = true;
                            this.validCodeMin = 0;
                        } else {
                            this.validCodeMin = Integer.parseInt(validcodeStr);
                        }
                        if (this.validCodeMax != -1) continue block20;
                        this.validCodeMax = this.validCodeMin;
                        continue block20;
                    }
                    case "validcodemax": {
                        String validcodeMaxStr = attrValue;
                        this.validCodeMax = Integer.parseInt(validcodeMaxStr);
                        if (this.validCodeMin != 0) continue block20;
                        this.validCodeMin = -1;
                        continue block20;
                    }
                    case "contiguous": {
                        String fallThruOnlyStr = attrValue;
                        this.contiguous = true;
                        if (fallThruOnlyStr.equalsIgnoreCase("false")) {
                            this.contiguous = false;
                            continue block20;
                        }
                        if (fallThruOnlyStr.equalsIgnoreCase("true")) {
                            this.contiguous = true;
                            continue block20;
                        }
                        Msg.error((Object)this, (Object)("Bad contiguous option (true,false): " + attrName + " = " + attrValue));
                        continue block20;
                    }
                    case "label": {
                        String name;
                        this.label = name = attrValue;
                        continue block20;
                    }
                    case "thunk": {
                        this.isThunk = true;
                        continue block20;
                    }
                    case "section": {
                        this.sectionNamePattern = java.util.regex.Pattern.compile(attrValue);
                        continue block20;
                    }
                    case "noreturn": {
                        this.noreturn = true;
                        continue block20;
                    }
                }
                Msg.error((Object)this, (Object)("Unknown Patten option: " + attrName + " = " + attrValue));
            }
        }
    }

    public class PossibleFunctionStartAction
    extends FunctionStartAction {
        @Override
        public void apply(Program program, Address addr, Match match) {
            if (!this.checkPreRequisites(program, addr)) {
                return;
            }
            this.applyActionToSet(program, addr, FunctionStartAnalyzer.this.potentialFuncResult, match);
        }

        @Override
        void bookmarkAction(Program program, Address addr, Match match) {
            if (FunctionStartAnalyzer.this.setbookmark) {
                BookmarkManager bookmarkManager = program.getBookmarkManager();
                bookmarkManager.setBookmark(addr, "Analysis", "Possible " + FunctionStartAnalyzer.this.getName(), "Match pattern " + match.getSequenceIndex());
            }
        }

        @Override
        public void restoreXml(XmlPullParser parser) {
            XmlElement el = parser.start(new String[]{"possiblefuncstart"});
            this.restoreXmlAttributes(el);
            parser.end();
        }
    }

    public class CodeBoundaryAction
    implements MatchAction {
        public void apply(Program program, Address addr, Match match) {
            Listing listing = program.getListing();
            CodeUnit cu = listing.getCodeUnitContaining(addr);
            if (cu != null) {
                if (cu instanceof Data) {
                    if (!((Data)cu).isDefined()) {
                        FunctionStartAnalyzer.this.setCurrentContext(program, addr);
                        FunctionStartAnalyzer.this.disassemResult.add(addr);
                        FunctionStartAnalyzer.this.codeLocations.add(addr);
                    }
                } else {
                    FunctionStartAnalyzer.this.codeLocations.add(addr);
                }
            }
        }

        public void restoreXml(XmlPullParser parser) {
            parser.start(new String[]{"codeboundary"});
            parser.end();
        }
    }

    public class ContextAction
    implements MatchAction {
        private String contextRegName = null;
        private BigInteger value = null;

        public ContextAction() {
        }

        public ContextAction(String register, BigInteger value) {
            this.contextRegName = register;
            this.value = value;
        }

        public void apply(Program program, Address addr, Match match) {
            Register contextReg;
            Listing listing = program.getListing();
            CodeUnit cu = listing.getCodeUnitContaining(addr);
            if (cu != null) {
                if (cu instanceof Data) {
                    if (((Data)cu).isDefined()) {
                        return;
                    }
                } else {
                    return;
                }
            }
            if (FunctionStartAnalyzer.this.contextValueList == null) {
                FunctionStartAnalyzer.this.contextValueList = new ArrayList();
            }
            if ((contextReg = program.getProgramContext().getRegister(this.contextRegName)) != null) {
                FunctionStartAnalyzer.this.contextValueList.add(new RegisterValue(contextReg, this.value));
            }
        }

        public void restoreXml(XmlPullParser parser) {
            XmlElement el = parser.start(new String[]{"setcontext"});
            this.contextRegName = el.getAttribute("name");
            long val = SpecXmlUtils.decodeLong((String)el.getAttribute("value"));
            this.value = BigInteger.valueOf(val);
            parser.end();
        }

        public String getName() {
            return this.contextRegName;
        }

        public BigInteger getValue() {
            return this.value;
        }
    }
}

