#ifndef GOOGLE_PROTOBUF_COMPILER_RUST_MAPPING_FILE_H__
#define GOOGLE_PROTOBUF_COMPILER_RUST_MAPPING_FILE_H__

#include <string>

#include "absl/container/flat_hash_map.h"
#include "absl/status/statusor.h"
#include "google/protobuf/compiler/rust/context.h"

namespace google {
namespace protobuf {
namespace compiler {
namespace rust {

// Returns a map from import path of a .proto file to the name of the crate
// (proto_library) covering that file.
//
// This function parses a .rust_crate_mapping file generated by Bazel. The file
// contains:
//
//    <crate_name>\n
//    <number of .proto files covered by the proto_library with that name>\n
//    <import path of the first .proto file of the proto_library>\n
//    ...
//    <import path of the last .proto file of the proto_library>\n
//
// repeated for each proto_library transitively reachable from the current
// proto_library.
//
//  Note that the logic of translating the proto_library label to a crate name
//  is handled by the build system completely, protoc is only given the end
//  results. See `_render_text_crate_mapping` in
//  //third_party/protobuf/rust:aspects.bzl for how Bazel does this.
absl::StatusOr<absl::flat_hash_map<std::string, std::string>>
GetImportPathToCrateNameMap(const Options* opts);

}  // namespace rust
}  // namespace compiler
}  // namespace protobuf
}  // namespace google

#endif  // GOOGLE_PROTOBUF_COMPILER_RUST_MAPPING_FILE_H__
