/**
 * MapLibre GL JS
 * @license 3-Clause BSD. Full text of license: https://github.com/maplibre/maplibre-gl-js/blob/v5.16.0/LICENSE.txt
 */
(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.maplibregl = factory());
})(this, (function () { 'use strict';

/* eslint-disable */

var maplibregl = {};
var modules = {};
function define(moduleName, _dependencies, moduleFactory) {
    modules[moduleName] = moduleFactory;

    // to get the list of modules see generated dist/maplibre-gl-dev.js file (look for `define(` calls)
    if (moduleName !== 'index') {
        return;
    }

    // we assume that when an index module is initializing then other modules are loaded already
    var workerBundleString = 'var sharedModule = {}; (' + modules.shared + ')(sharedModule); (' + modules.worker + ')(sharedModule);'

    var sharedModule = {};
    // the order of arguments of a module factory depends on rollup (it decides who is whose dependency)
    // to check the correct order, see dist/maplibre-gl-dev.js file (look for `define(` calls)
    // we assume that for our 3 chunks it will generate 3 modules and their order is predefined like the following
    modules.shared(sharedModule);
    modules.index(maplibregl, sharedModule);

    if (typeof window !== 'undefined') {
        maplibregl.setWorkerUrl(window.URL.createObjectURL(new Blob([workerBundleString], { type: 'text/javascript' })));
    }

    return maplibregl;
};



define("shared",["exports"],(function(t){"use strict";function e(t,e,r,n){return new(r||(r=Promise))((function(i,s){function a(t){try{l(n.next(t));}catch(t){s(t);}}function o(t){try{l(n.throw(t));}catch(t){s(t);}}function l(t){var e;t.done?i(t.value):(e=t.value,e instanceof r?e:new r((function(t){t(e);}))).then(a,o);}l((n=n.apply(t,e||[])).next());}))}function r(t,e){this.x=t,this.y=e;}function n(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var i,s;"function"==typeof SuppressedError&&SuppressedError,r.prototype={clone(){return new r(this.x,this.y)},add(t){return this.clone()._add(t)},sub(t){return this.clone()._sub(t)},multByPoint(t){return this.clone()._multByPoint(t)},divByPoint(t){return this.clone()._divByPoint(t)},mult(t){return this.clone()._mult(t)},div(t){return this.clone()._div(t)},rotate(t){return this.clone()._rotate(t)},rotateAround(t,e){return this.clone()._rotateAround(t,e)},matMult(t){return this.clone()._matMult(t)},unit(){return this.clone()._unit()},perp(){return this.clone()._perp()},round(){return this.clone()._round()},mag(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals(t){return this.x===t.x&&this.y===t.y},dist(t){return Math.sqrt(this.distSqr(t))},distSqr(t){const e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle(){return Math.atan2(this.y,this.x)},angleTo(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith(t){return this.angleWithSep(t.x,t.y)},angleWithSep(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult(t){const e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add(t){return this.x+=t.x,this.y+=t.y,this},_sub(t){return this.x-=t.x,this.y-=t.y,this},_mult(t){return this.x*=t,this.y*=t,this},_div(t){return this.x/=t,this.y/=t,this},_multByPoint(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint(t){return this.x/=t.x,this.y/=t.y,this},_unit(){return this._div(this.mag()),this},_perp(){const t=this.y;return this.y=this.x,this.x=-t,this},_rotate(t){const e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this},_rotateAround(t,e){const r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=i,this},_round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},constructor:r},r.convert=function(t){if(t instanceof r)return t;if(Array.isArray(t))return new r(+t[0],+t[1]);if(void 0!==t.x&&void 0!==t.y)return new r(+t.x,+t.y);throw new Error("Expected [x, y] or {x, y} point format")};var a=function(){if(s)return i;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}return s=1,i=t,t.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var a=0,o=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?a=r:o=r,r=.5*(o-a)+a;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},i}(),o=n(a);let l,u;function c(){return null==l&&(l="undefined"!=typeof OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof createImageBitmap),l}function h(){if(null==u&&(u=!1,c())){const t=5,e=new OffscreenCanvas(t,t).getContext("2d",{willReadFrequently:!0});if(e){for(let r=0;r<t*t;r++){const n=4*r;e.fillStyle=`rgb(${n},${n+1},${n+2})`,e.fillRect(r%t,Math.floor(r/t),1,1);}const r=e.getImageData(0,0,t,t).data;for(let e=0;e<t*t*4;e++)if(e%4!=3&&r[e]!==e){u=!0;break}}}return u||!1}var p=1e-6,f="undefined"!=typeof Float32Array?Float32Array:Array;function d(){var t=new f(9);return f!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t}function y(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function m(){var t=new f(3);return f!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function g(t){var e=t[0],r=t[1],n=t[2];return Math.sqrt(e*e+r*r+n*n)}function x(t,e,r){var n=new f(3);return n[0]=t,n[1]=e,n[2]=r,n}function v(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t}function b(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t}function w(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[0],o=r[1],l=r[2];return t[0]=i*l-s*o,t[1]=s*a-n*l,t[2]=n*o-i*a,t}var _,S=g;function A(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*s+r[12]*a,t[1]=r[1]*n+r[5]*i+r[9]*s+r[13]*a,t[2]=r[2]*n+r[6]*i+r[10]*s+r[14]*a,t[3]=r[3]*n+r[7]*i+r[11]*s+r[15]*a,t}function k(){var t=new f(4);return f!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function E(t,e,r,n){var i=arguments.length>4&&void 0!==arguments[4]?arguments[4]:"zyx",s=Math.PI/360;e*=s,n*=s,r*=s;var a=Math.sin(e),o=Math.cos(e),l=Math.sin(r),u=Math.cos(r),c=Math.sin(n),h=Math.cos(n);switch(i){case "xyz":t[0]=a*u*h+o*l*c,t[1]=o*l*h-a*u*c,t[2]=o*u*c+a*l*h,t[3]=o*u*h-a*l*c;break;case "xzy":t[0]=a*u*h-o*l*c,t[1]=o*l*h-a*u*c,t[2]=o*u*c+a*l*h,t[3]=o*u*h+a*l*c;break;case "yxz":t[0]=a*u*h+o*l*c,t[1]=o*l*h-a*u*c,t[2]=o*u*c-a*l*h,t[3]=o*u*h+a*l*c;break;case "yzx":t[0]=a*u*h+o*l*c,t[1]=o*l*h+a*u*c,t[2]=o*u*c-a*l*h,t[3]=o*u*h-a*l*c;break;case "zxy":t[0]=a*u*h-o*l*c,t[1]=o*l*h+a*u*c,t[2]=o*u*c+a*l*h,t[3]=o*u*h-a*l*c;break;case "zyx":t[0]=a*u*h-o*l*c,t[1]=o*l*h+a*u*c,t[2]=o*u*c-a*l*h,t[3]=o*u*h+a*l*c;break;default:throw new Error("Unknown angle order "+i)}return t}function T(){var t=new f(2);return f!=Float32Array&&(t[0]=0,t[1]=0),t}function I(t,e){var r=new f(2);return r[0]=t,r[1]=e,r}m(),_=new f(4),f!=Float32Array&&(_[0]=0,_[1]=0,_[2]=0,_[3]=0),m(),x(1,0,0),x(0,1,0),k(),k(),d(),T();const M=8192;function F(t,e,r){return e*(M/(t.tileSize*Math.pow(2,r-t.tileID.overscaledZ)))}function D(t,e){return (t%e+e)%e}function z(t,e,r){return t*(1-r)+e*r}function P(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}function B(t,e,r,n){const i=new o(t,e,r,n);return t=>i.solve(t)}const V=B(.25,.1,.25,1);function C(t,e,r){return Math.min(r,Math.max(e,t))}function L(t,e,r){const n=r-e,i=((t-e)%n+n)%n+e;return i===e?r:i}function O(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}let R=1;function N(t,e,r){const n={};for(const r in t)n[r]=e.call(this,t[r],r,t);return n}function $(t,e,r){const n={};for(const r in t)e.call(this,t[r],r,t)&&(n[r]=t[r]);return n}function U(t){return Array.isArray(t)?t.map(U):"object"==typeof t&&t?N(t,U):t}const q={};function j(t){q[t]||("undefined"!=typeof console&&console.warn(t),q[t]=!0);}function G(t,e,r){return (r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function X(t){return "undefined"!=typeof WorkerGlobalScope&&void 0!==t&&t instanceof WorkerGlobalScope}let Y=null;function Z(t){return "undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap}const H="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";function K(t,r,n,i,s){return e(this,void 0,void 0,(function*(){if("undefined"==typeof VideoFrame)throw new Error("VideoFrame not supported");const e=new VideoFrame(t,{timestamp:0});try{const a=null==e?void 0:e.format;if(!a||!a.startsWith("BGR")&&!a.startsWith("RGB"))throw new Error(`Unrecognized format ${a}`);const o=a.startsWith("BGR"),l=new Uint8ClampedArray(i*s*4);if(yield e.copyTo(l,function(t,e,r,n,i){const s=4*Math.max(-e,0),a=(Math.max(0,r)-r)*n*4+s,o=4*n,l=Math.max(0,e),u=Math.max(0,r);return {rect:{x:l,y:u,width:Math.min(t.width,e+n)-l,height:Math.min(t.height,r+i)-u},layout:[{offset:a,stride:o}]}}(t,r,n,i,s)),o)for(let t=0;t<l.length;t+=4){const e=l[t];l[t]=l[t+2],l[t+2]=e;}return l}finally{e.close();}}))}let W,J;function Q(t,e,r,n){return t.addEventListener(e,r,n),{unsubscribe:()=>{t.removeEventListener(e,r,n);}}}function tt(t){return t*Math.PI/180}function et(t){return t/Math.PI*180}const rt={touchstart:!0,touchmove:!0,touchmoveWindow:!0,touchend:!0,touchcancel:!0},nt={dblclick:!0,click:!0,mouseover:!0,mouseout:!0,mousedown:!0,mousemove:!0,mousemoveWindow:!0,mouseup:!0,mouseupWindow:!0,contextmenu:!0,wheel:!0},it="AbortError";class st extends Error{constructor(t=it){super(t instanceof Error?t.message:t),this.name=it,t instanceof Error&&t.stack&&(this.stack=t.stack);}}function at(t){return t.name===it}const ot={MAX_PARALLEL_IMAGE_REQUESTS:16,MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:8,MAX_TILE_CACHE_ZOOM_LEVELS:5,REGISTERED_PROTOCOLS:{},WORKER_URL:""};function lt(t){return ot.REGISTERED_PROTOCOLS[t.substring(0,t.indexOf("://"))]}const ut="global-dispatcher";class ct extends Error{constructor(t,e,r,n){super(`AJAXError: ${e} (${t}): ${r}`),this.status=t,this.statusText=e,this.url=r,this.body=n;}}const ht=()=>X(self)?self.worker&&self.worker.referrer:("blob:"===window.location.protocol?window.parent:window).location.href,pt=function(t,r){if(/:\/\//.test(t.url)&&!/^https?:|^file:/.test(t.url)){const e=lt(t.url);if(e)return e(t,r);if(X(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,targetMapId:ut},r)}if(!(/^file:/.test(n=t.url)||/^file:/.test(ht())&&!/^\w+:/.test(n))){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return function(t,r){return e(this,void 0,void 0,(function*(){const e=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,cache:t.cache,referrer:ht(),signal:r.signal});let n,i;"json"!==t.type||e.headers.has("Accept")||e.headers.set("Accept","application/json");try{n=yield fetch(e);}catch(e){if(at(e))throw e;throw new ct(0,e.message,t.url,new Blob)}if(!n.ok){const e=yield n.blob();throw new ct(n.status,n.statusText,t.url,e)}i="arrayBuffer"===t.type||"image"===t.type?n.arrayBuffer():"json"===t.type?n.json():n.text();const s=yield i;return r.signal.throwIfAborted(),{data:s,cacheControl:n.headers.get("Cache-Control"),expires:n.headers.get("Expires")}}))}(t,r);if(X(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,mustQueue:!0,targetMapId:ut},r)}var n;return function(t,e){return new Promise(((r,n)=>{var i;const s=new XMLHttpRequest;s.open(t.method||"GET",t.url,!0),"arrayBuffer"!==t.type&&"image"!==t.type||(s.responseType="arraybuffer");for(const e in t.headers)s.setRequestHeader(e,t.headers[e]);"json"===t.type&&(s.responseType="text",(null===(i=t.headers)||void 0===i?void 0:i.Accept)||s.setRequestHeader("Accept","application/json")),s.withCredentials="include"===t.credentials,s.onerror=()=>{n(new Error(s.statusText));},s.onload=()=>{if(!e.signal.aborted)if((s.status>=200&&s.status<300||0===s.status)&&null!==s.response){let e=s.response;if("json"===t.type)try{e=JSON.parse(s.response);}catch(t){return void n(t)}r({data:e,cacheControl:s.getResponseHeader("Cache-Control"),expires:s.getResponseHeader("Expires")});}else {const e=new Blob([s.response],{type:s.getResponseHeader("Content-Type")});n(new ct(s.status,s.statusText,t.url,e));}},e.signal.addEventListener("abort",(()=>{s.abort(),n(new st(e.signal.reason));})),s.send(t.body);}))}(t,r)};function ft(t){if(!t||t.indexOf("://")<=0||0===t.indexOf("data:image/")||0===t.indexOf("blob:"))return !0;const e=new URL(t),r=window.location;return e.protocol===r.protocol&&e.host===r.host}function dt(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e));}function yt(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1);}}class mt{constructor(t,e={}){O(this,e),this.type=t;}}class gt extends mt{constructor(t,e={}){super("error",O({error:t},e));}}class xt{on(t,e){return this._listeners=this._listeners||{},dt(t,e,this._listeners),{unsubscribe:()=>{this.off(t,e);}}}off(t,e){return yt(t,e,this._listeners),yt(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},dt(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){"string"==typeof t&&(t=new mt(t,e||{}));const r=t.type;if(this.listens(r)){t.target=this;const e=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of e)r.call(this,t);const n=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const e of n)yt(r,e,this._oneTimeListeners),e.call(this,t);const i=this._eventedParent;i&&(O(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(t));}else t instanceof gt&&console.error(t.error);return this}listens(t){return this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t)}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}var vt={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number",length:2},centerAltitude:{type:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},roll:{type:"number",default:0,units:"degrees"},state:{type:"state",default:{}},light:{type:"light"},sky:{type:"sky"},projection:{type:"projection"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"sprite"},glyphs:{type:"string"},"font-faces":{type:"fontFaces"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},encoding:{type:"enum",values:{mvt:{},mlt:{}},default:"mvt"},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{},custom:{}},default:"mapbox"},redFactor:{type:"number",default:1},blueFactor:{type:"number",default:1},greenFactor:{type:"number",default:1},baseShift:{type:"number",default:0},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{required:!0,type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"filter"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},"color-relief":{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_color-relief","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-variable-anchor-offset":{type:"variableAnchorOffsetCollection",requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},"layout_color-relief":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible",expression:{interpolated:!1,parameters:["global-state"]},"property-type":"data-constant"}},filter:{type:"boolean",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"expression_name",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},sky:{"sky-color":{type:"color","property-type":"data-constant",default:"#88C6FC",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-ground-blend":{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-fog-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"sky-horizon-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"atmosphere-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1}},projection:{type:{type:"projectionDefinition",default:"mercator","property-type":"data-constant",transition:!1,expression:{interpolated:!0,parameters:["zoom"]}}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_color-relief","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"numberArray",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-altitude":{type:"numberArray",default:45,minimum:0,maximum:90,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"colorArray",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"colorArray",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-method":{type:"enum",values:{standard:{},basic:{},combined:{},igor:{},multidirectional:{}},default:"standard",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},"paint_color-relief":{"color-relief-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"color-relief-color":{type:"color",transition:!1,expression:{interpolated:!0,parameters:["elevation"]},"property-type":"color-ramp"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}},interpolation:{type:"array",value:"interpolation_name",minimum:1},interpolation_name:{type:"enum",values:{linear:{syntax:{overloads:[{parameters:[],"output-type":"interpolation"}],parameters:[]}},exponential:{syntax:{overloads:[{parameters:["base"],"output-type":"interpolation"}],parameters:[{name:"base",type:"number literal"}]}},"cubic-bezier":{syntax:{overloads:[{parameters:["x1","y1","x2","y2"],"output-type":"interpolation"}],parameters:[{name:"x1",type:"number literal"},{name:"y1",type:"number literal"},{name:"x2",type:"number literal"},{name:"y2",type:"number literal"}]}}}}};const bt=["type","source","source-layer","minzoom","maxzoom","filter","layout"];function wt(t,e){const r={};for(const e in t)"ref"!==e&&(r[e]=t[e]);return bt.forEach((t=>{t in e&&(r[t]=e[t]);})),r}function _t(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return !1;for(let r=0;r<t.length;r++)if(!_t(t[r],e[r]))return !1;return !0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return !1;if(Object.keys(t).length!==Object.keys(e).length)return !1;for(const r in t)if(!_t(t[r],e[r]))return !1;return !0}return t===e}function St(t,e){t.push(e);}function At(t,e,r){St(r,{command:"addSource",args:[t,e[t]]});}function kt(t,e,r){St(e,{command:"removeSource",args:[t]}),r[t]=!0;}function Et(t,e,r,n){kt(t,r,n),At(t,e,r);}function Tt(t,e,r){let n;for(n in t[r])if(Object.prototype.hasOwnProperty.call(t[r],n)&&"data"!==n&&!_t(t[r][n],e[r][n]))return !1;for(n in e[r])if(Object.prototype.hasOwnProperty.call(e[r],n)&&"data"!==n&&!_t(t[r][n],e[r][n]))return !1;return !0}function It(t,e,r,n,i,s){t=t||{},e=e||{};for(const a in t)Object.prototype.hasOwnProperty.call(t,a)&&(_t(t[a],e[a])||r.push({command:s,args:[n,a,e[a],i]}));for(const a in e)Object.prototype.hasOwnProperty.call(e,a)&&!Object.prototype.hasOwnProperty.call(t,a)&&(_t(t[a],e[a])||r.push({command:s,args:[n,a,e[a],i]}));}function Mt(t){return t.id}function Ft(t,e){return t[e.id]=e,t}class Dt{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r,n&&(this.identifier=n),null!=e&&e.__line__&&(this.line=e.__line__);}}function zt(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}class Pt extends Error{constructor(t,e){super(e),this.message=e,this.key=t;}}class Bt{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new Bt(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return !!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const Vt={kind:"null"},Ct={kind:"number"},Lt={kind:"string"},Ot={kind:"boolean"},Rt={kind:"color"},Nt={kind:"projectionDefinition"},$t={kind:"object"},Ut={kind:"value"},qt={kind:"collator"},jt={kind:"formatted"},Gt={kind:"padding"},Xt={kind:"colorArray"},Yt={kind:"numberArray"},Zt={kind:"resolvedImage"},Ht={kind:"variableAnchorOffsetCollection"};function Kt(t,e){return {kind:"array",itemType:t,N:e}}function Wt(t){if("array"===t.kind){const e=Wt(t.itemType);return "number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const Jt=[Vt,Ct,Lt,Ot,Rt,Nt,jt,$t,Kt(Ut),Gt,Yt,Xt,Zt,Ht];function Qt(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!Qt(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else {if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of Jt)if(!Qt(t,e))return null}return `Expected ${Wt(t)} but found ${Wt(e)} instead.`}function te(t,e){return e.some((e=>e.kind===t.kind))}function ee(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}function re(t,e){return "array"===t.kind&&"array"===e.kind?t.itemType.kind===e.itemType.kind&&"number"==typeof t.N:t.kind===e.kind}const ne=.96422,ie=.82521,se=4/29,ae=6/29,oe=3*ae*ae,le=ae*ae*ae,ue=Math.PI/180,ce=180/Math.PI;function he(t){return (t%=360)<0&&(t+=360),t}function pe([t,e,r,n]){let i,s;const a=de((.2225045*(t=fe(t))+.7168786*(e=fe(e))+.0606169*(r=fe(r)))/1);t===e&&e===r?i=s=a:(i=de((.4360747*t+.3850649*e+.1430804*r)/ne),s=de((.0139322*t+.0971045*e+.7141733*r)/ie));const o=116*a-16;return [o<0?0:o,500*(i-a),200*(a-s),n]}function fe(t){return t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function de(t){return t>le?Math.pow(t,1/3):t/oe+se}function ye([t,e,r,n]){let i=(t+16)/116,s=isNaN(e)?i:i+e/500,a=isNaN(r)?i:i-r/200;return i=1*ge(i),s=ne*ge(s),a=ie*ge(a),[me(3.1338561*s-1.6168667*i-.4906146*a),me(-.9787684*s+1.9161415*i+.033454*a),me(.0719453*s-.2289914*i+1.4052427*a),n]}function me(t){return (t=t<=.00304?12.92*t:1.055*Math.pow(t,1/2.4)-.055)<0?0:t>1?1:t}function ge(t){return t>ae?t*t*t:oe*(t-se)}const xe=Object.hasOwn||function(t,e){return Object.prototype.hasOwnProperty.call(t,e)};function ve(t,e){return xe(t,e)?t[e]:void 0}function be(t){return parseInt(t.padEnd(2,t),16)/255}function we(t,e){return _e(e?t/100:t,0,1)}function _e(t,e,r){return Math.min(Math.max(e,t),r)}function Se(t){return !t.some(Number.isNaN)}const Ae={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};function ke(t,e,r){return t+r*(e-t)}function Ee(t,e,r){return t.map(((t,n)=>ke(t,e[n],r)))}class Te{constructor(t,e,r,n=1,i=!0){this.r=t,this.g=e,this.b=r,this.a=n,i||(this.r*=n,this.g*=n,this.b*=n,n||this.overwriteGetter("rgb",[t,e,r,n]));}static parse(t){if(t instanceof Te)return t;if("string"!=typeof t)return;const e=function(t){if("transparent"===(t=t.toLowerCase().trim()))return [0,0,0,0];const e=ve(Ae,t);if(e){const[t,r,n]=e;return [t/255,r/255,n/255,1]}if(t.startsWith("#")&&/^#(?:[0-9a-f]{3,4}|[0-9a-f]{6}|[0-9a-f]{8})$/.test(t)){const e=t.length<6?1:2;let r=1;return [be(t.slice(r,r+=e)),be(t.slice(r,r+=e)),be(t.slice(r,r+=e)),be(t.slice(r,r+e)||"ff")]}if(t.startsWith("rgb")){const e=t.match(/^rgba?\(\s*([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(e){const[t,r,n,i,s,a,o,l,u,c,h,p]=e,f=[i||" ",o||" ",c].join("");if("  "===f||"  /"===f||",,"===f||",,,"===f){const t=[n,a,u].join(""),e="%%%"===t?100:""===t?255:0;if(e){const t=[_e(+r/e,0,1),_e(+s/e,0,1),_e(+l/e,0,1),h?we(+h,p):1];if(Se(t))return t}}return}}const r=t.match(/^hsla?\(\s*([\de.+-]+)(?:deg)?(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(r){const[t,e,n,i,s,a,o,l,u]=r,c=[n||" ",s||" ",o].join("");if("  "===c||"  /"===c||",,"===c||",,,"===c){const t=[+e,_e(+i,0,100),_e(+a,0,100),l?we(+l,u):1];if(Se(t))return function([t,e,r,n]){function i(n){const i=(n+t/30)%12,s=e*Math.min(r,1-r);return r-s*Math.max(-1,Math.min(i-3,9-i,1))}return t=he(t),e/=100,r/=100,[i(0),i(8),i(4),n]}(t)}}}(t);return e?new Te(...e,!1):void 0}get rgb(){const{r:t,g:e,b:r,a:n}=this,i=n||1/0;return this.overwriteGetter("rgb",[t/i,e/i,r/i,n])}get hcl(){return this.overwriteGetter("hcl",function(t){const[e,r,n,i]=pe(t),s=Math.sqrt(r*r+n*n);return [Math.round(1e4*s)?he(Math.atan2(n,r)*ce):NaN,s,e,i]}(this.rgb))}get lab(){return this.overwriteGetter("lab",pe(this.rgb))}overwriteGetter(t,e){return Object.defineProperty(this,t,{value:e}),e}toString(){const[t,e,r,n]=this.rgb;return `rgba(${[t,e,r].map((t=>Math.round(255*t))).join(",")},${n})`}static interpolate(t,e,r,n="rgb"){switch(n){case "rgb":{const[n,i,s,a]=Ee(t.rgb,e.rgb,r);return new Te(n,i,s,a,!1)}case "hcl":{const[n,i,s,a]=t.hcl,[o,l,u,c]=e.hcl;let h,p;if(isNaN(n)||isNaN(o))isNaN(n)?isNaN(o)?h=NaN:(h=o,1!==s&&0!==s||(p=l)):(h=n,1!==u&&0!==u||(p=i));else {let t=o-n;o>n&&t>180?t-=360:o<n&&n-o>180&&(t+=360),h=n+r*t;}const[f,d,y,m]=function([t,e,r,n]){return t=isNaN(t)?0:t*ue,ye([r,Math.cos(t)*e,Math.sin(t)*e,n])}([h,null!=p?p:ke(i,l,r),ke(s,u,r),ke(a,c,r)]);return new Te(f,d,y,m,!1)}case "lab":{const[n,i,s,a]=ye(Ee(t.lab,e.lab,r));return new Te(n,i,s,a,!1)}}}}Te.black=new Te(0,0,0,1),Te.white=new Te(1,1,1,1),Te.transparent=new Te(0,0,0,0),Te.red=new Te(1,0,0,1);class Ie{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}const Me=["bottom","center","top"];class Fe{constructor(t,e,r,n,i,s){this.text=t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=i,this.verticalAlign=s;}}class De{constructor(t){this.sections=t;}static fromString(t){return new De([new Fe(t,null,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.name.length))}static factory(t){return t instanceof De?t:De.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}}class ze{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof ze)return t;if("number"==typeof t)return new ze([t,t,t,t]);if(Array.isArray(t)&&!(t.length<1||t.length>4)){for(const e of t)if("number"!=typeof e)return;switch(t.length){case 1:t=[t[0],t[0],t[0],t[0]];break;case 2:t=[t[0],t[1],t[0],t[1]];break;case 3:t=[t[0],t[1],t[2],t[1]];}return new ze(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r){return new ze(Ee(t.values,e.values,r))}}class Pe{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof Pe)return t;if("number"==typeof t)return new Pe([t]);if(Array.isArray(t)){for(const e of t)if("number"!=typeof e)return;return new Pe(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r){return new Pe(Ee(t.values,e.values,r))}}class Be{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof Be)return t;if("string"==typeof t){const e=Te.parse(t);if(!e)return;return new Be([e])}if(!Array.isArray(t))return;const e=[];for(const r of t){if("string"!=typeof r)return;const t=Te.parse(r);if(!t)return;e.push(t);}return new Be(e)}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r,n="rgb"){const i=[];if(t.values.length!=e.values.length)throw new Error(`colorArray: Arrays have mismatched length (${t.values.length} vs. ${e.values.length}), cannot interpolate.`);for(let s=0;s<t.values.length;s++)i.push(Te.interpolate(t.values[s],e.values[s],r,n));return new Be(i)}}class Ve extends Error{constructor(t){super(t),this.name="RuntimeError";}toJSON(){return this.message}}const Ce=new Set(["center","left","right","top","bottom","top-left","top-right","bottom-left","bottom-right"]);class Le{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof Le)return t;if(Array.isArray(t)&&!(t.length<1)&&t.length%2==0){for(let e=0;e<t.length;e+=2){const r=t[e],n=t[e+1];if("string"!=typeof r||!Ce.has(r))return;if(!Array.isArray(n)||2!==n.length||"number"!=typeof n[0]||"number"!=typeof n[1])return}return new Le(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r){const n=t.values,i=e.values;if(n.length!==i.length)throw new Ve(`Cannot interpolate values of different length. from: ${t.toString()}, to: ${e.toString()}`);const s=[];for(let t=0;t<n.length;t+=2){if(n[t]!==i[t])throw new Ve(`Cannot interpolate values containing mismatched anchors. from[${t}]: ${n[t]}, to[${t}]: ${i[t]}`);s.push(n[t]);const[e,a]=n[t+1],[o,l]=i[t+1];s.push([ke(e,o,r),ke(a,l,r)]);}return new Le(s)}}class Oe{constructor(t){this.name=t.name,this.available=t.available;}toString(){return this.name}static fromString(t){return t?new Oe({name:t,available:!1}):null}}class Re{constructor(t,e,r){this.from=t,this.to=e,this.transition=r;}static interpolate(t,e,r){return new Re(t,e,r)}static parse(t){return t instanceof Re?t:Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]?new Re(t[0],t[1],t[2]):"object"==typeof t&&"string"==typeof t.from&&"string"==typeof t.to&&"number"==typeof t.transition?new Re(t.from,t.to,t.transition):"string"==typeof t?new Re(t,t,1):void 0}}function Ne(t,e,r,n){return "number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function $e(t){if(null===t||"string"==typeof t||"boolean"==typeof t||"number"==typeof t||t instanceof Re||t instanceof Te||t instanceof Ie||t instanceof De||t instanceof ze||t instanceof Pe||t instanceof Be||t instanceof Le||t instanceof Oe)return !0;if(Array.isArray(t)){for(const e of t)if(!$e(e))return !1;return !0}if("object"==typeof t){for(const e in t)if(!$e(t[e]))return !1;return !0}return !1}function Ue(t){if(null===t)return Vt;if("string"==typeof t)return Lt;if("boolean"==typeof t)return Ot;if("number"==typeof t)return Ct;if(t instanceof Te)return Rt;if(t instanceof Re)return Nt;if(t instanceof Ie)return qt;if(t instanceof De)return jt;if(t instanceof ze)return Gt;if(t instanceof Pe)return Yt;if(t instanceof Be)return Xt;if(t instanceof Le)return Ht;if(t instanceof Oe)return Zt;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=Ue(e);if(r){if(r===t)continue;r=Ut;break}r=t;}return Kt(r||Ut,e)}return $t}function qe(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof Te||t instanceof Re||t instanceof De||t instanceof ze||t instanceof Pe||t instanceof Be||t instanceof Le||t instanceof Oe?t.toString():JSON.stringify(t)}class je{constructor(t,e){this.type=t,this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!$e(t[1]))return e.error("invalid value");const r=t[1];let n=Ue(r);const i=e.expectedType;return "array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new je(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}}const Ge={string:Lt,number:Ct,boolean:Ot,object:$t};class Xe{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,s;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in Ge)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=Ge[r],n++;}else i=Ut;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],n++;}r=Kt(i,s);}else {if(!Ge[i])throw new Error(`Types doesn't contain name = ${i}`);r=Ge[i];}const s=[];for(;n<t.length;n++){const r=e.parse(t[n],n,Ut);if(!r)return null;s.push(r);}return new Xe(r,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!Qt(this.type,Ue(r)))return r;if(e===this.args.length-1)throw new Ve(`Expected value to be of type ${Wt(this.type)}, but found ${Wt(Ue(r))} instead.`)}throw new Error}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const Ye={"to-boolean":Ot,"to-color":Rt,"to-number":Ct,"to-string":Lt};class Ze{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0];if(!Ye[r])throw new Error(`Can't parse ${r} as it is not part of the known types`);if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");const n=Ye[r],i=[];for(let r=1;r<t.length;r++){const n=e.parse(t[r],r,Ut);if(!n)return null;i.push(n);}return new Ze(n,i)}evaluate(t){switch(this.type.kind){case "boolean":return Boolean(this.args[0].evaluate(t));case "color":{let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof Te)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rgba value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:Ne(e[0],e[1],e[2],e[3]),!r))return new Te(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new Ve(r||`Could not parse color from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case "padding":{let e;for(const r of this.args){e=r.evaluate(t);const n=ze.parse(e);if(n)return n}throw new Ve(`Could not parse padding from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case "numberArray":{let e;for(const r of this.args){e=r.evaluate(t);const n=Pe.parse(e);if(n)return n}throw new Ve(`Could not parse numberArray from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case "colorArray":{let e;for(const r of this.args){e=r.evaluate(t);const n=Be.parse(e);if(n)return n}throw new Ve(`Could not parse colorArray from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case "variableAnchorOffsetCollection":{let e;for(const r of this.args){e=r.evaluate(t);const n=Le.parse(e);if(n)return n}throw new Ve(`Could not parse variableAnchorOffsetCollection from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case "number":{let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new Ve(`Could not convert ${JSON.stringify(e)} to number.`)}case "formatted":return De.fromString(qe(this.args[0].evaluate(t)));case "resolvedImage":return Oe.fromString(qe(this.args[0].evaluate(t)));case "projectionDefinition":return this.args[0].evaluate(t);default:return qe(this.args[0].evaluate(t))}}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const He=["Unknown","Point","LineString","Polygon"];class Ke{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache=new Map,this.availableImages=null,this.canonical=null;}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?He[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(t){let e=this._parseColorCache.get(t);return e||(e=Te.parse(t),this._parseColorCache.set(t,e)),e}}class We{constructor(t,e,r=[],n,i=new Bt,s=[]){this.registry=t,this.path=r,this.key=r.map((t=>`[${t}]`)).join(""),this.scope=i,this.errors=s,this.expectedType=n,this._isConstant=e;}parse(t,e,r,n,i={}){return e?this.concat(e,r,n)._parse(t,i):this._parse(t,i)}_parse(t,e){function r(t,e,r){return "assert"===r?new Xe(e,[t]):"coerce"===r?new Ze(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n=t[0];if("string"!=typeof n)return this.error(`Expression name must be a string, but found ${typeof n} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const i=this.registry[n];if(i){let n=i.parse(t,this);if(!n)return null;if(this.expectedType){const t=this.expectedType,i=n.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==i.kind){if("projectionDefinition"===t.kind&&["string","array"].includes(i.kind)||["color","formatted","resolvedImage"].includes(t.kind)&&["value","string"].includes(i.kind)||["padding","numberArray"].includes(t.kind)&&["value","number","array"].includes(i.kind)||"colorArray"===t.kind&&["value","string","array"].includes(i.kind)||"variableAnchorOffsetCollection"===t.kind&&["value","array"].includes(i.kind))n=r(n,t,e.typeAnnotation||"coerce");else if(this.checkSubtype(t,i))return null}else n=r(n,t,e.typeAnnotation||"assert");}if(!(n instanceof je)&&"resolvedImage"!==n.type.kind&&this._isConstant(n)){const t=new Ke;try{n=new je(n.type,n.evaluate(t));}catch(t){return this.error(t.message),null}}return n}return this.error(`Unknown expression "${n}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r){const n="number"==typeof t?this.path.concat(t):this.path,i=r?this.scope.concat(r):this.scope;return new We(this.registry,this._isConstant,n,e||null,i,this.errors)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new Pt(r,t));}checkSubtype(t,e){const r=Qt(t,e);return r&&this.error(r),r}}class Je{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e;}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const s=e.parse(t[n+1],n+1);if(!s)return null;r.push([i,s]);}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new Je(r,n):null}outputDefined(){return this.result.outputDefined()}}class Qe{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new Qe(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return !1}}class tr{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ct),n=e.parse(t[2],2,Kt(e.expectedType||Ut));return r&&n?new tr(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new Ve(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new Ve(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new Ve(`Array index must be an integer, but found ${e} instead.`);return r[e]}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}}class er{constructor(t,e){this.type=Ot,this.needle=t,this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ut),n=e.parse(t[2],2,Ut);return r&&n?te(r.type,[Ot,Lt,Ct,Vt,Ut])?new er(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Wt(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!r)return !1;if(!ee(e,["boolean","string","number","null"]))throw new Ve(`Expected first argument to be of type boolean, string, number or null, but found ${Wt(Ue(e))} instead.`);if(!ee(r,["string","array"]))throw new Ve(`Expected second argument to be of type array or string, but found ${Wt(Ue(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack);}outputDefined(){return !0}}class rr{constructor(t,e,r){this.type=Ct,this.needle=t,this.haystack=e,this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 2 or 3 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ut),n=e.parse(t[2],2,Ut);if(!r||!n)return null;if(!te(r.type,[Ot,Lt,Ct,Vt,Ut]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${Wt(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,Ct);return i?new rr(r,n,i):null}return new rr(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!ee(e,["boolean","string","number","null"]))throw new Ve(`Expected first argument to be of type boolean, string, number or null, but found ${Wt(Ue(e))} instead.`);let n;if(this.fromIndex&&(n=this.fromIndex.evaluate(t)),ee(r,["string"])){const t=r.indexOf(e,n);return -1===t?-1:[...r.slice(0,t)].length}if(ee(r,["array"]))return r.indexOf(e,n);throw new Ve(`Expected second argument to be of type array or string, but found ${Wt(Ue(r))} instead.`)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex);}outputDefined(){return !1}}class nr{constructor(t,e,r,n,i,s){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=i,this.otherwise=s;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},s=[];for(let a=2;a<t.length-1;a+=2){let o=t[a];const l=t[a+1];Array.isArray(o)||(o=[o]);const u=e.concat(a);if(0===o.length)return u.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,Ue(t)))return null}else r=Ue(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=s.length;}const c=e.parse(l,a,n);if(!c)return null;n=n||c.type,s.push(c);}const a=e.parse(t[1],1,Ut);if(!a)return null;const o=e.parse(t[t.length-1],t.length-1,n);return o?"value"!==a.type.kind&&e.concat(1).checkSubtype(r,a.type)?null:new nr(r,n,a,i,s,o):null}evaluate(t){const e=this.input.evaluate(t);return (Ue(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}}class ir{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const s=e.parse(t[i],i,Ot);if(!s)return null;const a=e.parse(t[i+1],i+1,r);if(!a)return null;n.push([s,a]),r=r||a.type;}const i=e.parse(t[t.length-1],t.length-1,r);if(!i)return null;if(!r)throw new Error("Can't infer output type");return new ir(r,n,i)}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise);}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}}class sr{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 2 or 3 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Ut),n=e.parse(t[2],2,Ct);if(!r||!n)return null;if(!te(r.type,[Kt(Ut),Lt,Ut]))return e.error(`Expected first argument to be of type array or string, but found ${Wt(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,Ct);return i?new sr(r.type,r,n,i):null}return new sr(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);let n;if(this.endIndex&&(n=this.endIndex.evaluate(t)),ee(e,["string"]))return [...e].slice(r,n).join("");if(ee(e,["array"]))return e.slice(r,n);throw new Ve(`Expected first argument to be of type array or string, but found ${Wt(Ue(e))} instead.`)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex);}outputDefined(){return !1}}function ar(t,e){const r=t.length-1;let n,i,s=0,a=r,o=0;for(;s<=a;)if(o=Math.floor((s+a)/2),n=t[o],i=t[o+1],n<=e){if(o===r||e<i)return o;s=o+1;}else {if(!(n>e))throw new Ve("Input is not a number.");a=o-1;}return 0}class or{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,Ct);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const s=1===r?-1/0:t[r],a=t[r+1],o=r,l=r+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(n.length&&n[n.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const u=e.parse(a,l,i);if(!u)return null;i=i||u.type,n.push([s,u]);}return new or(i,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[ar(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function lr(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var ur,cr,hr=function(){if(cr)return ur;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}return cr=1,ur=t,t.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var a=0,o=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?a=r:o=r,r=.5*(o-a)+a;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},ur}(),pr=lr(hr);class fr{constructor(t,e,r,n,i){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e);}static interpolationFactor(t,e,r,n){let i=0;if("exponential"===t.name)i=dr(e,t.base,r,n);else if("linear"===t.name)i=dr(e,1,r,n);else if("cubic-bezier"===t.name){const s=t.controlPoints;i=new pr(s[0],s[1],s[2],s[3]).solve(dr(e,1,r,n));}return i}static parse(t,e){let[r,n,i,...s]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t};}else {if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,Ct),!i)return null;const a=[];let o=null;"interpolate-hcl"!==r&&"interpolate-lab"!==r||e.expectedType==Xt?e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType):o=Rt;for(let t=0;t<s.length;t+=2){const r=s[t],n=s[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(a.length&&a[a.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,o);if(!u)return null;o=o||u.type,a.push([r,u]);}return re(o,Ct)||re(o,Nt)||re(o,Rt)||re(o,Gt)||re(o,Yt)||re(o,Xt)||re(o,Ht)||re(o,Kt(Ct))?new fr(o,r,n,i,a):e.error(`Type ${Wt(o)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const s=ar(e,n),a=fr.interpolationFactor(this.interpolation,n,e[s],e[s+1]),o=r[s].evaluate(t),l=r[s+1].evaluate(t);switch(this.operator){case "interpolate":switch(this.type.kind){case "number":return ke(o,l,a);case "color":return Te.interpolate(o,l,a);case "padding":return ze.interpolate(o,l,a);case "colorArray":return Be.interpolate(o,l,a);case "numberArray":return Pe.interpolate(o,l,a);case "variableAnchorOffsetCollection":return Le.interpolate(o,l,a);case "array":return Ee(o,l,a);case "projectionDefinition":return Re.interpolate(o,l,a)}case "interpolate-hcl":switch(this.type.kind){case "color":return Te.interpolate(o,l,a,"hcl");case "colorArray":return Be.interpolate(o,l,a,"hcl")}case "interpolate-lab":switch(this.type.kind){case "color":return Te.interpolate(o,l,a,"lab");case "colorArray":return Be.interpolate(o,l,a,"lab")}}}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function dr(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}const yr={color:Te.interpolate,number:ke,padding:ze.interpolate,numberArray:Pe.interpolate,colorArray:Be.interpolate,variableAnchorOffsetCollection:Le.interpolate,array:Ee};class mr{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,i.push(t);}if(!r)throw new Error("No output type");const s=n&&i.some((t=>Qt(n,t.type)));return new mr(s?Ut:r,i)}evaluate(t){let e,r=null,n=0;for(const i of this.args)if(n++,r=i.evaluate(t),r&&r instanceof Oe&&!r.available&&(e||(e=r.name),r=null,n===this.args.length&&(r=e)),null!==r)break;return r}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}function gr(t,e){return "=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function xr(t,e,r,n){return 0===n.compare(e,r)}function vr(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=Ot,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,Ut);if(!s)return null;if(!gr(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${Wt(s.type)}'.`);let a=e.parse(t[2],2,Ut);if(!a)return null;if(!gr(r,a.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${Wt(a.type)}'.`);if(s.type.kind!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error(`Cannot compare types '${Wt(s.type)}' and '${Wt(a.type)}'.`);n&&("value"===s.type.kind&&"value"!==a.type.kind?s=new Xe(a.type,[s]):"value"!==s.type.kind&&"value"===a.type.kind&&(a=new Xe(s.type,[a])));let o=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,qt),!o)return null}return new i(s,a,o)}evaluate(i){const s=this.lhs.evaluate(i),a=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=Ue(s),r=Ue(a);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new Ve(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=Ue(s),r=Ue(a);if("string"!==t.kind||"string"!==r.kind)return e(i,s,a)}return this.collator?r(i,s,a,this.collator.evaluate(i)):e(i,s,a)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator);}outputDefined(){return !0}}}const br=vr("==",(function(t,e,r){return e===r}),xr),wr=vr("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return !xr(0,e,r,n)})),_r=vr("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),Sr=vr(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),Ar=vr("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),kr=vr(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class Er{constructor(t,e,r){this.type=qt,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=e.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,Ot);if(!n)return null;const i=e.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,Ot);if(!i)return null;let s=null;return r.locale&&(s=e.parse(r.locale,1,Lt),!s)?null:new Er(n,i,s)}evaluate(t){return new Ie(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale);}outputDefined(){return !1}}class Tr{constructor(t,e,r,n,i){this.type=Lt,this.number=t,this.locale=e,this.currency=r,this.minFractionDigits=n,this.maxFractionDigits=i;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,Ct);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parse(n.locale,1,Lt),!i))return null;let s=null;if(n.currency&&(s=e.parse(n.currency,1,Lt),!s))return null;let a=null;if(n["min-fraction-digits"]&&(a=e.parse(n["min-fraction-digits"],1,Ct),!a))return null;let o=null;return n["max-fraction-digits"]&&(o=e.parse(n["max-fraction-digits"],1,Ct),!o)?null:new Tr(r,i,s,a,o)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return !1}}class Ir{constructor(t){this.type=jt,this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const s=t[r];if(i&&"object"==typeof s&&!Array.isArray(s)){i=!1;let t=null;if(s["font-scale"]&&(t=e.parse(s["font-scale"],1,Ct),!t))return null;let r=null;if(s["text-font"]&&(r=e.parse(s["text-font"],1,Kt(Lt)),!r))return null;let a=null;if(s["text-color"]&&(a=e.parse(s["text-color"],1,Rt),!a))return null;let o=null;if(s["vertical-align"]){if("string"==typeof s["vertical-align"]&&!Me.includes(s["vertical-align"]))return e.error(`'vertical-align' must be one of: 'bottom', 'center', 'top' but found '${s["vertical-align"]}' instead.`);if(o=e.parse(s["vertical-align"],1,Lt),!o)return null}const l=n[n.length-1];l.scale=t,l.font=r,l.textColor=a,l.verticalAlign=o;}else {const s=e.parse(t[r],1,Ut);if(!s)return null;const a=s.type.kind;if("string"!==a&&"value"!==a&&"null"!==a&&"resolvedImage"!==a)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:s,scale:null,font:null,textColor:null,verticalAlign:null});}}return new Ir(n)}evaluate(t){return new De(this.sections.map((e=>{const r=e.content.evaluate(t);return Ue(r)===Zt?new Fe("",r,null,null,null,e.verticalAlign?e.verticalAlign.evaluate(t):null):new Fe(qe(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null,e.verticalAlign?e.verticalAlign.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor),e.verticalAlign&&t(e.verticalAlign);}outputDefined(){return !1}}class Mr{constructor(t){this.type=Zt,this.input=t;}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,Lt);return r?new Mr(r):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),r=Oe.fromString(e);return r&&t.availableImages&&(r.available=t.availableImages.indexOf(e)>-1),r}eachChild(t){t(this.input);}outputDefined(){return !1}}class Fr{constructor(t){this.type=Ct,this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${Wt(r.type)} instead.`):new Fr(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return [...e].length;if(Array.isArray(e))return e.length;throw new Ve(`Expected value to be of type string or array, but found ${Wt(Ue(e))} instead.`)}eachChild(t){t(this.input);}outputDefined(){return !1}}const Dr=8192;function zr(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return [Math.round(r*i*Dr),Math.round(n*i*Dr)]}function Pr(t,e){const r=Math.pow(2,e.z);return [(i=(t[0]/Dr+e.x)/r,360*i-180),(n=(t[1]/Dr+e.y)/r,360/Math.PI*Math.atan(Math.exp((180-360*n)*Math.PI/180))-90)];var n,i;}function Br(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1]);}function Vr(t,e){return !(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function Cr(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],s=t[0]-r[0],a=t[1]-r[1];return n*a-s*i==0&&n*s<=0&&i*a<=0}function Lr(t,e,r,n){return 0!=(i=[n[0]-r[0],n[1]-r[1]])[0]*(s=[e[0]-t[0],e[1]-t[1]])[1]-i[1]*s[0]&&!(!qr(t,e,r,n)||!qr(r,n,t,e));var i,s;}function Or(t,e,r){for(const n of r)for(let r=0;r<n.length-1;++r)if(Lr(t,e,n[r],n[r+1]))return !0;return !1}function Rr(t,e,r=!1){let n=!1;for(const o of e)for(let e=0;e<o.length-1;e++){if(Cr(t,o[e],o[e+1]))return r;(s=o[e])[1]>(i=t)[1]!=(a=o[e+1])[1]>i[1]&&i[0]<(a[0]-s[0])*(i[1]-s[1])/(a[1]-s[1])+s[0]&&(n=!n);}var i,s,a;return n}function Nr(t,e){for(const r of e)if(Rr(t,r))return !0;return !1}function $r(t,e){for(const r of t)if(!Rr(r,e))return !1;for(let r=0;r<t.length-1;++r)if(Or(t[r],t[r+1],e))return !1;return !0}function Ur(t,e){for(const r of e)if($r(t,r))return !0;return !1}function qr(t,e,r,n){const i=n[0]-r[0],s=n[1]-r[1],a=(t[0]-r[0])*s-i*(t[1]-r[1]),o=(e[0]-r[0])*s-i*(e[1]-r[1]);return a>0&&o<0||a<0&&o>0}function jr(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=[];for(let n=0;n<t[i].length;n++){const a=zr(t[i][n],r);Br(e,a),s.push(a);}n.push(s);}return n}function Gr(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=jr(t[i],e,r);n.push(s);}return n}function Xr(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=i;}Br(e,t);}function Yr(t,e,r,n){const i=Math.pow(2,n.z)*Dr,s=[n.x*Dr,n.y*Dr],a=[];for(const n of t)for(const t of n){const n=[t.x+s[0],t.y+s[1]];Xr(n,e,r,i),a.push(n);}return a}function Zr(t,e,r,n){const i=Math.pow(2,n.z)*Dr,s=[n.x*Dr,n.y*Dr],a=[];for(const r of t){const t=[];for(const n of r){const r=[n.x+s[0],n.y+s[1]];Br(e,r),t.push(r);}a.push(t);}if(e[2]-e[0]<=i/2){(o=e)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const t of a)for(const n of t)Xr(n,e,r,i);}var o;return a}class Hr{constructor(t,e){this.type=Ot,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if($e(t[1])){const e=t[1];if("FeatureCollection"===e.type){const t=[];for(const r of e.features){const{type:e,coordinates:n}=r.geometry;"Polygon"===e&&t.push(n),"MultiPolygon"===e&&t.push(...n);}if(t.length)return new Hr(e,{type:"MultiPolygon",coordinates:t})}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new Hr(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new Hr(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=jr(e.coordinates,n,i),a=Yr(t.geometry(),r,n,i);if(!Vr(r,n))return !1;for(const t of a)if(!Rr(t,s))return !1}if("MultiPolygon"===e.type){const s=Gr(e.coordinates,n,i),a=Yr(t.geometry(),r,n,i);if(!Vr(r,n))return !1;for(const t of a)if(!Nr(t,s))return !1}return !0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=jr(e.coordinates,n,i),a=Zr(t.geometry(),r,n,i);if(!Vr(r,n))return !1;for(const t of a)if(!$r(t,s))return !1}if("MultiPolygon"===e.type){const s=Gr(e.coordinates,n,i),a=Zr(t.geometry(),r,n,i);if(!Vr(r,n))return !1;for(const t of a)if(!Ur(t,s))return !1}return !0}(t,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}}let Kr=class{constructor(t=[],e=(t,e)=>t<e?-1:t>e?1:0){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this._up(this.length++);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return --this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n;}e[t]=i;}};function Wr(t,e,r=0,n=t.length-1,i=Qr){for(;n>r;){if(n-r>600){const s=n-r+1,a=e-r+1,o=Math.log(s),l=.5*Math.exp(2*o/3),u=.5*Math.sqrt(o*l*(s-l)/s)*(a-s/2<0?-1:1);Wr(t,e,Math.max(r,Math.floor(e-a*l/s+u)),Math.min(n,Math.floor(e+(s-a)*l/s+u)),i);}const s=t[e];let a=r,o=n;for(Jr(t,r,e),i(t[n],s)>0&&Jr(t,r,n);a<o;){for(Jr(t,a,o),a++,o--;i(t[a],s)<0;)a++;for(;i(t[o],s)>0;)o--;}0===i(t[r],s)?Jr(t,r,o):(o++,Jr(t,o,n)),o<=e&&(r=o+1),e<=o&&(n=o-1);}}function Jr(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function Qr(t,e){return t<e?-1:t>e?1:0}function tn(t,e){if(t.length<=1)return [t];const r=[];let n,i;for(const e of t){const t=rn(e);0!==t&&(e.area=Math.abs(t),void 0===i&&(i=t<0),i===t<0?(n&&r.push(n),n=[e]):n.push(e));}if(n&&r.push(n),e>1)for(let t=0;t<r.length;t++)r[t].length<=e||(Wr(r[t],e,1,r[t].length-1,en),r[t]=r[t].slice(0,e));return r}function en(t,e){return e.area-t.area}function rn(t){let e=0;for(let r,n,i=0,s=t.length,a=s-1;i<s;a=i++)r=t[i],n=t[a],e+=(n.x-r.x)*(r.y+n.y);return e}const nn=1/298.257223563,sn=nn*(2-nn),an=Math.PI/180;class on{constructor(t){const e=6378.137*an*1e3,r=Math.cos(t*an),n=1/(1-sn*(1-r*r)),i=Math.sqrt(n);this.kx=e*i*r,this.ky=e*i*n*(1-sn);}distance(t,e){const r=this.wrap(t[0]-e[0])*this.kx,n=(t[1]-e[1])*this.ky;return Math.sqrt(r*r+n*n)}pointOnLine(t,e){let r,n,i,s,a=1/0;for(let o=0;o<t.length-1;o++){let l=t[o][0],u=t[o][1],c=this.wrap(t[o+1][0]-l)*this.kx,h=(t[o+1][1]-u)*this.ky,p=0;0===c&&0===h||(p=(this.wrap(e[0]-l)*this.kx*c+(e[1]-u)*this.ky*h)/(c*c+h*h),p>1?(l=t[o+1][0],u=t[o+1][1]):p>0&&(l+=c/this.kx*p,u+=h/this.ky*p)),c=this.wrap(e[0]-l)*this.kx,h=(e[1]-u)*this.ky;const f=c*c+h*h;f<a&&(a=f,r=l,n=u,i=o,s=p);}return {point:[r,n],index:i,t:Math.max(0,Math.min(1,s))}}wrap(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}}function ln(t,e){return e[0]-t[0]}function un(t){return t[1]-t[0]+1}function cn(t,e){return t[1]>=t[0]&&t[1]<e}function hn(t,e){if(t[0]>t[1])return [null,null];const r=un(t);if(e){if(2===r)return [t,null];const e=Math.floor(r/2);return [[t[0],t[0]+e],[t[0]+e,t[1]]]}if(1===r)return [t,null];const n=Math.floor(r/2)-1;return [[t[0],t[0]+n],[t[0]+n+1,t[1]]]}function pn(t,e){if(!cn(e,t.length))return [1/0,1/0,-1/0,-1/0];const r=[1/0,1/0,-1/0,-1/0];for(let n=e[0];n<=e[1];++n)Br(r,t[n]);return r}function fn(t){const e=[1/0,1/0,-1/0,-1/0];for(const r of t)for(const t of r)Br(e,t);return e}function dn(t){return t[0]!==-1/0&&t[1]!==-1/0&&t[2]!==1/0&&t[3]!==1/0}function yn(t,e,r){if(!dn(t)||!dn(e))return NaN;let n=0,i=0;return t[2]<e[0]&&(n=e[0]-t[2]),t[0]>e[2]&&(n=t[0]-e[2]),t[1]>e[3]&&(i=t[1]-e[3]),t[3]<e[1]&&(i=e[1]-t[3]),r.distance([0,0],[n,i])}function mn(t,e,r){const n=r.pointOnLine(e,t);return r.distance(t,n.point)}function gn(t,e,r,n,i){const s=Math.min(mn(t,[r,n],i),mn(e,[r,n],i)),a=Math.min(mn(r,[t,e],i),mn(n,[t,e],i));return Math.min(s,a)}function xn(t,e,r,n,i){if(!cn(e,t.length)||!cn(n,r.length))return 1/0;let s=1/0;for(let a=e[0];a<e[1];++a){const e=t[a],o=t[a+1];for(let t=n[0];t<n[1];++t){const n=r[t],a=r[t+1];if(Lr(e,o,n,a))return 0;s=Math.min(s,gn(e,o,n,a,i));}}return s}function vn(t,e,r,n,i){if(!cn(e,t.length)||!cn(n,r.length))return NaN;let s=1/0;for(let a=e[0];a<=e[1];++a)for(let e=n[0];e<=n[1];++e)if(s=Math.min(s,i.distance(t[a],r[e])),0===s)return s;return s}function bn(t,e,r){if(Rr(t,e,!0))return 0;let n=1/0;for(const i of e){const e=i[0],s=i[i.length-1];if(e!==s&&(n=Math.min(n,mn(t,[s,e],r)),0===n))return n;const a=r.pointOnLine(i,t);if(n=Math.min(n,r.distance(t,a.point)),0===n)return n}return n}function wn(t,e,r,n){if(!cn(e,t.length))return NaN;for(let n=e[0];n<=e[1];++n)if(Rr(t[n],r,!0))return 0;let i=1/0;for(let s=e[0];s<e[1];++s){const e=t[s],a=t[s+1];for(const t of r)for(let r=0,s=t.length,o=s-1;r<s;o=r++){const s=t[o],l=t[r];if(Lr(e,a,s,l))return 0;i=Math.min(i,gn(e,a,s,l,n));}}return i}function _n(t,e){for(const r of t)for(const t of r)if(Rr(t,e,!0))return !0;return !1}function Sn(t,e,r,n=1/0){const i=fn(t),s=fn(e);if(n!==1/0&&yn(i,s,r)>=n)return n;if(Vr(i,s)){if(_n(t,e))return 0}else if(_n(e,t))return 0;let a=1/0;for(const n of t)for(let t=0,i=n.length,s=i-1;t<i;s=t++){const i=n[s],o=n[t];for(const t of e)for(let e=0,n=t.length,s=n-1;e<n;s=e++){const n=t[s],l=t[e];if(Lr(i,o,n,l))return 0;a=Math.min(a,gn(i,o,n,l,r));}}return a}function An(t,e,r,n,i,s){if(!s)return;const a=yn(pn(n,s),i,r);a<e&&t.push([a,s,[0,0]]);}function kn(t,e,r,n,i,s,a){if(!s||!a)return;const o=yn(pn(n,s),pn(i,a),r);o<e&&t.push([o,s,a]);}function En(t,e,r,n,i=1/0){let s=Math.min(n.distance(t[0],r[0][0]),i);if(0===s)return s;const a=new Kr([[0,[0,t.length-1],[0,0]]],ln),o=fn(r);for(;a.length>0;){const i=a.pop();if(i[0]>=s)continue;const l=i[1],u=e?50:100;if(un(l)<=u){if(!cn(l,t.length))return NaN;if(e){const e=wn(t,l,r,n);if(isNaN(e)||0===e)return e;s=Math.min(s,e);}else for(let e=l[0];e<=l[1];++e){const i=bn(t[e],r,n);if(s=Math.min(s,i),0===s)return 0}}else {const r=hn(l,e);An(a,s,n,t,o,r[0]),An(a,s,n,t,o,r[1]);}}return s}function Tn(t,e,r,n,i,s=1/0){let a=Math.min(s,i.distance(t[0],r[0]));if(0===a)return a;const o=new Kr([[0,[0,t.length-1],[0,r.length-1]]],ln);for(;o.length>0;){const s=o.pop();if(s[0]>=a)continue;const l=s[1],u=s[2],c=e?50:100,h=n?50:100;if(un(l)<=c&&un(u)<=h){if(!cn(l,t.length)&&cn(u,r.length))return NaN;let s;if(e&&n)s=xn(t,l,r,u,i),a=Math.min(a,s);else if(e&&!n){const e=t.slice(l[0],l[1]+1);for(let t=u[0];t<=u[1];++t)if(s=mn(r[t],e,i),a=Math.min(a,s),0===a)return a}else if(!e&&n){const e=r.slice(u[0],u[1]+1);for(let r=l[0];r<=l[1];++r)if(s=mn(t[r],e,i),a=Math.min(a,s),0===a)return a}else s=vn(t,l,r,u,i),a=Math.min(a,s);}else {const s=hn(l,e),c=hn(u,n);kn(o,a,i,t,r,s[0],c[0]),kn(o,a,i,t,r,s[0],c[1]),kn(o,a,i,t,r,s[1],c[0]),kn(o,a,i,t,r,s[1],c[1]);}}return a}function In(t){return "MultiPolygon"===t.type?t.coordinates.map((t=>({type:"Polygon",coordinates:t}))):"MultiLineString"===t.type?t.coordinates.map((t=>({type:"LineString",coordinates:t}))):"MultiPoint"===t.type?t.coordinates.map((t=>({type:"Point",coordinates:t}))):[t]}class Mn{constructor(t,e){this.type=Ct,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires exactly one argument, but found ${t.length-1} instead.`);if($e(t[1])){const e=t[1];if("FeatureCollection"===e.type)return new Mn(e,e.features.map((t=>In(t.geometry))).flat());if("Feature"===e.type)return new Mn(e,In(e.geometry));if("type"in e&&"coordinates"in e)return new Mn(e,In(e))}return e.error("'distance' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=t.geometry(),n=r.flat().map((e=>Pr([e.x,e.y],t.canonical)));if(0===r.length)return NaN;const i=new on(n[0][1]);let s=1/0;for(const t of e){switch(t.type){case "Point":s=Math.min(s,Tn(n,!1,[t.coordinates],!1,i,s));break;case "LineString":s=Math.min(s,Tn(n,!1,t.coordinates,!0,i,s));break;case "Polygon":s=Math.min(s,En(n,!1,t.coordinates,i,s));}if(0===s)return s}return s}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=t.geometry(),n=r.flat().map((e=>Pr([e.x,e.y],t.canonical)));if(0===r.length)return NaN;const i=new on(n[0][1]);let s=1/0;for(const t of e){switch(t.type){case "Point":s=Math.min(s,Tn(n,!0,[t.coordinates],!1,i,s));break;case "LineString":s=Math.min(s,Tn(n,!0,t.coordinates,!0,i,s));break;case "Polygon":s=Math.min(s,En(n,!0,t.coordinates,i,s));}if(0===s)return s}return s}(t,this.geometries);if("Polygon"===t.geometryType())return function(t,e){const r=t.geometry();if(0===r.length||0===r[0].length)return NaN;const n=tn(r,0).map((e=>e.map((e=>e.map((e=>Pr([e.x,e.y],t.canonical))))))),i=new on(n[0][0][0][1]);let s=1/0;for(const t of e)for(const e of n){switch(t.type){case "Point":s=Math.min(s,En([t.coordinates],!1,e,i,s));break;case "LineString":s=Math.min(s,En(t.coordinates,!0,e,i,s));break;case "Polygon":s=Math.min(s,Sn(e,t.coordinates,i,s));}if(0===s)return s}return s}(t,this.geometries)}return NaN}eachChild(){}outputDefined(){return !0}}class Fn{constructor(t){this.type=Ut,this.key=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=t[1];return null==r?e.error("Global state property must be defined."):"string"!=typeof r?e.error(`Global state property must be string, but found ${typeof t[1]} instead.`):new Fn(r)}evaluate(t){var e;const r=null===(e=t.globals)||void 0===e?void 0:e.globalState;return r&&0!==Object.keys(r).length?ve(r,this.key):null}eachChild(){}outputDefined(){return !1}}const Dn={"==":br,"!=":wr,">":Sr,"<":_r,">=":kr,"<=":Ar,array:Xe,at:tr,boolean:Xe,case:ir,coalesce:mr,collator:Er,format:Ir,image:Mr,in:er,"index-of":rr,interpolate:fr,"interpolate-hcl":fr,"interpolate-lab":fr,length:Fr,let:Je,literal:je,match:nr,number:Xe,"number-format":Tr,object:Xe,slice:sr,step:or,string:Xe,"to-boolean":Ze,"to-color":Ze,"to-number":Ze,"to-string":Ze,var:Qe,within:Hr,distance:Mn,"global-state":Fn};class zn{constructor(t,e,r,n){this.name=t,this.type=e,this._evaluate=r,this.args=n;}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t);}outputDefined(){return !1}static parse(t,e){const r=t[0],n=zn.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,s=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,a=s.filter((([e])=>!Array.isArray(e)||e.length===t.length-1));let o=null;for(const[n,s]of a){o=new We(e.registry,Ln,e.path,null,e.scope);const a=[];let l=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,s=o.parse(r,1+a.length,i);if(!s){l=!0;break}a.push(s);}if(!l)if(Array.isArray(n)&&n.length!==a.length)o.error(`Expected ${n.length} arguments, but found ${a.length} instead.`);else {for(let t=0;t<a.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=a[t];o.concat(t+1).checkSubtype(e,r.type);}if(0===o.errors.length)return new zn(r,i,s,a)}}if(1===a.length)e.errors.push(...o.errors);else {const r=(a.length?a:s).map((([t])=>{return e=t,Array.isArray(e)?`(${e.map(Wt).join(", ")})`:`(${Wt(e.type)}...)`;var e;})).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(Wt(i.type));}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`);}return null}static register(t,e){zn.definitions=e;for(const r in e)t[r]=zn;}}function Pn(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,a=Ne(e,r,n,s);if(a)throw new Ve(a);return new Te(e/255,r/255,n/255,s,!1)}function Bn(t,e){return t in e}function Vn(t,e){const r=e[t];return void 0===r?null:r}function Cn(t){return {type:t}}function Ln(t){if(t instanceof Qe)return Ln(t.boundExpression);if(t instanceof zn&&"error"===t.name)return !1;if(t instanceof Er)return !1;if(t instanceof Hr)return !1;if(t instanceof Mn)return !1;if(t instanceof Fn)return !1;const e=t instanceof Ze||t instanceof Xe;let r=!0;return t.eachChild((t=>{r=e?r&&Ln(t):r&&t instanceof je;})),!!r&&On(t)&&Nn(t,["zoom","heatmap-density","elevation","line-progress","accumulated","is-supported-script"])}function On(t){if(t instanceof zn){if("get"===t.name&&1===t.args.length)return !1;if("feature-state"===t.name)return !1;if("has"===t.name&&1===t.args.length)return !1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return !1;if(/^filter-/.test(t.name))return !1}if(t instanceof Hr)return !1;if(t instanceof Mn)return !1;let e=!0;return t.eachChild((t=>{e&&!On(t)&&(e=!1);})),e}function Rn(t){if(t instanceof zn&&"feature-state"===t.name)return !1;let e=!0;return t.eachChild((t=>{e&&!Rn(t)&&(e=!1);})),e}function Nn(t,e){if(t instanceof zn&&e.indexOf(t.name)>=0)return !1;let r=!0;return t.eachChild((t=>{r&&!Nn(t,e)&&(r=!1);})),r}function $n(t){return {result:"success",value:t}}function Un(t){return {result:"error",value:t}}function qn(t){return "data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function jn(t){return !!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function Gn(t){return !!t.expression&&t.expression.interpolated}function Xn(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function Yn(t){return "object"==typeof t&&null!==t&&!Array.isArray(t)&&Ue(t)===$t}function Zn(t){return t}function Hn(t,e){const r=t.stops&&"object"==typeof t.stops[0][0],n=r||!(r||void 0!==t.property),i=t.type||(Gn(e)?"exponential":"interval"),s=function(t){switch(t.type){case "color":return Te.parse;case "padding":return ze.parse;case "numberArray":return Pe.parse;case "colorArray":return Be.parse;default:return null}}(e);if(s&&((t=zt({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],s(t[1])]))),t.default=s(t.default?t.default:e.default)),t.colorSpace&&"rgb"!==(a=t.colorSpace)&&"hcl"!==a&&"lab"!==a)throw new Error(`Unknown color space: "${t.colorSpace}"`);var a;const o=function(t){switch(t){case "exponential":return Qn;case "interval":return Jn;case "categorical":return Wn;case "identity":return ti;default:throw new Error(`Unknown function type "${t}"`)}}(i);let l,u;if("categorical"===i){l=Object.create(null);for(const e of t.stops)l[e[0]]=e[1];u=typeof t.stops[0][0];}if(r){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],s=i[0].zoom;void 0===r[s]&&(r[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},n.push(s)),r[s].stops.push([i[0].value,i[1]]);}const i=[];for(const t of n)i.push([r[t].zoom,Hn(r[t],e)]);const s={name:"linear"};return {kind:"composite",interpolationType:s,interpolationFactor:fr.interpolationFactor.bind(void 0,s),zoomStops:i.map((t=>t[0])),evaluate:({zoom:r},n)=>Qn({stops:i,base:t.base},e,r).evaluate(r,n)}}if(n){const r="exponential"===i?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return {kind:"camera",interpolationType:r,interpolationFactor:fr.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>o(t,e,r,l,u)}}return {kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?Kn(t.default,e.default):o(t,e,i,l,u)}}}function Kn(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function Wn(t,e,r,n,i){return Kn(typeof r===i?n[r]:void 0,t.default,e.default)}function Jn(t,e,r){if("number"!==Xn(r))return Kn(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=ar(t.stops.map((t=>t[0])),r);return t.stops[i][1]}function Qn(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==Xn(r))return Kn(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const s=ar(t.stops.map((t=>t[0])),r),a=function(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}(r,n,t.stops[s][0],t.stops[s+1][0]),o=t.stops[s][1],l=t.stops[s+1][1],u=yr[e.type]||Zn;return "function"==typeof o.evaluate?{evaluate(...e){const r=o.evaluate.apply(void 0,e),n=l.evaluate.apply(void 0,e);if(void 0!==r&&void 0!==n)return u(r,n,a,t.colorSpace)}}:u(o,l,a,t.colorSpace)}function ti(t,e,r){switch(e.type){case "color":r=Te.parse(r);break;case "formatted":r=De.fromString(r.toString());break;case "resolvedImage":r=Oe.fromString(r.toString());break;case "padding":r=ze.parse(r);break;case "colorArray":r=Be.parse(r);break;case "numberArray":r=Pe.parse(r);break;default:Xn(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0);}return Kn(r,t.default,e.default)}zn.register(Dn,{error:[{kind:"error"},[Lt],(t,[e])=>{throw new Ve(e.evaluate(t))}],typeof:[Lt,[Ut],(t,[e])=>Wt(Ue(e.evaluate(t)))],"to-rgba":[Kt(Ct,4),[Rt],(t,[e])=>{const[r,n,i,s]=e.evaluate(t).rgb;return [255*r,255*n,255*i,s]}],rgb:[Rt,[Ct,Ct,Ct],Pn],rgba:[Rt,[Ct,Ct,Ct,Ct],Pn],has:{type:Ot,overloads:[[[Lt],(t,[e])=>Bn(e.evaluate(t),t.properties())],[[Lt,$t],(t,[e,r])=>Bn(e.evaluate(t),r.evaluate(t))]]},get:{type:Ut,overloads:[[[Lt],(t,[e])=>Vn(e.evaluate(t),t.properties())],[[Lt,$t],(t,[e,r])=>Vn(e.evaluate(t),r.evaluate(t))]]},"feature-state":[Ut,[Lt],(t,[e])=>Vn(e.evaluate(t),t.featureState||{})],properties:[$t,[],t=>t.properties()],"geometry-type":[Lt,[],t=>t.geometryType()],id:[Ut,[],t=>t.id()],zoom:[Ct,[],t=>t.globals.zoom],"heatmap-density":[Ct,[],t=>t.globals.heatmapDensity||0],elevation:[Ct,[],t=>t.globals.elevation||0],"line-progress":[Ct,[],t=>t.globals.lineProgress||0],accumulated:[Ut,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[Ct,Cn(Ct),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[Ct,Cn(Ct),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:Ct,overloads:[[[Ct,Ct],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[Ct],(t,[e])=>-e.evaluate(t)]]},"/":[Ct,[Ct,Ct],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[Ct,[Ct,Ct],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[Ct,[],()=>Math.LN2],pi:[Ct,[],()=>Math.PI],e:[Ct,[],()=>Math.E],"^":[Ct,[Ct,Ct],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[Ct,[Ct],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[Ct,[Ct],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[Ct,[Ct],(t,[e])=>Math.log(e.evaluate(t))],log2:[Ct,[Ct],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[Ct,[Ct],(t,[e])=>Math.sin(e.evaluate(t))],cos:[Ct,[Ct],(t,[e])=>Math.cos(e.evaluate(t))],tan:[Ct,[Ct],(t,[e])=>Math.tan(e.evaluate(t))],asin:[Ct,[Ct],(t,[e])=>Math.asin(e.evaluate(t))],acos:[Ct,[Ct],(t,[e])=>Math.acos(e.evaluate(t))],atan:[Ct,[Ct],(t,[e])=>Math.atan(e.evaluate(t))],min:[Ct,Cn(Ct),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[Ct,Cn(Ct),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[Ct,[Ct],(t,[e])=>Math.abs(e.evaluate(t))],round:[Ct,[Ct],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[Ct,[Ct],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[Ct,[Ct],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[Ot,[Lt,Ut],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[Ot,[Ut],(t,[e])=>t.id()===e.value],"filter-type-==":[Ot,[Lt],(t,[e])=>t.geometryType()===e.value],"filter-<":[Ot,[Lt,Ut],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[Ot,[Ut],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[Ot,[Lt,Ut],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[Ot,[Ut],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[Ot,[Lt,Ut],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[Ot,[Ut],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[Ot,[Lt,Ut],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[Ot,[Ut],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[Ot,[Ut],(t,[e])=>e.value in t.properties()],"filter-has-id":[Ot,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[Ot,[Kt(Lt)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[Ot,[Kt(Ut)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[Ot,[Lt,Kt(Ut)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[Ot,[Lt,Kt(Ut)],(t,[e,r])=>function(t,e,r,n){for(;r<=n;){const i=r+n>>1;if(e[i]===t)return !0;e[i]>t?n=i-1:r=i+1;}return !1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:Ot,overloads:[[[Ot,Ot],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[Cn(Ot),(t,e)=>{for(const r of e)if(!r.evaluate(t))return !1;return !0}]]},any:{type:Ot,overloads:[[[Ot,Ot],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[Cn(Ot),(t,e)=>{for(const r of e)if(r.evaluate(t))return !0;return !1}]]},"!":[Ot,[Ot],(t,[e])=>!e.evaluate(t)],"is-supported-script":[Ot,[Lt],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return !r||r(e.evaluate(t))}],upcase:[Lt,[Lt],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[Lt,[Lt],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[Lt,Cn(Ut),(t,e)=>e.map((e=>qe(e.evaluate(t)))).join("")],"resolved-locale":[Lt,[qt],(t,[e])=>e.evaluate(t).resolvedLocale()]});class ei{constructor(t,e,r){this.expression=t,this._warningHistory={},this._evaluator=new Ke,this._defaultValue=e?function(t){if("color"===t.type&&Yn(t.default))return new Te(0,0,0,0);switch(t.type){case "color":return Te.parse(t.default)||null;case "padding":return ze.parse(t.default)||null;case "numberArray":return Pe.parse(t.default)||null;case "colorArray":return Be.parse(t.default)||null;case "variableAnchorOffsetCollection":return Le.parse(t.default)||null;case "projectionDefinition":return Re.parse(t.default)||null;default:return void 0===t.default?null:t.default}}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null,this._globalState=r;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._globalState&&(t=ci(t,this._globalState)),this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,i,s){this._globalState&&(t=ci(t,this._globalState)),this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new Ve(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function ri(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in Dn}function ni(t,e,r){const n=new We(Dn,Ln,[],e?function(t){const e={color:Rt,string:Lt,number:Ct,enum:Lt,boolean:Ot,formatted:jt,padding:Gt,numberArray:Yt,colorArray:Xt,projectionDefinition:Nt,resolvedImage:Zt,variableAnchorOffsetCollection:Ht};return "array"===t.type?Kt(e[t.value]||Ut,t.length):e[t.type]}(e):void 0),i=n.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return i?$n(new ei(i,e,r)):Un(n.errors)}class ii{constructor(t,e,r){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!Rn(e.expression),this.globalStateRefs=ui(e.expression),this._globalState=r;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._globalState&&(t=ci(t,this._globalState)),this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._globalState&&(t=ci(t,this._globalState)),this._styleExpression.evaluate(t,e,r,n,i,s)}}class si{constructor(t,e,r,n,i){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!Rn(e.expression),this.globalStateRefs=ui(e.expression),this.interpolationType=n,this._globalState=i;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._globalState&&(t=ci(t,this._globalState)),this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._globalState&&(t=ci(t,this._globalState)),this._styleExpression.evaluate(t,e,r,n,i,s)}interpolationFactor(t,e,r){return this.interpolationType?fr.interpolationFactor(this.interpolationType,t,e,r):0}}function ai(t,e,r){const n=ni(t,e,r);if("error"===n.result)return n;const i=n.value.expression,s=On(i);if(!s&&!qn(e))return Un([new Pt("","data expressions not supported")]);const a=Nn(i,["zoom"]);if(!a&&!jn(e))return Un([new Pt("","zoom expressions not supported")]);const o=li(i);return o||a?o instanceof Pt?Un([o]):o instanceof fr&&!Gn(e)?Un([new Pt("",'"interpolate" expressions cannot be used with this property')]):$n(o?new si(s?"camera":"composite",n.value,o.labels,o instanceof fr?o.interpolation:void 0,r):new ii(s?"constant":"source",n.value,r)):Un([new Pt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class oi{constructor(t,e){this._parameters=t,this._specification=e,zt(this,Hn(this._parameters,this._specification));}static deserialize(t){return new oi(t._parameters,t._specification)}static serialize(t){return {_parameters:t._parameters,_specification:t._specification}}}function li(t){let e=null;if(t instanceof Je)e=li(t.result);else if(t instanceof mr){for(const r of t.args)if(e=li(r),e)break}else (t instanceof or||t instanceof fr)&&t.input instanceof zn&&"zoom"===t.input.name&&(e=t);return e instanceof Pt||t.eachChild((t=>{const r=li(t);r instanceof Pt?e=r:!e&&r?e=new Pt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&r&&e!==r&&(e=new Pt("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));})),e}function ui(t,e=new Set){return t instanceof Fn&&e.add(t.key),t.eachChild((t=>{ui(t,e);})),e}function ci(t,e){const{zoom:r,heatmapDensity:n,elevation:i,lineProgress:s,isSupportedScript:a,accumulated:o}=null!=t?t:{};return {zoom:r,heatmapDensity:n,elevation:i,lineProgress:s,isSupportedScript:a,accumulated:o,globalState:e}}function hi(t){if(!0===t||!1===t)return !0;if(!Array.isArray(t)||0===t.length)return !1;switch(t[0]){case "has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case "in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case "!in":case "!has":case "none":return !1;case "==":case "!=":case ">":case ">=":case "<":case "<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case "any":case "all":for(const e of t.slice(1))if(!hi(e)&&"boolean"!=typeof e)return !1;return !0;default:return !0}}const pi={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function fi(t,e){if(null==t)return {filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set};hi(t)||(t=mi(t));const r=ni(t,pi,e);if("error"===r.result)throw new Error(r.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return {filter:(t,e,n)=>r.value.evaluate(t,e,{},n),needGeometry:yi(t),getGlobalStateRefs:()=>ui(r.value.expression)}}function di(t,e){return t<e?-1:t>e?1:0}function yi(t){if(!Array.isArray(t))return !1;if("within"===t[0]||"distance"===t[0])return !0;for(let e=1;e<t.length;e++)if(yi(t[e]))return !0;return !1}function mi(t){if(!t)return !0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?gi(t[1],t[2],"=="):"!="===e?bi(gi(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?gi(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(mi))):"all"===e?["all"].concat(t.slice(1).map(mi)):"none"===e?["all"].concat(t.slice(1).map(mi).map(bi)):"in"===e?xi(t[1],t.slice(2)):"!in"===e?bi(xi(t[1],t.slice(2))):"has"===e?vi(t[1]):"!has"!==e||bi(vi(t[1]));var r;}function gi(t,e,r){switch(t){case "$type":return [`filter-type-${r}`,e];case "$id":return [`filter-id-${r}`,e];default:return [`filter-${r}`,t,e]}}function xi(t,e){if(0===e.length)return !1;switch(t){case "$type":return ["filter-type-in",["literal",e]];case "$id":return ["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(di)]]:["filter-in-small",t,["literal",e]]}}function vi(t){switch(t){case "$type":return !0;case "$id":return ["filter-has-id"];default:return ["filter-has",t]}}function bi(t){return ["!",t]}function wi(t){const e=typeof t;if("number"===e||"boolean"===e||"string"===e||null==t)return JSON.stringify(t);if(Array.isArray(t)){let e="[";for(const r of t)e+=`${wi(r)},`;return `${e}]`}const r=Object.keys(t).sort();let n="{";for(let e=0;e<r.length;e++)n+=`${JSON.stringify(r[e])}:${wi(t[r[e]])},`;return `${n}}`}function _i(t){let e="";for(const r of bt)e+=`/${wi(t[r])}`;return e}function Si(t){const e=t.value;return e?[new Dt(t.key,e,"constants have been deprecated as of v8")]:[]}function Ai(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function ki(t){if(Array.isArray(t))return t.map(ki);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=ki(t[r]);return e}return Ai(t)}function Ei(t){const e=t.key,r=t.value,n=t.valueSpec||{},i=t.objectElementValidators||{},s=t.style,a=t.styleSpec,o=t.validateSpec;let l=[];const u=Xn(r);if("object"!==u)return [new Dt(e,r,`object expected, ${u} found`)];for(const t in r){const u=t.split(".")[0],c=ve(n,u)||n["*"];let h;if(ve(i,u))h=i[u];else if(ve(n,u)){if(void 0===r[t])continue;h=o;}else if(i["*"])h=i["*"];else {if(!n["*"]){l.push(new Dt(e,r[t],`unknown property "${t}"`));continue}h=o;}l=l.concat(h({key:(e?`${e}.`:e)+t,value:r[t],valueSpec:c,style:s,styleSpec:a,object:r,objectKey:t,validateSpec:o},r));}for(const t in n)i[t]||n[t].required&&void 0===n[t].default&&void 0===r[t]&&l.push(new Dt(e,r,`missing required property "${t}"`));return l}function Ti(t){const e=t.value,r=t.valueSpec,n=t.style,i=t.styleSpec,s=t.key,a=t.arrayElementValidator||t.validateSpec;if("array"!==Xn(e))return [new Dt(s,e,`array expected, ${Xn(e)} found`)];if(r.length&&e.length!==r.length)return [new Dt(s,e,`array length ${r.length} expected, length ${e.length} found`)];let o={type:r.value,values:r.values};i.$version<7&&(o.function=r.function),"object"===Xn(r.value)&&(o=r.value);let l=[];for(let r=0;r<e.length;r++)l=l.concat(a({array:e,arrayIndex:r,value:e[r],valueSpec:o,validateSpec:t.validateSpec,style:n,styleSpec:i,key:`${s}[${r}]`}));return l}function Ii(t){const e=t.key,r=t.value,n=t.valueSpec;let i=Xn(r);return "number"===i&&r!=r&&(i="NaN"),"number"!==i?[new Dt(e,r,`number expected, ${i} found`)]:"minimum"in n&&r<n.minimum?[new Dt(e,r,`${r} is less than the minimum value ${n.minimum}`)]:"maximum"in n&&r>n.maximum?[new Dt(e,r,`${r} is greater than the maximum value ${n.maximum}`)]:[]}function Mi(t){const e=t.valueSpec,r=Ai(t.value.type);let n,i,s,a={};const o="categorical"!==r&&void 0===t.value.property,l=!o,u="array"===Xn(t.value.stops)&&"array"===Xn(t.value.stops[0])&&"object"===Xn(t.value.stops[0][0]),c=Ei({key:t.key,value:t.value,valueSpec:t.styleSpec.function,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===r)return [new Dt(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const n=t.value;return e=e.concat(Ti({key:t.key,value:n,valueSpec:t.valueSpec,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:h})),"array"===Xn(n)&&0===n.length&&e.push(new Dt(t.key,n,"array must have at least one stop")),e},default:function(t){return t.validateSpec({key:t.key,value:t.value,valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec})}}});return "identity"===r&&o&&c.push(new Dt(t.key,t.value,'missing required property "property"')),"identity"===r||t.value.stops||c.push(new Dt(t.key,t.value,'missing required property "stops"')),"exponential"===r&&t.valueSpec.expression&&!Gn(t.valueSpec)&&c.push(new Dt(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!qn(t.valueSpec)?c.push(new Dt(t.key,t.value,"property functions not supported")):o&&!jn(t.valueSpec)&&c.push(new Dt(t.key,t.value,"zoom functions not supported"))),"categorical"!==r&&!u||void 0!==t.value.property||c.push(new Dt(t.key,t.value,'"property" property is required')),c;function h(t){let r=[];const n=t.value,o=t.key;if("array"!==Xn(n))return [new Dt(o,n,`array expected, ${Xn(n)} found`)];if(2!==n.length)return [new Dt(o,n,`array length 2 expected, length ${n.length} found`)];if(u){if("object"!==Xn(n[0]))return [new Dt(o,n,`object expected, ${Xn(n[0])} found`)];if(void 0===n[0].zoom)return [new Dt(o,n,"object stop key must have zoom")];if(void 0===n[0].value)return [new Dt(o,n,"object stop key must have value")];if(s&&s>Ai(n[0].zoom))return [new Dt(o,n[0].zoom,"stop zoom values must appear in ascending order")];Ai(n[0].zoom)!==s&&(s=Ai(n[0].zoom),i=void 0,a={}),r=r.concat(Ei({key:`${o}[0]`,value:n[0],valueSpec:{zoom:{}},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:Ii,value:p}}));}else r=r.concat(p({key:`${o}[0]`,value:n[0],validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec},n));return ri(ki(n[1]))?r.concat([new Dt(`${o}[1]`,n[1],"expressions are not allowed in function stops.")]):r.concat(t.validateSpec({key:`${o}[1]`,value:n[1],valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec}))}function p(t,s){const o=Xn(t.value),l=Ai(t.value),u=null!==t.value?t.value:s;if(n){if(o!==n)return [new Dt(t.key,u,`${o} stop domain type must match previous stop domain type ${n}`)]}else n=o;if("number"!==o&&"string"!==o&&"boolean"!==o)return [new Dt(t.key,u,"stop domain value must be a number, string, or boolean")];if("number"!==o&&"categorical"!==r){let n=`number expected, ${o} found`;return qn(e)&&void 0===r&&(n+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new Dt(t.key,u,n)]}return "categorical"!==r||"number"!==o||isFinite(l)&&Math.floor(l)===l?"categorical"!==r&&"number"===o&&void 0!==i&&l<i?[new Dt(t.key,u,"stop domain values must appear in ascending order")]:(i=l,"categorical"===r&&l in a?[new Dt(t.key,u,"stop domain values must be unique")]:(a[l]=!0,[])):[new Dt(t.key,u,`integer expected, found ${l}`)]}}function Fi(t){const e=("property"===t.expressionContext?ai:ni)(ki(t.value),t.valueSpec);if("error"===e.result)return e.value.map((e=>new Dt(`${t.key}${e.key}`,t.value,e.message)));const r=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!r.outputDefined())return [new Dt(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!Rn(r))return [new Dt(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!Rn(r))return [new Dt(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!Nn(r,["zoom","feature-state"]))return [new Dt(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!On(r))return [new Dt(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function Di(t){const e=t.key,r=t.value,n=Xn(r);return "string"!==n?[new Dt(e,r,`color expected, ${n} found`)]:Te.parse(String(r))?[]:[new Dt(e,r,`color expected, "${r}" found`)]}function zi(t){const e=t.key,r=t.value,n=t.valueSpec,i=[];return Array.isArray(n.values)?-1===n.values.indexOf(Ai(r))&&i.push(new Dt(e,r,`expected one of [${n.values.join(", ")}], ${JSON.stringify(r)} found`)):-1===Object.keys(n.values).indexOf(Ai(r))&&i.push(new Dt(e,r,`expected one of [${Object.keys(n.values).join(", ")}], ${JSON.stringify(r)} found`)),i}function Pi(t){return hi(ki(t.value))?Fi(zt({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):Bi(t)}function Bi(t){const e=t.value,r=t.key;if("array"!==Xn(e))return [new Dt(r,e,`array expected, ${Xn(e)} found`)];const n=t.styleSpec;let i,s=[];if(e.length<1)return [new Dt(r,e,"filter array must have at least 1 element")];switch(s=s.concat(zi({key:`${r}[0]`,value:e[0],valueSpec:n.filter_operator,style:t.style,styleSpec:t.styleSpec})),Ai(e[0])){case "<":case "<=":case ">":case ">=":e.length>=2&&"$type"===Ai(e[1])&&s.push(new Dt(r,e,`"$type" cannot be use with operator "${e[0]}"`));case "==":case "!=":3!==e.length&&s.push(new Dt(r,e,`filter array for operator "${e[0]}" must have 3 elements`));case "in":case "!in":e.length>=2&&(i=Xn(e[1]),"string"!==i&&s.push(new Dt(`${r}[1]`,e[1],`string expected, ${i} found`)));for(let a=2;a<e.length;a++)i=Xn(e[a]),"$type"===Ai(e[1])?s=s.concat(zi({key:`${r}[${a}]`,value:e[a],valueSpec:n.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==i&&"number"!==i&&"boolean"!==i&&s.push(new Dt(`${r}[${a}]`,e[a],`string, number, or boolean expected, ${i} found`));break;case "any":case "all":case "none":for(let n=1;n<e.length;n++)s=s.concat(Bi({key:`${r}[${n}]`,value:e[n],style:t.style,styleSpec:t.styleSpec}));break;case "has":case "!has":i=Xn(e[1]),2!==e.length?s.push(new Dt(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==i&&s.push(new Dt(`${r}[1]`,e[1],`string expected, ${i} found`));}return s}function Vi(t,e){const r=t.key,n=t.validateSpec,i=t.style,s=t.styleSpec,a=t.value,o=t.objectKey,l=s[`${e}_${t.layerType}`];if(!l)return [];const u=o.match(/^(.*)-transition$/);if("paint"===e&&u&&l[u[1]]&&l[u[1]].transition)return n({key:r,value:a,valueSpec:s.transition,style:i,styleSpec:s});const c=t.valueSpec||l[o];if(!c)return [new Dt(r,a,`unknown property "${o}"`)];let h;if("string"===Xn(a)&&qn(c)&&!c.tokens&&(h=/^{([^}]+)}$/.exec(a)))return [new Dt(r,a,`"${o}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(h[1])} }\`.`)];const p=[];return "symbol"===t.layerType&&"text-font"===o&&Yn(ki(a))&&"identity"===Ai(a.type)&&p.push(new Dt(r,a,'"text-font" does not support identity functions')),p.concat(n({key:t.key,value:a,valueSpec:c,style:i,styleSpec:s,expressionContext:"property",propertyType:e,propertyKey:o}))}function Ci(t){return Vi(t,"paint")}function Li(t){return Vi(t,"layout")}function Oi(t){let e=[];const r=t.value,n=t.key,i=t.style,s=t.styleSpec;if("object"!==Xn(r))return [new Dt(n,r,`object expected, ${Xn(r)} found`)];r.type||r.ref||e.push(new Dt(n,r,'either "type" or "ref" is required'));let a=Ai(r.type);const o=Ai(r.ref);if(r.id){const s=Ai(r.id);for(let a=0;a<t.arrayIndex;a++){const t=i.layers[a];Ai(t.id)===s&&e.push(new Dt(n,r.id,`duplicate layer id "${r.id}", previously used at line ${t.id.__line__}`));}}if("ref"in r){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in r&&e.push(new Dt(n,r[t],`"${t}" is prohibited for ref layers`));})),i.layers.forEach((e=>{Ai(e.id)===o&&(t=e);})),t?t.ref?e.push(new Dt(n,r.ref,"ref cannot reference another ref layer")):a=Ai(t.type):e.push(new Dt(n,r.ref,`ref layer "${o}" not found`));}else if("background"!==a)if(r.source){const t=i.sources&&i.sources[r.source],s=t&&Ai(t.type);t?"vector"===s&&"raster"===a?e.push(new Dt(n,r.source,`layer "${r.id}" requires a raster source`)):"raster-dem"!==s&&"hillshade"===a||"raster-dem"!==s&&"color-relief"===a?e.push(new Dt(n,r.source,`layer "${r.id}" requires a raster-dem source`)):"raster"===s&&"raster"!==a?e.push(new Dt(n,r.source,`layer "${r.id}" requires a vector source`)):"vector"!==s||r["source-layer"]?"raster-dem"===s&&"hillshade"!==a&&"color-relief"!==a?e.push(new Dt(n,r.source,"raster-dem source can only be used with layer type 'hillshade' or 'color-relief'.")):"line"!==a||!r.paint||!r.paint["line-gradient"]||"geojson"===s&&t.lineMetrics||e.push(new Dt(n,r,`layer "${r.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new Dt(n,r,`layer "${r.id}" must specify a "source-layer"`)):e.push(new Dt(n,r.source,`source "${r.source}" not found`));}else e.push(new Dt(n,r,'missing required property "source"'));return e=e.concat(Ei({key:n,value:r,valueSpec:s.layer,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":()=>[],type:()=>t.validateSpec({key:`${n}.type`,value:r.type,valueSpec:s.layer.type,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,object:r,objectKey:"type"}),filter:Pi,layout:t=>Ei({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Li(zt({layerType:a},t))}}),paint:t=>Ei({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Ci(zt({layerType:a},t))}})}})),e}function Ri(t){const e=t.value,r=t.key,n=Xn(e);return "string"!==n?[new Dt(r,e,`string expected, ${n} found`)]:[]}const Ni={promoteId:function({key:t,value:e}){if("string"===Xn(e))return Ri({key:t,value:e});{const r=[];for(const n in e)r.push(...Ri({key:`${t}.${n}`,value:e[n]}));return r}}};function $i(t){const e=t.value,r=t.key,n=t.styleSpec,i=t.style,s=t.validateSpec;if(!e.type)return [new Dt(r,e,'"type" is required')];const a=Ai(e.type);let o;switch(a){case "vector":case "raster":return o=Ei({key:r,value:e,valueSpec:n[`source_${a.replace("-","_")}`],style:t.style,styleSpec:n,objectElementValidators:Ni,validateSpec:s}),o;case "raster-dem":return o=function(t){var e;const r=null!==(e=t.sourceName)&&void 0!==e?e:"",n=t.value,i=t.styleSpec,s=i.source_raster_dem,a=t.style;let o=[];const l=Xn(n);if(void 0===n)return o;if("object"!==l)return o.push(new Dt("source_raster_dem",n,`object expected, ${l} found`)),o;const u="custom"===Ai(n.encoding),c=["redFactor","greenFactor","blueFactor","baseShift"],h=t.value.encoding?`"${t.value.encoding}"`:"Default";for(const e in n)!u&&c.includes(e)?o.push(new Dt(e,n[e],`In "${r}": "${e}" is only valid when "encoding" is set to "custom". ${h} encoding found`)):s[e]?o=o.concat(t.validateSpec({key:e,value:n[e],valueSpec:s[e],validateSpec:t.validateSpec,style:a,styleSpec:i})):o.push(new Dt(e,n[e],`unknown property "${e}"`));return o}({sourceName:r,value:e,style:t.style,styleSpec:n,validateSpec:s}),o;case "geojson":if(o=Ei({key:r,value:e,valueSpec:n.source_geojson,style:i,styleSpec:n,validateSpec:s,objectElementValidators:Ni}),e.cluster)for(const t in e.clusterProperties){const[n,i]=e.clusterProperties[t],s="string"==typeof n?[n,["accumulated"],["get",t]]:n;o.push(...Fi({key:`${r}.${t}.map`,value:i,expressionContext:"cluster-map"})),o.push(...Fi({key:`${r}.${t}.reduce`,value:s,expressionContext:"cluster-reduce"}));}return o;case "video":return Ei({key:r,value:e,valueSpec:n.source_video,style:i,validateSpec:s,styleSpec:n});case "image":return Ei({key:r,value:e,valueSpec:n.source_image,style:i,validateSpec:s,styleSpec:n});case "canvas":return [new Dt(r,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return zi({key:`${r}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]}})}}function Ui(t){const e=t.value,r=t.styleSpec,n=r.light,i=t.style;let s=[];const a=Xn(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new Dt("light",e,`object expected, ${a} found`)]),s;for(const a in e){const o=a.match(/^(.*)-transition$/);s=s.concat(o&&n[o[1]]&&n[o[1]].transition?t.validateSpec({key:a,value:e[a],valueSpec:r.transition,validateSpec:t.validateSpec,style:i,styleSpec:r}):n[a]?t.validateSpec({key:a,value:e[a],valueSpec:n[a],validateSpec:t.validateSpec,style:i,styleSpec:r}):[new Dt(a,e[a],`unknown property "${a}"`)]);}return s}function qi(t){const e=t.value,r=t.styleSpec,n=r.sky,i=t.style,s=Xn(e);if(void 0===e)return [];if("object"!==s)return [new Dt("sky",e,`object expected, ${s} found`)];let a=[];for(const s in e)a=a.concat(n[s]?t.validateSpec({key:s,value:e[s],valueSpec:n[s],style:i,styleSpec:r}):[new Dt(s,e[s],`unknown property "${s}"`)]);return a}function ji(t){const e=t.value,r=t.styleSpec,n=r.terrain,i=t.style;let s=[];const a=Xn(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new Dt("terrain",e,`object expected, ${a} found`)]),s;for(const a in e)s=s.concat(n[a]?t.validateSpec({key:a,value:e[a],valueSpec:n[a],validateSpec:t.validateSpec,style:i,styleSpec:r}):[new Dt(a,e[a],`unknown property "${a}"`)]);return s}function Gi(t){let e=[];const r=t.value,n=t.key;if(Array.isArray(r)){const i=[],s=[];for(const a in r)r[a].id&&i.includes(r[a].id)&&e.push(new Dt(n,r,`all the sprites' ids must be unique, but ${r[a].id} is duplicated`)),i.push(r[a].id),r[a].url&&s.includes(r[a].url)&&e.push(new Dt(n,r,`all the sprites' URLs must be unique, but ${r[a].url} is duplicated`)),s.push(r[a].url),e=e.concat(Ei({key:`${n}[${a}]`,value:r[a],valueSpec:{id:{type:"string",required:!0},url:{type:"string",required:!0}},validateSpec:t.validateSpec}));return e}return Ri({key:n,value:r})}function Xi(t){return Boolean(t)&&t.constructor===Object}function Yi(t){return Xi(t.value)?[]:[new Dt(t.key,t.value,`object expected, ${Xn(t.value)} found`)]}const Zi={"*":()=>[],array:Ti,boolean:function(t){const e=t.value,r=t.key,n=Xn(e);return "boolean"!==n?[new Dt(r,e,`boolean expected, ${n} found`)]:[]},number:Ii,color:Di,constants:Si,enum:zi,filter:Pi,function:Mi,layer:Oi,object:Ei,source:$i,light:Ui,sky:qi,terrain:ji,projection:function(t){const e=t.value,r=t.styleSpec,n=r.projection,i=t.style,s=Xn(e);if(void 0===e)return [];if("object"!==s)return [new Dt("projection",e,`object expected, ${s} found`)];let a=[];for(const s in e)a=a.concat(n[s]?t.validateSpec({key:s,value:e[s],valueSpec:n[s],style:i,styleSpec:r}):[new Dt(s,e[s],`unknown property "${s}"`)]);return a},projectionDefinition:function(t){const e=t.key;let r=t.value;r=r instanceof String?r.valueOf():r;const n=Xn(r);return "array"!==n||function(t){return Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]}(r)||function(t){return !!["interpolate","step","literal"].includes(t[0])}(r)?["array","string"].includes(n)?[]:[new Dt(e,r,`projection expected, invalid type "${n}" found`)]:[new Dt(e,r,`projection expected, invalid array ${JSON.stringify(r)} found`)]},string:Ri,formatted:function(t){return 0===Ri(t).length?[]:Fi(t)},resolvedImage:function(t){return 0===Ri(t).length?[]:Fi(t)},padding:function(t){const e=t.key,r=t.value;if("array"===Xn(r)){if(r.length<1||r.length>4)return [new Dt(e,r,`padding requires 1 to 4 values; ${r.length} values found`)];const n={type:"number"};let i=[];for(let s=0;s<r.length;s++)i=i.concat(t.validateSpec({key:`${e}[${s}]`,value:r[s],validateSpec:t.validateSpec,valueSpec:n}));return i}return Ii({key:e,value:r,valueSpec:{}})},numberArray:function(t){const e=t.key,r=t.value;if("array"===Xn(r)){const n={type:"number"};if(r.length<1)return [new Dt(e,r,"array length at least 1 expected, length 0 found")];let i=[];for(let s=0;s<r.length;s++)i=i.concat(t.validateSpec({key:`${e}[${s}]`,value:r[s],validateSpec:t.validateSpec,valueSpec:n}));return i}return Ii({key:e,value:r,valueSpec:{}})},colorArray:function(t){const e=t.key,r=t.value;if("array"===Xn(r)){if(r.length<1)return [new Dt(e,r,"array length at least 1 expected, length 0 found")];let t=[];for(let n=0;n<r.length;n++)t=t.concat(Di({key:`${e}[${n}]`,value:r[n]}));return t}return Di({key:e,value:r})},variableAnchorOffsetCollection:function(t){const e=t.key,r=t.value,n=Xn(r),i=t.styleSpec;if("array"!==n||r.length<1||r.length%2!=0)return [new Dt(e,r,"variableAnchorOffsetCollection requires a non-empty array of even length")];let s=[];for(let n=0;n<r.length;n+=2)s=s.concat(zi({key:`${e}[${n}]`,value:r[n],valueSpec:i.layout_symbol["text-anchor"]})),s=s.concat(Ti({key:`${e}[${n+1}]`,value:r[n+1],valueSpec:{length:2,value:"number"},validateSpec:t.validateSpec,style:t.style,styleSpec:i}));return s},sprite:Gi,state:Yi,fontFaces:function(t){const e=t.key,r=t.value,n=t.validateSpec,i=t.styleSpec,s=t.style;if(!Xi(r))return [new Dt(e,r,`object expected, ${Xn(r)} found`)];const a=[];for(const t in r){const o=r[t],l=Xn(o);if("string"===l)a.push(...Ri({key:`${e}.${t}`,value:o}));else if("array"===l){const r={url:{type:"string",required:!0},"unicode-range":{type:"array",value:"string"}};for(const[l,u]of o.entries())a.push(...Ei({key:`${e}.${t}[${l}]`,value:u,valueSpec:r,styleSpec:i,style:s,validateSpec:n}));}else a.push(new Dt(`${e}.${t}`,o,`string or array expected, ${l} found`));}return a}};function Hi(t){const e=t.value,r=t.valueSpec,n=t.styleSpec;return t.validateSpec=Hi,r.expression&&Yn(Ai(e))?Mi(t):r.expression&&ri(ki(e))?Fi(t):r.type&&Zi[r.type]?Zi[r.type](t):Ei(zt({},t,{valueSpec:r.type?n[r.type]:r}))}function Ki(t){const e=t.value,r=t.key,n=Ri(t);return n.length||(-1===e.indexOf("{fontstack}")&&n.push(new Dt(r,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&n.push(new Dt(r,e,'"glyphs" url must include a "{range}" token'))),n}function Wi(t,e=vt){let r=[];return r=r.concat(Hi({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,validateSpec:Hi,objectElementValidators:{glyphs:Ki,"*":()=>[]}})),t.constants&&(r=r.concat(Si({key:"constants",value:t.constants}))),Qi(r)}function Ji(t){return function(e){return t(Object.assign({},e,{validateSpec:Hi}))}}function Qi(t){return [].concat(t).sort(((t,e)=>t.line-e.line))}function ts(t){return function(...e){return Qi(t.apply(this,e))}}Wi.source=ts(Ji($i)),Wi.sprite=ts(Ji(Gi)),Wi.glyphs=ts(Ji(Ki)),Wi.light=ts(Ji(Ui)),Wi.sky=ts(Ji(qi)),Wi.terrain=ts(Ji(ji)),Wi.state=ts(Ji(Yi)),Wi.layer=ts(Ji(Oi)),Wi.filter=ts(Ji(Pi)),Wi.paintProperty=ts(Ji(Ci)),Wi.layoutProperty=ts(Ji(Li));const es={type:"enum","property-type":"data-constant",expression:{interpolated:!1,parameters:["global-state"]},values:{visible:{},none:{}},transition:!1,default:"visible"};class rs{constructor(t,e){this._globalState=e,this.setValue(t);}evaluate(){var t;return null!==(t=this._literalValue)&&void 0!==t?t:this._compiledValue.evaluate({})}setValue(t){if(null==t||"visible"===t||"none"===t)return this._literalValue="none"===t?"none":"visible",this._compiledValue=void 0,void(this._globalStateRefs=new Set);const e=ni(t,es,this._globalState);if("error"===e.result)throw this._literalValue="visible",this._compiledValue=void 0,new Error(e.value.map((t=>`${t.key}: ${t.message}`)).join(", "));this._literalValue=void 0,this._compiledValue=e.value,this._globalStateRefs=ui(e.value.expression);}getGlobalStateRefs(){return this._globalStateRefs}}const ns=vt,is=Wi,ss=is.light,as=is.sky,os=is.paintProperty,ls=is.layoutProperty;function us(t,e){let r=!1;if(e&&e.length)for(const n of e)t.fire(new gt(new Error(n.message))),r=!0;return r}class cs{constructor(t,e,r){const n=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;const i=new Int32Array(this.arrayBuffer);t=i[0],this.d=(e=i[1])+2*(r=i[2]);for(let t=0;t<this.d*this.d;t++){const e=i[3+t],r=i[3+t+1];n.push(e===r?null:i.subarray(e,r));}const s=i[3+n.length+1];this.keys=i.subarray(i[3+n.length],s),this.bboxes=i.subarray(s),this.insert=this._insertReadonly;}else {this.d=e+2*r;for(let t=0;t<this.d*this.d;t++)n.push([]);this.keys=[],this.bboxes=[];}this.n=e,this.extent=t,this.padding=r,this.scale=e/t,this.uid=0;const i=r/e*t;this.min=-i,this.max=t+i;}insert(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++,void 0,void 0),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i);}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.")}_insertCell(t,e,r,n,i,s){this.cells[i].push(s);}query(t,e,r,n,i){const s=this.min,a=this.max;if(t<=s&&e<=s&&a<=r&&a<=n&&!i)return Array.prototype.slice.call(this.keys);{const s=[];return this._forEachCell(t,e,r,n,this._queryCell,s,{},i),s}}_queryCell(t,e,r,n,i,s,a,o){const l=this.cells[i];if(null!==l){const i=this.keys,u=this.bboxes;for(let c=0;c<l.length;c++){const h=l[c];if(void 0===a[h]){const l=4*h;(o?o(u[l+0],u[l+1],u[l+2],u[l+3]):t<=u[l+2]&&e<=u[l+3]&&r>=u[l+0]&&n>=u[l+1])?(a[h]=!0,s.push(i[h])):a[h]=!1;}}}}_forEachCell(t,e,r,n,i,s,a,o){const l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n);for(let p=l;p<=c;p++)for(let l=u;l<=h;l++){const u=this.d*l+p;if((!o||o(this._convertFromCellCoord(p),this._convertFromCellCoord(l),this._convertFromCellCoord(p+1),this._convertFromCellCoord(l+1)))&&i.call(this,t,e,r,n,u,s,a,o))return}}_convertFromCellCoord(t){return (t-this.padding)/this.scale}_convertToCellCoord(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const t=this.cells,e=3+this.cells.length+1+1;let r=0;for(let t=0;t<this.cells.length;t++)r+=this.cells[t].length;const n=new Int32Array(e+r+this.keys.length+this.bboxes.length);n[0]=this.extent,n[1]=this.n,n[2]=this.padding;let i=e;for(let e=0;e<t.length;e++){const r=t[e];n[3+e]=i,n.set(r,i),i+=r.length;}return n[3+t.length]=i,n.set(this.keys,i),i+=this.keys.length,n[3+t.length+1]=i,n.set(this.bboxes,i),i+=this.bboxes.length,n.buffer}static serialize(t,e){const r=t.toArrayBuffer();return e&&e.push(r),{buffer:r}}static deserialize(t){return new cs(t.buffer)}}const hs={};function ps(t,e,r={}){if(hs[t])throw new Error(`${t} is already registered.`);Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),hs[t]={klass:e,omit:r.omit||[],shallow:r.shallow||[]};}ps("Object",Object),ps("Set",Set),ps("TransferableGridIndex",cs),ps("Color",Te),ps("Error",Error),ps("AJAXError",ct),ps("ResolvedImage",Oe),ps("StylePropertyFunction",oi),ps("StyleExpression",ei,{omit:["_evaluator"]}),ps("ZoomDependentExpression",si),ps("ZoomConstantExpression",ii),ps("CompoundExpression",zn,{omit:["_evaluate"]});for(const t in Dn)Dn[t]._classRegistryKey||ps(`Expression_${t}`,Dn[t]);function fs(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function ds(t){return t.$name||t.constructor._classRegistryKey}function ys(t){return !function(t){if(null===t||"object"!=typeof t)return !1;const e=ds(t);return !(!e||"Object"===e)}(t)&&(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||t instanceof Blob||t instanceof Error||fs(t)||Z(t)||ArrayBuffer.isView(t)||t instanceof ImageData)}function ms(t,e){if(ys(t))return (fs(t)||Z(t))&&e&&e.push(t),ArrayBuffer.isView(t)&&e&&e.push(t.buffer),t instanceof ImageData&&e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(ms(n,e));return r}if("object"!=typeof t)throw new Error("can't serialize object of type "+typeof t);const r=ds(t);if(!r)throw new Error(`can't serialize object of unregistered class ${t.constructor.name}`);if(!hs[r])throw new Error(`${r} is not registered.`);const{klass:n}=hs[r],i=n.serialize?n.serialize(t,e):{};if(n.serialize){if(e&&i===e[e.length-1])throw new Error("statically serialized object won't survive transfer of $name property")}else {for(const n in t){if(!t.hasOwnProperty(n))continue;if(hs[r].omit.indexOf(n)>=0)continue;const s=t[n];i[n]=hs[r].shallow.indexOf(n)>=0?s:ms(s,e);}t instanceof Error&&(i.message=t.message);}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==r&&(i.$name=r),i}function gs(t){if(ys(t))return t;if(Array.isArray(t))return t.map(gs);if("object"!=typeof t)throw new Error("can't deserialize object of type "+typeof t);const e=ds(t)||"Object";if(!hs[e])throw new Error(`can't deserialize unregistered class ${e}`);const{klass:r}=hs[e];if(!r)throw new Error(`can't deserialize unregistered class ${e}`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const r of Object.keys(t)){if("$name"===r)continue;const i=t[r];n[r]=hs[e].shallow.indexOf(r)>=0?i:gs(i);}return n}class xs{constructor(){this.first=!0;}update(t,e){const r=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=r,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=r,!0):(this.lastFloorZoom>r?(this.lastIntegerZoom=r+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<r&&(this.lastIntegerZoom=r,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=r,!0))}}function vs(t){return /[\u02EA\u02EB\u2E80-\u2FDF\u2FF0-\u303F\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FD-\u30FF\u3105-\u312F\u31A0-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uF900-\uFA6D\uFA70-\uFAD9\uFE10-\uFE1F\uFE30-\uFE4F\uFF00-\uFFEF]|\uD81B[\uDFE0-\uDFFF]|[\uD81C-\uD822\uD840-\uD868\uD86A-\uD86D\uD86F-\uD872\uD874-\uD879\uD880-\uD883\uD885-\uD88C][\uDC00-\uDFFF]|\uD823[\uDC00-\uDCD5\uDCFF-\uDD1E\uDD80-\uDDF2]|\uD82B[\uDFF0-\uDFFF]|\uD82C[\uDC00-\uDEFB]|\uD83C[\uDE00-\uDEFF]|\uD869[\uDC00-\uDEDF\uDF00-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEAD\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0\uDFF0-\uDFFF]|\uD87B[\uDC00-\uDE5D]|\uD87E[\uDC00-\uDE1D]|\uD884[\uDC00-\uDF4A\uDF50-\uDFFF]|\uD88D[\uDC00-\uDC79]/gim.test(String.fromCodePoint(t))}function bs(t){return /[\u02EA\u02EB\u1100-\u11FF\u1400-\u167F\u18B0-\u18F5\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u3007\u3012\u3013\u3020-\u302F\u3031-\u303F\u3041-\u3096\u309D-\u30FB\u30FD-\u30FF\u3105-\u312F\u3131-\u318E\u3190-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFE10-\uFE1F\uFE30-\uFE48\uFE50-\uFE57\uFE5F-\uFE62\uFE67-\uFE6F\uFF00-\uFF07\uFF0A-\uFF0C\uFF0E-\uFF19\uFF1F-\uFF3A\uFF3C\uFF3E\uFF40-\uFF5A\uFFE0-\uFFE2\uFFE4-\uFFE7]|\uD802[\uDD80-\uDD9F]|\uD805[\uDD80-\uDDFF]|\uD806[\uDE00-\uDEBF]|\uD811[\uDC00-\uDE7F]|\uD81B[\uDFE0-\uDFE4\uDFF0-\uDFF6]|[\uD81C-\uD822\uD83D\uD840-\uD868\uD86A-\uD86D\uD86F-\uD872\uD874-\uD879\uD880-\uD883\uD885-\uD88C][\uDC00-\uDFFF]|\uD823[\uDC00-\uDCD5\uDCFF-\uDD1E\uDD80-\uDDF2]|\uD82B[\uDFF0-\uDFF3\uDFF5-\uDFFB\uDFFD\uDFFE]|\uD82C[\uDC00-\uDD22\uDD30-\uDEFB]|\uD833[\uDEC0-\uDFCF]|\uD834[\uDC00-\uDDFF\uDEE0-\uDF7F]|\uD836[\uDC00-\uDEAF]|\uD83C[\uDC00-\uDE00\uDF00-\uDFFF]|\uD83E[\uDD00-\uDEFF]|\uD869[\uDC00-\uDEDF\uDF00-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEAD\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0\uDFF0-\uDFFF]|\uD87B[\uDC00-\uDE5D]|\uD87E[\uDC00-\uDE1D]|\uD884[\uDC00-\uDF4A\uDF50-\uDFFF]|\uD88D[\uDC00-\uDC79]/gim.test(String.fromCodePoint(t))}function ws(t){return /\s/u.test(String.fromCodePoint(t))}function _s(t){for(const e of t)if(bs(e.codePointAt(0)))return !0;return !1}function Ss(t){for(const e of t)if(!Es(e.codePointAt(0)))return !1;return !0}function As(t){const e=t.map((t=>{try{return new RegExp(`\\p{sc=${t}}`,"u").source}catch(t){return null}})).filter((t=>t));return new RegExp(e.join("|"),"u")}const ks=As(["Arab","Dupl","Mong","Ougr","Syrc"]);function Es(t){return !ks.test(String.fromCodePoint(t))}function Ts(t){return !(bs(t)||(e=t,/[\xA7\xA9\xAE\xB1\xBC-\xBE\xD7\xF7\u2016\u2020\u2021\u2030\u2031\u203B\u203C\u2042\u2047-\u2049\u2051\u2100-\u218F\u221E\u2234\u2235\u2300-\u2307\u230C-\u231F\u2324-\u2328\u232B\u237D-\u239A\u23BE-\u23CD\u23CF\u23D1-\u23DB\u23E2-\u2422\u2424-\u24FF\u25A0-\u2619\u2620-\u2767\u2776-\u2793\u2B12-\u2B2F\u2B50-\u2B59\u2BB8-\u2BEB\u3000-\u303F\u30A0-\u30FF\uE000-\uF8FF\uFE30-\uFE6F\uFF00-\uFFEF\uFFFC\uFFFD]|[\uDB80-\uDBFF][\uDC00-\uDFFF]/gim.test(String.fromCodePoint(e))));var e;}const Is=As(["Adlm","Arab","Armi","Avst","Chrs","Cprt","Egyp","Elym","Gara","Hatr","Hebr","Hung","Khar","Lydi","Mand","Mani","Mend","Merc","Mero","Narb","Nbat","Nkoo","Orkh","Palm","Phli","Phlp","Phnx","Prti","Rohg","Samr","Sarb","Sogo","Syrc","Thaa","Todr","Yezi"]);function Ms(t){return Is.test(String.fromCodePoint(t))}function Fs(t,e){return !(!e&&Ms(t)||/[\u0900-\u0DFF\u0F00-\u109F\u1780-\u17FF]/gim.test(String.fromCodePoint(t)))}function Ds(t){for(const e of t)if(Ms(e.codePointAt(0)))return !0;return !1}const zs=new class{constructor(){this.TIMEOUT=5e3,this.applyArabicShaping=null,this.processBidirectionalText=null,this.processStyledBidirectionalText=null,this.pluginStatus="unavailable",this.pluginURL=null,this.loadScriptResolve=()=>{};}setState(t){this.pluginStatus=t.pluginStatus,this.pluginURL=t.pluginURL;}getState(){return {pluginStatus:this.pluginStatus,pluginURL:this.pluginURL}}setMethods(t){if(zs.isParsed())throw new Error("RTL text plugin already registered.");this.applyArabicShaping=t.applyArabicShaping,this.processBidirectionalText=t.processBidirectionalText,this.processStyledBidirectionalText=t.processStyledBidirectionalText,this.loadScriptResolve();}isParsed(){return null!=this.applyArabicShaping&&null!=this.processBidirectionalText&&null!=this.processStyledBidirectionalText}getRTLTextPluginStatus(){return this.pluginStatus}syncState(t,r){return e(this,void 0,void 0,(function*(){if(this.isParsed())return this.getState();if("loading"!==t.pluginStatus)return this.setState(t),t;const e=t.pluginURL,n=new Promise((t=>{this.loadScriptResolve=t;}));r(e);const i=new Promise((t=>setTimeout((()=>t()),this.TIMEOUT)));if(yield Promise.race([n,i]),this.isParsed()){const t={pluginStatus:"loaded",pluginURL:e};return this.setState(t),t}throw this.setState({pluginStatus:"error",pluginURL:""}),new Error(`RTL Text Plugin failed to import scripts from ${e}`)}))}};class Ps{constructor(t,e){this.isSupportedScript=Bs,this.zoom=t,e?(this.now=e.now||0,this.fadeDuration=e.fadeDuration||0,this.zoomHistory=e.zoomHistory||new xs,this.transition=e.transition||{}):(this.now=0,this.fadeDuration=0,this.zoomHistory=new xs,this.transition={});}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),r=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*r}:{fromScale:.5,toScale:1,t:1-(1-r)*e}}}function Bs(t){return function(t,e){for(const r of t)if(!Fs(r.codePointAt(0),e))return !1;return !0}(t,"loaded"===zs.getRTLTextPluginStatus())}const Vs="-transition";class Cs{constructor(t,e,r){this.property=t,this.value=e,this.expression=function(t,e,r){if(Yn(t))return new oi(t,e);if(ri(t)){const n=ai(t,e,r);if("error"===n.result)throw new Error(n.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return n.value}{let r=t;return "color"===e.type&&"string"==typeof t?r=Te.parse(t):"padding"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"numberArray"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"colorArray"!==e.type||"string"!=typeof t&&!Array.isArray(t)?"variableAnchorOffsetCollection"===e.type&&Array.isArray(t)?r=Le.parse(t):"projectionDefinition"===e.type&&"string"==typeof t&&(r=Re.parse(t)):r=Be.parse(t):r=Pe.parse(t):r=ze.parse(t),{globalStateRefs:new Set,_globalState:null,kind:"constant",evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification,r);}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}getGlobalStateRefs(){return this.expression.globalStateRefs||new Set}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class Ls{constructor(t,e){this.property=t,this.value=new Cs(t,void 0,e);}transitioned(t,e){return new Rs(this.property,this.value,e,O({},t.transition,this.transition),t.now)}untransitioned(){return new Rs(this.property,this.value,null,{},0)}}class Os{constructor(t,e){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues),this._globalState=e;}getValue(t){return U(this._values[t].value.value)}setValue(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Ls(this._values[t].property,this._globalState)),this._values[t].value=new Cs(this._values[t].property,null===e?void 0:U(e),this._globalState);}getTransition(t){return U(this._values[t].transition)}setTransition(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Ls(this._values[t].property,this._globalState)),this._values[t].transition=U(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}${Vs}`]=n);}return t}transitioned(t,e){const r=new Ns(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new Ns(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class Rs{constructor(t,e,r,n,i){this.property=t,this.value=e,this.begin=i+n.delay||0,this.end=this.begin+n.duration||0,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),s=this.prior;if(s){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return s.possiblyEvaluate(t,e,r);{const a=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,r),i,P(a))}}return i}}class Ns{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const n=new qs(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return !0;return !1}}class $s{constructor(t,e){this._properties=t,this._values=Object.create(t.defaultPropertyValues),this._globalState=e;}hasValue(t){return void 0!==this._values[t].value}getValue(t){return U(this._values[t].value)}setValue(t,e){this._values[t]=new Cs(this._values[t].property,null===e?void 0:U(e),this._globalState);}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t}possiblyEvaluate(t,e,r){const n=new qs(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}}class Us{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r;}isConstant(){return "constant"===this.value.kind}constantOr(t){return "constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n)}}class qs{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t]}}class js{constructor(t){this.specification=t;}possiblyEvaluate(t,e){if(t.isDataDriven())throw new Error("Value should not be data driven");return t.expression.evaluate(e)}interpolate(t,e,r){const n=yr[this.specification.type];return n?n(t,e,r):t}}class Gs{constructor(t,e){this.specification=t,this.overrides=e;}possiblyEvaluate(t,e,r,n){return new Us(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new Us(this,{kind:"constant",value:void 0},t.parameters);const n=yr[this.specification.type];if(n){const i=n(t.value.value,e.value.value,r);return new Us(this,{kind:"constant",value:i},t.parameters)}return t}evaluate(t,e,r,n,i,s){return "constant"===t.kind?t.value:t.evaluate(e,r,n,i,s)}}class Xs extends Gs{possiblyEvaluate(t,e,r,n){if(void 0===t.value)return new Us(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n),s="resolvedImage"===t.property.specification.type&&"string"!=typeof i?i.name:i,a=this._calculate(s,s,s,e);return new Us(this,{kind:"constant",value:a},e)}if("camera"===t.expression.kind){const r=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new Us(this,{kind:"constant",value:r},e)}return new Us(this,t.expression,e)}evaluate(t,e,r,n,i,s){if("source"===t.kind){const a=t.evaluate(e,r,n,i,s);return this._calculate(a,a,a,e)}return "composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},r,n),t.evaluate({zoom:Math.floor(e.zoom)},r,n),t.evaluate({zoom:Math.floor(e.zoom)+1},r,n),e):t.value}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class Ys{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){if(void 0!==t.value){if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n);return this._calculate(i,i,i,e)}return this._calculate(t.expression.evaluate(new Ps(Math.floor(e.zoom-1),e)),t.expression.evaluate(new Ps(Math.floor(e.zoom),e)),t.expression.evaluate(new Ps(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class Zs{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){return !!t.expression.evaluate(e,null,{},r,n)}interpolate(){return !1}}class Hs{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const r=t[e];r.specification.overridable&&this.overridableProperties.push(e);const n=this.defaultPropertyValues[e]=new Cs(r,void 0,void 0),i=this.defaultTransitionablePropertyValues[e]=new Ls(r,void 0);this.defaultTransitioningPropertyValues[e]=i.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=n.possiblyEvaluate({});}}}ps("DataDrivenProperty",Gs),ps("DataConstantProperty",js),ps("CrossFadedDataDrivenProperty",Xs),ps("CrossFadedProperty",Ys),ps("ColorRampProperty",Zs);class Ks extends xt{constructor(t,e,r){if(super(),this.id=t.id,this.type=t.type,this._globalState=r,this._featureFilter={filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set},this._visibilityExpression=function(t,e){return new rs(t,e)}(this.visibility,r),"custom"!==t.type&&(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter,this._featureFilter=fi(t.filter,r)),e.layout&&(this._unevaluatedLayout=new $s(e.layout,r)),e.paint)){this._transitionablePaint=new Os(e.paint,r);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new qs(e.paint);}}setFilter(t){this.filter=t,this._featureFilter=fi(t,this._globalState);}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return "visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}getLayoutAffectingGlobalStateRefs(){const t=new Set;for(const e of this._visibilityExpression.getGlobalStateRefs())t.add(e);if(this._unevaluatedLayout)for(const e in this._unevaluatedLayout._values){const r=this._unevaluatedLayout._values[e];for(const e of r.getGlobalStateRefs())t.add(e);}for(const e of this._featureFilter.getGlobalStateRefs())t.add(e);return t}getPaintAffectingGlobalStateRefs(){var t;const e=new globalThis.Map;if(this._transitionablePaint)for(const r in this._transitionablePaint._values){const n=this._transitionablePaint._values[r].value;for(const i of n.getGlobalStateRefs()){const s=null!==(t=e.get(i))&&void 0!==t?t:[];s.push({name:r,value:n.value}),e.set(i,s);}}return e}getVisibilityAffectingGlobalStateRefs(){return this._visibilityExpression.getGlobalStateRefs()}setLayoutProperty(t,e,r={}){if(null==e||!this._validate(ls,`layers.${this.id}.layout.${t}`,t,e,r))return "visibility"===t?(this.visibility=e,this._visibilityExpression.setValue(e),void this.recalculateVisibility()):void this._unevaluatedLayout.setValue(t,e)}getPaintProperty(t){return t.endsWith(Vs)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,r={}){if(null!=e&&this._validate(os,`layers.${this.id}.paint.${t}`,t,e,r))return !1;if(t.endsWith(Vs))return this._transitionablePaint.setTransition(t.slice(0,-11),e||void 0),!1;{const r=this._transitionablePaint._values[t],n="cross-faded-data-driven"===r.property.specification["property-type"],i=r.value.isDataDriven(),s=r.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const a=this._transitionablePaint._values[t].value;return a.isDataDriven()||i||n||this._handleOverridablePaintPropertyUpdate(t,s,a)}}_handleSpecialPaintPropertyUpdate(t){}_handleOverridablePaintPropertyUpdate(t,e,r){return !1}isHidden(t=this.minzoom,e=!1){return !!(this.minzoom&&t<(e?Math.floor(this.minzoom):this.minzoom))||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this._evaluatedVisibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculateVisibility(){this._evaluatedVisibility=this._visibilityExpression.evaluate();}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),$(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}_validate(t,e,r,n,i={}){return (!i||!1!==i.validate)&&us(this,t.call(is,{key:e,layerType:this.type,objectKey:r,value:n,styleSpec:vt,style:{glyphs:!0,sprite:!0}}))}is3D(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof Us&&qn(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return !0}return !1}}let Ws;var Js={get paint(){return Ws=Ws||new Hs({"raster-opacity":new js(vt.paint_raster["raster-opacity"]),"raster-hue-rotate":new js(vt.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new js(vt.paint_raster["raster-brightness-min"]),"raster-brightness-max":new js(vt.paint_raster["raster-brightness-max"]),"raster-saturation":new js(vt.paint_raster["raster-saturation"]),"raster-contrast":new js(vt.paint_raster["raster-contrast"]),"raster-resampling":new js(vt.paint_raster["raster-resampling"]),"raster-fade-duration":new js(vt.paint_raster["raster-fade-duration"])})}};class Qs extends Ks{constructor(t,e){super(t,Js,e);}}const ta={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class ea{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}class ra{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0);}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t),this.length=t;}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e);}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function na(t,e=1){let r=0,n=0;return {members:t.map((t=>{const i=ta[t.type].BYTES_PER_ELEMENT,s=r=ia(r,Math.max(e,i)),a=t.components||1;return n=Math.max(n,i),r+=i*a,{name:t.name,type:t.type,components:a,offset:s}})),size:ia(r,Math.max(n,e)),alignment:e}}function ia(t,e){return Math.ceil(t/e)*e}class sa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t}}sa.prototype.bytesPerElement=4,ps("StructArrayLayout2i4",sa);class aa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}aa.prototype.bytesPerElement=6,ps("StructArrayLayout3i6",aa);class oa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,t}}oa.prototype.bytesPerElement=8,ps("StructArrayLayout4i8",oa);class la extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,this.int16[o+5]=a,t}}la.prototype.bytesPerElement=12,ps("StructArrayLayout2i4i12",la);class ua extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=4*t,l=8*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.uint8[l+4]=n,this.uint8[l+5]=i,this.uint8[l+6]=s,this.uint8[l+7]=a,t}}ua.prototype.bytesPerElement=8,ps("StructArrayLayout2i4ub8",ua);class ca extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t}}ca.prototype.bytesPerElement=8,ps("StructArrayLayout2f8",ca);class ha extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,r,n,i,s,a,o,l,u)}emplace(t,e,r,n,i,s,a,o,l,u,c){const h=10*t;return this.uint16[h+0]=e,this.uint16[h+1]=r,this.uint16[h+2]=n,this.uint16[h+3]=i,this.uint16[h+4]=s,this.uint16[h+5]=a,this.uint16[h+6]=o,this.uint16[h+7]=l,this.uint16[h+8]=u,this.uint16[h+9]=c,t}}ha.prototype.bytesPerElement=20,ps("StructArrayLayout10ui20",ha);class pa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o){const l=this.length;return this.resize(l+1),this.emplace(l,t,e,r,n,i,s,a,o)}emplace(t,e,r,n,i,s,a,o,l){const u=8*t;return this.uint16[u+0]=e,this.uint16[u+1]=r,this.uint16[u+2]=n,this.uint16[u+3]=i,this.uint16[u+4]=s,this.uint16[u+5]=a,this.uint16[u+6]=o,this.uint16[u+7]=l,t}}pa.prototype.bytesPerElement=16,ps("StructArrayLayout8ui16",pa);class fa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,n,i,s,a,o,l,u,c,h)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=12*t;return this.int16[f+0]=e,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.uint16[f+4]=s,this.uint16[f+5]=a,this.uint16[f+6]=o,this.uint16[f+7]=l,this.int16[f+8]=u,this.int16[f+9]=c,this.int16[f+10]=h,this.int16[f+11]=p,t}}fa.prototype.bytesPerElement=24,ps("StructArrayLayout4i4ui4i24",fa);class da extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}da.prototype.bytesPerElement=12,ps("StructArrayLayout3f12",da);class ya extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}ya.prototype.bytesPerElement=4,ps("StructArrayLayout1ul4",ya);class ma extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l){const u=this.length;return this.resize(u+1),this.emplace(u,t,e,r,n,i,s,a,o,l)}emplace(t,e,r,n,i,s,a,o,l,u){const c=10*t,h=5*t;return this.int16[c+0]=e,this.int16[c+1]=r,this.int16[c+2]=n,this.int16[c+3]=i,this.int16[c+4]=s,this.int16[c+5]=a,this.uint32[h+3]=o,this.uint16[c+8]=l,this.uint16[c+9]=u,t}}ma.prototype.bytesPerElement=20,ps("StructArrayLayout6i1ul2ui20",ma);class ga extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,this.int16[o+5]=a,t}}ga.prototype.bytesPerElement=12,ps("StructArrayLayout2i2i2i12",ga);class xa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=4*t,o=8*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.int16[o+6]=i,this.int16[o+7]=s,t}}xa.prototype.bytesPerElement=16,ps("StructArrayLayout2f1f2i16",xa);class va extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=16*t,l=4*t,u=8*t;return this.uint8[o+0]=e,this.uint8[o+1]=r,this.float32[l+1]=n,this.float32[l+2]=i,this.int16[u+6]=s,this.int16[u+7]=a,t}}va.prototype.bytesPerElement=16,ps("StructArrayLayout2ub2f2i16",va);class ba extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,this.uint16[i+2]=n,t}}ba.prototype.bytesPerElement=6,ps("StructArrayLayout3ui6",ba);class wa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m){const g=this.length;return this.resize(g+1),this.emplace(g,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g){const x=24*t,v=12*t,b=48*t;return this.int16[x+0]=e,this.int16[x+1]=r,this.uint16[x+2]=n,this.uint16[x+3]=i,this.uint32[v+2]=s,this.uint32[v+3]=a,this.uint32[v+4]=o,this.uint16[x+10]=l,this.uint16[x+11]=u,this.uint16[x+12]=c,this.float32[v+7]=h,this.float32[v+8]=p,this.uint8[b+36]=f,this.uint8[b+37]=d,this.uint8[b+38]=y,this.uint32[v+10]=m,this.int16[x+22]=g,t}}wa.prototype.bytesPerElement=48,ps("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",wa);class _a extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,k,E,T){const I=this.length;return this.resize(I+1),this.emplace(I,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,k,E,T)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,k,E,T,I){const M=32*t,F=16*t;return this.int16[M+0]=e,this.int16[M+1]=r,this.int16[M+2]=n,this.int16[M+3]=i,this.int16[M+4]=s,this.int16[M+5]=a,this.int16[M+6]=o,this.int16[M+7]=l,this.uint16[M+8]=u,this.uint16[M+9]=c,this.uint16[M+10]=h,this.uint16[M+11]=p,this.uint16[M+12]=f,this.uint16[M+13]=d,this.uint16[M+14]=y,this.uint16[M+15]=m,this.uint16[M+16]=g,this.uint16[M+17]=x,this.uint16[M+18]=v,this.uint16[M+19]=b,this.uint16[M+20]=w,this.uint16[M+21]=_,this.uint16[M+22]=S,this.uint32[F+12]=A,this.float32[F+13]=k,this.float32[F+14]=E,this.uint16[M+30]=T,this.uint16[M+31]=I,t}}_a.prototype.bytesPerElement=64,ps("StructArrayLayout8i15ui1ul2f2ui64",_a);class Sa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}Sa.prototype.bytesPerElement=4,ps("StructArrayLayout1f4",Sa);class Aa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[6*t+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}Aa.prototype.bytesPerElement=12,ps("StructArrayLayout1ui2f12",Aa);class ka extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=4*t;return this.uint32[2*t+0]=e,this.uint16[i+2]=r,this.uint16[i+3]=n,t}}ka.prototype.bytesPerElement=8,ps("StructArrayLayout1ul2ui8",ka);class Ea extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t}}Ea.prototype.bytesPerElement=4,ps("StructArrayLayout2ui4",Ea);class Ta extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}Ta.prototype.bytesPerElement=2,ps("StructArrayLayout1ui2",Ta);class Ia extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,t}}Ia.prototype.bytesPerElement=16,ps("StructArrayLayout4f16",Ia);class Ma extends ea{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.int16[this._pos2+2]}get y1(){return this._structArray.int16[this._pos2+3]}get x2(){return this._structArray.int16[this._pos2+4]}get y2(){return this._structArray.int16[this._pos2+5]}get featureIndex(){return this._structArray.uint32[this._pos4+3]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8]}get bucketIndex(){return this._structArray.uint16[this._pos2+9]}get anchorPoint(){return new r(this.anchorPointX,this.anchorPointY)}}Ma.prototype.size=20;class Fa extends ma{get(t){return new Ma(this,t)}}ps("CollisionBoxArray",Fa);class Da extends ea{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t;}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(t){this._structArray.uint8[this._pos1+38]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}Da.prototype.size=48;class za extends wa{get(t){return new Da(this,t)}}ps("PlacedSymbolArray",za);class Pa extends ea{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t;}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+14]}get textAnchorOffsetStartIndex(){return this._structArray.uint16[this._pos2+30]}get textAnchorOffsetEndIndex(){return this._structArray.uint16[this._pos2+31]}}Pa.prototype.size=64;class Ba extends _a{get(t){return new Pa(this,t)}}ps("SymbolInstanceArray",Ba);class Va extends Sa{getoffsetX(t){return this.float32[1*t+0]}}ps("GlyphOffsetArray",Va);class Ca extends aa{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}ps("SymbolLineVertexArray",Ca);class La extends ea{get textAnchor(){return this._structArray.uint16[this._pos2+0]}get textOffset0(){return this._structArray.float32[this._pos4+1]}get textOffset1(){return this._structArray.float32[this._pos4+2]}}La.prototype.size=12;class Oa extends Aa{get(t){return new La(this,t)}}ps("TextAnchorOffsetArray",Oa);class Ra extends ea{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}Ra.prototype.size=8;class Na extends ka{get(t){return new Ra(this,t)}}ps("FeatureIndexArray",Na);class $a extends sa{}class Ua extends sa{}class qa extends sa{}class ja extends la{}class Ga extends ua{}class Xa extends ca{}class Ya extends ha{}class Za extends pa{}class Ha extends fa{}class Ka extends da{}class Wa extends ya{}class Ja extends ga{}class Qa extends va{}class to extends ba{}class eo extends Ea{}const ro=na([{name:"a_pos",components:2,type:"Int16"}],4),{members:no}=ro;class io{constructor(t=[]){this._forceNewSegmentOnNextPrepare=!1,this.segments=t;}prepareSegment(t,e,r,n){const i=this.segments[this.segments.length-1];return t>io.MAX_VERTEX_ARRAY_LENGTH&&j(`Max vertices per segment is ${io.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}. Consider using the \`fillLargeMeshArrays\` function if you require meshes with more than ${io.MAX_VERTEX_ARRAY_LENGTH} vertices.`),this._forceNewSegmentOnNextPrepare||!i||i.vertexLength+t>io.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n?this.createNewSegment(e,r,n):i}createNewSegment(t,e,r){const n={vertexOffset:t.length,primitiveOffset:e.length,vertexLength:0,primitiveLength:0,vaos:{}};return void 0!==r&&(n.sortKey=r),this._forceNewSegmentOnNextPrepare=!1,this.segments.push(n),n}getOrCreateLatestSegment(t,e,r){return this.prepareSegment(0,t,e,r)}forceNewSegmentOnNextPrepare(){this._forceNewSegmentOnNextPrepare=!0;}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,n){return new io([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}function so(t,e){return 256*(t=C(Math.floor(t),0,255))+C(Math.floor(e),0,255)}io.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,ps("SegmentVector",io);const ao=na([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]),oo=na([{name:"a_dasharray_from",components:4,type:"Uint16"},{name:"a_dasharray_to",components:4,type:"Uint16"}]);var lo,uo,co,ho={exports:{}},po={exports:{}},fo={exports:{}},yo=function(){if(co)return ho.exports;co=1;var t=(lo||(lo=1,po.exports=function(t,e){var r,n,i,s,a,o,l,u;for(n=t.length-(r=3&t.length),i=e,a=3432918353,o=461845907,u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,i=27492+(65535&(s=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295;}return i^=t.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0}),po.exports),e=(uo||(uo=1,fo.exports=function(t,e){for(var r,n=t.length,i=e^n,s=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++s;switch(n){case 3:i^=(255&t.charCodeAt(s+2))<<16;case 2:i^=(255&t.charCodeAt(s+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(s)))+((1540483477*(i>>>16)&65535)<<16);}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0}),fo.exports);return ho.exports=t,ho.exports.murmur3=t,ho.exports.murmur2=e,ho.exports}(),mo=n(yo);class go{constructor(){this.ids=[],this.positions=[],this.indexed=!1;}add(t,e,r,n){this.ids.push(xo(t)),this.positions.push(e,r,n);}getPositions(t){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const e=xo(t);let r=0,n=this.ids.length-1;for(;r<n;){const t=r+n>>1;this.ids[t]>=e?n=t:r=t+1;}const i=[];for(;this.ids[r]===e;)i.push({index:this.positions[3*r],start:this.positions[3*r+1],end:this.positions[3*r+2]}),r++;return i}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return vo(r,n,0,r.length-1),e&&e.push(r.buffer,n.buffer),{ids:r,positions:n}}static deserialize(t){const e=new go;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function xo(t){const e=+t;return !isNaN(e)&&e<=Number.MAX_SAFE_INTEGER?e:mo(String(t))}function vo(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let s=r-1,a=n+1;for(;;){do{s++;}while(t[s]<i);do{a--;}while(t[a]>i);if(s>=a)break;bo(t,s,a),bo(e,3*s,3*a),bo(e,3*s+1,3*a+1),bo(e,3*s+2,3*a+2);}a-r<n-a?(vo(t,e,r,a),r=a+1):(vo(t,e,a+1,n),n=a);}}function bo(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}ps("FeaturePositionMap",go);class wo{constructor(t,e){this.gl=t.gl,this.location=e;}}class _o extends wo{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t));}}class So extends wo{constructor(t,e){super(t,e),this.current=[0,0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]));}}class Ao extends wo{constructor(t,e){super(t,e),this.current=Te.transparent;}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a));}}const ko=new Float32Array(16);function Eo(t){return [so(255*t.r,255*t.g),so(255*t.b,255*t.a)]}class To{constructor(t,e,r){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=r;}setUniform(t,e,r){t.set(r.constantOr(this.value));}getBinding(t,e,r){return "color"===this.type?new Ao(t,e):new _o(t,e)}}class Io{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1;}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tlbr,this.patternTo=t.tlbr;}setConstantDashPositions(t,e){this.dashTo=[0,t.y,t.height,t.width],this.dashFrom=[0,e.y,e.height,e.width];}setUniform(t,e,r,n){let i=null;"u_pattern_to"===n?i=this.patternTo:"u_pattern_from"===n?i=this.patternFrom:"u_dasharray_to"===n?i=this.dashTo:"u_dasharray_from"===n?i=this.dashFrom:"u_pixel_ratio_to"===n?i=this.pixelRatioTo:"u_pixel_ratio_from"===n&&(i=this.pixelRatioFrom),null!==i&&t.set(i);}getBinding(t,e,r){return "u_pattern"===r.substr(0,9)||"u_dasharray_"===r.substr(0,12)?new So(t,e):new _o(t,e)}}class Mo{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n;}populatePaintArray(t,e,r){const n=this.paintVertexArray.length,i=this.expression.evaluate(new Ps(0,r),e,{},r.canonical,[],r.formattedSection);this.paintVertexArray.resize(t),this._setPaintValue(n,t,i);}updatePaintArray(t,e,r,n,i){const s=this.expression.evaluate(new Ps(0,i),r,n);this._setPaintValue(t,e,s);}_setPaintValue(t,e,r){if("color"===this.type){const n=Eo(r);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1]);}else {for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class Fo{constructor(t,e,r,n,i,s){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=r,this.useIntegerZoom=n,this.zoom=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new s;}populatePaintArray(t,e,r){const n=this.expression.evaluate(new Ps(this.zoom,r),e,{},r.canonical,[],r.formattedSection),i=this.expression.evaluate(new Ps(this.zoom+1,r),e,{},r.canonical,[],r.formattedSection),s=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(s,t,n,i);}updatePaintArray(t,e,r,n,i){const s=this.expression.evaluate(new Ps(this.zoom,i),r,n),a=this.expression.evaluate(new Ps(this.zoom+1,i),r,n);this._setPaintValue(t,e,s,a);}_setPaintValue(t,e,r,n){if("color"===this.type){const i=Eo(r),s=Eo(n);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1],s[0],s[1]);}else {for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e){const r=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,n=C(this.expression.interpolationFactor(r,this.zoom,this.zoom+1),0,1);t.set(n);}getBinding(t,e,r){return new _o(t,e)}}class Do{constructor(t,e,r,n,i,s){this.expression=t,this.type=e,this.useIntegerZoom=r,this.zoom=n,this.layerId=s,this.zoomInPaintVertexArray=new i,this.zoomOutPaintVertexArray=new i;}populatePaintArray(t,e,r){const n=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(n,t,this.getPositionIds(e),r);}updatePaintArray(t,e,r,n,i){this._setPaintValues(t,e,this.getPositionIds(r),i);}_setPaintValues(t,e,r,n){const i=this.getPositions(n);if(!i||!r)return;const s=i[r.min],a=i[r.mid],o=i[r.max];if(s&&a&&o)for(let r=t;r<e;r++)this.emplace(this.zoomInPaintVertexArray,r,a,s),this.emplace(this.zoomOutPaintVertexArray,r,a,o);}upload(t){if(this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer){const e=this.getVertexAttributes();this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,e,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,e,this.expression.isStateDependent);}}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy();}}class zo extends Do{getPositions(t){return t.imagePositions}getPositionIds(t){return t.patterns&&t.patterns[this.layerId]}getVertexAttributes(){return ao.members}emplace(t,e,r,n){t.emplace(e,r.tlbr[0],r.tlbr[1],r.tlbr[2],r.tlbr[3],n.tlbr[0],n.tlbr[1],n.tlbr[2],n.tlbr[3],r.pixelRatio,n.pixelRatio);}}class Po extends Do{getPositions(t){return t.dashPositions}getPositionIds(t){return t.dashes&&t.dashes[this.layerId]}getVertexAttributes(){return oo.members}emplace(t,e,r,n){t.emplace(e,0,r.y,r.height,r.width,0,n.y,n.height,n.width);}}class Bo{constructor(t,e,r){this.binders={},this._buffers=[];const n=[];for(const i in t.paint._values){if(!r(i))continue;const s=t.paint.get(i);if(!(s instanceof Us&&qn(s.property.specification)))continue;const a=Co(i,t.type),o=s.value,l=s.property.specification.type,u=s.property.useIntegerZoom,c=s.property.specification["property-type"],h="cross-faded"===c||"cross-faded-data-driven"===c;if("constant"===o.kind)this.binders[i]=h?new Io(o.value,a):new To(o.value,a,l),n.push(`/u_${i}`);else if("source"===o.kind||h){const r=Lo(i,l,"source");this.binders[i]=h?"line-dasharray"===i?new Po(o,l,u,e,r,t.id):new zo(o,l,u,e,r,t.id):new Mo(o,a,l,r),n.push(`/a_${i}`);}else {const t=Lo(i,l,"composite");this.binders[i]=new Fo(o,a,l,u,e,t),n.push(`/z_${i}`);}}this.cacheKey=n.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof Mo||e instanceof Fo?e.maxValue:0}populatePaintArrays(t,e,r){for(const n in this.binders){const i=this.binders[n];(i instanceof Mo||i instanceof Fo||i instanceof Do)&&i.populatePaintArray(t,e,r);}}setConstantPatternPositions(t,e){for(const r in this.binders){const n=this.binders[r];n instanceof Io&&n.setConstantPatternPositions(t,e);}}setConstantDashPositions(t,e){for(const r in this.binders){const n=this.binders[r];n instanceof Io&&n.setConstantDashPositions(t,e);}}updatePaintArrays(t,e,r,n,i){let s=!1;for(const a in t){const o=e.getPositions(a);for(const e of o){const o=r.feature(e.index);for(const r in this.binders){const l=this.binders[r];if((l instanceof Mo||l instanceof Fo||l instanceof Do)&&!0===l.expression.isStateDependent){const u=n.paint.get(r);l.expression=u.value,l.updatePaintArray(e.start,e.end,o,t[a],i),s=!0;}}}}return s}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof To||r instanceof Io)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)));}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Mo||r instanceof Fo)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);else if(r instanceof Do){const e=r.getVertexAttributes();for(const r of e)t.push(r.name);}}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof To||r instanceof Io||r instanceof Fo)for(const e of r.uniformNames)t.push(e);}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const r=[];for(const n in this.binders){const i=this.binders[n];if(i instanceof To||i instanceof Io||i instanceof Fo)for(const s of i.uniformNames)if(e[s]){const a=i.getBinding(t,e[s],s);r.push({name:s,property:n,binding:a});}}return r}setUniforms(t,e,r,n){for(const{name:t,property:i,binding:s}of e)this.binders[i].setUniform(s,n,r.get(i),t);}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const r=this.binders[e];if(t&&r instanceof Do){const e=2===t.fromScale?r.zoomInPaintVertexBuffer:r.zoomOutPaintVertexBuffer;e&&this._buffers.push(e);}else (r instanceof Mo||r instanceof Fo)&&r.paintVertexBuffer&&this._buffers.push(r.paintVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof Mo||r instanceof Fo||r instanceof Do)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof Mo||e instanceof Fo||e instanceof Do)&&e.destroy();}}}class Vo{constructor(t,e,r=()=>!0){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new Bo(n,e,r);this.needsUpload=!1,this._featureMap=new go,this._bufferOffset=0;}populatePaintArrays(t,e,r,n){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n);void 0!==e.id&&this._featureMap.add(e.id,r,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0;}updatePaintArrays(t,e,r,n){for(const i of r)this.needsUpload=this.programConfigurations[i.id].updatePaintArrays(t,this._featureMap,e,i,n)||this.needsUpload;}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}function Co(t,e){return {"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-dasharray":["dasharray_to","dasharray_from"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}function Lo(t,e,r){const n={color:{source:ca,composite:Ia},number:{source:Sa,composite:ca}},i=function(t){return {"line-pattern":{source:Ya,composite:Ya},"fill-pattern":{source:Ya,composite:Ya},"fill-extrusion-pattern":{source:Ya,composite:Ya},"line-dasharray":{source:Za,composite:Za}}[t]}(t);return i&&i[r]||n[e][r]}ps("ConstantBinder",To),ps("CrossFadedConstantBinder",Io),ps("SourceExpressionBinder",Mo),ps("CrossFadedPatternBinder",zo),ps("CrossFadedDasharrayBinder",Po),ps("CompositeExpressionBinder",Fo),ps("ProgramConfiguration",Bo,{omit:["_buffers"]}),ps("ProgramConfigurationSet",Vo);const Oo=Math.pow(2,14)-1,Ro=-Oo-1;function No(t){const e=M/t.extent,r=t.loadGeometry();for(let t=0;t<r.length;t++){const n=r[t];for(let t=0;t<n.length;t++){const r=n[t],i=Math.round(r.x*e),s=Math.round(r.y*e);r.x=C(i,Ro,Oo),r.y=C(s,Ro,Oo),(i<r.x||i>r.x+1||s<r.y||s>r.y+1)&&j("Geometry exceeds allowed extent, reduce your vector tile buffer size");}}return r}function $o(t,e){return {type:t.type,id:t.id,properties:t.properties,geometry:e?No(t):[]}}const Uo=-32768;function qo(t,e,r,n,i){t.emplaceBack(Uo+8*e+n,Uo+8*r+i);}class jo{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasDependencies=!1,this.layoutVertexArray=new Ua,this.indexArray=new to,this.segments=new io,this.programConfigurations=new Vo(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){const n=this.layers[0],i=[];let s=null,a=!1,o="heatmap"===n.type;if("circle"===n.type){const t=n;s=t.layout.get("circle-sort-key"),a=!s.isConstant(),o=o||"map"===t.paint.get("circle-pitch-alignment");}const l=o?e.subdivisionGranularity.circle:1;for(const{feature:e,id:n,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=$o(e,t);if(!this.layers[0]._featureFilter.filter(new Ps(this.zoom),u,r))continue;const c=a?s.evaluate(u,{},r):void 0,h={id:n,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:No(e),patterns:{},sortKey:c};i.push(h);}a&&i.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of i){const{geometry:i,index:s,sourceLayerIndex:a}=n,o=t[s].feature;this.addFeature(n,i,s,r,l),e.featureIndex.insert(o,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:r});}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,no),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,n,i=1){let s;switch(i){case 1:s=[0,7];break;case 3:s=[0,2,5,7];break;case 5:s=[0,1,3,4,6,7];break;case 7:s=[0,1,2,3,4,5,6,7];break;default:throw new Error(`Invalid circle bucket granularity: ${i}; valid values are 1, 3, 5, 7.`)}const a=s.length;for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=M||n<0||n>=M)continue;const i=this.segments.prepareSegment(a*a,this.layoutVertexArray,this.indexArray,t.sortKey),o=i.vertexLength;for(let t=0;t<a;t++)for(let e=0;e<a;e++)qo(this.layoutVertexArray,r,n,s[e],s[t]);for(let t=0;t<a-1;t++)for(let e=0;e<a-1;e++){const r=o+t*a+e,n=o+(t+1)*a+e;this.indexArray.emplaceBack(r,n+1,r+1),this.indexArray.emplaceBack(r,n,n+1);}i.vertexLength+=a*a,i.primitiveLength+=(a-1)*(a-1)*2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{imagePositions:{},canonical:n});}}function Go(t,e){for(let r=0;r<t.length;r++)if(tl(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(tl(t,e[r]))return !0;return !!Ho(t,e)}function Xo(t,e,r){return !!tl(t,e)||!!Wo(e,t,r)}function Yo(t,e){if(1===t.length)return Qo(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(tl(t,n[e]))return !0}for(let r=0;r<t.length;r++)if(Qo(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(Ho(t,e[r]))return !0;return !1}function Zo(t,e,r){if(t.length>1){if(Ho(t,e))return !0;for(let n=0;n<e.length;n++)if(Wo(e[n],t,r))return !0}for(let n=0;n<t.length;n++)if(Wo(t[n],e,r))return !0;return !1}function Ho(t,e){if(0===t.length||0===e.length)return !1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(Ko(n,i,e[t],e[t+1]))return !0}return !1}function Ko(t,e,r,n){return G(t,r,n)!==G(e,r,n)&&G(t,e,r)!==G(t,e,n)}function Wo(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(Jo(t,e[r-1],e[r])<n)return !0;return !1}function Jo(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e))}function Qo(t,e){let r,n,i,s=!1;for(let a=0;a<t.length;a++){r=t[a];for(let t=0,a=r.length-1;t<r.length;a=t++)n=r[t],i=r[a],n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(s=!s);}return s}function tl(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const s=t[n],a=t[i];s.y>e.y!=a.y>e.y&&e.x<(a.x-s.x)*(e.y-s.y)/(a.y-s.y)+s.x&&(r=!r);}return r}function el(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return !1;const s=G(t,e,r[0]);return s!==G(t,e,r[1])||s!==G(t,e,r[2])||s!==G(t,e,r[3])}function rl(t,e,r){const n=e.paint.get(t).value;return "constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function nl(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function il(t,e,n,i,s){if(!e[0]&&!e[1])return t;const a=r.convert(e)._mult(s);"viewport"===n&&a._rotate(-i);const o=[];for(let e=0;e<t.length;e++)o.push(t[e].sub(a));return o}function sl(t){const e=[];for(let r=0;r<t.length;r++){const n=t[r],i=e.at(-1);(0===r||i&&!n.equals(i))&&e.push(n);}return e}function al({queryGeometry:t,size:e},r){return Xo(t,r,e)}function ol({queryGeometry:t,size:e,transform:r,unwrappedTileID:n,getElevation:i},s){return Xo(t,s,e*(r.projectTileCoordinates(s.x,s.y,n,i).signedDistanceFromCamera/r.cameraToCenterDistance))}function ll({queryGeometry:t,size:e,transform:r,unwrappedTileID:n,getElevation:i},s){const a=r.projectTileCoordinates(s.x,s.y,n,i).signedDistanceFromCamera,o=e*(r.cameraToCenterDistance/a);return Xo(t,hl(s,r,n,i),o)}function ul({queryGeometry:t,size:e,transform:r,unwrappedTileID:n,getElevation:i},s){return Xo(t,hl(s,r,n,i),e)}function cl({queryGeometry:t,size:e,transform:r,unwrappedTileID:n,getElevation:i,pitchAlignment:s="map",pitchScale:a="map"},o){const l="map"===s?"map"===a?al:ol:"map"===a?ll:ul,u={queryGeometry:t,size:e,transform:r,unwrappedTileID:n,getElevation:i};for(const t of o)for(const e of t)if(l(u,e))return !0;return !1}function hl(t,e,n,i){const s=e.projectTileCoordinates(t.x,t.y,n,i).point;return new r((.5*s.x+.5)*e.width,(.5*-s.y+.5)*e.height)}let pl,fl;ps("CircleBucket",jo,{omit:["layers"]});var dl={get paint(){return fl=fl||new Hs({"circle-radius":new Gs(vt.paint_circle["circle-radius"]),"circle-color":new Gs(vt.paint_circle["circle-color"]),"circle-blur":new Gs(vt.paint_circle["circle-blur"]),"circle-opacity":new Gs(vt.paint_circle["circle-opacity"]),"circle-translate":new js(vt.paint_circle["circle-translate"]),"circle-translate-anchor":new js(vt.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new js(vt.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new js(vt.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new Gs(vt.paint_circle["circle-stroke-width"]),"circle-stroke-color":new Gs(vt.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new Gs(vt.paint_circle["circle-stroke-opacity"])})},get layout(){return pl=pl||new Hs({"circle-sort-key":new Gs(vt.layout_circle["circle-sort-key"])})}};class yl extends Ks{constructor(t,e){super(t,dl,e);}createBucket(t){return new jo(t)}queryRadius(t){const e=t;return rl("circle-radius",this,e)+rl("circle-stroke-width",this,e)+nl(this.paint.get("circle-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:r,geometry:n,transform:i,pixelsToTileUnits:s,unwrappedTileID:a,getElevation:o}){const l=il(t,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),-i.bearingInRadians,s),u=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r),c=this.paint.get("circle-pitch-scale"),h=this.paint.get("circle-pitch-alignment");let p,f;return "map"===h?(p=l,f=u*s):(p=function(t,e,r,n){return t.map((t=>hl(t,e,r,n)))}(l,i,a,o),f=u),cl({queryGeometry:p,size:f,transform:i,unwrappedTileID:a,getElevation:o,pitchAlignment:h,pitchScale:c},n)}}class ml extends jo{}let gl;ps("HeatmapBucket",ml,{omit:["layers"]});var xl={get paint(){return gl=gl||new Hs({"heatmap-radius":new Gs(vt.paint_heatmap["heatmap-radius"]),"heatmap-weight":new Gs(vt.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new js(vt.paint_heatmap["heatmap-intensity"]),"heatmap-color":new Zs(vt.paint_heatmap["heatmap-color"]),"heatmap-opacity":new js(vt.paint_heatmap["heatmap-opacity"])})}};function vl(t,{width:e,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError(`mismatched image size. expected: ${i.length} but got: ${e*r*n}`)}else i=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=i,t}function bl(t,{width:e,height:r},n){if(e===t.width&&r===t.height)return;const i=vl({},{width:e,height:r},n);wl(t,i,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,r)},n),t.width=e,t.height=r,t.data=i.data;}function wl(t,e,r,n,i,s){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const a=t.data,o=e.data;if(a===o)throw new Error("srcData equals dstData, so image is already copied");for(let l=0;l<i.height;l++){const u=((r.y+l)*t.width+r.x)*s,c=((n.y+l)*e.width+n.x)*s;for(let t=0;t<i.width*s;t++)o[c+t]=a[u+t];}return e}class _l{constructor(t,e){vl(this,t,1,e);}resize(t){bl(this,t,1);}clone(){return new _l({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){wl(t,e,r,n,i,1);}}class Sl{constructor(t,e){vl(this,t,4,e);}resize(t){bl(this,t,4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new Sl({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){wl(t,e,r,n,i,4);}setPixel(t,e,r){const n=4*(t*this.width+e);this.data[n+0]=Math.round(255*r.r/r.a),this.data[n+1]=Math.round(255*r.g/r.a),this.data[n+2]=Math.round(255*r.b/r.a),this.data[n+3]=Math.round(255*r.a);}}function Al(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new Sl({width:r,height:n});if(Math.log(r)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${r}`);const s=(n,s,a)=>{e[t.evaluationKey]=a;const o=t.expression.evaluate(e);i.setPixel(n/4/r,s/4,o);};if(t.clips)for(let e=0,i=0;e<n;++e,i+=4*r)for(let n=0,a=0;n<r;n++,a+=4){const o=n/(r-1),{start:l,end:u}=t.clips[e];s(i,a,l*(1-o)+u*o);}else for(let t=0,e=0;t<r;t++,e+=4)s(0,e,t/(r-1));return i}ps("AlphaImage",_l),ps("RGBAImage",Sl);const kl="big-fb";class El extends Ks{createBucket(t){return new ml(t)}constructor(t,e){super(t,xl,e),this.heatmapFbos=new Map,this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=Al({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbos.has(kl)&&this.heatmapFbos.delete(kl);}queryRadius(t){return rl("heatmap-radius",this,t)}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:r,geometry:n,transform:i,pixelsToTileUnits:s,unwrappedTileID:a,getElevation:o}){return cl({queryGeometry:t,size:this.paint.get("heatmap-radius").evaluate(e,r)*s,transform:i,unwrappedTileID:a,getElevation:o},n)}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&!this.isHidden()}}let Tl;var Il={get paint(){return Tl=Tl||new Hs({"hillshade-illumination-direction":new js(vt.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-altitude":new js(vt.paint_hillshade["hillshade-illumination-altitude"]),"hillshade-illumination-anchor":new js(vt.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new js(vt.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new js(vt.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new js(vt.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new js(vt.paint_hillshade["hillshade-accent-color"]),"hillshade-method":new js(vt.paint_hillshade["hillshade-method"])})}};class Ml extends Ks{constructor(t,e){super(t,Il,e),this.recalculate({zoom:0,zoomHistory:{}},void 0);}getIlluminationProperties(){let t=this.paint.get("hillshade-illumination-direction").values,e=this.paint.get("hillshade-illumination-altitude").values,r=this.paint.get("hillshade-highlight-color").values,n=this.paint.get("hillshade-shadow-color").values;const i=Math.max(t.length,e.length,r.length,n.length);t=t.concat(Array(i-t.length).fill(t.at(-1))),e=e.concat(Array(i-e.length).fill(e.at(-1))),r=r.concat(Array(i-r.length).fill(r.at(-1))),n=n.concat(Array(i-n.length).fill(n.at(-1)));const s=e.map(tt);return {directionRadians:t.map(tt),altitudeRadians:s,shadowColor:n,highlightColor:r}}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&!this.isHidden()}}let Fl;var Dl={get paint(){return Fl=Fl||new Hs({"color-relief-opacity":new js(vt["paint_color-relief"]["color-relief-opacity"]),"color-relief-color":new Zs(vt["paint_color-relief"]["color-relief-color"])})}};class zl{constructor(t,e,r,n){this.context=t,this.format=r,this.texture=t.gl.createTexture(),this.update(e,n);}update(t,e,r){const{width:n,height:i}=t,s=!(this.size&&this.size[0]===n&&this.size[1]===i||r),{context:a}=this,{gl:o}=a;if(this.useMipmap=Boolean(e&&e.useMipmap),o.bindTexture(o.TEXTURE_2D,this.texture),a.pixelStoreUnpackFlipY.set(!1),a.pixelStoreUnpack.set(1),a.pixelStoreUnpackPremultiplyAlpha.set(this.format===o.RGBA&&(!e||!1!==e.premultiply)),s)this.size=[n,i],t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||Z(t)?o.texImage2D(o.TEXTURE_2D,0,this.format,this.format,o.UNSIGNED_BYTE,t):o.texImage2D(o.TEXTURE_2D,0,this.format,n,i,0,this.format,o.UNSIGNED_BYTE,t.data);else {const{x:e,y:s}=r||{x:0,y:0};t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||Z(t)?o.texSubImage2D(o.TEXTURE_2D,0,e,s,o.RGBA,o.UNSIGNED_BYTE,t):o.texSubImage2D(o.TEXTURE_2D,0,e,s,n,i,o.RGBA,o.UNSIGNED_BYTE,t.data);}this.useMipmap&&this.isSizePowerOfTwo()&&o.generateMipmap(o.TEXTURE_2D),a.pixelStoreUnpackFlipY.setDefault(),a.pixelStoreUnpack.setDefault(),a.pixelStoreUnpackPremultiplyAlpha.setDefault();}bind(t,e,r){const{context:n}=this,{gl:i}=n;i.bindTexture(i.TEXTURE_2D,this.texture),r!==i.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(r=i.LINEAR),t!==this.filter&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,t),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,r||t),this.filter=t),e!==this.wrap&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,e),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,e),this.wrap=e);}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}}class Pl{constructor(t,e,r,n=1,i=1,s=1,a=0){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&!["mapbox","terrarium","custom"].includes(r))return void j(`"${r}" is not a valid encoding type. Valid types include "mapbox", "terrarium" and "custom".`);this.stride=e.height;const o=this.dim=e.height-2;switch(this.data=new Uint32Array(e.data.buffer),r){case "terrarium":this.redFactor=256,this.greenFactor=1,this.blueFactor=1/256,this.baseShift=32768;break;case "custom":this.redFactor=n,this.greenFactor=i,this.blueFactor=s,this.baseShift=a;break;default:this.redFactor=6553.6,this.greenFactor=25.6,this.blueFactor=.1,this.baseShift=1e4;}for(let t=0;t<o;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(o,t)]=this.data[this._idx(o-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,o)]=this.data[this._idx(t,o-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(o,-1)]=this.data[this._idx(o-1,0)],this.data[this._idx(-1,o)]=this.data[this._idx(0,o-1)],this.data[this._idx(o,o)]=this.data[this._idx(o-1,o-1)],this.min=Number.MAX_SAFE_INTEGER,this.max=Number.MIN_SAFE_INTEGER;for(let t=0;t<o;t++)for(let e=0;e<o;e++){const r=this.get(t,e);r>this.max&&(this.max=r),r<this.min&&(this.min=r);}}get(t,e){const r=new Uint8Array(this.data.buffer),n=4*this._idx(t,e);return this.unpack(r[n],r[n+1],r[n+2])}getUnpackVector(){return [this.redFactor,this.greenFactor,this.blueFactor,this.baseShift]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError(`Out of range source coordinates for DEM data. x: ${t}, y: ${e}, dim: ${this.dim}`);return (e+1)*this.stride+(t+1)}unpack(t,e,r){return t*this.redFactor+e*this.greenFactor+r*this.blueFactor-this.baseShift}pack(t){return Bl(t,this.getUnpackVector())}getPixels(){return new Sl({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,s=r*this.dim,a=r*this.dim+this.dim;switch(e){case -1:n=i-1;break;case 1:i=n+1;}switch(r){case -1:s=a-1;break;case 1:a=s+1;}const o=-e*this.dim,l=-r*this.dim;for(let e=s;e<a;e++)for(let r=n;r<i;r++)this.data[this._idx(r,e)]=t.data[this._idx(r+o,e+l)];}}function Bl(t,e){const r=e[0],n=e[1],i=e[2],s=e[3],a=Math.min(r,n,i),o=Math.round((t+s)/a);return {r:Math.floor(o*a/r)%256,g:Math.floor(o*a/n)%256,b:Math.floor(o*a/i)%256}}ps("DEMData",Pl);class Vl extends Ks{constructor(t,e){super(t,Dl,e);}_createColorRamp(t){const e={elevationStops:[],colorStops:[]},r=this._transitionablePaint._values["color-relief-color"].value.expression;if(r instanceof ii&&r._styleExpression.expression instanceof fr){this.colorRampExpression=r;const t=r._styleExpression.expression;e.elevationStops=t.labels,e.colorStops=[];for(const r of e.elevationStops)e.colorStops.push(t.evaluate({globals:{elevation:r}}));}if(e.elevationStops.length<1&&(e.elevationStops=[0],e.colorStops=[Te.transparent]),e.elevationStops.length<2&&(e.elevationStops.push(e.elevationStops[0]+1),e.colorStops.push(e.colorStops[0])),e.elevationStops.length<=t)return e;const n={elevationStops:[],colorStops:[]},i=(e.elevationStops.length-1)/(t-1);for(let t=0;t<e.elevationStops.length-.5;t+=i)n.elevationStops.push(e.elevationStops[Math.round(t)]),n.colorStops.push(e.colorStops[Math.round(t)]);return j(`Too many colors in specification of ${this.id} color-relief layer, may not render properly. Max possible colors: ${t}, provided: ${e.elevationStops.length}`),n}_colorRampChanged(){return this.colorRampExpression!=this._transitionablePaint._values["color-relief-color"].value.expression}getColorRampTextures(t,e,r){if(this.colorRampTextures&&!this._colorRampChanged())return this.colorRampTextures;const n=this._createColorRamp(e),i=new Sl({width:n.colorStops.length,height:1}),s=new Sl({width:n.colorStops.length,height:1});for(let t=0;t<n.elevationStops.length;t++){const e=Bl(n.elevationStops[t],r);s.setPixel(0,t,new Te(e.r/255,e.g/255,e.b/255,1)),i.setPixel(0,t,n.colorStops[t]);}return this.colorRampTextures={elevationTexture:new zl(t,s,t.gl.RGBA),colorTexture:new zl(t,i,t.gl.RGBA)},this.colorRampTextures}hasOffscreenPass(){return !this.isHidden()&&!!this.colorRampTextures}}const Cl=na([{name:"a_pos",components:2,type:"Int16"}],4),{members:Ll}=Cl;function Ol(t,e,r){const n=r.patternDependencies;let i=!1;for(const r of e){const e=r.paint.get(`${t}-pattern`);e.isConstant()||(i=!0);const s=e.constantOr(null);s&&(i=!0,n[s.to]=!0,n[s.from]=!0);}return i}function Rl(t,e,r,n,i){const{zoom:s}=n,a=i.patternDependencies;for(const n of e){const e=n.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:s-1},r,{},i.availableImages),o=e.evaluate({zoom:s},r,{},i.availableImages),l=e.evaluate({zoom:s+1},r,{},i.availableImages);t=t&&t.name?t.name:t,o=o&&o.name?o.name:o,l=l&&l.name?l.name:l,a[t]=!0,a[o]=!0,a[l]=!0,r.patterns[n.id]={min:t,mid:o,max:l};}}return r}function Nl(t,e,r,n,i){let s;if(i===function(t,e,r,n){let i=0;for(let s=e,a=r-n;s<r;s+=n)i+=(t[a]-t[s])*(t[s+1]+t[a+1]),a=s;return i}(t,e,r,n)>0)for(let i=e;i<r;i+=n)s=lu(i/n|0,t[i],t[i+1],s);else for(let i=r-n;i>=e;i-=n)s=lu(i/n|0,t[i],t[i+1],s);return s&&ru(s,s.next)&&(uu(s),s=s.next),s}function $l(t,e){if(!t)return t;e||(e=t);let r,n=t;do{if(r=!1,n.steiner||!ru(n,n.next)&&0!==eu(n.prev,n,n.next))n=n.next;else {if(uu(n),n=e=n.prev,n===n.next)break;r=!0;}}while(r||n!==e);return e}function Ul(t,e,r,n,i,s,a){if(!t)return;!a&&s&&function(t,e,r,n){let i=t;do{0===i.z&&(i.z=Kl(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){let e,r=1;do{let n,i=t;t=null;let s=null;for(e=0;i;){e++;let a=i,o=0;for(let t=0;t<r&&(o++,a=a.nextZ,a);t++);let l=r;for(;o>0||l>0&&a;)0!==o&&(0===l||!a||i.z<=a.z)?(n=i,i=i.nextZ,o--):(n=a,a=a.nextZ,l--),s?s.nextZ=n:t=n,n.prevZ=s,s=n;i=a;}s.nextZ=null,r*=2;}while(e>1)}(i);}(t,n,i,s);let o=t;for(;t.prev!==t.next;){const l=t.prev,u=t.next;if(s?jl(t,n,i,s):ql(t))e.push(l.i,t.i,u.i),uu(t),t=u.next,o=u.next;else if((t=u)===o){a?1===a?Ul(t=Gl($l(t),e),e,r,n,i,s,2):2===a&&Xl(t,e,r,n,i,s):Ul($l(t),e,r,n,i,s,1);break}}}function ql(t){const e=t.prev,r=t,n=t.next;if(eu(e,r,n)>=0)return !1;const i=e.x,s=r.x,a=n.x,o=e.y,l=r.y,u=n.y,c=Math.min(i,s,a),h=Math.min(o,l,u),p=Math.max(i,s,a),f=Math.max(o,l,u);let d=n.next;for(;d!==e;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&Ql(i,o,s,l,a,u,d.x,d.y)&&eu(d.prev,d,d.next)>=0)return !1;d=d.next;}return !0}function jl(t,e,r,n){const i=t.prev,s=t,a=t.next;if(eu(i,s,a)>=0)return !1;const o=i.x,l=s.x,u=a.x,c=i.y,h=s.y,p=a.y,f=Math.min(o,l,u),d=Math.min(c,h,p),y=Math.max(o,l,u),m=Math.max(c,h,p),g=Kl(f,d,e,r,n),x=Kl(y,m,e,r,n);let v=t.prevZ,b=t.nextZ;for(;v&&v.z>=g&&b&&b.z<=x;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==a&&Ql(o,c,l,h,u,p,v.x,v.y)&&eu(v.prev,v,v.next)>=0)return !1;if(v=v.prevZ,b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==a&&Ql(o,c,l,h,u,p,b.x,b.y)&&eu(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}for(;v&&v.z>=g;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==a&&Ql(o,c,l,h,u,p,v.x,v.y)&&eu(v.prev,v,v.next)>=0)return !1;v=v.prevZ;}for(;b&&b.z<=x;){if(b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==a&&Ql(o,c,l,h,u,p,b.x,b.y)&&eu(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}return !0}function Gl(t,e){let r=t;do{const n=r.prev,i=r.next.next;!ru(n,i)&&nu(n,r,r.next,i)&&au(n,i)&&au(i,n)&&(e.push(n.i,r.i,i.i),uu(r),uu(r.next),r=t=i),r=r.next;}while(r!==t);return $l(r)}function Xl(t,e,r,n,i,s){let a=t;do{let t=a.next.next;for(;t!==a.prev;){if(a.i!==t.i&&tu(a,t)){let o=ou(a,t);return a=$l(a,a.next),o=$l(o,o.next),Ul(a,e,r,n,i,s,0),void Ul(o,e,r,n,i,s,0)}t=t.next;}a=a.next;}while(a!==t)}function Yl(t,e){let r=t.x-e.x;return 0===r&&(r=t.y-e.y,0===r)&&(r=(t.next.y-t.y)/(t.next.x-t.x)-(e.next.y-e.y)/(e.next.x-e.x)),r}function Zl(t,e){const r=function(t,e){let r=e;const n=t.x,i=t.y;let s,a=-1/0;if(ru(t,r))return r;do{if(ru(t,r.next))return r.next;if(i<=r.y&&i>=r.next.y&&r.next.y!==r.y){const t=r.x+(i-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(t<=n&&t>a&&(a=t,s=r.x<r.next.x?r:r.next,t===n))return s}r=r.next;}while(r!==e);if(!s)return null;const o=s,l=s.x,u=s.y;let c=1/0;r=s;do{if(n>=r.x&&r.x>=l&&n!==r.x&&Jl(i<u?n:a,i,l,u,i<u?a:n,i,r.x,r.y)){const e=Math.abs(i-r.y)/(n-r.x);au(r,t)&&(e<c||e===c&&(r.x>s.x||r.x===s.x&&Hl(s,r)))&&(s=r,c=e);}r=r.next;}while(r!==o);return s}(t,e);if(!r)return e;const n=ou(r,t);return $l(n,n.next),$l(r,r.next)}function Hl(t,e){return eu(t.prev,t,e.prev)<0&&eu(e.next,t,t.next)<0}function Kl(t,e,r,n,i){return (t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function Wl(t){let e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next;}while(e!==t);return r}function Jl(t,e,r,n,i,s,a,o){return (i-a)*(e-o)>=(t-a)*(s-o)&&(t-a)*(n-o)>=(r-a)*(e-o)&&(r-a)*(s-o)>=(i-a)*(n-o)}function Ql(t,e,r,n,i,s,a,o){return !(t===a&&e===o)&&Jl(t,e,r,n,i,s,a,o)}function tu(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&nu(r,r.next,t,e))return !0;r=r.next;}while(r!==t);return !1}(t,e)&&(au(t,e)&&au(e,t)&&function(t,e){let r=t,n=!1;const i=(t.x+e.x)/2,s=(t.y+e.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&i<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;}while(r!==t);return n}(t,e)&&(eu(t.prev,t,e.prev)||eu(t,e.prev,e))||ru(t,e)&&eu(t.prev,t,t.next)>0&&eu(e.prev,e,e.next)>0)}function eu(t,e,r){return (e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function ru(t,e){return t.x===e.x&&t.y===e.y}function nu(t,e,r,n){const i=su(eu(t,e,r)),s=su(eu(t,e,n)),a=su(eu(r,n,t)),o=su(eu(r,n,e));return i!==s&&a!==o||!(0!==i||!iu(t,r,e))||!(0!==s||!iu(t,n,e))||!(0!==a||!iu(r,t,n))||!(0!==o||!iu(r,e,n))}function iu(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function su(t){return t>0?1:t<0?-1:0}function au(t,e){return eu(t.prev,t,t.next)<0?eu(t,e,t.next)>=0&&eu(t,t.prev,e)>=0:eu(t,e,t.prev)<0||eu(t,t.next,e)<0}function ou(t,e){const r=cu(t.i,t.x,t.y),n=cu(e.i,e.x,e.y),i=t.next,s=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,n.next=r,r.prev=n,s.next=n,n.prev=s,n}function lu(t,e,r,n){const i=cu(t,e,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function uu(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function cu(t,e,r){return {i:t,x:e,y:r,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}class hu{constructor(t,e){if(e>t)throw new Error("Min granularity must not be greater than base granularity.");this._baseZoomGranularity=t,this._minGranularity=e;}getGranularityForZoomLevel(t){return Math.max(Math.floor(this._baseZoomGranularity/(1<<t)),this._minGranularity,1)}}class pu{constructor(t){this.fill=t.fill,this.line=t.line,this.tile=t.tile,this.stencil=t.stencil,this.circle=t.circle;}}pu.noSubdivision=new pu({fill:new hu(0,0),line:new hu(0,0),tile:new hu(0,0),stencil:new hu(0,0),circle:1}),ps("SubdivisionGranularityExpression",hu),ps("SubdivisionGranularitySetting",pu);const fu=-32768,du=32767;class yu{constructor(t,e){this._vertexBuffer=[],this._vertexDictionary=new Map,this._used=!1,this._granularity=t,this._granularityCellSize=M/t,this._canonical=e;}_getKey(t,e){return (t+=32768)<<16|e+32768}_vertexToIndex(t,e){if(t<-32768||e<-32768||t>32767||e>32767)throw new Error("Vertex coordinates are out of signed 16 bit integer range.");const r=0|Math.round(t),n=0|Math.round(e),i=this._getKey(r,n);if(this._vertexDictionary.has(i))return this._vertexDictionary.get(i);const s=this._vertexBuffer.length/2;return this._vertexDictionary.set(i,s),this._vertexBuffer.push(r,n),s}_subdivideTrianglesScanline(t){if(this._granularity<2)return function(t,e){const r=[];for(let n=0;n<e.length;n+=3){const i=e[n],s=e[n+1],a=e[n+2],o=t[2*i],l=t[2*i+1];(t[2*s]-o)*(t[2*a+1]-l)-(t[2*s+1]-l)*(t[2*a]-o)>0?(r.push(i),r.push(a),r.push(s)):(r.push(i),r.push(s),r.push(a));}return r}(this._vertexBuffer,t);const e=[],r=t.length;for(let n=0;n<r;n+=3){const r=[t[n+0],t[n+1],t[n+2]],i=[this._vertexBuffer[2*t[n+0]+0],this._vertexBuffer[2*t[n+0]+1],this._vertexBuffer[2*t[n+1]+0],this._vertexBuffer[2*t[n+1]+1],this._vertexBuffer[2*t[n+2]+0],this._vertexBuffer[2*t[n+2]+1]];let s=1/0,a=1/0,o=-1/0,l=-1/0;for(let t=0;t<3;t++){const e=i[2*t],r=i[2*t+1];s=Math.min(s,e),o=Math.max(o,e),a=Math.min(a,r),l=Math.max(l,r);}if(s===o||a===l)continue;const u=Math.floor(s/this._granularityCellSize),c=Math.ceil(o/this._granularityCellSize),h=Math.floor(a/this._granularityCellSize),p=Math.ceil(l/this._granularityCellSize);if(u!==c||h!==p)for(let t=h;t<p;t++){const n=this._scanlineGenerateVertexRingForCellRow(t,i,r);xu(this._vertexBuffer,n,e);}else e.push(...r);}return e}_scanlineGenerateVertexRingForCellRow(t,e,r){const n=t*this._granularityCellSize,i=n+this._granularityCellSize,s=[];for(let t=0;t<3;t++){const a=e[2*t],o=e[2*t+1],l=e[2*(t+1)%6],u=e[(2*(t+1)+1)%6],c=e[2*(t+2)%6],h=e[(2*(t+2)+1)%6],p=l-a,f=u-o,d=0===p,y=0===f,m=(n-o)/f,g=(i-o)/f,x=Math.min(m,g),v=Math.max(m,g);if(!y&&(x>=1||v<=0)||y&&(o<n||o>i)){u>=n&&u<=i&&s.push(r[(t+1)%3]);continue}!y&&x>0&&s.push(this._vertexToIndex(a+p*x,o+f*x));const b=a+p*Math.max(x,0),w=a+p*Math.min(v,1);d||this._generateIntraEdgeVertices(s,a,o,l,u,b,w),!y&&v<1&&s.push(this._vertexToIndex(a+p*v,o+f*v)),(y||u>=n&&u<=i)&&s.push(r[(t+1)%3]),!y&&(u<=n||u>=i)&&this._generateInterEdgeVertices(s,a,o,l,u,c,h,w,n,i);}return s}_generateIntraEdgeVertices(t,e,r,n,i,s,a){const o=n-e,l=i-r,u=0===l,c=u?Math.min(e,n):Math.min(s,a),h=u?Math.max(e,n):Math.max(s,a),p=Math.floor(c/this._granularityCellSize)+1,f=Math.ceil(h/this._granularityCellSize)-1;if(u?e<n:s<a)for(let n=p;n<=f;n++){const i=n*this._granularityCellSize;t.push(this._vertexToIndex(i,r+l*(i-e)/o));}else for(let n=f;n>=p;n--){const i=n*this._granularityCellSize;t.push(this._vertexToIndex(i,r+l*(i-e)/o));}}_generateInterEdgeVertices(t,e,r,n,i,s,a,o,l,u){const c=i-r,h=s-n,p=a-i,f=(l-i)/p,d=(u-i)/p,y=Math.min(f,d),m=Math.max(f,d),g=n+h*y;let x=Math.floor(Math.min(g,o)/this._granularityCellSize)+1,v=Math.ceil(Math.max(g,o)/this._granularityCellSize)-1,b=o<g;const w=0===p;if(w&&(a===l||a===u))return;if(w||y>=1||m<=0){const t=r-a,n=s+(e-s)*Math.min((l-a)/t,(u-a)/t);x=Math.floor(Math.min(n,o)/this._granularityCellSize)+1,v=Math.ceil(Math.max(n,o)/this._granularityCellSize)-1,b=o<n;}const _=c>0?u:l;if(b)for(let e=x;e<=v;e++)t.push(this._vertexToIndex(e*this._granularityCellSize,_));else for(let e=v;e>=x;e--)t.push(this._vertexToIndex(e*this._granularityCellSize,_));}_generateOutline(t){const e=[];for(const r of t){const t=gu(r,this._granularity,!0),n=this._pointArrayToIndices(t),i=[];for(let t=1;t<n.length;t++)i.push(n[t-1]),i.push(n[t]);e.push(i);}return e}_handlePoles(t){let e=!1,r=!1;this._canonical&&(0===this._canonical.y&&(e=!0),this._canonical.y===(1<<this._canonical.z)-1&&(r=!0)),(e||r)&&this._fillPoles(t,e,r);}_ensureNoPoleVertices(){const t=this._vertexBuffer;for(let e=0;e<t.length;e+=2){const r=t[e+1];r===fu&&(t[e+1]=-32767),r===du&&(t[e+1]=32766);}}_generatePoleQuad(t,e,r,n,i,s){n>i!=(s===fu)?(t.push(e),t.push(r),t.push(this._vertexToIndex(n,s)),t.push(r),t.push(this._vertexToIndex(i,s)),t.push(this._vertexToIndex(n,s))):(t.push(r),t.push(e),t.push(this._vertexToIndex(n,s)),t.push(this._vertexToIndex(i,s)),t.push(r),t.push(this._vertexToIndex(n,s)));}_fillPoles(t,e,r){const n=this._vertexBuffer,i=M,s=t.length;for(let a=2;a<s;a+=3){const s=t[a-2],o=t[a-1],l=t[a],u=n[2*s],c=n[2*s+1],h=n[2*o],p=n[2*o+1],f=n[2*l],d=n[2*l+1];e&&(0===c&&0===p&&this._generatePoleQuad(t,s,o,u,h,fu),0===p&&0===d&&this._generatePoleQuad(t,o,l,h,f,fu),0===d&&0===c&&this._generatePoleQuad(t,l,s,f,u,fu)),r&&(c===i&&p===i&&this._generatePoleQuad(t,s,o,u,h,du),p===i&&d===i&&this._generatePoleQuad(t,o,l,h,f,du),d===i&&c===i&&this._generatePoleQuad(t,l,s,f,u,du));}}_initializeVertices(t){for(let e=0;e<t.length;e+=2)this._vertexToIndex(t[e],t[e+1]);}subdividePolygonInternal(t,e){if(this._used)throw new Error("Subdivision: multiple use not allowed.");this._used=!0;const{flattened:r,holeIndices:n}=function(t){const e=[],r=[];for(const n of t)if(0!==n.length){n!==t[0]&&e.push(r.length/2);for(let t=0;t<n.length;t++)r.push(n[t].x),r.push(n[t].y);}return {flattened:r,holeIndices:e}}(t);let i;this._initializeVertices(r);try{const t=function(t,e,r=2){const n=e&&e.length,i=n?e[0]*r:t.length;let s=Nl(t,0,i,r,!0);const a=[];if(!s||s.next===s.prev)return a;let o,l,u;if(n&&(s=function(t,e,r,n){const i=[];for(let r=0,s=e.length;r<s;r++){const a=Nl(t,e[r]*n,r<s-1?e[r+1]*n:t.length,n,!1);a===a.next&&(a.steiner=!0),i.push(Wl(a));}i.sort(Yl);for(let t=0;t<i.length;t++)r=Zl(i[t],r);return r}(t,e,s,r)),t.length>80*r){o=t[0],l=t[1];let e=o,n=l;for(let s=r;s<i;s+=r){const r=t[s],i=t[s+1];r<o&&(o=r),i<l&&(l=i),r>e&&(e=r),i>n&&(n=i);}u=Math.max(e-o,n-l),u=0!==u?32767/u:0;}return Ul(s,a,r,o,l,u,0),a}(r,n),e=this._convertIndices(r,t);i=this._subdivideTrianglesScanline(e);}catch(t){console.error(t);}let s=[];return e&&(s=this._generateOutline(t)),this._ensureNoPoleVertices(),this._handlePoles(i),{verticesFlattened:this._vertexBuffer,indicesTriangles:i,indicesLineList:s}}_convertIndices(t,e){const r=[];for(let n=0;n<e.length;n++)r.push(this._vertexToIndex(t[2*e[n]],t[2*e[n]+1]));return r}_pointArrayToIndices(t){const e=[];for(let r=0;r<t.length;r++){const n=t[r];e.push(this._vertexToIndex(n.x,n.y));}return e}}function mu(t,e,r,n=!0){return new yu(r,e).subdividePolygonInternal(t,n)}function gu(t,e,n=!1){if(!t||t.length<1)return [];if(t.length<2)return [];const i=t[0],s=t[t.length-1],a=n&&(i.x!==s.x||i.y!==s.y);if(e<2)return a?[...t,t[0]]:[...t];const o=Math.floor(M/e),l=[];l.push(new r(t[0].x,t[0].y));const u=t.length,c=a?u:u-1;for(let e=0;e<c;e++){const n=t[e],i=e<u-1?t[e+1]:t[0],s=n.x,a=n.y,c=i.x,h=i.y,p=s!==c,f=a!==h;if(!p&&!f)continue;const d=c-s,y=h-a,m=Math.abs(d),g=Math.abs(y);let x=s,v=a;for(;;){const t=d>0?(Math.floor(x/o)+1)*o:(Math.ceil(x/o)-1)*o,e=y>0?(Math.floor(v/o)+1)*o:(Math.ceil(v/o)-1)*o,n=Math.abs(x-t),i=Math.abs(v-e),s=Math.abs(x-c),a=Math.abs(v-h),u=p?n/m:Number.POSITIVE_INFINITY,b=f?i/g:Number.POSITIVE_INFINITY;if((s<=n||!p)&&(a<=i||!f))break;if(u<b&&p||!f){x=t,v+=y*u;const e=new r(x,Math.round(v));l[l.length-1].x===e.x&&l[l.length-1].y===e.y||l.push(e);}else {x+=d*b,v=e;const t=new r(Math.round(x),v);l[l.length-1].x===t.x&&l[l.length-1].y===t.y||l.push(t);}}const b=new r(c,h);l[l.length-1].x===b.x&&l[l.length-1].y===b.y||l.push(b);}return l}function xu(t,e,r){if(0===e.length)throw new Error("Subdivision vertex ring is empty.");let n=0,i=t[2*e[0]];for(let r=1;r<e.length;r++){const s=t[2*e[r]];s<i&&(i=s,n=r);}const s=e.length;let a=n,o=(a+1)%s;for(;;){const n=a-1>=0?a-1:s-1,i=(o+1)%s,l=t[2*e[n]],u=t[2*e[i]],c=t[2*e[a]],h=t[2*e[a]+1],p=t[2*e[o]+1];let f=!1;if(l<u)f=!0;else if(l>u)f=!1;else {const r=p-h,s=-(t[2*e[o]]-c),a=h<p?1:-1;((l-c)*r+(t[2*e[n]+1]-h)*s)*a>((u-c)*r+(t[2*e[i]+1]-h)*s)*a&&(f=!0);}if(f){const t=e[n],i=e[a],l=e[o];t!==i&&t!==l&&i!==l&&r.push(l,i,t),a--,a<0&&(a=s-1);}else {const t=e[i],n=e[a],l=e[o];t!==n&&t!==l&&n!==l&&r.push(l,n,t),o++,o>=s&&(o=0);}if(n===i)break}}function vu(t,e,r,n,i,s,a,o,l){const u=i.length/2,c=a&&o&&l;if(u<io.MAX_VERTEX_ARRAY_LENGTH){const h=e.prepareSegment(u,r,n),p=h.vertexLength;for(let t=0;t<s.length;t+=3)n.emplaceBack(p+s[t],p+s[t+1],p+s[t+2]);let f,d;h.vertexLength+=u,h.primitiveLength+=s.length/3,c&&(d=a.prepareSegment(u,r,o),f=d.vertexLength,d.vertexLength+=u);for(let e=0;e<i.length;e+=2)t(i[e],i[e+1]);if(c)for(let t=0;t<l.length;t++){const e=l[t];for(let t=1;t<e.length;t+=2)o.emplaceBack(f+e[t-1],f+e[t]);d.primitiveLength+=e.length/2;}}else !function(t,e,r,n,i,s){const a=[];for(let t=0;t<n.length/2;t++)a.push(-1);const o={count:0};let l=0,u=t.getOrCreateLatestSegment(e,r),c=u.vertexLength;for(let h=2;h<i.length;h+=3){const p=i[h-2],f=i[h-1],d=i[h];let y=a[p]<l,m=a[f]<l,g=a[d]<l;u.vertexLength+((y?1:0)+(m?1:0)+(g?1:0))>io.MAX_VERTEX_ARRAY_LENGTH&&(u=t.createNewSegment(e,r),l=o.count,y=!0,m=!0,g=!0,c=0);const x=bu(a,n,s,o,p,y,u),v=bu(a,n,s,o,f,m,u),b=bu(a,n,s,o,d,g,u);r.emplaceBack(c+x-l,c+v-l,c+b-l),u.primitiveLength++;}}(e,r,n,i,s,t),c&&function(t,e,r,n,i,s){const a=[];for(let t=0;t<n.length/2;t++)a.push(-1);const o={count:0};let l=0,u=t.getOrCreateLatestSegment(e,r),c=u.vertexLength;for(let h=0;h<i.length;h++){const p=i[h];for(let f=1;f<i[h].length;f+=2){const i=p[f-1],h=p[f];let d=a[i]<l,y=a[h]<l;u.vertexLength+((d?1:0)+(y?1:0))>io.MAX_VERTEX_ARRAY_LENGTH&&(u=t.createNewSegment(e,r),l=o.count,d=!0,y=!0,c=0);const m=bu(a,n,s,o,i,d,u),g=bu(a,n,s,o,h,y,u);r.emplaceBack(c+m-l,c+g-l),u.primitiveLength++;}}}(a,r,o,i,l,t),e.forceNewSegmentOnNextPrepare(),null==a||a.forceNewSegmentOnNextPrepare();}function bu(t,e,r,n,i,s,a){if(s){const s=n.count;return r(e[2*i],e[2*i+1]),t[i]=n.count,n.count++,a.vertexLength++,s}return t[i]}class wu{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasDependencies=!1,this.patternFeatures=[],this.layoutVertexArray=new qa,this.indexArray=new to,this.indexArray2=new eo,this.programConfigurations=new Vo(t.layers,t.zoom),this.segments=new io,this.segments2=new io,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.hasDependencies=Ol("fill",this.layers,e);const n=this.layers[0].layout.get("fill-sort-key"),i=!n.isConstant(),s=[];for(const{feature:a,id:o,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=$o(a,t);if(!this.layers[0]._featureFilter.filter(new Ps(this.zoom),c,r))continue;const h=i?n.evaluate(c,{},r,e.availableImages):void 0,p={id:o,properties:a.properties,type:a.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:No(a),patterns:{},sortKey:h};s.push(p);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(this.hasDependencies){const t=Rl("fill",this.layers,n,{zoom:this.zoom},e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{},e.subdivisionGranularity);e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:r});}addFeatures(t,e,r){for(const n of this.patternFeatures)this.addFeature(n,n.geometry,n.index,e,r,t.subdivisionGranularity);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Ll),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy());}addFeature(t,e,r,n,i,s){for(const t of tn(e,500)){const e=mu(t,n,s.fill.getGranularityForZoomLevel(n.z)),r=this.layoutVertexArray;vu(((t,e)=>{r.emplaceBack(t,e);}),this.segments,this.layoutVertexArray,this.indexArray,e.verticesFlattened,e.indicesTriangles,this.segments2,this.indexArray2,e.indicesLineList);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{imagePositions:i,canonical:n});}}let _u,Su;ps("FillBucket",wu,{omit:["layers","patternFeatures"]});var Au={get paint(){return Su=Su||new Hs({"fill-antialias":new js(vt.paint_fill["fill-antialias"]),"fill-opacity":new Gs(vt.paint_fill["fill-opacity"]),"fill-color":new Gs(vt.paint_fill["fill-color"]),"fill-outline-color":new Gs(vt.paint_fill["fill-outline-color"]),"fill-translate":new js(vt.paint_fill["fill-translate"]),"fill-translate-anchor":new js(vt.paint_fill["fill-translate-anchor"]),"fill-pattern":new Xs(vt.paint_fill["fill-pattern"])})},get layout(){return _u=_u||new Hs({"fill-sort-key":new Gs(vt.layout_fill["fill-sort-key"])})}};class ku extends Ks{constructor(t,e){super(t,Au,e);}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new wu(t)}queryRadius(){return nl(this.paint.get("fill-translate"))}queryIntersectsFeature({queryGeometry:t,geometry:e,transform:r,pixelsToTileUnits:n}){return Yo(il(t,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),-r.bearingInRadians,n),e)}isTileClipped(){return !0}}const Eu=na([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),Tu=na([{name:"a_centroid",components:2,type:"Int16"}],4),{members:Iu}=Eu;class Mu{constructor(t,e,r,n,i){this.properties={},this.extent=r,this.type=0,this.id=void 0,this._pbf=t,this._geometry=-1,this._keys=n,this._values=i,t.readFields(Fu,this,e);}loadGeometry(){const t=this._pbf;t.pos=this._geometry;const e=t.readVarint()+t.pos,n=[];let i,s=1,a=0,o=0,l=0;for(;t.pos<e;){if(a<=0){const e=t.readVarint();s=7&e,a=e>>3;}if(a--,1===s||2===s)o+=t.readSVarint(),l+=t.readSVarint(),1===s&&(i&&n.push(i),i=[]),i&&i.push(new r(o,l));else {if(7!==s)throw new Error(`unknown command ${s}`);i&&i.push(i[0].clone());}}return i&&n.push(i),n}bbox(){const t=this._pbf;t.pos=this._geometry;const e=t.readVarint()+t.pos;let r=1,n=0,i=0,s=0,a=1/0,o=-1/0,l=1/0,u=-1/0;for(;t.pos<e;){if(n<=0){const e=t.readVarint();r=7&e,n=e>>3;}if(n--,1===r||2===r)i+=t.readSVarint(),s+=t.readSVarint(),i<a&&(a=i),i>o&&(o=i),s<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error(`unknown command ${r}`)}return [a,l,o,u]}toGeoJSON(t,e,r){const n=this.extent*Math.pow(2,r),i=this.extent*t,s=this.extent*e,a=this.loadGeometry();function o(t){return [360*(t.x+i)/n-180,360/Math.PI*Math.atan(Math.exp((1-2*(t.y+s)/n)*Math.PI))-90]}function l(t){return t.map(o)}let u;if(1===this.type){const t=[];for(const e of a)t.push(e[0]);const e=l(t);u=1===t.length?{type:"Point",coordinates:e[0]}:{type:"MultiPoint",coordinates:e};}else if(2===this.type){const t=a.map(l);u=1===t.length?{type:"LineString",coordinates:t[0]}:{type:"MultiLineString",coordinates:t};}else {if(3!==this.type)throw new Error("unknown feature type");{const t=Du(a),e=[];for(const r of t)e.push(r.map(l));u=1===e.length?{type:"Polygon",coordinates:e[0]}:{type:"MultiPolygon",coordinates:e};}}const c={type:"Feature",geometry:u,properties:this.properties};return null!=this.id&&(c.id=this.id),c}}function Fu(t,e,r){1===t?e.id=r.readVarint():2===t?function(t,e){const r=t.readVarint()+t.pos;for(;t.pos<r;){const r=e._keys[t.readVarint()],n=e._values[t.readVarint()];e.properties[r]=n;}}(r,e):3===t?e.type=r.readVarint():4===t&&(e._geometry=r.pos);}function Du(t){const e=t.length;if(e<=1)return [t];const r=[];let n,i;for(let s=0;s<e;s++){const e=zu(t[s]);0!==e&&(void 0===i&&(i=e<0),i===e<0?(n&&r.push(n),n=[t[s]]):n&&n.push(t[s]));}return n&&r.push(n),r}function zu(t){let e=0;for(let r,n,i=0,s=t.length,a=s-1;i<s;a=i++)r=t[i],n=t[a],e+=(n.x-r.x)*(r.y+n.y);return e}Mu.types=["Unknown","Point","LineString","Polygon"];class Pu{constructor(t,e){this.version=1,this.name="",this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(Bu,this,e),this.length=this._features.length;}feature(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];const e=this._pbf.readVarint()+this._pbf.pos;return new Mu(this._pbf,e,this.extent,this._keys,this._values)}}function Bu(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){let e=null;const r=t.readVarint()+t.pos;for(;t.pos<r;){const r=t.readVarint()>>3;e=1===r?t.readString():2===r?t.readFloat():3===r?t.readDouble():4===r?t.readVarint64():5===r?t.readVarint():6===r?t.readSVarint():7===r?t.readBoolean():null;}if(null==e)throw new Error("unknown feature value");return e}(r));}class Vu{constructor(t,e){this.layers=t.readFields(Cu,{},e);}}function Cu(t,e,r){if(3===t){const t=new Pu(r,r.readVarint()+r.pos);t.length&&(e[t.name]=t);}}const Lu=Math.pow(2,13);function Ou(t,e,r,n,i,s,a,o){t.emplaceBack(e,r,2*Math.floor(n*Lu)+a,i*Lu*2,s*Lu*2,Math.round(o));}class Ru{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasDependencies=!1,this.layoutVertexArray=new ja,this.centroidVertexArray=new $a,this.indexArray=new to,this.programConfigurations=new Vo(t.layers,t.zoom),this.segments=new io,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.features=[],this.hasDependencies=Ol("fill-extrusion",this.layers,e);for(const{feature:n,id:i,index:s,sourceLayerIndex:a}of t){const t=this.layers[0]._featureFilter.needGeometry,o=$o(n,t);if(!this.layers[0]._featureFilter.filter(new Ps(this.zoom),o,r))continue;const l={id:i,sourceLayerIndex:a,index:s,geometry:t?o.geometry:No(n),properties:n.properties,type:n.type,patterns:{}};this.hasDependencies?this.features.push(Rl("fill-extrusion",this.layers,l,{zoom:this.zoom},e)):this.addFeature(l,l.geometry,s,r,{},e.subdivisionGranularity),e.featureIndex.insert(n,l.geometry,s,a,this.index,!0);}}addFeatures(t,e,r){for(const n of this.features){const{geometry:i}=n;this.addFeature(n,i,n.index,e,r,t.subdivisionGranularity);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:r});}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Iu),this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,Tu.members,!0),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.centroidVertexBuffer.destroy());}addFeature(t,e,r,n,i,s){for(const r of tn(e,500)){const e={x:0,y:0,sampleCount:0},i=this.layoutVertexArray.length;this.processPolygon(e,n,t,r,s);const a=this.layoutVertexArray.length-i,o=Math.floor(e.x/e.sampleCount),l=Math.floor(e.y/e.sampleCount);for(let t=0;t<a;t++)this.centroidVertexArray.emplaceBack(o,l);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{imagePositions:i,canonical:n});}processPolygon(t,e,r,n,i){if(n.length<1)return;if(Uu(n[0]))return;for(const e of n)0!==e.length&&Nu(t,e);const s={segment:this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray)},a=i.fill.getGranularityForZoomLevel(e.z),o="Polygon"===Mu.types[r.type];for(const t of n){if(0===t.length)continue;if(Uu(t))continue;const e=gu(t,a,o);this._generateSideFaces(e,s);}if(!o)return;const l=mu(n,e,a,!1),u=this.layoutVertexArray;vu(((t,e)=>{Ou(u,t,e,0,0,1,1,0);}),this.segments,this.layoutVertexArray,this.indexArray,l.verticesFlattened,l.indicesTriangles);}_generateSideFaces(t,e){let r=0;for(let n=1;n<t.length;n++){const i=t[n],s=t[n-1];if($u(i,s))continue;e.segment.vertexLength+4>io.MAX_VERTEX_ARRAY_LENGTH&&(e.segment=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const a=i.sub(s)._perp()._unit(),o=s.dist(i);r+o>32768&&(r=0),Ou(this.layoutVertexArray,i.x,i.y,a.x,a.y,0,0,r),Ou(this.layoutVertexArray,i.x,i.y,a.x,a.y,0,1,r),r+=o,Ou(this.layoutVertexArray,s.x,s.y,a.x,a.y,0,0,r),Ou(this.layoutVertexArray,s.x,s.y,a.x,a.y,0,1,r);const l=e.segment.vertexLength;this.indexArray.emplaceBack(l,l+2,l+1),this.indexArray.emplaceBack(l+1,l+2,l+3),e.segment.vertexLength+=4,e.segment.primitiveLength+=2;}}}function Nu(t,e){for(let r=0;r<e.length;r++){const n=e[r];r===e.length-1&&e[0].x===n.x&&e[0].y===n.y||(t.x+=n.x,t.y+=n.y,t.sampleCount++);}}function $u(t,e){return t.x===e.x&&(t.x<0||t.x>M)||t.y===e.y&&(t.y<0||t.y>M)}function Uu(t){return t.every((t=>t.x<0))||t.every((t=>t.x>M))||t.every((t=>t.y<0))||t.every((t=>t.y>M))}let qu;ps("FillExtrusionBucket",Ru,{omit:["layers","features"]});var ju={get paint(){return qu=qu||new Hs({"fill-extrusion-opacity":new js(vt["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new Gs(vt["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new js(vt["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new js(vt["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new Xs(vt["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new Gs(vt["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new Gs(vt["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new js(vt["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})}};class Gu extends Ks{constructor(t,e){super(t,ju,e);}createBucket(t){return new Ru(t)}queryRadius(){return nl(this.paint.get("fill-extrusion-translate"))}is3D(){return !0}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:n,geometry:i,transform:s,pixelsToTileUnits:a,pixelPosMatrix:o}){const l=il(t,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),-s.bearingInRadians,a),u=this.paint.get("fill-extrusion-height").evaluate(e,n),c=this.paint.get("fill-extrusion-base").evaluate(e,n),h=function(t,e){const n=[];for(const i of t){const t=[i.x,i.y,0,1];A(t,t,e),n.push(new r(t[0]/t[3],t[1]/t[3]));}return n}(l,o),p=function(t,e,n,i){const s=[],a=[],o=i[8]*e,l=i[9]*e,u=i[10]*e,c=i[11]*e,h=i[8]*n,p=i[9]*n,f=i[10]*n,d=i[11]*n;for(const e of t){const t=[],n=[];for(const s of e){const e=s.x,a=s.y,y=i[0]*e+i[4]*a+i[12],m=i[1]*e+i[5]*a+i[13],g=i[2]*e+i[6]*a+i[14],x=i[3]*e+i[7]*a+i[15],v=g+u,b=x+c,w=y+h,_=m+p,S=g+f,A=x+d,k=new r((y+o)/b,(m+l)/b);k.z=v/b,t.push(k);const E=new r(w/A,_/A);E.z=S/A,n.push(E);}s.push(t),a.push(n);}return [s,a]}(i,c,u,o);return function(t,e,r){let n=1/0;Yo(r,e)&&(n=Yu(r,e[0]));for(let i=0;i<e.length;i++){const s=e[i],a=t[i];for(let t=0;t<s.length-1;t++){const e=s[t],i=[e,s[t+1],a[t+1],a[t],e];Go(r,i)&&(n=Math.min(n,Yu(r,i)));}}return n!==1/0&&n}(p[0],p[1],h)}}function Xu(t,e){return t.x*e.x+t.y*e.y}function Yu(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++],!i)return 1/0;for(;r<e.length;r++){const s=e[r],a=t[0],o=i.sub(n),l=s.sub(n),u=a.sub(n),c=Xu(o,o),h=Xu(o,l),p=Xu(l,l),f=Xu(u,o),d=Xu(u,l),y=c*p-h*h,m=(p*f-h*d)/y,g=(c*d-h*f)/y,x=n.z*(1-m-g)+i.z*m+s.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}const Zu=na([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:Hu}=Zu,Ku=na([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:Wu}=Ku,Ju=Math.cos(Math.PI/180*37.5),Qu=Math.pow(2,14)/.5;class tc{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasDependencies=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={};})),this.layoutVertexArray=new Ga,this.layoutVertexArray2=new Xa,this.indexArray=new to,this.programConfigurations=new Vo(t.layers,t.zoom),this.segments=new io,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.hasDependencies=Ol("line",this.layers,e)||this.hasLineDasharray(this.layers);const n=this.layers[0].layout.get("line-sort-key"),i=!n.isConstant(),s=[];for(const{feature:e,id:a,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=$o(e,t);if(!this.layers[0]._featureFilter.filter(new Ps(this.zoom),u,r))continue;const c=i?n.evaluate(u,{},r):void 0,h={id:a,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:No(e),patterns:{},dashes:{},sortKey:c};s.push(h);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n;this.hasDependencies?(Ol("line",this.layers,e)?Rl("line",this.layers,n,{zoom:this.zoom},e):this.hasLineDasharray(this.layers)&&this.addLineDashDependencies(this.layers,n,this.zoom,e),this.patternFeatures.push(n)):this.addFeature(n,i,s,r,{},{},e.subdivisionGranularity),e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r,n){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:r,dashPositions:n});}addFeatures(t,e,r,n){for(const i of this.patternFeatures)this.addFeature(i,i.geometry,i.index,e,r,n,t.subdivisionGranularity);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,Wu)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Hu),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(t){if(t.properties&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_end"))return {start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,n,i,s,a){const o=this.layers[0].layout,l=o.get("line-join").evaluate(t,{}),u=o.get("line-cap"),c=o.get("line-miter-limit"),h=o.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const r of e)this.addLine(r,t,l,u,c,h,n,a);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{imagePositions:i,dashPositions:s,canonical:n});}addLine(t,e,r,n,i,s,a,o){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,t=gu(t,a?o.line.getGranularityForZoomLevel(a.z):1),this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}const l="Polygon"===Mu.types[e.type];let u=t.length;for(;u>=2&&t[u-1].equals(t[u-2]);)u--;let c=0;for(;c<u-1&&t[c].equals(t[c+1]);)c++;if(u<(l?3:2))return;"bevel"===r&&(i=1.05);const h=this.overscaling<=16?122880/(512*this.overscaling):0,p=this.segments.prepareSegment(10*u,this.layoutVertexArray,this.indexArray);let f,d,y,m,g;this.e1=this.e2=-1,l&&(f=t[u-2],g=t[c].sub(f)._unit()._perp());for(let e=c;e<u;e++){if(y=e===u-1?l?t[c+1]:void 0:t[e+1],y&&t[e].equals(y))continue;g&&(m=g),f&&(d=f),f=t[e],g=y?y.sub(f)._unit()._perp():m,m=m||g;let a=m.add(g);0===a.x&&0===a.y||a._unit();const o=m.x*g.x+m.y*g.y,x=a.x*g.x+a.y*g.y,v=0!==x?1/x:1/0,b=2*Math.sqrt(2-2*x),w=x<Ju&&d&&y,_=m.x*g.y-m.y*g.x>0;if(w&&e>c){const t=f.dist(d);if(t>2*h){const e=f.sub(f.sub(d)._mult(h/t)._round());this.updateDistance(d,e),this.addCurrentVertex(e,m,0,0,p),d=e;}}const S=d&&y;let A=S?r:l?"butt":n;if(S&&"round"===A&&(v<s?A="miter":v<=2&&(A="fakeround")),"miter"===A&&v>i&&(A="bevel"),"bevel"===A&&(v>2&&(A="flipbevel"),v<i&&(A="miter")),d&&this.updateDistance(d,f),"miter"===A)a._mult(v),this.addCurrentVertex(f,a,0,0,p);else if("flipbevel"===A){if(v>100)a=g.mult(-1);else {const t=v*m.add(g).mag()/m.sub(g).mag();a._perp()._mult(t*(_?-1:1));}this.addCurrentVertex(f,a,0,0,p),this.addCurrentVertex(f,a.mult(-1),0,0,p);}else if("bevel"===A||"fakeround"===A){const t=-Math.sqrt(v*v-1),e=_?t:0,r=_?0:t;if(d&&this.addCurrentVertex(f,m,e,r,p),"fakeround"===A){const t=Math.round(180*b/Math.PI/20);for(let e=1;e<t;e++){let r=e/t;if(.5!==r){const t=r-.5;r+=r*t*(r-1)*((1.0904+o*(o*(3.55645-1.43519*o)-3.2452))*t*t+(.848013+o*(.215638*o-1.06021)));}const n=g.sub(m)._mult(r)._add(m)._unit()._mult(_?-1:1);this.addHalfVertex(f,n.x,n.y,!1,_,0,p);}}y&&this.addCurrentVertex(f,g,-e,-r,p);}else if("butt"===A)this.addCurrentVertex(f,a,0,0,p);else if("square"===A){const t=d?1:-1;this.addCurrentVertex(f,a,t,t,p);}else "round"===A&&(d&&(this.addCurrentVertex(f,m,0,0,p),this.addCurrentVertex(f,m,1,1,p,!0)),y&&(this.addCurrentVertex(f,g,-1,-1,p,!0),this.addCurrentVertex(f,g,0,0,p)));if(w&&e<u-1){const t=f.dist(y);if(t>2*h){const e=f.add(y.sub(f)._mult(h/t)._round());this.updateDistance(f,e),this.addCurrentVertex(e,g,0,0,p),f=e;}}}}addCurrentVertex(t,e,r,n,i,s=!1){const a=e.y*n-e.x,o=-e.y-e.x*n;this.addHalfVertex(t,e.x+e.y*r,e.y-e.x*r,s,!1,r,i),this.addHalfVertex(t,a,o,s,!0,-n,i),this.distance>Qu/2&&0===this.totalDistance&&(this.distance=0,this.updateScaledDistance(),this.addCurrentVertex(t,e,r,n,i,s));}addHalfVertex({x:t,y:e},r,n,i,s,a,o){const l=.5*(this.lineClips?this.scaledDistance*(Qu-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===a?0:a<0?-1:1)|(63&l)<<2,l>>6),this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const u=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,u,this.e2),o.primitiveLength++),s?this.e2=u:this.e1=u;}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance;}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance();}hasLineDasharray(t){for(const e of t){const t=e.paint.get("line-dasharray");if(t&&!t.isConstant())return !0}return !1}addLineDashDependencies(t,e,r,n){for(const i of t){const t=i.paint.get("line-dasharray");if(!t||"constant"===t.value.kind)continue;const s="round"===i.layout.get("line-cap"),a={dasharray:t.value.evaluate({zoom:r-1},e,{}),round:s},o={dasharray:t.value.evaluate({zoom:r},e,{}),round:s},l={dasharray:t.value.evaluate({zoom:r+1},e,{}),round:s},u=`${a.dasharray.join(",")},${a.round}`,c=`${o.dasharray.join(",")},${o.round}`,h=`${l.dasharray.join(",")},${l.round}`;n.dashDependencies[u]=a,n.dashDependencies[c]=o,n.dashDependencies[h]=l,e.dashes[i.id]={min:u,mid:c,max:h};}}}let ec,rc;ps("LineBucket",tc,{omit:["layers","patternFeatures"]});var nc={get paint(){return rc=rc||new Hs({"line-opacity":new Gs(vt.paint_line["line-opacity"]),"line-color":new Gs(vt.paint_line["line-color"]),"line-translate":new js(vt.paint_line["line-translate"]),"line-translate-anchor":new js(vt.paint_line["line-translate-anchor"]),"line-width":new Gs(vt.paint_line["line-width"]),"line-gap-width":new Gs(vt.paint_line["line-gap-width"]),"line-offset":new Gs(vt.paint_line["line-offset"]),"line-blur":new Gs(vt.paint_line["line-blur"]),"line-dasharray":new Xs(vt.paint_line["line-dasharray"]),"line-pattern":new Xs(vt.paint_line["line-pattern"]),"line-gradient":new Zs(vt.paint_line["line-gradient"])})},get layout(){return ec=ec||new Hs({"line-cap":new js(vt.layout_line["line-cap"]),"line-join":new Gs(vt.layout_line["line-join"]),"line-miter-limit":new js(vt.layout_line["line-miter-limit"]),"line-round-limit":new js(vt.layout_line["line-round-limit"]),"line-sort-key":new Gs(vt.layout_line["line-sort-key"])})}};class ic extends Gs{possiblyEvaluate(t,e){return e=new Ps(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=O({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n)}}let sc;class ac extends Ks{constructor(t,e){super(t,nc,e),this.gradientVersion=0,sc||(sc=new ic(nc.paint.properties["line-width"].specification),sc.useIntegerZoom=!0);}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this.gradientExpression();this.stepInterpolant=!!function(t){return void 0!==t._styleExpression}(t)&&t._styleExpression.expression instanceof or,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER;}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=sc.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new tc(t)}queryRadius(t){const e=t,r=oc(rl("line-width",this,e),rl("line-gap-width",this,e)),n=rl("line-offset",this,e);return r/2+Math.abs(n)+nl(this.paint.get("line-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:n,geometry:i,transform:s,pixelsToTileUnits:a}){const o=il(t,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),-s.bearingInRadians,a),l=a/2*oc(this.paint.get("line-width").evaluate(e,n),this.paint.get("line-gap-width").evaluate(e,n)),u=this.paint.get("line-offset").evaluate(e,n);return u&&(i=function(t,e){const n=[];for(let i=0;i<t.length;i++){const s=sl(t[i]),a=[];for(let t=0;t<s.length;t++){const n=s[t],i=s[t-1],o=s[t+1],l=0===t?new r(0,0):n.sub(i)._unit()._perp(),u=t===s.length-1?new r(0,0):o.sub(n)._unit()._perp(),c=l._add(u)._unit(),h=c.x*u.x+c.y*u.y;0!==h&&c._mult(1/h),a.push(c._mult(e)._add(n));}n.push(a);}return n}(i,u*a)),function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(tl(t,i[e]))return !0;if(Zo(t,i,r))return !0}return !1}(o,i,l)}isTileClipped(){return !0}}function oc(t,e){return e>0?e+2*t:t}const lc=na([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),uc=na([{name:"a_projected_pos",components:3,type:"Float32"}],4);na([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const cc=na([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_box_real",components:2,type:"Int16"}]);na([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const hc=na([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),pc=na([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);function fc(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return "uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),zs.applyArabicShaping&&(t=zs.applyArabicShaping(t)),t}(t.text,e,r);})),t}na([{name:"triangle",components:3,type:"Uint16"}]),na([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),na([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Uint16",name:"textAnchorOffsetStartIndex"},{type:"Uint16",name:"textAnchorOffsetEndIndex"}]),na([{type:"Float32",name:"offsetX"}]),na([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]),na([{type:"Uint16",name:"textAnchor"},{type:"Float32",components:2,name:"textOffset"}]);var dc=24;const yc={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","⋯":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"},mc={10:!0,32:!0,38:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0},gc={40:!0};function xc(t,e,r,n,i,s){if("fontStack"in e){const n=r[e.fontStack],s=n&&n[t];return s?s.metrics.advance*e.scale+i:0}{const t=n[e.imageName];return t?t.displaySize[0]*e.scale*dc/s+i:0}}function vc(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r}function bc(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n}function wc(t,e,r,n,i,s){let a=null,o=vc(e,r,i,s);for(const t of n){const n=vc(e-t.x,r,i,s)+t.badness;n<=o&&(a=t,o=n);}return {index:t,x:e,priorBreak:a,badness:o}}function _c(t){return t?_c(t.priorBreak).concat(t.index):[]}class Sc{constructor(t="",e=[],r=[]){this.text=t,this.sections=e,this.sectionIndex=r,this.imageSectionID=null;}static fromFeature(t,e){const r=new Sc;for(let n=0;n<t.sections.length;n++){const i=t.sections[n];i.image?r.addImageSection(i):r.addTextSection(i,e);}return r}length(){return [...this.text].length}getSection(t){return this.sections[this.sectionIndex[t]]}getSectionIndex(t){return this.sectionIndex[t]}verticalizePunctuation(){this.text=function(t){let e="",r={premature:!0,value:void 0};const n=t[Symbol.iterator]();let i=n.next();const s=t[Symbol.iterator]();s.next();let a=s.next();for(;!i.done;)e+=!a.done&&Ts(a.value.codePointAt(0))&&!yc[a.value]||!r.premature&&Ts(r.value.codePointAt(0))&&!yc[r.value]||!yc[i.value]?i.value:yc[i.value],r={value:i.value,premature:!1},i=n.next(),a=s.next();return e}(this.text);}hasZeroWidthSpaces(){return this.text.includes("​")}trim(){const t=this.text.match(/^\s*/),e=t?t[0].length:0,r=this.text.match(/\S\s*$/),n=r?r[0].length-1:0;this.text=this.text.substring(e,this.text.length-n),this.sectionIndex=this.sectionIndex.slice(e,this.sectionIndex.length-n);}substring(t,e){const r=[...this.text].slice(t,e).join(""),n=this.sectionIndex.slice(t,e);return new Sc(r,this.sections,n)}toCodeUnitIndex(t){return [...this.text].slice(0,t).join("").length}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}getMaxImageSize(t){let e=0,r=0;for(let n=0;n<this.length();n++){const i=this.getSection(n);if("imageName"in i){const n=t[i.imageName];if(!n)continue;const s=n.displaySize;e=Math.max(e,s[0]),r=Math.max(r,s[1]);}}return {maxImageWidth:e,maxImageHeight:r}}addTextSection(t,e){this.text+=t.text,this.sections.push({scale:t.scale||1,verticalAlign:t.verticalAlign||"bottom",fontStack:t.fontStack||e});const r=this.sections.length-1;this.sectionIndex.push(...[...t.text].map((()=>r)));}addImageSection(t){const e=t.image?t.image.name:"";if(0===e.length)return void j("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCharCode(r),this.sections.push({scale:1,verticalAlign:t.verticalAlign||"bottom",imageName:e}),this.sectionIndex.push(this.sections.length-1)):j("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}determineLineBreaks(t,e,r,n,i){const s=[],a=this.determineAverageLineWidth(t,e,r,n,i),o=this.hasZeroWidthSpaces();let l=0,u=0;const c=this.text[Symbol.iterator]();let h=c.next();const p=this.text[Symbol.iterator]();p.next();let f=p.next();const d=this.text[Symbol.iterator]();d.next(),d.next();let y=d.next();for(;!h.done;){const e=this.getSection(u),m=h.value.codePointAt(0);if(ws(m)||(l+=xc(m,e,r,n,t,i)),!f.done){const t=vs(m),r=f.value.codePointAt(0);(mc[m]||t||"imageName"in e||!y.done&&gc[r])&&s.push(wc(u+1,l,a,s,bc(m,r,t&&o),!1));}u++,h=c.next(),f=p.next(),y=d.next();}return _c(wc(this.length(),l,a,s,0,!0))}determineAverageLineWidth(t,e,r,n,i){let s=0,a=0;for(const e of this.text){const o=this.getSection(a);s+=xc(e.codePointAt(0),o,r,n,t,i),a++;}return s/Math.max(1,Math.ceil(s/e))}}const Ac=4294967296,kc=1/Ac,Ec="undefined"==typeof TextDecoder?null:new TextDecoder("utf-8");class Tc{constructor(t=new Uint8Array(16)){this.buf=ArrayBuffer.isView(t)?t:new Uint8Array(t),this.dataView=new DataView(this.buf.buffer),this.pos=0,this.type=0,this.length=this.buf.length;}readFields(t,e,r=this.length){for(;this.pos<r;){const r=this.readVarint(),n=r>>3,i=this.pos;this.type=7&r,t(n,e,this),this.pos===i&&this.skip(r);}return e}readMessage(t,e){return this.readFields(t,e,this.readVarint()+this.pos)}readFixed32(){const t=this.dataView.getUint32(this.pos,!0);return this.pos+=4,t}readSFixed32(){const t=this.dataView.getInt32(this.pos,!0);return this.pos+=4,t}readFixed64(){const t=this.dataView.getUint32(this.pos,!0)+this.dataView.getUint32(this.pos+4,!0)*Ac;return this.pos+=8,t}readSFixed64(){const t=this.dataView.getUint32(this.pos,!0)+this.dataView.getInt32(this.pos+4,!0)*Ac;return this.pos+=8,t}readFloat(){const t=this.dataView.getFloat32(this.pos,!0);return this.pos+=4,t}readDouble(){const t=this.dataView.getFloat64(this.pos,!0);return this.pos+=8,t}readVarint(t){const e=this.buf;let r,n;return n=e[this.pos++],r=127&n,n<128?r:(n=e[this.pos++],r|=(127&n)<<7,n<128?r:(n=e[this.pos++],r|=(127&n)<<14,n<128?r:(n=e[this.pos++],r|=(127&n)<<21,n<128?r:(n=e[this.pos],r|=(15&n)<<28,function(t,e,r){const n=r.buf;let i,s;if(s=n[r.pos++],i=(112&s)>>4,s<128)return Ic(t,i,e);if(s=n[r.pos++],i|=(127&s)<<3,s<128)return Ic(t,i,e);if(s=n[r.pos++],i|=(127&s)<<10,s<128)return Ic(t,i,e);if(s=n[r.pos++],i|=(127&s)<<17,s<128)return Ic(t,i,e);if(s=n[r.pos++],i|=(127&s)<<24,s<128)return Ic(t,i,e);if(s=n[r.pos++],i|=(1&s)<<31,s<128)return Ic(t,i,e);throw new Error("Expected varint not more than 10 bytes")}(r,t,this)))))}readVarint64(){return this.readVarint(!0)}readSVarint(){const t=this.readVarint();return t%2==1?(t+1)/-2:t/2}readBoolean(){return Boolean(this.readVarint())}readString(){const t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&Ec?Ec.decode(this.buf.subarray(e,t)):function(t,e,r){let n="",i=e;for(;i<r;){const e=t[i];let s,a,o,l=null,u=e>239?4:e>223?3:e>191?2:1;if(i+u>r)break;1===u?e<128&&(l=e):2===u?(s=t[i+1],128==(192&s)&&(l=(31&e)<<6|63&s,l<=127&&(l=null))):3===u?(s=t[i+1],a=t[i+2],128==(192&s)&&128==(192&a)&&(l=(15&e)<<12|(63&s)<<6|63&a,(l<=2047||l>=55296&&l<=57343)&&(l=null))):4===u&&(s=t[i+1],a=t[i+2],o=t[i+3],128==(192&s)&&128==(192&a)&&128==(192&o)&&(l=(15&e)<<18|(63&s)<<12|(63&a)<<6|63&o,(l<=65535||l>=1114112)&&(l=null))),null===l?(l=65533,u=1):l>65535&&(l-=65536,n+=String.fromCharCode(l>>>10&1023|55296),l=56320|1023&l),n+=String.fromCharCode(l),i+=u;}return n}(this.buf,e,t)}readBytes(){const t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e}readPackedVarint(t=[],e){const r=this.readPackedEnd();for(;this.pos<r;)t.push(this.readVarint(e));return t}readPackedSVarint(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSVarint());return t}readPackedBoolean(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readBoolean());return t}readPackedFloat(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFloat());return t}readPackedDouble(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readDouble());return t}readPackedFixed32(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFixed32());return t}readPackedSFixed32(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSFixed32());return t}readPackedFixed64(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFixed64());return t}readPackedSFixed64(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSFixed64());return t}readPackedEnd(){return 2===this.type?this.readVarint()+this.pos:this.pos+1}skip(t){const e=7&t;if(0===e)for(;this.buf[this.pos++]>127;);else if(2===e)this.pos=this.readVarint()+this.pos;else if(5===e)this.pos+=4;else {if(1!==e)throw new Error(`Unimplemented type: ${e}`);this.pos+=8;}}writeTag(t,e){this.writeVarint(t<<3|e);}realloc(t){let e=this.length||16;for(;e<this.pos+t;)e*=2;if(e!==this.length){const t=new Uint8Array(e);t.set(this.buf),this.buf=t,this.dataView=new DataView(t.buffer),this.length=e;}}finish(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)}writeFixed32(t){this.realloc(4),this.dataView.setInt32(this.pos,t,!0),this.pos+=4;}writeSFixed32(t){this.realloc(4),this.dataView.setInt32(this.pos,t,!0),this.pos+=4;}writeFixed64(t){this.realloc(8),this.dataView.setInt32(this.pos,-1&t,!0),this.dataView.setInt32(this.pos+4,Math.floor(t*kc),!0),this.pos+=8;}writeSFixed64(t){this.realloc(8),this.dataView.setInt32(this.pos,-1&t,!0),this.dataView.setInt32(this.pos+4,Math.floor(t*kc),!0),this.pos+=8;}writeVarint(t){(t=+t||0)>268435455||t<0?function(t,e){let r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(r=~(-t%4294967296),n=~(-t/4294967296),4294967295^r?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7);}(r,0,e),function(t,e){const r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))));}(n,e);}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))));}writeSVarint(t){this.writeVarint(t<0?2*-t-1:2*t);}writeBoolean(t){this.writeVarint(+t);}writeString(t){t=String(t),this.realloc(4*t.length),this.pos++;const e=this.pos;this.pos=function(t,e,r){for(let n,i,s=0;s<e.length;s++){if(n=e.charCodeAt(s),n>55295&&n<57344){if(!i){n>56319||s+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):i=n;continue}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null;}else i&&(t[r++]=239,t[r++]=191,t[r++]=189,i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128);}return r}(this.buf,t,this.pos);const r=this.pos-e;r>=128&&Mc(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r;}writeFloat(t){this.realloc(4),this.dataView.setFloat32(this.pos,t,!0),this.pos+=4;}writeDouble(t){this.realloc(8),this.dataView.setFloat64(this.pos,t,!0),this.pos+=8;}writeBytes(t){const e=t.length;this.writeVarint(e),this.realloc(e);for(let r=0;r<e;r++)this.buf[this.pos++]=t[r];}writeRawMessage(t,e){this.pos++;const r=this.pos;t(e,this);const n=this.pos-r;n>=128&&Mc(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n;}writeMessage(t,e,r){this.writeTag(t,2),this.writeRawMessage(e,r);}writePackedVarint(t,e){e.length&&this.writeMessage(t,Fc,e);}writePackedSVarint(t,e){e.length&&this.writeMessage(t,Dc,e);}writePackedBoolean(t,e){e.length&&this.writeMessage(t,Bc,e);}writePackedFloat(t,e){e.length&&this.writeMessage(t,zc,e);}writePackedDouble(t,e){e.length&&this.writeMessage(t,Pc,e);}writePackedFixed32(t,e){e.length&&this.writeMessage(t,Vc,e);}writePackedSFixed32(t,e){e.length&&this.writeMessage(t,Cc,e);}writePackedFixed64(t,e){e.length&&this.writeMessage(t,Lc,e);}writePackedSFixed64(t,e){e.length&&this.writeMessage(t,Oc,e);}writeBytesField(t,e){this.writeTag(t,2),this.writeBytes(e);}writeFixed32Field(t,e){this.writeTag(t,5),this.writeFixed32(e);}writeSFixed32Field(t,e){this.writeTag(t,5),this.writeSFixed32(e);}writeFixed64Field(t,e){this.writeTag(t,1),this.writeFixed64(e);}writeSFixed64Field(t,e){this.writeTag(t,1),this.writeSFixed64(e);}writeVarintField(t,e){this.writeTag(t,0),this.writeVarint(e);}writeSVarintField(t,e){this.writeTag(t,0),this.writeSVarint(e);}writeStringField(t,e){this.writeTag(t,2),this.writeString(e);}writeFloatField(t,e){this.writeTag(t,5),this.writeFloat(e);}writeDoubleField(t,e){this.writeTag(t,1),this.writeDouble(e);}writeBooleanField(t,e){this.writeVarintField(t,+e);}}function Ic(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function Mc(t,e,r){const n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(let e=r.pos-1;e>=t;e--)r.buf[e+n]=r.buf[e];}function Fc(t,e){for(let r=0;r<t.length;r++)e.writeVarint(t[r]);}function Dc(t,e){for(let r=0;r<t.length;r++)e.writeSVarint(t[r]);}function zc(t,e){for(let r=0;r<t.length;r++)e.writeFloat(t[r]);}function Pc(t,e){for(let r=0;r<t.length;r++)e.writeDouble(t[r]);}function Bc(t,e){for(let r=0;r<t.length;r++)e.writeBoolean(t[r]);}function Vc(t,e){for(let r=0;r<t.length;r++)e.writeFixed32(t[r]);}function Cc(t,e){for(let r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function Lc(t,e){for(let r=0;r<t.length;r++)e.writeFixed64(t[r]);}function Oc(t,e){for(let r=0;r<t.length;r++)e.writeSFixed64(t[r]);}function Rc(t,e,r){1===t&&r.readMessage(Nc,e);}function Nc(t,e,r){if(3===t){const{id:t,bitmap:n,width:i,height:s,left:a,top:o,advance:l}=r.readMessage($c,{});e.push({id:t,bitmap:new _l({width:i+6,height:s+6},n),metrics:{width:i,height:s,left:a,top:o,advance:l}});}}function $c(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}function Uc(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,s=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,s=Math.max(s,e.y+e.h),i=Math.max(i,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();e&&t<n.length&&(n[t]=e);}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return {w:i,h:s,fill:e/(i*s)||0}}class qc{constructor(t,{pixelRatio:e,version:r,stretchX:n,stretchY:i,content:s,textFitWidth:a,textFitHeight:o}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=n,this.stretchY=i,this.content=s,this.version=r,this.textFitWidth=a,this.textFitHeight=o;}get tl(){return [this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return [this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return [(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}class jc{constructor(t,e){const r={},n={};this.haveRenderCallbacks=[];const i=[];this.addImages(t,r,i),this.addImages(e,n,i);const{w:s,h:a}=Uc(i),o=new Sl({width:s||1,height:a||1});for(const e in t){const n=t[e],i=r[e].paddedRect;Sl.copy(n.data,o,{x:0,y:0},{x:i.x+1,y:i.y+1},n.data);}for(const t in e){const r=e[t],i=n[t].paddedRect,s=i.x+1,a=i.y+1,l=r.data.width,u=r.data.height;Sl.copy(r.data,o,{x:0,y:0},{x:s,y:a},r.data),Sl.copy(r.data,o,{x:0,y:u-1},{x:s,y:a-1},{width:l,height:1}),Sl.copy(r.data,o,{x:0,y:0},{x:s,y:a+u},{width:l,height:1}),Sl.copy(r.data,o,{x:l-1,y:0},{x:s-1,y:a},{width:1,height:u}),Sl.copy(r.data,o,{x:0,y:0},{x:s+l,y:a},{width:1,height:u});}this.image=o,this.iconPositions=r,this.patternPositions=n;}addImages(t,e,r){for(const n in t){const i=t[n],s={x:0,y:0,w:i.data.width+2,h:i.data.height+2};r.push(s),e[n]=new qc(s,i),i.hasRenderCallback&&this.haveRenderCallbacks.push(n);}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const r in t.updatedImages)this.patchUpdatedImage(this.iconPositions[r],t.getImage(r),e),this.patchUpdatedImage(this.patternPositions[r],t.getImage(r),e);}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,i]=t.tl;r.update(e.data,void 0,{x:n,y:i});}}var Gc;function Xc(e,r,n,i,s,a,o,l,u,c,h,p,f,d,y){const m=Sc.fromFeature(e,s);let g;p===t.az.vertical&&m.verticalizePunctuation();let x=m.determineLineBreaks(c,a,r,i,d);const{processBidirectionalText:v,processStyledBidirectionalText:b}=zs;if(v&&1===m.sections.length){g=[],x=x.map((t=>m.toCodeUnitIndex(t)));const t=v(m.toString(),x);for(const e of t){const t=[...e].map((()=>0));g.push(new Sc(e,m.sections,t));}}else if(b){g=[],x=x.map((t=>m.toCodeUnitIndex(t)));let t=0;const e=[];for(const r of m.text)e.push(...Array(r.length).fill(m.sectionIndex[t])),t++;const r=b(m.text,e,x);for(const t of r){const e=[];let r="";for(const n of t[0])e.push(t[1][r.length]),r+=n;g.push(new Sc(t[0],m.sections,e));}}else g=function(t,e){const r=[];let n=0;for(const i of e)r.push(t.substring(n,i)),n=i;return n<t.length()&&r.push(t.substring(n,t.length())),r}(m,x);const w=[],_={positionedLines:w,text:m.toString(),top:h[1],bottom:h[1],left:h[0],right:h[0],writingMode:p,iconsInText:!1,verticalizable:!1};return function(t,e,r,n,i,s,a,o,l,u,c,h){let p=0,f=0,d=0,y=0;const m="right"===o?1:"left"===o?0:.5,g=dc/h;let x=0;for(const a of i){a.trim();const i=a.getMaxScale(),o={positionedGlyphs:[],lineOffset:0};t.positionedLines[x]=o;const h=o.positionedGlyphs;let v=0;if(!a.length()){f+=s,++x;continue}const b=Zc(n,a,g);let w=0;for(const s of a.text){const o=a.getSection(w),d=s.codePointAt(0),y=Kc(l,c,d),m={glyph:d,imageName:null,x:p,y:f+-17,vertical:y,scale:1,fontStack:"",sectionIndex:a.getSectionIndex(w),metrics:null,rect:null};let x;if("fontStack"in o){if(x=Wc(o,d,y,b,e,r),!x)continue;m.fontStack=o.fontStack;}else {if(t.iconsInText=!0,o.scale*=g,x=Jc(o,y,i,b,n),!x)continue;v=Math.max(v,x.imageOffset),m.imageName=o.imageName;}const{rect:_,metrics:S,baselineOffset:A}=x;m.y+=A,m.scale=o.scale,m.metrics=S,m.rect=_,h.push(m),y?(t.verticalizable=!0,p+=("imageName"in o?S.advance:dc)*o.scale+u):p+=S.advance*o.scale+u,w++;}0!==h.length&&(d=Math.max(p-u,d),Qc(h,0,h.length-1,m)),p=0,o.lineOffset=Math.max(v,(i-1)*dc);const _=s*i+v;f+=_,y=Math.max(_,y),++x;}const{horizontalAlign:v,verticalAlign:b}=Yc(a);((function(t,e,r,n,i,s,a,o,l){const u=(e-r)*i;let c=0;c=s!==a?-o*n- -17:-n*l*a+.5*a;for(const e of t)for(const t of e.positionedGlyphs)t.x+=u,t.y+=c;}))(t.positionedLines,m,v,b,d,y,s,f,i.length),t.top+=-b*f,t.bottom=t.top+f,t.left+=-v*d,t.right=t.left+d;}(_,r,n,i,g,o,l,u,p,c,f,y),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return !1;return !0}(w)&&_}function Yc(t){let e=.5,r=.5;switch(t){case "right":case "top-right":case "bottom-right":e=1;break;case "left":case "top-left":case "bottom-left":e=0;}switch(t){case "bottom":case "bottom-right":case "bottom-left":r=1;break;case "top":case "top-right":case "top-left":r=0;}return {horizontalAlign:e,verticalAlign:r}}function Zc(t,e,r){const n=e.getMaxScale()*dc,{maxImageWidth:i,maxImageHeight:s}=e.getMaxImageSize(t),a=Math.max(n,s*r);return {verticalLineContentWidth:Math.max(n,i*r),horizontalLineContentHeight:a}}function Hc(t){switch(t){case "top":return 0;case "center":return .5;default:return 1}}function Kc(e,r,n){return !(e===t.az.horizontal||!r&&!bs(n)||r&&(ws(n)||(i=n,/\p{sc=Arab}/u.test(String.fromCodePoint(i)))));var i;}function Wc(t,e,r,n,i,s){const a=s[t.fontStack],o=function(t,e,r,n){if(t&&t.rect)return t;const i=e[r.fontStack],s=i&&i[n];return s?{rect:null,metrics:s.metrics}:null}(a&&a[e],i,t,e);if(null===o)return null;let l;if(r)l=n.verticalLineContentWidth-t.scale*dc;else {const e=Hc(t.verticalAlign);l=(n.horizontalLineContentHeight-t.scale*dc)*e;}return {rect:o.rect,metrics:o.metrics,baselineOffset:l}}function Jc(t,e,r,n,i){const s=i[t.imageName];if(!s)return null;const a=s.paddedRect,o=s.displaySize,l={width:o[0],height:o[1],left:1,top:-3,advance:e?o[1]:o[0]};let u;if(e)u=n.verticalLineContentWidth-o[1]*t.scale;else {const e=Hc(t.verticalAlign);u=(n.horizontalLineContentHeight-o[1]*t.scale)*e;}return {rect:a,metrics:l,baselineOffset:u,imageOffset:(e?o[0]:o[1])*t.scale-dc*r}}function Qc(t,e,r,n){if(0===n)return;const i=t[r],s=(t[r].x+i.metrics.advance*i.scale)*n;for(let n=e;n<=r;n++)t[n].x-=s;}function th(t,e,r){const{horizontalAlign:n,verticalAlign:i}=Yc(r),s=e[0]-t.displaySize[0]*n,a=e[1]-t.displaySize[1]*i;return {image:t,top:a,bottom:a+t.displaySize[1],left:s,right:s+t.displaySize[0]}}function eh(t){var e,r;let n=t.left,i=t.top,s=t.right-n,a=t.bottom-i;const o=null!==(e=t.image.textFitWidth)&&void 0!==e?e:"stretchOrShrink",l=null!==(r=t.image.textFitHeight)&&void 0!==r?r:"stretchOrShrink",u=(t.image.content[2]-t.image.content[0])/(t.image.content[3]-t.image.content[1]);if("proportional"===l){if("stretchOnly"===o&&s/a<u||"proportional"===o){const t=Math.ceil(a*u);n*=t/s,s=t;}}else if("proportional"===o&&"stretchOnly"===l&&0!==u&&s/a>u){const t=Math.ceil(s/u);i*=t/a,a=t;}return {x1:n,y1:i,x2:n+s,y2:i+a}}function rh(t,e,r,n,i,s){const a=t.image;let o;if(a.content){const t=a.content,e=a.pixelRatio||1;o=[t[0]/e,t[1]/e,a.displaySize[0]-t[2]/e,a.displaySize[1]-t[3]/e];}const l=e.left*s,u=e.right*s;let c,h,p,f;"width"===r||"both"===r?(f=i[0]+l-n[3],h=i[0]+u+n[1]):(f=i[0]+(l+u-a.displaySize[0])/2,h=f+a.displaySize[0]);const d=e.top*s,y=e.bottom*s;return "height"===r||"both"===r?(c=i[1]+d-n[0],p=i[1]+y+n[2]):(c=i[1]+(d+y-a.displaySize[1])/2,p=c+a.displaySize[1]),{image:a,top:c,right:h,bottom:p,left:f,collisionPadding:o}}ps("ImagePosition",qc),ps("ImageAtlas",jc),t.az=void 0,(Gc=t.az||(t.az={}))[Gc.none=0]="none",Gc[Gc.horizontal=1]="horizontal",Gc[Gc.vertical=2]="vertical",Gc[Gc.horizontalOnly=3]="horizontalOnly";const nh=128,ih=32640;function sh(t,e){const{expression:r}=e;if("constant"===r.kind)return {kind:"constant",layoutSize:r.evaluate(new Ps(t+1))};if("source"===r.kind)return {kind:"source"};{const{zoomStops:e,interpolationType:n}=r;let i=0;for(;i<e.length&&e[i]<=t;)i++;i=Math.max(0,i-1);let s=i;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const a=e[i],o=e[s];return "composite"===r.kind?{kind:"composite",minZoom:a,maxZoom:o,interpolationType:n}:{kind:"camera",minZoom:a,maxZoom:o,minSize:r.evaluate(new Ps(a)),maxSize:r.evaluate(new Ps(o)),interpolationType:n}}}function ah(t,e,r){let n="never";const i=t.get(e);return i?n=i:t.get(r)&&(n="always"),n}const oh=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function lh(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=o?Math.min(ih,Math.round(o[0])):0,d=o?Math.min(ih,Math.round(o[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*i),s,a,(f<<1)+(l?1:0),d,16*u,16*c,256*h,256*p);}function uh(t,e,r){t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r);}function ch(t){for(const e of t.sections)if(Ds(e.text))return !0;return !1}class hh{constructor(t){this.layoutVertexArray=new Ha,this.indexArray=new to,this.programConfigurations=t,this.segments=new io,this.dynamicLayoutVertexArray=new Ka,this.opacityVertexArray=new Wa,this.hasVisibleVertices=!1,this.placedSymbolArray=new za;}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,r,n){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,lc.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,uc.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,oh,!0),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy());}}ps("SymbolBuffers",hh);class ph{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new io,this.collisionVertexArray=new Qa;}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,cc.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy());}}ps("CollisionBuffers",ph);class fh{constructor(e){this.collisionBoxArray=e.collisionBoxArray,this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=e.index,this.pixelRatio=e.pixelRatio,this.sourceLayerIndex=e.sourceLayerIndex,this.hasDependencies=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[];const r=this.layers[0]._unevaluatedLayout._values;this.textSizeData=sh(this.zoom,r["text-size"]),this.iconSizeData=sh(this.zoom,r["icon-size"]);const n=this.layers[0].layout,i=n.get("symbol-sort-key"),s=n.get("symbol-z-order");this.canOverlap="never"!==ah(n,"text-overlap","text-allow-overlap")||"never"!==ah(n,"icon-overlap","icon-allow-overlap")||n.get("text-ignore-placement")||n.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==s&&!i.isConstant(),this.sortFeaturesByY=("viewport-y"===s||"auto"===s&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===n.get("symbol-placement")&&(this.writingModes=n.get("text-writing-mode").map((e=>t.az[e]))),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=e.sourceID;}createArrays(){this.text=new hh(new Vo(this.layers,this.zoom,(t=>/^text/.test(t)))),this.icon=new hh(new Vo(this.layers,this.zoom,(t=>/^icon/.test(t)))),this.glyphOffsetArray=new Va,this.lineVertexArray=new Ca,this.symbolInstances=new Ba,this.textAnchorOffsets=new Oa;}calculateGlyphDependencies(t,e,r,n,i){for(const s of t)if(e[s.codePointAt(0)]=!0,(r||n)&&i){const t=yc[s];t&&(e[t.codePointAt(0)]=!0);}}populate(e,r,n){const i=this.layers[0],s=i.layout,a=s.get("text-font"),o=s.get("text-field"),l=s.get("icon-image"),u=("constant"!==o.value.kind||o.value.value instanceof De&&!o.value.value.isEmpty()||o.value.value.toString().length>0)&&("constant"!==a.value.kind||a.value.value.length>0),c="constant"!==l.value.kind||!!l.value.value||Object.keys(l.parameters).length>0,h=s.get("symbol-sort-key");if(this.features=[],!u&&!c)return;const p=r.iconDependencies,f=r.glyphDependencies,d=r.availableImages,y=new Ps(this.zoom);for(const{feature:r,id:o,index:l,sourceLayerIndex:m}of e){const e=i._featureFilter.needGeometry,g=$o(r,e);if(!i._featureFilter.filter(y,g,n))continue;let x,v;if(e||(g.geometry=No(r)),u){const t=i.getValueAndResolveTokens("text-field",g,n,d),e=De.factory(t),r=this.hasRTLText=this.hasRTLText||ch(e);(!r||"unavailable"===zs.getRTLTextPluginStatus()||r&&zs.isParsed())&&(x=fc(e,i,g));}if(c){const t=i.getValueAndResolveTokens("icon-image",g,n,d);v=t instanceof Oe?t:Oe.fromString(t);}if(!x&&!v)continue;const b=this.sortFeaturesByKey?h.evaluate(g,{},n):void 0;if(this.features.push({id:o,text:x,icon:v,index:l,sourceLayerIndex:m,geometry:g.geometry,properties:r.properties,type:Mu.types[r.type],sortKey:b}),v&&(p[v.name]=!0),x){const e=a.evaluate(g,{},n).join(","),r="viewport"!==s.get("text-rotation-alignment")&&"point"!==s.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(t.az.vertical)>=0;for(const t of x.sections)if(t.image)p[t.image.name]=!0;else {const n=_s(x.toString()),i=t.fontStack||e,s=f[i]=f[i]||{};this.calculateGlyphDependencies(t.text,s,r,this.allowVerticalPlacement,n);}}}"line"===s.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function s(e){n.push(t[e]),i++;}function a(t,e,i){const s=r[t];return delete r[t],r[e]=s,n[s].geometry[0].pop(),n[s].geometry[0]=n[s].geometry[0].concat(i[0]),s}function o(t,r,i){const s=e[r];return delete e[r],e[t]=s,n[s].geometry[0].shift(),n[s].geometry[0]=i[0].concat(n[s].geometry[0]),s}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return `${t}:${n.x}:${n.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const f=l(p,h),d=l(p,h,!0);if(f in r&&d in e&&r[f]!==e[d]){const t=o(f,d,h),i=a(f,d,n[t].geometry);delete e[f],delete r[d],r[l(p,n[i].geometry,!0)]=i,n[t].geometry=null;}else f in r?a(f,d,h):d in e?o(f,d,h):(s(u),e[f]=i-1,r[d]=i-1);}return n.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey));}update(t,e,r){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,{imagePositions:r}),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,{imagePositions:r}));}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment){let r=t.dist(e[t.segment+1]),n=t.dist(e[t.segment]);const i={};for(let n=t.segment+1;n<e.length;n++)i[n]={x:e[n].x,y:e[n].y,tileUnitDistanceFromAnchor:r},n<e.length-1&&(r+=e[n+1].dist(e[n]));for(let r=t.segment||0;r>=0;r--)i[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:n},r>0&&(n+=e[r-1].dist(e[r]));for(let t=0;t<e.length;t++){const e=i[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor);}}return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(e,r,n,i,s,a,o,l,u,c,h,p){const f=e.indexArray,d=e.layoutVertexArray,y=e.segments.prepareSegment(4*r.length,d,f,this.canOverlap?a.sortKey:void 0),m=this.glyphOffsetArray.length,g=y.vertexLength,x=this.allowVerticalPlacement&&o===t.az.vertical?Math.PI/2:0,v=a.text&&a.text.sections;for(let t=0;t<r.length;t++){const{tl:i,tr:s,bl:o,br:u,tex:c,pixelOffsetTL:h,pixelOffsetBR:m,minFontScaleX:g,minFontScaleY:b,glyphOffset:w,isSDF:_,sectionIndex:S}=r[t],A=y.vertexLength,k=w[1];lh(d,l.x,l.y,i.x,k+i.y,c.x,c.y,n,_,h.x,h.y,g,b),lh(d,l.x,l.y,s.x,k+s.y,c.x+c.w,c.y,n,_,m.x,h.y,g,b),lh(d,l.x,l.y,o.x,k+o.y,c.x,c.y+c.h,n,_,h.x,m.y,g,b),lh(d,l.x,l.y,u.x,k+u.y,c.x+c.w,c.y+c.h,n,_,m.x,m.y,g,b),uh(e.dynamicLayoutVertexArray,l,x),f.emplaceBack(A,A+2,A+1),f.emplaceBack(A+1,A+2,A+3),y.vertexLength+=4,y.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(w[0]),t!==r.length-1&&S===r[t+1].sectionIndex||e.programConfigurations.populatePaintArrays(d.length,a,a.index,{imagePositions:{},canonical:p,formattedSection:v&&v[S]});}e.placedSymbolArray.emplaceBack(l.x,l.y,m,this.glyphOffsetArray.length-m,g,u,c,l.segment,n?n[0]:0,n?n[1]:0,i[0],i[1],o,0,!1,0,h);}_addCollisionDebugVertex(t,e,r,n,i,s){return e.emplaceBack(0,0),t.emplaceBack(r.x,r.y,n,i,Math.round(s.x),Math.round(s.y))}addCollisionDebugVertices(t,e,n,i,s,a,o){const l=s.segments.prepareSegment(4,s.layoutVertexArray,s.indexArray),u=l.vertexLength,c=s.layoutVertexArray,h=s.collisionVertexArray,p=o.anchorX,f=o.anchorY;this._addCollisionDebugVertex(c,h,a,p,f,new r(t,e)),this._addCollisionDebugVertex(c,h,a,p,f,new r(n,e)),this._addCollisionDebugVertex(c,h,a,p,f,new r(n,i)),this._addCollisionDebugVertex(c,h,a,p,f,new r(t,i)),l.vertexLength+=4;const d=s.indexArray;d.emplaceBack(u,u+1),d.emplaceBack(u+1,u+2),d.emplaceBack(u+2,u+3),d.emplaceBack(u+3,u),l.primitiveLength+=4;}addDebugCollisionBoxes(t,e,r,n){for(let i=t;i<e;i++){const t=this.collisionBoxArray.get(i);this.addCollisionDebugVertices(t.x1,t.y1,t.x2,t.y2,n?this.textCollisionBox:this.iconCollisionBox,t.anchorPoint,r);}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new ph(Ja,hc.members,eo),this.iconCollisionBox=new ph(Ja,hc.members,eo);for(let t=0;t<this.symbolInstances.length;t++){const e=this.symbolInstances.get(t);this.addDebugCollisionBoxes(e.textBoxStartIndex,e.textBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.verticalTextBoxStartIndex,e.verticalTextBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.iconBoxStartIndex,e.iconBoxEndIndex,e,!1),this.addDebugCollisionBoxes(e.verticalIconBoxStartIndex,e.verticalIconBoxEndIndex,e,!1);}}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,s,a,o,l){const u={};for(let n=e;n<r;n++){const e=t.get(n);u.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY},u.textFeatureIndex=e.featureIndex;break}for(let e=n;e<i;e++){const r=t.get(e);u.verticalTextBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalTextFeatureIndex=r.featureIndex;break}for(let e=s;e<a;e++){const r=t.get(e);u.iconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.iconFeatureIndex=r.featureIndex;break}for(let e=o;e<l;e++){const r=t.get(e);u.verticalIconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalIconFeatureIndex=r.featureIndex;break}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+2,e+1),t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const a=this.symbolInstances.get(t);n.push(0|Math.round(e*a.anchorX+r*a.anchorY)),i.push(a.featureIndex);}return s.sort(((t,e)=>n[t]-n[e]||i[e]-i[t])),s}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach(((t,e,r)=>{t>=0&&r.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t);})),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}let dh,yh;ps("SymbolBucket",fh,{omit:["layers","collisionBoxArray","features","compareText"]}),fh.MAX_GLYPHS=65535,fh.addDynamicAttributes=uh;var mh={get paint(){return yh=yh||new Hs({"icon-opacity":new Gs(vt.paint_symbol["icon-opacity"]),"icon-color":new Gs(vt.paint_symbol["icon-color"]),"icon-halo-color":new Gs(vt.paint_symbol["icon-halo-color"]),"icon-halo-width":new Gs(vt.paint_symbol["icon-halo-width"]),"icon-halo-blur":new Gs(vt.paint_symbol["icon-halo-blur"]),"icon-translate":new js(vt.paint_symbol["icon-translate"]),"icon-translate-anchor":new js(vt.paint_symbol["icon-translate-anchor"]),"text-opacity":new Gs(vt.paint_symbol["text-opacity"]),"text-color":new Gs(vt.paint_symbol["text-color"],{runtimeType:Rt,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new Gs(vt.paint_symbol["text-halo-color"]),"text-halo-width":new Gs(vt.paint_symbol["text-halo-width"]),"text-halo-blur":new Gs(vt.paint_symbol["text-halo-blur"]),"text-translate":new js(vt.paint_symbol["text-translate"]),"text-translate-anchor":new js(vt.paint_symbol["text-translate-anchor"])})},get layout(){return dh=dh||new Hs({"symbol-placement":new js(vt.layout_symbol["symbol-placement"]),"symbol-spacing":new js(vt.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new js(vt.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new Gs(vt.layout_symbol["symbol-sort-key"]),"symbol-z-order":new js(vt.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new js(vt.layout_symbol["icon-allow-overlap"]),"icon-overlap":new js(vt.layout_symbol["icon-overlap"]),"icon-ignore-placement":new js(vt.layout_symbol["icon-ignore-placement"]),"icon-optional":new js(vt.layout_symbol["icon-optional"]),"icon-rotation-alignment":new js(vt.layout_symbol["icon-rotation-alignment"]),"icon-size":new Gs(vt.layout_symbol["icon-size"]),"icon-text-fit":new js(vt.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new js(vt.layout_symbol["icon-text-fit-padding"]),"icon-image":new Gs(vt.layout_symbol["icon-image"]),"icon-rotate":new Gs(vt.layout_symbol["icon-rotate"]),"icon-padding":new Gs(vt.layout_symbol["icon-padding"]),"icon-keep-upright":new js(vt.layout_symbol["icon-keep-upright"]),"icon-offset":new Gs(vt.layout_symbol["icon-offset"]),"icon-anchor":new Gs(vt.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new js(vt.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new js(vt.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new js(vt.layout_symbol["text-rotation-alignment"]),"text-field":new Gs(vt.layout_symbol["text-field"]),"text-font":new Gs(vt.layout_symbol["text-font"]),"text-size":new Gs(vt.layout_symbol["text-size"]),"text-max-width":new Gs(vt.layout_symbol["text-max-width"]),"text-line-height":new js(vt.layout_symbol["text-line-height"]),"text-letter-spacing":new Gs(vt.layout_symbol["text-letter-spacing"]),"text-justify":new Gs(vt.layout_symbol["text-justify"]),"text-radial-offset":new Gs(vt.layout_symbol["text-radial-offset"]),"text-variable-anchor":new js(vt.layout_symbol["text-variable-anchor"]),"text-variable-anchor-offset":new Gs(vt.layout_symbol["text-variable-anchor-offset"]),"text-anchor":new Gs(vt.layout_symbol["text-anchor"]),"text-max-angle":new js(vt.layout_symbol["text-max-angle"]),"text-writing-mode":new js(vt.layout_symbol["text-writing-mode"]),"text-rotate":new Gs(vt.layout_symbol["text-rotate"]),"text-padding":new js(vt.layout_symbol["text-padding"]),"text-keep-upright":new js(vt.layout_symbol["text-keep-upright"]),"text-transform":new Gs(vt.layout_symbol["text-transform"]),"text-offset":new Gs(vt.layout_symbol["text-offset"]),"text-allow-overlap":new js(vt.layout_symbol["text-allow-overlap"]),"text-overlap":new js(vt.layout_symbol["text-overlap"]),"text-ignore-placement":new js(vt.layout_symbol["text-ignore-placement"]),"text-optional":new js(vt.layout_symbol["text-optional"])})}};class gh{constructor(t){if(void 0===t.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=t.property.overrides?t.property.overrides.runtimeType:Vt,this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}ps("FormatSectionOverride",gh,{omit:["defaultValue"]});class xh extends Ks{constructor(t,e){super(t,mh,e);}recalculate(t,e){if(super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const r of t)e.indexOf(r)<0&&e.push(r);this.layout._values["text-writing-mode"]=e;}else this.layout._values["text-writing-mode"]=["horizontal"];}this._setPaintOverrides();}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||ri(s.value)||!i?i:function(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>t&&r in t?String(t[r]):""))}(e.properties,i)}createBucket(t){return new fh(t)}queryRadius(){return 0}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex")}_setPaintOverrides(){for(const t of mh.paint.overridableProperties){if(!xh.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new gh(e),n=new ei(r,e.property.specification);let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new ii("source",n):new si("composite",n,e.value.zoomStops),this.paint._values[t]=new Us(e.property,i,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven())&&xh.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=mh.paint.properties[e];let i=!1;const s=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof De)s(r.value.value.sections);else if("source"===r.value.kind||"composite"===r.value.kind){const t=e=>{i||(e instanceof je&&Ue(e.value)===jt?s(e.value.sections):e instanceof Ir?s(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return i}}let vh;var bh={get paint(){return vh=vh||new Hs({"background-color":new js(vt.paint_background["background-color"]),"background-pattern":new Ys(vt.paint_background["background-pattern"]),"background-opacity":new js(vt.paint_background["background-opacity"])})}};class wh extends Ks{constructor(t,e){super(t,bh,e);}}class _h extends Ks{constructor(t,e){super(t,{},e),this.onAdd=t=>{this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);},this.onRemove=t=>{this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);},this.implementation=t;}is3D(){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){return !1}serialize(){throw new Error("Custom layers cannot be serialized")}}class Sh{constructor(t){this._methodToThrottle=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._methodToThrottle();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._methodToThrottle();}),0));}remove(){delete this._channel,this._methodToThrottle=()=>{};}}const Ah={once:!0},kh=6371008.8;class Eh{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new Eh(L(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return kh*Math.acos(Math.min(i,1))}static convert(t){if(t instanceof Eh)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new Eh(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new Eh(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}const Th=2*Math.PI*kh;function Ih(t){return Th*Math.cos(t*Math.PI/180)}function Mh(t){return (180+t)/360}function Fh(t){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function Dh(t,e){return t/Ih(e)}function zh(t){return 360*t-180}function Ph(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function Bh(t,e){return t*Ih(Ph(e))}class Vh{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r;}static fromLngLat(t,e=0){const r=Eh.convert(t);return new Vh(Mh(r.lng),Fh(r.lat),Dh(e,r.lat))}toLngLat(){return new Eh(zh(this.x),Ph(this.y))}toAltitude(){return Bh(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/Th*(t=Ph(this.y),1/Math.cos(t*Math.PI/180));var t;}}function Ch(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return [t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}class Lh{constructor(t,e,r){if(!function(t,e,r){return !(t<0||t>25||r<0||r>=Math.pow(2,t)||e<0||e>=Math.pow(2,t))}(t,e,r))throw new Error(`x=${e}, y=${r}, z=${t} outside of bounds. 0<=x<${Math.pow(2,t)}, 0<=y<${Math.pow(2,t)} 0<=z<=25 `);this.z=t,this.x=e,this.y=r,this.key=Nh(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e,r){const n=function(t,e,r){var n=Ch(256*t,256*(e=Math.pow(2,r)-e-1),r),i=Ch(256*(t+1),256*(e+1),r);return n[0]+","+n[1]+","+i[0]+","+i[1]}(this.x,this.y,this.z),i=function(t,e,r){let n,i="";for(let s=t;s>0;s--)n=1<<s-1,i+=(e&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===r?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,e>1?"@2x":"").replace(/{quadkey}/g,i).replace(/{bbox-epsg-3857}/g,n)}isChildOf(t){const e=this.z-t.z;return e>0&&t.x===this.x>>e&&t.y===this.y>>e}getTilePoint(t){const e=Math.pow(2,this.z);return new r((t.x*e-this.x)*M,(t.y*e-this.y)*M)}toString(){return `${this.z}/${this.x}/${this.y}`}}class Oh{constructor(t,e){this.wrap=t,this.canonical=e,this.key=Nh(t,e.z,e.z,e.x,e.y);}}class Rh{constructor(t,e,r,n,i){if(this.terrainRttPosMatrix32f=null,t<r)throw new Error(`overscaledZ should be >= z; overscaledZ = ${t}; z = ${r}`);this.overscaledZ=t,this.wrap=e,this.canonical=new Lh(r,+n,+i),this.key=Nh(e,t,r,n,i);}clone(){return new Rh(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const e=this.canonical.z-t;return t>this.canonical.z?new Rh(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new Rh(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}isOverscaled(){return this.overscaledZ>this.canonical.z}calculateScaledKey(t,e){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const r=this.canonical.z-t;return t>this.canonical.z?Nh(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y):Nh(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}isChildOf(t){if(t.wrap!==this.wrap)return !1;if(this.overscaledZ-t.overscaledZ<=0)return !1;if(0===t.overscaledZ)return this.overscaledZ>0;const e=this.canonical.z-t.canonical.z;return !(e<0)&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return [new Rh(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return [new Rh(e,this.wrap,e,r,n),new Rh(e,this.wrap,e,r+1,n),new Rh(e,this.wrap,e,r,n+1),new Rh(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new Rh(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new Rh(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new Oh(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(t){return this.canonical.getTilePoint(new Vh(t.x-this.wrap,t.y))}}function Nh(t,e,r,n,i){(t*=2)<0&&(t=-1*t-1);const s=1<<r;return (s*s*t+s*i+n).toString(36)+r.toString(36)+e.toString(36)}function $h(t,e){return e?t.properties[e]:t.id}function Uh(t,e){const r={id:t.id};if(e.removeAllProperties&&(delete t.removeProperties,delete t.addOrUpdateProperties,delete e.removeProperties),e.removeProperties)for(const r of e.removeProperties){const e=t.addOrUpdateProperties.findIndex((t=>t.key===r));e>-1&&t.addOrUpdateProperties.splice(e,1);}return (t.removeAllProperties||e.removeAllProperties)&&(r.removeAllProperties=!0),(t.removeProperties||e.removeProperties)&&(r.removeProperties=[...t.removeProperties||[],...e.removeProperties||[]]),(t.addOrUpdateProperties||e.addOrUpdateProperties)&&(r.addOrUpdateProperties=[...t.addOrUpdateProperties||[],...e.addOrUpdateProperties||[]]),(t.newGeometry||e.newGeometry)&&(r.newGeometry=e.newGeometry||t.newGeometry),r}function qh(t){var e,r;if(!t)return {};const n={};return n.removeAll=t.removeAll,n.remove=new Set(t.remove||[]),n.add=new Map(null===(e=t.add)||void 0===e?void 0:e.map((t=>[t.id,t]))),n.update=new Map(null===(r=t.update)||void 0===r?void 0:r.map((t=>[t.id,t]))),n}ps("CanonicalTileID",Lh),ps("OverscaledTileID",Rh,{omit:["terrainRttPosMatrix32f"]});class jh{constructor(){this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0;}extend(t){return this.minX=Math.min(this.minX,t.x),this.minY=Math.min(this.minY,t.y),this.maxX=Math.max(this.maxX,t.x),this.maxY=Math.max(this.maxY,t.y),this}expandBy(t){return this.minX-=t,this.minY-=t,this.maxX+=t,this.maxY+=t,(this.minX>this.maxX||this.minY>this.maxY)&&(this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0),this}shrinkBy(t){return this.expandBy(-t)}map(t){const e=new jh;return e.extend(t(new r(this.minX,this.minY))),e.extend(t(new r(this.maxX,this.minY))),e.extend(t(new r(this.minX,this.maxY))),e.extend(t(new r(this.maxX,this.maxY))),e}static fromPoints(t){const e=new jh;for(const r of t)e.extend(r);return e}contains(t){return t.x>=this.minX&&t.x<=this.maxX&&t.y>=this.minY&&t.y<=this.maxY}empty(){return this.minX>this.maxX}width(){return this.maxX-this.minX}height(){return this.maxY-this.minY}covers(t){return !this.empty()&&!t.empty()&&t.minX>=this.minX&&t.maxX<=this.maxX&&t.minY>=this.minY&&t.maxY<=this.maxY}intersects(t){return !this.empty()&&!t.empty()&&t.minX<=this.maxX&&t.maxX>=this.minX&&t.minY<=this.maxY&&t.maxY>=this.minY}}class Gh{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t]}decode(t){if(t>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${t} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[t]}}class Xh{constructor(t,e,r,n,i){this.type="Feature",this._vectorTileFeature=t,this._x=r,this._y=n,this._z=e,this.properties=t.properties,this.id=i;}projectPoint(t,e,r,n){return [360*(t.x+e)/n-180,360/Math.PI*Math.atan(Math.exp((1-2*(t.y+r)/n)*Math.PI))-90]}projectLine(t,e,r,n){return t.map((t=>this.projectPoint(t,e,r,n)))}get geometry(){if(this._geometry)return this._geometry;const t=this._vectorTileFeature,e=t.extent*Math.pow(2,this._z),r=t.extent*this._x,n=t.extent*this._y,i=t.loadGeometry();switch(t.type){case 1:{const t=[];for(const e of i)t.push(e[0]);const s=this.projectLine(t,r,n,e);this._geometry=1===t.length?{type:"Point",coordinates:s[0]}:{type:"MultiPoint",coordinates:s};break}case 2:{const t=i.map((t=>this.projectLine(t,r,n,e)));this._geometry=1===t.length?{type:"LineString",coordinates:t[0]}:{type:"MultiLineString",coordinates:t};break}case 3:{const t=Du(i),s=[];for(const i of t)s.push(i.map((t=>this.projectLine(t,r,n,e))));this._geometry=1===s.length?{type:"Polygon",coordinates:s[0]}:{type:"MultiPolygon",coordinates:s};break}default:throw new Error(`unknown feature type: ${t.type}`)}return this._geometry}set geometry(t){this._geometry=t;}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&"_x"!==e&&"_y"!==e&&"_z"!==e&&(t[e]=this[e]);return t}}class Yh{_name;dataBuffer;nullabilityBuffer;_size;constructor(t,e,r){this._name=t,this.dataBuffer=e,"number"==typeof r?this._size=r:(this.nullabilityBuffer=r,this._size=r.size());}getValue(t){return this.nullabilityBuffer&&!this.nullabilityBuffer.get(t)?null:this.getValueFromBuffer(t)}has(t){return this.nullabilityBuffer&&this.nullabilityBuffer.get(t)||!this.nullabilityBuffer}get name(){return this._name}get size(){return this._size}}class Zh extends Yh{}class Hh extends Zh{getValueFromBuffer(t){return this.dataBuffer[t]}}class Kh extends Zh{getValueFromBuffer(t){return this.dataBuffer[t]}}class Wh extends Yh{delta;constructor(t,e,r,n){super(t,e,n),this.delta=r;}}class Jh extends Wh{constructor(t,e,r,n){super(t,Int32Array.of(e),r,n);}getValueFromBuffer(t){return this.dataBuffer[0]+t*this.delta}}class Qh extends Yh{constructor(t,e,r){super(t,Int32Array.of(e),r);}getValueFromBuffer(t){return this.dataBuffer[0]}}class tp{_name;_geometryVector;_idVector;_propertyVectors;_extent;propertyVectorsMap;constructor(t,e,r,n,i=4096){this._name=t,this._geometryVector=e,this._idVector=r,this._propertyVectors=n,this._extent=i;}get name(){return this._name}get idVector(){return this._idVector}get geometryVector(){return this._geometryVector}get propertyVectors(){return this._propertyVectors}getPropertyVector(t){return this.propertyVectorsMap||(this.propertyVectorsMap=new Map(this._propertyVectors.map((t=>[t.name,t])))),this.propertyVectorsMap.get(t)}*[Symbol.iterator](){const t=this.geometryVector[Symbol.iterator]();let e=0;for(;e<this.numFeatures;){let r;this.idVector&&(r=this.containsMaxSaveIntegerValues(this.idVector)?Number(this.idVector.getValue(e)):this.idVector.getValue(e));const n=t?.next().value,i={};for(const t of this.propertyVectors){if(!t)continue;const r=t.name,n=t.getValue(e);null!==n&&(i[r]=n);}e++,yield {id:r,geometry:n,properties:i};}}get numFeatures(){return this.geometryVector.numGeometries}get extent(){return this._extent}getFeatures(){const t=[],e=this.geometryVector.getGeometries();for(let r=0;r<this.numFeatures;r++){let n;this.idVector&&(n=this.containsMaxSaveIntegerValues(this.idVector)?Number(this.idVector.getValue(r)):this.idVector.getValue(r));const i={coordinates:e[r],type:this.geometryVector.geometryType(r)},s={};for(const t of this.propertyVectors){if(!t)continue;const e=t.name,n=t.getValue(r);null!==n&&(s[e]=n);}t.push({id:n,geometry:i,properties:s});}return t}containsMaxSaveIntegerValues(t){return t instanceof Hh||t instanceof Qh&&t instanceof Jh||t instanceof Kh}}class ep{value;constructor(t){this.value=t;}get(){return this.value}set(t){this.value=t;}increment(){return this.value++}add(t){this.value+=t;}}var rp,np,ip,sp,ap,op,lp,up,cp,hp;function pp(t,e,r){const n=new Int32Array(r);let i=0,s=e.get();for(let e=0;e<n.length;e++){let e=t[s++],r=127&e;e<128||(e=t[s++],r|=(127&e)<<7,e<128||(e=t[s++],r|=(127&e)<<14,e<128||(e=t[s++],r|=(127&e)<<21,e<128||(e=t[s++],r|=(15&e)<<28)))),n[i++]=r;}return e.set(s),n}function fp(t,e,r){const n=new BigInt64Array(r);for(let r=0;r<n.length;r++)n[r]=xp(t,e);return n}function dp(t,e){let r,n;return n=t[e.get()],e.increment(),r=127&n,n<128?r:(n=t[e.get()],e.increment(),r|=(127&n)<<7,n<128?r:(n=t[e.get()],e.increment(),r|=(127&n)<<14,n<128?r:(n=t[e.get()],e.increment(),r|=(127&n)<<21,n<128?r:(n=t[e.get()],r|=(15&n)<<28,function(t,e,r){let n,i;if(i=e[r.get()],r.increment(),n=(112&i)>>4,i<128)return 4294967296*n+(t>>>0);if(i=e[r.get()],r.increment(),n|=(127&i)<<3,i<128)return 4294967296*n+(t>>>0);if(i=e[r.get()],r.increment(),n|=(127&i)<<10,i<128)return 4294967296*n+(t>>>0);if(i=e[r.get()],r.increment(),n|=(127&i)<<17,i<128)return 4294967296*n+(t>>>0);if(i=e[r.get()],r.increment(),n|=(127&i)<<24,i<128)return 4294967296*n+(t>>>0);if(i=e[r.get()],r.increment(),n|=(1&i)<<31,i<128)return 4294967296*n+(t>>>0);throw new Error("Expected varint not more than 10 bytes")}(r,t,e)))))}function yp(t,e,r,n){throw new Error("FastPFor is not implemented yet.")}function mp(t){return t>>>1^-(1&t)}function gp(t){return t>>1n^-(1n&t)}function xp(t,e){let r=0n,n=0,i=e.get();for(;i<t.length;){const e=t[i++];if(r|=BigInt(127&e)<<BigInt(n),!(128&e))break;if(n+=7,n>=64)throw new Error("Varint too long")}return e.set(i),r}function vp(t,e,r){const n=new Int32Array(r);let i=0;for(let r=0;r<e;r++){const s=t[r];n.fill(t[r+e],i,i+s),i+=s;}return n}function bp(t,e,r){const n=new BigInt64Array(r);let i=0;for(let r=0;r<e;r++){const s=Number(t[r]);n.fill(t[r+e],i,i+s),i+=s;}return n}function wp(t,e,r){const n=new Float64Array(r);let i=0;for(let r=0;r<e;r++){const s=t[r];n.fill(t[r+e],i,i+s),i+=s;}return n}function _p(t){const e=t.length/4*4;let r=1;if(e>=4)for(let n=t[0];r<e-4;r+=4)n=t[r]+=n,n=t[r+1]+=n,n=t[r+2]+=n,n=t[r+3]+=n;for(;r!=t.length;)t[r]+=t[r-1],++r;}function Sp(t){t[0]=t[0]>>>1^-(1&t[0]),t[1]=t[1]>>>1^-(1&t[1]);const e=t.length/4*4;let r=2;if(e>=4)for(;r<e-4;r+=4){const e=t[r],n=t[r+1],i=t[r+2],s=t[r+3];t[r]=(e>>>1^-(1&e))+t[r-2],t[r+1]=(n>>>1^-(1&n))+t[r-1],t[r+2]=(i>>>1^-(1&i))+t[r],t[r+3]=(s>>>1^-(1&s))+t[r+1];}for(;r!=t.length;r+=2)t[r]=(t[r]>>>1^-(1&t[r]))+t[r-2],t[r+1]=(t[r+1]>>>1^-(1&t[r+1]))+t[r-1];}!function(t){t.NONE="NONE",t.DELTA="DELTA",t.COMPONENTWISE_DELTA="COMPONENTWISE_DELTA",t.RLE="RLE",t.MORTON="MORTON",t.PDE="PDE";}(rp||(rp={})),function(t){t.NONE="NONE",t.FAST_PFOR="FAST_PFOR",t.VARINT="VARINT",t.ALP="ALP";}(np||(np={})),function(t){t.PRESENT="PRESENT",t.DATA="DATA",t.OFFSET="OFFSET",t.LENGTH="LENGTH";}(ip||(ip={}));class Ap{_dictionaryType;_offsetType;_lengthType;constructor(t,e,r){this._dictionaryType=t,this._offsetType=e,this._lengthType=r;}get dictionaryType(){return this._dictionaryType}get offsetType(){return this._offsetType}get lengthType(){return this._lengthType}}function kp(t,e){const r=function(t,e){const r=t[e.get()],n=Object.values(ip)[r>>4];let i=null;switch(n){case ip.DATA:i=new Ap(Object.values(sp)[15&r]);break;case ip.OFFSET:i=new Ap(null,Object.values(ap)[15&r]);break;case ip.LENGTH:i=new Ap(null,null,Object.values(op)[15&r]);}e.increment();const s=t[e.get()],a=Object.values(rp)[s>>5],o=Object.values(rp)[s>>2&7],l=Object.values(np)[3&s];e.increment();const u=pp(t,e,2),c=u[0];return {physicalStreamType:n,logicalStreamType:i,logicalLevelTechnique1:a,logicalLevelTechnique2:o,physicalLevelTechnique:l,numValues:c,byteLength:u[1],decompressedCount:c}}(t,e);return r.logicalLevelTechnique1===rp.MORTON?function(t,e,r){const n=pp(e,r,2);return {physicalStreamType:t.physicalStreamType,logicalStreamType:t.logicalStreamType,logicalLevelTechnique1:t.logicalLevelTechnique1,logicalLevelTechnique2:t.logicalLevelTechnique2,physicalLevelTechnique:t.physicalLevelTechnique,numValues:t.numValues,byteLength:t.byteLength,decompressedCount:t.decompressedCount,numBits:n[0],coordinateShift:n[1]}}(r,t,e):rp.RLE!==r.logicalLevelTechnique1&&rp.RLE!==r.logicalLevelTechnique2||np.NONE===r.physicalLevelTechnique?r:function(t,e,r){const n=pp(e,r,2);return {physicalStreamType:t.physicalStreamType,logicalStreamType:t.logicalStreamType,logicalLevelTechnique1:t.logicalLevelTechnique1,logicalLevelTechnique2:t.logicalLevelTechnique2,physicalLevelTechnique:t.physicalLevelTechnique,numValues:t.numValues,byteLength:t.byteLength,decompressedCount:n[1],runs:n[0],numRleValues:n[1]}}(r,t,e)}!function(t){t.NONE="NONE",t.SINGLE="SINGLE",t.SHARED="SHARED",t.VERTEX="VERTEX",t.MORTON="MORTON",t.FSST="FSST";}(sp||(sp={})),function(t){t.VERTEX="VERTEX",t.INDEX="INDEX",t.STRING="STRING",t.KEY="KEY";}(ap||(ap={})),function(t){t.VAR_BINARY="VAR_BINARY",t.GEOMETRIES="GEOMETRIES",t.PARTS="PARTS",t.RINGS="RINGS",t.TRIANGLES="TRIANGLES",t.SYMBOL="SYMBOL",t.DICTIONARY="DICTIONARY";}(op||(op={})),function(t){t[t.FLAT=0]="FLAT",t[t.CONST=1]="CONST",t[t.SEQUENCE=2]="SEQUENCE",t[t.DICTIONARY=3]="DICTIONARY",t[t.FSST_DICTIONARY=4]="FSST_DICTIONARY";}(lp||(lp={}));class Ep{values;_size;constructor(t,e){this.values=t,this._size=e;}get(t){const e=Math.floor(t/8);return 1==(this.values[e]>>t%8&1)}set(t,e){const r=Math.floor(t/8);this.values[r]=this.values[r]|(e?1:0)<<t%8;}getInt(t){const e=Math.floor(t/8);return this.values[e]>>t%8&1}size(){return this._size}getBuffer(){return this.values}}function Tp(t,e,r,n,i){return function(t,e,r){switch(e.logicalLevelTechnique1){case rp.DELTA:return e.logicalLevelTechnique2===rp.RLE?function(t,e,r){const n=new Int32Array(r);let i=0,s=0;for(let r=0;r<e;r++){const a=t[r],o=mp(t[r+e]);for(let t=0;t<a;t++)s+=o,n[i++]=s;}return n}(t,e.runs,e.numRleValues):(function(t){t[0]=t[0]>>>1^-(1&t[0]);const e=t.length/4*4;let r=1;if(e>=4)for(;r<e-4;r+=4){const e=t[r],n=t[r+1],i=t[r+2],s=t[r+3];t[r]=(e>>>1^-(1&e))+t[r-1],t[r+1]=(n>>>1^-(1&n))+t[r],t[r+2]=(i>>>1^-(1&i))+t[r+1],t[r+3]=(s>>>1^-(1&s))+t[r+2];}for(;r!=t.length;++r)t[r]=(t[r]>>>1^-(1&t[r]))+t[r-1];}(t),t);case rp.RLE:return function(t,e,r){return r?function(t,e,r){const n=new Int32Array(r);let i=0;for(let r=0;r<e;r++){const s=t[r];let a=t[r+e];a=a>>>1^-(1&a),n.fill(a,i,i+s),i+=s;}return n}(t,e.runs,e.numRleValues):vp(t,e.runs,e.numRleValues)}(t,e,r);case rp.MORTON:return _p(t),t;case rp.COMPONENTWISE_DELTA:return Sp(t),t;case rp.NONE:return r&&function(t){for(let e=0;e<t.length;e++){const r=t[e];t[e]=r>>>1^-(1&r);}}(t),t;default:throw new Error(`The specified Logical level technique is not supported: ${e.logicalLevelTechnique1}`)}}(Mp(t,e,r),r,n)}function Ip(t,e,r){return function(t,e){if(e.logicalLevelTechnique1===rp.DELTA&&e.logicalLevelTechnique2===rp.NONE){const e=function(t){const e=new Int32Array(t.length+1);e[0]=0,e[1]=mp(t[0]);let r=e[1],n=2;for(;n!=e.length;++n){const i=t[n-1];r+=i>>>1^-(1&i),e[n]=e[n-1]+r;}return e}(t);return e}if(e.logicalLevelTechnique1===rp.RLE&&e.logicalLevelTechnique2===rp.NONE){const r=function(t,e,r){const n=new Int32Array(r+1);n[0]=0;let i=1,s=n[0];for(let r=0;r<e;r++){const a=t[r],o=t[r+e];for(let t=i;t<i+a;t++)n[t]=o+s,s=n[t];i+=a;}return n}(t,e.runs,e.numRleValues);return r}if(e.logicalLevelTechnique1===rp.NONE&&e.logicalLevelTechnique2===rp.NONE){!function(t){let e=0;for(let r=0;r<t.length;r++)t[r]+=e,e=t[r];}(t);const r=new Int32Array(e.numValues+1);return r[0]=0,r.set(t,1),r}if(e.logicalLevelTechnique1===rp.DELTA&&e.logicalLevelTechnique2===rp.RLE){const r=function(t,e,r){const n=new Int32Array(r+1);n[0]=0;let i=1,s=n[0];for(let r=0;r<e;r++){const a=t[r];let o=t[r+e];o=o>>>1^-(1&o);for(let t=i;t<i+a;t++)n[t]=o+s,s=n[t];i+=a;}return n}(t,e.runs,e.numRleValues);return _p(r),r}throw new Error("Only delta encoding is supported for transforming length to offset streams yet.")}(Mp(t,e,r),r)}function Mp(t,e,r){const n=r.physicalLevelTechnique;if(n===np.FAST_PFOR)return yp();if(n===np.VARINT)return pp(t,e,r.numValues);if(n===np.NONE){const n=e.get();e.add(r.byteLength);const i=t.subarray(n,e.get());return new Int32Array(i)}throw new Error("Specified physicalLevelTechnique is not supported (yet).")}function Fp(t,e,r,n){const i=Mp(t,e,r);if(1===i.length){const t=i[0];return n?mp(t):t}return n?function(t){return mp(t[1])}(i):function(t){return t[1]}(i)}function Dp(t,e,r){return function(t){if(2==t.length){const e=mp(t[1]);return [e,e]}return [mp(t[2]),mp(t[3])]}(Mp(t,e,r))}function zp(t,e,r){return function(t){if(2==t.length){const e=gp(t[1]);return [e,e]}return [gp(t[2]),gp(t[3])]}(fp(t,e,r.numValues))}function Pp(t,e,r,n){return function(t,e,r){switch(e.logicalLevelTechnique1){case rp.DELTA:return e.logicalLevelTechnique2===rp.RLE?function(t,e,r){const n=new BigInt64Array(r);let i=0,s=0n;for(let r=0;r<e;r++){const a=Number(t[r]),o=gp(t[r+e]);for(let t=0;t<a;t++)s+=o,n[i++]=s;}return n}(t,e.runs,e.numRleValues):(function(t){t[0]=t[0]>>1n^-(1n&t[0]);const e=t.length/4*4;let r=1;if(e>=4)for(;r<e-4;r+=4){const e=t[r],n=t[r+1],i=t[r+2],s=t[r+3];t[r]=(e>>1n^-(1n&e))+t[r-1],t[r+1]=(n>>1n^-(1n&n))+t[r],t[r+2]=(i>>1n^-(1n&i))+t[r+1],t[r+3]=(s>>1n^-(1n&s))+t[r+2];}for(;r!=t.length;++r)t[r]=(t[r]>>1n^-(1n&t[r]))+t[r-1];}(t),t);case rp.RLE:return function(t,e,r){return r?function(t,e,r){const n=new BigInt64Array(r);let i=0;for(let r=0;r<e;r++){const s=Number(t[r]);let a=t[r+e];a=a>>1n^-(1n&a),n.fill(a,i,i+s),i+=s;}return n}(t,e.runs,e.numRleValues):bp(t,e.runs,e.numRleValues)}(t,e,r);case rp.NONE:return r&&function(t){for(let e=0;e<t.length;e++){const r=t[e];t[e]=r>>1n^-(1n&r);}}(t),t;default:throw new Error(`The specified Logical level technique is not supported: ${e.logicalLevelTechnique1}`)}}(fp(t,e,r.numValues),r,n)}function Bp(t,e,r,n){const i=fp(t,e,r.numValues);if(1===i.length){const t=i[0];return n?gp(t):t}return n?function(t){return gp(t[1])}(i):function(t){return t[1]}(i)}function Vp(t,e,r,n,i){return function(t,e,r,n){switch(e.logicalLevelTechnique1){case rp.DELTA:return e.logicalLevelTechnique2===rp.RLE&&(t=vp(t,e.runs,e.numRleValues)),function(t,e){const r=new Int32Array(t.size());let n=0;t.get(0)?(r[0]=t.get(0)?e[0]>>>1^-(1&e[0]):0,n=1):r[0]=0;let i=1;for(;i!=r.length;++i)r[i]=t.get(i)?r[i-1]+(e[n]>>>1^-(1&e[n++])):r[i-1];return r}(n,t);case rp.RLE:return function(t,e,r,n){const i=e;return r?function(t,e,r){const n=new Int32Array(t.size());let i=0;for(let s=0;s<r;s++){const a=e[s];let o=e[s+r];o=o>>>1^-(1&o);for(let e=i;e<i+a;e++)t.get(e)?n[e]=o:(n[e]=0,i++);i+=a;}return n}(n,t,i.runs):function(t,e,r){const n=new Int32Array(t.size());let i=0;for(let s=0;s<r;s++){const a=e[s],o=e[s+r];for(let e=i;e<i+a;e++)t.get(e)?n[e]=o:(n[e]=0,i++);i+=a;}return n}(n,t,i.runs)}(t,e,r,n);case rp.MORTON:return _p(t),t;case rp.COMPONENTWISE_DELTA:return Sp(t),t;case rp.NONE:return t=r?function(t,e){const r=new Int32Array(t.size());let n=0,i=0;for(;i!=r.length;++i)if(t.get(i)){const t=e[n++];r[i]=t>>>1^-(1&t);}else r[i]=0;return r}(n,t):function(t,e){const r=new Int32Array(t.size());let n=0,i=0;for(;i!=r.length;++i)r[i]=t.get(i)?e[n++]:0;return r}(n,t),t;default:throw new Error("The specified Logical level technique is not supported")}}(r.physicalLevelTechnique===np.FAST_PFOR?yp():pp(t,e,r.numValues),r,n,i)}function Cp(t,e,r,n){const i=t.logicalLevelTechnique1;if(i===rp.RLE)return 1===t.runs?lp.CONST:lp.FLAT;const s=e instanceof Ep?e.size():e;if(i===rp.DELTA&&t.logicalLevelTechnique2===rp.RLE){const e=t.runs,i=2;if(t.numRleValues!==s)return lp.FLAT;if(1===e)return lp.SEQUENCE;if(2===e){const e=n.get();let s;if(t.physicalLevelTechnique===np.VARINT)s=pp(r,n,4);else {const t=n.get();s=new Int32Array(r.buffer,r.byteOffset+t,4);}if(n.set(e),s[2]===i&&s[3]===i)return lp.SEQUENCE}}return 1===t.numValues?lp.CONST:lp.FLAT}class Lp extends Zh{getValueFromBuffer(t){return this.dataBuffer[t]}}class Op extends Wh{constructor(t,e,r,n){super(t,BigInt64Array.of(e),r,n);}getValueFromBuffer(t){return this.dataBuffer[0]+BigInt(t)*this.delta}}class Rp{_geometryOffsets;_partOffsets;_ringOffsets;constructor(t,e,r){this._geometryOffsets=t,this._partOffsets=e,this._ringOffsets=r;}get geometryOffsets(){return this._geometryOffsets}get partOffsets(){return this._partOffsets}get ringOffsets(){return this._ringOffsets}}function Np(t,e,r){return {x:$p(t,e)-r,y:$p(t>>1,e)-r}}function $p(t,e){let r=0;for(let n=0;n<e;n++)r|=(t&1<<2*n)>>n;return r}!function(t){t[t.POINT=0]="POINT",t[t.LINESTRING=1]="LINESTRING",t[t.POLYGON=2]="POLYGON",t[t.MULTIPOINT=3]="MULTIPOINT",t[t.MULTILINESTRING=4]="MULTILINESTRING",t[t.MULTIPOLYGON=5]="MULTIPOLYGON";}(up||(up={})),function(t){t[t.POINT=0]="POINT",t[t.LINESTRING=1]="LINESTRING",t[t.POLYGON=2]="POLYGON";}(cp||(cp={})),function(t){t[t.MORTON=0]="MORTON",t[t.VEC_2=1]="VEC_2",t[t.VEC_3=2]="VEC_3";}(hp||(hp={}));class Up{createPoint(t){return [[t]]}createMultiPoint(t){return t.map((t=>[t]))}createLineString(t){return [t]}createMultiLineString(t){return t}createPolygon(t,e){return [t].concat(e)}createMultiPolygon(t){return t.flat()}}function qp(t){const e=new Array(t.numGeometries);let n=1,i=1,s=1,a=0;const o=new Up;let l=0,u=0;const c=t.mortonSettings,h=t.topologyVector,p=h.geometryOffsets,f=h.partOffsets,d=h.ringOffsets,y=t.vertexOffsets,m=t.containsPolygonGeometry(),g=t.vertexBuffer;for(let h=0;h<t.numGeometries;h++){const x=t.geometryType(h);if(x===up.POINT){if(y&&0!==y.length)if(t.vertexBufferType===hp.VEC_2){const t=2*y[u++],n=new r(g[t],g[t+1]);e[a++]=o.createPoint(n);}else {const t=Np(g[y[u++]],c.numBits,c.coordinateShift),n=new r(t.x,t.y);e[a++]=o.createPoint(n);}else {const t=new r(g[l++],g[l++]);e[a++]=o.createPoint(t);}p&&s++,f&&n++,d&&i++;}else if(x===up.MULTIPOINT){const t=p[s]-p[s-1];s++;const n=new Array(t);if(y&&0!==y.length){for(let e=0;e<t;e++){const t=2*y[u++];n[e]=new r(g[t],g[t+1]);}e[a++]=o.createMultiPoint(n);}else {for(let e=0;e<t;e++){const t=g[l++],i=g[l++];n[e]=new r(t,i);}e[a++]=o.createMultiPoint(n);}}else if(x===up.LINESTRING){let r,h=0;m?(h=d[i]-d[i-1],i++):h=f[n]-f[n-1],n++,y&&0!==y.length?(r=t.vertexBufferType===hp.VEC_2?Zp(g,y,u,h,!1):Hp(g,y,u,h,!1,c),u+=h):(r=Yp(g,l,h,!1),l+=2*h),e[a++]=o.createLineString(r),p&&s++;}else if(x===up.POLYGON){const r=f[n]-f[n-1];n++;const h=new Array(r-1);let m=d[i]-d[i-1];if(i++,y&&0!==y.length){const r=t.vertexBufferType===hp.VEC_2?Gp(g,y,u,m):Xp(g,y,u,m,0,c);u+=m;for(let e=0;e<h.length;e++)m=d[i]-d[i-1],i++,h[e]=t.vertexBufferType===hp.VEC_2?Gp(g,y,u,m):Xp(g,y,u,m,0,c),u+=m;e[a++]=o.createPolygon(r,h);}else {const t=jp(g,l,m);l+=2*m;for(let t=0;t<h.length;t++)m=d[i]-d[i-1],i++,h[t]=jp(g,l,m),l+=2*m;e[a++]=o.createPolygon(t,h);}p&&s++;}else if(x===up.MULTILINESTRING){const r=p[s]-p[s-1];s++;const h=new Array(r);if(y&&0!==y.length){for(let e=0;e<r;e++){let r=0;m?(r=d[i]-d[i-1],i++):r=f[n]-f[n-1],n++;const s=t.vertexBufferType===hp.VEC_2?Zp(g,y,u,r,!1):Hp(g,y,u,r,!1,c);h[e]=s,u+=r;}e[a++]=o.createMultiLineString(h);}else {for(let t=0;t<r;t++){let e=0;m?(e=d[i]-d[i-1],i++):e=f[n]-f[n-1],n++,h[t]=Yp(g,l,e,!1),l+=2*e;}e[a++]=o.createMultiLineString(h);}}else {if(x!==up.MULTIPOLYGON)throw new Error("The specified geometry type is currently not supported.");{const r=p[s]-p[s-1];s++;const h=new Array(r);let m=0;if(y&&0!==y.length){for(let e=0;e<r;e++){const r=f[n]-f[n-1];n++;const s=new Array(r-1);m=d[i]-d[i-1],i++;const a=t.vertexBufferType===hp.VEC_2?Gp(g,y,u,m):Xp(g,y,u,m,0,c);u+=m;for(let e=0;e<s.length;e++)m=d[i]-d[i-1],i++,s[e]=t.vertexBufferType===hp.VEC_2?Gp(g,y,u,m):Xp(g,y,u,m,0,c),u+=m;h[e]=o.createPolygon(a,s);}e[a++]=o.createMultiPolygon(h);}else {for(let t=0;t<r;t++){const e=f[n]-f[n-1];n++;const r=new Array(e-1);m=d[i]-d[i-1],i++;const s=jp(g,l,m);l+=2*m;for(let t=0;t<r.length;t++){const e=d[i]-d[i-1];i++,r[t]=jp(g,l,e),l+=2*e;}h[t]=o.createPolygon(s,r);}e[a++]=o.createMultiPolygon(h);}}}}return e}function jp(t,e,r){return Yp(t,e,r,!0)}function Gp(t,e,r,n){return Zp(t,e,r,n,!0)}function Xp(t,e,r,n,i,s){return Hp(t,e,r,n,!0,s)}function Yp(t,e,n,i){const s=new Array(i?n+1:n);for(let i=0;i<2*n;i+=2)s[i/2]=new r(t[e+i],t[e+i+1]);return i&&(s[s.length-1]=s[0]),s}function Zp(t,e,n,i,s){const a=new Array(s?i+1:i);for(let s=0;s<2*i;s+=2){const i=2*e[n+s/2];a[s/2]=new r(t[i],t[i+1]);}return s&&(a[a.length-1]=a[0]),a}function Hp(t,e,n,i,s,a){const o=new Array(s?i+1:i);for(let s=0;s<i;s++){const i=Np(t[e[n+s]],a.numBits,a.coordinateShift);o[s]=new r(i.x,i.y);}return s&&(o[o.length-1]=o[0]),o}class Kp{_vertexBufferType;_topologyVector;_vertexOffsets;_vertexBuffer;_mortonSettings;constructor(t,e,r,n,i){this._vertexBufferType=t,this._topologyVector=e,this._vertexOffsets=r,this._vertexBuffer=n,this._mortonSettings=i;}get vertexBufferType(){return this._vertexBufferType}get topologyVector(){return this._topologyVector}get vertexOffsets(){return this._vertexOffsets}get vertexBuffer(){return this._vertexBuffer}*[Symbol.iterator](){const t=qp(this);let e=0;for(;e<this.numGeometries;)yield {coordinates:t[e],type:this.geometryType(e)},e++;}getSimpleEncodedVertex(t){const e=this.vertexOffsets?2*this.vertexOffsets[t]:2*t;return [this.vertexBuffer[e],this.vertexBuffer[e+1]]}getVertex(t){if(this.vertexOffsets&&this.mortonSettings){const e=Np(this.vertexBuffer[this.vertexOffsets[t]],this.mortonSettings.numBits,this.mortonSettings.coordinateShift);return [e.x,e.y]}const e=this.vertexOffsets?2*this.vertexOffsets[t]:2*t;return [this.vertexBuffer[e],this.vertexBuffer[e+1]]}getGeometries(){return qp(this)}get mortonSettings(){return this._mortonSettings}}class Wp extends Kp{_numGeometries;_geometryType;constructor(t,e,r,n,i,s,a){super(r,n,i,s,a),this._numGeometries=t,this._geometryType=e;}geometryType(t){return this._geometryType}get numGeometries(){return this._numGeometries}containsPolygonGeometry(){return this._geometryType===up.POLYGON||this._geometryType===up.MULTIPOLYGON}containsSingleGeometryType(){return !0}}class Jp extends Kp{_geometryTypes;constructor(t,e,r,n,i,s){super(t,r,n,i,s),this._geometryTypes=e;}geometryType(t){return this._geometryTypes[t]}get numGeometries(){return this._geometryTypes.length}containsPolygonGeometry(){for(let t=0;t<this.numGeometries;t++)if(this.geometryType(t)===up.POLYGON||this.geometryType(t)===up.MULTIPOLYGON)return !0;return !1}containsSingleGeometryType(){return !1}}class Qp{_triangleOffsets;_indexBuffer;_vertexBuffer;_topologyVector;constructor(t,e,r,n){this._triangleOffsets=t,this._indexBuffer=e,this._vertexBuffer=r,this._topologyVector=n;}get triangleOffsets(){return this._triangleOffsets}get indexBuffer(){return this._indexBuffer}get vertexBuffer(){return this._vertexBuffer}get topologyVector(){return this._topologyVector}getGeometries(){if(!this._topologyVector)throw new Error("Cannot convert GpuVector to coordinates without topology information");const t=new Array(this.numGeometries),e=this._topologyVector,n=e.partOffsets,i=e.ringOffsets,s=e.geometryOffsets;let a=0,o=1,l=1,u=1;for(let e=0;e<this.numGeometries;e++)switch(this.geometryType(e)){case up.POLYGON:{const c=n[o]-n[o-1];o++;const h=[];for(let t=0;t<c;t++){const t=i[l]-i[l-1];l++;const e=[];for(let n=0;n<t;n++){const t=this._vertexBuffer[a++],n=this._vertexBuffer[a++];e.push(new r(t,n));}e.length>0&&e.push(e[0]),h.push(e);}t[e]=h,s&&u++;}break;case up.MULTIPOLYGON:{const c=s[u]-s[u-1];u++;const h=[];for(let t=0;t<c;t++){const t=n[o]-n[o-1];o++;for(let e=0;e<t;e++){const t=i[l]-i[l-1];l++;const e=[];for(let n=0;n<t;n++){const t=this._vertexBuffer[a++],n=this._vertexBuffer[a++];e.push(new r(t,n));}e.length>0&&e.push(e[0]),h.push(e);}}t[e]=h;}}return t}[Symbol.iterator](){return null}}function tf(t,e,r,n,i,s){return new ef(t,e,r,n,i,s)}class ef extends Qp{_numGeometries;_geometryType;constructor(t,e,r,n,i,s){super(r,n,i,s),this._numGeometries=t,this._geometryType=e;}geometryType(t){return this._geometryType}get numGeometries(){return this._numGeometries}containsSingleGeometryType(){return !0}}function rf(t,e,r,n,i){return new nf(t,e,r,n,i)}class nf extends Qp{_geometryTypes;constructor(t,e,r,n,i){super(e,r,n,i),this._geometryTypes=t;}geometryType(t){return this._geometryTypes[t]}get numGeometries(){return this._geometryTypes.length}containsSingleGeometryType(){return !1}}function sf(t,e,r,n,i){const s=kp(t,r);let a=null,o=null,l=null,u=null,c=null,h=null,p=null,f=null;if(Cp(s,n,t,r)===lp.CONST){const i=Fp(t,r,s,!1);for(let n=0;n<e-1;n++){const e=kp(t,r);switch(e.physicalStreamType){case ip.LENGTH:switch(e.logicalStreamType.lengthType){case op.GEOMETRIES:a=Ip(t,r,e);break;case op.PARTS:o=Ip(t,r,e);break;case op.RINGS:l=Ip(t,r,e);break;case op.TRIANGLES:p=Ip(t,r,e);}break;case ip.OFFSET:switch(e.logicalStreamType.offsetType){case ap.VERTEX:u=Tp(t,r,e,!1);break;case ap.INDEX:f=Tp(t,r,e,!1);}break;case ip.DATA:sp.VERTEX===e.logicalStreamType.dictionaryType?c=Tp(t,r,e,!0):(h={numBits:e.numBits,coordinateShift:e.coordinateShift},c=Tp(t,r,e,!1));}}return null!==f?null!=a||null!=o?tf(n,i,p,f,c,new Rp(a,o,l)):tf(n,i,p,f,c):null===h?function(t,e,r,n,i){return new Wp(t,e,hp.VEC_2,r,n,i)}(n,i,new Rp(a,o,l),u,c):function(t,e,r,n,i,s){return new Wp(t,e,hp.MORTON,r,n,i,s)}(n,i,new Rp(a,o,l),u,c,h)}const d=Tp(t,r,s,!1);for(let n=0;n<e-1;n++){const e=kp(t,r);switch(e.physicalStreamType){case ip.LENGTH:switch(e.logicalStreamType.lengthType){case op.GEOMETRIES:a=Tp(t,r,e,!1);break;case op.PARTS:o=Tp(t,r,e,!1);break;case op.RINGS:l=Tp(t,r,e,!1);break;case op.TRIANGLES:p=Ip(t,r,e);}break;case ip.OFFSET:switch(e.logicalStreamType.offsetType){case ap.VERTEX:u=Tp(t,r,e,!1);break;case ap.INDEX:f=Tp(t,r,e,!1);}break;case ip.DATA:sp.VERTEX===e.logicalStreamType.dictionaryType?c=Tp(t,r,e,!0):(h={numBits:e.numBits,coordinateShift:e.coordinateShift},c=Tp(t,r,e,!1));}}return null!==f&&null===o?rf(d,p,f,c):(null!==a?(a=af(d,a,2),null!==o&&null!==l?(o=of(d,a,o,!1),l=function(t,e,r,n){const i=new Int32Array(r[r.length-1]+1);let s=0;i[0]=s;let a=1,o=1,l=0;for(let u=0;u<t.length;u++){const c=t[u],h=e[u+1]-e[u];if(0!==c&&3!==c)for(let t=0;t<h;t++){const t=r[a]-r[a-1];a++;for(let e=0;e<t;e++)s=i[o++]=s+n[l++];}else for(let t=0;t<h;t++)i[o++]=++s,a++;}return i}(d,a,o,l)):null!==o&&(o=function(t,e,r){const n=new Int32Array(e[e.length-1]+1);let i=0;n[0]=i;let s=1,a=0;for(let o=0;o<t.length;o++){const l=t[o],u=e[o+1]-e[o];if(4===l||1===l)for(let t=0;t<u;t++)i=n[s++]=i+r[a++];else for(let t=0;t<u;t++)n[s++]=++i;}return n}(d,a,o))):null!==o&&null!==l?(o=af(d,o,1),l=of(d,o,l,!0)):null!==o&&(o=af(d,o,0)),null!==f?rf(d,p,f,c,new Rp(a,o,l)):null===h?function(t,e,r,n){return new Jp(hp.VEC_2,t,e,r,n)}(d,new Rp(a,o,l),u,c):function(t,e,r,n,i){return new Jp(hp.MORTON,t,e,r,n,i)}(d,new Rp(a,o,l),u,c,h))}function af(t,e,r){const n=new Int32Array(t.length+1);let i=0;n[0]=i;let s=0;for(let a=0;a<t.length;a++)i=n[a+1]=i+(t[a]>r?e[s++]:1);return n}function of(t,e,r,n){const i=new Int32Array(e[e.length-1]+1);let s=0;i[0]=s;let a=1,o=0;for(let l=0;l<t.length;l++){const u=t[l],c=e[l+1]-e[l];if(5===u||2===u||n&&(4===u||1===u))for(let t=0;t<c;t++)s=i[a++]=s+r[o++];else for(let t=0;t<c;t++)i[a++]=++s;}return i}class lf extends Yh{dataVector;constructor(t,e,r){super(t,e.getBuffer(),r),this.dataVector=e;}getValueFromBuffer(t){return this.dataVector.get(t)}}class uf extends Zh{getValueFromBuffer(t){return this.dataBuffer[t]}}class cf extends Yh{constructor(t,e,r){super(t,BigInt64Array.of(e),r);}getValueFromBuffer(t){return this.dataBuffer[0]}}function hf(t,e,r){return pf(t,Math.ceil(e/8),r)}function pf(t,e,r){const n=new Uint8Array(e);let i=0;for(;i<e;){const e=t[r.increment()];if(e<=127){const s=e+3,a=t[r.increment()],o=i+s;n.fill(a,i,o),i=o;}else {const s=256-e;for(let e=0;e<s;e++)n[i++]=t[r.increment()];}}return n}const ff=new TextDecoder;function df(t,e,r){return r-e>=12?ff.decode(t.subarray(e,r)):function(t,e,r){let n="",i=e;for(;i<r;){const e=t[i];let s,a,o,l=null,u=e>239?4:e>223?3:e>191?2:1;if(i+u>r)break;1===u?e<128&&(l=e):2===u?(s=t[i+1],128==(192&s)&&(l=(31&e)<<6|63&s,l<=127&&(l=null))):3===u?(s=t[i+1],a=t[i+2],128==(192&s)&&128==(192&a)&&(l=(15&e)<<12|(63&s)<<6|63&a,(l<=2047||l>=55296&&l<=57343)&&(l=null))):4===u&&(s=t[i+1],a=t[i+2],o=t[i+3],128==(192&s)&&128==(192&a)&&128==(192&o)&&(l=(15&e)<<18|(63&s)<<12|(63&a)<<6|63&o,(l<=65535||l>=1114112)&&(l=null))),null===l?(l=65533,u=1):l>65535&&(l-=65536,n+=String.fromCharCode(l>>>10&1023|55296),l=56320|1023&l),n+=String.fromCharCode(l),i+=u;}return n}(t,e,r)}class yf extends Yh{offsetBuffer;constructor(t,e,r,n){super(t,r,n),this.offsetBuffer=e;}}class mf extends yf{textEncoder;constructor(t,e,r,n){super(t,e,r,n??e.length-1),this.textEncoder=new TextEncoder;}getValueFromBuffer(t){return df(this.dataBuffer,this.offsetBuffer[t],this.offsetBuffer[t+1])}}class gf extends yf{indexBuffer;textEncoder;constructor(t,e,r,n,i){super(t,r,n,i??e.length),this.indexBuffer=e,this.indexBuffer=e,this.textEncoder=new TextEncoder;}getValueFromBuffer(t){const e=this.indexBuffer[t];return df(this.dataBuffer,this.offsetBuffer[e],this.offsetBuffer[e+1])}}class xf extends yf{indexBuffer;symbolOffsetBuffer;symbolTableBuffer;textEncoder;symbolLengthBuffer;lengthBuffer;decodedDictionary;constructor(t,e,r,n,i,s,a){super(t,r,n,a),this.indexBuffer=e,this.symbolOffsetBuffer=i,this.symbolTableBuffer=s,this.textEncoder=new TextEncoder;}getValueFromBuffer(t){null==this.decodedDictionary&&(null==this.symbolLengthBuffer&&(this.symbolLengthBuffer=this.offsetToLengthBuffer(this.symbolOffsetBuffer),this.lengthBuffer=this.offsetToLengthBuffer(this.offsetBuffer)),this.decodedDictionary=function(t,e,r){const n=[],i=new Array(e.length).fill(0);for(let t=1;t<e.length;t++)i[t]=i[t-1]+e[t-1];for(let s=0;s<r.length;s++)if(255===r[s])n.push(r[++s]);else {const a=e[r[s]],o=i[r[s]];for(let e=0;e<a;e++)n.push(t[o+e]);}return new Uint8Array(n)}(this.symbolTableBuffer,this.symbolLengthBuffer,this.dataBuffer));const e=this.indexBuffer[t];return df(this.decodedDictionary,this.offsetBuffer[e],this.offsetBuffer[e+1])}offsetToLengthBuffer(t){const e=new Uint32Array(t.length-1);let r=t[0];for(let n=1;n<t.length;n++){const i=t[n];e[n-1]=i-r,r=i;}return e}}function vf(t,e,r,n,i,s){return "scalarType"===r.type?function(t,e,r,n,i,s){let a=null,o=0;if(0===t)return null;if(s.nullable){const t=kp(e,r);o=t.numValues;const n=r.get(),i=hf(e,o,r);r.set(n+t.byteLength),a=new Ep(i,t.numValues);}const l=a??n;switch(i.physicalType){case 4:case 3:return function(t,e,r,n,i){const s=kp(t,e),a=Cp(s,i,t,e),o=3===n.physicalType;if(a===lp.FLAT){const n=bf(i)?Vp(t,e,s,o,i):Tp(t,e,s,o);return new Hh(r.name,n,i)}if(a===lp.SEQUENCE){const n=Dp(t,e,s);return new Jh(r.name,n[0],n[1],s.numRleValues)}{const n=Fp(t,e,s,o);return new Qh(r.name,n,i)}}(e,r,s,i,l);case 9:return function(t,e,r,n,i){let s=null,a=null,o=null,l=null,u=null,c=null,h=null,p=null;for(let t=0;t<n;t++){const t=kp(e,r);if(0!==t.byteLength)switch(t.physicalStreamType){case ip.PRESENT:{const n=hf(e,t.numValues,r);c=new Ep(n,t.numValues);break}case ip.OFFSET:a=null!=i||null!=c?Vp(e,r,t,!1,i??c):Tp(e,r,t,!1);break;case ip.LENGTH:{const n=Ip(e,r,t);op.DICTIONARY===t.logicalStreamType.lengthType?s=n:op.SYMBOL===t.logicalStreamType.lengthType?l=n:h=n;break}case ip.DATA:{const n=e.subarray(r.get(),r.get()+t.byteLength);r.add(t.byteLength);const i=t.logicalStreamType.dictionaryType;sp.FSST===i?u=n:sp.SINGLE===i||sp.SHARED===i?o=n:sp.NONE===i&&(p=n);break}}}return function(t,e,r,n,i,s,a){return e?new xf(t,r,n,i,s,e,a):null}(t,u,a,s,o,l,i??c)??function(t,e,r,n,i){return e?i?new gf(t,r,n,e,i):new gf(t,r,n,e):null}(t,o,a,s,i??c)??function(t,e,r,n,i){if(!e||!r)return null;if(n)return i?new gf(t,n,e,r,i):new gf(t,n,e,r);if(i&&i.size()!==e.length-1){const n=new Int32Array(i.size());let s=0;for(let t=0;t<i.size();t++)n[t]=i.get(t)?s++:0;return new gf(t,n,e,r,i)}return i?new mf(t,e,r,i):new mf(t,e,r)}(t,h,p,a,i??c)}(s.name,e,r,s.nullable?t-1:t,a);case 0:return function(t,e,r,n,i){const s=kp(t,e),a=s.numValues,o=e.get(),l=bf(i)?function(t,e,r,n){const i=pf(t,Math.ceil(e/8),r),s=new Ep(i,e),a=n.size(),o=new Ep(new Uint8Array(a),a);let l=0;for(let t=0;t<n.size();t++){const e=!!n.get(t)&&s.get(l++);o.set(t,e);}return o.getBuffer()}(t,a,e,i):hf(t,a,e);e.set(o+s.byteLength);const u=new Ep(l,a);return new lf(r.name,u,i)}(e,r,s,0,l);case 6:case 5:return function(t,e,r,n,i){const s=kp(t,e),a=Cp(s,n,t,e),o=5===i.physicalType;if(a===lp.FLAT){const i=bf(n)?function(t,e,r,n,i){return function(t,e,r,n){switch(e.logicalLevelTechnique1){case rp.DELTA:return e.logicalLevelTechnique2===rp.RLE&&(t=bp(t,e.runs,e.numRleValues)),function(t,e){const r=new BigInt64Array(t.size());let n=0;t.get(0)?(r[0]=t.get(0)?e[0]>>1n^-(1n&e[0]):0n,n=1):r[0]=0n;let i=1;for(;i!=r.length;++i)r[i]=t.get(i)?r[i-1]+(e[n]>>1n^-(1n&e[n++])):r[i-1];return r}(n,t);case rp.RLE:return function(t,e,r,n){const i=e;return r?function(t,e,r){const n=new BigInt64Array(t.size());let i=0;for(let s=0;s<r;s++){const a=Number(e[s]);let o=e[s+r];o=o>>1n^-(1n&o);for(let e=i;e<i+a;e++)t.get(e)?n[e]=o:(n[e]=0n,i++);i+=a;}return n}(n,t,i.runs):function(t,e,r){const n=new BigInt64Array(t.size());let i=0;for(let s=0;s<r;s++){const a=Number(e[s]),o=e[s+r];for(let e=i;e<i+a;e++)t.get(e)?n[e]=o:(n[e]=0n,i++);i+=a;}return n}(n,t,i.runs)}(t,e,r,n);case rp.NONE:return t=r?function(t,e){const r=new BigInt64Array(t.size());let n=0,i=0;for(;i!=r.length;++i)if(t.get(i)){const t=e[n++];r[i]=t>>1n^-(1n&t);}else r[i]=0n;return r}(n,t):function(t,e){const r=new BigInt64Array(t.size());let n=0,i=0;for(;i!=r.length;++i)r[i]=t.get(i)?e[n++]:0n;return r}(n,t),t;default:throw new Error("The specified Logical level technique is not supported")}}(fp(t,e,r.numValues),r,n,i)}(t,e,s,o,n):Pp(t,e,s,o);return new Lp(r.name,i,n)}if(a===lp.SEQUENCE){const n=zp(t,e,s);return new Op(r.name,n[0],n[1],s.numRleValues)}{const i=Bp(t,e,s,o);return new cf(r.name,i,n)}}(e,r,s,l,i);case 7:return function(t,e,r,n){const i=kp(t,e),s=bf(n)?function(t,e,r,n){const i=e.get(),s=i+n*Float32Array.BYTES_PER_ELEMENT,a=new Uint8Array(t.subarray(i,s)).buffer,o=new Float32Array(a);e.set(s);const l=r.size(),u=new Float32Array(l);let c=0;for(let t=0;t<l;t++)u[t]=r.get(t)?o[c++]:0;return u}(t,e,n,i.numValues):function(t,e,r){const n=e.get(),i=n+r*Float32Array.BYTES_PER_ELEMENT,s=new Uint8Array(t.subarray(n,i)).buffer,a=new Float32Array(s);return e.set(i),a}(t,e,i.numValues);return new uf(r.name,s,n)}(e,r,s,l);case 8:return function(t,e,r,n){const i=kp(t,e),s=bf(n)?function(t,e,r,n){const i=e.get(),s=i+n*Float64Array.BYTES_PER_ELEMENT,a=new Uint8Array(t.subarray(i,s)).buffer,o=new Float64Array(a);e.set(s);const l=r.size(),u=new Float64Array(l);let c=0;for(let t=0;t<l;t++)u[t]=r.get(t)?o[c++]:0;return u}(t,e,n,i.numValues):function(t,e,r){const n=e.get(),i=n+r*Float64Array.BYTES_PER_ELEMENT,s=new Uint8Array(t.subarray(n,i)).buffer,a=new Float64Array(s);return e.set(i),a}(t,e,i.numValues);return new Kh(r.name,s,n)}(e,r,s,l);default:throw new Error(`The specified data type for the field is currently not supported: ${i}`)}}(n,t,e,i,r.scalarType,r):1!=n?null:function(t,e,r,n){let i=null,s=null,a=null,o=null,l=!1;for(;!l;){const r=kp(t,e);switch(r.physicalStreamType){case ip.LENGTH:op.DICTIONARY===r.logicalStreamType.lengthType?i=Ip(t,e,r):a=Ip(t,e,r);break;case ip.DATA:sp.SINGLE===r.logicalStreamType.dictionaryType||sp.SHARED===r.logicalStreamType.dictionaryType?(s=t.subarray(e.get(),e.get()+r.byteLength),l=!0):o=t.subarray(e.get(),e.get()+r.byteLength),e.add(r.byteLength);}}const u=r.complexType.children,c=[];let h=0;for(const l of u){const u=pp(t,e,1)[0];if(0==u)continue;const p=`${r.name}${"default"===l.name?"":":"+l.name}`;if(2!==u||"scalarField"!==l.type||9!==l.scalarField.physicalType)throw new Error("Currently only optional string fields are implemented for a struct.");const f=kp(t,e),d=hf(t,f.numValues,e),y=kp(t,e),m=y.decompressedCount!==n?Vp(t,e,y,!1,new Ep(d,f.numValues)):Tp(t,e,y,!1);c[h++]=o?new xf(p,m,i,s,a,o,new Ep(d,f.numValues)):new gf(p,m,i,s,new Ep(d,f.numValues));}return c}(t,e,r,i)}function bf(t){return t instanceof Ep}function wf(t){if("id"===t.name)return !1;if("scalarType"===t.type){const e=t.scalarType;if("physicalType"===e.type)switch(e.physicalType){case 0:case 1:case 2:case 3:case 4:case 5:case 6:case 7:case 8:default:return !1;case 9:return !0}else if("logicalType"===e.type)return !1}else if("complexType"===t.type){const e=t.complexType;if("physicalType"===e.type)switch(e.physicalType){case 0:case 1:return !0;default:return !1}}return console.warn("Unexpected column type in hasStreamCount",t),!1}const _f=new TextDecoder;function Sf(t,e){const r=pp(t,e,1)[0];if(0===r)return "";const n=e.get(),i=t.subarray(n,n+r);return e.add(r),_f.decode(i)}function Af(t,e){const r=pp(t,e,1)[0]>>>0,n=!!(4&r),i=!!(2&r),s=pp(t,e,1)[0]>>>0,a={};if(1&r&&(a.nullable=!0),i){const i={};if(n?(i.type="logicalType",i.logicalType=s):(i.type="physicalType",i.physicalType=s),8&r){const r=pp(t,e,1)[0]>>>0;i.children=new Array(r);for(let n=0;n<r;n++)i.children[n]=Af(t,e);}a.type="complexField",a.complexField=i;}else {const t={};n?(t.type="logicalType",t.logicalType=s):(t.type="physicalType",t.physicalType=s),a.type="scalarField",a.scalarField=t;}return a}function kf(t,e){const r=pp(t,e,1)[0]>>>0,n=function(t){switch(t){case 0:case 1:case 2:case 3:{const e={};e.nullable=!!(1&t),e.columnScope=0;const r={};return r.physicalType=t>1?6:4,r.type="physicalType",e.scalarType=r,e.type="scalarType",e}case 4:{const t={nullable:!1,columnScope:0},e={type:"physicalType",physicalType:0};return t.type="complexType",t.complexType=e,t}case 30:{const t={nullable:!1,columnScope:0},e={type:"physicalType",physicalType:1};return t.type="complexType",t.complexType=e,t}default:return function(t){let e=null;switch(t){case 10:case 11:e=0;break;case 12:case 13:e=1;break;case 14:case 15:e=2;break;case 16:case 17:e=3;break;case 18:case 19:e=4;break;case 20:case 21:e=5;break;case 22:case 23:e=6;break;case 24:case 25:e=7;break;case 26:case 27:e=8;break;case 28:case 29:e=9;break;default:return null}const r={};r.nullable=!!(1&t),r.columnScope=0;const n={type:"physicalType"};return n.physicalType=e,r.type="scalarType",r.scalarType=n,r}(t)}}(r);if(!n)throw new Error(`Unsupported column type code: ${r}`);if(function(t){return t>=10}(r)?n.name=Sf(t,e):r>=0&&r<=3?n.name="id":4===r&&(n.name="geometry"),function(t){return 30===t}(r)){const r=pp(t,e,1)[0]>>>0,i=n.complexType;i.children=new Array(r);for(let n=0;n<r;n++)i.children[n]=Af(t,e);}return n}function Ef(t,e){const r={featureTables:[]},n={};n.name=Sf(t,e);const i=pp(t,e,1)[0]>>>0,s=pp(t,e,1)[0]>>>0;n.columns=new Array(s);for(let r=0;r<s;r++)n.columns[r]=kf(t,e);return r.featureTables.push(n),[r,i]}function Tf(t,e,r,n,i,s,a=!1){const o=e.scalarType.physicalType,l=Cp(i,s,t,r);if(4===o)switch(l){case lp.FLAT:{const e=Tp(t,r,i,!1);return new Hh(n,e,s)}case lp.SEQUENCE:{const e=Dp(t,r,i);return new Jh(n,e[0],e[1],i.numRleValues)}case lp.CONST:{const e=Fp(t,r,i,!1);return new Qh(n,e,s)}}else switch(l){case lp.FLAT:{if(a){const e=function(t,e,r,n){const i=function(t,e,r){const n=new Float64Array(e);for(let i=0;i<e;i++)n[i]=dp(t,r);return n}(t,r.numValues,e);return function(t,e,r){switch(e.logicalLevelTechnique1){case rp.DELTA:return e.logicalLevelTechnique2===rp.RLE&&(t=wp(t,e.runs,e.numRleValues)),function(t){t[0]=t[0]%2==1?(t[0]+1)/-2:t[0]/2;const e=t.length/4*4;let r=1;if(e>=4)for(;r<e-4;r+=4){const e=t[r],n=t[r+1],i=t[r+2],s=t[r+3];t[r]=(e%2==1?(e+1)/-2:e/2)+t[r-1],t[r+1]=(n%2==1?(n+1)/-2:n/2)+t[r],t[r+2]=(i%2==1?(i+1)/-2:i/2)+t[r+1],t[r+3]=(s%2==1?(s+1)/-2:s/2)+t[r+2];}for(;r!=t.length;++r)t[r]=(t[r]%2==1?(t[r]+1)/-2:t[r]/2)+t[r-1];}(t),t;case rp.RLE:return function(t,e,r){return r?function(t,e,r){const n=new Float64Array(r);let i=0;for(let r=0;r<e;r++){const s=t[r];let a=t[r+e];a=a%2==1?(a+1)/-2:a/2,n.fill(a,i,i+s),i+=s;}return n}(t,e.runs,e.numRleValues):wp(t,e.runs,e.numRleValues)}(t,e,r);case rp.NONE:return t;default:throw new Error(`The specified Logical level technique is not supported: ${e.logicalLevelTechnique1}`)}}(i,r,n)}(t,r,i,!1);return new Kh(n,e,s)}const e=Pp(t,r,i,!1);return new Lp(n,e,s)}case lp.SEQUENCE:{const e=zp(t,r,i);return new Op(n,e[0],e[1],i.numRleValues)}case lp.CONST:{const e=Bp(t,r,i,!1);return new cf(n,e,s)}}throw new Error("Vector type not supported for id column.")}class If{constructor(t,e){var r;switch(this._featureData=t,this.properties=this._featureData.properties||{},null===(r=this._featureData.geometry)||void 0===r?void 0:r.type){case up.POINT:case up.MULTIPOINT:this.type=1;break;case up.LINESTRING:case up.MULTILINESTRING:this.type=2;break;case up.POLYGON:case up.MULTIPOLYGON:this.type=3;break;default:this.type=0;}this.extent=e,this.id=Number(this._featureData.id);}loadGeometry(){const t=[];for(const e of this._featureData.geometry.coordinates){const n=[];for(const t of e)n.push(new r(t.x,t.y));t.push(n);}return t}}class Mf{constructor(t){this.features=[],this.featureTable=t,this.name=t.name,this.extent=t.extent,this.version=2,this.features=t.getFeatures(),this.length=this.features.length;}feature(t){return new If(this.features[t],this.extent)}}class Ff{constructor(t){this.layers={};const e=function(t,e,r=!0){const n=new ep(0),i=[];for(;n.get()<t.length;){const e=pp(t,n,1)[0]>>>0,s=n.get()+e;if(s>t.length)throw new Error(`Block overruns tile: ${s} > ${t.length}`);if(1!=pp(t,n,1)[0]>>>0){n.set(s);continue}const a=Ef(t,n),o=a[1],l=a[0].featureTables[0];let u=null,c=null;const h=[];let p=0;for(const e of l.columns){const i=e.name;if("id"===i){let s=null;if(e.nullable){const e=kp(t,n),r=n.get(),i=hf(t,e.numValues,n);n.set(r+e.byteLength),s=new Ep(i,e.numValues);}const a=kp(t,n);p=a.decompressedCount,u=Tf(t,e,n,i,a,s??p,r);}else if("geometry"===i){const e=pp(t,n,1)[0];if(0===p){const e=n.get();p=kp(t,n).decompressedCount,n.set(e);}c=sf(t,e,n,p);}else {const r=wf(e)?pp(t,n,1)[0]:1;if(0===r&&"scalarType"===e.type)continue;const i=vf(t,n,e,r,p);if(i)if(Array.isArray(i))for(const t of i)h.push(t);else h.push(i);}}const f=new tp(l.name,c,u,h,o);i.push(f),n.set(s);}return i}(new Uint8Array(t));this.layers=e.reduce(((t,e)=>Object.assign(Object.assign({},t),{[e.name]:new Mf(e)})),{});}}class Df{constructor(t,e){this.feature=t,this.type=t.type,this.properties=t.tags?t.tags:{},this.extent=e,"id"in t&&("string"==typeof t.id?this.id=parseInt(t.id,10):"number"!=typeof t.id||isNaN(t.id)||(this.id=t.id));}loadGeometry(){const t=[],e=1===this.feature.type?[this.feature.geometry]:this.feature.geometry;for(const n of e){const e=[];for(const t of n)e.push(new r(t[0],t[1]));t.push(e);}return t}}const zf="_geojsonTileLayer";function Pf(t,e){e.writeVarintField(15,t.version||1),e.writeStringField(1,t.name||""),e.writeVarintField(5,t.extent||4096);const r={keys:[],values:[],keycache:{},valuecache:{}};for(let n=0;n<t.length;n++)r.feature=t.feature(n),e.writeMessage(2,Bf,r);const n=r.keys;for(const t of n)e.writeStringField(3,t);const i=r.values;for(const t of i)e.writeMessage(4,Rf,t);}function Bf(t,e){if(!t.feature)return;const r=t.feature;void 0!==r.id&&e.writeVarintField(1,r.id),e.writeMessage(2,Vf,t),e.writeVarintField(3,r.type),e.writeMessage(4,Of,r);}function Vf(t,e){for(const r in t.feature?.properties){let n=t.feature.properties[r],i=t.keycache[r];if(null==n)continue;void 0===i&&(t.keys.push(r),i=t.keys.length-1,t.keycache[r]=i),e.writeVarint(i),"string"!=typeof n&&"boolean"!=typeof n&&"number"!=typeof n&&(n=JSON.stringify(n));const s=typeof n+":"+n;let a=t.valuecache[s];void 0===a&&(t.values.push(n),a=t.values.length-1,t.valuecache[s]=a),e.writeVarint(a);}}function Cf(t,e){return (e<<3)+(7&t)}function Lf(t){return t<<1^t>>31}function Of(t,e){const r=t.loadGeometry(),n=t.type;let i=0,s=0;for(const a of r){let r=1;1===n&&(r=a.length),e.writeVarint(Cf(1,r));const o=3===n?a.length-1:a.length;for(let t=0;t<o;t++){1===t&&1!==n&&e.writeVarint(Cf(2,o-1));const r=a[t].x-i,l=a[t].y-s;e.writeVarint(Lf(r)),e.writeVarint(Lf(l)),i+=r,s+=l;}3===t.type&&e.writeVarint(Cf(7,1));}}function Rf(t,e){const r=typeof t;"string"===r?e.writeStringField(1,t):"boolean"===r?e.writeBooleanField(7,t):"number"===r&&(t%1!=0?e.writeDoubleField(3,t):t<0?e.writeSVarintField(6,t):e.writeVarintField(5,t));}class Nf{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new cs(M,16,0),this.grid3D=new cs(M,16,0),this.featureIndexArray=new Na,this.promoteId=e;}insert(t,e,r,n,i,s){const a=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i);const o=s?this.grid3D:this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y);}n[0]<M&&n[1]<M&&n[2]>=0&&n[3]>=0&&o.insert(a,n[0],n[1],n[2],n[3]);}}loadVTLayers(){return this.vtLayers||(this.vtLayers="mlt"!==this.encoding?new Vu(new Tc(this.rawTileData)).layers:new Ff(this.rawTileData).layers,this.sourceLayerCoder=new Gh(this.vtLayers?Object.keys(this.vtLayers).sort():[zf])),this.vtLayers}query(t,e,n,i){this.loadVTLayers();const s=t.params,a=M/t.tileSize/t.scale,o=fi(s.filter,s.globalState),l=t.queryGeometry,u=t.queryPadding*a,c=jh.fromPoints(l),h=this.grid.query(c.minX-u,c.minY-u,c.maxX+u,c.maxY+u),p=jh.fromPoints(t.cameraQueryGeometry).expandBy(u),f=this.grid3D.query(p.minX,p.minY,p.maxX,p.maxY,((e,n,i,s)=>function(t,e,n,i,s){for(const r of t)if(e<=r.x&&n<=r.y&&i>=r.x&&s>=r.y)return !0;const a=[new r(e,n),new r(e,s),new r(i,s),new r(i,n)];if(t.length>2)for(const e of a)if(tl(t,e))return !0;for(let e=0;e<t.length-1;e++)if(el(t[e],t[e+1],a))return !0;return !1}(t.cameraQueryGeometry,e-u,n-u,i+u,s+u)));for(const t of f)h.push(t);h.sort(Uf);const d={};let y;for(let r=0;r<h.length;r++){const u=h[r];if(u===y)continue;y=u;const c=this.featureIndexArray.get(u);let p=null;this.loadMatchingFeature(d,c.bucketIndex,c.sourceLayerIndex,c.featureIndex,o,s.layers,s.availableImages,e,n,i,((e,r,n)=>(p||(p=No(e)),r.queryIntersectsFeature({queryGeometry:l,feature:e,featureState:n,geometry:p,zoom:this.z,transform:t.transform,pixelsToTileUnits:a,pixelPosMatrix:t.pixelPosMatrix,unwrappedTileID:this.tileID.toUnwrapped(),getElevation:t.getElevation}))));}return d}loadMatchingFeature(t,e,r,n,i,s,a,o,l,u,c){const h=this.bucketLayerIDs[e];if(s&&!h.some((t=>s.has(t))))return;const p=this.sourceLayerCoder.decode(r),f=this.vtLayers[p].feature(n);if(i.needGeometry){const t=$o(f,!0);if(!i.filter(new Ps(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!i.filter(new Ps(this.tileID.overscaledZ),f))return;const d=this.getId(f,p);for(let e=0;e<h.length;e++){const r=h[e];if(s&&!s.has(r))continue;const i=o[r];if(!i)continue;let p={};d&&u&&(p=u.getState(i.sourceLayer||zf,d));const y=O({},l[r]);y.paint=$f(y.paint,i.paint,f,p,a),y.layout=$f(y.layout,i.layout,f,p,a);const m=!c||c(f,i,p);if(!m)continue;const g=new Xh(f,this.z,this.x,this.y,d);g.layer=y;let x=t[r];void 0===x&&(x=t[r]=[]),x.push({featureIndex:n,feature:g,intersectionZ:m});}}lookupSymbolFeatures(t,e,r,n,i,s,a,o){const l={};this.loadVTLayers();const u=fi(i.filterSpec,i.globalState);for(const i of t)this.loadMatchingFeature(l,r,n,i,u,s,a,o,e);return l}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return !0;return !1}getId(t,e){var r;let n=t.id;return this.promoteId&&(n=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof n&&(n=Number(n)),void 0===n&&(null===(r=t.properties)||void 0===r?void 0:r.cluster)&&this.promoteId&&(n=Number(t.properties.cluster_id))),n}}function $f(t,e,r,n,i){return N(t,((t,s)=>{const a=e instanceof qs?e.get(s):null;return a&&a.evaluate?a.evaluate(r,n,i):a}))}function Uf(t,e){return e-t}function qf(t,e,n,i,s){const a=[];for(let o=0;o<t.length;o++){const l=t[o];let u;for(let t=0;t<l.length-1;t++){let o=l[t],c=l[t+1];o.x<e&&c.x<e||(o.x<e?o=new r(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x<e&&(c=new r(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y<n&&c.y<n||(o.y<n?o=new r(o.x+(n-o.y)/(c.y-o.y)*(c.x-o.x),n)._round():c.y<n&&(c=new r(o.x+(n-o.y)/(c.y-o.y)*(c.x-o.x),n)._round()),o.x>=i&&c.x>=i||(o.x>=i?o=new r(i,o.y+(i-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x>=i&&(c=new r(i,o.y+(i-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y>=s&&c.y>=s||(o.y>=s?o=new r(o.x+(s-o.y)/(c.y-o.y)*(c.x-o.x),s)._round():c.y>=s&&(c=new r(o.x+(s-o.y)/(c.y-o.y)*(c.x-o.x),s)._round()),u&&o.equals(u[u.length-1])||(u=[o],a.push(u)),u.push(c)))));}}return a}function jf(t,e,r,n,i){switch(e){case 1:return function(t,e,r,n){const i=[];for(const s of t)for(const t of s){const s=0===n?t.x:t.y;s>=e&&s<=r&&i.push([t]);}return i}(t,r,n,i);case 2:return Xf(t,r,n,i,!1);case 3:return Xf(t,r,n,i,!0)}return []}function Gf(t,e,n,i,s){const a=0===i?Yf:Zf;let o=[];const l=[];for(let r=0;r<t.length-1;r++){const u=t[r],c=t[r+1],h=0===i?u.x:u.y,p=0===i?c.x:c.y;let f=!1;h<e?p>e&&o.push(a(u,c,e)):h>n?p<n&&o.push(a(u,c,n)):o.push(u),p<e&&h>=e&&(o.push(a(u,c,e)),f=!0),p>n&&h<=n&&(o.push(a(u,c,n)),f=!0),!s&&f&&(l.push(o),o=[]);}const u=t.length-1,c=0===i?t[u].x:t[u].y;return c>=e&&c<=n&&o.push(t[u]),s&&o.length>0&&!o[0].equals(o[o.length-1])&&o.push(new r(o[0].x,o[0].y)),o.length>0&&l.push(o),l}function Xf(t,e,r,n,i){const s=[];for(const a of t){const t=Gf(a,e,r,n,i);t.length>0&&s.push(...t);}return s}function Yf(t,e,n){return new r(n,t.y+(n-t.x)/(e.x-t.x)*(e.y-t.y))}function Zf(t,e,n){return new r(t.x+(n-t.y)/(e.y-t.y)*(e.x-t.x),n)}ps("FeatureIndex",Nf,{omit:["rawTileData","sourceLayerCoder"]});class Hf extends r{constructor(t,e,r,n){super(t,e),this.angle=r,void 0!==n&&(this.segment=n);}clone(){return new Hf(this.x,this.y,this.angle,this.segment)}}function Kf(t,e,r,n,i){if(void 0===e.segment||0===r)return !0;let s=e,a=e.segment+1,o=0;for(;o>-r/2;){if(a--,a<0)return !1;o-=t[a].dist(s),s=t[a];}o+=t[a].dist(t[a+1]),a++;const l=[];let u=0;for(;o<r/2;){const e=t[a],r=t[a+1];if(!r)return !1;let s=t[a-1].angleTo(e)-e.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:o,angleDelta:s}),u+=s;o-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return !1;a++,o+=e.dist(r);}return !0}function Wf(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function Jf(t,e,r){return t?.6*e*r:0}function Qf(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function td(t,e,r,n,i,s){const a=Jf(r,i,s),o=Qf(r,n)*s;let l=0;const u=Wf(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],s=n.dist(i);if(l+s>u){const c=(u-l)/s,h=yr.number(n.x,i.x,c),p=yr.number(n.y,i.y,c),f=new Hf(h,p,i.angleTo(n),r);return f._round(),!a||Kf(t,f,o,a,e)?f:void 0}l+=s;}}function ed(t,e,r,n,i,s,a,o,l){const u=Jf(n,s,a),c=Qf(n,i),h=c*a,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),rd(t,p?e/2*o%e:(c/2+2*s)*a*o%e,e,u,r,h,p,!1,l)}function rd(t,e,r,n,i,s,a,o,l){const u=s/2,c=Wf(t);let h=0,p=e-r,f=[];for(let e=0;e<t.length-1;e++){const a=t[e],o=t[e+1],d=a.dist(o),y=o.angleTo(a);for(;p+r<h+d;){p+=r;const m=(p-h)/d,g=yr.number(a.x,o.x,m),x=yr.number(a.y,o.y,m);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new Hf(g,x,y,e);r._round(),n&&!Kf(t,r,s,n,i)||f.push(r);}}h+=d;}return o||f.length||a||(f=rd(t,h/2,r,n,i,s,a,!0,l)),f}function nd(t,e,n,i){const s=[],a=t.image,o=a.pixelRatio,l=a.paddedRect.w-2,u=a.paddedRect.h-2;let c={x1:t.left,y1:t.top,x2:t.right,y2:t.bottom};const h=a.stretchX||[[0,l]],p=a.stretchY||[[0,u]],f=(t,e)=>t+e[1]-e[0],d=h.reduce(f,0),y=p.reduce(f,0),m=l-d,g=u-y;let x=0,v=d,b=0,w=y,_=0,S=m,A=0,k=g;if(a.content&&i){const e=a.content,r=e[2]-e[0],n=e[3]-e[1];(a.textFitWidth||a.textFitHeight)&&(c=eh(t)),x=id(h,0,e[0]),b=id(p,0,e[1]),v=id(h,e[0],e[2]),w=id(p,e[1],e[3]),_=e[0]-x,A=e[1]-b,S=r-v,k=n-w;}const E=c.x1,T=c.y1,I=c.x2-E,M=c.y2-T,F=(t,i,s,l)=>{const u=ad(t.stretch-x,v,I,E),c=od(t.fixed-_,S,t.stretch,d),h=ad(i.stretch-b,w,M,T),p=od(i.fixed-A,k,i.stretch,y),f=ad(s.stretch-x,v,I,E),m=od(s.fixed-_,S,s.stretch,d),g=ad(l.stretch-b,w,M,T),F=od(l.fixed-A,k,l.stretch,y),D=new r(u,h),z=new r(f,h),P=new r(f,g),B=new r(u,g),V=new r(c/o,p/o),C=new r(m/o,F/o),L=e*Math.PI/180;if(L){const t=Math.sin(L),e=Math.cos(L),r=[e,-t,t,e];D._matMult(r),z._matMult(r),B._matMult(r),P._matMult(r);}const O=t.stretch+t.fixed,R=i.stretch+i.fixed;return {tl:D,tr:z,bl:B,br:P,tex:{x:a.paddedRect.x+1+O,y:a.paddedRect.y+1+R,w:s.stretch+s.fixed-O,h:l.stretch+l.fixed-R},writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:V,pixelOffsetBR:C,minFontScaleX:S/o/I,minFontScaleY:k/o/M,isSDF:n}};if(i&&(a.stretchX||a.stretchY)){const t=sd(h,m,d),e=sd(p,g,y);for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)s.push(F(n,e[t],i,e[t+1]));}}else s.push(F({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:l+1},{fixed:0,stretch:u+1}));return s}function id(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n}function sd(t,e,r){const n=[{fixed:-1,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return n.push({fixed:e+1,stretch:r}),n}function ad(t,e,r,n){return t/e*r+n}function od(t,e,r,n){return t-e*r/n}ps("Anchor",Hf);class ld{constructor(t,e,n,i,s,a,o,l,u,c){var h;if(this.boxStartIndex=t.length,u){let t=a.top,e=a.bottom;const r=a.collisionPadding;r&&(t-=r[1],e+=r[3]);let n=e-t;n>0&&(n=Math.max(10,n),this.circleDiameter=n);}else {const u=(null===(h=a.image)||void 0===h?void 0:h.content)&&(a.image.textFitWidth||a.image.textFitHeight)?eh(a):{x1:a.left,y1:a.top,x2:a.right,y2:a.bottom};u.y1=u.y1*o-l[0],u.y2=u.y2*o+l[2],u.x1=u.x1*o-l[3],u.x2=u.x2*o+l[1];const p=a.collisionPadding;if(p&&(u.x1-=p[0]*o,u.y1-=p[1]*o,u.x2+=p[2]*o,u.y2+=p[3]*o),c){const t=new r(u.x1,u.y1),e=new r(u.x2,u.y1),n=new r(u.x1,u.y2),i=new r(u.x2,u.y2),s=c*Math.PI/180;t._rotate(s),e._rotate(s),n._rotate(s),i._rotate(s),u.x1=Math.min(t.x,e.x,n.x,i.x),u.x2=Math.max(t.x,e.x,n.x,i.x),u.y1=Math.min(t.y,e.y,n.y,i.y),u.y2=Math.max(t.y,e.y,n.y,i.y);}t.emplaceBack(e.x,e.y,u.x1,u.y1,u.x2,u.y2,n,i,s);}this.boxEndIndex=t.length;}}class ud{constructor(t=[],e=(t,e)=>t<e?-1:t>e?1:0){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this._up(this.length++);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return --this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n;}e[t]=i;}}function cd(t,e=1,n=!1){const i=jh.fromPoints(t[0]),s=Math.min(i.width(),i.height());let a=s/2;const o=new ud([],hd),{minX:l,minY:u,maxX:c,maxY:h}=i;if(0===s)return new r(l,u);for(let e=l;e<c;e+=s)for(let r=u;r<h;r+=s)o.push(new pd(e+a,r+a,a,t));let p=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,s=i.length,a=s-1;t<s;a=t++){const s=i[t],o=i[a],l=s.x*o.y-o.x*s.y;r+=(s.x+o.x)*l,n+=(s.y+o.y)*l,e+=3*l;}return new pd(r/e,n/e,0,t)}(t),f=o.length;for(;o.length;){const r=o.pop();(r.d>p.d||!p.d)&&(p=r,n&&console.log("found best %d after %d probes",Math.round(1e4*r.d)/1e4,f)),r.max-p.d<=e||(a=r.h/2,o.push(new pd(r.p.x-a,r.p.y-a,a,t)),o.push(new pd(r.p.x+a,r.p.y-a,a,t)),o.push(new pd(r.p.x-a,r.p.y+a,a,t)),o.push(new pd(r.p.x+a,r.p.y+a,a,t)),f+=4);}return n&&(console.log(`num probes: ${f}`),console.log(`best distance: ${p.d}`)),p.p}function hd(t,e){return e.max-t.max}function pd(t,e,n,i){this.p=new r(t,e),this.h=n,this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const s=e[i];for(let e=0,i=s.length,a=i-1;e<i;a=e++){const i=s[e],o=s[a];i.y>t.y!=o.y>t.y&&t.x<(o.x-i.x)*(t.y-i.y)/(o.y-i.y)+i.x&&(r=!r),n=Math.min(n,Jo(t,i,o));}}return (r?1:-1)*Math.sqrt(n)}(this.p,i),this.max=this.d+this.h*Math.SQRT2;}var fd;t.aP=void 0,(fd=t.aP||(t.aP={}))[fd.center=1]="center",fd[fd.left=2]="left",fd[fd.right=3]="right",fd[fd.top=4]="top",fd[fd.bottom=5]="bottom",fd[fd["top-left"]=6]="top-left",fd[fd["top-right"]=7]="top-right",fd[fd["bottom-left"]=8]="bottom-left",fd[fd["bottom-right"]=9]="bottom-right";const dd=Number.POSITIVE_INFINITY;function yd(t,e){return e[1]!==dd?function(t,e,r){let n=0,i=0;switch(e=Math.abs(e),r=Math.abs(r),t){case "top-right":case "top-left":case "top":i=r-7;break;case "bottom-right":case "bottom-left":case "bottom":i=7-r;}switch(t){case "top-right":case "bottom-right":case "right":n=-e;break;case "top-left":case "bottom-left":case "left":n=e;}return [n,i]}(t,e[0],e[1]):function(t,e){let r=0,n=0;e<0&&(e=0);const i=e/Math.SQRT2;switch(t){case "top-right":case "top-left":n=i-7;break;case "bottom-right":case "bottom-left":n=7-i;break;case "bottom":n=7-e;break;case "top":n=e-7;}switch(t){case "top-right":case "bottom-right":r=-i;break;case "top-left":case "bottom-left":r=i;break;case "left":r=e;break;case "right":r=-e;}return [r,n]}(t,e[0])}function md(t,e,r){var n;const i=t.layout,s=null===(n=i.get("text-variable-anchor-offset"))||void 0===n?void 0:n.evaluate(e,{},r);if(s){const t=s.values,e=[];for(let r=0;r<t.length;r+=2){const n=e[r]=t[r],i=t[r+1].map((t=>t*dc));n.startsWith("top")?i[1]-=7:n.startsWith("bottom")&&(i[1]+=7),e[r+1]=i;}return new Le(e)}const a=i.get("text-variable-anchor");if(a){let n;n=void 0!==t._unevaluatedLayout.getValue("text-radial-offset")?[i.get("text-radial-offset").evaluate(e,{},r)*dc,dd]:i.get("text-offset").evaluate(e,{},r).map((t=>t*dc));const s=[];for(const t of a)s.push(t,yd(t,n));return new Le(s)}return null}function gd(t){switch(t){case "right":case "top-right":case "bottom-right":return "right";case "left":case "top-left":case "bottom-left":return "left"}return "center"}function xd(e,r,n,i,s,a,o,l,u,c,h,p){let f=a.textMaxSize.evaluate(r,{});void 0===f&&(f=o);const d=e.layers[0].layout,y=d.get("icon-offset").evaluate(r,{},h),m=bd(n.horizontal),g=o/24,x=e.tilePixelRatio*g,v=e.tilePixelRatio*f/24,b=e.tilePixelRatio*l,w=e.tilePixelRatio*d.get("symbol-spacing"),_=d.get("text-padding")*e.tilePixelRatio,S=function(t,e,r,n=1){const i=t.get("icon-padding").evaluate(e,{},r),s=i&&i.values;return [s[0]*n,s[1]*n,s[2]*n,s[3]*n]}(d,r,h,e.tilePixelRatio),A=d.get("text-max-angle")/180*Math.PI,k="viewport"!==d.get("text-rotation-alignment")&&"point"!==d.get("symbol-placement"),E="map"===d.get("icon-rotation-alignment")&&"point"!==d.get("symbol-placement"),T=d.get("symbol-placement"),I=w/2,F=d.get("icon-text-fit");let D;i&&"none"!==F&&(e.allowVerticalPlacement&&n.vertical&&(D=rh(i,n.vertical,F,d.get("icon-text-fit-padding"),y,g)),m&&(i=rh(i,m,F,d.get("icon-text-fit-padding"),y,g)));const z=h?p.line.getGranularityForZoomLevel(h.z):1,P=(l,p)=>{p.x<0||p.x>=M||p.y<0||p.y>=M||function(e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,k){const E=e.addToLineVertexArray(r,n);let T,I,M,F,D=0,z=0,P=0,B=0,V=-1,C=-1;const L={};let O=mo("");if(e.allowVerticalPlacement&&i.vertical){const t=l.layout.get("text-rotate").evaluate(w,{},A)+90;M=new ld(u,r,c,h,p,i.vertical,f,d,y,t),o&&(F=new ld(u,r,c,h,p,o,g,x,y,t));}if(s){const n=l.layout.get("icon-rotate").evaluate(w,{}),i="none"!==l.layout.get("icon-text-fit"),a=nd(s,n,S,i),f=o?nd(o,n,S,i):void 0;I=new ld(u,r,c,h,p,s,g,x,!1,n),D=4*a.length;const d=e.iconSizeData;let y=null;"source"===d.kind?(y=[nh*l.layout.get("icon-size").evaluate(w,{})],y[0]>ih&&j(`${e.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)):"composite"===d.kind&&(y=[nh*_.compositeIconSizes[0].evaluate(w,{},A),nh*_.compositeIconSizes[1].evaluate(w,{},A)],(y[0]>ih||y[1]>ih)&&j(`${e.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)),e.addSymbols(e.icon,a,y,b,v,w,t.az.none,r,E.lineStartIndex,E.lineLength,-1,A),V=e.icon.placedSymbolArray.length-1,f&&(z=4*f.length,e.addSymbols(e.icon,f,y,b,v,w,t.az.vertical,r,E.lineStartIndex,E.lineLength,-1,A),C=e.icon.placedSymbolArray.length-1);}const R=Object.keys(i.horizontal);for(const n of R){const s=i.horizontal[n];if(!T){O=mo(s.text);const t=l.layout.get("text-rotate").evaluate(w,{},A);T=new ld(u,r,c,h,p,s,f,d,y,t);}const o=1===s.positionedLines.length;if(P+=vd(e,r,s,a,l,y,w,m,E,i.vertical?t.az.horizontal:t.az.horizontalOnly,o?R:[n],L,V,_,A),o)break}i.vertical&&(B+=vd(e,r,i.vertical,a,l,y,w,m,E,t.az.vertical,["vertical"],L,C,_,A));const N=T?T.boxStartIndex:e.collisionBoxArray.length,$=T?T.boxEndIndex:e.collisionBoxArray.length,U=M?M.boxStartIndex:e.collisionBoxArray.length,q=M?M.boxEndIndex:e.collisionBoxArray.length,G=I?I.boxStartIndex:e.collisionBoxArray.length,X=I?I.boxEndIndex:e.collisionBoxArray.length,Y=F?F.boxStartIndex:e.collisionBoxArray.length,Z=F?F.boxEndIndex:e.collisionBoxArray.length;let H=-1;const K=(t,e)=>t&&t.circleDiameter?Math.max(t.circleDiameter,e):e;H=K(T,H),H=K(M,H),H=K(I,H),H=K(F,H);const W=H>-1?1:0;W&&(H*=k/dc),e.glyphOffsetArray.length>=fh.MAX_GLYPHS&&j("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==w.sortKey&&e.addToSortKeyRanges(e.symbolInstances.length,w.sortKey);const J=md(l,w,A),[Q,tt]=function(e,r){const n=e.length,i=null==r?void 0:r.values;if((null==i?void 0:i.length)>0)for(let r=0;r<i.length;r+=2){const n=i[r+1];e.emplaceBack(t.aP[i[r]],n[0],n[1]);}return [n,e.length]}(e.textAnchorOffsets,J);e.symbolInstances.emplaceBack(r.x,r.y,L.right>=0?L.right:-1,L.center>=0?L.center:-1,L.left>=0?L.left:-1,L.vertical||-1,V,C,O,N,$,U,q,G,X,Y,Z,c,P,B,D,z,W,0,f,H,Q,tt);}(e,p,l,n,i,s,D,e.layers[0],e.collisionBoxArray,r.index,r.sourceLayerIndex,e.index,x,[_,_,_,_],k,u,b,S,E,y,r,a,c,h,o);};if("line"===T)for(const t of qf(r.geometry,0,0,M,M)){const r=gu(t,z),s=ed(r,w,A,n.vertical||m,i,24,v,e.overscaling,M);for(const t of s)m&&wd(e,m.text,I,t)||P(r,t);}else if("line-center"===T){for(const t of r.geometry)if(t.length>1){const e=gu(t,z),r=td(e,A,n.vertical||m,i,24,v);r&&P(e,r);}}else if("Polygon"===r.type)for(const t of tn(r.geometry,0)){const e=cd(t,16);P(gu(t[0],z,!0),new Hf(e.x,e.y,0));}else if("LineString"===r.type)for(const t of r.geometry){const e=gu(t,z);P(e,new Hf(e[0].x,e[0].y,0));}else if("Point"===r.type)for(const t of r.geometry)for(const e of t)P([e],new Hf(e.x,e.y,0));}function vd(t,e,n,i,s,a,o,l,u,c,h,p,f,d,y){const m=function(t,e,n,i,s,a,o,l){const u=i.layout.get("text-rotate").evaluate(a,{})*Math.PI/180,c=[];for(const t of e.positionedLines)for(const i of t.positionedGlyphs){if(!i.rect)continue;const a=i.rect||{};let h=4,p=!0,f=1,d=0;const y=(s||l)&&i.vertical,m=i.metrics.advance*i.scale/2;if(l&&e.verticalizable&&(d=t.lineOffset/2-(i.imageName?-(dc-i.metrics.width*i.scale)/2:(i.scale-1)*dc)),i.imageName){const t=o[i.imageName];p=t.sdf,f=t.pixelRatio,h=1/f;}const g=s?[i.x+m,i.y]:[0,0];let x=s?[0,0]:[i.x+m+n[0],i.y+n[1]-d],v=[0,0];y&&(v=x,x=[0,0]);const b=i.metrics.isDoubleResolution?2:1,w=(i.metrics.left-h)*i.scale-m+x[0],_=(-i.metrics.top-h)*i.scale+x[1],S=w+a.w/b*i.scale/f,A=_+a.h/b*i.scale/f,k=new r(w,_),E=new r(S,_),T=new r(w,A),I=new r(S,A);if(y){const t=new r(-m,m- -17),e=-Math.PI/2,n=12-m,s=new r(22-n,-(i.imageName?n:0)),a=new r(...v);k._rotateAround(e,t)._add(s)._add(a),E._rotateAround(e,t)._add(s)._add(a),T._rotateAround(e,t)._add(s)._add(a),I._rotateAround(e,t)._add(s)._add(a);}if(u){const t=Math.sin(u),e=Math.cos(u),r=[e,-t,t,e];k._matMult(r),E._matMult(r),T._matMult(r),I._matMult(r);}const M=new r(0,0),F=new r(0,0);c.push({tl:k,tr:E,bl:T,br:I,tex:a,writingMode:e.writingMode,glyphOffset:g,sectionIndex:i.sectionIndex,isSDF:p,pixelOffsetTL:M,pixelOffsetBR:F,minFontScaleX:0,minFontScaleY:0});}return c}(0,n,l,s,a,o,i,t.allowVerticalPlacement),g=t.textSizeData;let x=null;"source"===g.kind?(x=[nh*s.layout.get("text-size").evaluate(o,{})],x[0]>ih&&j(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)):"composite"===g.kind&&(x=[nh*d.compositeTextSizes[0].evaluate(o,{},y),nh*d.compositeTextSizes[1].evaluate(o,{},y)],(x[0]>ih||x[1]>ih)&&j(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)),t.addSymbols(t.text,m,x,l,a,o,c,e,u.lineStartIndex,u.lineLength,f,y);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*m.length}function bd(t){for(const e in t)return t[e];return null}function wd(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return !0}else i[e]=[];return i[e].push(n),!1}const _d=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class Sd{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,r]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const n=r>>4;if(1!==n)throw new Error(`Got v${n} data when expected v1.`);const i=_d[15&r];if(!i)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(t,2,1),[a]=new Uint32Array(t,4,1);return new Sd(a,s,i,t)}constructor(t,e=64,r=Float64Array,n){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=r,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const i=_d.indexOf(this.ArrayType),s=2*t*this.ArrayType.BYTES_PER_ELEMENT,a=t*this.IndexArrayType.BYTES_PER_ELEMENT,o=(8-a%8)%8;if(i<0)throw new Error(`Unexpected typed array class: ${r}.`);n&&n instanceof ArrayBuffer?(this.data=n,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+s+a+o),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+i]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t);}add(t,e){const r=this._pos>>1;return this.ids[r]=r,this.coords[this._pos++]=t,this.coords[this._pos++]=e,r}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return Ad(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,r,n){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:i,coords:s,nodeSize:a}=this,o=[0,i.length-1,0],l=[];for(;o.length;){const u=o.pop()||0,c=o.pop()||0,h=o.pop()||0;if(c-h<=a){for(let a=h;a<=c;a++){const o=s[2*a],u=s[2*a+1];o>=t&&o<=r&&u>=e&&u<=n&&l.push(i[a]);}continue}const p=h+c>>1,f=s[2*p],d=s[2*p+1];f>=t&&f<=r&&d>=e&&d<=n&&l.push(i[p]),(0===u?t<=f:e<=d)&&(o.push(h),o.push(p-1),o.push(1-u)),(0===u?r>=f:n>=d)&&(o.push(p+1),o.push(c),o.push(1-u));}return l}within(t,e,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:i,nodeSize:s}=this,a=[0,n.length-1,0],o=[],l=r*r;for(;a.length;){const u=a.pop()||0,c=a.pop()||0,h=a.pop()||0;if(c-h<=s){for(let r=h;r<=c;r++)Id(i[2*r],i[2*r+1],t,e)<=l&&o.push(n[r]);continue}const p=h+c>>1,f=i[2*p],d=i[2*p+1];Id(f,d,t,e)<=l&&o.push(n[p]),(0===u?t-r<=f:e-r<=d)&&(a.push(h),a.push(p-1),a.push(1-u)),(0===u?t+r>=f:e+r>=d)&&(a.push(p+1),a.push(c),a.push(1-u));}return o}}function Ad(t,e,r,n,i,s){if(i-n<=r)return;const a=n+i>>1;kd(t,e,a,n,i,s),Ad(t,e,r,n,a-1,1-s),Ad(t,e,r,a+1,i,1-s);}function kd(t,e,r,n,i,s){for(;i>n;){if(i-n>600){const a=i-n+1,o=r-n+1,l=Math.log(a),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(a-u)/a)*(o-a/2<0?-1:1);kd(t,e,r,Math.max(n,Math.floor(r-o*u/a+c)),Math.min(i,Math.floor(r+(a-o)*u/a+c)),s);}const a=e[2*r+s];let o=n,l=i;for(Ed(t,e,n,r),e[2*i+s]>a&&Ed(t,e,n,i);o<l;){for(Ed(t,e,o,l),o++,l--;e[2*o+s]<a;)o++;for(;e[2*l+s]>a;)l--;}e[2*n+s]===a?Ed(t,e,n,l):(l++,Ed(t,e,l,i)),l<=r&&(n=l+1),r<=l&&(i=l-1);}}function Ed(t,e,r,n){Td(t,r,n),Td(e,2*r,2*n),Td(e,2*r+1,2*n+1);}function Td(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function Id(t,e,r,n){const i=t-r,s=e-n;return i*i+s*s}var Md;t.cH=void 0,(Md=t.cH||(t.cH={})).create="create",Md.load="load",Md.fullLoad="fullLoad";let Fd=null,Dd=[];const zd=1e3/60,Pd="loadTime",Bd="fullLoadTime",Vd={mark(t){performance.mark(t);},frame(t){const e=t;null!=Fd&&Dd.push(e-Fd),Fd=e;},clearMetrics(){Fd=null,Dd=[],performance.clearMeasures(Pd),performance.clearMeasures(Bd);for(const e in t.cH)performance.clearMarks(t.cH[e]);},getPerformanceMetrics(){performance.measure(Pd,t.cH.create,t.cH.load),performance.measure(Bd,t.cH.create,t.cH.fullLoad);const e=performance.getEntriesByName(Pd)[0].duration,r=performance.getEntriesByName(Bd)[0].duration,n=Dd.length,i=1/(Dd.reduce(((t,e)=>t+e),0)/n/1e3),s=Dd.filter((t=>t>zd)).reduce(((t,e)=>t+(e-zd)/zd),0);return {loadTime:e,fullLoadTime:r,fps:i,percentDroppedFrames:s/(n+s)*100,totalFrames:n}}};t.$=c,t.A=f,t.B=us,t.C=is,t.D=js,t.E=xt,t.F=function([t,e,r]){return e+=90,e*=Math.PI/180,r*=Math.PI/180,{x:t*Math.cos(e)*Math.sin(r),y:t*Math.sin(e)*Math.sin(r),z:t*Math.cos(r)}},t.G=yr,t.H=Ps,t.I=qc,t.J=as,t.K=function(t){if(null==Y){const e=t.navigator?t.navigator.userAgent:null;Y=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return Y},t.L=class{constructor(t,e){this.target=t,this.mapId=e,this.resolveRejects={},this.tasks={},this.taskQueue=[],this.abortControllers={},this.messageHandlers={},this.invoker=new Sh((()=>this.process())),this.subscription=Q(this.target,"message",(t=>this.receive(t)),!1),this.globalScope=X(self)?t:window;}registerMessageHandler(t,e){this.messageHandlers[t]=e;}unregisterMessageHandler(t){delete this.messageHandlers[t];}sendAsync(t,e){return new Promise(((r,n)=>{const i=Math.round(1e18*Math.random()).toString(36).substring(0,10),s=e?Q(e.signal,"abort",(()=>{null==s||s.unsubscribe(),delete this.resolveRejects[i];const e={id:i,type:"<cancel>",origin:location.origin,targetMapId:t.targetMapId,sourceMapId:this.mapId};this.target.postMessage(e);}),Ah):null;this.resolveRejects[i]={resolve:t=>{null==s||s.unsubscribe(),r(t);},reject:t=>{null==s||s.unsubscribe(),n(t);}};const a=[],o=Object.assign(Object.assign({},t),{id:i,sourceMapId:this.mapId,origin:location.origin,data:ms(t.data,a)});this.target.postMessage(o,{transfer:a});}))}receive(t){const e=t.data,r=e.id;if(!("file://"!==e.origin&&"file://"!==location.origin&&"resource://android"!==e.origin&&"resource://android"!==location.origin&&e.origin!==location.origin||e.targetMapId&&this.mapId!==e.targetMapId)){if("<cancel>"===e.type){delete this.tasks[r];const t=this.abortControllers[r];return delete this.abortControllers[r],void(t&&t.abort())}if(X(self)||e.mustQueue)return this.tasks[r]=e,this.taskQueue.push(r),void this.invoker.trigger();this.processTask(r,e);}}process(){if(0===this.taskQueue.length)return;const t=this.taskQueue.shift(),e=this.tasks[t];delete this.tasks[t],this.taskQueue.length>0&&this.invoker.trigger(),e&&this.processTask(t,e);}processTask(t,r){return e(this,void 0,void 0,(function*(){if("<response>"===r.type){const e=this.resolveRejects[t];if(delete this.resolveRejects[t],!e)return;return void(r.error?e.reject(gs(r.error)):e.resolve(gs(r.data)))}if(!this.messageHandlers[r.type])return void this.completeTask(t,new Error(`Could not find a registered handler for ${r.type}, map ID: ${this.mapId}, available handlers: ${Object.keys(this.messageHandlers).join(", ")}`));const e=gs(r.data),n=new AbortController;this.abortControllers[t]=n;try{const i=yield this.messageHandlers[r.type](r.sourceMapId,e,n);this.completeTask(t,null,i);}catch(e){this.completeTask(t,e);}}))}completeTask(t,e,r){const n=[];delete this.abortControllers[t];const i={id:t,type:"<response>",sourceMapId:this.mapId,origin:location.origin,error:e?ms(e):null,data:ms(r,n)};this.target.postMessage(i,{transfer:n});}remove(){this.invoker.remove(),this.subscription.unsubscribe();}},t.M=ut,t.N=function(){var t=new f(16);return f!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},t.O=function(t,e,r){var n,i,s,a,o,l,u,c,h,p,f,d,y=r[0],m=r[1],g=r[2];return e===t?(t[12]=e[0]*y+e[4]*m+e[8]*g+e[12],t[13]=e[1]*y+e[5]*m+e[9]*g+e[13],t[14]=e[2]*y+e[6]*m+e[10]*g+e[14],t[15]=e[3]*y+e[7]*m+e[11]*g+e[15]):(i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],t[0]=n=e[0],t[1]=i,t[2]=s,t[3]=a,t[4]=o,t[5]=l,t[6]=u,t[7]=c,t[8]=h,t[9]=p,t[10]=f,t[11]=d,t[12]=n*y+o*m+h*g+e[12],t[13]=i*y+l*m+p*g+e[13],t[14]=s*y+u*m+f*g+e[14],t[15]=a*y+c*m+d*g+e[15]),t},t.P=r,t.Q=function(t,e,r){var n=r[0],i=r[1],s=r[2];return t[0]=e[0]*n,t[1]=e[1]*n,t[2]=e[2]*n,t[3]=e[3]*n,t[4]=e[4]*i,t[5]=e[5]*i,t[6]=e[6]*i,t[7]=e[7]*i,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},t.R=Sl,t.S=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],y=e[12],m=e[13],g=e[14],x=e[15],v=r[0],b=r[1],w=r[2],_=r[3];return t[0]=v*n+b*o+w*h+_*y,t[1]=v*i+b*l+w*p+_*m,t[2]=v*s+b*u+w*f+_*g,t[3]=v*a+b*c+w*d+_*x,t[4]=(v=r[4])*n+(b=r[5])*o+(w=r[6])*h+(_=r[7])*y,t[5]=v*i+b*l+w*p+_*m,t[6]=v*s+b*u+w*f+_*g,t[7]=v*a+b*c+w*d+_*x,t[8]=(v=r[8])*n+(b=r[9])*o+(w=r[10])*h+(_=r[11])*y,t[9]=v*i+b*l+w*p+_*m,t[10]=v*s+b*u+w*f+_*g,t[11]=v*a+b*c+w*d+_*x,t[12]=(v=r[12])*n+(b=r[13])*o+(w=r[14])*h+(_=r[15])*y,t[13]=v*i+b*l+w*p+_*m,t[14]=v*s+b*u+w*f+_*g,t[15]=v*a+b*c+w*d+_*x,t},t.T=zl,t.U=function(t,e){const r={};for(let n=0;n<e.length;n++){const i=e[n];i in t&&(r[i]=t[i]);}return r},t.V=Eh,t.W=L,t.X=Fh,t.Y=Mh,t.Z=at,t._=e,t.a=st,t.a$=b,t.a0=h,t.a1=K,t.a2=Rh,t.a3=zh,t.a4=Ph,t.a5=M,t.a6=function(t,e,r){if(!t)return e||{};if(!e)return t||{};const n=qh(t),i=qh(e);!function(t,e){e.removeAll&&(t.add.clear(),t.update.clear(),t.remove.clear(),e.remove.clear());for(const r of e.remove)t.add.delete(r),t.update.delete(r);for(const[r,n]of e.update){const i=t.update.get(r);i&&(e.update.set(r,Uh(i,n)),t.update.delete(r));}}(n,i);const s={};if((n.removeAll||i.removeAll)&&(s.removeAll=!0),s.remove=new Set([...n.remove,...i.remove]),s.add=new Map([...n.add,...i.add]),s.update=new Map([...n.update,...i.update]),s.remove.size&&s.add.size)for(const t of s.add.keys())s.remove.delete(t);return function(t){const e={};return t.removeAll&&(e.removeAll=t.removeAll),t.remove&&(e.remove=Array.from(t.remove)),t.add&&(e.add=Array.from(t.add.values())),t.update&&(e.update=Array.from(t.update.values())),e}(s)},t.a7=function(t,e){const r=new Map;if(null==t)return r;if(null==t.type)return r;if("Feature"===t.type){const n=$h(t,e);if(null==n)return;return r.set(n,t),r}if("FeatureCollection"===t.type){const n=new Set;for(const i of t.features){const t=$h(i,e);if(null==t)return;if(n.has(t))return;n.add(t),r.set(t,i);}return r}},t.a8=function(t,e,r){var n,i;const s=[];if(e.removeAll)t.clear();else if(e.remove)for(const r of e.remove){const e=t.get(r);e&&(s.push(e.geometry),t.delete(r));}if(e.add)for(const n of e.add){const e=$h(n,r);if(null==e)continue;const i=t.get(e);i&&s.push(i.geometry),s.push(n.geometry),t.set(e,n);}if(e.update)for(const r of e.update){const e=t.get(r.id);if(!e)continue;const a=!!r.newGeometry,o=r.removeAllProperties||(null===(n=r.removeProperties)||void 0===n?void 0:n.length)>0||(null===(i=r.addOrUpdateProperties)||void 0===i?void 0:i.length)>0;if(!a&&!o)continue;s.push(e.geometry);const l=Object.assign({},e);if(t.set(r.id,l),a&&(s.push(r.newGeometry),l.geometry=r.newGeometry),o){if(l.properties=r.removeAllProperties?{}:Object.assign({},l.properties||{}),r.removeProperties)for(const t of r.removeProperties)delete l.properties[t];if(r.addOrUpdateProperties)for(const{key:t,value:e}of r.addOrUpdateProperties)l.properties[t]=e;}}return s},t.a9=Vh,t.aA=function(t,{uSize:e,uSizeT:r},{lowerSize:n,upperSize:i}){return "source"===t.kind?n/nh:"composite"===t.kind?yr.number(n/nh,i/nh,r):e},t.aB=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],y=e[13],m=e[14],g=e[15],x=r*o-n*a,v=r*l-i*a,b=r*u-s*a,w=n*l-i*o,_=n*u-s*o,S=i*u-s*l,A=c*y-h*d,k=c*m-p*d,E=c*g-f*d,T=h*m-p*y,I=h*g-f*y,M=p*g-f*m,F=x*M-v*I+b*T+w*E-_*k+S*A;return F?(t[0]=(o*M-l*I+u*T)*(F=1/F),t[1]=(i*I-n*M-s*T)*F,t[2]=(y*S-m*_+g*w)*F,t[3]=(p*_-h*S-f*w)*F,t[4]=(l*E-a*M-u*k)*F,t[5]=(r*M-i*E+s*k)*F,t[6]=(m*b-d*S-g*v)*F,t[7]=(c*S-p*b+f*v)*F,t[8]=(a*I-o*E+u*A)*F,t[9]=(n*E-r*I-s*A)*F,t[10]=(d*_-y*b+g*x)*F,t[11]=(h*b-c*_-f*x)*F,t[12]=(o*k-a*T-l*A)*F,t[13]=(r*T-n*k+i*A)*F,t[14]=(y*v-d*w-m*x)*F,t[15]=(c*w-h*v+p*x)*F,t):null},t.aC=T,t.aD=function(t){var e=t[0],r=t[1];return Math.sqrt(e*e+r*r)},t.aE=function(t){return t[0]=0,t[1]=0,t},t.aF=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t},t.aG=uh,t.aH=A,t.aI=function(t,e,n,i){const s=e.y-t.y,a=e.x-t.x,o=i.y-n.y,l=i.x-n.x,u=o*a-l*s;if(0===u)return null;const c=(l*(t.y-n.y)-o*(t.x-n.x))/u;return new r(t.x+c*a,t.y+c*s)},t.aJ=qf,t.aK=Go,t.aL=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of t)e=Math.min(e,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);return [e,r,n,i]},t.aM=dc,t.aN=F,t.aO=function(t,e,r,n,i=!1){if(!r[0]&&!r[1])return [0,0];const s=i?"map"===n?-t.bearingInRadians:0:"viewport"===n?t.bearingInRadians:0;if(s){const t=Math.sin(s),e=Math.cos(s);r=[r[0]*e-r[1]*t,r[0]*t+r[1]*e];}return [i?r[0]:F(e,r[0],t.zoom),i?r[1]:F(e,r[1],t.zoom)]},t.aQ=ah,t.aR=gd,t.aS=Yc,t.aT=Sd,t.aU=na,t.aV=pu,t.aW=$a,t.aX=io,t.aY=to,t.aZ=et,t.a_=Bh,t.aa=jh,t.ab=25,t.ac=Lh,t.ad=t=>{const e=window.document.createElement("video");return e.muted=!0,new Promise((r=>{e.onloadstart=()=>{r(e);};for(const r of t){const t=window.document.createElement("source");ft(r)||(e.crossOrigin="Anonymous"),t.src=r,e.appendChild(t);}}))},t.ae=Dt,t.af=function(){return R++},t.ag=Fa,t.ah=fh,t.ai=zf,t.aj=fi,t.ak=$o,t.al=Xh,t.am=function(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,r,n,i)=>{const s=n||i;return e[r]=!s||s.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e},t.an=C,t.ao=85.051129,t.ap=tt,t.aq=function(t){return Math.pow(2,t)},t.ar=y,t.as=Dh,t.at=function(t){return Math.log(t)/Math.LN2},t.au=function(t){var e=t[0],r=t[1];return e*e+r*r},t.av=function(t){if(!t.length)return new Set;const e=Math.max(...t.map((t=>t.canonical.z)));let r=1/0,n=-1/0,i=1/0,s=-1/0;const a=[];for(const o of t){const{x:t,y:l,z:u}=o.canonical,c=Math.pow(2,e-u),h=t*c,p=l*c;a.push({id:o,x:h,y:p}),h<r&&(r=h),h>n&&(n=h),p<i&&(i=p),p>s&&(s=p);}const o=new Set;for(const t of a)t.x!==r&&t.x!==n&&t.y!==i&&t.y!==s||o.add(t.id);return o},t.aw=function(t,e){const r=Math.abs(2*t.wrap)-+(t.wrap<0),n=Math.abs(2*e.wrap)-+(e.wrap<0);return t.overscaledZ-e.overscaledZ||n-r||e.canonical.y-t.canonical.y||e.canonical.x-t.canonical.x},t.ax=class{constructor(t,e){this.max=t,this.onRemove=e,this.reset();}reset(){for(const t in this.data)for(const e of this.data[t])e.timeout&&clearTimeout(e.timeout),this.onRemove(e.value);return this.data={},this.order=[],this}add(t,e,r){const n=t.wrapped().key;void 0===this.data[n]&&(this.data[n]=[]);const i={value:e,timeout:void 0};if(void 0!==r&&(i.timeout=setTimeout((()=>{this.remove(t,i);}),r)),this.data[n].push(i),this.order.push(n),this.order.length>this.max){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}has(t){return t.wrapped().key in this.data}getAndRemove(t){return this.has(t)?this._getAndRemoveByKey(t.wrapped().key):null}_getAndRemoveByKey(t){const e=this.data[t].shift();return e.timeout&&clearTimeout(e.timeout),0===this.data[t].length&&delete this.data[t],this.order.splice(this.order.indexOf(t),1),e.value}getByKey(t){const e=this.data[t];return e?e[0].value:null}get(t){return this.has(t)?this.data[t.wrapped().key][0].value:null}remove(t,e){if(!this.has(t))return this;const r=t.wrapped().key,n=void 0===e?0:this.data[r].indexOf(e),i=this.data[r][n];return this.data[r].splice(n,1),i.timeout&&clearTimeout(i.timeout),0===this.data[r].length&&delete this.data[r],this.onRemove(i.value),this.order.splice(this.order.indexOf(r),1),this}setMaxSize(t){for(this.max=t;this.order.length>this.max;){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}filter(t){const e=[];for(const r in this.data)for(const n of this.data[r])t(n.value)||e.push(n);for(const t of e)this.remove(t.value.tileID,t);}},t.ay=function(t,e){let r=0,n=0;if("constant"===t.kind)n=t.layoutSize;else if("source"!==t.kind){const{interpolationType:i,minZoom:s,maxZoom:a}=t,o=i?C(fr.interpolationFactor(i,e,s,a),0,1):0;"camera"===t.kind?n=yr.number(t.minSize,t.maxSize,o):r=o;}return {uSizeT:r,uSize:n}},t.b=Z,t.b$=Ao,t.b0=v,t.b1=function(t){var e=new f(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e},t.b2=function(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t},t.b3=function(t,e){var r=e[0],n=e[1],i=e[2],s=r*r+n*n+i*i;return s>0&&(s=1/Math.sqrt(s)),t[0]=e[0]*s,t[1]=e[1]*s,t[2]=e[2]*s,t},t.b4=w,t.b5=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]},t.b6=function(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t[3]=e[3]*r[3],t},t.b7=g,t.b8=function(t,e,r){const n=e[0]*r[0]+e[1]*r[1]+e[2]*r[2];return 0===n?null:(-(t[0]*r[0]+t[1]*r[1]+t[2]*r[2])-r[3])/n},t.b9=S,t.bA=function(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t},t.bB=E,t.bC=function(t,e,r){var n=r[0],i=r[1],s=r[2],a=r[3],o=e[0],l=e[1],u=e[2],c=i*u-s*l,h=s*o-n*u,p=n*l-i*o;return t[0]=o+a*(c+=c)+i*(p+=p)-s*(h+=h),t[1]=l+a*h+s*c-n*p,t[2]=u+a*p+n*h-i*c,t},t.bD=function(t,e,r){const n=function(t){var e=t[3],r=t[4],n=t[5],i=t[6],s=t[7],a=t[8];return t[0]*(a*r-n*s)+t[1]*(-a*e+n*i)+t[2]*(s*e-r*i)}([t[0],t[1],t[2],e[0],e[1],e[2],r[0],r[1],r[2]]);if(0===n)return null;const i=w([],[e[0],e[1],e[2]],[r[0],r[1],r[2]]),s=w([],[r[0],r[1],r[2]],[t[0],t[1],t[2]]),a=w([],[t[0],t[1],t[2]],[e[0],e[1],e[2]]),o=b([],i,-t[3]);return v(o,o,b([],s,-e[3])),v(o,o,b([],a,-r[3])),b(o,o,1/n),o},t.bE=kh,t.bF=function(){return new Float64Array(4)},t.bG=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[0]*Math.cos(n)-i[1]*Math.sin(n),s[1]=i[0]*Math.sin(n)+i[1]*Math.cos(n),s[2]=i[2],t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t},t.bH=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[0],s[1]=i[1]*Math.cos(n)-i[2]*Math.sin(n),s[2]=i[1]*Math.sin(n)+i[2]*Math.cos(n),t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t},t.bI=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[2]*Math.sin(n)+i[0]*Math.cos(n),s[1]=i[1],s[2]=i[2]*Math.cos(n)-i[0]*Math.sin(n),t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t},t.bJ=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i-u*n,t[1]=a*i-c*n,t[2]=o*i-h*n,t[3]=l*i-p*n,t[8]=s*n+u*i,t[9]=a*n+c*i,t[10]=o*n+h*i,t[11]=l*n+p*i,t},t.bK=function(t,e){const r=D(t,360),n=D(e,360),i=n-r,s=n>r?i-360:i+360;return Math.abs(i)<Math.abs(s)?i:s},t.bL=function(t){return t[0]=0,t[1]=0,t[2]=0,t},t.bM=function(t,e,r,n){const i=Math.sqrt(t*t+e*e),s=Math.sqrt(r*r+n*n);t/=i,e/=i,r/=s,n/=s;const a=Math.acos(t*r+e*n);return -e*r+t*n>0?a:-a},t.bN=function(t,e){const r=D(t,2*Math.PI),n=D(e,2*Math.PI);return Math.min(Math.abs(r-n),Math.abs(r-n+2*Math.PI),Math.abs(r-n-2*Math.PI))},t.bO=function(){const t={},e=vt.$version;for(const r in vt.$root){const n=vt.$root[r];if(n.required){let i=null;i="version"===r?e:"array"===n.type?[]:{},null!=i&&(t[r]=i);}}return t},t.bP=ht,t.bQ=xs,t.bR=function t(e,r){if(Array.isArray(e)){if(!Array.isArray(r)||e.length!==r.length)return !1;for(let n=0;n<e.length;n++)if(!t(e[n],r[n]))return !1;return !0}if("object"==typeof e&&null!==e&&null!==r){if("object"!=typeof r)return !1;if(Object.keys(e).length!==Object.keys(r).length)return !1;for(const n in e)if(!t(e[n],r[n]))return !1;return !0}return e===r},t.bS=function(t){t=t.slice();const e=Object.create(null);for(let r=0;r<t.length;r++)e[t[r].id]=t[r];for(let r=0;r<t.length;r++)"ref"in t[r]&&(t[r]=wt(t[r],e[t[r].ref]));return t},t.bT=function(t,e){if("custom"===t.type)return new _h(t,e);switch(t.type){case "background":return new wh(t,e);case "circle":return new yl(t,e);case "color-relief":return new Vl(t,e);case "fill":return new ku(t,e);case "fill-extrusion":return new Gu(t,e);case "heatmap":return new El(t,e);case "hillshade":return new Ml(t,e);case "line":return new ac(t,e);case "raster":return new Qs(t,e);case "symbol":return new xh(t,e)}},t.bU=t=>"raster"===t.type,t.bV=U,t.bW=function(t,e){if(!t)return [{command:"setStyle",args:[e]}];let r=[];try{if(!_t(t.version,e.version))return [{command:"setStyle",args:[e]}];_t(t.center,e.center)||r.push({command:"setCenter",args:[e.center]}),_t(t.state,e.state)||r.push({command:"setGlobalState",args:[e.state]}),_t(t.centerAltitude,e.centerAltitude)||r.push({command:"setCenterAltitude",args:[e.centerAltitude]}),_t(t.zoom,e.zoom)||r.push({command:"setZoom",args:[e.zoom]}),_t(t.bearing,e.bearing)||r.push({command:"setBearing",args:[e.bearing]}),_t(t.pitch,e.pitch)||r.push({command:"setPitch",args:[e.pitch]}),_t(t.roll,e.roll)||r.push({command:"setRoll",args:[e.roll]}),_t(t.sprite,e.sprite)||r.push({command:"setSprite",args:[e.sprite]}),_t(t.glyphs,e.glyphs)||r.push({command:"setGlyphs",args:[e.glyphs]}),_t(t.transition,e.transition)||r.push({command:"setTransition",args:[e.transition]}),_t(t.light,e.light)||r.push({command:"setLight",args:[e.light]}),_t(t.terrain,e.terrain)||r.push({command:"setTerrain",args:[e.terrain]}),_t(t.sky,e.sky)||r.push({command:"setSky",args:[e.sky]}),_t(t.projection,e.projection)||r.push({command:"setProjection",args:[e.projection]});const n={},i=[];!function(t,e,r,n){let i;for(i in e=e||{},t=t||{})Object.prototype.hasOwnProperty.call(t,i)&&(Object.prototype.hasOwnProperty.call(e,i)||kt(i,r,n));for(i in e)Object.prototype.hasOwnProperty.call(e,i)&&(Object.prototype.hasOwnProperty.call(t,i)?_t(t[i],e[i])||("geojson"===t[i].type&&"geojson"===e[i].type&&Tt(t,e,i)?St(r,{command:"setGeoJSONSourceData",args:[i,e[i].data]}):Et(i,e,r,n)):At(i,e,r));}(t.sources,e.sources,i,n);const s=[];t.layers&&t.layers.forEach((t=>{"source"in t&&n[t.source]?r.push({command:"removeLayer",args:[t.id]}):s.push(t);})),r=r.concat(i),function(t,e,r){e=e||[];const n=(t=t||[]).map(Mt),i=e.map(Mt),s=t.reduce(Ft,{}),a=e.reduce(Ft,{}),o=n.slice(),l=Object.create(null);let u,c,h,p,f;for(let t=0,e=0;t<n.length;t++)u=n[t],Object.prototype.hasOwnProperty.call(a,u)?e++:(St(r,{command:"removeLayer",args:[u]}),o.splice(o.indexOf(u,e),1));for(let t=0,e=0;t<i.length;t++)u=i[i.length-1-t],o[o.length-1-t]!==u&&(Object.prototype.hasOwnProperty.call(s,u)?(St(r,{command:"removeLayer",args:[u]}),o.splice(o.lastIndexOf(u,o.length-e),1)):e++,p=o[o.length-t],St(r,{command:"addLayer",args:[a[u],p]}),o.splice(o.length-t,0,u),l[u]=!0);for(let t=0;t<i.length;t++)if(u=i[t],c=s[u],h=a[u],!l[u]&&!_t(c,h))if(_t(c.source,h.source)&&_t(c["source-layer"],h["source-layer"])&&_t(c.type,h.type)){for(f in It(c.layout,h.layout,r,u,null,"setLayoutProperty"),It(c.paint,h.paint,r,u,null,"setPaintProperty"),_t(c.filter,h.filter)||St(r,{command:"setFilter",args:[u,h.filter]}),_t(c.minzoom,h.minzoom)&&_t(c.maxzoom,h.maxzoom)||St(r,{command:"setLayerZoomRange",args:[u,h.minzoom,h.maxzoom]}),c)Object.prototype.hasOwnProperty.call(c,f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?It(c[f],h[f],r,u,f.slice(6),"setPaintProperty"):_t(c[f],h[f])||St(r,{command:"setLayerProperty",args:[u,f,h[f]]}));for(f in h)Object.prototype.hasOwnProperty.call(h,f)&&!Object.prototype.hasOwnProperty.call(c,f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?It(c[f],h[f],r,u,f.slice(6),"setPaintProperty"):_t(c[f],h[f])||St(r,{command:"setLayerProperty",args:[u,f,h[f]]}));}else St(r,{command:"removeLayer",args:[u]}),p=o[o.lastIndexOf(u)+1],St(r,{command:"addLayer",args:[h,p]});}(s,e.layers,r);}catch(t){console.warn("Unable to compute style diff:",t),r=[{command:"setStyle",args:[e]}];}return r},t.bX=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),e},t.bY=N,t.bZ=$,t.b_=class extends wo{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1i(this.location,t));}},t.ba=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t},t.bb=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]},t.bc=Oh,t.bd=Nh,t.be=function(t,e,r,n,i){var s=1/Math.tan(e/2);if(t[0]=s/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=s,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0){var a=1/(n-i);t[10]=(i+n)*a,t[14]=2*i*n*a;}else t[10]=-1,t[14]=-2*n;return t},t.bf=function(t){var e=new f(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},t.bg=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i+u*n,t[1]=a*i+c*n,t[2]=o*i+h*n,t[3]=l*i+p*n,t[4]=u*i-s*n,t[5]=c*i-a*n,t[6]=h*i-o*n,t[7]=p*i-l*n,t},t.bh=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[4],a=e[5],o=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*i+u*n,t[5]=a*i+c*n,t[6]=o*i+h*n,t[7]=l*i+p*n,t[8]=u*i-s*n,t[9]=c*i-a*n,t[10]=h*i-o*n,t[11]=p*i-l*n,t},t.bi=function(){const t=new Float32Array(16);return y(t),t},t.bj=function(){const t=new Float64Array(16);return y(t),t},t.bk=function(){return new Float64Array(16)},t.bl=function(t,e,r){const n=new Float64Array(4);return E(n,t,e-90,r),n},t.bm=function(t,e,r,n){var i,s,a,o,l,u=e[0],c=e[1],h=e[2],f=e[3],d=r[0],y=r[1],m=r[2],g=r[3];return (s=u*d+c*y+h*m+f*g)<0&&(s=-s,d=-d,y=-y,m=-m,g=-g),1-s>p?(i=Math.acos(s),a=Math.sin(i),o=Math.sin((1-n)*i)/a,l=Math.sin(n*i)/a):(o=1-n,l=n),t[0]=o*u+l*d,t[1]=o*c+l*y,t[2]=o*h+l*m,t[3]=o*f+l*g,t},t.bn=function(t){const e=new Float64Array(9);!function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=r+r,o=n+n,l=i+i,u=r*a,c=n*a,h=n*o,p=i*a,f=i*o,d=i*l,y=s*a,m=s*o,g=s*l;t[0]=1-h-d,t[3]=c-g,t[6]=p+m,t[1]=c+g,t[4]=1-u-d,t[7]=f-y,t[2]=p-m,t[5]=f+y,t[8]=1-u-h;}(e,t);const r=et(-Math.asin(C(e[2],-1,1)));let n,i;return Math.hypot(e[5],e[8])<.001?(n=0,i=-et(Math.atan2(e[3],e[4]))):(n=et(0===e[5]&&0===e[8]?0:Math.atan2(e[5],e[8])),i=et(0===e[1]&&0===e[0]?0:Math.atan2(e[1],e[0]))),{roll:n,pitch:r+90,bearing:i}},t.bo=function(t,e){return t.roll==e.roll&&t.pitch==e.pitch&&t.bearing==e.bearing},t.bp=Te,t.bq=_o,t.br=fu,t.bs=du,t.bt=hu,t.bu=z,t.bv=P,t.bw=Re,t.bx=function(t,e,r,n,i){return z(n,i,C((t-e)/(r-e),0,1))},t.by=D,t.bz=function(){return new Float64Array(3)},t.c=ot,t.c$=function(t,r,n,i,s){return e(this,void 0,void 0,(function*(){if(h())try{return yield K(t,r,n,i,s)}catch(t){}return function(t,e,r,n,i){const s=t.width,a=t.height;W&&J||(W=new OffscreenCanvas(s,a),J=W.getContext("2d",{willReadFrequently:!0})),W.width=s,W.height=a,J.drawImage(t,0,0,s,a);const o=J.getImageData(e,r,n,i);return J.clearRect(0,0,s,a),o.data}(t,r,n,i,s)}))},t.c0=class extends wo{constructor(t,e){super(t,e),this.current=ko;}set(t){if(t[12]!==this.current[12]||t[0]!==this.current[0])return this.current=t,void this.gl.uniformMatrix4fv(this.location,!1,t);for(let e=1;e<16;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix4fv(this.location,!1,t);break}}},t.c1=So,t.c2=class extends wo{constructor(t,e){super(t,e),this.current=[0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]||(this.current=t,this.gl.uniform3f(this.location,t[0],t[1],t[2]));}},t.c3=class extends wo{constructor(t,e){super(t,e),this.current=[0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]||(this.current=t,this.gl.uniform2f(this.location,t[0],t[1]));}},t.c4=d,t.c5=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=0,t[3]=-r,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},t.c6=function(t,e,r){var n=e[0],i=e[1],s=e[2];return t[0]=n*r[0]+i*r[3]+s*r[6],t[1]=n*r[1]+i*r[4]+s*r[7],t[2]=n*r[2]+i*r[5]+s*r[8],t},t.c7=function(t,e,r,n,i,s,a){var o=1/(e-r),l=1/(n-i),u=1/(s-a);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*u,t[11]=0,t[12]=(e+r)*o,t[13]=(i+n)*l,t[14]=(a+s)*u,t[15]=1,t},t.c8=class extends wo{constructor(t,e){super(t,e),this.current=new Array;}set(t){if(t!=this.current){this.current=t;const e=new Float32Array(4*t.length);for(let r=0;r<t.length;r++)e[4*r]=t[r].r,e[4*r+1]=t[r].g,e[4*r+2]=t[r].b,e[4*r+3]=t[r].a;this.gl.uniform4fv(this.location,e);}}},t.c9=class extends wo{constructor(t,e){super(t,e),this.current=new Array;}set(t){if(t!=this.current){this.current=t;const e=new Float32Array(t);this.gl.uniform1fv(this.location,e);}}},t.cA=function(t,e){return rt[e]&&"touches"in t},t.cB=function(t){return rt[t]||nt[t]},t.cC=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[4]*i+r[12],t[1]=r[1]*n+r[5]*i+r[13],t},t.cD=function(t,e){const{x:r,y:n}=Vh.fromLngLat(e);return !(t<0||t>25||n<0||n>=1||r<0||r>=1)},t.cE=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},t.cF=class extends aa{},t.cG=Vd,t.cI=ct,t.cJ=function(t,e){ot.REGISTERED_PROTOCOLS[t]=e;},t.cK=function(t){delete ot.REGISTERED_PROTOCOLS[t];},t.cL=function(t,e){const r={};for(let n=0;n<t.length;n++){const i=e&&e[t[n].id]||_i(t[n]);e&&(e[t[n].id]=i);let s=r[i];s||(s=r[i]=[]),s.push(t[n]);}const n=[];for(const t in r)n.push(r[t]);return n},t.cM=ps,t.cN=Gh,t.cO=Nf,t.cP=jc,t.cQ=function(e){e.bucket.createArrays(),e.bucket.tilePixelRatio=M/(512*e.bucket.overscaling),e.bucket.compareText={},e.bucket.iconsNeedLinear=!1;const r=e.bucket.layers[0],n=r.layout,i=r._unevaluatedLayout._values,s={layoutIconSize:i["icon-size"].possiblyEvaluate(new Ps(e.bucket.zoom+1),e.canonical),layoutTextSize:i["text-size"].possiblyEvaluate(new Ps(e.bucket.zoom+1),e.canonical),textMaxSize:i["text-size"].possiblyEvaluate(new Ps(18))};if("composite"===e.bucket.textSizeData.kind){const{minZoom:t,maxZoom:r}=e.bucket.textSizeData;s.compositeTextSizes=[i["text-size"].possiblyEvaluate(new Ps(t),e.canonical),i["text-size"].possiblyEvaluate(new Ps(r),e.canonical)];}if("composite"===e.bucket.iconSizeData.kind){const{minZoom:t,maxZoom:r}=e.bucket.iconSizeData;s.compositeIconSizes=[i["icon-size"].possiblyEvaluate(new Ps(t),e.canonical),i["icon-size"].possiblyEvaluate(new Ps(r),e.canonical)];}const a=n.get("text-line-height")*dc,o="viewport"!==n.get("text-rotation-alignment")&&"point"!==n.get("symbol-placement"),l=n.get("text-keep-upright"),u=n.get("text-size");for(const i of e.bucket.features){const c=n.get("text-font").evaluate(i,{},e.canonical).join(","),h=u.evaluate(i,{},e.canonical),p=s.layoutTextSize.evaluate(i,{},e.canonical),f=s.layoutIconSize.evaluate(i,{},e.canonical),d={horizontal:{},vertical:void 0},y=i.text;let m,g=[0,0];if(y){const s=y.toString(),u=n.get("text-letter-spacing").evaluate(i,{},e.canonical)*dc,f=Ss(s)?u:0,m=n.get("text-anchor").evaluate(i,{},e.canonical),x=md(r,i,e.canonical);if(!x){const t=n.get("text-radial-offset").evaluate(i,{},e.canonical);g=t?yd(m,[t*dc,dd]):n.get("text-offset").evaluate(i,{},e.canonical).map((t=>t*dc));}let v=o?"center":n.get("text-justify").evaluate(i,{},e.canonical);const b="point"===n.get("symbol-placement")?n.get("text-max-width").evaluate(i,{},e.canonical)*dc:1/0,w=()=>{e.bucket.allowVerticalPlacement&&_s(s)&&(d.vertical=Xc(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,m,"left",f,g,t.az.vertical,!0,p,h));};if(!o&&x){const r=new Set;if("auto"===v)for(let t=0;t<x.values.length;t+=2)r.add(gd(x.values[t]));else r.add(v);let n=!1;for(const i of r)if(!d.horizontal[i])if(n)d.horizontal[i]=d.horizontal[0];else {const r=Xc(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,"center",i,f,g,t.az.horizontal,!1,p,h);r&&(d.horizontal[i]=r,n=1===r.positionedLines.length);}w();}else {"auto"===v&&(v=gd(m));const r=Xc(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,m,v,f,g,t.az.horizontal,!1,p,h);r&&(d.horizontal[v]=r),w(),_s(s)&&o&&l&&(d.vertical=Xc(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,m,v,f,g,t.az.vertical,!1,p,h));}}let x=!1;if(i.icon&&i.icon.name){const t=e.imageMap[i.icon.name];t&&(m=th(e.imagePositions[i.icon.name],n.get("icon-offset").evaluate(i,{},e.canonical),n.get("icon-anchor").evaluate(i,{},e.canonical)),x=!!t.sdf,void 0===e.bucket.sdfIcons?e.bucket.sdfIcons=x:e.bucket.sdfIcons!==x&&j("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(t.pixelRatio!==e.bucket.pixelRatio||0!==n.get("icon-rotate").constantOr(1))&&(e.bucket.iconsNeedLinear=!0));}const v=bd(d.horizontal)||d.vertical;e.bucket.iconsInText=!!v&&v.iconsInText,(v||m)&&xd(e.bucket,i,d,m,e.imageMap,s,p,f,g,x,e.canonical,e.subdivisionGranularity);}e.showCollisionBoxes&&e.bucket.generateCollisionDebugBuffers();},t.cR=wu,t.cS=Ru,t.cT=tc,t.cU=function(t){const e=new Tc;return function(t,e){for(const r in t.layers)e.writeMessage(3,Pf,t.layers[r]);}(t,e),e.finish()},t.cV=function(t,e,r,n,i,s){let a=jf(t,e,r,i,0);return a=jf(a,e,n,s,1),a},t.cW=class{constructor(t){this.maxEntries=t,this.map=new Map;}get(t){const e=this.map.get(t);return void 0!==e&&(this.map.delete(t),this.map.set(t,e)),e}set(t,e){if(this.map.has(t))this.map.delete(t);else if(this.map.size>=this.maxEntries){const t=this.map.keys().next().value;this.map.delete(t);}this.map.set(t,e);}clear(){this.map.clear();}},t.cX=Vu,t.cY=Tc,t.cZ=Ff,t.c_=class{constructor(t){this._marks={start:[t.url,"start"].join("#"),end:[t.url,"end"].join("#"),measure:t.url.toString()},performance.mark(this._marks.start);}finish(){performance.mark(this._marks.end);let t=performance.getEntriesByName(this._marks.measure);return 0===t.length&&(performance.measure(this._marks.measure,this._marks.start,this._marks.end),t=performance.getEntriesByName(this._marks.measure),performance.clearMarks(this._marks.start),performance.clearMarks(this._marks.end),performance.clearMeasures(this._marks.measure)),t}},t.ca=class extends xa{},t.cb=pc,t.cc=class extends ba{},t.cd=kl,t.ce=function(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))},t.cf=Al,t.cg=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[3]*n+r[7]*i+r[11]*s+r[15];return t[0]=(r[0]*n+r[4]*i+r[8]*s+r[12])/(a=a||1),t[1]=(r[1]*n+r[5]*i+r[9]*s+r[13])/a,t[2]=(r[2]*n+r[6]*i+r[10]*s+r[14])/a,t},t.ch=class extends oa{},t.ci=class extends Ta{},t.cj=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]&&t[9]===e[9]&&t[10]===e[10]&&t[11]===e[11]&&t[12]===e[12]&&t[13]===e[13]&&t[14]===e[14]&&t[15]===e[15]},t.ck=function(t,e){var r=t[0],n=t[1],i=t[2],s=t[3],a=t[4],o=t[5],l=t[6],u=t[7],c=t[8],h=t[9],f=t[10],d=t[11],y=t[12],m=t[13],g=t[14],x=t[15],v=e[0],b=e[1],w=e[2],_=e[3],S=e[4],A=e[5],k=e[6],E=e[7],T=e[8],I=e[9],M=e[10],F=e[11],D=e[12],z=e[13],P=e[14],B=e[15];return Math.abs(r-v)<=p*Math.max(1,Math.abs(r),Math.abs(v))&&Math.abs(n-b)<=p*Math.max(1,Math.abs(n),Math.abs(b))&&Math.abs(i-w)<=p*Math.max(1,Math.abs(i),Math.abs(w))&&Math.abs(s-_)<=p*Math.max(1,Math.abs(s),Math.abs(_))&&Math.abs(a-S)<=p*Math.max(1,Math.abs(a),Math.abs(S))&&Math.abs(o-A)<=p*Math.max(1,Math.abs(o),Math.abs(A))&&Math.abs(l-k)<=p*Math.max(1,Math.abs(l),Math.abs(k))&&Math.abs(u-E)<=p*Math.max(1,Math.abs(u),Math.abs(E))&&Math.abs(c-T)<=p*Math.max(1,Math.abs(c),Math.abs(T))&&Math.abs(h-I)<=p*Math.max(1,Math.abs(h),Math.abs(I))&&Math.abs(f-M)<=p*Math.max(1,Math.abs(f),Math.abs(M))&&Math.abs(d-F)<=p*Math.max(1,Math.abs(d),Math.abs(F))&&Math.abs(y-D)<=p*Math.max(1,Math.abs(y),Math.abs(D))&&Math.abs(m-z)<=p*Math.max(1,Math.abs(m),Math.abs(z))&&Math.abs(g-P)<=p*Math.max(1,Math.abs(g),Math.abs(P))&&Math.abs(x-B)<=p*Math.max(1,Math.abs(x),Math.abs(B))},t.cl=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},t.cm=t=>"symbol"===t.type,t.cn=t=>"circle"===t.type,t.co=t=>"heatmap"===t.type,t.cp=t=>"line"===t.type,t.cq=t=>"fill"===t.type,t.cr=t=>"fill-extrusion"===t.type,t.cs=t=>"hillshade"===t.type,t.ct=t=>"color-relief"===t.type,t.cu=t=>"background"===t.type,t.cv=t=>"custom"===t.type,t.cw=B,t.cx=function(t,e,r){const n=I(e.x-r.x,e.y-r.y),i=I(t.x-r.x,t.y-r.y),s=Math.atan2(n[0]*i[1]-n[1]*i[0],function(t,e){return t[0]*e[0]+t[1]*e[1]}(n,i));return et(s)},t.cy=V,t.cz=function(t,e){return nt[e]&&(t instanceof MouseEvent||t instanceof WheelEvent)},t.d=ft,t.d0=Pl,t.d1=n,t.d2=class{constructor(t,e){this.layers={[zf]:this},this.name=zf,this.version=e?e.version:1,this.extent=e?e.extent:4096,this.length=t.length,this.features=t;}feature(t){return new Df(this.features[t],this.extent)}},t.d3=ni,t.d4=zs,t.e=O,t.f=t=>e(void 0,void 0,void 0,(function*(){if(0===t.byteLength)return createImageBitmap(new ImageData(1,1));const e=new Blob([new Uint8Array(t)],{type:"image/png"});try{return createImageBitmap(e)}catch(t){throw new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`)}})),t.g=lt,t.h=t=>new Promise(((e,r)=>{const n=new Image;n.onload=()=>{e(n),URL.revokeObjectURL(n.src),n.onload=null,window.requestAnimationFrame((()=>{n.src=H;}));},n.onerror=()=>r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const i=new Blob([new Uint8Array(t)],{type:"image/png"});n.src=t.byteLength?URL.createObjectURL(i):H;})),t.i=X,t.j=(t,e)=>pt(O(t,{type:"json"}),e),t.k=gt,t.l=mt,t.m=pt,t.n=(t,e)=>pt(O(t,{type:"arrayBuffer"}),e),t.o=function(t){return new Tc(t).readFields(Rc,[])},t.p=Uc,t.q=function(t){return /[\u02EA\u02EB\u1100-\u11FF\u2E80-\u2FDF\u3000-\u30FF\u3105-\u312F\u3131-\u318E\u31A0-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFE10-\uFE1F\uFE30-\uFE4F\uFF00-\uFFEF]|\uD81B[\uDFE0-\uDFFF]|[\uD81C-\uD822\uD840-\uD868\uD86A-\uD86D\uD86F-\uD872\uD874-\uD879\uD880-\uD883\uD885-\uD88C][\uDC00-\uDFFF]|\uD823[\uDC00-\uDCD5\uDCFF-\uDD1E\uDD80-\uDDF2]|\uD82B[\uDFF0-\uDFFF]|\uD82C[\uDC00-\uDEFB]|\uD83C[\uDE00-\uDEFF]|\uD869[\uDC00-\uDEDF\uDF00-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEAD\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0\uDFF0-\uDFFF]|\uD87B[\uDC00-\uDE5D]|\uD87E[\uDC00-\uDE1D]|\uD884[\uDC00-\uDF4A\uDF50-\uDFFF]|\uD88D[\uDC00-\uDC79]/gim.test(String.fromCodePoint(t))},t.r=_l,t.s=Q,t.t=Hs,t.u=vt,t.v=ns,t.w=j,t.x=Os,t.y=ss,t.z=Vs;}));

define("worker",["./shared"],(function(e){"use strict";class t{constructor(e,t){this.keyCache={},e&&this.replace(e,t);}replace(e,t){this._layerConfigs={},this._layers={},this.update(e,[],t);}update(t,o,i){for(const o of t){this._layerConfigs[o.id]=o;const t=this._layers[o.id]=e.bT(o,i);t._featureFilter=e.aj(t.filter,i),this.keyCache[o.id]&&delete this.keyCache[o.id];}for(const e of o)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const s=e.cL(Object.values(this._layerConfigs),this.keyCache);for(const t of s){const o=t.map((e=>this._layers[e.id])),i=o[0];if(i.isHidden())continue;const s=i.source||"";let n=this.familiesBySource[s];n||(n=this.familiesBySource[s]={});const r=i.sourceLayer||e.ai;let a=n[r];a||(a=n[r]=[]),a.push(o);}}}class o{constructor(t){const o={},i=[];for(const e in t){const s=t[e],n=o[e]={};for(const e in s){const t=s[+e];if(!t||0===t.bitmap.width||0===t.bitmap.height)continue;const o={x:0,y:0,w:t.bitmap.width+2,h:t.bitmap.height+2};i.push(o),n[e]={rect:o,metrics:t.metrics};}}const{w:s,h:n}=e.p(i),r=new e.r({width:s||1,height:n||1});for(const i in t){const s=t[i];for(const t in s){const n=s[+t];if(!n||0===n.bitmap.width||0===n.bitmap.height)continue;const a=o[i][t].rect;e.r.copy(n.bitmap,r,{x:0,y:0},{x:a.x+1,y:a.y+1},n.bitmap);}}this.image=r,this.positions=o;}}e.cM("GlyphAtlas",o);class i{constructor(t){this.tileID=new e.a2(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.uid=t.uid,this.zoom=t.zoom,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.collectResourceTiming,this.returnDependencies=!!t.returnDependencies,this.promoteId=t.promoteId,this.inFlightDependencies=[];}parse(t,i,n,r,a){return e._(this,void 0,void 0,(function*(){this.status="parsing",this.data=t,this.collisionBoxArray=new e.ag;const l=new e.cN(Object.keys(t.layers).sort()),c=new e.cO(this.tileID,this.promoteId);c.bucketLayerIDs=[];const h={},u={featureIndex:c,iconDependencies:{},patternDependencies:{},glyphDependencies:{},dashDependencies:{},availableImages:n,subdivisionGranularity:a},d=i.familiesBySource[this.source];for(const o in d){const i=t.layers[o];if(!i)continue;1===i.version&&e.w(`Vector tile source "${this.source}" layer "${o}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const r=l.encode(o),a=[];for(let e=0;e<i.length;e++){const t=i.feature(e),s=c.getId(t,o);a.push({feature:t,id:s,index:e,sourceLayerIndex:r});}for(const t of d[o]){const o=t[0];o.source!==this.source&&e.w(`layer.source = ${o.source} does not equal this.source = ${this.source}`),o.isHidden(this.zoom,!0)||(s(t,this.zoom,n),(h[o.id]=o.createBucket({index:c.bucketLayerIDs.length,layers:t,zoom:this.zoom,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:r,sourceID:this.source})).populate(a,u,this.tileID.canonical),c.bucketLayerIDs.push(t.map((e=>e.id))));}}const g=e.bY(u.glyphDependencies,(e=>Object.keys(e).map(Number)));this.inFlightDependencies.forEach((e=>null==e?void 0:e.abort())),this.inFlightDependencies=[];let f=Promise.resolve({});if(Object.keys(g).length){const e=new AbortController;this.inFlightDependencies.push(e),f=r.sendAsync({type:"GG",data:{stacks:g,source:this.source,tileID:this.tileID,type:"glyphs"}},e);}const p=Object.keys(u.iconDependencies);let m=Promise.resolve({});if(p.length){const e=new AbortController;this.inFlightDependencies.push(e),m=r.sendAsync({type:"GI",data:{icons:p,source:this.source,tileID:this.tileID,type:"icons"}},e);}const y=Object.keys(u.patternDependencies);let v=Promise.resolve({});if(y.length){const e=new AbortController;this.inFlightDependencies.push(e),v=r.sendAsync({type:"GI",data:{icons:y,source:this.source,tileID:this.tileID,type:"patterns"}},e);}const x=u.dashDependencies;let _=Promise.resolve({});if(Object.keys(x).length){const e=new AbortController;this.inFlightDependencies.push(e),_=r.sendAsync({type:"GDA",data:{dashes:x}},e);}const[w,S,b,M]=yield Promise.all([f,m,v,_]),I=new o(w),P=new e.cP(S,b);for(const t in h){const o=h[t];o instanceof e.ah?(s(o.layers,this.zoom,n),e.cQ({bucket:o,glyphMap:w,glyphPositions:I.positions,imageMap:S,imagePositions:P.iconPositions,showCollisionBoxes:this.showCollisionBoxes,canonical:this.tileID.canonical,subdivisionGranularity:u.subdivisionGranularity})):o.hasDependencies&&(o instanceof e.cR||o instanceof e.cS||o instanceof e.cT)&&(s(o.layers,this.zoom,n),o.addFeatures(u,this.tileID.canonical,P.patternPositions,M));}return this.status="done",{buckets:Object.values(h).filter((e=>!e.isEmpty())),featureIndex:c,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:I.image,imageAtlas:P,dashPositions:M,glyphMap:this.returnDependencies?w:null,iconMap:this.returnDependencies?S:null,glyphPositions:this.returnDependencies?I.positions:null}}))}}function s(t,o,i){const s=new e.H(o);for(const e of t)e.recalculate(s,i);}class n{constructor(e,t,o,i,s){this.type=e,this.properties=o||{},this.extent=s,this.pointsArray=t,this.id=i;}loadGeometry(){return this.pointsArray.map((t=>t.map((t=>new e.P(t.x,t.y)))))}}class r{constructor(e,t,o){this.version=2,this._myFeatures=e,this.name=t,this.length=e.length,this.extent=o;}feature(e){return this._myFeatures[e]}}class a{constructor(){this.layers={};}addLayer(e){this.layers[e.name]=e;}}function l(t){let o=e.cU(t);return 0===o.byteOffset&&o.byteLength===o.buffer.byteLength||(o=new Uint8Array(o)),{vectorTile:t,rawData:o.buffer}}function c(t,o,i){const{extent:s}=t,a=Math.pow(2,i.z-o.z),l=(i.x-o.x*a)*s,c=(i.y-o.y*a)*s,h=[];for(let o=0;o<t.length;o++){const i=t.feature(o);let r=i.loadGeometry();for(const e of r)for(const t of e)t.x=t.x*a-l,t.y=t.y*a-c;const u=128;r=e.cV(r,i.type,-u,-u,s+u,s+u),0!==r.length&&h.push(new n(i.type,r,i.properties,i.id,s));}return new r(h,t.name,s)}class h{constructor(t,o,i){this.actor=t,this.layerIndex=o,this.availableImages=i,this.fetching={},this.loading={},this.loaded={},this.overzoomedTileResultCache=new e.cW(1e3);}loadVectorTile(t,o){return e._(this,void 0,void 0,(function*(){const i=yield e.n(t.request,o);try{return {vectorTile:"mlt"!==t.encoding?new e.cX(new e.cY(i.data)):new e.cZ(i.data),rawData:i.data,cacheControl:i.cacheControl,expires:i.expires}}catch(e){const o=new Uint8Array(i.data);let s=`Unable to parse the tile at ${t.request.url}, `;throw s+=31===o[0]&&139===o[1]?"please make sure the data is not gzipped and that you have configured the relevant header in the server":`got error: ${e.message}`,new Error(s)}}))}loadTile(t){return e._(this,void 0,void 0,(function*(){const{uid:o,overzoomParameters:s}=t;s&&(t.request=s.overzoomRequest);const n=!!(t&&t.request&&t.request.collectResourceTiming)&&new e.c_(t.request),r=new i(t);this.loading[o]=r;const a=new AbortController;r.abort=a;try{const i=yield this.loadVectorTile(t,a);if(delete this.loading[o],!i)return null;if(s){const e=this._getOverzoomTile(t,i.vectorTile);i.rawData=e.rawData,i.vectorTile=e.vectorTile;}const l=i.rawData,c={};i.expires&&(c.expires=i.expires),i.cacheControl&&(c.cacheControl=i.cacheControl);const h={};if(n){const e=n.finish();e&&(h.resourceTiming=JSON.parse(JSON.stringify(e)));}r.vectorTile=i.vectorTile;const u=r.parse(i.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity);this.loaded[o]=r,this.fetching[o]={rawTileData:l,cacheControl:c,resourceTiming:h};try{const o=yield u;return e.e({rawTileData:l.slice(0),encoding:t.encoding},o,c,h)}finally{delete this.fetching[o];}}catch(e){throw delete this.loading[o],r.status="done",this.loaded[o]=r,e}}))}_getOverzoomTile(e,t){const{tileID:o,source:i,overzoomParameters:s}=e,{maxZoomTileID:n}=s,r=`${n.key}_${o.key}`,h=this.overzoomedTileResultCache.get(r);if(h)return h;const u=new a,d=this.layerIndex.familiesBySource[i];for(const e in d){const i=t.layers[e];if(!i)continue;const s=c(i,n,o.canonical);s.length>0&&u.addLayer(s);}const g=l(u);return this.overzoomedTileResultCache.set(r,g),g}reloadTile(t){return e._(this,void 0,void 0,(function*(){const o=t.uid;if(!this.loaded||!this.loaded[o])throw new Error("Should not be trying to reload a tile that was never loaded or has been removed");const i=this.loaded[o];if(i.showCollisionBoxes=t.showCollisionBoxes,"parsing"===i.status){const s=yield i.parse(i.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity);let n;if(this.fetching[o]){const{rawTileData:i,cacheControl:r,resourceTiming:a}=this.fetching[o];delete this.fetching[o],n=e.e({rawTileData:i.slice(0),encoding:t.encoding},s,r,a);}else n=s;return n}if("done"===i.status&&i.vectorTile)return i.parse(i.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity)}))}abortTile(t){return e._(this,void 0,void 0,(function*(){const e=this.loading,o=t.uid;e&&e[o]&&e[o].abort&&(e[o].abort.abort(),delete e[o]);}))}removeTile(t){return e._(this,void 0,void 0,(function*(){this.loaded&&this.loaded[t.uid]&&delete this.loaded[t.uid];}))}}class u{constructor(){this.loaded={};}loadTile(t){return e._(this,void 0,void 0,(function*(){const{uid:o,encoding:i,rawImageData:s,redFactor:n,greenFactor:r,blueFactor:a,baseShift:l}=t,c=s.width+2,h=s.height+2,u=e.b(s)?new e.R({width:c,height:h},yield e.c$(s,-1,-1,c,h)):s,d=new e.d0(o,u,i,n,r,a,l);return this.loaded=this.loaded||{},this.loaded[o]=d,d}))}removeTile(e){const t=this.loaded,o=e.uid;t&&t[o]&&delete t[o];}}var d,g,f=function(){if(g)return d;function e(e,o){if(0!==e.length){t(e[0],o);for(var i=1;i<e.length;i++)t(e[i],!o);}}function t(e,t){for(var o=0,i=0,s=0,n=e.length,r=n-1;s<n;r=s++){var a=(e[s][0]-e[r][0])*(e[r][1]+e[s][1]),l=o+a;i+=Math.abs(o)>=Math.abs(a)?o-l+a:a-l+o,o=l;}o+i>=0!=!!t&&e.reverse();}return g=1,d=function t(o,i){var s,n=o&&o.type;if("FeatureCollection"===n)for(s=0;s<o.features.length;s++)t(o.features[s],i);else if("GeometryCollection"===n)for(s=0;s<o.geometries.length;s++)t(o.geometries[s],i);else if("Feature"===n)t(o.geometry,i);else if("Polygon"===n)e(o.coordinates,i);else if("MultiPolygon"===n)for(s=0;s<o.coordinates.length;s++)e(o.coordinates[s],i);return o}}(),p=e.d1(f);const m={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},y=Math.fround||(v=new Float32Array(1),e=>(v[0]=+e,v[0]));var v;class x{constructor(e){this.options=Object.assign(Object.create(m),e),this.trees=new Array(this.options.maxZoom+1),this.stride=this.options.reduce?7:6,this.clusterProps=[];}load(e){const{log:t,minZoom:o,maxZoom:i}=this.options;t&&console.time("total time");const s=`prepare ${e.length} points`;t&&console.time(s),this.points=e;const n=[];for(let t=0;t<e.length;t++){const o=e[t];if(!o.geometry)continue;const[i,s]=o.geometry.coordinates,r=y(S(i)),a=y(b(s));n.push(r,a,1/0,t,-1,1),this.options.reduce&&n.push(0);}let r=this.trees[i+1]=this._createTree(n);t&&console.timeEnd(s);for(let e=i;e>=o;e--){const o=+Date.now();r=this.trees[e]=this._createTree(this._cluster(r,e)),t&&console.log("z%d: %d clusters in %dms",e,r.numItems,+Date.now()-o);}return t&&console.timeEnd("total time"),this}getClusters(e,t){let o=((e[0]+180)%360+360)%360-180;const i=Math.max(-90,Math.min(90,e[1]));let s=180===e[2]?180:((e[2]+180)%360+360)%360-180;const n=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)o=-180,s=180;else if(o>s){const e=this.getClusters([o,i,180,n],t),r=this.getClusters([-180,i,s,n],t);return e.concat(r)}const r=this.trees[this._limitZoom(t)],a=r.range(S(o),b(n),S(s),b(i)),l=r.data,c=[];for(const e of a){const t=this.stride*e;c.push(l[t+5]>1?_(l,t,this.clusterProps):this.points[l[t+3]]);}return c}getChildren(e){const t=this._getOriginId(e),o=this._getOriginZoom(e),i="No cluster with the specified id.",s=this.trees[o];if(!s)throw new Error(i);const n=s.data;if(t*this.stride>=n.length)throw new Error(i);const r=this.options.radius/(this.options.extent*Math.pow(2,o-1)),a=s.within(n[t*this.stride],n[t*this.stride+1],r),l=[];for(const t of a){const o=t*this.stride;n[o+4]===e&&l.push(n[o+5]>1?_(n,o,this.clusterProps):this.points[n[o+3]]);}if(0===l.length)throw new Error(i);return l}getLeaves(e,t,o){const i=[];return this._appendLeaves(i,e,t=t||10,o=o||0,0),i}getTile(e,t,o){const i=this.trees[this._limitZoom(e)],s=Math.pow(2,e),{extent:n,radius:r}=this.options,a=r/n,l=(o-a)/s,c=(o+1+a)/s,h={features:[]};return this._addTileFeatures(i.range((t-a)/s,l,(t+1+a)/s,c),i.data,t,o,s,h),0===t&&this._addTileFeatures(i.range(1-a/s,l,1,c),i.data,s,o,s,h),t===s-1&&this._addTileFeatures(i.range(0,l,a/s,c),i.data,-1,o,s,h),h.features.length?h:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const o=this.getChildren(e);if(t++,1!==o.length)break;e=o[0].properties.cluster_id;}return t}_appendLeaves(e,t,o,i,s){const n=this.getChildren(t);for(const t of n){const n=t.properties;if(n&&n.cluster?s+n.point_count<=i?s+=n.point_count:s=this._appendLeaves(e,n.cluster_id,o,i,s):s<i?s++:e.push(t),e.length===o)break}return s}_createTree(t){const o=new e.aT(t.length/this.stride|0,this.options.nodeSize,Float32Array);for(let e=0;e<t.length;e+=this.stride)o.add(t[e],t[e+1]);return o.finish(),o.data=t,o}_addTileFeatures(e,t,o,i,s,n){for(const r of e){const e=r*this.stride,a=t[e+5]>1;let l,c,h;if(a)l=w(t,e,this.clusterProps),c=t[e],h=t[e+1];else {const o=this.points[t[e+3]];l=o.properties;const[i,s]=o.geometry.coordinates;c=S(i),h=b(s);}const u={type:1,geometry:[[Math.round(this.options.extent*(c*s-o)),Math.round(this.options.extent*(h*s-i))]],tags:l};let d;d=a||this.options.generateId?t[e+3]:this.points[t[e+3]].id,void 0!==d&&(u.id=d),n.features.push(u);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(Math.floor(+e),this.options.maxZoom+1))}_cluster(e,t){const{radius:o,extent:i,reduce:s,minPoints:n}=this.options,r=o/(i*Math.pow(2,t)),a=e.data,l=[],c=this.stride;for(let o=0;o<a.length;o+=c){if(a[o+2]<=t)continue;a[o+2]=t;const i=a[o],h=a[o+1],u=e.within(a[o],a[o+1],r),d=a[o+5];let g=d;for(const e of u){const o=e*c;a[o+2]>t&&(g+=a[o+5]);}if(g>d&&g>=n){let e,n=i*d,r=h*d,f=-1;const p=(o/c<<5)+(t+1)+this.points.length;for(const i of u){const l=i*c;if(a[l+2]<=t)continue;a[l+2]=t;const h=a[l+5];n+=a[l]*h,r+=a[l+1]*h,a[l+4]=p,s&&(e||(e=this._map(a,o,!0),f=this.clusterProps.length,this.clusterProps.push(e)),s(e,this._map(a,l)));}a[o+4]=p,l.push(n/g,r/g,1/0,p,-1,g),s&&l.push(f);}else {for(let e=0;e<c;e++)l.push(a[o+e]);if(g>1)for(const e of u){const o=e*c;if(!(a[o+2]<=t)){a[o+2]=t;for(let e=0;e<c;e++)l.push(a[o+e]);}}}}return l}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t,o){if(e[t+5]>1){const i=this.clusterProps[e[t+6]];return o?Object.assign({},i):i}const i=this.points[e[t+3]].properties,s=this.options.map(i);return o&&s===i?Object.assign({},s):s}}function _(e,t,o){return {type:"Feature",id:e[t+3],properties:w(e,t,o),geometry:{type:"Point",coordinates:[(i=e[t],360*(i-.5)),M(e[t+1])]}};var i;}function w(e,t,o){const i=e[t+5],s=i>=1e4?`${Math.round(i/1e3)}k`:i>=1e3?Math.round(i/100)/10+"k":i,n=e[t+6],r=-1===n?{}:Object.assign({},o[n]);return Object.assign(r,{cluster:!0,cluster_id:e[t+3],point_count:i,point_count_abbreviated:s})}function S(e){return e/360+.5}function b(e){const t=Math.sin(e*Math.PI/180),o=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return o<0?0:o>1?1:o}function M(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function I(e,t,o,i){let s=i;const n=t+(o-t>>1);let r,a=o-t;const l=e[t],c=e[t+1],h=e[o],u=e[o+1];for(let i=t+3;i<o;i+=3){const t=P(e[i],e[i+1],l,c,h,u);if(t>s)r=i,s=t;else if(t===s){const e=Math.abs(i-n);e<a&&(r=i,a=e);}}s>i&&(r-t>3&&I(e,t,r,i),e[r+2]=s,o-r>3&&I(e,r,o,i));}function P(e,t,o,i,s,n){let r=s-o,a=n-i;if(0!==r||0!==a){const l=((e-o)*r+(t-i)*a)/(r*r+a*a);l>1?(o=s,i=n):l>0&&(o+=r*l,i+=a*l);}return r=e-o,a=t-i,r*r+a*a}function D(e,t,o,i){const s={id:null==e?null:e,type:t,geometry:o,tags:i,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};if("Point"===t||"MultiPoint"===t||"LineString"===t)T(s,o);else if("Polygon"===t)T(s,o[0]);else if("MultiLineString"===t)for(const e of o)T(s,e);else if("MultiPolygon"===t)for(const e of o)T(s,e[0]);return s}function T(e,t){for(let o=0;o<t.length;o+=3)e.minX=Math.min(e.minX,t[o]),e.minY=Math.min(e.minY,t[o+1]),e.maxX=Math.max(e.maxX,t[o]),e.maxY=Math.max(e.maxY,t[o+1]);}function k(e,t,o,i){if(!t.geometry)return;const s=t.geometry.coordinates;if(s&&0===s.length)return;const n=t.geometry.type,r=Math.pow(o.tolerance/((1<<o.maxZoom)*o.extent),2);let a=[],l=t.id;if(o.promoteId?l=t.properties[o.promoteId]:o.generateId&&(l=i||0),"Point"===n)C(s,a);else if("MultiPoint"===n)for(const e of s)C(e,a);else if("LineString"===n)O(s,a,r,!1);else if("MultiLineString"===n){if(o.lineMetrics){for(const o of s)a=[],O(o,a,r,!1),e.push(D(l,"LineString",a,t.properties));return}L(s,a,r,!1);}else if("Polygon"===n)L(s,a,r,!0);else {if("MultiPolygon"!==n){if("GeometryCollection"===n){for(const s of t.geometry.geometries)k(e,{id:l,geometry:s,properties:t.properties},o,i);return}throw new Error("Input data is not a valid GeoJSON object.")}for(const e of s){const t=[];L(e,t,r,!0),a.push(t);}}e.push(D(l,n,a,t.properties));}function C(e,t){t.push(z(e[0]),F(e[1]),0);}function O(e,t,o,i){let s,n,r=0;for(let o=0;o<e.length;o++){const a=z(e[o][0]),l=F(e[o][1]);t.push(a,l,0),o>0&&(r+=i?(s*l-a*n)/2:Math.sqrt(Math.pow(a-s,2)+Math.pow(l-n,2))),s=a,n=l;}const a=t.length-3;t[2]=1,I(t,0,a,o),t[a+2]=1,t.size=Math.abs(r),t.start=0,t.end=t.size;}function L(e,t,o,i){for(let s=0;s<e.length;s++){const n=[];O(e[s],n,o,i),t.push(n);}}function z(e){return e/360+.5}function F(e){const t=Math.sin(e*Math.PI/180),o=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return o<0?0:o>1?1:o}function G(e,t,o,i,s,n,r,a){if(i/=t,n>=(o/=t)&&r<i)return e;if(r<o||n>=i)return null;const l=[];for(const t of e){const e=t.geometry;let n=t.type;const r=0===s?t.minX:t.minY,c=0===s?t.maxX:t.maxY;if(r>=o&&c<i){l.push(t);continue}if(c<o||r>=i)continue;let h=[];if("Point"===n||"MultiPoint"===n)A(e,h,o,i,s);else if("LineString"===n)Z(e,h,o,i,s,!1,a.lineMetrics);else if("MultiLineString"===n)E(e,h,o,i,s,!1);else if("Polygon"===n)E(e,h,o,i,s,!0);else if("MultiPolygon"===n)for(const t of e){const e=[];E(t,e,o,i,s,!0),e.length&&h.push(e);}if(h.length){if(a.lineMetrics&&"LineString"===n){for(const e of h)l.push(D(t.id,n,e,t.tags));continue}"LineString"!==n&&"MultiLineString"!==n||(1===h.length?(n="LineString",h=h[0]):n="MultiLineString"),"Point"!==n&&"MultiPoint"!==n||(n=3===h.length?"Point":"MultiPoint"),l.push(D(t.id,n,h,t.tags));}}return l.length?l:null}function A(e,t,o,i,s){for(let n=0;n<e.length;n+=3){const r=e[n+s];r>=o&&r<=i&&j(t,e[n],e[n+1],e[n+2]);}}function Z(e,t,o,i,s,n,r){let a=R(e);const l=0===s?N:W;let c,h,u=e.start;for(let d=0;d<e.length-3;d+=3){const g=e[d],f=e[d+1],p=e[d+2],m=e[d+3],y=e[d+4],v=0===s?g:f,x=0===s?m:y;let _=!1;r&&(c=Math.sqrt(Math.pow(g-m,2)+Math.pow(f-y,2))),v<o?x>o&&(h=l(a,g,f,m,y,o),r&&(a.start=u+c*h)):v>i?x<i&&(h=l(a,g,f,m,y,i),r&&(a.start=u+c*h)):j(a,g,f,p),x<o&&v>=o&&(h=l(a,g,f,m,y,o),_=!0),x>i&&v<=i&&(h=l(a,g,f,m,y,i),_=!0),!n&&_&&(r&&(a.end=u+c*h),t.push(a),a=R(e)),r&&(u+=c);}let d=e.length-3;const g=e[d],f=e[d+1],p=0===s?g:f;p>=o&&p<=i&&j(a,g,f,e[d+2]),d=a.length-3,n&&d>=3&&(a[d]!==a[0]||a[d+1]!==a[1])&&j(a,a[0],a[1],a[2]),a.length&&t.push(a);}function R(e){const t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function E(e,t,o,i,s,n){for(const r of e)Z(r,t,o,i,s,n,!1);}function j(e,t,o,i){e.push(t,o,i);}function N(e,t,o,i,s,n){const r=(n-t)/(i-t);return j(e,n,o+(s-o)*r,1),r}function W(e,t,o,i,s,n){const r=(n-o)/(s-o);return j(e,t+(i-t)*r,n,1),r}function J(e,t){const o=[];for(let i=0;i<e.length;i++){const s=e[i],n=s.type;let r;if("Point"===n||"MultiPoint"===n||"LineString"===n)r=Y(s.geometry,t);else if("MultiLineString"===n||"Polygon"===n){r=[];for(const e of s.geometry)r.push(Y(e,t));}else if("MultiPolygon"===n){r=[];for(const e of s.geometry){const o=[];for(const i of e)o.push(Y(i,t));r.push(o);}}o.push(D(s.id,n,r,s.tags));}return o}function Y(e,t){const o=[];o.size=e.size,void 0!==e.start&&(o.start=e.start,o.end=e.end);for(let i=0;i<e.length;i+=3)o.push(e[i]+t,e[i+1],e[i+2]);return o}function q(e,t){if(e.transformed)return e;const o=1<<e.z,i=e.x,s=e.y;for(const n of e.features){const e=n.geometry,r=n.type;if(n.geometry=[],1===r)for(let r=0;r<e.length;r+=2)n.geometry.push(H(e[r],e[r+1],t,o,i,s));else for(let r=0;r<e.length;r++){const a=[];for(let n=0;n<e[r].length;n+=2)a.push(H(e[r][n],e[r][n+1],t,o,i,s));n.geometry.push(a);}}return e.transformed=!0,e}function H(e,t,o,i,s,n){return [Math.round(o*(e*i-s)),Math.round(o*(t*i-n))]}function X(e,t,o,i,s){const n=t===s.maxZoom?0:s.tolerance/((1<<t)*s.extent),r={features:[],numPoints:0,numSimplified:0,numFeatures:e.length,source:null,x:o,y:i,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0};for(const t of e)B(r,t,n,s);return r}function B(e,t,o,i){const s=t.geometry,n=t.type,r=[];if(e.minX=Math.min(e.minX,t.minX),e.minY=Math.min(e.minY,t.minY),e.maxX=Math.max(e.maxX,t.maxX),e.maxY=Math.max(e.maxY,t.maxY),"Point"===n||"MultiPoint"===n)for(let t=0;t<s.length;t+=3)r.push(s[t],s[t+1]),e.numPoints++,e.numSimplified++;else if("LineString"===n)$(r,s,e,o,!1,!1);else if("MultiLineString"===n||"Polygon"===n)for(let t=0;t<s.length;t++)$(r,s[t],e,o,"Polygon"===n,0===t);else if("MultiPolygon"===n)for(let t=0;t<s.length;t++){const i=s[t];for(let t=0;t<i.length;t++)$(r,i[t],e,o,!0,0===t);}if(r.length){let o=t.tags||null;if("LineString"===n&&i.lineMetrics){o={};for(const e in t.tags)o[e]=t.tags[e];o.mapbox_clip_start=s.start/s.size,o.mapbox_clip_end=s.end/s.size;}const a={geometry:r,type:"Polygon"===n||"MultiPolygon"===n?3:"LineString"===n||"MultiLineString"===n?2:1,tags:o};null!==t.id&&(a.id=t.id),e.features.push(a);}}function $(e,t,o,i,s,n){const r=i*i;if(i>0&&t.size<(s?r:i))return void(o.numPoints+=t.length/3);const a=[];for(let e=0;e<t.length;e+=3)(0===i||t[e+2]>r)&&(o.numSimplified++,a.push(t[e],t[e+1])),o.numPoints++;s&&function(e,t){let o=0;for(let t=0,i=e.length,s=i-2;t<i;s=t,t+=2)o+=(e[t]-e[s])*(e[t+1]+e[s+1]);if(o>0===t)for(let t=0,o=e.length;t<o/2;t+=2){const i=e[t],s=e[t+1];e[t]=e[o-2-t],e[t+1]=e[o-1-t],e[o-2-t]=i,e[o-1-t]=s;}}(a,n),e.push(a);}const U={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0};class V{constructor(e,t){const o=(t=this.options=function(e,t){for(const o in t)e[o]=t[o];return e}(Object.create(U),t)).debug;if(o&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");let i=function(e,t){const o=[];if("FeatureCollection"===e.type)for(let i=0;i<e.features.length;i++)k(o,e.features[i],t,i);else k(o,"Feature"===e.type?e:{geometry:e},t);return o}(e,t);this.tiles={},this.tileCoords=[],o&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),i=function(e,t){const o=t.buffer/t.extent;let i=e;const s=G(e,1,-1-o,o,0,-1,2,t),n=G(e,1,1-o,2+o,0,-1,2,t);return (s||n)&&(i=G(e,1,-o,1+o,0,-1,2,t)||[],s&&(i=J(s,1).concat(i)),n&&(i=i.concat(J(n,-1)))),i}(i,t),i.length&&this.splitTile(i,0,0,0),o&&(i.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}splitTile(e,t,o,i,s,n,r){const a=[e,t,o,i],l=this.options,c=l.debug;for(;a.length;){i=a.pop(),o=a.pop(),t=a.pop(),e=a.pop();const h=1<<t,u=K(t,o,i);let d=this.tiles[u];if(!d&&(c>1&&console.time("creation"),d=this.tiles[u]=X(e,t,o,i,l),this.tileCoords.push({z:t,x:o,y:i}),c)){c>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,o,i,d.numFeatures,d.numPoints,d.numSimplified),console.timeEnd("creation"));const e=`z${t}`;this.stats[e]=(this.stats[e]||0)+1,this.total++;}if(d.source=e,null==s){if(t===l.indexMaxZoom||d.numPoints<=l.indexMaxPoints)continue}else {if(t===l.maxZoom||t===s)continue;if(null!=s){const e=s-t;if(o!==n>>e||i!==r>>e)continue}}if(d.source=null,0===e.length)continue;c>1&&console.time("clipping");const g=.5*l.buffer/l.extent,f=.5-g,p=.5+g,m=1+g;let y=null,v=null,x=null,_=null,w=G(e,h,o-g,o+p,0,d.minX,d.maxX,l),S=G(e,h,o+f,o+m,0,d.minX,d.maxX,l);e=null,w&&(y=G(w,h,i-g,i+p,1,d.minY,d.maxY,l),v=G(w,h,i+f,i+m,1,d.minY,d.maxY,l),w=null),S&&(x=G(S,h,i-g,i+p,1,d.minY,d.maxY,l),_=G(S,h,i+f,i+m,1,d.minY,d.maxY,l),S=null),c>1&&console.timeEnd("clipping"),a.push(y||[],t+1,2*o,2*i),a.push(v||[],t+1,2*o,2*i+1),a.push(x||[],t+1,2*o+1,2*i),a.push(_||[],t+1,2*o+1,2*i+1);}}getTile(e,t,o){e=+e,t=+t,o=+o;const i=this.options,{extent:s,debug:n}=i;if(e<0||e>24)return null;const r=1<<e,a=K(e,t=t+r&r-1,o);if(this.tiles[a])return q(this.tiles[a],s);n>1&&console.log("drilling down to z%d-%d-%d",e,t,o);let l,c=e,h=t,u=o;for(;!l&&c>0;)c--,h>>=1,u>>=1,l=this.tiles[K(c,h,u)];return l&&l.source?(n>1&&(console.log("found parent tile z%d-%d-%d",c,h,u),console.time("drilling down")),this.splitTile(l.source,c,h,u,e,t,o),n>1&&console.timeEnd("drilling down"),this.tiles[a]?q(this.tiles[a],s):null):null}}function K(e,t,o){return 32*((1<<e)*o+t)+e}class Q extends h{constructor(e,t,o,i=ee){super(e,t,o),this._dataUpdateable=new Map,this._createGeoJSONIndex=i;}loadVectorTile(t,o){return e._(this,void 0,void 0,(function*(){const o=t.tileID.canonical;if(!this._geoJSONIndex)throw new Error("Unable to parse the data into a cluster or geojson");const i=this._geoJSONIndex.getTile(o.z,o.x,o.y);return i?l(new e.d2(i.features,{version:2,extent:e.a5})):null}))}loadData(t){return e._(this,void 0,void 0,(function*(){var o;null===(o=this._pendingRequest)||void 0===o||o.abort();const i=this._startPerformance(t);this._pendingRequest=new AbortController;try{(!this._pendingData||t.request||t.data||t.dataDiff)&&(this._pendingData=this.loadAndProcessGeoJSON(t,this._pendingRequest));const e=yield this._pendingData;this._geoJSONIndex=this._createGeoJSONIndex(e,t),this.loaded={};const o={};return t.request&&(o.data=e),this._finishPerformance(i,t,o),o}catch(t){if(delete this._pendingRequest,e.Z(t))return {abandoned:!0};throw t}}))}_startPerformance(t){var o;if(null===(o=null==t?void 0:t.request)||void 0===o?void 0:o.collectResourceTiming)return new e.c_(t.request)}_finishPerformance(e,t,o){if(!e)return;const i=e.finish();i&&(o.resourceTiming={},o.resourceTiming[t.source]=JSON.parse(JSON.stringify(i)));}getData(){return e._(this,void 0,void 0,(function*(){return this._pendingData}))}reloadTile(e){const t=this.loaded;return t&&t[e.uid]?super.reloadTile(e):this.loadTile(e)}loadAndProcessGeoJSON(t,o){return e._(this,void 0,void 0,(function*(){let e;if(t.request?e=yield this.loadGeoJSONFromUrl(t.request,t.promoteId,o):t.data?e=this._loadGeoJSONFromObject(t.data,t.promoteId):t.dataDiff&&(e=this._loadGeoJSONFromDiff(t.dataDiff,t.promoteId,t.source)),delete this._pendingRequest,"object"!=typeof e)throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`);return p(e,!0),t.filter&&(e=this._filterGeoJSON(e,t.filter)),e}))}loadGeoJSONFromUrl(t,o,i){return e._(this,void 0,void 0,(function*(){const s=yield e.j(t,i);return this._dataUpdateable=e.a7(s.data,o),s.data}))}_loadGeoJSONFromObject(t,o){return this._dataUpdateable=e.a7(t,o),t}_loadGeoJSONFromDiff(t,o,i){if(!this._dataUpdateable)throw new Error(`Cannot update existing geojson data in ${i}`);e.a8(this._dataUpdateable,t,o);const s=Array.from(this._dataUpdateable.values());return this._toFeatureCollection(s)}_filterGeoJSON(t,o){const i=e.d3(o,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===i.result)throw new Error(i.value.map((e=>`${e.key}: ${e.message}`)).join(", "));const s=t.features.filter((e=>i.value.evaluate({zoom:0},e)));return this._toFeatureCollection(s)}_toFeatureCollection(e){return {type:"FeatureCollection",features:e}}removeSource(t){return e._(this,void 0,void 0,(function*(){this._pendingRequest&&this._pendingRequest.abort();}))}getClusterExpansionZoom(e){return this._geoJSONIndex.getClusterExpansionZoom(e.clusterId)}getClusterChildren(e){return this._geoJSONIndex.getChildren(e.clusterId)}getClusterLeaves(e){return this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset)}}function ee(t,o){return o.cluster?new x(function({superclusterOptions:t,clusterProperties:o}){if(!o||!t)return t;const i={},s={},n={accumulated:null,zoom:0},r={properties:null},a=Object.keys(o);for(const t of a){const[n,r]=o[t],a=e.d3(r),l=e.d3("string"==typeof n?[n,["accumulated"],["get",t]]:n);i[t]=a.value,s[t]=l.value;}return t.map=e=>{r.properties=e;const t={};for(const e of a)t[e]=i[e].evaluate(n,r);return t},t.reduce=(e,t)=>{r.properties=t;for(const t of a)n.accumulated=e[t],e[t]=s[t].evaluate(n,r);},t}(o)).load(t.features):function(e,t){return new V(e,t)}(t,o.geojsonVtOptions)}class te{constructor(t){this.self=t,this.actor=new e.L(t),this.layerIndexes={},this.availableImages={},this.workerSources={},this.demWorkerSources={},this.externalWorkerSourceTypes={},this.globalStates=new Map,this.self.registerWorkerSource=(e,t)=>{if(this.externalWorkerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.externalWorkerSourceTypes[e]=t;},this.self.addProtocol=e.cJ,this.self.removeProtocol=e.cK,this.self.registerRTLTextPlugin=t=>{e.d4.setMethods(t);},this.actor.registerMessageHandler("LDT",((e,t)=>this._getDEMWorkerSource(e,t.source).loadTile(t))),this.actor.registerMessageHandler("RDT",((t,o)=>e._(this,void 0,void 0,(function*(){this._getDEMWorkerSource(t,o.source).removeTile(o);})))),this.actor.registerMessageHandler("GCEZ",((t,o)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,o.type,o.source).getClusterExpansionZoom(o)})))),this.actor.registerMessageHandler("GCC",((t,o)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,o.type,o.source).getClusterChildren(o)})))),this.actor.registerMessageHandler("GCL",((t,o)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,o.type,o.source).getClusterLeaves(o)})))),this.actor.registerMessageHandler("LD",((e,t)=>this._getWorkerSource(e,t.type,t.source).loadData(t))),this.actor.registerMessageHandler("GD",((e,t)=>this._getWorkerSource(e,t.type,t.source).getData())),this.actor.registerMessageHandler("LT",((e,t)=>this._getWorkerSource(e,t.type,t.source).loadTile(t))),this.actor.registerMessageHandler("RT",((e,t)=>this._getWorkerSource(e,t.type,t.source).reloadTile(t))),this.actor.registerMessageHandler("AT",((e,t)=>this._getWorkerSource(e,t.type,t.source).abortTile(t))),this.actor.registerMessageHandler("RMT",((e,t)=>this._getWorkerSource(e,t.type,t.source).removeTile(t))),this.actor.registerMessageHandler("RS",((t,o)=>e._(this,void 0,void 0,(function*(){if(!this.workerSources[t]||!this.workerSources[t][o.type]||!this.workerSources[t][o.type][o.source])return;const e=this.workerSources[t][o.type][o.source];delete this.workerSources[t][o.type][o.source],void 0!==e.removeSource&&e.removeSource(o);})))),this.actor.registerMessageHandler("RM",(t=>e._(this,void 0,void 0,(function*(){delete this.layerIndexes[t],delete this.availableImages[t],delete this.workerSources[t],delete this.demWorkerSources[t],this.globalStates.delete(t);})))),this.actor.registerMessageHandler("SR",((t,o)=>e._(this,void 0,void 0,(function*(){this.referrer=o;})))),this.actor.registerMessageHandler("SRPS",((e,t)=>this._syncRTLPluginState(e,t))),this.actor.registerMessageHandler("IS",((t,o)=>e._(this,void 0,void 0,(function*(){this.self.importScripts(o);})))),this.actor.registerMessageHandler("SI",((e,t)=>this._setImages(e,t))),this.actor.registerMessageHandler("UL",((t,o)=>e._(this,void 0,void 0,(function*(){this._getLayerIndex(t).update(o.layers,o.removedIds,this._getGlobalState(t));})))),this.actor.registerMessageHandler("UGS",((t,o)=>e._(this,void 0,void 0,(function*(){const e=this._getGlobalState(t);for(const t in o)e[t]=o[t];})))),this.actor.registerMessageHandler("SL",((t,o)=>e._(this,void 0,void 0,(function*(){this._getLayerIndex(t).replace(o,this._getGlobalState(t));}))));}_getGlobalState(e){let t=this.globalStates.get(e);return t||(t={},this.globalStates.set(e,t)),t}_setImages(t,o){return e._(this,void 0,void 0,(function*(){this.availableImages[t]=o;for(const e in this.workerSources[t]){const i=this.workerSources[t][e];for(const e in i)i[e].availableImages=o;}}))}_syncRTLPluginState(t,o){return e._(this,void 0,void 0,(function*(){return yield e.d4.syncState(o,this.self.importScripts)}))}_getAvailableImages(e){let t=this.availableImages[e];return t||(t=[]),t}_getLayerIndex(e){let o=this.layerIndexes[e];return o||(o=this.layerIndexes[e]=new t),o}_getWorkerSource(e,t,o){if(this.workerSources[e]||(this.workerSources[e]={}),this.workerSources[e][t]||(this.workerSources[e][t]={}),!this.workerSources[e][t][o]){const i={sendAsync:(t,o)=>(t.targetMapId=e,this.actor.sendAsync(t,o))};switch(t){case "vector":this.workerSources[e][t][o]=new h(i,this._getLayerIndex(e),this._getAvailableImages(e));break;case "geojson":this.workerSources[e][t][o]=new Q(i,this._getLayerIndex(e),this._getAvailableImages(e));break;default:this.workerSources[e][t][o]=new this.externalWorkerSourceTypes[t](i,this._getLayerIndex(e),this._getAvailableImages(e));}}return this.workerSources[e][t][o]}_getDEMWorkerSource(e,t){return this.demWorkerSources[e]||(this.demWorkerSources[e]={}),this.demWorkerSources[e][t]||(this.demWorkerSources[e][t]=new u),this.demWorkerSources[e][t]}}return e.i(self)&&(self.worker=new te(self)),te}));

define("index",["exports","./shared"],(function(e,t){"use strict";var i="5.16.0";function a(){var e=new t.A(4);return t.A!=Float32Array&&(e[1]=0,e[2]=0),e[0]=1,e[3]=1,e}let r,o,s;const n={frame(e,i,a){const r=requestAnimationFrame((e=>{o(),i(e);})),{unsubscribe:o}=t.s(e.signal,"abort",(()=>{o(),cancelAnimationFrame(r),a(new t.a(e.signal.reason));}),!1);},frameAsync(e){return new Promise(((t,i)=>{this.frame(e,t,i);}))},getImageData(e,t=0){return this.getImageCanvasContext(e).getImageData(-t,-t,e.width+2*t,e.height+2*t)},getImageCanvasContext(e){const t=window.document.createElement("canvas"),i=t.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return t.width=e.width,t.height=e.height,i.drawImage(e,0,0,e.width,e.height),i},resolveURL:e=>(r||(r=document.createElement("a")),r.href=e,r.href),hardwareConcurrency:"undefined"!=typeof navigator&&navigator.hardwareConcurrency||4,get prefersReducedMotion(){return void 0!==s?s:!!matchMedia&&(null==o&&(o=matchMedia("(prefers-reduced-motion: reduce)")),o.matches)},set prefersReducedMotion(e){s=e;}},l=new class{constructor(){this._realTime="undefined"!=typeof performance&&performance&&performance.now?performance.now.bind(performance):Date.now.bind(Date),this._frozenAt=null;}getCurrentTime(){return null!==this._frozenAt?this._frozenAt:this._realTime()}setNow(e){this._frozenAt=e;}restoreNow(){this._frozenAt=null;}isFrozen(){return null!==this._frozenAt}};function c(){return l.getCurrentTime()}class h{static testProp(e){if(!h.docStyle)return e[0];for(let t=0;t<e.length;t++)if(e[t]in h.docStyle)return e[t];return e[0]}static create(e,t,i){const a=window.document.createElement(e);return void 0!==t&&(a.className=t),i&&i.appendChild(a),a}static createNS(e,t){return window.document.createElementNS(e,t)}static disableDrag(){h.docStyle&&h.selectProp&&(h.userSelect=h.docStyle[h.selectProp],h.docStyle[h.selectProp]="none");}static enableDrag(){h.docStyle&&h.selectProp&&(h.docStyle[h.selectProp]=h.userSelect);}static setTransform(e,t){e.style[h.transformProp]=t;}static addEventListener(e,t,i,a={}){e.addEventListener(t,i,"passive"in a?a:a.capture);}static removeEventListener(e,t,i,a={}){e.removeEventListener(t,i,"passive"in a?a:a.capture);}static suppressClickInternal(e){e.preventDefault(),e.stopPropagation(),window.removeEventListener("click",h.suppressClickInternal,!0);}static suppressClick(){window.addEventListener("click",h.suppressClickInternal,!0),window.setTimeout((()=>{window.removeEventListener("click",h.suppressClickInternal,!0);}),0);}static getScale(e){const t=e.getBoundingClientRect();return {x:t.width/e.offsetWidth||1,y:t.height/e.offsetHeight||1,boundingClientRect:t}}static getPoint(e,i,a){const r=i.boundingClientRect;return new t.P((a.clientX-r.left)/i.x-e.clientLeft,(a.clientY-r.top)/i.y-e.clientTop)}static mousePos(e,t){const i=h.getScale(e);return h.getPoint(e,i,t)}static touchPos(e,t){const i=[],a=h.getScale(e);for(let r=0;r<t.length;r++)i.push(h.getPoint(e,a,t[r]));return i}static mouseButton(e){return e.button}static remove(e){e.parentNode&&e.parentNode.removeChild(e);}static sanitize(e){const t=(new DOMParser).parseFromString(e,"text/html").body||document.createElement("body"),i=t.querySelectorAll("script");for(const e of i)e.remove();return h.clean(t),t.innerHTML}static isPossiblyDangerous(e,t){const i=t.replace(/\s+/g,"").toLowerCase();return !(!["src","href","xlink:href"].includes(e)||!i.includes("javascript:")&&!i.includes("data:"))||!!e.startsWith("on")||void 0}static clean(e){const t=e.children;for(const e of t)h.removeAttributes(e),h.clean(e);}static removeAttributes(e){for(const{name:t,value:i}of e.attributes)h.isPossiblyDangerous(t,i)&&e.removeAttribute(t);}}h.docStyle="undefined"!=typeof window&&window.document&&window.document.documentElement.style,h.selectProp=h.testProp(["userSelect","MozUserSelect","WebkitUserSelect","msUserSelect"]),h.transformProp=h.testProp(["transform","WebkitTransform"]);const u={supported:!1,testSupport:function(e){!p&&_&&(m?f(e):d=e);}};let d,_,p=!1,m=!1;function f(e){const t=e.createTexture();e.bindTexture(e.TEXTURE_2D,t);try{if(e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,_),e.isContextLost())return;u.supported=!0;}catch(e){}e.deleteTexture(t),p=!0;}var g;"undefined"!=typeof document&&(_=document.createElement("img"),_.onload=()=>{d&&f(d),d=null,m=!0;},_.onerror=()=>{p=!0,d=null;},_.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA="),function(e){let i,a,r,o;e.resetRequestQueue=()=>{i=[],a=0,r=0,o={};},e.addThrottleControl=e=>{const t=r++;return o[t]=e,t},e.removeThrottleControl=e=>{delete o[e],n();},e.getImage=(e,a,r=!0)=>new Promise(((o,s)=>{u.supported&&(e.headers||(e.headers={}),e.headers.accept="image/webp,*/*"),t.e(e,{type:"image"}),i.push({abortController:a,requestParameters:e,supportImageRefresh:r,state:"queued",onError:e=>{s(e);},onSuccess:e=>{o(e);}}),n();}));const s=e=>t._(this,void 0,void 0,(function*(){e.state="running";const{requestParameters:i,supportImageRefresh:r,onError:o,onSuccess:s,abortController:c}=e,h=!1===r&&!t.i(self)&&!t.g(i.url)&&(!i.headers||Object.keys(i.headers).reduce(((e,t)=>e&&"accept"===t),!0));a++;const u=h?l(i,c):t.m(i,c);try{const i=yield u;delete e.abortController,e.state="completed",i.data instanceof HTMLImageElement||t.b(i.data)?s(i):i.data&&s({data:yield(d=i.data,"function"==typeof createImageBitmap?t.f(d):t.h(d)),cacheControl:i.cacheControl,expires:i.expires});}catch(t){delete e.abortController,o(t);}finally{a--,n();}var d;})),n=()=>{const e=(()=>{for(const e of Object.keys(o))if(o[e]())return !0;return !1})()?t.c.MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:t.c.MAX_PARALLEL_IMAGE_REQUESTS;for(let t=a;t<e&&i.length>0;t++){const e=i.shift();e.abortController.signal.aborted?t--:s(e);}},l=(e,i)=>new Promise(((a,r)=>{const o=new Image,s=e.url,n=e.credentials;n&&"include"===n?o.crossOrigin="use-credentials":(n&&"same-origin"===n||!t.d(s))&&(o.crossOrigin="anonymous"),i.signal.addEventListener("abort",(()=>{o.src="",r(new t.a(i.signal.reason));})),o.fetchPriority="high",o.onload=()=>{o.onerror=o.onload=null,a({data:o});},o.onerror=()=>{o.onerror=o.onload=null,i.signal.aborted||r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));},o.src=s;}));}(g||(g={})),g.resetRequestQueue();class v{constructor(e){this._transformRequestFn=null!=e?e:null;}transformRequest(e,t){return this._transformRequestFn&&this._transformRequestFn(e,t)||{url:e}}setTransformRequest(e){this._transformRequestFn=e;}}function x(e){const t=[];if("string"==typeof e)t.push({id:"default",url:e});else if(e&&e.length>0){const i=[];for(const{id:a,url:r}of e){const e=`${a}${r}`;-1===i.indexOf(e)&&(i.push(e),t.push({id:a,url:r}));}}return t}function b(e,t,i){try{const a=new URL(e);return a.pathname+=`${t}${i}`,a.toString()}catch(t){throw new Error(`Invalid sprite URL "${e}", must be absolute. Modify style specification directly or use TransformStyleFunction to correct the issue dynamically`)}}function y(e){const{userImage:t}=e;return !!(t&&t.render&&t.render())&&(e.data.replace(new Uint8Array(t.data.buffer)),!0)}class w extends t.E{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new t.R({width:1,height:1}),this.dirty=!0;}destroy(){this.atlasTexture&&(this.atlasTexture.destroy(),this.atlasTexture=null);for(const e of Object.keys(this.images))this.removeImage(e);this.patterns={},this.atlasImage=new t.R({width:1,height:1}),this.dirty=!0;}isLoaded(){return this.loaded}setLoaded(e){if(this.loaded!==e&&(this.loaded=e,e)){for(const{ids:e,promiseResolve:t}of this.requestors)t(this._getImagesForIds(e));this.requestors=[];}}getImage(e){const i=this.images[e];if(i&&!i.data&&i.spriteData){const e=i.spriteData;i.data=new t.R({width:e.width,height:e.height},e.context.getImageData(e.x,e.y,e.width,e.height).data),i.spriteData=null;}return i}addImage(e,t){if(this.images[e])throw new Error(`Image id ${e} already exist, use updateImage instead`);this._validate(e,t)&&(this.images[e]=t);}_validate(e,i){let a=!0;const r=i.data||i.spriteData;return this._validateStretch(i.stretchX,r&&r.width)||(this.fire(new t.k(new Error(`Image "${e}" has invalid "stretchX" value`))),a=!1),this._validateStretch(i.stretchY,r&&r.height)||(this.fire(new t.k(new Error(`Image "${e}" has invalid "stretchY" value`))),a=!1),this._validateContent(i.content,i)||(this.fire(new t.k(new Error(`Image "${e}" has invalid "content" value`))),a=!1),a}_validateStretch(e,t){if(!e)return !0;let i=0;for(const a of e){if(a[0]<i||a[1]<a[0]||t<a[1])return !1;i=a[1];}return !0}_validateContent(e,t){if(!e)return !0;if(4!==e.length)return !1;const i=t.spriteData,a=i&&i.width||t.data.width,r=i&&i.height||t.data.height;return !(e[0]<0||a<e[0]||e[1]<0||r<e[1]||e[2]<0||a<e[2]||e[3]<0||r<e[3]||e[2]<e[0]||e[3]<e[1])}updateImage(e,t,i=!0){const a=this.getImage(e);if(i&&(a.data.width!==t.data.width||a.data.height!==t.data.height))throw new Error(`size mismatch between old image (${a.data.width}x${a.data.height}) and new image (${t.data.width}x${t.data.height}).`);t.version=a.version+1,this.images[e]=t,this.updatedImages[e]=!0;}removeImage(e){const t=this.images[e];delete this.images[e],delete this.patterns[e],t.userImage&&t.userImage.onRemove&&t.userImage.onRemove();}listImages(){return Object.keys(this.images)}getImages(e){return new Promise(((t,i)=>{let a=!0;if(!this.isLoaded())for(const t of e)this.images[t]||(a=!1);this.isLoaded()||a?t(this._getImagesForIds(e)):this.requestors.push({ids:e,promiseResolve:t});}))}_getImagesForIds(e){const i={};for(const a of e){let e=this.getImage(a);e||(this.fire(new t.l("styleimagemissing",{id:a})),e=this.getImage(a)),e?i[a]={data:e.data.clone(),pixelRatio:e.pixelRatio,sdf:e.sdf,version:e.version,stretchX:e.stretchX,stretchY:e.stretchY,content:e.content,textFitWidth:e.textFitWidth,textFitHeight:e.textFitHeight,hasRenderCallback:Boolean(e.userImage&&e.userImage.render)}:t.w(`Image "${a}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`);}return i}getPixelSize(){const{width:e,height:t}=this.atlasImage;return {width:e,height:t}}getPattern(e){const i=this.patterns[e],a=this.getImage(e);if(!a)return null;if(i&&i.position.version===a.version)return i.position;if(i)i.position.version=a.version;else {const i={w:a.data.width+2,h:a.data.height+2,x:0,y:0},r=new t.I(i,a);this.patterns[e]={bin:i,position:r};}return this._updatePatternAtlas(),this.patterns[e].position}bind(e){const i=e.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new t.T(e,this.atlasImage,i.RGBA),this.atlasTexture.bind(i.LINEAR,i.CLAMP_TO_EDGE);}_updatePatternAtlas(){const e=[];for(const t in this.patterns)e.push(this.patterns[t].bin);const{w:i,h:a}=t.p(e),r=this.atlasImage;r.resize({width:i||1,height:a||1});for(const e in this.patterns){const{bin:i}=this.patterns[e],a=i.x+1,o=i.y+1,s=this.getImage(e).data,n=s.width,l=s.height;t.R.copy(s,r,{x:0,y:0},{x:a,y:o},{width:n,height:l}),t.R.copy(s,r,{x:0,y:l-1},{x:a,y:o-1},{width:n,height:1}),t.R.copy(s,r,{x:0,y:0},{x:a,y:o+l},{width:n,height:1}),t.R.copy(s,r,{x:n-1,y:0},{x:a-1,y:o},{width:1,height:l}),t.R.copy(s,r,{x:0,y:0},{x:a+n,y:o},{width:1,height:l});}this.dirty=!0;}beginFrame(){this.callbackDispatchedThisFrame={};}dispatchRenderCallbacks(e){for(const i of e){if(this.callbackDispatchedThisFrame[i])continue;this.callbackDispatchedThisFrame[i]=!0;const e=this.getImage(i);e||t.w(`Image with ID: "${i}" was not found`),y(e)&&this.updateImage(i,e);}}cloneImages(){const e={};for(const t in this.images){const i=this.images[t];e[t]=Object.assign(Object.assign({},i),{data:i.data?i.data.clone():null});}return e}}const T=1e20;function P(e,t,i,a,r,o,s,n,l){for(let c=t;c<t+a;c++)C(e,i*o+c,o,r,s,n,l);for(let c=i;c<i+r;c++)C(e,c*o+t,1,a,s,n,l);}function C(e,t,i,a,r,o,s){o[0]=0,s[0]=-T,s[1]=T,r[0]=e[t];for(let n=1,l=0,c=0;n<a;n++){r[n]=e[t+n*i];const a=n*n;do{const e=o[l];c=(r[n]-r[e]+a-e*e)/(n-e)/2;}while(c<=s[l]&&--l>-1);l++,o[l]=n,s[l]=c,s[l+1]=T;}for(let n=0,l=0;n<a;n++){for(;s[l+1]<n;)l++;const a=o[l],c=n-a;e[t+n*i]=r[a]+c*c;}}const I=t.v.layout_symbol["text-font"].default.join(",");class M{constructor(e,t,i){this.requestManager=e,this.localIdeographFontFamily=t,this.entries={},this.lang=i;}setURL(e){this.url=e;}getGlyphs(e){return t._(this,void 0,void 0,(function*(){const t=[];for(const i in e)for(const a of e[i])t.push(this._getAndCacheGlyphsPromise(i,a));const i=yield Promise.all(t),a={};for(const{stack:e,id:t,glyph:r}of i)a[e]||(a[e]={}),a[e][t]=r&&{id:r.id,bitmap:r.bitmap.clone(),metrics:r.metrics};return a}))}_getAndCacheGlyphsPromise(e,i){return t._(this,void 0,void 0,(function*(){let t=this.entries[e];t||(t=this.entries[e]={glyphs:{},requests:{},ranges:{}});let a=t.glyphs[i];return void 0!==a?{stack:e,id:i,glyph:a}:!this.url||this._charUsesLocalIdeographFontFamily(i)?(a=t.glyphs[i]=this._drawGlyph(t,e,i),{stack:e,id:i,glyph:a}):yield this._downloadAndCacheRangePromise(e,i)}))}_downloadAndCacheRangePromise(e,i){return t._(this,void 0,void 0,(function*(){const t=this.entries[e],a=Math.floor(i/256);if(t.ranges[a])return {stack:e,id:i,glyph:null};if(!t.requests[a]){const i=M.loadGlyphRange(e,a,this.url,this.requestManager);t.requests[a]=i;}try{const r=yield t.requests[a];for(const e in r)t.glyphs[+e]=r[+e];return t.ranges[a]=!0,{stack:e,id:i,glyph:r[i]||null}}catch(r){const o=t.glyphs[i]=this._drawGlyph(t,e,i);return this._warnOnMissingGlyphRange(o,a,i,r),{stack:e,id:i,glyph:o}}}))}_warnOnMissingGlyphRange(e,i,a,r){const o=256*i,s=o+255,n=a.toString(16).padStart(4,"0").toUpperCase();t.w(`Unable to load glyph range ${i}, ${o}-${s}. Rendering codepoint U+${n} locally instead. ${r}`);}_charUsesLocalIdeographFontFamily(e){return !!this.localIdeographFontFamily&&t.q(e)}_drawGlyph(e,i,a){const r=i===I&&""!==this.localIdeographFontFamily&&this._charUsesLocalIdeographFontFamily(a),o=r?"ideographTinySDF":"tinySDF";e[o]||(e[o]=this._createTinySDF(r?this.localIdeographFontFamily:i));const s=e[o].draw(String.fromCodePoint(a)),n=/^\p{gc=Cf}+$/u.test(String.fromCodePoint(a));return {id:a,bitmap:new t.r({width:s.width||60,height:s.height||60},s.data),metrics:{width:n?0:s.glyphWidth/2||24,height:s.glyphHeight/2||24,left:s.glyphLeft/2+.5||0,top:s.glyphTop/2-27.5||-8,advance:n?0:s.glyphAdvance/2||24,isDoubleResolution:!0}}}_createTinySDF(e){const t=e?e.split(","):[];t.push("sans-serif");const i=t.map((e=>/[-\w]+/.test(e)?e:`'${CSS.escape(e)}'`)).join(",");return new M.TinySDF({fontSize:48,buffer:6,radius:16,cutoff:.25,fontFamily:i,fontWeight:this._fontWeight(t[0]),fontStyle:this._fontStyle(t[0]),lang:this.lang})}_fontStyle(e){return /italic/i.test(e)?"italic":/oblique/i.test(e)?"oblique":"normal"}_fontWeight(e){const t={thin:100,hairline:100,"extra light":200,"ultra light":200,light:300,normal:400,regular:400,medium:500,semibold:600,demibold:600,bold:700,"extra bold":800,"ultra bold":800,black:900,heavy:900,"extra black":950,"ultra black":950};let i;for(const[a,r]of Object.entries(t))new RegExp(`\\b${a}\\b`,"i").test(e)&&(i=`${r}`);return i}destroy(){for(const e in this.entries){const t=this.entries[e];t.tinySDF&&(t.tinySDF=null),t.ideographTinySDF&&(t.ideographTinySDF=null),t.glyphs={},t.requests={},t.ranges={};}this.entries={};}}M.loadGlyphRange=function(e,i,a,r){return t._(this,void 0,void 0,(function*(){const o=256*i,s=o+255,n=r.transformRequest(a.replace("{fontstack}",e).replace("{range}",`${o}-${s}`),"Glyphs"),l=yield t.n(n,new AbortController);if(!l||!l.data)throw new Error(`Could not load glyph range. range: ${i}, ${o}-${s}`);const c={};for(const e of t.o(l.data))c[e.id]=e;return c}))},M.TinySDF=class{constructor({fontSize:e=24,buffer:t=3,radius:i=8,cutoff:a=.25,fontFamily:r="sans-serif",fontWeight:o="normal",fontStyle:s="normal",lang:n=null}={}){this.buffer=t,this.cutoff=a,this.radius=i,this.lang=n;const l=this.size=e+4*t,c=this._createCanvas(l),h=this.ctx=c.getContext("2d",{willReadFrequently:!0});h.font=`${s} ${o} ${e}px ${r}`,h.textBaseline="alphabetic",h.textAlign="left",h.fillStyle="black",this.gridOuter=new Float64Array(l*l),this.gridInner=new Float64Array(l*l),this.f=new Float64Array(l),this.z=new Float64Array(l+1),this.v=new Uint16Array(l);}_createCanvas(e){const t=document.createElement("canvas");return t.width=t.height=e,t}draw(e){const{width:t,actualBoundingBoxAscent:i,actualBoundingBoxDescent:a,actualBoundingBoxLeft:r,actualBoundingBoxRight:o}=this.ctx.measureText(e),s=Math.ceil(i),n=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(o-r))),l=Math.min(this.size-this.buffer,s+Math.ceil(a)),c=n+2*this.buffer,h=l+2*this.buffer,u=Math.max(c*h,0),d=new Uint8ClampedArray(u),_={data:d,width:c,height:h,glyphWidth:n,glyphHeight:l,glyphTop:s,glyphLeft:0,glyphAdvance:t};if(0===n||0===l)return _;const{ctx:p,buffer:m,gridInner:f,gridOuter:g}=this;this.lang&&(p.lang=this.lang),p.clearRect(m,m,n,l),p.fillText(e,m,m+s);const v=p.getImageData(m,m,n,l);g.fill(T,0,u),f.fill(0,0,u);for(let e=0;e<l;e++)for(let t=0;t<n;t++){const i=v.data[4*(e*n+t)+3]/255;if(0===i)continue;const a=(e+m)*c+t+m;if(1===i)g[a]=0,f[a]=T;else {const e=.5-i;g[a]=e>0?e*e:0,f[a]=e<0?e*e:0;}}P(g,0,0,c,h,c,this.f,this.v,this.z),P(f,m,m,n,l,c,this.f,this.v,this.z);for(let e=0;e<u;e++){const t=Math.sqrt(g[e])-Math.sqrt(f[e]);d[e]=Math.round(255-255*(t/this.radius+this.cutoff));}return _}};class E{constructor(){this.specification=t.u.light.position;}possiblyEvaluate(e,i){return t.F(e.expression.evaluate(i))}interpolate(e,i,a){return {x:t.G.number(e.x,i.x,a),y:t.G.number(e.y,i.y,a),z:t.G.number(e.z,i.z,a)}}}let S;class z extends t.E{constructor(e){super(),S=S||new t.t({anchor:new t.D(t.u.light.anchor),position:new E,color:new t.D(t.u.light.color),intensity:new t.D(t.u.light.intensity)}),this._transitionable=new t.x(S,void 0),this.setLight(e),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize()}setLight(e,i={}){if(!this._validate(t.y,e,i))for(const i in e){const a=e[i];i.endsWith(t.z)?this._transitionable.setTransition(i.slice(0,-t.z.length),a):this._transitionable.setValue(i,a);}}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(e,i,a){return (!a||!1!==a.validate)&&t.B(this,e.call(t.C,{value:i,style:{glyphs:!0,sprite:!0},styleSpec:t.u}))}}const R=new t.t({"sky-color":new t.D(t.u.sky["sky-color"]),"horizon-color":new t.D(t.u.sky["horizon-color"]),"fog-color":new t.D(t.u.sky["fog-color"]),"fog-ground-blend":new t.D(t.u.sky["fog-ground-blend"]),"horizon-fog-blend":new t.D(t.u.sky["horizon-fog-blend"]),"sky-horizon-blend":new t.D(t.u.sky["sky-horizon-blend"]),"atmosphere-blend":new t.D(t.u.sky["atmosphere-blend"])});class D extends t.E{constructor(e){super(),this._transitionable=new t.x(R,void 0),this.setSky(e),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new t.H(0));}setSky(e,i={}){if(!this._validate(t.J,e,i)){e||(e={"sky-color":"transparent","horizon-color":"transparent","fog-color":"transparent","fog-ground-blend":1,"atmosphere-blend":0});for(const i in e){const a=e[i];i.endsWith(t.z)?this._transitionable.setTransition(i.slice(0,-t.z.length),a):this._transitionable.setValue(i,a);}}}getSky(){return this._transitionable.serialize()}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(e,i,a={}){return !1!==(null==a?void 0:a.validate)&&t.B(this,e.call(t.C,t.e({value:i,style:{glyphs:!0,sprite:!0},styleSpec:t.u})))}calculateFogBlendOpacity(e){return e<60?0:e<70?(e-60)/10:1}}class A{constructor(e,t){this.width=e,this.height=t,this.nextRow=0,this.data=new Uint8Array(this.width*this.height),this.dashEntry={};}getDash(e,t){const i=e.join(",")+String(t);return this.dashEntry[i]||(this.dashEntry[i]=this.addDash(e,t)),this.dashEntry[i]}getDashRanges(e,t,i){const a=[];let r=e.length%2==1?-e[e.length-1]*i:0,o=e[0]*i,s=!0;a.push({left:r,right:o,isDash:s,zeroLength:0===e[0]});let n=e[0];for(let t=1;t<e.length;t++){s=!s;const l=e[t];r=n*i,n+=l,o=n*i,a.push({left:r,right:o,isDash:s,zeroLength:0===l});}return a}addRoundDash(e,t,i){const a=t/2;for(let t=-i;t<=i;t++){const r=this.width*(this.nextRow+i+t);let o=0,s=e[o];for(let n=0;n<this.width;n++){n/s.right>1&&(s=e[++o]);const l=Math.abs(n-s.left),c=Math.abs(n-s.right),h=Math.min(l,c);let u;const d=t/i*(a+1);if(s.isDash){const e=a-Math.abs(d);u=Math.sqrt(h*h+e*e);}else u=a-Math.sqrt(h*h+d*d);this.data[r+n]=Math.max(0,Math.min(255,u+128));}}}addRegularDash(e){for(let t=e.length-1;t>=0;--t){const i=e[t],a=e[t+1];i.zeroLength?e.splice(t,1):a&&a.isDash===i.isDash&&(a.left=i.left,e.splice(t,1));}const t=e[0],i=e[e.length-1];t.isDash===i.isDash&&(t.left=i.left-this.width,i.right=t.right+this.width);const a=this.width*this.nextRow;let r=0,o=e[r];for(let t=0;t<this.width;t++){t/o.right>1&&(o=e[++r]);const i=Math.abs(t-o.left),s=Math.abs(t-o.right),n=Math.min(i,s);this.data[a+t]=Math.max(0,Math.min(255,(o.isDash?n:-n)+128));}}addDash(e,i){const a=i?7:0,r=2*a+1;if(this.nextRow+r>this.height)return t.w("LineAtlas out of space"),null;let o=0;for(let t=0;t<e.length;t++)o+=e[t];if(0!==o){const t=this.width/o,r=this.getDashRanges(e,this.width,t);i?this.addRoundDash(r,t,a):this.addRegularDash(r);}const s={y:this.nextRow+a,height:2*a,width:o};return this.nextRow+=r,this.dirty=!0,s}bind(e){const t=e.gl;this.texture?(t.bindTexture(t.TEXTURE_2D,this.texture),this.dirty&&(this.dirty=!1,t.texSubImage2D(t.TEXTURE_2D,0,0,0,this.width,this.height,t.ALPHA,t.UNSIGNED_BYTE,this.data))):(this.texture=t.createTexture(),t.bindTexture(t.TEXTURE_2D,this.texture),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_S,t.REPEAT),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_T,t.REPEAT),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.LINEAR),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAG_FILTER,t.LINEAR),t.texImage2D(t.TEXTURE_2D,0,t.ALPHA,this.width,this.height,0,t.ALPHA,t.UNSIGNED_BYTE,this.data));}}const L="maplibre_preloaded_worker_pool";class k{constructor(){this.active={};}acquire(e){if(!this.workers)for(this.workers=[];this.workers.length<k.workerCount;)this.workers.push(new Worker(t.c.WORKER_URL));return this.active[e]=!0,this.workers.slice()}release(e){delete this.active[e],0===this.numActive()&&(this.workers.forEach((e=>{e.terminate();})),this.workers=null);}isPreloaded(){return !!this.active[L]}numActive(){return Object.keys(this.active).length}}const F=Math.floor(n.hardwareConcurrency/2);let B,O;function j(){return B||(B=new k),B}k.workerCount=t.K(globalThis)?Math.max(Math.min(F,3),1):1;class N{constructor(e,i){this.workerPool=e,this.actors=[],this.currentActor=0,this.id=i;const a=this.workerPool.acquire(i);for(let e=0;e<a.length;e++){const r=new t.L(a[e],i);r.name=`Worker ${e}`,this.actors.push(r);}if(!this.actors.length)throw new Error("No actors found")}broadcast(e,t){const i=[];for(const a of this.actors)i.push(a.sendAsync({type:e,data:t}));return Promise.all(i)}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(e=!0){this.actors.forEach((e=>{e.remove();})),this.actors=[],e&&this.workerPool.release(this.id);}registerMessageHandler(e,t){for(const i of this.actors)i.registerMessageHandler(e,t);}unregisterMessageHandler(e){for(const t of this.actors)t.unregisterMessageHandler(e);}}function Z(){return O||(O=new N(j(),t.M),O.registerMessageHandler("GR",((e,i,a)=>t.m(i,a)))),O}function G(e,i){const a=t.N();return t.O(a,a,[1,1,0]),t.Q(a,a,[.5*e.width,.5*e.height,1]),e.calculatePosMatrix?t.S(a,a,e.calculatePosMatrix(i.toUnwrapped())):a}function U(e,t,i,a,r,o,s){var n;const l=function(e,t,i){if(e)for(const a of e){const e=t[a];if(e&&e.source===i&&"fill-extrusion"===e.type)return !0}else for(const e in t){const a=t[e];if(a.source===i&&"fill-extrusion"===a.type)return !0}return !1}(null!==(n=null==r?void 0:r.layers)&&void 0!==n?n:null,t,e.id),c=o.maxPitchScaleFactor(),h=e.tilesIn(a,c,l);h.sort(V);const u=[];for(const a of h)u.push({wrappedTileID:a.tileID.wrapped().key,queryResults:a.tile.queryRenderedFeatures(t,i,e.getState(),a.queryGeometry,a.cameraQueryGeometry,a.scale,r,o,c,G(o,a.tileID),s?(e,t)=>s(a.tileID,e,t):void 0)});return function(e,t){for(const i in e)for(const a of e[i])q(a,t);return e}(function(e){const t={},i={};for(const a of e){const e=a.queryResults,r=a.wrappedTileID,o=i[r]=i[r]||{};for(const i in e){const a=e[i],r=o[i]=o[i]||{},s=t[i]=t[i]||[];for(const e of a)r[e.featureIndex]||(r[e.featureIndex]=!0,s.push(e));}}return t}(u),e)}function V(e,t){const i=e.tileID,a=t.tileID;return i.overscaledZ-a.overscaledZ||i.canonical.y-a.canonical.y||i.wrap-a.wrap||i.canonical.x-a.canonical.x}function q(e,t){const i=e.feature,a=t.getFeatureState(i.layer["source-layer"],i.id);i.source=i.layer.source,i.layer["source-layer"]&&(i.sourceLayer=i.layer["source-layer"]),i.state=a;}function W(e,i,a){return t._(this,void 0,void 0,(function*(){let r=e;if(e.url?r=(yield t.j(i.transformRequest(e.url,"Source"),a)).data:yield n.frameAsync(a),!r)return null;const o=t.U(t.e(r,e),["tiles","minzoom","maxzoom","attribution","bounds","scheme","tileSize","encoding"]);return "vector_layers"in r&&r.vector_layers&&(o.vectorLayerIds=r.vector_layers.map((e=>e.id))),o}))}class ${constructor(e,t){e&&(t?this.setSouthWest(e).setNorthEast(t):Array.isArray(e)&&(4===e.length?this.setSouthWest([e[0],e[1]]).setNorthEast([e[2],e[3]]):this.setSouthWest(e[0]).setNorthEast(e[1])));}setNorthEast(e){return this._ne=e instanceof t.V?new t.V(e.lng,e.lat):t.V.convert(e),this}setSouthWest(e){return this._sw=e instanceof t.V?new t.V(e.lng,e.lat):t.V.convert(e),this}extend(e){const i=this._sw,a=this._ne;let r,o;if(e instanceof t.V)r=e,o=e;else {if(!(e instanceof $))return Array.isArray(e)?4===e.length||e.every(Array.isArray)?this.extend($.convert(e)):this.extend(t.V.convert(e)):e&&("lng"in e||"lon"in e)&&"lat"in e?this.extend(t.V.convert(e)):this;if(r=e._sw,o=e._ne,!r||!o)return this}return i||a?(i.lng=Math.min(r.lng,i.lng),i.lat=Math.min(r.lat,i.lat),a.lng=Math.max(o.lng,a.lng),a.lat=Math.max(o.lat,a.lat)):(this._sw=new t.V(r.lng,r.lat),this._ne=new t.V(o.lng,o.lat)),this}getCenter(){return new t.V((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new t.V(this.getWest(),this.getNorth())}getSouthEast(){return new t.V(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(e){const{lng:i,lat:a}=t.V.convert(e);let r=this._sw.lng<=i&&i<=this._ne.lng;return this._sw.lng>this._ne.lng&&(r=this._sw.lng>=i&&i>=this._ne.lng),this._sw.lat<=a&&a<=this._ne.lat&&r}intersects(e){if(!((e=$.convert(e)).getNorth()>=this.getSouth()&&e.getSouth()<=this.getNorth()))return !1;const i=Math.abs(this.getEast()-this.getWest()),a=Math.abs(e.getEast()-e.getWest());if(i>=360||a>=360)return !0;const r=t.W(this.getWest(),-180,180),o=t.W(this.getEast(),-180,180),s=t.W(e.getWest(),-180,180),n=t.W(e.getEast(),-180,180),l=r>=o,c=s>=n;return !(!l||!c)||(l?n>=r||s<=o:c?o>=s||r<=n:s<=o&&n>=r)}static convert(e){return e instanceof $?e:e?new $(e):e}static fromLngLat(e,i=0){const a=360*i/40075017,r=a/Math.cos(Math.PI/180*e.lat);return new $(new t.V(e.lng-r,e.lat-a),new t.V(e.lng+r,e.lat+a))}adjustAntiMeridian(){const e=new t.V(this._sw.lng,this._sw.lat),i=new t.V(this._ne.lng,this._ne.lat);return new $(e,e.lng>i.lng?new t.V(i.lng+360,i.lat):i)}}class H{constructor(e,t,i){this.bounds=$.convert(this.validateBounds(e)),this.minzoom=t||0,this.maxzoom=i||24;}validateBounds(e){return Array.isArray(e)&&4===e.length?[Math.max(-180,e[0]),Math.max(-90,e[1]),Math.min(180,e[2]),Math.min(90,e[3])]:[-180,-90,180,90]}contains(e){const i=Math.pow(2,e.z),a=Math.floor(t.Y(this.bounds.getWest())*i),r=Math.floor(t.X(this.bounds.getNorth())*i),o=Math.ceil(t.Y(this.bounds.getEast())*i),s=Math.ceil(t.X(this.bounds.getSouth())*i);return e.x>=a&&e.x<o&&e.y>=r&&e.y<s}}class X extends t.E{constructor(e,i,a,r){if(super(),this.id=e,this.dispatcher=a,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,t.e(this,t.U(i,["url","scheme","tileSize","promoteId","encoding"])),this._options=t.e({type:"vector"},i),this._collectResourceTiming=i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(r);}load(){return t._(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new t.l("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const e=yield W(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,this.map.style.tileManagers[this.id].clearTiles(),e&&(t.e(this,e),e.bounds&&(this.tileBounds=new H(e.bounds,this.minzoom,this.maxzoom)),this.fire(new t.l("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new t.l("data",{dataType:"source",sourceDataType:"content"})));}catch(e){this._tileJSONRequest=null,this._loaded=!0,t.Z(e)||this.fire(new t.k(e));}}))}loaded(){return this._loaded}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}onAdd(e){this.map=e,this.load();}setSourceProperty(e){this._tileJSONRequest&&this._tileJSONRequest.abort(),e(),this.load();}setTiles(e){return this.setSourceProperty((()=>{this._options.tiles=e;})),this}setUrl(e){return this.setSourceProperty((()=>{this.url=e,this._options.url=e;})),this}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null);}serialize(){return t.e({},this._options)}loadTile(e){return t._(this,void 0,void 0,(function*(){const t=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i={request:this.map._requestManager.transformRequest(t,"Tile"),uid:e.uid,tileID:e.tileID,zoom:e.tileID.overscaledZ,tileSize:this.tileSize*e.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity,encoding:this.encoding,overzoomParameters:this._getOverzoomParameters(e)};i.request.collectResourceTiming=this._collectResourceTiming;let a="RT";if(e.actor&&"expired"!==e.state){if("loading"===e.state)return new Promise(((t,i)=>{e.reloadPromise={resolve:t,reject:i};}))}else e.actor=this.dispatcher.getActor(),a="LT";e.abortController=new AbortController;try{const t=yield e.actor.sendAsync({type:a,data:i},e.abortController);if(delete e.abortController,e.aborted)return;this._afterTileLoadWorkerResponse(e,t);}catch(t){if(delete e.abortController,e.aborted)return;if(t&&404!==t.status)throw t;this._afterTileLoadWorkerResponse(e,null);}}))}_getOverzoomParameters(e){if(e.tileID.canonical.z<=this.maxzoom)return;if(void 0===this.map._zoomLevelsToOverscale)return;const t=e.tileID.scaledTo(this.maxzoom).canonical,i=t.url(this.tiles,this.map.getPixelRatio(),this.scheme);return {maxZoomTileID:t,overzoomRequest:this.map._requestManager.transformRequest(i,"Tile")}}_afterTileLoadWorkerResponse(e,t){if(t&&t.resourceTiming&&(e.resourceTiming=t.resourceTiming),t&&this.map._refreshExpiredTiles&&e.setExpiryData(t),e.loadVectorData(t,this.map.painter),e.reloadPromise){const t=e.reloadPromise;e.reloadPromise=null,this.loadTile(e).then(t.resolve).catch(t.reject);}}abortTile(e){return t._(this,void 0,void 0,(function*(){e.abortController&&(e.abortController.abort(),delete e.abortController),e.actor&&(yield e.actor.sendAsync({type:"AT",data:{uid:e.uid,type:this.type,source:this.id}}));}))}unloadTile(e){return t._(this,void 0,void 0,(function*(){e.unloadVectorData(),e.actor&&(yield e.actor.sendAsync({type:"RMT",data:{uid:e.uid,type:this.type,source:this.id}}));}))}hasTransition(){return !1}}class K extends t.E{constructor(e,i,a,r){super(),this.id=e,this.dispatcher=a,this.setEventedParent(r),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=t.e({type:"raster"},i),t.e(this,t.U(i,["url","scheme","tileSize"]));}load(){return t._(this,arguments,void 0,(function*(e=!1){this._loaded=!1,this.fire(new t.l("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const i=yield W(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,i&&(t.e(this,i),i.bounds&&(this.tileBounds=new H(i.bounds,this.minzoom,this.maxzoom)),this.fire(new t.l("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new t.l("data",{dataType:"source",sourceDataType:"content",sourceDataChanged:e})));}catch(e){this._tileJSONRequest=null,this._loaded=!0,t.Z(e)||this.fire(new t.k(e));}}))}loaded(){return this._loaded}onAdd(e){this.map=e,this.load();}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null);}setSourceProperty(e){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null),e(),this.load(!0);}setTiles(e){return this.setSourceProperty((()=>{this._options.tiles=e;})),this}setUrl(e){return this.setSourceProperty((()=>{this.url=e,this._options.url=e;})),this}serialize(){return t.e({},this._options)}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(e){return t._(this,void 0,void 0,(function*(){const i=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme);e.abortController=new AbortController;try{const a=yield g.getImage(this.map._requestManager.transformRequest(i,"Tile"),e.abortController,this.map._refreshExpiredTiles);if(delete e.abortController,e.aborted)return void(e.state="unloaded");if(a&&a.data){this.map._refreshExpiredTiles&&(a.cacheControl||a.expires)&&e.setExpiryData({cacheControl:a.cacheControl,expires:a.expires});const i=this.map.painter.context,r=i.gl,o=a.data;e.texture=this.map.painter.getTileTexture(o.width),e.texture?e.texture.update(o,{useMipmap:!0}):(e.texture=new t.T(i,o,r.RGBA,{useMipmap:!0}),e.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE,r.LINEAR_MIPMAP_NEAREST)),e.state="loaded";}}catch(t){if(delete e.abortController,e.aborted)e.state="unloaded";else if(t)throw e.state="errored",t}}))}abortTile(e){return t._(this,void 0,void 0,(function*(){e.abortController&&(e.abortController.abort(),delete e.abortController);}))}unloadTile(e){return t._(this,void 0,void 0,(function*(){e.texture&&this.map.painter.saveTileTexture(e.texture);}))}hasTransition(){return !1}}class Y extends K{constructor(e,i,a,r){super(e,i,a,r),this.type="raster-dem",this.maxzoom=22,this._options=t.e({type:"raster-dem"},i),this.encoding=i.encoding||"mapbox",this.redFactor=i.redFactor,this.greenFactor=i.greenFactor,this.blueFactor=i.blueFactor,this.baseShift=i.baseShift;}loadTile(e){return t._(this,void 0,void 0,(function*(){const i=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),a=this.map._requestManager.transformRequest(i,"Tile");e.neighboringTiles=this._getNeighboringTiles(e.tileID),e.abortController=new AbortController;try{const i=yield g.getImage(a,e.abortController,this.map._refreshExpiredTiles);if(delete e.abortController,e.aborted)return void(e.state="unloaded");if(i&&i.data){const a=i.data;this.map._refreshExpiredTiles&&(i.cacheControl||i.expires)&&e.setExpiryData({cacheControl:i.cacheControl,expires:i.expires});const r=t.b(a)&&t.$()?a:yield this.readImageNow(a),o={type:this.type,uid:e.uid,source:this.id,rawImageData:r,encoding:this.encoding,redFactor:this.redFactor,greenFactor:this.greenFactor,blueFactor:this.blueFactor,baseShift:this.baseShift};if(!e.actor||"expired"===e.state){e.actor=this.dispatcher.getActor();const t=yield e.actor.sendAsync({type:"LDT",data:o});e.dem=t,e.needsHillshadePrepare=!0,e.needsTerrainPrepare=!0,e.state="loaded";}}}catch(t){if(delete e.abortController,e.aborted)e.state="unloaded";else if(t)throw e.state="errored",t}}))}readImageNow(e){return t._(this,void 0,void 0,(function*(){if("undefined"!=typeof VideoFrame&&t.a0()){const i=e.width+2,a=e.height+2;try{return new t.R({width:i,height:a},yield t.a1(e,-1,-1,i,a))}catch(e){}}return n.getImageData(e,1)}))}_getNeighboringTiles(e){const i=e.canonical,a=Math.pow(2,i.z),r=(i.x-1+a)%a,o=0===i.x?e.wrap-1:e.wrap,s=(i.x+1+a)%a,n=i.x+1===a?e.wrap+1:e.wrap,l={};return l[new t.a2(e.overscaledZ,o,i.z,r,i.y).key]={backfilled:!1},l[new t.a2(e.overscaledZ,n,i.z,s,i.y).key]={backfilled:!1},i.y>0&&(l[new t.a2(e.overscaledZ,o,i.z,r,i.y-1).key]={backfilled:!1},l[new t.a2(e.overscaledZ,e.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new t.a2(e.overscaledZ,n,i.z,s,i.y-1).key]={backfilled:!1}),i.y+1<a&&(l[new t.a2(e.overscaledZ,o,i.z,r,i.y+1).key]={backfilled:!1},l[new t.a2(e.overscaledZ,e.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new t.a2(e.overscaledZ,n,i.z,s,i.y+1).key]={backfilled:!1}),l}unloadTile(e){return t._(this,void 0,void 0,(function*(){e.demTexture&&this.map.painter.saveTileTexture(e.demTexture),e.fbo&&(e.fbo.destroy(),delete e.fbo),e.dem&&delete e.dem,delete e.neighboringTiles,e.state="unloaded",e.actor&&(yield e.actor.sendAsync({type:"RDT",data:{type:this.type,uid:e.uid,source:this.id}}));}))}}function Q(e){return "GeometryCollection"===e.type?e.geometries.map((e=>e.coordinates)).flat(1/0):e.coordinates.flat(1/0)}function J(e){const t=new $;let i;switch(e.type){case "FeatureCollection":i=e.features.map((e=>Q(e.geometry))).flat(1/0);break;case "Feature":i=Q(e.geometry);break;default:i=Q(e);}if(0==i.length)return t;for(let e=0;e<i.length-1;e+=2)t.extend([i[e],i[e+1]]);return t}class ee extends t.E{constructor(e,i,a,r){super(),this.id=e,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._removed=!1,this._isUpdatingWorker=!1,this._pendingWorkerUpdate={data:i.data},this.actor=a.getActor(),this.setEventedParent(r),this._data="string"==typeof i.data?{url:i.data}:{geojson:i.data},this._options=t.e({},i),this._collectResourceTiming=i.collectResourceTiming,void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId,void 0!==i.clusterMaxZoom&&this.maxzoom<=i.clusterMaxZoom&&t.w(`The maxzoom value "${this.maxzoom}" is expected to be greater than the clusterMaxZoom value "${i.clusterMaxZoom}".`),this.workerOptions=t.e({source:this.id,cluster:i.cluster||!1,geojsonVtOptions:{buffer:this._pixelsToTileUnits(void 0!==i.buffer?i.buffer:128),tolerance:this._pixelsToTileUnits(void 0!==i.tolerance?i.tolerance:.375),extent:t.a5,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:this._getClusterMaxZoom(i.clusterMaxZoom),minPoints:Math.max(2,i.clusterMinPoints||2),extent:t.a5,radius:this._pixelsToTileUnits(i.clusterRadius||50),log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter},i.workerOptions),"string"==typeof this.promoteId&&(this.workerOptions.promoteId=this.promoteId);}_hasPendingWorkerUpdate(){return void 0!==this._pendingWorkerUpdate.data||void 0!==this._pendingWorkerUpdate.diff||this._pendingWorkerUpdate.optionsChanged}_pixelsToTileUnits(e){return e*(t.a5/this.tileSize)}_getClusterMaxZoom(e){const i=e?Math.round(e):this.maxzoom-1;return Number.isInteger(e)||void 0===e||t.w(`Integer expected for option 'clusterMaxZoom': provided value "${e}" rounded to "${i}"`),i}load(){return t._(this,void 0,void 0,(function*(){yield this._updateWorkerData();}))}onAdd(e){this.map=e,this.load();}setData(e,t){this._data="string"==typeof e?{url:e}:{geojson:e},this._pendingWorkerUpdate={data:e};const i=this._updateWorkerData();return t?i:this}updateData(e,i){this._pendingWorkerUpdate.diff=t.a6(this._pendingWorkerUpdate.diff,e);const a=this._updateWorkerData();return i?a:this}getData(){return t._(this,void 0,void 0,(function*(){const e=t.e({type:this.type},this.workerOptions);return this.actor.sendAsync({type:"GD",data:e})}))}getBounds(){return t._(this,void 0,void 0,(function*(){return J(yield this.getData())}))}setClusterOptions(e){return this.workerOptions.cluster=e.cluster,void 0!==e.clusterRadius&&(this.workerOptions.superclusterOptions.radius=this._pixelsToTileUnits(e.clusterRadius)),void 0!==e.clusterMaxZoom&&(this.workerOptions.superclusterOptions.maxZoom=this._getClusterMaxZoom(e.clusterMaxZoom)),this._pendingWorkerUpdate.optionsChanged=!0,this._updateWorkerData(),this}getClusterExpansionZoom(e){return this.actor.sendAsync({type:"GCEZ",data:{type:this.type,clusterId:e,source:this.id}})}getClusterChildren(e){return this.actor.sendAsync({type:"GCC",data:{type:this.type,clusterId:e,source:this.id}})}getClusterLeaves(e,t,i){return this.actor.sendAsync({type:"GCL",data:{type:this.type,source:this.id,clusterId:e,limit:t,offset:i}})}_updateWorkerData(){return t._(this,void 0,void 0,(function*(){if(this._isUpdatingWorker)return;if(!this._hasPendingWorkerUpdate())return void t.w(`No pending worker updates for GeoJSONSource ${this.id}.`);const{data:e,diff:i}=this._pendingWorkerUpdate,a=t.e({type:this.type},this.workerOptions);void 0!==e?("string"==typeof e?(a.request=this.map._requestManager.transformRequest(n.resolveURL(e),"Source"),a.request.collectResourceTiming=this._collectResourceTiming):a.data=e,this._pendingWorkerUpdate.data=void 0):i&&(a.dataDiff=i,this._pendingWorkerUpdate.diff=void 0),this._pendingWorkerUpdate.optionsChanged=void 0,this._isUpdatingWorker=!0,this.fire(new t.l("dataloading",{dataType:"source"}));try{const e=yield this.actor.sendAsync({type:"LD",data:a});if(this._isUpdatingWorker=!1,this._removed||e.abandoned)return void this.fire(new t.l("dataabort",{dataType:"source"}));e.data&&(this._data={geojson:e.data});const r=this._applyDiffToSource(i),o=this._getShouldReloadTileOptions(r);let s=null;e.resourceTiming&&e.resourceTiming[this.id]&&(s=e.resourceTiming[this.id].slice(0));const n={dataType:"source"};this._collectResourceTiming&&s&&s.length>0&&t.e(n,{resourceTiming:s}),this.fire(new t.l("data",Object.assign(Object.assign({},n),{sourceDataType:"metadata"}))),this.fire(new t.l("data",Object.assign(Object.assign({},n),{sourceDataType:"content",shouldReloadTileOptions:o})));}catch(e){if(this._isUpdatingWorker=!1,this._removed)return void this.fire(new t.l("dataabort",{dataType:"source"}));this.fire(new t.k(e));}finally{this._hasPendingWorkerUpdate()&&this._updateWorkerData();}}))}_applyDiffToSource(e){if(!e)return;const i="string"==typeof this.promoteId?this.promoteId:void 0;if(!this._data.url&&!this._data.updateable){const e=t.a7(this._data.geojson,i);if(!e)throw new Error(`GeoJSONSource "${this.id}": GeoJSON data is not compatible with updateData`);this._data={updateable:e};}if(!this._data.updateable)return;const a=t.a8(this._data.updateable,e,i);return e.removeAll||this._options.cluster?void 0:a}_getShouldReloadTileOptions(e){if(e)return {affectedBounds:e.filter(Boolean).map((e=>J(e)))}}shouldReloadTile(e,{affectedBounds:i}){if("loading"===e.state)return !0;if("unloaded"===e.state)return !1;const{buffer:a,extent:r}=this.workerOptions.geojsonVtOptions,o=function({x:e,y:i,z:a},r=0){const o=t.a3((e-r)/Math.pow(2,a)),s=t.a4((i+1+r)/Math.pow(2,a)),n=t.a3((e+1+r)/Math.pow(2,a)),l=t.a4((i-r)/Math.pow(2,a));return new $([o,s],[n,l])}(e.tileID.canonical,a/r);for(const e of i)if(o.intersects(e))return !0;return !1}loaded(){return !this._isUpdatingWorker&&!this._hasPendingWorkerUpdate()}loadTile(e){return t._(this,void 0,void 0,(function*(){const t=e.actor?"RT":"LT";e.actor=this.actor;const i={type:this.type,uid:e.uid,tileID:e.tileID,zoom:e.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity};e.abortController=new AbortController;const a=yield this.actor.sendAsync({type:t,data:i},e.abortController);delete e.abortController,e.unloadVectorData(),e.aborted||e.loadVectorData(a,this.map.painter,"RT"===t);}))}abortTile(e){return t._(this,void 0,void 0,(function*(){e.abortController&&(e.abortController.abort(),delete e.abortController),e.aborted=!0;}))}unloadTile(e){return t._(this,void 0,void 0,(function*(){e.unloadVectorData(),yield this.actor.sendAsync({type:"RMT",data:{uid:e.uid,type:this.type,source:this.id}});}))}onRemove(){this._removed=!0,this.actor.sendAsync({type:"RS",data:{type:this.type,source:this.id}});}serialize(){return t.e({},this._options,{type:this.type,data:this._data.updateable?{type:"FeatureCollection",features:Array.from(this._data.updateable.values())}:this._data.url||this._data.geojson})}hasTransition(){return !1}}class te extends t.E{constructor(e,t,i,a){super(),this.flippedWindingOrder=!1,this.id=e,this.dispatcher=i,this.coordinates=t.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(a),this.options=t;}load(e){return t._(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new t.l("dataloading",{dataType:"source"})),this.url=this.options.url,this._request=new AbortController;try{const t=yield g.getImage(this.map._requestManager.transformRequest(this.url,"Image"),this._request);this._request=null,this._loaded=!0,t&&t.data&&(this.image=t.data,e&&(this.coordinates=e),this._finishLoading());}catch(e){this._request=null,this._loaded=!0,t.Z(e)||this.fire(new t.k(e));}}))}loaded(){return this._loaded}updateImage(e){return e.url?(this._request&&(this._request.abort(),this._request=null),this.options.url=e.url,this.load(e.coordinates).finally((()=>{this.texture=null;})),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new t.l("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(e){this.map=e,this.load();}onRemove(){this._request&&(this._request.abort(),this._request=null);}setCoordinates(e){this.coordinates=e;const i=e.map(t.a9.fromLngLat);var a;return this.tileID=function(e){const i=t.aa.fromPoints(e),a=i.width(),r=i.height(),o=Math.max(a,r),s=Math.max(0,Math.floor(-Math.log(o)/Math.LN2)),n=Math.pow(2,s);return new t.ac(s,Math.floor((i.minX+i.maxX)/2*n),Math.floor((i.minY+i.maxY)/2*n))}(i),this.terrainTileRanges=this._getOverlappingTileRanges(i),this.minzoom=this.maxzoom=this.tileID.z,this.tileCoords=i.map((e=>this.tileID.getTilePoint(e)._round())),this.flippedWindingOrder=((a=this.tileCoords)[1].x-a[0].x)*(a[2].y-a[0].y)-(a[1].y-a[0].y)*(a[2].x-a[0].x)<0,this.fire(new t.l("data",{dataType:"source",sourceDataType:"content"})),this}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const e=this.map.painter.context,i=e.gl;this.texture||(this.texture=new t.T(e,this.image,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));let a=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,a=!0);}a&&this.fire(new t.l("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}loadTile(e){return t._(this,void 0,void 0,(function*(){this.tileID&&this.tileID.equals(e.tileID.canonical)?(this.tiles[String(e.tileID.wrap)]=e,e.buckets={}):e.state="errored";}))}serialize(){return {type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return !1}_getOverlappingTileRanges(e){const{minX:i,minY:a,maxX:r,maxY:o}=t.aa.fromPoints(e),s={};for(let e=0;e<=t.ab;e++){const t=Math.pow(2,e),n=Math.floor(i*t),l=Math.floor(a*t),c=Math.floor(r*t),h=Math.floor(o*t),u=(n%t+t)%t,d=c%t,_=Math.floor(n/t),p=Math.floor(c/t);s[e]={minWrap:_,maxWrap:p,minTileXWrapped:u,maxTileXWrapped:d,minTileY:l,maxTileY:h};}return s}}class ie extends te{constructor(e,t,i,a){super(e,t,i,a),this.roundZoom=!0,this.type="video",this.options=t;}load(){return t._(this,void 0,void 0,(function*(){this._loaded=!1;const e=this.options;this.urls=[];for(const t of e.urls)this.urls.push(this.map._requestManager.transformRequest(t,"Source").url);try{const e=yield t.ad(this.urls);if(this._loaded=!0,!e)return;this.video=e,this.video.loop=!0,this.video.addEventListener("playing",(()=>{this.map.triggerRepaint();})),this.map&&this.video.play(),this._finishLoading();}catch(e){this.fire(new t.k(e));}}))}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(e){if(this.video){const i=this.video.seekable;e<i.start(0)||e>i.end(0)?this.fire(new t.k(new t.ae(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=e;}}getVideo(){return this.video}onAdd(e){this.map||(this.map=e,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const e=this.map.painter.context,i=e.gl;this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new t.T(e,this.video,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));let a=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,a=!0);}a&&this.fire(new t.l("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}serialize(){return {type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}}class ae extends te{constructor(e,i,a,r){super(e,i,a,r),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some((e=>!Array.isArray(e)||2!==e.length||e.some((e=>"number"!=typeof e))))||this.fire(new t.k(new t.ae(`sources.${e}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new t.k(new t.ae(`sources.${e}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new t.k(new t.ae(`sources.${e}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof HTMLCanvasElement||this.fire(new t.k(new t.ae(`sources.${e}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new t.k(new t.ae(`sources.${e}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){return t._(this,void 0,void 0,(function*(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new t.k(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());}))}getCanvas(){return this.canvas}onAdd(e){this.map=e,this.load(),this.canvas&&this.animate&&this.play();}onRemove(){this.pause();}prepare(){let e=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,e=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,e=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context,a=i.gl;this.texture?(e||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):(this.texture=new t.T(i,this.canvas,a.RGBA,{premultiply:!0}),this.texture.bind(a.LINEAR,a.CLAMP_TO_EDGE));let r=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,r=!0);}r&&this.fire(new t.l("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}serialize(){return {type:"canvas",animate:this.animate,canvas:this.options.canvas,coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const e of [this.canvas.width,this.canvas.height])if(isNaN(e)||e<=0)return !0;return !1}}const re={},oe=e=>{switch(e){case "geojson":return ee;case "image":return te;case "raster":return K;case "raster-dem":return Y;case "vector":return X;case "video":return ie;case "canvas":return ae}return re[e]},se="RTLPluginLoaded";class ne extends t.E{constructor(){super(...arguments),this.status="unavailable",this.url=null,this.dispatcher=Z();}_syncState(e){return this.status=e,this.dispatcher.broadcast("SRPS",{pluginStatus:e,pluginURL:this.url}).catch((e=>{throw this.status="error",e}))}getRTLTextPluginStatus(){return this.status}clearRTLTextPlugin(){this.status="unavailable",this.url=null;}setRTLTextPlugin(e){return t._(this,arguments,void 0,(function*(e,t=!1){if(this.url)throw new Error("setRTLTextPlugin cannot be called multiple times.");if(this.url=n.resolveURL(e),!this.url)throw new Error(`requested url ${e} is invalid`);if("unavailable"===this.status){if(!t)return this._requestImport();this.status="deferred",this._syncState(this.status);}else if("requested"===this.status)return this._requestImport()}))}_requestImport(){return t._(this,void 0,void 0,(function*(){yield this._syncState("loading"),this.status="loaded",this.fire(new t.l(se));}))}lazyLoad(){"unavailable"===this.status?this.status="requested":"deferred"===this.status&&this._requestImport();}}let le=null;function ce(){return le||(le=new ne),le}var he,ue;!function(e){e[e.Base=0]="Base",e[e.Parent=1]="Parent";}(he||(he={})),function(e){e[e.Departing=0]="Departing",e[e.Incoming=1]="Incoming";}(ue||(ue={}));class de{constructor(e,i){this.timeAdded=0,this.fadeEndTime=0,this.fadeOpacity=1,this.tileID=e,this.uid=t.af(),this.uses=0,this.tileSize=i,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.rtt=[],this.rttCoords={},this.expiredRequestCount=0,this.state="loading";}isRenderable(e){return this.hasData()&&(!this.fadeEndTime||this.fadeOpacity>0)&&(e||!this.holdingForSymbolFade())}setCrossFadeLogic({fadingRole:e,fadingDirection:t,fadingParentID:i,fadeEndTime:a}){this.resetFadeLogic(),this.fadingRole=e,this.fadingDirection=t,this.fadingParentID=i,this.fadeEndTime=a;}setSelfFadeLogic(e){this.resetFadeLogic(),this.selfFading=!0,this.fadeEndTime=e;}resetFadeLogic(){this.fadingRole=null,this.fadingDirection=null,this.fadingParentID=null,this.selfFading=!1,this.timeAdded=c(),this.fadeEndTime=0,this.fadeOpacity=1;}wasRequested(){return "errored"===this.state||"loaded"===this.state||"reloading"===this.state}clearTextures(e){this.demTexture&&e.saveTileTexture(this.demTexture),this.demTexture=null;}loadVectorData(e,i,a){if(this.hasData()&&this.unloadVectorData(),this.state="loaded",e){e.featureIndex&&(this.latestFeatureIndex=e.featureIndex,e.rawTileData?(this.latestRawTileData=e.rawTileData,this.latestFeatureIndex.rawTileData=e.rawTileData,this.latestFeatureIndex.encoding=e.encoding):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData,this.latestFeatureIndex.encoding=this.latestEncoding)),this.collisionBoxArray=e.collisionBoxArray,this.buckets=function(e,t){const i={};if(!t)return i;for(const a of e){const e=a.layerIds.map((e=>t.getLayer(e))).filter(Boolean);if(0!==e.length){a.layers=e,a.stateDependentLayerIds&&(a.stateDependentLayers=a.stateDependentLayerIds.map((t=>e.filter((e=>e.id===t))[0])));for(const t of e)i[t.id]=a;}}return i}(e.buckets,null==i?void 0:i.style),this.hasSymbolBuckets=!1;for(const e in this.buckets){const i=this.buckets[e];if(i instanceof t.ah){if(this.hasSymbolBuckets=!0,!a)break;i.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const e in this.buckets){const i=this.buckets[e];if(i instanceof t.ah&&i.hasRTLText){this.hasRTLText=!0,ce().lazyLoad();break}}this.queryPadding=0;for(const e in this.buckets){const t=this.buckets[e];this.queryPadding=Math.max(this.queryPadding,i.style.getLayer(e).queryRadius(t));}e.imageAtlas&&(this.imageAtlas=e.imageAtlas),e.glyphAtlasImage&&(this.glyphAtlasImage=e.glyphAtlasImage),this.dashPositions=e.dashPositions;}else this.collisionBoxArray=new t.ag;}unloadVectorData(){for(const e in this.buckets)this.buckets[e].destroy();this.buckets={},this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.imageAtlas&&(this.imageAtlas=null),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.dashPositions&&(this.dashPositions=null),this.latestFeatureIndex=null,this.state="unloaded";}getBucket(e){return this.buckets[e.id]}upload(e){for(const t in this.buckets){const i=this.buckets[t];i.uploadPending()&&i.upload(e);}const i=e.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new t.T(e,this.imageAtlas.image,i.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new t.T(e,this.glyphAtlasImage,i.ALPHA),this.glyphAtlasImage=null);}prepare(e){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(e,this.imageAtlasTexture);}queryRenderedFeatures(e,t,i,a,r,o,s,n,l,c,h){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({queryGeometry:a,cameraQueryGeometry:r,scale:o,tileSize:this.tileSize,pixelPosMatrix:c,transform:n,params:s,queryPadding:this.queryPadding*l,getElevation:h},e,t,i):{}}querySourceFeatures(e,i){const a=this.latestFeatureIndex;if(!a||!a.rawTileData)return;const r=a.loadVTLayers(),o=i&&i.sourceLayer?i.sourceLayer:"",s=r[t.ai]||r[o];if(!s)return;const n=t.aj(null==i?void 0:i.filter,null==i?void 0:i.globalState),{z:l,x:c,y:h}=this.tileID.canonical,u={z:l,x:c,y:h};for(let i=0;i<s.length;i++){const r=s.feature(i);if(n.needGeometry){const e=t.ak(r,!0);if(!n.filter(new t.H(this.tileID.overscaledZ),e,this.tileID.canonical))continue}else if(!n.filter(new t.H(this.tileID.overscaledZ),r))continue;const d=a.getId(r,o),_=new t.al(r,l,c,h,d);_.tile=u,e.push(_);}}hasData(){return "loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(e){const i=this.expirationTime;if(e.cacheControl){const i=t.am(e.cacheControl);i["max-age"]&&(this.expirationTime=Date.now()+1e3*i["max-age"]);}else e.expires&&(this.expirationTime=new Date(e.expires).getTime());if(this.expirationTime){const e=Date.now();let t=!1;if(this.expirationTime>e)t=!1;else if(i)if(this.expirationTime<i)t=!0;else {const a=this.expirationTime-i;a?this.expirationTime=e+Math.max(a,3e4):t=!0;}else t=!0;t?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(e,i){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(e).length)return;const a=this.latestFeatureIndex.loadVTLayers();for(const r in this.buckets){if(!i.style.hasLayer(r))continue;const o=this.buckets[r],s=o.layers[0].sourceLayer||t.ai,n=a[s],l=e[s];if(!n||!l||0===Object.keys(l).length)continue;o.update(l,n,this.imageAtlas&&this.imageAtlas.patternPositions||{},this.dashPositions||{});const c=i&&i.style&&i.style.getLayer(r);c&&(this.queryPadding=Math.max(this.queryPadding,c.queryRadius(o)));}}holdingForSymbolFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return !this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<c()}clearSymbolFadeHold(){this.symbolFadeHoldUntil=void 0;}setSymbolHoldDuration(e){this.symbolFadeHoldUntil=c()+e;}setDependencies(e,t){const i={};for(const e of t)i[e]=!0;this.dependencies[e]=i;}hasDependency(e,t){for(const i of e){const e=this.dependencies[i];if(e)for(const i of t)if(e[i])return !0}return !1}}class _e{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(e,i,a){const r=String(i);if(this.stateChanges[e]=this.stateChanges[e]||{},this.stateChanges[e][r]=this.stateChanges[e][r]||{},t.e(this.stateChanges[e][r],a),null===this.deletedStates[e]){this.deletedStates[e]={};for(const t in this.state[e])t!==r&&(this.deletedStates[e][t]=null);}else if(this.deletedStates[e]&&null===this.deletedStates[e][r]){this.deletedStates[e][r]={};for(const t in this.state[e][r])a[t]||(this.deletedStates[e][r][t]=null);}else for(const t in a)this.deletedStates[e]&&this.deletedStates[e][r]&&null===this.deletedStates[e][r][t]&&delete this.deletedStates[e][r][t];}removeFeatureState(e,t,i){if(null===this.deletedStates[e])return;const a=String(t);if(this.deletedStates[e]=this.deletedStates[e]||{},i&&void 0!==t)null!==this.deletedStates[e][a]&&(this.deletedStates[e][a]=this.deletedStates[e][a]||{},this.deletedStates[e][a][i]=null);else if(void 0!==t)if(this.stateChanges[e]&&this.stateChanges[e][a])for(i in this.deletedStates[e][a]={},this.stateChanges[e][a])this.deletedStates[e][a][i]=null;else this.deletedStates[e][a]=null;else this.deletedStates[e]=null;}getState(e,i){const a=String(i),r=t.e({},(this.state[e]||{})[a],(this.stateChanges[e]||{})[a]);if(null===this.deletedStates[e])return {};if(this.deletedStates[e]){const t=this.deletedStates[e][i];if(null===t)return {};for(const e in t)delete r[e];}return r}initializeTileState(e,t){e.setFeatureState(this.state,t);}coalesceChanges(e,i){const a={};for(const e in this.stateChanges){this.state[e]=this.state[e]||{};const i={};for(const a in this.stateChanges[e])this.state[e][a]||(this.state[e][a]={}),t.e(this.state[e][a],this.stateChanges[e][a]),i[a]=this.state[e][a];a[e]=i;}for(const e in this.deletedStates){this.state[e]=this.state[e]||{};const i={};if(null===this.deletedStates[e])for(const t in this.state[e])i[t]={},this.state[e][t]={};else for(const t in this.deletedStates[e]){if(null===this.deletedStates[e][t])this.state[e][t]={};else for(const i of Object.keys(this.deletedStates[e][t]))delete this.state[e][t][i];i[t]=this.state[e][t];}a[e]=a[e]||{},t.e(a[e],i);}this.stateChanges={},this.deletedStates={},0!==Object.keys(a).length&&e.setFeatureState(a,i);}}const pe=89.25;function me(e,i){const a=t.an(i.lat,-t.ao,t.ao);return new t.P(t.Y(i.lng)*e,t.X(a)*e)}function fe(e,i){return new t.a9(i.x/e,i.y/e).toLngLat()}function ge(e){return e.cameraToCenterDistance*Math.min(.85*Math.tan(t.ap(90-e.pitch)),Math.tan(t.ap(pe-e.pitch)))}function ve(e,i){const a=e.canonical,r=i/t.aq(a.z),o=a.x+Math.pow(2,a.z)*e.wrap,s=t.ar(new Float64Array(16));return t.O(s,s,[o*r,a.y*r,0]),t.Q(s,s,[r/t.a5,r/t.a5,1]),s}function xe(e,i,a,r,o){const s=t.a9.fromLngLat(e,i),n=o*t.as(1,e.lat),{x:l,y:c,z:h}=be(a,r);return new t.a9(s.x+n*-l,s.y+n*-c,s.z+n*-h)}function be(e,i){const a=t.ap(e),r=t.ap(i),o=Math.cos(-a),s=Math.sin(a);return {x:s*Math.sin(r),y:-s*Math.cos(r),z:o}}function ye(e,t,i){const a=t.intersectsFrustum(e);if(!i||0===a)return a;const r=t.intersectsPlane(i);return 0===r?0:2===a&&2===r?2:1}function we(e,t,i){let a=0;const r=(i-t)/10;for(let o=0;o<10;o++)a+=r*Math.pow(Math.cos(t+(o+.5)/10*(i-t)),e);return a}function Te(e,i){return function(a,r,o,s,n){const l=2*((e-1)/t.at(Math.cos(t.ap(pe-n))/Math.cos(t.ap(pe)))-1),c=Math.acos(o/s),h=2*we(l-1,0,t.ap(n/2)),u=Math.min(t.ap(pe),c+t.ap(n/2)),d=we(l-1,Math.min(u,c-t.ap(n/2)),u),_=Math.atan(r/o),p=Math.hypot(r,o);let m=a;return m+=t.at(s/p/Math.max(.5,Math.cos(t.ap(n/2)))),m+=l*t.at(Math.cos(_))/2,m-=t.at(Math.max(1,d/h/i))/2,m}}const Pe=Te(9.314,3);function Ce(e,i){const a=(i.roundZoom?Math.round:Math.floor)(e.zoom+t.at(e.tileSize/i.tileSize));return Math.max(0,a)}function Ie(e,i){const a=e.getCameraFrustum(),r=e.getClippingPlane(),o=e.screenPointToMercatorCoordinate(e.getCameraPoint()),s=t.a9.fromLngLat(e.center,e.elevation);o.z=s.z+Math.cos(e.pitchInRadians)*e.cameraToCenterDistance/e.worldSize;const n=e.getCoveringTilesDetailsProvider(),l=n.allowVariableZoom(e,i),c=Ce(e,i),h=i.minzoom||0,u=void 0!==i.maxzoom?i.maxzoom:e.maxZoom,d=Math.min(Math.max(0,c),u),_=Math.pow(2,d),p=[_*o.x,_*o.y,0],m=[_*s.x,_*s.y,0],f=Math.hypot(s.x-o.x,s.y-o.y),g=Math.abs(s.z-o.z),v=Math.hypot(f,g),x=e=>({zoom:0,x:0,y:0,wrap:e,fullyVisible:!1}),b=[],y=[];if(e.renderWorldCopies&&n.allowWorldCopies())for(let e=1;e<=3;e++)b.push(x(-e)),b.push(x(e));for(b.push(x(0));b.length>0;){const _=b.pop(),f=_.x,x=_.y;let w=_.fullyVisible;const T={x:f,y:x,z:_.zoom},P=n.getTileBoundingVolume(T,_.wrap,e.elevation,i);if(!w){const e=ye(a,P,r);if(0===e)continue;w=2===e;}const C=n.distanceToTile2d(o.x,o.y,T,P);let I=c;l&&(I=(i.calculateTileZoom||Pe)(e.zoom+t.at(e.tileSize/i.tileSize),C,g,v,e.fov)),I=(i.roundZoom?Math.round:Math.floor)(I),I=Math.max(0,I);const M=Math.min(I,u);if(_.wrap=n.getWrap(s,T,_.wrap),_.zoom>=M){if(_.zoom<h)continue;const e=d-_.zoom,a=p[0]-.5-(f<<e),r=p[1]-.5-(x<<e),o=i.reparseOverscaled?Math.max(_.zoom,I):_.zoom;y.push({tileID:new t.a2(_.zoom===u?o:_.zoom,_.wrap,_.zoom,f,x),distanceSq:t.au([m[0]-.5-f,m[1]-.5-x]),tileDistanceToCamera:Math.sqrt(a*a+r*r)});}else for(let e=0;e<4;e++)b.push({zoom:_.zoom+1,x:(f<<1)+e%2,y:(x<<1)+(e>>1),wrap:_.wrap,fullyVisible:w});}return y.sort(((e,t)=>e.distanceSq-t.distanceSq)).map((e=>e.tileID))}const Me=t.aa.fromPoints([new t.P(0,0),new t.P(t.a5,t.a5)]);function Ee(e){return "raster"===e||"image"===e||"video"===e}function Se(e,t,i,a,r,o,s){if(!t.hasData())return !1;const{tileID:n,fadingRole:l,fadingDirection:c,fadingParentID:h}=t;if(l===he.Base&&c===ue.Incoming&&h)return i[h.key]=h,!0;const u=Math.max(n.overscaledZ-r,o);for(let r=n.overscaledZ-1;r>=u;r--){const o=n.scaledTo(r),l=e.getLoadedTile(o);if(l)return t.setCrossFadeLogic({fadingRole:he.Base,fadingDirection:ue.Incoming,fadingParentID:l.tileID,fadeEndTime:a+s}),l.setCrossFadeLogic({fadingRole:he.Parent,fadingDirection:ue.Departing,fadeEndTime:a+s}),i[o.key]=o,!0}return !1}function ze(e,t,i,a,r,o){if(!t.hasData())return !1;const s=t.tileID.children(r);let n=Re(e,t,s,i,a,r,o);if(n)return !0;for(const l of s)Re(e,t,l.children(r),i,a,r,o)&&(n=!0);return n}function Re(e,t,i,a,r,o,s){if(i[0].overscaledZ>=o)return !1;let n=!1;for(const o of i){const i=e.getLoadedTile(o);if(!i)continue;const{fadingRole:l,fadingDirection:c,fadingParentID:h}=i;l===he.Base&&c===ue.Departing&&h||(i.setCrossFadeLogic({fadingRole:he.Base,fadingDirection:ue.Departing,fadingParentID:t.tileID,fadeEndTime:r+s}),t.setCrossFadeLogic({fadingRole:he.Parent,fadingDirection:ue.Incoming,fadeEndTime:r+s})),a[o.key]=o,n=!0;}return n}function De(e,t,i,a){const r=e.tileID;return !!e.selfFading||!e.hasData()&&!!t.has(r)&&(e.setSelfFadeLogic(i+a),!0)}function Ae(e,t){var i;e.needsHillshadePrepare=!0,e.needsTerrainPrepare=!0;let a=t.tileID.canonical.x-e.tileID.canonical.x;const r=t.tileID.canonical.y-e.tileID.canonical.y,o=Math.pow(2,e.tileID.canonical.z),s=t.tileID.key;0===a&&0===r||Math.abs(r)>1||(Math.abs(a)>1&&(1===Math.abs(a+o)?a+=o:1===Math.abs(a-o)&&(a-=o)),t.dem&&e.dem&&(e.dem.backfillBorder(t.dem,a,r),(null===(i=e.neighboringTiles)||void 0===i?void 0:i[s])&&(e.neighboringTiles[s].backfilled=!0)));}class Le{constructor(){this._tiles={};}handleWrapJump(e){const t={};for(const i in this._tiles){const a=this._tiles[i];a.tileID=a.tileID.unwrapTo(a.tileID.wrap+e),t[a.tileID.key]=a;}this._tiles=t;}setFeatureState(e,t){for(const i in this._tiles)this._tiles[i].setFeatureState(e,t);}getAllTiles(){return Object.values(this._tiles)}getAllIds(e=!1){return e?Object.values(this._tiles).map((e=>e.tileID)).sort(t.aw).map((e=>e.key)):Object.keys(this._tiles)}getTileById(e){return this._tiles[e]}setTile(e,t){this._tiles[e]=t;}deleteTileById(e){delete this._tiles[e];}getLoadedTile(e){const t=this.getTileById(e.key);return (null==t?void 0:t.hasData())?t:null}isIdRenderable(e,t=!1){var i;return null===(i=this.getTileById(e))||void 0===i?void 0:i.isRenderable(t)}getRenderableIds(e=0,i){const a=[];for(const e of this.getAllIds())this.isIdRenderable(e,i)&&a.push(this.getTileById(e));return i?a.sort(((i,a)=>{const r=i.tileID,o=a.tileID,s=new t.P(r.canonical.x,r.canonical.y)._rotate(-e),n=new t.P(o.canonical.x,o.canonical.y)._rotate(-e);return r.overscaledZ-o.overscaledZ||n.y-s.y||n.x-s.x})).map((e=>e.tileID.key)):a.map((e=>e.tileID)).sort(t.aw).map((e=>e.key))}}class ke extends t.E{constructor(e,i,a){super(),this.id=e,this.dispatcher=a,this.on("data",(e=>this._dataHandler(e))),this.on("dataloading",(()=>{this._sourceErrored=!1;})),this.on("error",(()=>{this._sourceErrored=this._source.loaded();})),this._source=((e,t,i,a)=>{const r=new(oe(t.type))(e,t,i,a);if(r.id!==e)throw new Error(`Expected Source id to be ${e} instead of ${r.id}`);return r})(e,i,a,this),this._inViewTiles=new Le,this._outOfViewCache=new t.ax(0,(e=>this._unloadTile(e))),this._timers={},this._maxTileCacheSize=null,this._maxTileCacheZoomLevels=null,this._rasterFadeDuration=0,this._maxFadingAncestorLevels=5,this._state=new _e,this._didEmitContent=!1,this._updated=!1;}onAdd(e){this.map=e,this._maxTileCacheSize=e?e._maxTileCacheSize:null,this._maxTileCacheZoomLevels=e?e._maxTileCacheZoomLevels:null,this._source&&this._source.onAdd&&this._source.onAdd(e);}onRemove(e){for(const e of this._inViewTiles.getAllTiles())e.unloadVectorData();this.clearTiles(),this._source&&this._source.onRemove&&this._source.onRemove(e),this._inViewTiles=new Le;}loaded(){if(this._sourceErrored)return !0;if(!this._sourceLoaded)return !1;if(!this._source.loaded())return !1;if(!(void 0===this.used&&void 0===this.usedForTerrain||this.used||this.usedForTerrain))return !0;if(!this._updated)return !1;for(const e of this._inViewTiles.getAllTiles())if("loaded"!==e.state&&"errored"!==e.state)return !1;return !0}getSource(){return this._source}getState(){return this._state}pause(){this._paused=!0;}resume(){if(!this._paused)return;const e=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,e&&this.reload(),this.transform&&this.update(this.transform,this.terrain);}_loadTile(e,i,a){return t._(this,void 0,void 0,(function*(){try{yield this._source.loadTile(e),this._tileLoaded(e,i,a);}catch(i){e.state="errored",404!==i.status?this._source.fire(new t.k(i,{tile:e})):this.update(this.transform,this.terrain);}}))}_unloadTile(e){this._source.unloadTile&&this._source.unloadTile(e);}_abortTile(e){this._source.abortTile&&this._source.abortTile(e),this._source.fire(new t.l("dataabort",{tile:e,coord:e.tileID,dataType:"source"}));}serialize(){return this._source.serialize()}prepare(e){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._inViewTiles,this.map?this.map.painter:null);for(const t of this._inViewTiles.getAllTiles())t.upload(e),t.prepare(this.map.style.imageManager);}getIds(){return this._inViewTiles.getAllIds(!0)}getRenderableIds(e){var t;return this._inViewTiles.getRenderableIds(null===(t=this.transform)||void 0===t?void 0:t.bearingInRadians,e)}hasRenderableParent(e){const t=e.overscaledZ-1;if(t>=this._source.minzoom){const i=this.getLoadedTile(e.scaledTo(t));if(i)return this._inViewTiles.isIdRenderable(i.tileID.key)}return !1}reload(e,t=void 0){if(this._paused)this._shouldReloadOnResume=!0;else {this._outOfViewCache.reset();for(const i of this._inViewTiles.getAllIds()){const a=this._inViewTiles.getTileById(i);t&&!this._source.shouldReloadTile(a,t)||(e?this._reloadTile(i,"expired"):"errored"!==a.state&&this._reloadTile(i,"reloading"));}}}_reloadTile(e,i){return t._(this,void 0,void 0,(function*(){const t=this._inViewTiles.getTileById(e);t&&("loading"!==t.state&&(t.state=i),yield this._loadTile(t,e,i));}))}_tileLoaded(e,i,a){e.timeAdded=c(),e.selfFading&&(e.fadeEndTime=e.timeAdded+this._rasterFadeDuration),"expired"===a&&(e.refreshedUponExpiration=!0),this._setTileReloadTimer(i,e),"raster-dem"===this.getSource().type&&e.dem&&function(e,t){var i,a;const r=t.getRenderableIds();for(const o of r){if(!e.neighboringTiles||!e.neighboringTiles[o])continue;const r=t.getTileById(o);e.neighboringTiles[o].backfilled||Ae(e,r),(null===(a=null===(i=r.neighboringTiles)||void 0===i?void 0:i[e.tileID.key])||void 0===a?void 0:a.backfilled)||Ae(r,e);}}(e,this._inViewTiles),this._state.initializeTileState(e,this.map?this.map.painter:null),e.aborted||this._source.fire(new t.l("data",{dataType:"source",tile:e,coord:e.tileID}));}getTile(e){return this.getTileByID(e.key)}getTileByID(e){return this._inViewTiles.getTileById(e)}_retainLoadedChildren(e,t){const i=this._getLoadedDescendents(t),a=new Set;for(const r of t){const t=i[r.key];if(!(null==t?void 0:t.length)){a.add(r);continue}const o=r.overscaledZ+ke.maxOverzooming,s=t.filter((e=>e.tileID.overscaledZ<=o));if(!s.length){a.add(r);continue}const n=Math.min(...s.map((e=>e.tileID.overscaledZ))),l=s.filter((e=>e.tileID.overscaledZ===n)).map((e=>e.tileID));for(const t of l)e[t.key]=t;this._areDescendentsComplete(l,n,r.overscaledZ)||a.add(r);}return a}_getLoadedDescendents(e){var t;const i={};for(const a of this._inViewTiles.getAllTiles().filter((e=>e.hasData())))for(const r of e)a.tileID.isChildOf(r)&&(i[t=r.key]||(i[t]=[])).push(a);return i}_areDescendentsComplete(e,t,i){return 1===e.length&&e[0].isOverscaled()?e[0].overscaledZ===t:Math.pow(4,t-i)===e.length}getLoadedTile(e){return this._inViewTiles.getLoadedTile(e)}updateCacheSize(e){const i=Math.ceil(e.width/this._source.tileSize)+1,a=Math.ceil(e.height/this._source.tileSize)+1,r=Math.floor(i*a*(null===this._maxTileCacheZoomLevels?t.c.MAX_TILE_CACHE_ZOOM_LEVELS:this._maxTileCacheZoomLevels)),o="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,r):r;this._outOfViewCache.setMaxSize(o);}handleWrapJump(e){const t=Math.round((e-(void 0===this._prevLng?e:this._prevLng))/360);this._prevLng=e,t&&(this._inViewTiles.handleWrapJump(t),this._resetTileReloadTimers());}update(e,i){if(!this._sourceLoaded||this._paused)return;let a;this.transform=e,this.terrain=i,this.updateCacheSize(e),this.handleWrapJump(this.transform.center.lng),this.used||this.usedForTerrain?this._source.tileID?a=e.getVisibleUnwrappedCoordinates(this._source.tileID).map((e=>new t.a2(e.canonical.z,e.wrap,e.canonical.z,e.canonical.x,e.canonical.y))):(a=Ie(e,{tileSize:this.usedForTerrain?this.tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:"vector"===this._source.type&&void 0!==this.map._zoomLevelsToOverscale?e.maxZoom-this.map._zoomLevelsToOverscale:this._source.maxzoom,roundZoom:!this.usedForTerrain&&this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled,terrain:i,calculateTileZoom:this._source.calculateTileZoom}),this._source.hasTile&&(a=a.filter((e=>this._source.hasTile(e))))):a=[],this.usedForTerrain&&(a=this._addTerrainIdealTiles(a));const r=0===a.length&&!this._updated&&this._didEmitContent;this._updated=!0,r&&this.fire(new t.l("data",{sourceDataType:"idle",dataType:"source",sourceId:this.id}));const o=Ce(e,this._source),s=this._updateRetainedTiles(a,o),n=Ee(this._source.type);n&&this._rasterFadeDuration>0&&!i&&function(e,i,a,r,o,s,n){const l=c(),h=t.av(i);for(const t of i){const i=e.getTileById(t.key);i.fadingDirection!==ue.Departing&&0!==i.fadeOpacity||i.resetFadeLogic(),Se(e,i,a,l,r,o,n)||ze(e,i,a,l,s,n)||De(i,h,l,n)||i.resetFadeLogic();}}(this._inViewTiles,a,s,this._maxFadingAncestorLevels,this._source.minzoom,this._source.maxzoom,this._rasterFadeDuration),n?this._cleanUpRasterTiles(s):this._cleanUpVectorTiles(s);}_cleanUpRasterTiles(e){for(const t of this._inViewTiles.getAllIds())e[t]||this._removeTile(t);}_cleanUpVectorTiles(e){for(const t of this._inViewTiles.getAllIds()){const i=this._inViewTiles.getTileById(t);e[t]?i.clearSymbolFadeHold():i.hasSymbolBuckets?i.holdingForSymbolFade()?i.symbolFadeFinished()&&this._removeTile(t):i.setSymbolHoldDuration(this.map._fadeDuration):this._removeTile(t);}}_addTerrainIdealTiles(e){const t=[];for(const i of e)if(i.canonical.z>this._source.minzoom){const e=i.scaledTo(i.canonical.z-1);t.push(e);const a=i.scaledTo(Math.max(this._source.minzoom,Math.min(i.canonical.z,5)));t.push(a);}return e.concat(t)}releaseSymbolFadeTiles(){for(const e of this._inViewTiles.getAllIds())this._inViewTiles.getTileById(e).holdingForSymbolFade()&&this._removeTile(e);}_updateRetainedTiles(e,t){var i;const a=new Set;for(const t of e)this._addTile(t).hasData()||a.add(t);const r=e.reduce(((e,t)=>(e[t.key]=t,e)),{}),o=this._retainLoadedChildren(r,a),s={},n=Math.max(t-ke.maxUnderzooming,this._source.minzoom);for(const e of o){let t=this._inViewTiles.getTileById(e.key),a=null==t?void 0:t.wasRequested();for(let o=e.overscaledZ-1;o>=n;--o){const n=e.scaledTo(o);if(s[n.key])break;if(s[n.key]=!0,t=this.getTile(n),!t&&a&&(t=this._addTile(n)),t){const e=t.hasData();if((e||!(null===(i=this.map)||void 0===i?void 0:i.cancelPendingTileRequestsWhileZooming)||a)&&(r[n.key]=n),a=t.wasRequested(),e)break}}}return r}_addTile(e){let i=this._inViewTiles.getTileById(e.key);if(i)return i;i=this._outOfViewCache.getAndRemove(e),i&&(i.resetFadeLogic(),this._setTileReloadTimer(e.key,i),i.tileID=e,this._state.initializeTileState(i,this.map?this.map.painter:null));const a=i;return i||(i=new de(e,this._source.tileSize*e.overscaleFactor()),this._loadTile(i,e.key,i.state)),i.uses++,this._inViewTiles.setTile(e.key,i),a||this._source.fire(new t.l("dataloading",{tile:i,coord:i.tileID,dataType:"source"})),i}_setTileReloadTimer(e,t){this._clearTileReloadTimer(e);const i=t.getExpiryTimeout();i&&(this._timers[e]=setTimeout((()=>{this._reloadTile(e,"expired"),delete this._timers[e];}),i));}_clearTileReloadTimer(e){const t=this._timers[e];t&&(clearTimeout(t),delete this._timers[e]);}_resetTileReloadTimers(){for(const e in this._timers)clearTimeout(this._timers[e]),delete this._timers[e];for(const e of this._inViewTiles.getAllIds()){const t=this._inViewTiles.getTileById(e);this._setTileReloadTimer(e,t);}}refreshTiles(e){for(const t of this._inViewTiles.getAllIds()){const i=this._inViewTiles.getTileById(t);(this._inViewTiles.isIdRenderable(t)||"errored"==i.state)&&e.some((e=>e.equals(i.tileID.canonical)))&&this._reloadTile(t,"expired");}}_removeTile(e){const t=this._inViewTiles.getTileById(e);t&&(t.uses--,this._inViewTiles.deleteTileById(e),this._clearTileReloadTimer(e),t.uses>0||(t.hasData()&&"reloading"!==t.state?this._outOfViewCache.add(t.tileID,t,t.getExpiryTimeout()):(t.aborted=!0,this._abortTile(t),this._unloadTile(t))));}_dataHandler(e){"source"===e.dataType&&("metadata"!==e.sourceDataType?"content"===e.sourceDataType&&this._sourceLoaded&&!this._paused&&(this.reload(e.sourceDataChanged,e.shouldReloadTileOptions),this.transform&&this.update(this.transform,this.terrain),this._didEmitContent=!0):this._sourceLoaded=!0);}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const e of this._inViewTiles.getAllIds())this._removeTile(e);this._outOfViewCache.reset();}tilesIn(e,i,a){const r=[],o=this.transform;if(!o)return r;const s=o.getCoveringTilesDetailsProvider().allowWorldCopies(),n=a?o.getCameraQueryGeometry(e):e,l=e=>o.screenPointToMercatorCoordinate(e,this.terrain),c=this.transformBbox(e,l,!s),h=this.transformBbox(n,l,!s),u=this.getIds(),d=t.aa.fromPoints(h);for(let e=0;e<u.length;e++){const a=this._inViewTiles.getTileById(u[e]);if(a.holdingForSymbolFade())continue;const n=s?[a.tileID]:[a.tileID.unwrapTo(-1),a.tileID.unwrapTo(0)],l=Math.pow(2,o.zoom-a.tileID.overscaledZ),_=i*a.queryPadding*t.a5/a.tileSize/l;for(const e of n){const i=d.map((i=>e.getTilePoint(new t.a9(i.x,i.y))));if(i.expandBy(_),i.intersects(Me)){const t=c.map((t=>e.getTilePoint(t))),i=h.map((t=>e.getTilePoint(t)));r.push({tile:a,tileID:s?e:e.unwrapTo(0),queryGeometry:t,cameraQueryGeometry:i,scale:l});}}}return r}transformBbox(e,i,a){let r=e.map(i);if(a){const a=t.aa.fromPoints(e);a.shrinkBy(.001*Math.min(a.width(),a.height()));const o=a.map(i);t.aa.fromPoints(r).covers(o)||(r=r.map((e=>e.x>.5?new t.a9(e.x-1,e.y,e.z):e)));}return r}getVisibleCoordinates(e){const t=this.getRenderableIds(e).map((e=>this._inViewTiles.getTileById(e).tileID));return this.transform&&this.transform.populateCache(t),t}hasTransition(){return !!this._source.hasTransition()||!(!Ee(this._source.type)||!function(e,t){if(t<=0)return !1;const i=c();for(const t of e.getAllTiles())if(t.fadeEndTime>=i)return !0;return !1}(this._inViewTiles,this._rasterFadeDuration))}setRasterFadeDuration(e){this._rasterFadeDuration=e;}setFeatureState(e,i,a){this._state.updateState(e=e||t.ai,i,a);}removeFeatureState(e,i,a){this._state.removeFeatureState(e=e||t.ai,i,a);}getFeatureState(e,i){return this._state.getState(e=e||t.ai,i)}setDependencies(e,t,i){const a=this._inViewTiles.getTileById(e);a&&a.setDependencies(t,i);}reloadTilesForDependencies(e,t){for(const i of this._inViewTiles.getAllIds())this._inViewTiles.getTileById(i).hasDependency(e,t)&&this._reloadTile(i,"reloading");this._outOfViewCache.filter((i=>!i.hasDependency(e,t)));}areTilesLoaded(){for(const e of this._inViewTiles.getAllTiles())if("loaded"!==e.state&&"errored"!==e.state)return !1;return !0}}ke.maxUnderzooming=10,ke.maxOverzooming=3;class Fe{constructor(e,t){this.reset(e,t);}reset(e,t){this.points=e||[],this._distances=[0];for(let e=1;e<this.points.length;e++)this._distances[e]=this._distances[e-1]+this.points[e].dist(this.points[e-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(t||0,.5*this.length),this.paddedLength=this.length-2*this.padding;}lerp(e){if(1===this.points.length)return this.points[0];e=t.an(e,0,1);let i=1,a=this._distances[i];const r=e*this.paddedLength+this.padding;for(;a<r&&i<this._distances.length;)a=this._distances[++i];const o=i-1,s=this._distances[o],n=a-s,l=n>0?(r-s)/n:0;return this.points[o].mult(1-l).add(this.points[i].mult(l))}}function Be(e,t){let i=!0;return "always"===e||"never"!==e&&"never"!==t||(i=!1),i}class Oe{constructor(e,t,i){const a=this.boxCells=[],r=this.circleCells=[];this.xCellCount=Math.ceil(e/i),this.yCellCount=Math.ceil(t/i);for(let e=0;e<this.xCellCount*this.yCellCount;e++)a.push([]),r.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=e,this.height=t,this.xScale=this.xCellCount/e,this.yScale=this.yCellCount/t,this.boxUid=0,this.circleUid=0;}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(e,t,i,a,r){this._forEachCell(t,i,a,r,this._insertBoxCell,this.boxUid++),this.boxKeys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(a),this.bboxes.push(r);}insertCircle(e,t,i,a){this._forEachCell(t-a,i-a,t+a,i+a,this._insertCircleCell,this.circleUid++),this.circleKeys.push(e),this.circles.push(t),this.circles.push(i),this.circles.push(a);}_insertBoxCell(e,t,i,a,r,o){this.boxCells[r].push(o);}_insertCircleCell(e,t,i,a,r,o){this.circleCells[r].push(o);}_query(e,t,i,a,r,o,s){if(i<0||e>this.width||a<0||t>this.height)return [];const n=[];if(e<=0&&t<=0&&this.width<=i&&this.height<=a){if(r)return [{key:null,x1:e,y1:t,x2:i,y2:a}];for(let e=0;e<this.boxKeys.length;e++)n.push({key:this.boxKeys[e],x1:this.bboxes[4*e],y1:this.bboxes[4*e+1],x2:this.bboxes[4*e+2],y2:this.bboxes[4*e+3]});for(let e=0;e<this.circleKeys.length;e++){const t=this.circles[3*e],i=this.circles[3*e+1],a=this.circles[3*e+2];n.push({key:this.circleKeys[e],x1:t-a,y1:i-a,x2:t+a,y2:i+a});}}else this._forEachCell(e,t,i,a,this._queryCell,n,{hitTest:r,overlapMode:o,seenUids:{box:{},circle:{}}},s);return n}query(e,t,i,a){return this._query(e,t,i,a,!1,null)}hitTest(e,t,i,a,r,o){return this._query(e,t,i,a,!0,r,o).length>0}hitTestCircle(e,t,i,a,r){const o=e-i,s=e+i,n=t-i,l=t+i;if(s<0||o>this.width||l<0||n>this.height)return !1;const c=[];return this._forEachCell(o,n,s,l,this._queryCellCircle,c,{hitTest:!0,overlapMode:a,circle:{x:e,y:t,radius:i},seenUids:{box:{},circle:{}}},r),c.length>0}_queryCell(e,t,i,a,r,o,s,n){const{seenUids:l,hitTest:c,overlapMode:h}=s,u=this.boxCells[r];if(null!==u){const r=this.bboxes;for(const s of u)if(!l.box[s]){l.box[s]=!0;const u=4*s,d=this.boxKeys[s];if(e<=r[u+2]&&t<=r[u+3]&&i>=r[u+0]&&a>=r[u+1]&&(!n||n(d))&&(!c||!Be(h,d.overlapMode))&&(o.push({key:d,x1:r[u],y1:r[u+1],x2:r[u+2],y2:r[u+3]}),c))return !0}}const d=this.circleCells[r];if(null!==d){const r=this.circles;for(const s of d)if(!l.circle[s]){l.circle[s]=!0;const u=3*s,d=this.circleKeys[s];if(this._circleAndRectCollide(r[u],r[u+1],r[u+2],e,t,i,a)&&(!n||n(d))&&(!c||!Be(h,d.overlapMode))){const e=r[u],t=r[u+1],i=r[u+2];if(o.push({key:d,x1:e-i,y1:t-i,x2:e+i,y2:t+i}),c)return !0}}}return !1}_queryCellCircle(e,t,i,a,r,o,s,n){const{circle:l,seenUids:c,overlapMode:h}=s,u=this.boxCells[r];if(null!==u){const e=this.bboxes;for(const t of u)if(!c.box[t]){c.box[t]=!0;const i=4*t,a=this.boxKeys[t];if(this._circleAndRectCollide(l.x,l.y,l.radius,e[i+0],e[i+1],e[i+2],e[i+3])&&(!n||n(a))&&!Be(h,a.overlapMode))return o.push(!0),!0}}const d=this.circleCells[r];if(null!==d){const e=this.circles;for(const t of d)if(!c.circle[t]){c.circle[t]=!0;const i=3*t,a=this.circleKeys[t];if(this._circlesCollide(e[i],e[i+1],e[i+2],l.x,l.y,l.radius)&&(!n||n(a))&&!Be(h,a.overlapMode))return o.push(!0),!0}}}_forEachCell(e,t,i,a,r,o,s,n){const l=this._convertToXCellCoord(e),c=this._convertToYCellCoord(t),h=this._convertToXCellCoord(i),u=this._convertToYCellCoord(a);for(let d=l;d<=h;d++)for(let l=c;l<=u;l++)if(r.call(this,e,t,i,a,this.xCellCount*l+d,o,s,n))return}_convertToXCellCoord(e){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(e*this.xScale)))}_convertToYCellCoord(e){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(e*this.yScale)))}_circlesCollide(e,t,i,a,r,o){const s=a-e,n=r-t,l=i+o;return l*l>s*s+n*n}_circleAndRectCollide(e,t,i,a,r,o,s){const n=(o-a)/2,l=Math.abs(e-(a+n));if(l>n+i)return !1;const c=(s-r)/2,h=Math.abs(t-(r+c));if(h>c+i)return !1;if(l<=n||h<=c)return !0;const u=l-n,d=h-c;return u*u+d*d<=i*i}}function je(e,i,r){const o=t.N();if(!e){const{vecSouth:e,vecEast:t}=Ze(i),r=a();r[0]=t[0],r[1]=t[1],r[2]=e[0],r[3]=e[1],s=r,(d=(l=(n=r)[0])*(u=n[3])-(h=n[2])*(c=n[1]))&&(s[0]=u*(d=1/d),s[1]=-c*d,s[2]=-h*d,s[3]=l*d),o[0]=r[0],o[1]=r[1],o[4]=r[2],o[5]=r[3];}var s,n,l,c,h,u,d;return t.Q(o,o,[1/r,1/r,1]),o}function Ne(e,i,a,r){if(e){const e=t.N();if(!i){const{vecSouth:t,vecEast:i}=Ze(a);e[0]=i[0],e[1]=i[1],e[4]=t[0],e[5]=t[1];}return t.Q(e,e,[r,r,1]),e}return a.pixelsToClipSpaceMatrix}function Ze(e){const i=Math.cos(e.rollInRadians),a=Math.sin(e.rollInRadians),r=Math.cos(e.pitchInRadians),o=Math.cos(e.bearingInRadians),s=Math.sin(e.bearingInRadians),n=t.aC();n[0]=-o*r*a-s*i,n[1]=-s*r*a+o*i;const l=t.aD(n);l<1e-9?t.aE(n):t.aF(n,n,1/l);const c=t.aC();c[0]=o*r*i-s*a,c[1]=s*r*i+o*a;const h=t.aD(c);return h<1e-9?t.aE(c):t.aF(c,c,1/h),{vecEast:c,vecSouth:n}}function Ge(e,i,a,r){let o;r?(o=[e,i,r(e,i),1],t.aH(o,o,a)):(o=[e,i,0,1],ot(o,o,a));const s=o[3];return {point:new t.P(o[0]/s,o[1]/s),signedDistanceFromCamera:s,isOccluded:!1}}function Ue(e,t){return .5+e/t*.5}function Ve(e,t){return e.x>=-t[0]&&e.x<=t[0]&&e.y>=-t[1]&&e.y<=t[1]}function qe(e,i,a,r,o,s,n,l,c,h,u,d,_){const p=a?e.textSizeData:e.iconSizeData,m=t.ay(p,i.transform.zoom),f=[256/i.width*2+1,256/i.height*2+1],g=a?e.text.dynamicLayoutVertexArray:e.icon.dynamicLayoutVertexArray;g.clear();const v=e.lineVertexArray,x=a?e.text.placedSymbolArray:e.icon.placedSymbolArray,b=i.transform.width/i.transform.height;let y=!1;for(let a=0;a<x.length;a++){const w=x.get(a);if(w.hidden||w.writingMode===t.az.vertical&&!y){rt(w.numGlyphs,g);continue}y=!1;const T=new t.P(w.anchorX,w.anchorY),P={getElevation:_,pitchedLabelPlaneMatrix:r,lineVertexArray:v,pitchWithMap:s,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:i.transform,tileAnchorPoint:T,unwrappedTileID:c,width:h,height:u,translation:d},C=Je(w.anchorX,w.anchorY,P);if(!Ve(C.point,f)){rt(w.numGlyphs,g);continue}const I=Ue(i.transform.cameraToCenterDistance,C.signedDistanceFromCamera),M=t.aA(p,m,w),E=s?M*i.transform.getPitchedTextCorrection(w.anchorX,w.anchorY,c)/I:M*I,S=He({projectionContext:P,pitchedLabelPlaneMatrixInverse:o,symbol:w,fontSize:E,flip:!1,keepUpright:n,glyphOffsetArray:e.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:b,rotateToLine:l});y=S.useVertical,(S.notEnoughRoom||y||S.needsFlipping&&He({projectionContext:P,pitchedLabelPlaneMatrixInverse:o,symbol:w,fontSize:E,flip:!0,keepUpright:n,glyphOffsetArray:e.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:b,rotateToLine:l}).notEnoughRoom)&&rt(w.numGlyphs,g);}a?e.text.dynamicLayoutVertexBuffer.updateData(g):e.icon.dynamicLayoutVertexBuffer.updateData(g);}function We(e,t,i,a,r,o,s,n){const l=o.glyphStartIndex+o.numGlyphs,c=o.lineStartIndex,h=o.lineStartIndex+o.lineLength,u=t.getoffsetX(o.glyphStartIndex),d=t.getoffsetX(l-1),_=it(e*u,i,a,r,o.segment,c,h,n,s);if(!_)return null;const p=it(e*d,i,a,r,o.segment,c,h,n,s);return p?n.projectionCache.anyProjectionOccluded?null:{first:_,last:p}:null}function $e(e,i,a,r){return e===t.az.horizontal&&Math.abs(a.y-i.y)>Math.abs(a.x-i.x)*r?{useVertical:!0}:(e===t.az.vertical?i.y<a.y:i.x>a.x)?{needsFlipping:!0}:null}function He(e){const{projectionContext:i,pitchedLabelPlaneMatrixInverse:a,symbol:r,fontSize:o,flip:s,keepUpright:n,glyphOffsetArray:l,dynamicLayoutVertexArray:c,aspectRatio:h,rotateToLine:u}=e,d=o/24,_=r.lineOffsetX*d,p=r.lineOffsetY*d;let m;if(r.numGlyphs>1){const e=r.glyphStartIndex+r.numGlyphs,t=r.lineStartIndex,o=r.lineStartIndex+r.lineLength,c=We(d,l,_,p,s,r,u,i);if(!c)return {notEnoughRoom:!0};const f=Qe(c.first.point.x,c.first.point.y,i,a),g=Qe(c.last.point.x,c.last.point.y,i,a);if(n&&!s){const e=$e(r.writingMode,f,g,h);if(e)return e}m=[c.first];for(let a=r.glyphStartIndex+1;a<e-1;a++){const e=it(d*l.getoffsetX(a),_,p,s,r.segment,t,o,i,u);if(!e)return {notEnoughRoom:!0};m.push(e);}m.push(c.last);}else {if(n&&!s){const e=Ye(i.tileAnchorPoint.x,i.tileAnchorPoint.y,i).point,o=r.lineStartIndex+r.segment+1,s=new t.P(i.lineVertexArray.getx(o),i.lineVertexArray.gety(o)),n=Ye(s.x,s.y,i),l=n.signedDistanceFromCamera>0?n.point:Xe(i.tileAnchorPoint,s,e,1,i),c=Qe(e.x,e.y,i,a),u=Qe(l.x,l.y,i,a),d=$e(r.writingMode,c,u,h);if(d)return d}const e=it(d*l.getoffsetX(r.glyphStartIndex),_,p,s,r.segment,r.lineStartIndex,r.lineStartIndex+r.lineLength,i,u);if(!e||i.projectionCache.anyProjectionOccluded)return {notEnoughRoom:!0};m=[e];}for(const e of m)t.aG(c,e.point,e.angle);return {}}function Xe(e,t,i,a,r){const o=e.add(e.sub(t)._unit()),s=Ye(o.x,o.y,r).point,n=i.sub(s);return i.add(n._mult(a/n.mag()))}function Ke(e,i,a){const r=i.projectionCache;if(r.projections[e])return r.projections[e];const o=new t.P(i.lineVertexArray.getx(e),i.lineVertexArray.gety(e)),s=Ye(o.x,o.y,i);if(s.signedDistanceFromCamera>0)return r.projections[e]=s.point,r.anyProjectionOccluded=r.anyProjectionOccluded||s.isOccluded,s.point;const n=e-a.direction;return Xe(0===a.distanceFromAnchor?i.tileAnchorPoint:new t.P(i.lineVertexArray.getx(n),i.lineVertexArray.gety(n)),o,a.previousVertex,a.absOffsetX-a.distanceFromAnchor+1,i)}function Ye(e,t,i){const a=e+i.translation[0],r=t+i.translation[1];let o;return i.pitchWithMap?(o=Ge(a,r,i.pitchedLabelPlaneMatrix,i.getElevation),o.isOccluded=!1):(o=i.transform.projectTileCoordinates(a,r,i.unwrappedTileID,i.getElevation),o.point.x=(.5*o.point.x+.5)*i.width,o.point.y=(.5*-o.point.y+.5)*i.height),o}function Qe(e,i,a,r){if(a.pitchWithMap){const o=[e,i,0,1];return t.aH(o,o,r),a.transform.projectTileCoordinates(o[0]/o[3],o[1]/o[3],a.unwrappedTileID,a.getElevation).point}return {x:e/a.width*2-1,y:1-i/a.height*2}}function Je(e,t,i){return i.transform.projectTileCoordinates(e,t,i.unwrappedTileID,i.getElevation)}function et(e,t,i){return e._unit()._perp()._mult(t*i)}function tt(e,i,a,r,o,s,n,l,c){if(l.projectionCache.offsets[e])return l.projectionCache.offsets[e];const h=a.add(i);if(e+c.direction<r||e+c.direction>=o)return l.projectionCache.offsets[e]=h,h;const u=Ke(e+c.direction,l,c),d=et(u.sub(a),n,c.direction),_=a.add(d),p=u.add(d);return l.projectionCache.offsets[e]=t.aI(s,h,_,p)||h,l.projectionCache.offsets[e]}function it(e,t,i,a,r,o,s,n,l){const c=a?e-t:e+t;let h=c>0?1:-1,u=0;a&&(h*=-1,u=Math.PI),h<0&&(u+=Math.PI);let d,_=h>0?o+r:o+r+1;n.projectionCache.cachedAnchorPoint?d=n.projectionCache.cachedAnchorPoint:(d=Ye(n.tileAnchorPoint.x,n.tileAnchorPoint.y,n).point,n.projectionCache.cachedAnchorPoint=d);let p,m,f=d,g=d,v=0,x=0;const b=Math.abs(c),y=[];let w;for(;v+x<=b;){if(_+=h,_<o||_>=s)return null;v+=x,g=f,m=p;const e={absOffsetX:b,direction:h,distanceFromAnchor:v,previousVertex:g};if(f=Ke(_,n,e),0===i)y.push(g),w=f.sub(g);else {let t;const a=f.sub(g);t=0===a.mag()?et(Ke(_+h,n,e).sub(f),i,h):et(a,i,h),m||(m=g.add(t)),p=tt(_,t,f,o,s,m,i,n,e),y.push(m),w=p.sub(m);}x=w.mag();}const T=w._mult((b-v)/x)._add(m||g),P=u+Math.atan2(f.y-g.y,f.x-g.x);return y.push(T),{point:T,angle:l?P:0,path:y}}const at=new Float32Array([-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0]);function rt(e,t){for(let i=0;i<e;i++){const e=t.length;t.resize(e+4),t.float32.set(at,3*e);}}function ot(e,t,i){const a=t[0],r=t[1];return e[0]=i[0]*a+i[4]*r+i[12],e[1]=i[1]*a+i[5]*r+i[13],e[3]=i[3]*a+i[7]*r+i[15],e}const st=100;class nt{constructor(e,t=new Oe(e.width+200,e.height+200,25),i=new Oe(e.width+200,e.height+200,25)){this.transform=e,this.grid=t,this.ignoredGrid=i,this.pitchFactor=Math.cos(e.pitch*Math.PI/180)*e.cameraToCenterDistance,this.screenRightBoundary=e.width+st,this.screenBottomBoundary=e.height+st,this.gridRightBoundary=e.width+200,this.gridBottomBoundary=e.height+200,this.perspectiveRatioCutoff=.6;}placeCollisionBox(e,t,i,a,r,o,s,n,l,c,h,u){const d=this.projectAndGetPerspectiveRatio(e.anchorPointX+n[0],e.anchorPointY+n[1],r,c,u),_=i*d.perspectiveRatio;let p;if(o||s)p=this._projectCollisionBox(e,_,a,r,o,s,n,d,c,h,u);else {const t=d.x+(h?h.x*_:0),i=d.y+(h?h.y*_:0);p={allPointsOccluded:!1,box:[t+e.x1*_,i+e.y1*_,t+e.x2*_,i+e.y2*_]};}const[m,f,g,v]=p.box,x=o?p.allPointsOccluded:d.isOccluded;let b=x;return b||(b=d.perspectiveRatio<this.perspectiveRatioCutoff),b||(b=!this.isInsideGrid(m,f,g,v)),b||"always"!==t&&this.grid.hitTest(m,f,g,v,t,l)?{box:[m,f,g,v],placeable:!1,offscreen:!1,occluded:x}:{box:[m,f,g,v],placeable:!0,offscreen:this.isOffscreen(m,f,g,v),occluded:x}}placeCollisionCircles(e,i,a,r,o,s,n,l,c,h,u,d,_,p){const m=[],f=new t.P(i.anchorX,i.anchorY),g=this.getPerspectiveRatio(f.x,f.y,s,p),v=(c?o*this.transform.getPitchedTextCorrection(i.anchorX,i.anchorY,s)/g:o*g)/t.aM,x={getElevation:p,pitchedLabelPlaneMatrix:n,lineVertexArray:a,pitchWithMap:c,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:this.transform,tileAnchorPoint:f,unwrappedTileID:s,width:this.transform.width,height:this.transform.height,translation:_},b=We(v,r,i.lineOffsetX*v,i.lineOffsetY*v,!1,i,!1,x);let y=!1,w=!1,T=!0;if(b){const i=.5*u*g+d,a=new t.P(-100,-100),r=new t.P(this.screenRightBoundary,this.screenBottomBoundary),o=new Fe,s=b.first,n=b.last;let _=[];for(let e=s.path.length-1;e>=1;e--)_.push(s.path[e]);for(let e=1;e<n.path.length;e++)_.push(n.path[e]);const p=2.5*i;if(c){const e=this.projectPathToScreenSpace(_,x);_=e.some((e=>e.signedDistanceFromCamera<=0))?[]:e.map((e=>e.point));}let f=[];if(_.length>0){const e=_[0].clone(),i=_[0].clone();for(let t=1;t<_.length;t++)e.x=Math.min(e.x,_[t].x),e.y=Math.min(e.y,_[t].y),i.x=Math.max(i.x,_[t].x),i.y=Math.max(i.y,_[t].y);f=e.x>=a.x&&i.x<=r.x&&e.y>=a.y&&i.y<=r.y?[_]:i.x<a.x||e.x>r.x||i.y<a.y||e.y>r.y?[]:t.aJ([_],a.x,a.y,r.x,r.y);}for(const t of f){o.reset(t,.25*i);let a=0;a=o.length<=.5*i?1:Math.ceil(o.paddedLength/p)+1;for(let t=0;t<a;t++){const r=t/Math.max(a-1,1),s=o.lerp(r),n=s.x+st,c=s.y+st;m.push(n,c,i,0);const u=n-i,d=c-i,_=n+i,p=c+i;if(T=T&&this.isOffscreen(u,d,_,p),w=w||this.isInsideGrid(u,d,_,p),"always"!==e&&this.grid.hitTestCircle(n,c,i,e,h)&&(y=!0,!l))return {circles:[],offscreen:!1,collisionDetected:y}}}}return {circles:!l&&y||!w||g<this.perspectiveRatioCutoff?[]:m,offscreen:T,collisionDetected:y}}projectPathToScreenSpace(e,i){const a=function(e,i){const a=t.N();return t.aB(a,i.pitchedLabelPlaneMatrix),e.map((e=>{const t=Ge(e.x,e.y,a,i.getElevation),r=i.transform.projectTileCoordinates(t.point.x,t.point.y,i.unwrappedTileID,i.getElevation);return r.point.x=(.5*r.point.x+.5)*i.width,r.point.y=(.5*-r.point.y+.5)*i.height,r}))}(e,i);return function(e){let t=0,i=0,a=0,r=0;for(let o=0;o<e.length;o++)e[o].isOccluded?(a=o+1,r=0):(r++,r>i&&(i=r,t=a));return e.slice(t,t+i)}(a)}queryRenderedSymbols(e){if(0===e.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return {};const i=[],a=new t.aa;for(const r of e){const e=new t.P(r.x+st,r.y+st);a.extend(e),i.push(e);}const{minX:r,minY:o,maxX:s,maxY:n}=a,l=this.grid.query(r,o,s,n).concat(this.ignoredGrid.query(r,o,s,n)),c={},h={};for(const e of l){const a=e.key;if(void 0===c[a.bucketInstanceId]&&(c[a.bucketInstanceId]={}),c[a.bucketInstanceId][a.featureIndex])continue;const r=[new t.P(e.x1,e.y1),new t.P(e.x2,e.y1),new t.P(e.x2,e.y2),new t.P(e.x1,e.y2)];t.aK(i,r)&&(c[a.bucketInstanceId][a.featureIndex]=!0,void 0===h[a.bucketInstanceId]&&(h[a.bucketInstanceId]=[]),h[a.bucketInstanceId].push(a.featureIndex));}return h}insertCollisionBox(e,t,i,a,r,o){(i?this.ignoredGrid:this.grid).insert({bucketInstanceId:a,featureIndex:r,collisionGroupID:o,overlapMode:t},e[0],e[1],e[2],e[3]);}insertCollisionCircles(e,t,i,a,r,o){const s=i?this.ignoredGrid:this.grid,n={bucketInstanceId:a,featureIndex:r,collisionGroupID:o,overlapMode:t};for(let t=0;t<e.length;t+=4)s.insertCircle(n,e[t],e[t+1],e[t+2]);}projectAndGetPerspectiveRatio(e,i,a,r,o){if(o){let a;r?(a=[e,i,r(e,i),1],t.aH(a,a,o)):(a=[e,i,0,1],ot(a,a,o));const s=a[3];return {x:(a[0]/s+1)/2*this.transform.width+st,y:(-a[1]/s+1)/2*this.transform.height+st,perspectiveRatio:.5+this.transform.cameraToCenterDistance/s*.5,isOccluded:!1,signedDistanceFromCamera:s}}{const t=this.transform.projectTileCoordinates(e,i,a,r);return {x:(t.point.x+1)/2*this.transform.width+st,y:(1-t.point.y)/2*this.transform.height+st,perspectiveRatio:.5+this.transform.cameraToCenterDistance/t.signedDistanceFromCamera*.5,isOccluded:t.isOccluded,signedDistanceFromCamera:t.signedDistanceFromCamera}}}getPerspectiveRatio(e,t,i,a){const r=this.transform.projectTileCoordinates(e,t,i,a);return .5+this.transform.cameraToCenterDistance/r.signedDistanceFromCamera*.5}isOffscreen(e,t,i,a){return i<st||e>=this.screenRightBoundary||a<st||t>this.screenBottomBoundary}isInsideGrid(e,t,i,a){return i>=0&&e<this.gridRightBoundary&&a>=0&&t<this.gridBottomBoundary}getViewportMatrix(){const e=t.ar([]);return t.O(e,e,[-100,-100,0]),e}_projectCollisionBox(e,i,a,r,o,s,n,l,c,h,u){let d=1,_=0,p=0,m=1;const f=e.anchorPointX+n[0],g=e.anchorPointY+n[1];if(s&&!o){const e=this.projectAndGetPerspectiveRatio(f+1,g,r,c,u),t=e.x-l.x,i=Math.atan((e.y-l.y)/t)+(t<0?Math.PI:0),a=Math.sin(i),o=Math.cos(i);d=o,_=a,p=-a,m=o;}else if(!s&&o){const e=Ze(this.transform);d=e.vecEast[0],_=e.vecEast[1],p=e.vecSouth[0],m=e.vecSouth[1];}let v=l.x,x=l.y,b=i;o&&(v=f,x=g,b=Math.pow(2,-(this.transform.zoom-a.overscaledZ)),b*=this.transform.getPitchedTextCorrection(f,g,r),h||(b*=t.an(.5+l.signedDistanceFromCamera/this.transform.cameraToCenterDistance*.5,0,4))),h&&(v+=d*h.x*b+p*h.y*b,x+=_*h.x*b+m*h.y*b);const y=e.x1*b,w=e.x2*b,T=(y+w)/2,P=e.y1*b,C=e.y2*b,I=(P+C)/2,M=[{offsetX:y,offsetY:P},{offsetX:T,offsetY:P},{offsetX:w,offsetY:P},{offsetX:w,offsetY:I},{offsetX:w,offsetY:C},{offsetX:T,offsetY:C},{offsetX:y,offsetY:C},{offsetX:y,offsetY:I}];let E=[];for(const{offsetX:e,offsetY:i}of M)E.push(new t.P(v+d*e+p*i,x+_*e+m*i));let S=!1;if(o){const e=E.map((e=>this.projectAndGetPerspectiveRatio(e.x,e.y,r,c,u)));S=e.some((e=>!e.isOccluded)),E=e.map((e=>new t.P(e.x,e.y)));}else S=!0;return {box:t.aL(E),allPointsOccluded:!S}}}class lt{constructor(e,t,i,a){this.opacity=e?Math.max(0,Math.min(1,e.opacity+(e.placed?t:-t))):a&&i?1:0,this.placed=i;}isHidden(){return 0===this.opacity&&!this.placed}}class ct{constructor(e,t,i,a,r){this.text=new lt(e?e.text:null,t,i,r),this.icon=new lt(e?e.icon:null,t,a,r);}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class ht{constructor(e,t,i){this.text=e,this.icon=t,this.skipFade=i;}}class ut{constructor(e,t,i,a,r){this.bucketInstanceId=e,this.featureIndex=t,this.sourceLayerIndex=i,this.bucketIndex=a,this.tileID=r;}}class dt{constructor(e){this.crossSourceCollisions=e,this.maxGroupID=0,this.collisionGroups={};}get(e){if(this.crossSourceCollisions)return {ID:0,predicate:null};if(!this.collisionGroups[e]){const t=++this.maxGroupID;this.collisionGroups[e]={ID:t,predicate:e=>e.collisionGroupID===t};}return this.collisionGroups[e]}}function _t(e,i,a,r,o){const{horizontalAlign:s,verticalAlign:n}=t.aS(e);return new t.P(-(s-.5)*i+r[0]*o,-(n-.5)*a+r[1]*o)}class pt{constructor(e,t,i,a,r){this.transform=e.clone(),this.terrain=t,this.collisionIndex=new nt(this.transform),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=i,this.retainedQueryData={},this.collisionGroups=new dt(a),this.collisionCircleArrays={},this.collisionBoxArrays=new Map,this.prevPlacement=r,r&&(r.prevPlacement=void 0),this.placedOrientations={};}_getTerrainElevationFunc(e){const t=this.terrain;return t?(i,a)=>t.getElevation(e,i,a):null}getBucketParts(e,i,a,r){const o=a.getBucket(i),s=a.latestFeatureIndex;if(!o||!s||i.id!==o.layerIds[0])return;const n=a.collisionBoxArray,l=o.layers[0].layout,c=o.layers[0].paint,h=Math.pow(2,this.transform.zoom-a.tileID.overscaledZ),u=a.tileSize/t.a5,d=a.tileID.toUnwrapped(),_="map"===l.get("text-rotation-alignment"),p=t.aN(a,1,this.transform.zoom),m=t.aO(this.collisionIndex.transform,a,c.get("text-translate"),c.get("text-translate-anchor")),f=t.aO(this.collisionIndex.transform,a,c.get("icon-translate"),c.get("icon-translate-anchor")),g=je(_,this.transform,p);this.retainedQueryData[o.bucketInstanceId]=new ut(o.bucketInstanceId,s,o.sourceLayerIndex,o.index,a.tileID);const v={bucket:o,layout:l,translationText:m,translationIcon:f,unwrappedTileID:d,pitchedLabelPlaneMatrix:g,scale:h,textPixelRatio:u,holdingForFade:a.holdingForSymbolFade(),collisionBoxArray:n,partiallyEvaluatedTextSize:t.ay(o.textSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(o.sourceID)};if(r)for(const t of o.sortKeyRanges){const{sortKey:i,symbolInstanceStart:a,symbolInstanceEnd:r}=t;e.push({sortKey:i,symbolInstanceStart:a,symbolInstanceEnd:r,parameters:v});}else e.push({symbolInstanceStart:0,symbolInstanceEnd:o.symbolInstances.length,parameters:v});}attemptAnchorPlacement(e,i,a,r,o,s,n,l,c,h,u,d,_,p,m,f,g,v,x,b){const y=t.aP[e.textAnchor],w=[e.textOffset0,e.textOffset1],T=_t(y,a,r,w,o),P=this.collisionIndex.placeCollisionBox(i,d,l,c,h,n,s,f,u.predicate,x,T,b);if((!v||this.collisionIndex.placeCollisionBox(v,d,l,c,h,n,s,g,u.predicate,x,T,b).placeable)&&P.placeable){let e;if(this.prevPlacement&&this.prevPlacement.variableOffsets[_.crossTileID]&&this.prevPlacement.placements[_.crossTileID]&&this.prevPlacement.placements[_.crossTileID].text&&(e=this.prevPlacement.variableOffsets[_.crossTileID].anchor),0===_.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");return this.variableOffsets[_.crossTileID]={textOffset:w,width:a,height:r,anchor:y,textBoxScale:o,prevAnchor:e},this.markUsedJustification(p,y,_,m),p.allowVerticalPlacement&&(this.markUsedOrientation(p,m,_),this.placedOrientations[_.crossTileID]=m),{shift:T,placedGlyphBoxes:P}}}placeLayerBucketPart(e,i,a){const{bucket:r,layout:o,translationText:s,translationIcon:n,unwrappedTileID:l,pitchedLabelPlaneMatrix:c,textPixelRatio:h,holdingForFade:u,collisionBoxArray:d,partiallyEvaluatedTextSize:_,collisionGroup:p}=e.parameters,m=o.get("text-optional"),f=o.get("icon-optional"),g=t.aQ(o,"text-overlap","text-allow-overlap"),v="always"===g,x=t.aQ(o,"icon-overlap","icon-allow-overlap"),b="always"===x,y="map"===o.get("text-rotation-alignment"),w="map"===o.get("text-pitch-alignment"),T="none"!==o.get("icon-text-fit"),P="viewport-y"===o.get("symbol-z-order"),C=v&&(b||!r.hasIconData()||f),I=b&&(v||!r.hasTextData()||m);!r.collisionArrays&&d&&r.deserializeCollisionBoxes(d);const M=this.retainedQueryData[r.bucketInstanceId].tileID,E=this._getTerrainElevationFunc(M),S=this.transform.getFastPathSimpleProjectionMatrix(M),z=(e,d,b)=>{var P,z;if(i[e.crossTileID])return;if(u)return void(this.placements[e.crossTileID]=new ht(!1,!1,!1));let R=!1,D=!1,A=!0,L=null,k={box:null,placeable:!1,offscreen:null,occluded:!1},F={placeable:!1},B=null,O=null,j=null,N=0,Z=0,G=0;d.textFeatureIndex?N=d.textFeatureIndex:e.useRuntimeCollisionCircles&&(N=e.featureIndex),d.verticalTextFeatureIndex&&(Z=d.verticalTextFeatureIndex);const U=d.textBox;if(U){const i=i=>{let a=t.az.horizontal;if(r.allowVerticalPlacement&&!i&&this.prevPlacement){const t=this.prevPlacement.placedOrientations[e.crossTileID];t&&(this.placedOrientations[e.crossTileID]=t,a=t,this.markUsedOrientation(r,a,e));}return a},o=(i,a)=>{if(r.allowVerticalPlacement&&e.numVerticalGlyphVertices>0&&d.verticalTextBox){for(const e of r.writingModes)if(e===t.az.vertical?(k=a(),F=k):k=i(),k&&k.placeable)break}else k=i();},c=e.textAnchorOffsetStartIndex,u=e.textAnchorOffsetEndIndex;if(u===c){const a=(t,i)=>{const a=this.collisionIndex.placeCollisionBox(t,g,h,M,l,w,y,s,p.predicate,E,void 0,S);return a&&a.placeable&&(this.markUsedOrientation(r,i,e),this.placedOrientations[e.crossTileID]=i),a};o((()=>a(U,t.az.horizontal)),(()=>{const i=d.verticalTextBox;return r.allowVerticalPlacement&&e.numVerticalGlyphVertices>0&&i?a(i,t.az.vertical):{box:null,offscreen:null}})),i(k&&k.placeable);}else {let _=t.aP[null===(z=null===(P=this.prevPlacement)||void 0===P?void 0:P.variableOffsets[e.crossTileID])||void 0===z?void 0:z.anchor];const m=(t,i,o)=>{const d=t.x2-t.x1,m=t.y2-t.y1,f=e.textBoxScale,v=T&&"never"===x?i:null;let b=null,P="never"===g?1:2,C="never";_&&P++;for(let i=0;i<P;i++){for(let i=c;i<u;i++){const a=r.textAnchorOffsets.get(i);if(_&&a.textAnchor!==_)continue;const c=this.attemptAnchorPlacement(a,t,d,m,f,y,w,h,M,l,p,C,e,r,o,s,n,v,E);if(c&&(b=c.placedGlyphBoxes,b&&b.placeable))return R=!0,L=c.shift,b}_?_=null:C=g;}return a&&!b&&(b={box:this.collisionIndex.placeCollisionBox(U,"always",h,M,l,w,y,s,p.predicate,E,void 0,S).box,offscreen:!1,placeable:!1,occluded:!1}),b};o((()=>m(U,d.iconBox,t.az.horizontal)),(()=>{const i=d.verticalTextBox;return r.allowVerticalPlacement&&(!k||!k.placeable)&&e.numVerticalGlyphVertices>0&&i?m(i,d.verticalIconBox,t.az.vertical):{box:null,occluded:!0,offscreen:null}})),k&&(R=k.placeable,A=k.offscreen);const f=i(k&&k.placeable);if(!R&&this.prevPlacement){const t=this.prevPlacement.variableOffsets[e.crossTileID];t&&(this.variableOffsets[e.crossTileID]=t,this.markUsedJustification(r,t.anchor,e,f));}}}if(B=k,R=B&&B.placeable,A=B&&B.offscreen,e.useRuntimeCollisionCircles&&e.centerJustifiedTextSymbolIndex>=0){const i=r.text.placedSymbolArray.get(e.centerJustifiedTextSymbolIndex),n=t.aA(r.textSizeData,_,i),h=o.get("text-padding");O=this.collisionIndex.placeCollisionCircles(g,i,r.lineVertexArray,r.glyphOffsetArray,n,l,c,a,w,p.predicate,e.collisionCircleDiameter,h,s,E),O.circles.length&&O.collisionDetected&&!a&&t.w("Collisions detected, but collision boxes are not shown"),R=v||O.circles.length>0&&!O.collisionDetected,A=A&&O.offscreen;}if(d.iconFeatureIndex&&(G=d.iconFeatureIndex),d.iconBox){const e=e=>this.collisionIndex.placeCollisionBox(e,x,h,M,l,w,y,n,p.predicate,E,T&&L?L:void 0,S);F&&F.placeable&&d.verticalIconBox?(j=e(d.verticalIconBox),D=j.placeable):(j=e(d.iconBox),D=j.placeable),A=A&&j.offscreen;}const V=m||0===e.numHorizontalGlyphVertices&&0===e.numVerticalGlyphVertices,q=f||0===e.numIconVertices;V||q?q?V||(D=D&&R):R=D&&R:D=R=D&&R;const W=D&&j.placeable;if(R&&B.placeable&&this.collisionIndex.insertCollisionBox(B.box,g,o.get("text-ignore-placement"),r.bucketInstanceId,F&&F.placeable&&Z?Z:N,p.ID),W&&this.collisionIndex.insertCollisionBox(j.box,x,o.get("icon-ignore-placement"),r.bucketInstanceId,G,p.ID),O&&R&&this.collisionIndex.insertCollisionCircles(O.circles,g,o.get("text-ignore-placement"),r.bucketInstanceId,N,p.ID),a&&this.storeCollisionData(r.bucketInstanceId,b,d,B,j,O),0===e.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");if(0===r.bucketInstanceId)throw new Error("bucket.bucketInstanceId can't be 0");this.placements[e.crossTileID]=new ht((R||C)&&!(null==B?void 0:B.occluded),(D||I)&&!(null==j?void 0:j.occluded),A||r.justReloaded),i[e.crossTileID]=!0;};if(P){if(0!==e.symbolInstanceStart)throw new Error("bucket.bucketInstanceId should be 0");const t=r.getSortedSymbolIndexes(-this.transform.bearingInRadians);for(let e=t.length-1;e>=0;--e){const i=t[e];z(r.symbolInstances.get(i),r.collisionArrays[i],i);}}else for(let t=e.symbolInstanceStart;t<e.symbolInstanceEnd;t++)z(r.symbolInstances.get(t),r.collisionArrays[t],t);r.justReloaded=!1;}storeCollisionData(e,t,i,a,r,o){if(i.textBox||i.iconBox){let o,s;this.collisionBoxArrays.has(e)?o=this.collisionBoxArrays.get(e):(o=new Map,this.collisionBoxArrays.set(e,o)),o.has(t)?s=o.get(t):(s={text:null,icon:null},o.set(t,s)),i.textBox&&(s.text=a.box),i.iconBox&&(s.icon=r.box);}if(o){let t=this.collisionCircleArrays[e];void 0===t&&(t=this.collisionCircleArrays[e]=[]);for(let e=0;e<o.circles.length;e+=4)t.push(o.circles[e+0]-st),t.push(o.circles[e+1]-st),t.push(o.circles[e+2]),t.push(o.collisionDetected?1:0);}}markUsedJustification(e,i,a,r){let o;o=r===t.az.vertical?a.verticalPlacedTextSymbolIndex:{left:a.leftJustifiedTextSymbolIndex,center:a.centerJustifiedTextSymbolIndex,right:a.rightJustifiedTextSymbolIndex}[t.aR(i)];const s=[a.leftJustifiedTextSymbolIndex,a.centerJustifiedTextSymbolIndex,a.rightJustifiedTextSymbolIndex,a.verticalPlacedTextSymbolIndex];for(const t of s)t>=0&&(e.text.placedSymbolArray.get(t).crossTileID=o>=0&&t!==o?0:a.crossTileID);}markUsedOrientation(e,i,a){const r=i===t.az.horizontal||i===t.az.horizontalOnly?i:0,o=i===t.az.vertical?i:0,s=[a.leftJustifiedTextSymbolIndex,a.centerJustifiedTextSymbolIndex,a.rightJustifiedTextSymbolIndex];for(const t of s)e.text.placedSymbolArray.get(t).placedOrientation=r;a.verticalPlacedTextSymbolIndex&&(e.text.placedSymbolArray.get(a.verticalPlacedTextSymbolIndex).placedOrientation=o);}commit(e){this.commitTime=e,this.zoomAtLastRecencyCheck=this.transform.zoom;const t=this.prevPlacement;let i=!1;this.prevZoomAdjustment=t?t.zoomAdjustment(this.transform.zoom):0;const a=t?t.symbolFadeChange(e):1,r=t?t.opacities:{},o=t?t.variableOffsets:{},s=t?t.placedOrientations:{};for(const e in this.placements){const t=this.placements[e],o=r[e];o?(this.opacities[e]=new ct(o,a,t.text,t.icon),i=i||t.text!==o.text.placed||t.icon!==o.icon.placed):(this.opacities[e]=new ct(null,a,t.text,t.icon,t.skipFade),i=i||t.text||t.icon);}for(const e in r){const t=r[e];if(!this.opacities[e]){const r=new ct(t,a,!1,!1);r.isHidden()||(this.opacities[e]=r,i=i||t.text.placed||t.icon.placed);}}for(const e in o)this.variableOffsets[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.variableOffsets[e]=o[e]);for(const e in s)this.placedOrientations[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.placedOrientations[e]=s[e]);if(t&&void 0===t.lastPlacementChangeTime)throw new Error("Last placement time for previous placement is not defined");i?this.lastPlacementChangeTime=e:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=t?t.lastPlacementChangeTime:e);}updateLayerOpacities(e,t){const i={};for(const a of t){const t=a.getBucket(e);t&&a.latestFeatureIndex&&e.id===t.layerIds[0]&&this.updateBucketOpacities(t,a.tileID,i,a.collisionBoxArray);}}updateBucketOpacities(e,i,a,r){e.hasTextData()&&(e.text.opacityVertexArray.clear(),e.text.hasVisibleVertices=!1),e.hasIconData()&&(e.icon.opacityVertexArray.clear(),e.icon.hasVisibleVertices=!1),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexArray.clear(),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexArray.clear();const o=e.layers[0],s=o.layout,n=new ct(null,0,!1,!1,!0),l=s.get("text-allow-overlap"),c=s.get("icon-allow-overlap"),h=o._unevaluatedLayout.hasValue("text-variable-anchor")||o._unevaluatedLayout.hasValue("text-variable-anchor-offset"),u="map"===s.get("text-rotation-alignment"),d="map"===s.get("text-pitch-alignment"),_="none"!==s.get("icon-text-fit"),p=new ct(null,0,l&&(c||!e.hasIconData()||s.get("icon-optional")),c&&(l||!e.hasTextData()||s.get("text-optional")),!0);!e.collisionArrays&&r&&(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData())&&e.deserializeCollisionBoxes(r);const m=(e,t,i)=>{for(let a=0;a<t/4;a++)e.opacityVertexArray.emplaceBack(i);e.hasVisibleVertices=e.hasVisibleVertices||i!==Pt;},f=this.collisionBoxArrays.get(e.bucketInstanceId);for(let i=0;i<e.symbolInstances.length;i++){const r=e.symbolInstances.get(i),{numHorizontalGlyphVertices:o,numVerticalGlyphVertices:s,crossTileID:l}=r;let c=this.opacities[l];a[l]?c=n:c||(c=p,this.opacities[l]=c),a[l]=!0;const g=r.numIconVertices>0,v=this.placedOrientations[r.crossTileID],x=v===t.az.vertical,b=v===t.az.horizontal||v===t.az.horizontalOnly;if(o>0||s>0){const t=Tt(c.text);m(e.text,o,x?Pt:t),m(e.text,s,b?Pt:t);const i=c.text.isHidden();[r.rightJustifiedTextSymbolIndex,r.centerJustifiedTextSymbolIndex,r.leftJustifiedTextSymbolIndex].forEach((t=>{t>=0&&(e.text.placedSymbolArray.get(t).hidden=i||x?1:0);})),r.verticalPlacedTextSymbolIndex>=0&&(e.text.placedSymbolArray.get(r.verticalPlacedTextSymbolIndex).hidden=i||b?1:0);const a=this.variableOffsets[r.crossTileID];a&&this.markUsedJustification(e,a.anchor,r,v);const n=this.placedOrientations[r.crossTileID];n&&(this.markUsedJustification(e,"left",r,n),this.markUsedOrientation(e,n,r));}if(g){const t=Tt(c.icon),i=!(_&&r.verticalPlacedIconSymbolIndex&&x);r.placedIconSymbolIndex>=0&&(m(e.icon,r.numIconVertices,i?t:Pt),e.icon.placedSymbolArray.get(r.placedIconSymbolIndex).hidden=c.icon.isHidden()),r.verticalPlacedIconSymbolIndex>=0&&(m(e.icon,r.numVerticalIconVertices,i?Pt:t),e.icon.placedSymbolArray.get(r.verticalPlacedIconSymbolIndex).hidden=c.icon.isHidden());}const y=f&&f.has(i)?f.get(i):{text:null,icon:null};if(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData()){const a=e.collisionArrays[i];if(a){let i=new t.P(0,0);if(a.textBox||a.verticalTextBox){let t=!0;if(h){const e=this.variableOffsets[l];e?(i=_t(e.anchor,e.width,e.height,e.textOffset,e.textBoxScale),u&&i._rotate(d?-this.transform.bearingInRadians:this.transform.bearingInRadians)):t=!1;}if(a.textBox||a.verticalTextBox){let r;a.textBox&&(r=x),a.verticalTextBox&&(r=b),mt(e.textCollisionBox.collisionVertexArray,c.text.placed,!t||r,y.text,i.x,i.y);}}if(a.iconBox||a.verticalIconBox){const t=Boolean(!b&&a.verticalIconBox);let r;a.iconBox&&(r=t),a.verticalIconBox&&(r=!t),mt(e.iconCollisionBox.collisionVertexArray,c.icon.placed,r,y.icon,_?i.x:0,_?i.y:0);}}}}if(e.sortFeatures(-this.transform.bearingInRadians),this.retainedQueryData[e.bucketInstanceId]&&(this.retainedQueryData[e.bucketInstanceId].featureSortOrder=e.featureSortOrder),e.hasTextData()&&e.text.opacityVertexBuffer&&e.text.opacityVertexBuffer.updateData(e.text.opacityVertexArray),e.hasIconData()&&e.icon.opacityVertexBuffer&&e.icon.opacityVertexBuffer.updateData(e.icon.opacityVertexArray),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexBuffer&&e.iconCollisionBox.collisionVertexBuffer.updateData(e.iconCollisionBox.collisionVertexArray),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexBuffer&&e.textCollisionBox.collisionVertexBuffer.updateData(e.textCollisionBox.collisionVertexArray),e.text.opacityVertexArray.length!==e.text.layoutVertexArray.length/4)throw new Error(`bucket.text.opacityVertexArray.length (= ${e.text.opacityVertexArray.length}) !== bucket.text.layoutVertexArray.length (= ${e.text.layoutVertexArray.length}) / 4`);if(e.icon.opacityVertexArray.length!==e.icon.layoutVertexArray.length/4)throw new Error(`bucket.icon.opacityVertexArray.length (= ${e.icon.opacityVertexArray.length}) !== bucket.icon.layoutVertexArray.length (= ${e.icon.layoutVertexArray.length}) / 4`);e.bucketInstanceId in this.collisionCircleArrays&&(e.collisionCircleArray=this.collisionCircleArrays[e.bucketInstanceId],delete this.collisionCircleArrays[e.bucketInstanceId]);}symbolFadeChange(e){return 0===this.fadeDuration?1:(e-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(e){return Math.max(0,(this.transform.zoom-e)/1.5)}hasTransitions(e){return this.stale||e-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(e,t){const i=this.zoomAtLastRecencyCheck===t?1-this.zoomAdjustment(t):1;return this.zoomAtLastRecencyCheck=t,this.commitTime+this.fadeDuration*i>e}setStale(){this.stale=!0;}}function mt(e,t,i,a,r,o){a&&0!==a.length||(a=[0,0,0,0]);const s=a[0]-st,n=a[1]-st,l=a[2]-st,c=a[3]-st;e.emplaceBack(t?1:0,i?1:0,r||0,o||0,s,n),e.emplaceBack(t?1:0,i?1:0,r||0,o||0,l,n),e.emplaceBack(t?1:0,i?1:0,r||0,o||0,l,c),e.emplaceBack(t?1:0,i?1:0,r||0,o||0,s,c);}const ft=Math.pow(2,25),gt=Math.pow(2,24),vt=Math.pow(2,17),xt=Math.pow(2,16),bt=Math.pow(2,9),yt=Math.pow(2,8),wt=Math.pow(2,1);function Tt(e){if(0===e.opacity&&!e.placed)return 0;if(1===e.opacity&&e.placed)return 4294967295;const t=e.placed?1:0,i=Math.floor(127*e.opacity);return i*ft+t*gt+i*vt+t*xt+i*bt+t*yt+i*wt+t}const Pt=0;class Ct{constructor(e){this._sortAcrossTiles="viewport-y"!==e.layout.get("symbol-z-order")&&!e.layout.get("symbol-sort-key").isConstant(),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs={},this._bucketParts=[];}continuePlacement(e,t,i,a,r){const o=this._bucketParts;for(;this._currentTileIndex<e.length;)if(t.getBucketParts(o,a,e[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,r())return !0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,o.sort(((e,t)=>e.sortKey-t.sortKey)));this._currentPartIndex<o.length;)if(t.placeLayerBucketPart(o[this._currentPartIndex],this._seenCrossTileIDs,i),this._currentPartIndex++,r())return !0;return !1}}class It{constructor(e,t,i,a,r,o,s,n){this.placement=new pt(e,t,o,s,n),this._currentPlacementIndex=i.length-1,this._forceFullPlacement=a,this._showCollisionBoxes=r,this._done=!1;}isDone(){return this._done}continuePlacement(e,t,i){const a=c(),r=()=>!this._forceFullPlacement&&c()-a>2;for(;this._currentPlacementIndex>=0;){const a=t[e[this._currentPlacementIndex]],o=this.placement.collisionIndex.transform.zoom;if("symbol"===a.type&&(!a.minzoom||a.minzoom<=o)&&(!a.maxzoom||a.maxzoom>o)){if(this._inProgressLayer||(this._inProgressLayer=new Ct(a)),this._inProgressLayer.continuePlacement(i[a.source],this.placement,this._showCollisionBoxes,a,r))return;delete this._inProgressLayer;}this._currentPlacementIndex--;}this._done=!0;}commit(e){return this.placement.commit(e),this.placement}}const Mt=512/t.a5/2;class Et{constructor(e,i,a){this.tileID=e,this.bucketInstanceId=a,this._symbolsByKey={};const r=new Map;for(let e=0;e<i.length;e++){const t=i.get(e),a=t.key,o=r.get(a);o?o.push(t):r.set(a,[t]);}for(const[e,i]of r){const a={positions:i.map((e=>({x:Math.floor(e.anchorX*Mt),y:Math.floor(e.anchorY*Mt)}))),crossTileIDs:i.map((e=>e.crossTileID))};if(a.positions.length>128){const e=new t.aT(a.positions.length,16,Uint16Array);for(const{x:t,y:i}of a.positions)e.add(t,i);e.finish(),delete a.positions,a.index=e;}this._symbolsByKey[e]=a;}}getScaledCoordinates(e,i){const{x:a,y:r,z:o}=this.tileID.canonical,{x:s,y:n,z:l}=i.canonical,c=Mt/Math.pow(2,l-o),h=(n*t.a5+e.anchorY)*c,u=r*t.a5*Mt;return {x:Math.floor((s*t.a5+e.anchorX)*c-a*t.a5*Mt),y:Math.floor(h-u)}}findMatches(e,t,i){const a=this.tileID.canonical.z<t.canonical.z?1:Math.pow(2,this.tileID.canonical.z-t.canonical.z);for(let r=0;r<e.length;r++){const o=e.get(r);if(o.crossTileID)continue;const s=this._symbolsByKey[o.key];if(!s)continue;const n=this.getScaledCoordinates(o,t);if(s.index){const e=s.index.range(n.x-a,n.y-a,n.x+a,n.y+a).sort();for(const t of e){const e=s.crossTileIDs[t];if(!i[e]){i[e]=!0,o.crossTileID=e;break}}}else if(s.positions)for(let e=0;e<s.positions.length;e++){const t=s.positions[e],r=s.crossTileIDs[e];if(Math.abs(t.x-n.x)<=a&&Math.abs(t.y-n.y)<=a&&!i[r]){i[r]=!0,o.crossTileID=r;break}}}}getCrossTileIDsLists(){return Object.values(this._symbolsByKey).map((({crossTileIDs:e})=>e))}}class St{constructor(){this.maxCrossTileID=0;}generate(){return ++this.maxCrossTileID}}class zt{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0;}handleWrapJump(e){const t=Math.round((e-this.lng)/360);if(0!==t)for(const e in this.indexes){const i=this.indexes[e],a={};for(const e in i){const r=i[e];r.tileID=r.tileID.unwrapTo(r.tileID.wrap+t),a[r.tileID.key]=r;}this.indexes[e]=a;}this.lng=e;}addBucket(e,t,i){if(this.indexes[e.overscaledZ]&&this.indexes[e.overscaledZ][e.key]){if(this.indexes[e.overscaledZ][e.key].bucketInstanceId===t.bucketInstanceId)return !1;this.removeBucketCrossTileIDs(e.overscaledZ,this.indexes[e.overscaledZ][e.key]);}for(let e=0;e<t.symbolInstances.length;e++)t.symbolInstances.get(e).crossTileID=0;this.usedCrossTileIDs[e.overscaledZ]||(this.usedCrossTileIDs[e.overscaledZ]={});const a=this.usedCrossTileIDs[e.overscaledZ];for(const i in this.indexes){const r=this.indexes[i];if(Number(i)>e.overscaledZ)for(const i in r){const o=r[i];o.tileID.isChildOf(e)&&o.findMatches(t.symbolInstances,e,a);}else {const o=r[e.scaledTo(Number(i)).key];o&&o.findMatches(t.symbolInstances,e,a);}}for(let e=0;e<t.symbolInstances.length;e++){const r=t.symbolInstances.get(e);r.crossTileID||(r.crossTileID=i.generate(),a[r.crossTileID]=!0);}return void 0===this.indexes[e.overscaledZ]&&(this.indexes[e.overscaledZ]={}),this.indexes[e.overscaledZ][e.key]=new Et(e,t.symbolInstances,t.bucketInstanceId),!0}removeBucketCrossTileIDs(e,t){for(const i of t.getCrossTileIDsLists())for(const t of i)delete this.usedCrossTileIDs[e][t];}removeStaleBuckets(e){let t=!1;for(const i in this.indexes){const a=this.indexes[i];for(const r in a)e[a[r].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,a[r]),delete a[r],t=!0);}return t}}class Rt{constructor(){this.layerIndexes={},this.crossTileIDs=new St,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={};}addLayer(e,t,i){let a=this.layerIndexes[e.id];void 0===a&&(a=this.layerIndexes[e.id]=new zt);let r=!1;const o={};a.handleWrapJump(i);for(const i of t){const t=i.getBucket(e);t&&e.id===t.layerIds[0]&&(t.bucketInstanceId||(t.bucketInstanceId=++this.maxBucketInstanceId),a.addBucket(i.tileID,t,this.crossTileIDs)&&(r=!0),o[t.bucketInstanceId]=!0);}return a.removeStaleBuckets(o)&&(r=!0),r}pruneUnusedLayers(e){const t={};e.forEach((e=>{t[e]=!0;}));for(const e in this.layerIndexes)t[e]||delete this.layerIndexes[e];}}var Dt="void main() {fragColor=vec4(1.0);}";const At={prelude:Lt("#ifdef GL_ES\nprecision mediump float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nout highp vec4 fragColor;","#ifdef GL_ES\nprecision highp float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(unpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}mat3 rotationMatrixFromAxisAngle(vec3 u,float angle) {float c=cos(angle);float s=sin(angle);float c2=1.0-c;return mat3(u.x*u.x*c2+      c,u.x*u.y*c2-u.z*s,u.x*u.z*c2+u.y*s,u.y*u.x*c2+u.z*s,u.y*u.y*c2+    c,u.y*u.z*c2-u.x*s,u.z*u.x*c2-u.y*s,u.z*u.y*c2+u.x*s,u.z*u.z*c2+    c\n);}\n#ifdef TERRAIN3D\nuniform sampler2D u_terrain;uniform float u_terrain_dim;uniform mat4 u_terrain_matrix;uniform vec4 u_terrain_unpack;uniform float u_terrain_exaggeration;uniform highp sampler2D u_depth;\n#endif\nconst highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitShifts=vec4(1.)/bitSh;highp float unpack(highp vec4 color) {return dot(color,bitShifts);}highp float depthOpacity(vec3 frag) {\n#ifdef TERRAIN3D\nhighp float d=unpack(texture(u_depth,frag.xy*0.5+0.5))+0.0001-frag.z;return 1.0-max(0.0,min(1.0,-d*500.0));\n#else\nreturn 1.0;\n#endif\n}float calculate_visibility(vec4 pos) {\n#ifdef TERRAIN3D\nvec3 frag=pos.xyz/pos.w;highp float d=depthOpacity(frag);if (d > 0.95) return 1.0;return (d+depthOpacity(frag+vec3(0.0,0.01,0.0)))/2.0;\n#else\nreturn 1.0;\n#endif\n}float ele(vec2 pos) {\n#ifdef TERRAIN3D\nvec4 rgb=(texture(u_terrain,pos)*255.0)*u_terrain_unpack;return rgb.r+rgb.g+rgb.b-u_terrain_unpack.a;\n#else\nreturn 0.0;\n#endif\n}float get_elevation(vec2 pos) {\n#ifdef TERRAIN3D\n#ifdef GLOBE\nif ((pos.y <-32767.5) || (pos.y > 32766.5)) {return 0.0;}\n#endif\nvec2 coord=(u_terrain_matrix*vec4(pos,0.0,1.0)).xy*u_terrain_dim+1.0;vec2 f=fract(coord);vec2 c=(floor(coord)+0.5)/(u_terrain_dim+2.0);float d=1.0/(u_terrain_dim+2.0);float tl=ele(c);float tr=ele(c+vec2(d,0.0));float bl=ele(c+vec2(0.0,d));float br=ele(c+vec2(d,d));float elevation=mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);return elevation*u_terrain_exaggeration;\n#else\nreturn 0.0;\n#endif\n}const float PI=3.141592653589793;uniform mat4 u_projection_matrix;"),projectionMercator:Lt("","float projectLineThickness(float tileY) {return 1.0;}float projectCircleRadius(float tileY) {return 1.0;}vec4 projectTile(vec2 p) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);return result;}vec4 projectTile(vec2 p,vec2 rawPos) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);if (rawPos.y <-32767.5 || rawPos.y > 32766.5) {result.z=-10000000.0;}return result;}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return u_projection_matrix*vec4(posInTile,elevation,1.0);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {return projectTileWithElevation(posInTile,elevation);}"),projectionGlobe:Lt("","#define GLOBE_RADIUS 6371008.8\nuniform highp vec4 u_projection_tile_mercator_coords;uniform highp vec4 u_projection_clipping_plane;uniform highp float u_projection_transition;uniform mat4 u_projection_fallback_matrix;vec3 globeRotateVector(vec3 vec,vec2 angles) {vec3 axisRight=vec3(vec.z,0.0,-vec.x);vec3 axisUp=cross(axisRight,vec);axisRight=normalize(axisRight);axisUp=normalize(axisUp);vec2 t=tan(angles);return normalize(vec+axisRight*t.x+axisUp*t.y);}mat3 globeGetRotationMatrix(vec3 spherePos) {vec3 axisRight=vec3(spherePos.z,0.0,-spherePos.x);vec3 axisDown=cross(axisRight,spherePos);axisRight=normalize(axisRight);axisDown=normalize(axisDown);return mat3(axisRight,axisDown,spherePos\n);}float circumferenceRatioAtTileY(float tileY) {float mercator_pos_y=u_projection_tile_mercator_coords.y+u_projection_tile_mercator_coords.w*tileY;float spherical_y=2.0*atan(exp(PI-(mercator_pos_y*PI*2.0)))-PI*0.5;return cos(spherical_y);}float projectLineThickness(float tileY) {float thickness=1.0/circumferenceRatioAtTileY(tileY); \nif (u_projection_transition < 0.999) {return mix(1.0,thickness,u_projection_transition);} else {return thickness;}}vec3 projectToSphere(vec2 translatedPos,vec2 rawPos) {vec2 mercator_pos=u_projection_tile_mercator_coords.xy+u_projection_tile_mercator_coords.zw*translatedPos;vec2 spherical;spherical.x=mercator_pos.x*PI*2.0+PI;spherical.y=2.0*atan(exp(PI-(mercator_pos.y*PI*2.0)))-PI*0.5;float len=cos(spherical.y);vec3 pos=vec3(sin(spherical.x)*len,sin(spherical.y),cos(spherical.x)*len\n);if (rawPos.y <-32767.5) {pos=vec3(0.0,1.0,0.0);}if (rawPos.y > 32766.5) {pos=vec3(0.0,-1.0,0.0);}return pos;}vec3 projectToSphere(vec2 posInTile) {return projectToSphere(posInTile,vec2(0.0,0.0));}float globeComputeClippingZ(vec3 spherePos) {return (1.0-(dot(spherePos,u_projection_clipping_plane.xyz)+u_projection_clipping_plane.w));}vec4 interpolateProjection(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);globePosition.z=globeComputeClippingZ(elevatedPos)*globePosition.w;if (u_projection_transition > 0.999) {return globePosition;}vec4 flatPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);const float z_globeness_threshold=0.2;vec4 result=globePosition;result.z=mix(0.0,globePosition.z,clamp((u_projection_transition-z_globeness_threshold)/(1.0-z_globeness_threshold),0.0,1.0));result.xyw=mix(flatPosition.xyw,globePosition.xyw,u_projection_transition);if ((posInTile.y <-32767.5) || (posInTile.y > 32766.5)) {result=globePosition;const float poles_hidden_anim_percentage=0.02;result.z=mix(globePosition.z,100.0,pow(max((1.0-u_projection_transition)/poles_hidden_anim_percentage,0.0),8.0));}return result;}vec4 interpolateProjectionFor3D(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);if (u_projection_transition > 0.999) {return globePosition;}vec4 fallbackPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);return mix(fallbackPosition,globePosition,u_projection_transition);}vec4 projectTile(vec2 posInTile) {return interpolateProjection(posInTile,projectToSphere(posInTile),0.0);}vec4 projectTile(vec2 posInTile,vec2 rawPos) {return interpolateProjection(posInTile,projectToSphere(posInTile,rawPos),0.0);}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return interpolateProjection(posInTile,projectToSphere(posInTile),elevation);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {vec3 spherePos=projectToSphere(posInTile,posInTile);return interpolateProjectionFor3D(posInTile,spherePos,elevation);}"),background:Lt("uniform vec4 u_color;uniform float u_opacity;void main() {fragColor=u_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),backgroundPattern:Lt("uniform vec2 u_pattern_tl_a;uniform vec2 u_pattern_br_a;uniform vec2 u_pattern_tl_b;uniform vec2 u_pattern_br_b;uniform vec2 u_texsize;uniform float u_mix;uniform float u_opacity;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;void main() {vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(u_pattern_tl_a/u_texsize,u_pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(u_pattern_tl_b/u_texsize,u_pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_mix)*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pattern_size_a;uniform vec2 u_pattern_size_b;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_scale_a;uniform float u_scale_b;uniform float u_tile_units_to_pixels;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;void main() {gl_Position=projectTile(a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_a*u_pattern_size_a,u_tile_units_to_pixels,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_b*u_pattern_size_b,u_tile_units_to_pixels,a_pos);}"),circle:Lt("in vec3 v_data;in float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);float antialiased_blur=v_data.z;float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(antialiased_blur,0.0,extrude_length-radius/(radius+stroke_width));fragColor=v_visibility*opacity_t*mix(color*opacity,stroke_color*stroke_opacity,color_t);const float epsilon=0.5/255.0;if (fragColor.r < epsilon && fragColor.g < epsilon && fragColor.b < epsilon && fragColor.a < epsilon) {discard;}\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform bool u_scale_with_map;uniform bool u_pitch_with_map;uniform vec2 u_extrude_scale;uniform highp float u_globe_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;uniform vec2 u_translate;in vec2 a_pos;out vec3 v_data;out float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 pos_raw=a_pos+32768.0;vec2 extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);vec2 circle_center=floor(pos_raw/8.0)+u_translate;float ele=get_elevation(circle_center);v_visibility=calculate_visibility(projectTileWithElevation(circle_center,ele));if (u_pitch_with_map) {\n#ifdef GLOBE\nvec3 center_vector=projectToSphere(circle_center);\n#endif\nfloat angle_scale=u_globe_extrude_scale;vec2 corner_position=circle_center;if (u_scale_with_map) {angle_scale*=(radius+stroke_width);corner_position+=extrude*u_extrude_scale*(radius+stroke_width);} else {\n#ifdef GLOBE\nvec4 projected_center=interpolateProjection(circle_center,center_vector,ele);\n#else\nvec4 projected_center=projectTileWithElevation(circle_center,ele);\n#endif\ncorner_position+=extrude*u_extrude_scale*(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);angle_scale*=(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);}\n#ifdef GLOBE\nvec2 angles=extrude*angle_scale;vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(corner_position,corner_vector,ele);\n#else\ngl_Position=projectTileWithElevation(corner_position,ele);\n#endif\n} else {gl_Position=projectTileWithElevation(circle_center,ele);if (gl_Position.z/gl_Position.w > 1.0) {gl_Position.xy=vec2(10000.0);}if (u_scale_with_map) {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*u_camera_to_center_distance;} else {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*gl_Position.w;}}float antialiasblur=-max(1.0/u_device_pixel_ratio/(radius+stroke_width),blur);v_data=vec3(extrude.x,extrude.y,antialiasblur);}"),clippingMask:Lt(Dt,"in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),heatmap:Lt("uniform highp float u_intensity;in vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);fragColor=vec4(val,1.0,1.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;uniform highp float u_globe_extrude_scale;in vec2 a_pos;out vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 pos_raw=a_pos+32768.0;vec2 unscaled_extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec2 circle_center=floor(pos_raw/8.0);\n#ifdef GLOBE\nvec2 angles=v_extrude*radius*u_globe_extrude_scale;vec3 center_vector=projectToSphere(circle_center);vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(circle_center+extrude,corner_vector,0.0);\n#else\ngl_Position=projectTileFor3D(circle_center+extrude,get_elevation(circle_center));\n#endif\n}"),heatmapTexture:Lt("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;in vec2 v_pos;void main() {float t=texture(u_image,v_pos).r;vec4 color=texture(u_color_ramp,vec2(t,0.5));fragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(0.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos*u_world,0,1);v_pos.x=a_pos.x;v_pos.y=1.0-a_pos.y;}"),collisionBox:Lt("in float v_placed;in float v_notUsed;void main() {float alpha=0.5;fragColor=vec4(1.0,0.0,0.0,1.0)*alpha;if (v_placed > 0.5) {fragColor=vec4(0.0,0.0,1.0,0.5)*alpha;}if (v_notUsed > 0.5) {fragColor*=.1;}}","in vec2 a_anchor_pos;in vec2 a_placed;in vec2 a_box_real;uniform vec2 u_pixel_extrude_scale;out float v_placed;out float v_notUsed;void main() {gl_Position=projectTileWithElevation(a_anchor_pos,get_elevation(a_anchor_pos));gl_Position.xy=((a_box_real+0.5)*u_pixel_extrude_scale*2.0-1.0)*vec2(1.0,-1.0)*gl_Position.w;if (gl_Position.z/gl_Position.w < 1.1) {gl_Position.z=0.5;}v_placed=a_placed.x;v_notUsed=a_placed.y;}"),collisionCircle:Lt("in float v_radius;in vec2 v_extrude;in float v_collision;void main() {float alpha=0.5;float stroke_radius=0.9;float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);fragColor=color*alpha*opacity_t;}","in vec2 a_pos;in float a_radius;in vec2 a_flags;uniform vec2 u_viewport_size;out float v_radius;out vec2 v_extrude;out float v_collision;void main() {float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(mix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_collision=collision;gl_Position=vec4((a_pos/u_viewport_size*2.0-1.0)*vec2(1.0,-1.0),0.0,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),colorRelief:Lt("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;uniform vec4 u_unpack;uniform sampler2D u_elevation_stops;uniform sampler2D u_color_stops;uniform int u_color_ramp_size;uniform float u_opacity;in vec2 v_pos;float getElevation(vec2 coord) {vec4 data=texture(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack);}float getElevationStop(int stop) {float x=(float(stop)+0.5)/float(u_color_ramp_size);vec4 data=texture(u_elevation_stops,vec2(x,0))*255.0;data.a=-1.0;return dot(data,u_unpack);}void main() {float el=getElevation(v_pos);int r=(u_color_ramp_size-1);int l=0;float el_l=getElevationStop(l);float el_r=getElevationStop(r);while(r-l > 1){int m=(r+l)/2;float el_m=getElevationStop(m);if(el < el_m){r=m;el_r=el_m;}else\n{l=m;el_l=el_m;}}float x=(float(l)+(el-el_l)/(el_r-el_l)+0.5)/float(u_color_ramp_size);fragColor=u_opacity*texture(u_color_stops,vec2(x,0));\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_dimension;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=projectTile(a_pos,a_pos);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_pos/8192.0)*scale+epsilon;if (a_pos.y <-32767.5) {v_pos.y=0.0;}if (a_pos.y > 32766.5) {v_pos.y=1.0;}}"),debug:Lt("uniform highp vec4 u_color;uniform sampler2D u_overlay;in vec2 v_uv;void main() {vec4 overlay_color=texture(u_overlay,v_uv);fragColor=mix(u_color,overlay_color,overlay_color.a);}","in vec2 a_pos;out vec2 v_uv;uniform float u_overlay_scale;void main() {v_uv=a_pos/8192.0;gl_Position=projectTileWithElevation(a_pos*u_overlay_scale,get_elevation(a_pos));}"),depth:Lt(Dt,"in vec2 a_pos;void main() {\n#ifdef GLOBE\ngl_Position=projectTileFor3D(a_pos,0.0);\n#else\ngl_Position=u_projection_matrix*vec4(a_pos,0.0,1.0);\n#endif\n}"),fill:Lt("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\nfragColor=color*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_fill_translate;in vec2 a_pos;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);}"),fillOutline:Lt("in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=outline_color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillOutlinePattern:Lt("uniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_fade;in vec2 v_pos_a;in vec2 v_pos_b;in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);float dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=mix(color1,color2,u_fade)*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillPattern:Lt("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_fade)*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileZoomRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileZoomRatio,a_pos);}"),fillExtrusion:Lt("in vec4 v_color;void main() {fragColor=v_color;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\nout vec4 v_color;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec3 normal=a_normal_ed.xyz;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nfloat colorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;v_color=vec4(0.0,0.0,0.0,1.0);vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;vec3 normalForLighting=normal/16384.0;float directional=clamp(dot(normalForLighting,u_lightpos),0.0,1.0);\n#ifdef GLOBE\nmat3 rotMatrix=globeGetRotationMatrix(spherePos);normalForLighting=rotMatrix*normalForLighting;directional=mix(directional,clamp(dot(normalForLighting,u_lightpos_globe),0.0,1.0),u_projection_transition);\n#endif\ndirectional=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_color.r+=clamp(color.r*directional*u_lightcolor.r,mix(0.0,0.3,1.0-u_lightcolor.r),1.0);v_color.g+=clamp(color.g*directional*u_lightcolor.g,mix(0.0,0.3,1.0-u_lightcolor.g),1.0);v_color.b+=clamp(color.b*directional*u_lightcolor.b,mix(0.0,0.3,1.0-u_lightcolor.b),1.0);v_color*=u_opacity;}"),fillExtrusionPattern:Lt("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;in vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);vec4 mixedColor=mix(color1,color2,u_fade);fragColor=mixedColor*v_lighting;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform vec3 u_scale;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\n#ifdef GLOBE\nout vec3 v_sphere_pos;\n#endif\nout vec2 v_pos_a;out vec2 v_pos_b;out vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec3 normal=a_normal_ed.xyz;float edgedistance=a_normal_ed.w;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);v_sphere_pos=elevatedPos;gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nvec2 pos=normal.x==1.0 && normal.y==0.0 && normal.z==16384.0\n? a_pos\n: vec2(edgedistance,elevation*u_height_factor);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float directional=clamp(dot(normal/16383.0,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_lighting.rgb+=clamp(directional*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;}"),hillshadePrepare:Lt("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord,float bias) {vec4 data=texture(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack);}void main() {vec2 epsilon=1.0/u_dimension;float tileSize=u_dimension.x-2.0;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y),0.0);float b=getElevation(v_pos+vec2(0,-epsilon.y),0.0);float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y),0.0);float d=getElevation(v_pos+vec2(-epsilon.x,0),0.0);float e=getElevation(v_pos,0.0);float f=getElevation(v_pos+vec2(epsilon.x,0),0.0);float g=getElevation(v_pos+vec2(-epsilon.x,epsilon.y),0.0);float h=getElevation(v_pos+vec2(0,epsilon.y),0.0);float i=getElevation(v_pos+vec2(epsilon.x,epsilon.y),0.0);float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2((c+f+f+i)-(a+d+d+g),(g+h+h+i)-(a+b+b+c))*tileSize/pow(2.0,exaggeration+(28.2562-u_zoom));fragColor=clamp(vec4(deriv.x/8.0+0.5,deriv.y/8.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;in vec2 a_pos;in vec2 a_texture_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:Lt("uniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_latrange;uniform float u_exaggeration;uniform vec4 u_accent;uniform int u_method;uniform float u_altitudes[NUM_ILLUMINATION_SOURCES];uniform float u_azimuths[NUM_ILLUMINATION_SOURCES];uniform vec4 u_shadows[NUM_ILLUMINATION_SOURCES];uniform vec4 u_highlights[NUM_ILLUMINATION_SOURCES];\n#define PI 3.141592653589793\n#define STANDARD 0\n#define COMBINED 1\n#define IGOR 2\n#define MULTIDIRECTIONAL 3\n#define BASIC 4\nfloat get_aspect(vec2 deriv){return deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);}void igor_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float aspect=get_aspect(deriv);float azimuth=u_azimuths[0]+PI;float slope_stength=atan(length(deriv))*2.0/PI;float aspect_strength=1.0-abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);float shadow_strength=slope_stength*aspect_strength;float highlight_strength=slope_stength*(1.0-aspect_strength);fragColor=u_shadows[0]*shadow_strength+u_highlights[0]*highlight_strength;}void standard_hillshade(vec2 deriv){float azimuth=u_azimuths[0]+PI;float slope=atan(0.625*length(deriv));float aspect=get_aspect(deriv);float intensity=u_exaggeration;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadows[0],u_highlights[0],shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);fragColor=accent_color*(1.0-shade_color.a)+shade_color;}void basic_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float azimuth=u_azimuths[0]+PI;float cos_az=cos(azimuth);float sin_az=sin(azimuth);float cos_alt=cos(u_altitudes[0]);float sin_alt=sin(u_altitudes[0]);float cang=(sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv));float shade=clamp(cang,0.0,1.0);if(shade > 0.5){fragColor=u_highlights[0]*(2.0*shade-1.0);}else\n{fragColor=u_shadows[0]*(1.0-2.0*shade);}}void multidirectional_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;fragColor=vec4(0,0,0,0);for(int i=0; i < NUM_ILLUMINATION_SOURCES; i++){float cos_alt=cos(u_altitudes[i]);float sin_alt=sin(u_altitudes[i]);float cos_az=-cos(u_azimuths[i]);float sin_az=-sin(u_azimuths[i]);float cang=(sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv));float shade=clamp(cang,0.0,1.0);if(shade > 0.5){fragColor+=u_highlights[i]*(2.0*shade-1.0)/float(NUM_ILLUMINATION_SOURCES);}else\n{fragColor+=u_shadows[i]*(1.0-2.0*shade)/float(NUM_ILLUMINATION_SOURCES);}}}void combined_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float azimuth=u_azimuths[0]+PI;float cos_az=cos(azimuth);float sin_az=sin(azimuth);float cos_alt=cos(u_altitudes[0]);float sin_alt=sin(u_altitudes[0]);float cang=acos((sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv)));cang=clamp(cang,0.0,PI/2.0);float shade=cang*atan(length(deriv))*4.0/PI/PI;float highlight=(PI/2.0-cang)*atan(length(deriv))*4.0/PI/PI;fragColor=u_shadows[0]*shade+u_highlights[0]*highlight;}void main() {vec4 pixel=texture(u_image,v_pos);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));vec2 deriv=((pixel.rg*8.0)-4.0)/scaleFactor;if (u_method==BASIC) {basic_hillshade(deriv);} else if (u_method==COMBINED) {combined_hillshade(deriv);} else if (u_method==IGOR) {igor_hillshade(deriv);} else if (u_method==MULTIDIRECTIONAL) {multidirectional_hillshade(deriv);} else if (u_method==STANDARD) {standard_hillshade(deriv);} else {standard_hillshade(deriv);}\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=projectTile(a_pos,a_pos);v_pos=a_pos/8192.0;if (a_pos.y <-32767.5) {v_pos.y=0.0;}if (a_pos.y > 32766.5) {v_pos.y=1.0;}}"),line:Lt("uniform lowp float u_device_pixel_ratio;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp float v_linesofar;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;v_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*2.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),lineGradient:Lt("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;in highp vec2 v_uv;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture(u_image,v_uv);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;in float a_uv_x;in float a_split_index;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp vec2 v_uv;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;highp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),linePattern:Lt("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_fade;uniform mediump vec3 u_scale;uniform sampler2D u_image;in vec2 v_normal;in vec2 v_width2;in float v_linesofar;in float v_gamma_scale;in float v_width;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;vec2 pattern_size_a=vec2(display_size_a.x*fromScale/tileZoomRatio,display_size_a.y);vec2 pattern_size_b=vec2(display_size_b.x*toScale/tileZoomRatio,display_size_b.y);float aspect_a=display_size_a.y/v_width;float aspect_b=display_size_b.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x_a=mod(v_linesofar/pattern_size_a.x*aspect_a,1.0);float x_b=mod(v_linesofar/pattern_size_b.x*aspect_b,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos_a=mix(pattern_tl_a*texel_size-texel_size,pattern_br_a*texel_size+texel_size,vec2(x_a,y));vec2 pos_b=mix(pattern_tl_b*texel_size-texel_size,pattern_br_b*texel_size+texel_size,vec2(x_b,y));vec4 color=mix(texture(u_image,pos_a),texture(u_image,pos_b),u_fade);fragColor=color*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform vec2 u_units_to_pixels;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_linesofar;out float v_gamma_scale;out float v_width;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;}"),lineSDF:Lt("uniform lowp float u_device_pixel_ratio;uniform lowp float u_lineatlas_width;uniform sampler2D u_image;uniform float u_mix;in vec2 v_normal;in vec2 v_width2;in vec2 v_tex_a;in vec2 v_tex_b;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define mediump vec4 dasharray_from\n#pragma mapbox: define mediump vec4 dasharray_to\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 dasharray_from\n#pragma mapbox: initialize mediump vec4 dasharray_to\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float sdfdist_a=texture(u_image,v_tex_a).a;float sdfdist_b=texture(u_image,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);float sdfgamma=(u_lineatlas_width/256.0/u_device_pixel_ratio)/min(dasharray_from.w,dasharray_to.w);alpha*=smoothstep(0.5-sdfgamma/floorwidth,0.5+sdfgamma/floorwidth,sdfdist);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_tileratio;uniform float u_crossfade_from;uniform float u_crossfade_to;uniform float u_lineatlas_height;out vec2 v_normal;out vec2 v_width2;out vec2 v_tex_a;out vec2 v_tex_b;out float v_gamma_scale;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define mediump vec4 dasharray_from\n#pragma mapbox: define mediump vec4 dasharray_to\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 dasharray_from\n#pragma mapbox: initialize mediump vec4 dasharray_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nfloat u_patternscale_a_x=u_tileratio/dasharray_from.w/u_crossfade_from;float u_patternscale_a_y=-dasharray_from.z/2.0/u_lineatlas_height;float u_patternscale_b_x=u_tileratio/dasharray_to.w/u_crossfade_to;float u_patternscale_b_y=-dasharray_to.z/2.0/u_lineatlas_height;v_tex_a=vec2(a_linesofar*u_patternscale_a_x/floorwidth,normal.y*u_patternscale_a_y+(float(dasharray_from.y)+0.5)/u_lineatlas_height);v_tex_b=vec2(a_linesofar*u_patternscale_b_x/floorwidth,normal.y*u_patternscale_b_y+(float(dasharray_to.y)+0.5)/u_lineatlas_height);v_width2=vec2(outset,inset);}"),lineGradientSDF:Lt("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;uniform sampler2D u_image_dash;uniform float u_mix;uniform lowp float u_lineatlas_width;in vec2 v_normal;in vec2 v_width2;in vec2 v_tex_a;in vec2 v_tex_b;in float v_gamma_scale;in highp vec2 v_uv;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define mediump vec4 dasharray_from\n#pragma mapbox: define mediump vec4 dasharray_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 dasharray_from\n#pragma mapbox: initialize mediump vec4 dasharray_to\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture(u_image,v_uv);float sdfdist_a=texture(u_image_dash,v_tex_a).a;float sdfdist_b=texture(u_image_dash,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);float sdfgamma=(u_lineatlas_width/256.0)/min(dasharray_from.w,dasharray_to.w);float dash_alpha=smoothstep(0.5-sdfgamma/floorwidth,0.5+sdfgamma/floorwidth,sdfdist);fragColor=color*(alpha*dash_alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;in float a_uv_x;in float a_split_index;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;uniform float u_tileratio;uniform float u_crossfade_from;uniform float u_crossfade_to;uniform float u_lineatlas_height;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp vec2 v_uv;out vec2 v_tex_a;out vec2 v_tex_b;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define mediump vec4 dasharray_from\n#pragma mapbox: define mediump vec4 dasharray_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 dasharray_from\n#pragma mapbox: initialize mediump vec4 dasharray_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;float texel_height=1.0/u_image_height;float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nfloat u_patternscale_a_x=u_tileratio/dasharray_from.w/u_crossfade_from;float u_patternscale_a_y=-dasharray_from.z/2.0/u_lineatlas_height;float u_patternscale_b_x=u_tileratio/dasharray_to.w/u_crossfade_to;float u_patternscale_b_y=-dasharray_to.z/2.0/u_lineatlas_height;v_tex_a=vec2(a_linesofar*u_patternscale_a_x/floorwidth,normal.y*u_patternscale_a_y+(float(dasharray_from.y)+0.5)/u_lineatlas_height);v_tex_b=vec2(a_linesofar*u_patternscale_b_x/floorwidth,normal.y*u_patternscale_b_y+(float(dasharray_to.y)+0.5)/u_lineatlas_height);v_width2=vec2(outset,inset);}"),raster:Lt("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;in vec2 v_pos0;in vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture(u_image0,v_pos0);vec4 color1=texture(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(dot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);fragColor=vec4(mix(u_high_vec,u_low_vec,rgb)*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform float u_buffer_scale;uniform vec4 u_coords_top;uniform vec4 u_coords_bottom;in vec2 a_pos;out vec2 v_pos0;out vec2 v_pos1;void main() {vec2 fractionalPos=a_pos/8192.0;vec2 position=mix(mix(u_coords_top.xy,u_coords_top.zw,fractionalPos.x),mix(u_coords_bottom.xy,u_coords_bottom.zw,fractionalPos.x),fractionalPos.y);gl_Position=projectTile(position,position);v_pos0=((fractionalPos-0.5)/u_buffer_scale)+0.5;\n#ifdef GLOBE\nif (a_pos.y <-32767.5) {v_pos0.y=0.0;}if (a_pos.y > 32766.5) {v_pos0.y=1.0;}\n#endif\nv_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}"),symbolIcon:Lt("uniform sampler2D u_texture;in vec2 v_tex;in float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;fragColor=texture(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_tex;out float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_minFontScale=a_pixeloffset.zw/256.0;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*max(a_minFontScale,fontScale)+a_pxoffset/16.0)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}gl_Position=finalPos;v_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float visibility=calculate_visibility(projectedPoint);v_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));}"),symbolSDF:Lt("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;in vec2 v_data0;in vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float inner_edge=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);inner_edge=inner_edge+gamma*gamma_scale;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(inner_edge-gamma_scaled,inner_edge+gamma_scaled,dist);if (u_is_halo) {lowp float halo_edge=(6.0-halo_width/fontScale)/SDF_PX;alpha=min(smoothstep(halo_edge-gamma_scaled,halo_edge+gamma_scaled,dist),1.0-alpha);}fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_data0;out vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity);}"),symbolTextAndIcon:Lt("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;in vec4 v_data0;in vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;fragColor=texture(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_texsize_icon;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec4 v_data0;out vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map && !u_is_along_line) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity,is_sdf);}"),terrain:Lt("uniform sampler2D u_texture;uniform vec4 u_fog_color;uniform vec4 u_horizon_color;uniform float u_fog_ground_blend;uniform float u_fog_ground_blend_opacity;uniform float u_horizon_fog_blend;uniform bool u_is_globe_mode;in vec2 v_texture_pos;in float v_fog_depth;const float gamma=2.2;vec4 gammaToLinear(vec4 color) {return pow(color,vec4(gamma));}vec4 linearToGamma(vec4 color) {return pow(color,vec4(1.0/gamma));}void main() {vec4 surface_color=texture(u_texture,vec2(v_texture_pos.x,1.0-v_texture_pos.y));if (!u_is_globe_mode && v_fog_depth > u_fog_ground_blend) {vec4 surface_color_linear=gammaToLinear(surface_color);float blend_color=smoothstep(0.0,1.0,max((v_fog_depth-u_horizon_fog_blend)/(1.0-u_horizon_fog_blend),0.0));vec4 fog_horizon_color_linear=mix(gammaToLinear(u_fog_color),gammaToLinear(u_horizon_color),blend_color);float factor_fog=max(v_fog_depth-u_fog_ground_blend,0.0)/(1.0-u_fog_ground_blend);fragColor=linearToGamma(mix(surface_color_linear,fog_horizon_color_linear,pow(factor_fog,2.0)*u_fog_ground_blend_opacity));} else {fragColor=surface_color;}}","in vec3 a_pos3d;uniform mat4 u_fog_matrix;uniform float u_ele_delta;out vec2 v_texture_pos;out float v_fog_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,get_elevation(a_pos3d.xy)-ele_delta);vec4 pos=u_fog_matrix*vec4(a_pos3d.xy,ele,1.0);v_fog_depth=pos.z/pos.w*0.5+0.5;}"),terrainDepth:Lt("in float v_depth;const highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitMsk=vec4(0.,vec3(1./256.0));highp vec4 pack(highp float value) {highp vec4 comp=fract(value*bitSh);comp-=comp.xxyz*bitMsk;return comp;}void main() {fragColor=pack(v_depth);}","in vec3 a_pos3d;uniform float u_ele_delta;out float v_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);v_depth=gl_Position.z/gl_Position.w;}"),terrainCoords:Lt("precision mediump float;uniform sampler2D u_texture;uniform float u_terrain_coords_id;in vec2 v_texture_pos;void main() {vec4 rgba=texture(u_texture,v_texture_pos);fragColor=vec4(rgba.r,rgba.g,rgba.b,u_terrain_coords_id);}","in vec3 a_pos3d;uniform float u_ele_delta;out vec2 v_texture_pos;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);}"),projectionErrorMeasurement:Lt("in vec4 v_output_error_encoded;void main() {fragColor=v_output_error_encoded;}","in vec2 a_pos;uniform highp float u_input;uniform highp float u_output_expected;out vec4 v_output_error_encoded;void main() {float real_output=2.0*atan(exp(PI-(u_input*PI*2.0)))-PI*0.5;float error=real_output-u_output_expected;float abs_error=abs(error)*128.0;v_output_error_encoded.x=min(floor(abs_error*256.0),255.0)/255.0;abs_error-=v_output_error_encoded.x;v_output_error_encoded.y=min(floor(abs_error*65536.0),255.0)/255.0;abs_error-=v_output_error_encoded.x/255.0;v_output_error_encoded.z=min(floor(abs_error*16777216.0),255.0)/255.0;v_output_error_encoded.w=error >=0.0 ? 1.0 : 0.0;gl_Position=vec4(a_pos,0.0,1.0);}"),atmosphere:Lt("#ifdef GL_ES\nprecision highp float;\n#endif\nin vec3 view_direction;uniform vec3 u_sun_pos;uniform vec3 u_globe_position;uniform float u_globe_radius;uniform float u_atmosphere_blend;/**Shader use from https:*Made some change to adapt to MapLibre Globe geometry*/const float PI=3.141592653589793;const int iSteps=5;const int jSteps=3;/*radius of the planet*/const float EARTH_RADIUS=6371e3;/*radius of the atmosphere*/const float ATMOS_RADIUS=6471e3;vec2 rsi(vec3 r0,vec3 rd,float sr) {float a=dot(rd,rd);float b=2.0*dot(rd,r0);float c=dot(r0,r0)-(sr*sr);float d=(b*b)-4.0*a*c;if (d < 0.0) return vec2(1e5,-1e5);return vec2((-b-sqrt(d))/(2.0*a),(-b+sqrt(d))/(2.0*a));}vec4 atmosphere(vec3 r,vec3 r0,vec3 pSun,float iSun,float rPlanet,float rAtmos,vec3 kRlh,float kMie,float shRlh,float shMie,float g) {pSun=normalize(pSun);r=normalize(r);vec2 p=rsi(r0,r,rAtmos);if (p.x > p.y) {return vec4(0.0,0.0,0.0,1.0);}if (p.x < 0.0) {p.x=0.0;}vec3 pos=r0+r*p.x;vec2 p2=rsi(r0,r,rPlanet);if (p2.x <=p2.y && p2.x > 0.0) {p.y=min(p.y,p2.x);}float iStepSize=(p.y-p.x)/float(iSteps);float iTime=p.x+iStepSize*0.5;vec3 totalRlh=vec3(0,0,0);vec3 totalMie=vec3(0,0,0);float iOdRlh=0.0;float iOdMie=0.0;float mu=dot(r,pSun);float mumu=mu*mu;float gg=g*g;float pRlh=3.0/(16.0*PI)*(1.0+mumu);float pMie=3.0/(8.0*PI)*((1.0-gg)*(mumu+1.0))/(pow(1.0+gg-2.0*mu*g,1.5)*(2.0+gg));for (int i=0; i < iSteps; i++) {vec3 iPos=r0+r*iTime;float iHeight=length(iPos)-rPlanet;float odStepRlh=exp(-iHeight/shRlh)*iStepSize;float odStepMie=exp(-iHeight/shMie)*iStepSize;iOdRlh+=odStepRlh;iOdMie+=odStepMie;float jStepSize=rsi(iPos,pSun,rAtmos).y/float(jSteps);float jTime=jStepSize*0.5;float jOdRlh=0.0;float jOdMie=0.0;for (int j=0; j < jSteps; j++) {vec3 jPos=iPos+pSun*jTime;float jHeight=length(jPos)-rPlanet;jOdRlh+=exp(-jHeight/shRlh)*jStepSize;jOdMie+=exp(-jHeight/shMie)*jStepSize;jTime+=jStepSize;}vec3 attn=exp(-(kMie*(iOdMie+jOdMie)+kRlh*(iOdRlh+jOdRlh)));totalRlh+=odStepRlh*attn;totalMie+=odStepMie*attn;iTime+=iStepSize;}float opacity=exp(-(length(kRlh)*length(totalRlh)+kMie*length(totalMie)));vec3 color=iSun*(pRlh*kRlh*totalRlh+pMie*kMie*totalMie);return vec4(color,opacity);}void main() {vec3 scale_camera_pos=-u_globe_position*EARTH_RADIUS/u_globe_radius;vec4 color=atmosphere(normalize(view_direction),scale_camera_pos,u_sun_pos,22.0,EARTH_RADIUS,ATMOS_RADIUS,vec3(5.5e-6,13.0e-6,22.4e-6),21e-6,8e3,1.2e3,0.758\n);color.rgb=1.0-exp(-1.0*color.rgb);color=pow(color,vec4(1.0/2.2));fragColor=vec4(color.rgb,1.0-color.a)*u_atmosphere_blend;}","in vec2 a_pos;uniform mat4 u_inv_proj_matrix;out vec3 view_direction;void main() {view_direction=(u_inv_proj_matrix*vec4(a_pos,0.0,1.0)).xyz;gl_Position=vec4(a_pos,0.0,1.0);}"),sky:Lt("uniform vec4 u_sky_color;uniform vec4 u_horizon_color;uniform vec2 u_horizon;uniform vec2 u_horizon_normal;uniform float u_sky_horizon_blend;uniform float u_sky_blend;void main() {float x=gl_FragCoord.x;float y=gl_FragCoord.y;float blend=(y-u_horizon.y)*u_horizon_normal.y+(x-u_horizon.x)*u_horizon_normal.x;if (blend > 0.0) {if (blend < u_sky_horizon_blend) {fragColor=mix(u_sky_color,u_horizon_color,pow(1.0-blend/u_sky_horizon_blend,2.0));} else {fragColor=u_sky_color;}}fragColor=mix(fragColor,vec4(vec3(0.0),0.0),u_sky_blend);}","in vec2 a_pos;void main() {gl_Position=vec4(a_pos,1.0,1.0);}")};function Lt(e,t){const i=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,a=t.match(/in ([\w]+) ([\w]+)/g),r=e.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),o=t.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),s=o?o.concat(r):r,n={};return {fragmentSource:e=e.replace(i,((e,t,i,a,r)=>(n[r]=!0,"define"===t?`\n#ifndef HAS_UNIFORM_u_${r}\nin ${i} ${a} ${r};\n#else\nuniform ${i} ${a} u_${r};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${r}\n    ${i} ${a} ${r} = u_${r};\n#endif\n`))),vertexSource:t=t.replace(i,((e,t,i,a,r)=>{const o="float"===a?"vec2":"vec4",s=r.match(/color/)?"color":o;return n[r]?"define"===t?`\n#ifndef HAS_UNIFORM_u_${r}\nuniform lowp float u_${r}_t;\nin ${i} ${o} a_${r};\nout ${i} ${a} ${r};\n#else\nuniform ${i} ${a} u_${r};\n#endif\n`:"vec4"===s?`\n#ifndef HAS_UNIFORM_u_${r}\n    ${r} = a_${r};\n#else\n    ${i} ${a} ${r} = u_${r};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${r}\n    ${r} = unpack_mix_${s}(a_${r}, u_${r}_t);\n#else\n    ${i} ${a} ${r} = u_${r};\n#endif\n`:"define"===t?`\n#ifndef HAS_UNIFORM_u_${r}\nuniform lowp float u_${r}_t;\nin ${i} ${o} a_${r};\n#else\nuniform ${i} ${a} u_${r};\n#endif\n`:"vec4"===s?`\n#ifndef HAS_UNIFORM_u_${r}\n    ${i} ${a} ${r} = a_${r};\n#else\n    ${i} ${a} ${r} = u_${r};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${r}\n    ${i} ${a} ${r} = unpack_mix_${s}(a_${r}, u_${r}_t);\n#else\n    ${i} ${a} ${r} = u_${r};\n#endif\n`})),staticAttributes:a,staticUniforms:s}}class kt{constructor(e,t,i){this.vertexBuffer=e,this.indexBuffer=t,this.segments=i;}destroy(){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.vertexBuffer=null,this.indexBuffer=null,this.segments=null;}}var Ft=t.aU([{name:"a_pos",type:"Int16",components:2}]);const Bt="#define PROJECTION_MERCATOR",Ot="mercator";class jt{constructor(){this._cachedMesh=null;}get name(){return "mercator"}get useSubdivision(){return !1}get shaderVariantName(){return Ot}get shaderDefine(){return Bt}get shaderPreludeCode(){return At.projectionMercator}get vertexShaderPreludeCode(){return At.projectionMercator.vertexSource}get subdivisionGranularity(){return t.aV.noSubdivision}get useGlobeControls(){return !1}get transitionState(){return 0}get latitudeErrorCorrectionRadians(){return 0}destroy(){}updateGPUdependent(e){}getMeshFromTileID(e,i,a,r,o){if(this._cachedMesh)return this._cachedMesh;const s=new t.aW;s.emplaceBack(0,0),s.emplaceBack(t.a5,0),s.emplaceBack(0,t.a5),s.emplaceBack(t.a5,t.a5);const n=e.createVertexBuffer(s,Ft.members),l=t.aX.simpleSegment(0,0,4,2),c=new t.aY;c.emplaceBack(1,0,2),c.emplaceBack(1,2,3);const h=e.createIndexBuffer(c);return this._cachedMesh=new kt(n,h,l),this._cachedMesh}recalculate(){}hasTransition(){return !1}setErrorQueryLatitudeDegrees(e){}}class Nt{constructor(e=0,t=0,i=0,a=0){if(isNaN(e)||e<0||isNaN(t)||t<0||isNaN(i)||i<0||isNaN(a)||a<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=e,this.bottom=t,this.left=i,this.right=a;}interpolate(e,i,a){return null!=i.top&&null!=e.top&&(this.top=t.G.number(e.top,i.top,a)),null!=i.bottom&&null!=e.bottom&&(this.bottom=t.G.number(e.bottom,i.bottom,a)),null!=i.left&&null!=e.left&&(this.left=t.G.number(e.left,i.left,a)),null!=i.right&&null!=e.right&&(this.right=t.G.number(e.right,i.right,a)),this}getCenter(e,i){const a=t.an((this.left+e-this.right)/2,0,e),r=t.an((this.top+i-this.bottom)/2,0,i);return new t.P(a,r)}equals(e){return this.top===e.top&&this.bottom===e.bottom&&this.left===e.left&&this.right===e.right}clone(){return new Nt(this.top,this.bottom,this.left,this.right)}toJSON(){return {top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function Zt(e,t){if(!e.renderWorldCopies||e.lngRange)return;const i=t.lng-e.center.lng;t.lng+=i>180?-360:i<-180?360:0;}function Gt(e){return Math.max(0,Math.floor(e))}class Ut{constructor(e,i){var a;this.applyConstrain=(e,t)=>null!==this._constrainOverride?this._constrainOverride(e,t):this._callbacks.defaultConstrain(e,t),this._callbacks=e,this._tileSize=512,this._renderWorldCopies=void 0===(null==i?void 0:i.renderWorldCopies)||!!(null==i?void 0:i.renderWorldCopies),this._minZoom=(null==i?void 0:i.minZoom)||0,this._maxZoom=(null==i?void 0:i.maxZoom)||22,this._minPitch=null==(null==i?void 0:i.minPitch)?0:null==i?void 0:i.minPitch,this._maxPitch=null==(null==i?void 0:i.maxPitch)?60:null==i?void 0:i.maxPitch,this._constrainOverride=null!==(a=null==i?void 0:i.constrainOverride)&&void 0!==a?a:null,this.setMaxBounds(),this._width=0,this._height=0,this._center=new t.V(0,0),this._elevation=0,this._zoom=0,this._tileZoom=Gt(this._zoom),this._scale=t.aq(this._zoom),this._bearingInRadians=0,this._fovInRadians=.6435011087932844,this._pitchInRadians=0,this._rollInRadians=0,this._unmodified=!0,this._edgeInsets=new Nt,this._minElevationForCurrentTile=0,this._autoCalculateNearFarZ=!0;}apply(e,i,a){this._constrainOverride=e.constrainOverride,this._latRange=e.latRange,this._lngRange=e.lngRange,this._width=e.width,this._height=e.height,this._center=e.center,this._elevation=e.elevation,this._minElevationForCurrentTile=e.minElevationForCurrentTile,this._zoom=e.zoom,this._tileZoom=Gt(this._zoom),this._scale=t.aq(this._zoom),this._bearingInRadians=e.bearingInRadians,this._fovInRadians=e.fovInRadians,this._pitchInRadians=e.pitchInRadians,this._rollInRadians=e.rollInRadians,this._unmodified=e.unmodified,this._edgeInsets=new Nt(e.padding.top,e.padding.bottom,e.padding.left,e.padding.right),this._minZoom=e.minZoom,this._maxZoom=e.maxZoom,this._minPitch=e.minPitch,this._maxPitch=e.maxPitch,this._renderWorldCopies=e.renderWorldCopies,this._cameraToCenterDistance=e.cameraToCenterDistance,this._nearZ=e.nearZ,this._farZ=e.farZ,this._autoCalculateNearFarZ=!a&&e.autoCalculateNearFarZ,i&&this.constrainInternal(),this._calcMatrices();}get pixelsToClipSpaceMatrix(){return this._pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._clipSpaceToPixelsMatrix}get minElevationForCurrentTile(){return this._minElevationForCurrentTile}setMinElevationForCurrentTile(e){this._minElevationForCurrentTile=e;}get tileSize(){return this._tileSize}get tileZoom(){return this._tileZoom}get scale(){return this._scale}get width(){return this._width}get height(){return this._height}get bearingInRadians(){return this._bearingInRadians}get lngRange(){return this._lngRange}get latRange(){return this._latRange}get pixelsToGLUnits(){return this._pixelsToGLUnits}get minZoom(){return this._minZoom}setMinZoom(e){this._minZoom!==e&&(this._minZoom=e,this.setZoom(this.applyConstrain(this._center,this.zoom).zoom));}get maxZoom(){return this._maxZoom}setMaxZoom(e){this._maxZoom!==e&&(this._maxZoom=e,this.setZoom(this.applyConstrain(this._center,this.zoom).zoom));}get minPitch(){return this._minPitch}setMinPitch(e){this._minPitch!==e&&(this._minPitch=e,this.setPitch(Math.max(this.pitch,e)));}get maxPitch(){return this._maxPitch}setMaxPitch(e){this._maxPitch!==e&&(this._maxPitch=e,this.setPitch(Math.min(this.pitch,e)));}get renderWorldCopies(){return this._renderWorldCopies}setRenderWorldCopies(e){void 0===e?e=!0:null===e&&(e=!1),this._renderWorldCopies=e;}get constrainOverride(){return this._constrainOverride}setConstrainOverride(e){void 0===e&&(e=null),this._constrainOverride!==e&&(this._constrainOverride=e,this.constrainInternal(),this._calcMatrices());}get worldSize(){return this._tileSize*this._scale}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new t.P(this._width,this._height)}get bearing(){return this._bearingInRadians/Math.PI*180}setBearing(e){const i=t.W(e,-180,180)*Math.PI/180;var r,o,s,n,l,c,h,u,d;this._bearingInRadians!==i&&(this._unmodified=!1,this._bearingInRadians=i,this._calcMatrices(),this._rotationMatrix=a(),r=this._rotationMatrix,s=-this._bearingInRadians,n=(o=this._rotationMatrix)[0],l=o[1],c=o[2],h=o[3],u=Math.sin(s),d=Math.cos(s),r[0]=n*d+c*u,r[1]=l*d+h*u,r[2]=n*-u+c*d,r[3]=l*-u+h*d);}get rotationMatrix(){return this._rotationMatrix}get pitchInRadians(){return this._pitchInRadians}get pitch(){return this._pitchInRadians/Math.PI*180}setPitch(e){const i=t.an(e,this.minPitch,this.maxPitch)/180*Math.PI;this._pitchInRadians!==i&&(this._unmodified=!1,this._pitchInRadians=i,this._calcMatrices());}get rollInRadians(){return this._rollInRadians}get roll(){return this._rollInRadians/Math.PI*180}setRoll(e){const t=e/180*Math.PI;this._rollInRadians!==t&&(this._unmodified=!1,this._rollInRadians=t,this._calcMatrices());}get fovInRadians(){return this._fovInRadians}get fov(){return t.aZ(this._fovInRadians)}setFov(e){e=t.an(e,.1,150),this.fov!==e&&(this._unmodified=!1,this._fovInRadians=t.ap(e),this._calcMatrices());}get zoom(){return this._zoom}setZoom(e){const i=this.applyConstrain(this._center,e).zoom;this._zoom!==i&&(this._unmodified=!1,this._zoom=i,this._tileZoom=Math.max(0,Math.floor(i)),this._scale=t.aq(i),this.constrainInternal(),this._calcMatrices());}get center(){return this._center}setCenter(e){e.lat===this._center.lat&&e.lng===this._center.lng||(this._unmodified=!1,this._center=e,this.constrainInternal(),this._calcMatrices());}get elevation(){return this._elevation}setElevation(e){e!==this._elevation&&(this._elevation=e,this.constrainInternal(),this._calcMatrices());}get padding(){return this._edgeInsets.toJSON()}setPadding(e){this._edgeInsets.equals(e)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,e,1),this._calcMatrices());}get centerPoint(){return this._edgeInsets.getCenter(this._width,this._height)}get pixelsPerMeter(){return this._pixelPerMeter}get unmodified(){return this._unmodified}get cameraToCenterDistance(){return this._cameraToCenterDistance}get nearZ(){return this._nearZ}get farZ(){return this._farZ}get autoCalculateNearFarZ(){return this._autoCalculateNearFarZ}overrideNearFarZ(e,t){this._autoCalculateNearFarZ=!1,this._nearZ=e,this._farZ=t,this._calcMatrices();}clearNearFarZOverride(){this._autoCalculateNearFarZ=!0,this._calcMatrices();}isPaddingEqual(e){return this._edgeInsets.equals(e)}interpolatePadding(e,t,i){this._unmodified=!1,this._edgeInsets.interpolate(e,t,i),this.constrainInternal(),this._calcMatrices();}resize(e,t,i=!0){this._width=e,this._height=t,i&&this.constrainInternal(),this._calcMatrices();}getMaxBounds(){return this._latRange&&2===this._latRange.length&&this._lngRange&&2===this._lngRange.length?new $([this._lngRange[0],this._latRange[0]],[this._lngRange[1],this._latRange[1]]):null}setMaxBounds(e){e?(this._lngRange=[e.getWest(),e.getEast()],this._latRange=[e.getSouth(),e.getNorth()],this.constrainInternal()):(this._lngRange=null,this._latRange=[-t.ao,t.ao]);}getCameraQueryGeometry(e,i){if(1===i.length)return [i[0],e];{const{minX:a,minY:r,maxX:o,maxY:s}=t.aa.fromPoints(i).extend(e);return [new t.P(a,r),new t.P(o,r),new t.P(o,s),new t.P(a,s),new t.P(a,r)]}}constrainInternal(){if(!this.center||!this._width||!this._height||this._constraining)return;this._constraining=!0;const e=this._unmodified,{center:t,zoom:i}=this.applyConstrain(this.center,this.zoom);this.setCenter(t),this.setZoom(i),this._unmodified=e,this._constraining=!1;}_calcMatrices(){if(this._width&&this._height){this._pixelsToGLUnits=[2/this._width,-2/this._height];let e=t.ar(new Float64Array(16));t.Q(e,e,[this._width/2,-this._height/2,1]),t.O(e,e,[1,-1,0]),this._clipSpaceToPixelsMatrix=e,e=t.ar(new Float64Array(16)),t.Q(e,e,[1,-1,1]),t.O(e,e,[-1,-1,0]),t.Q(e,e,[2/this._width,2/this._height,1]),this._pixelsToClipSpaceMatrix=e,this._cameraToCenterDistance=.5/Math.tan(this.fovInRadians/2)*this._height;}this._callbacks.calcMatrices();}calculateCenterFromCameraLngLatAlt(e,i,a,r){const o=void 0!==a?a:this.bearing,s=r=void 0!==r?r:this.pitch,{distanceToCenter:n,clampedElevation:l}=this._distanceToCenterFromAltElevationPitch(i,this.elevation,s),{x:c,y:h}=be(s,o),u=t.a9.fromLngLat(e,i);let d,_,p=t.a_(1,u.y),m=0;do{if(m+=1,m>10)break;_=n/p,d=new t.a9(u.x+c*_,u.y+h*_),p=1/d.meterInMercatorCoordinateUnits();}while(Math.abs(n-_*p)>1e-12);return {center:d.toLngLat(),elevation:l,zoom:t.at(this.height/2/Math.tan(this.fovInRadians/2)/_/this.tileSize)}}recalculateZoomAndCenter(e){if(this.elevation-e==0)return;const i=1/this.worldSize,a=t.as(1,this.center.lat)*this.worldSize,r=t.a9.fromLngLat(this.center,this.elevation),o=r.x/i,s=r.y/i,n=r.z/i,l=this.pitch,c=this.bearing,{x:h,y:u,z:d}=be(l,c),_=this.cameraToCenterDistance,p=o+_*-h,m=s+_*-u,f=n+_*d,{distanceToCenter:g,clampedElevation:v}=this._distanceToCenterFromAltElevationPitch(f/a,e,l),x=g*a,b=new t.a9((p+h*x)*i,(m+u*x)*i,0).toLngLat(),y=t.as(1,b.lat),w=t.at(this.height/2/Math.tan(this.fovInRadians/2)/g/y/this.tileSize);this._elevation=v,this._center=b,this.setZoom(w);}_distanceToCenterFromAltElevationPitch(e,i,a){const r=-Math.cos(t.ap(a)),o=e-i;let s,n=i;return r*o>=0||Math.abs(r)<.1?(s=1e4,n=e+s*r):s=-o/r,{distanceToCenter:s,clampedElevation:n}}getCameraPoint(){const e=Math.tan(this.pitchInRadians)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new t.P(e*Math.sin(this.rollInRadians),e*Math.cos(this.rollInRadians)))}getCameraAltitude(){return Math.cos(this.pitchInRadians)*this._cameraToCenterDistance/this._pixelPerMeter+this.elevation}getCameraLngLat(){const e=t.as(1,this.center.lat)*this.worldSize;return xe(this.center,this.elevation,this.pitch,this.bearing,this.cameraToCenterDistance/e).toLngLat()}getMercatorTileCoordinates(e){if(!e)return [0,0,1,1];const i=e.canonical.z>=0?1<<e.canonical.z:Math.pow(2,e.canonical.z);return [e.canonical.x/i,e.canonical.y/i,1/i/t.a5,1/i/t.a5]}}class Vt{constructor(e,i){this.min=e,this.max=i,this.center=t.a$([],t.b0([],this.min,this.max),.5);}quadrant(e){const i=[e%2==0,e<2],a=t.b1(this.min),r=t.b1(this.max);for(let e=0;e<i.length;e++)a[e]=i[e]?this.min[e]:this.center[e],r[e]=i[e]?this.center[e]:this.max[e];return r[2]=this.max[2],new Vt(a,r)}distanceX(e){return Math.max(Math.min(this.max[0],e[0]),this.min[0])-e[0]}distanceY(e){return Math.max(Math.min(this.max[1],e[1]),this.min[1])-e[1]}intersectsFrustum(e){let t=!0;for(let i=0;i<e.planes.length;i++){const a=this.intersectsPlane(e.planes[i]);if(0===a)return 0;1===a&&(t=!1);}return t?2:e.aabb.min[0]>this.max[0]||e.aabb.min[1]>this.max[1]||e.aabb.min[2]>this.max[2]||e.aabb.max[0]<this.min[0]||e.aabb.max[1]<this.min[1]||e.aabb.max[2]<this.min[2]?0:1}intersectsPlane(e){let t=e[3],i=e[3];for(let a=0;a<3;a++)e[a]>0?(t+=e[a]*this.min[a],i+=e[a]*this.max[a]):(i+=e[a]*this.min[a],t+=e[a]*this.max[a]);return t>=0?2:i<0?0:1}}class qt{distanceToTile2d(e,t,i,a){const r=a.distanceX([e,t]),o=a.distanceY([e,t]);return Math.hypot(r,o)}getWrap(e,t,i){return i}getTileBoundingVolume(e,i,a,r){var o,s;let n=0,l=0;if(null==r?void 0:r.terrain){const c=new t.a2(e.z,i,e.z,e.x,e.y),h=r.terrain.getMinMaxElevation(c);n=null!==(o=h.minElevation)&&void 0!==o?o:Math.min(0,a),l=null!==(s=h.maxElevation)&&void 0!==s?s:Math.max(0,a);}const c=1<<e.z;return new Vt([i+e.x/c,e.y/c,n],[i+(e.x+1)/c,(e.y+1)/c,l])}allowVariableZoom(e,i){const a=e.fov*(Math.abs(Math.cos(e.rollInRadians))*e.height+Math.abs(Math.sin(e.rollInRadians))*e.width)/e.height,r=t.an(78.5-a/2,0,60);return !!i.terrain||e.pitch>r}allowWorldCopies(){return !0}prepareNextFrame(){}}class Wt{constructor(e,t,i){this.points=e,this.planes=t,this.aabb=i;}static fromInvProjectionMatrix(e,i=1,a=0,r,o){const s=o?[[6,5,4],[0,1,2],[0,3,7],[2,1,5],[3,2,6],[0,4,5]]:[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]],n=Math.pow(2,a),l=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((a=>function(e,i,a,r){const o=t.aH([],e,i),s=1/o[3]/a*r;return t.b6(o,o,[s,s,1/o[3],s])}(a,e,i,n)));r&&function(e,i,a,r){const o=r?4:0,s=r?0:4;let n=0;const l=[],c=[];for(let i=0;i<4;i++){const a=t.b2([],e[i+s],e[i+o]),r=t.b7(a);t.a$(a,a,1/r),l.push(r),c.push(a);}for(let i=0;i<4;i++){const r=t.b8(e[i+o],c[i],a);n=null!==r&&r>=0?Math.max(n,r):Math.max(n,l[i]);}const h=function(e,i){const a=t.b2([],e[i[0]],e[i[1]]),r=t.b2([],e[i[2]],e[i[1]]),o=[0,0,0,0];return t.b3(o,t.b4([],a,r)),o[3]=-t.b5(o,e[i[0]]),o}(e,i),u=function(e,i){const a=t.b9(e),r=t.ba([],e,1/a),o=t.b2([],i,t.a$([],r,t.b5(i,r))),s=t.b9(o);if(s>0){const e=Math.sqrt(1-r[3]*r[3]),a=t.a$([],r,-r[3]),n=t.b0([],a,t.a$([],o,e/s));return t.bb(i,n)}return null}(a,h);if(null!==u){const e=u/t.b5(c[0],h);n=Math.min(n,e);}for(let t=0;t<4;t++){const i=Math.min(n,l[t]);e[t+s]=[e[t+o][0]+c[t][0]*i,e[t+o][1]+c[t][1]*i,e[t+o][2]+c[t][2]*i,1];}}(l,s[0],r,o);const c=s.map((e=>{const i=t.b2([],l[e[0]],l[e[1]]),a=t.b2([],l[e[2]],l[e[1]]),r=t.b3([],t.b4([],i,a)),o=-t.b5(r,l[e[1]]);return r.concat(o)})),h=[Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY],u=[Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY];for(const e of l)for(let t=0;t<3;t++)h[t]=Math.min(h[t],e[t]),u[t]=Math.max(u[t],e[t]);return new Wt(l,c,new Vt(h,u))}}class $t{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(e){this._helper.setMinZoom(e);}setMaxZoom(e){this._helper.setMaxZoom(e);}setMinPitch(e){this._helper.setMinPitch(e);}setMaxPitch(e){this._helper.setMaxPitch(e);}setRenderWorldCopies(e){this._helper.setRenderWorldCopies(e);}setBearing(e){this._helper.setBearing(e);}setPitch(e){this._helper.setPitch(e);}setRoll(e){this._helper.setRoll(e);}setFov(e){this._helper.setFov(e);}setZoom(e){this._helper.setZoom(e);}setCenter(e){this._helper.setCenter(e);}setElevation(e){this._helper.setElevation(e);}setMinElevationForCurrentTile(e){this._helper.setMinElevationForCurrentTile(e);}setPadding(e){this._helper.setPadding(e);}interpolatePadding(e,t,i){return this._helper.interpolatePadding(e,t,i)}isPaddingEqual(e){return this._helper.isPaddingEqual(e)}resize(e,t,i=!0){this._helper.resize(e,t,i);}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(e){this._helper.setMaxBounds(e);}setConstrainOverride(e){this._helper.setConstrainOverride(e);}overrideNearFarZ(e,t){this._helper.overrideNearFarZ(e,t);}clearNearFarZOverride(){this._helper.clearNearFarZOverride();}getCameraQueryGeometry(e){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),e)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get constrainOverride(){return this._helper.constrainOverride}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(e,t){}constructor(e){this._posMatrixCache=new Map,this._alignedPosMatrixCache=new Map,this._fogMatrixCacheF32=new Map,this.defaultConstrain=(e,i)=>{i=t.an(+i,this.minZoom,this.maxZoom);const a={center:new t.V(e.lng,e.lat),zoom:i};let r=this._helper._lngRange;if(!this._helper._renderWorldCopies&&null===r){const e=180-1e-10;r=[-e,e];}const o=this.tileSize*t.aq(a.zoom);let s=0,n=o,l=0,c=o,h=0,u=0;const{x:d,y:_}=this.size;if(this._helper._latRange){const e=this._helper._latRange;s=t.X(e[1])*o,n=t.X(e[0])*o,n-s<_&&(h=_/(n-s));}r&&(l=t.W(t.Y(r[0])*o,0,o),c=t.W(t.Y(r[1])*o,0,o),c<l&&(c+=o),c-l<d&&(u=d/(c-l)));const{x:p,y:m}=me(o,e);let f,g;const v=Math.max(u||0,h||0);if(v){const e=new t.P(u?(c+l)/2:p,h?(n+s)/2:m);return a.center=fe(o,e).wrap(),a.zoom+=t.at(v),a}if(this._helper._latRange){const e=_/2;m-e<s&&(g=s+e),m+e>n&&(g=n-e);}if(r){const e=(l+c)/2;let i=p;this._helper._renderWorldCopies&&(i=t.W(p,e-o/2,e+o/2));const a=d/2;i-a<l&&(f=l+a),i+a>c&&(f=c-a);}if(void 0!==f||void 0!==g){const e=new t.P(null!=f?f:p,null!=g?g:m);a.center=fe(o,e).wrap();}return a},this.applyConstrain=(e,t)=>this._helper.applyConstrain(e,t),this._helper=new Ut({calcMatrices:()=>{this._calcMatrices();},defaultConstrain:(e,t)=>this.defaultConstrain(e,t)},e),this._coveringTilesDetailsProvider=new qt;}clone(){const e=new $t;return e.apply(this,!1),e}apply(e,t,i){this._helper.apply(e,t,i);}get cameraPosition(){return this._cameraPosition}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._viewProjMatrix}get inverseProjectionMatrix(){return this._invProjMatrix}get mercatorMatrix(){return this._mercatorMatrix}getVisibleUnwrappedCoordinates(e){const i=[new t.bc(0,e)];if(this._helper._renderWorldCopies){const a=this.screenPointToMercatorCoordinate(new t.P(0,0)),r=this.screenPointToMercatorCoordinate(new t.P(this._helper._width,0)),o=this.screenPointToMercatorCoordinate(new t.P(this._helper._width,this._helper._height)),s=this.screenPointToMercatorCoordinate(new t.P(0,this._helper._height)),n=Math.floor(Math.min(a.x,r.x,o.x,s.x)),l=Math.floor(Math.max(a.x,r.x,o.x,s.x)),c=1;for(let a=n-c;a<=l+c;a++)0!==a&&i.push(new t.bc(a,e));}return i}getCameraFrustum(){return Wt.fromInvProjectionMatrix(this._invViewProjMatrix,this.worldSize)}getClippingPlane(){return null}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(e){const t=this.screenPointToLocation(this.centerPoint,e),i=e?e.getElevationForLngLatZoom(t,this._helper._tileZoom):0;this._helper.recalculateZoomAndCenter(i);}setLocationAtPoint(e,i){const a=t.as(this.elevation,this.center.lat),r=this.screenPointToMercatorCoordinateAtZ(i,a),o=this.screenPointToMercatorCoordinateAtZ(this.centerPoint,a),s=t.a9.fromLngLat(e),n=new t.a9(s.x-(r.x-o.x),s.y-(r.y-o.y));this.setCenter(null==n?void 0:n.toLngLat()),this._helper._renderWorldCopies&&this.setCenter(this.center.wrap());}locationToScreenPoint(e,i){return i?this.coordinatePoint(t.a9.fromLngLat(e),i.getElevationForLngLat(e,this),this._pixelMatrix3D):this.coordinatePoint(t.a9.fromLngLat(e))}screenPointToLocation(e,t){var i;return null===(i=this.screenPointToMercatorCoordinate(e,t))||void 0===i?void 0:i.toLngLat()}screenPointToMercatorCoordinate(e,t){if(t){const i=t.pointCoordinate(e);if(null!=i)return i}return this.screenPointToMercatorCoordinateAtZ(e)}screenPointToMercatorCoordinateAtZ(e,i){const a=i||0,r=[e.x,e.y,0,1],o=[e.x,e.y,1,1];t.aH(r,r,this._pixelMatrixInverse),t.aH(o,o,this._pixelMatrixInverse);const s=r[3],n=o[3],l=r[1]/s,c=o[1]/n,h=r[2]/s,u=o[2]/n,d=h===u?0:(a-h)/(u-h);return new t.a9(t.G.number(r[0]/s,o[0]/n,d)/this.worldSize,t.G.number(l,c,d)/this.worldSize,a)}coordinatePoint(e,i=0,a=this._pixelMatrix){const r=[e.x*this.worldSize,e.y*this.worldSize,i,1];return t.aH(r,r,a),new t.P(r[0]/r[3],r[1]/r[3])}getBounds(){const e=Math.max(0,this._helper._height/2-ge(this));return (new $).extend(this.screenPointToLocation(new t.P(0,e))).extend(this.screenPointToLocation(new t.P(this._helper._width,e))).extend(this.screenPointToLocation(new t.P(this._helper._width,this._helper._height))).extend(this.screenPointToLocation(new t.P(0,this._helper._height)))}isPointOnMapSurface(e,t){return t?null!=t.pointCoordinate(e):e.y>this.height/2-ge(this)}calculatePosMatrix(e,i=!1,a){var r;const o=null!==(r=e.key)&&void 0!==r?r:t.bd(e.wrap,e.canonical.z,e.canonical.z,e.canonical.x,e.canonical.y),s=i?this._alignedPosMatrixCache:this._posMatrixCache;if(s.has(o)){const e=s.get(o);return a?e.f32:e.f64}const n=ve(e,this.worldSize);t.S(n,i?this._alignedProjMatrix:this._viewProjMatrix,n);const l={f64:n,f32:new Float32Array(n)};return s.set(o,l),a?l.f32:l.f64}calculateFogMatrix(e){const i=e.key,a=this._fogMatrixCacheF32;if(a.has(i))return a.get(i);const r=ve(e,this.worldSize);return t.S(r,this._fogMatrix,r),a.set(i,new Float32Array(r)),a.get(i)}calculateCenterFromCameraLngLatAlt(e,t,i,a){return this._helper.calculateCenterFromCameraLngLatAlt(e,t,i,a)}_calculateNearFarZIfNeeded(e,i,a){if(!this._helper.autoCalculateNearFarZ)return;const r=Math.min(this.elevation,this.minElevationForCurrentTile,this.getCameraAltitude()-100),o=e-r*this._helper._pixelPerMeter/Math.cos(i),s=r<0?o:e,n=Math.PI/2+this.pitchInRadians,l=t.ap(this.fov)*(Math.abs(Math.cos(t.ap(this.roll)))*this.height+Math.abs(Math.sin(t.ap(this.roll)))*this.width)/this.height*(.5+a.y/this.height),c=Math.sin(l)*s/Math.sin(t.an(Math.PI-n-l,.01,Math.PI-.01)),h=ge(this),u=Math.atan(h/this._helper.cameraToCenterDistance),d=t.ap(.75),_=u>d?2*u*(.5+a.y/(2*h)):d,p=Math.sin(_)*s/Math.sin(t.an(Math.PI-n-_,.01,Math.PI-.01)),m=Math.min(c,p);this._helper._farZ=1.01*(Math.cos(Math.PI/2-i)*m+s),this._helper._nearZ=this._helper._height/50;}_calcMatrices(){if(!this._helper._height)return;const e=this.centerOffset,i=me(this.worldSize,this.center),a=i.x,r=i.y;this._helper._pixelPerMeter=t.as(1,this.center.lat)*this.worldSize;const o=t.ap(Math.min(this.pitch,pe)),s=Math.max(this._helper.cameraToCenterDistance/2,this._helper.cameraToCenterDistance+this._helper._elevation*this._helper._pixelPerMeter/Math.cos(o));let n;this._calculateNearFarZIfNeeded(s,o,e),n=new Float64Array(16),t.be(n,this.fovInRadians,this._helper._width/this._helper._height,this._helper._nearZ,this._helper._farZ),this._invProjMatrix=new Float64Array(16),t.aB(this._invProjMatrix,n),n[8]=2*-e.x/this._helper._width,n[9]=2*e.y/this._helper._height,this._projectionMatrix=t.bf(n),t.Q(n,n,[1,-1,1]),t.O(n,n,[0,0,-this._helper.cameraToCenterDistance]),t.bg(n,n,-this.rollInRadians),t.bh(n,n,this.pitchInRadians),t.bg(n,n,-this.bearingInRadians),t.O(n,n,[-a,-r,0]),this._mercatorMatrix=t.Q([],n,[this.worldSize,this.worldSize,this.worldSize]),t.Q(n,n,[1,1,this._helper._pixelPerMeter]),this._pixelMatrix=t.S(new Float64Array(16),this.clipSpaceToPixelsMatrix,n),t.O(n,n,[0,0,-this.elevation]),this._viewProjMatrix=n,this._invViewProjMatrix=t.aB([],n);const l=[0,0,-1,1];t.aH(l,l,this._invViewProjMatrix),this._cameraPosition=[l[0]/l[3],l[1]/l[3],l[2]/l[3]],this._fogMatrix=new Float64Array(16),t.be(this._fogMatrix,this.fovInRadians,this.width/this.height,s,this._helper._farZ),this._fogMatrix[8]=2*-e.x/this.width,this._fogMatrix[9]=2*e.y/this.height,t.Q(this._fogMatrix,this._fogMatrix,[1,-1,1]),t.O(this._fogMatrix,this._fogMatrix,[0,0,-this.cameraToCenterDistance]),t.bg(this._fogMatrix,this._fogMatrix,-this.rollInRadians),t.bh(this._fogMatrix,this._fogMatrix,this.pitchInRadians),t.bg(this._fogMatrix,this._fogMatrix,-this.bearingInRadians),t.O(this._fogMatrix,this._fogMatrix,[-a,-r,0]),t.Q(this._fogMatrix,this._fogMatrix,[1,1,this._helper._pixelPerMeter]),t.O(this._fogMatrix,this._fogMatrix,[0,0,-this.elevation]),this._pixelMatrix3D=t.S(new Float64Array(16),this.clipSpaceToPixelsMatrix,n);const c=this._helper._width%2/2,h=this._helper._height%2/2,u=Math.cos(this.bearingInRadians),d=Math.sin(-this.bearingInRadians),_=a-Math.round(a)+u*c+d*h,p=r-Math.round(r)+u*h+d*c,m=new Float64Array(n);if(t.O(m,m,[_>.5?_-1:_,p>.5?p-1:p,0]),this._alignedProjMatrix=m,n=t.aB(new Float64Array(16),this._pixelMatrix),!n)throw new Error("failed to invert matrix");this._pixelMatrixInverse=n,this._clearMatrixCaches();}_clearMatrixCaches(){this._posMatrixCache.clear(),this._alignedPosMatrixCache.clear(),this._fogMatrixCacheF32.clear();}maxPitchScaleFactor(){if(!this._pixelMatrixInverse)return 1;const e=this.screenPointToMercatorCoordinate(new t.P(0,0)),i=[e.x*this.worldSize,e.y*this.worldSize,0,1];return t.aH(i,i,this._pixelMatrix)[3]/this._helper.cameraToCenterDistance}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){const e=t.as(1,this.center.lat)*this.worldSize;return xe(this.center,this.elevation,this.pitch,this.bearing,this._helper.cameraToCenterDistance/e).toLngLat()}lngLatToCameraDepth(e,i){const a=t.a9.fromLngLat(e),r=[a.x*this.worldSize,a.y*this.worldSize,i,1];return t.aH(r,r,this._viewProjMatrix),r[2]/r[3]}getProjectionData(e){const{overscaledTileID:i,aligned:a,applyTerrainMatrix:r}=e,o=this._helper.getMercatorTileCoordinates(i),s=i?this.calculatePosMatrix(i,a,!0):null;let n;return n=i&&i.terrainRttPosMatrix32f&&r?i.terrainRttPosMatrix32f:s||t.bi(),{mainMatrix:n,tileMercatorCoords:o,clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:n}}isLocationOccluded(e){return !1}getPixelScale(){return 1}getCircleRadiusCorrection(){return 1}getPitchedTextCorrection(e,t,i){return 1}transformLightDirection(e){return t.b1(e)}getRayDirectionFromPixel(e){throw new Error("Not implemented.")}projectTileCoordinates(e,i,a,r){const o=this.calculatePosMatrix(a);let s;r?(s=[e,i,r(e,i),1],t.aH(s,s,o)):(s=[e,i,0,1],ot(s,s,o));const n=s[3];return {point:new t.P(s[0]/n,s[1]/n),signedDistanceFromCamera:n,isOccluded:!1}}populateCache(e){for(const t of e)this.calculatePosMatrix(t);}getMatrixForModel(e,i){const a=t.a9.fromLngLat(e,i),r=a.meterInMercatorCoordinateUnits(),o=t.bj();return t.O(o,o,[a.x,a.y,a.z]),t.bg(o,o,Math.PI),t.bh(o,o,Math.PI/2),t.Q(o,o,[-r,r,r]),o}getProjectionDataForCustomLayer(e=!0){const i=new t.a2(0,0,0,0,0),a=this.getProjectionData({overscaledTileID:i,applyGlobeMatrix:e}),r=ve(i,this.worldSize);t.S(r,this._viewProjMatrix,r),a.tileMercatorCoords=[0,0,1,1];const o=[t.a5,t.a5,this.worldSize/this._helper.pixelsPerMeter],s=t.bk();return t.Q(s,r,o),a.fallbackMatrix=s,a.mainMatrix=s,a}getFastPathSimpleProjectionMatrix(e){return this.calculatePosMatrix(e)}}function Ht(){t.w("Map cannot fit within canvas with the given bounds, padding, and/or offset.");}function Xt(e){if(e.useSlerp)if(e.k<1){const i=t.bl(e.startEulerAngles.roll,e.startEulerAngles.pitch,e.startEulerAngles.bearing),a=t.bl(e.endEulerAngles.roll,e.endEulerAngles.pitch,e.endEulerAngles.bearing),r=new Float64Array(4);t.bm(r,i,a,e.k);const o=t.bn(r);e.tr.setRoll(o.roll),e.tr.setPitch(o.pitch),e.tr.setBearing(o.bearing);}else e.tr.setRoll(e.endEulerAngles.roll),e.tr.setPitch(e.endEulerAngles.pitch),e.tr.setBearing(e.endEulerAngles.bearing);else e.tr.setRoll(t.G.number(e.startEulerAngles.roll,e.endEulerAngles.roll,e.k)),e.tr.setPitch(t.G.number(e.startEulerAngles.pitch,e.endEulerAngles.pitch,e.k)),e.tr.setBearing(t.G.number(e.startEulerAngles.bearing,e.endEulerAngles.bearing,e.k));}function Kt(e,i,a,r,o){const s=o.padding,n=me(o.worldSize,a.getNorthWest()),l=me(o.worldSize,a.getNorthEast()),c=me(o.worldSize,a.getSouthEast()),h=me(o.worldSize,a.getSouthWest()),u=t.ap(-r),d=n.rotate(u),_=l.rotate(u),p=c.rotate(u),m=h.rotate(u),f=new t.P(Math.max(d.x,_.x,m.x,p.x),Math.max(d.y,_.y,m.y,p.y)),g=new t.P(Math.min(d.x,_.x,m.x,p.x),Math.min(d.y,_.y,m.y,p.y)),v=f.sub(g),x=(o.width-(s.left+s.right+i.left+i.right))/v.x,b=(o.height-(s.top+s.bottom+i.top+i.bottom))/v.y;if(b<0||x<0)return void Ht();const y=Math.min(t.at(o.scale*Math.min(x,b)),e.maxZoom),w=t.P.convert(e.offset),T=new t.P((i.left-i.right)/2,(i.top-i.bottom)/2).rotate(t.ap(r)),P=w.add(T).mult(o.scale/t.aq(y));return {center:fe(o.worldSize,n.add(c).div(2).sub(P)),zoom:y,bearing:r}}class Yt{get useGlobeControls(){return !1}handlePanInertia(e,t){const i=e.mag(),a=Math.abs(ge(t));return {easingOffset:e.mult(Math.min(.75*a/i,1)),easingCenter:t.center}}handleMapControlsRollPitchBearingZoom(e,t){e.bearingDelta&&t.setBearing(t.bearing+e.bearingDelta),e.pitchDelta&&t.setPitch(t.pitch+e.pitchDelta),e.rollDelta&&t.setRoll(t.roll+e.rollDelta),e.zoomDelta&&t.setZoom(t.zoom+e.zoomDelta);}handleMapControlsPan(e,t,i){e.around.distSqr(t.centerPoint)<.01||t.setLocationAtPoint(i,e.around);}cameraForBoxAndBearing(e,t,i,a,r){return Kt(e,t,i,a,r)}handleJumpToCenterZoom(e,i){e.zoom!==(void 0!==i.zoom?+i.zoom:e.zoom)&&e.setZoom(+i.zoom),void 0!==i.center&&e.setCenter(t.V.convert(i.center));}handleEaseTo(e,i){const a=e.zoom,r=e.padding,o={roll:e.roll,pitch:e.pitch,bearing:e.bearing},s={roll:void 0===i.roll?e.roll:i.roll,pitch:void 0===i.pitch?e.pitch:i.pitch,bearing:void 0===i.bearing?e.bearing:i.bearing},n=void 0!==i.zoom,l=!e.isPaddingEqual(i.padding);let c=!1;const h=n?+i.zoom:e.zoom;let u=e.centerPoint.add(i.offsetAsPoint);const d=e.screenPointToLocation(u),{center:_,zoom:p}=e.applyConstrain(t.V.convert(i.center||d),null!=h?h:a);Zt(e,_);const m=me(e.worldSize,d),f=me(e.worldSize,_).sub(m),g=t.aq(p-a);return c=p!==a,{easeFunc:n=>{if(c&&e.setZoom(t.G.number(a,p,n)),t.bo(o,s)||Xt({startEulerAngles:o,endEulerAngles:s,tr:e,k:n,useSlerp:o.roll!=s.roll}),l&&(e.interpolatePadding(r,i.padding,n),u=e.centerPoint.add(i.offsetAsPoint)),i.around)e.setLocationAtPoint(i.around,i.aroundPoint);else {const i=t.aq(e.zoom-a),r=p>a?Math.min(2,g):Math.max(.5,g),o=Math.pow(r,1-n),s=fe(e.worldSize,m.add(f.mult(n*o)).mult(i));e.setLocationAtPoint(e.renderWorldCopies?s.wrap():s,u);}},isZooming:c,elevationCenter:_}}handleFlyTo(e,i){const a=void 0!==i.zoom,r=e.zoom,o=e.applyConstrain(t.V.convert(i.center||i.locationAtOffset),a?+i.zoom:r),s=o.center,n=o.zoom;Zt(e,s);const l=me(e.worldSize,i.locationAtOffset),c=me(e.worldSize,s).sub(l),h=c.mag(),u=t.aq(n-r);let d;if(void 0!==i.minZoom){const a=Math.min(+i.minZoom,r,n),o=e.applyConstrain(s,a).zoom;d=t.aq(o-r);}return {easeFunc:(i,a,o,h)=>{e.setZoom(1===i?n:r+t.at(a));const u=1===i?s:fe(e.worldSize,l.add(c.mult(o)).mult(a));e.setLocationAtPoint(e.renderWorldCopies?u.wrap():u,h);},scaleOfZoom:u,targetCenter:s,scaleOfMinZoom:d,pixelPathLength:h}}}class Qt{constructor(e,t,i){this.blendFunction=e,this.blendColor=t,this.mask=i;}}Qt.Replace=[1,0],Qt.disabled=new Qt(Qt.Replace,t.bp.transparent,[!1,!1,!1,!1]),Qt.unblended=new Qt(Qt.Replace,t.bp.transparent,[!0,!0,!0,!0]),Qt.alphaBlended=new Qt([1,771],t.bp.transparent,[!0,!0,!0,!0]);const Jt=2305;class ei{constructor(e,t,i){this.enable=e,this.mode=t,this.frontFace=i;}}ei.disabled=new ei(!1,1029,Jt),ei.backCCW=new ei(!0,1029,Jt),ei.frontCCW=new ei(!0,1028,Jt);class ti{constructor(e,t,i){this.func=e,this.mask=t,this.range=i;}}ti.ReadOnly=!1,ti.ReadWrite=!0,ti.disabled=new ti(519,ti.ReadOnly,[0,1]);const ii=7680;class ai{constructor(e,t,i,a,r,o){this.test=e,this.ref=t,this.mask=i,this.fail=a,this.depthFail=r,this.pass=o;}}ai.disabled=new ai({func:519,mask:0},0,0,ii,ii,ii);const ri=new WeakMap;function oi(e){var t;if(ri.has(e))return ri.get(e);{const i=null===(t=e.getParameter(e.VERSION))||void 0===t?void 0:t.startsWith("WebGL 2.0");return ri.set(e,i),i}}class si{get awaitingQuery(){return !!this._readbackQueue}constructor(e){this._readbackWaitFrames=4,this._measureWaitFrames=6,this._texWidth=1,this._texHeight=1,this._measuredError=0,this._updateCount=0,this._lastReadbackFrame=-1e3,this._readbackQueue=null,this._cachedRenderContext=e;const i=e.context,a=i.gl;this._texFormat=a.RGBA,this._texType=a.UNSIGNED_BYTE;const r=new t.aW;r.emplaceBack(-1,-1),r.emplaceBack(2,-1),r.emplaceBack(-1,2);const o=new t.aY;o.emplaceBack(0,1,2),this._fullscreenTriangle=new kt(i.createVertexBuffer(r,Ft.members),i.createIndexBuffer(o),t.aX.simpleSegment(0,0,r.length,o.length)),this._resultBuffer=new Uint8Array(4),i.activeTexture.set(a.TEXTURE1);const s=a.createTexture();a.bindTexture(a.TEXTURE_2D,s),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_S,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_T,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,a.NEAREST),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,a.NEAREST),a.texImage2D(a.TEXTURE_2D,0,this._texFormat,this._texWidth,this._texHeight,0,this._texFormat,this._texType,null),this._fbo=i.createFramebuffer(this._texWidth,this._texHeight,!1,!1),this._fbo.colorAttachment.set(s),oi(a)&&(this._pbo=a.createBuffer(),a.bindBuffer(a.PIXEL_PACK_BUFFER,this._pbo),a.bufferData(a.PIXEL_PACK_BUFFER,4,a.STREAM_READ),a.bindBuffer(a.PIXEL_PACK_BUFFER,null));}destroy(){const e=this._cachedRenderContext.context.gl;this._fullscreenTriangle.destroy(),this._fbo.destroy(),e.deleteBuffer(this._pbo),this._fullscreenTriangle=null,this._fbo=null,this._pbo=null,this._resultBuffer=null;}updateErrorLoop(e,t){const i=this._updateCount;return this._readbackQueue?i>=this._readbackQueue.frameNumberIssued+this._readbackWaitFrames&&this._tryReadback():i>=this._lastReadbackFrame+this._measureWaitFrames&&this._renderErrorTexture(e,t),this._updateCount++,this._measuredError}_bindFramebuffer(){const e=this._cachedRenderContext.context,t=e.gl;e.activeTexture.set(t.TEXTURE1),t.bindTexture(t.TEXTURE_2D,this._fbo.colorAttachment.get()),e.bindFramebuffer.set(this._fbo.framebuffer);}_renderErrorTexture(e,i){const a=this._cachedRenderContext.context,r=a.gl;if(this._bindFramebuffer(),a.viewport.set([0,0,this._texWidth,this._texHeight]),a.clear({color:t.bp.transparent}),this._cachedRenderContext.useProgram("projectionErrorMeasurement").draw(a,r.TRIANGLES,ti.disabled,ai.disabled,Qt.unblended,ei.disabled,((e,t)=>({u_input:e,u_output_expected:t}))(e,i),null,null,"$clipping",this._fullscreenTriangle.vertexBuffer,this._fullscreenTriangle.indexBuffer,this._fullscreenTriangle.segments),this._pbo&&oi(r)){r.bindBuffer(r.PIXEL_PACK_BUFFER,this._pbo),r.readBuffer(r.COLOR_ATTACHMENT0),r.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,0),r.bindBuffer(r.PIXEL_PACK_BUFFER,null);const e=r.fenceSync(r.SYNC_GPU_COMMANDS_COMPLETE,0);r.flush(),this._readbackQueue={frameNumberIssued:this._updateCount,sync:e};}else this._readbackQueue={frameNumberIssued:this._updateCount,sync:null};}_tryReadback(){const e=this._cachedRenderContext.context.gl;if(this._pbo&&this._readbackQueue&&oi(e)){const i=e.clientWaitSync(this._readbackQueue.sync,0,0);if(i===e.WAIT_FAILED)return t.w("WebGL2 clientWaitSync failed."),this._readbackQueue=null,void(this._lastReadbackFrame=this._updateCount);if(i===e.TIMEOUT_EXPIRED)return;e.bindBuffer(e.PIXEL_PACK_BUFFER,this._pbo),e.getBufferSubData(e.PIXEL_PACK_BUFFER,0,this._resultBuffer,0,4),e.bindBuffer(e.PIXEL_PACK_BUFFER,null);}else this._bindFramebuffer(),e.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,this._resultBuffer);this._readbackQueue=null,this._measuredError=si._parseRGBA8float(this._resultBuffer),this._lastReadbackFrame=this._updateCount;}static _parseRGBA8float(e){let t=0;return t+=e[0]/256,t+=e[1]/65536,t+=e[2]/16777216,e[3]<127&&(t=-t),t/128}}const ni=t.a5/128;function li(e,i){const a=void 0!==e.granularity?Math.max(e.granularity,1):1,r=a+(e.generateBorders?2:0),o=a+(e.extendToNorthPole||e.generateBorders?1:0)+(e.extendToSouthPole||e.generateBorders?1:0),s=r+1,n=o+1,l=e.generateBorders?-1:0,c=e.generateBorders||e.extendToNorthPole?-1:0,h=a+(e.generateBorders?1:0),u=a+(e.generateBorders||e.extendToSouthPole?1:0),d=s*n,_=r*o*6,p=s*n>65536;if(p&&"16bit"===i)throw new Error("Granularity is too large and meshes would not fit inside 16 bit vertex indices.");const m=p||"32bit"===i,f=new Int16Array(2*d);let g=0;for(let i=c;i<=u;i++)for(let r=l;r<=h;r++){let o=r/a*t.a5;-1===r&&(o=-ni),r===a+1&&(o=t.a5+ni);let s=i/a*t.a5;-1===i&&(s=e.extendToNorthPole?t.br:-ni),i===a+1&&(s=e.extendToSouthPole?t.bs:t.a5+ni),f[g++]=o,f[g++]=s;}const v=m?new Uint32Array(_):new Uint16Array(_);let x=0;for(let e=0;e<o;e++)for(let t=0;t<r;t++){const i=t+1+e*s,a=t+(e+1)*s,r=t+1+(e+1)*s;v[x++]=t+e*s,v[x++]=a,v[x++]=i,v[x++]=i,v[x++]=a,v[x++]=r;}return {vertices:f.buffer.slice(0),indices:v.buffer.slice(0),uses32bitIndices:m}}const ci=new t.aV({fill:new t.bt(128,2),line:new t.bt(512,0),tile:new t.bt(128,32),stencil:new t.bt(128,1),circle:3});class hi{constructor(){this._tileMeshCache={},this._errorCorrectionUsable=0,this._errorMeasurementLastValue=0,this._errorCorrectionPreviousValue=0,this._errorMeasurementLastChangeTime=-1e3;}get name(){return "vertical-perspective"}get transitionState(){return 1}get useSubdivision(){return !0}get shaderVariantName(){return "globe"}get shaderDefine(){return "#define GLOBE"}get shaderPreludeCode(){return At.projectionGlobe}get vertexShaderPreludeCode(){return At.projectionMercator.vertexSource}get subdivisionGranularity(){return ci}get useGlobeControls(){return !0}get latitudeErrorCorrectionRadians(){return this._errorCorrectionUsable}destroy(){this._errorMeasurement&&this._errorMeasurement.destroy();}updateGPUdependent(e){this._errorMeasurement||(this._errorMeasurement=new si(e));const i=t.X(this._errorQueryLatitudeDegrees),a=2*Math.atan(Math.exp(Math.PI-i*Math.PI*2))-.5*Math.PI,r=this._errorMeasurement.updateErrorLoop(i,a),o=c();r!==this._errorMeasurementLastValue&&(this._errorCorrectionPreviousValue=this._errorCorrectionUsable,this._errorMeasurementLastValue=r,this._errorMeasurementLastChangeTime=o);const s=Math.min(Math.max((o-this._errorMeasurementLastChangeTime)/1e3/.5,0),1);this._errorCorrectionUsable=t.bu(this._errorCorrectionPreviousValue,-this._errorMeasurementLastValue,t.bv(s));}_getMeshKey(e){return `${e.granularity.toString(36)}_${e.generateBorders?"b":""}${e.extendToNorthPole?"n":""}${e.extendToSouthPole?"s":""}`}getMeshFromTileID(e,t,i,a,r){const o=("stencil"===r?ci.stencil:ci.tile).getGranularityForZoomLevel(t.z);return this._getMesh(e,{granularity:o,generateBorders:i,extendToNorthPole:0===t.y&&a,extendToSouthPole:t.y===(1<<t.z)-1&&a})}_getMesh(e,i){const a=this._getMeshKey(i);if(a in this._tileMeshCache)return this._tileMeshCache[a];const r=function(e,i){const a=li(i,"16bit"),r=t.aW.deserialize({arrayBuffer:a.vertices,length:a.vertices.byteLength/2/2}),o=t.aY.deserialize({arrayBuffer:a.indices,length:a.indices.byteLength/2/3});return new kt(e.createVertexBuffer(r,Ft.members),e.createIndexBuffer(o),t.aX.simpleSegment(0,0,r.length,o.length))}(e,i);return this._tileMeshCache[a]=r,r}recalculate(e){}hasTransition(){const e=c();let t=!1;return t=t||(e-this._errorMeasurementLastChangeTime)/1e3<.7,t=t||this._errorMeasurement&&this._errorMeasurement.awaitingQuery,t}setErrorQueryLatitudeDegrees(e){this._errorQueryLatitudeDegrees=e;}}const ui=new t.t({type:new t.D(t.u.projection.type)});class di extends t.E{constructor(e){super(),this._transitionable=new t.x(ui,void 0),this.setProjection(e),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new t.H(0)),this._mercatorProjection=new jt,this._verticalPerspectiveProjection=new hi;}get transitionState(){const e=this.properties.get("type");if("string"==typeof e&&"mercator"===e)return 0;if("string"==typeof e&&"vertical-perspective"===e)return 1;if(e instanceof t.bw){if("vertical-perspective"===e.from&&"mercator"===e.to)return 1-e.transition;if("mercator"===e.from&&"vertical-perspective"===e.to)return e.transition}return 1}get useGlobeRendering(){return this.transitionState>0}get latitudeErrorCorrectionRadians(){return this._verticalPerspectiveProjection.latitudeErrorCorrectionRadians}get currentProjection(){return this.useGlobeRendering?this._verticalPerspectiveProjection:this._mercatorProjection}get name(){return "globe"}get useSubdivision(){return this.currentProjection.useSubdivision}get shaderVariantName(){return this.currentProjection.shaderVariantName}get shaderDefine(){return this.currentProjection.shaderDefine}get shaderPreludeCode(){return this.currentProjection.shaderPreludeCode}get vertexShaderPreludeCode(){return this.currentProjection.vertexShaderPreludeCode}get subdivisionGranularity(){return this.currentProjection.subdivisionGranularity}get useGlobeControls(){return this.transitionState>0}destroy(){this._mercatorProjection.destroy(),this._verticalPerspectiveProjection.destroy();}updateGPUdependent(e){this._mercatorProjection.updateGPUdependent(e),this._verticalPerspectiveProjection.updateGPUdependent(e);}getMeshFromTileID(e,t,i,a,r){return this.currentProjection.getMeshFromTileID(e,t,i,a,r)}setProjection(e){this._transitionable.setValue("type",(null==e?void 0:e.type)||"mercator");}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()||this.currentProjection.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}setErrorQueryLatitudeDegrees(e){this._verticalPerspectiveProjection.setErrorQueryLatitudeDegrees(e),this._mercatorProjection.setErrorQueryLatitudeDegrees(e);}}function _i(e){const t=fi(e.worldSize,e.center.lat);return 2*Math.PI*t}function pi(e,i,a,r,o){const s=1/(1<<o),n=i/t.a5*s+r*s,l=t.by((e/t.a5*s+a*s)*Math.PI*2+Math.PI,2*Math.PI),c=2*Math.atan(Math.exp(Math.PI-n*Math.PI*2))-.5*Math.PI,h=Math.cos(c),u=new Float64Array(3);return u[0]=Math.sin(l)*h,u[1]=Math.sin(c),u[2]=Math.cos(l)*h,u}function mi(e){return function(e,t){const i=Math.cos(t),a=new Float64Array(3);return a[0]=Math.sin(e)*i,a[1]=Math.sin(t),a[2]=Math.cos(e)*i,a}(e.lng*Math.PI/180,e.lat*Math.PI/180)}function fi(e,t){return e/(2*Math.PI)/Math.cos(t*Math.PI/180)}function gi(e){const i=Math.asin(e[1])/Math.PI*180,a=Math.sqrt(e[0]*e[0]+e[2]*e[2]);if(a>1e-6){const r=e[0]/a,o=Math.acos(e[2]/a),s=(r>0?o:-o)/Math.PI*180;return new t.V(t.W(s,-180,180),i)}return new t.V(0,i)}function vi(e){return Math.cos(e*Math.PI/180)}function xi(e,i){const a=vi(e),r=vi(i);return t.at(r/a)}function bi(e,i){const a=e.rotate(i.bearingInRadians),r=i.zoom+xi(i.center.lat,0),o=t.bu(1/vi(i.center.lat),1/vi(Math.min(Math.abs(i.center.lat),60)),t.bx(r,7,3,0,1)),s=360/_i({worldSize:i.worldSize,center:{lat:i.center.lat}});return new t.V(i.center.lng-a.x*s*o,t.an(i.center.lat+a.y*s,-t.ao,t.ao))}function yi(e){const t=.5*e,i=Math.sin(t),a=Math.cos(t);return Math.log(i+a)-Math.log(a-i)}function wi(e,i,a,r){const o=e.lat+a*r;if(Math.abs(a)>1){const s=(Math.sign(e.lat+a)!==Math.sign(e.lat)?-Math.abs(e.lat):Math.abs(e.lat))*Math.PI/180,n=Math.abs(e.lat+a)*Math.PI/180,l=yi(s+r*(n-s)),c=yi(s),h=yi(n);return new t.V(e.lng+i*((l-c)/(h-c)),o)}return new t.V(e.lng+i*r,o)}class Ti{constructor(e){this._cachePrevious=new Map,this._cache=new Map,this._hadAnyChanges=!1,this._boundingVolumeFactory=e;}swapBuffers(){if(!this._hadAnyChanges)return;const e=this._cachePrevious;this._cachePrevious=this._cache,this._cache=e,this._cache.clear(),this._hadAnyChanges=!1;}getTileBoundingVolume(e,t,i,a){const r=`${e.z}_${e.x}_${e.y}_${(null==a?void 0:a.terrain)?"t":""}`,o=this._cache.get(r);if(o)return o;const s=this._cachePrevious.get(r);if(s)return this._cache.set(r,s),s;const n=this._boundingVolumeFactory(e,t,i,a);return this._cache.set(r,n),this._hadAnyChanges=!0,n}}class Pi{constructor(e,t,i,a){this.min=i,this.max=a,this.points=e,this.planes=t;}static fromAabb(e,t){const i=[];for(let a=0;a<8;a++)i.push([1&~a?e[0]:t[0],1==(a>>1&1)?t[1]:e[1],1==(a>>2&1)?t[2]:e[2]]);return new Pi(i,[[-1,0,0,t[0]],[1,0,0,-e[0]],[0,-1,0,t[1]],[0,1,0,-e[1]],[0,0,-1,t[2]],[0,0,1,-e[2]]],e,t)}static fromCenterSizeAngles(e,i,a){const r=t.bB([],a[0],a[1],a[2]),o=t.bC([],[i[0],0,0],r),s=t.bC([],[0,i[1],0],r),n=t.bC([],[0,0,i[2]],r),l=[...e],c=[...e];for(let t=0;t<8;t++)for(let i=0;i<3;i++){const a=e[i]+o[i]*(1&~t?-1:1)+s[i]*(1==(t>>1&1)?1:-1)+n[i]*(1==(t>>2&1)?1:-1);l[i]=Math.min(l[i],a),c[i]=Math.max(c[i],a);}const h=[];for(let i=0;i<8;i++){const a=[...e];t.b0(a,a,t.a$([],o,1&~i?-1:1)),t.b0(a,a,t.a$([],s,1==(i>>1&1)?1:-1)),t.b0(a,a,t.a$([],n,1==(i>>2&1)?1:-1)),h.push(a);}return new Pi(h,[[...o,-t.b5(o,h[0])],[...s,-t.b5(s,h[0])],[...n,-t.b5(n,h[0])],[-o[0],-o[1],-o[2],-t.b5(o,h[7])],[-s[0],-s[1],-s[2],-t.b5(s,h[7])],[-n[0],-n[1],-n[2],-t.b5(n,h[7])]],l,c)}intersectsFrustum(e){let t=!0;const i=this.points.length,a=this.planes.length,r=e.planes.length,o=e.points.length;for(let a=0;a<r;a++){const r=e.planes[a];let o=0;for(let e=0;e<i;e++){const t=this.points[e];r[0]*t[0]+r[1]*t[1]+r[2]*t[2]+r[3]>=0&&o++;}if(0===o)return 0;o<i&&(t=!1);}if(t)return 2;for(let t=0;t<a;t++){const i=this.planes[t];let a=0;for(let t=0;t<o;t++){const r=e.points[t];i[0]*r[0]+i[1]*r[1]+i[2]*r[2]+i[3]>=0&&a++;}if(0===a)return 0}return 1}intersectsPlane(e){const t=this.points.length;let i=0;for(let a=0;a<t;a++){const t=this.points[a];e[0]*t[0]+e[1]*t[1]+e[2]*t[2]+e[3]>=0&&i++;}return i===t?2:0===i?0:1}}function Ci(e,t,i){const a=e-t;return a<0?-a:Math.max(0,a-i)}function Ii(e,t,i,a,r){const o=e-i;let s;return s=o<0?Math.min(-o,1+o-r):o>1?Math.min(Math.max(o-r,0),1-o):0,Math.max(s,Ci(t,a,r))}class Mi{constructor(){this._boundingVolumeCache=new Ti(this._computeTileBoundingVolume);}prepareNextFrame(){this._boundingVolumeCache.swapBuffers();}distanceToTile2d(e,t,i,a){const r=1<<i.z,o=1/r,s=i.x/r,n=i.y/r;let l=2;return l=Math.min(l,Ii(e,t,s,n,o)),l=Math.min(l,Ii(e,t,s+.5,-n-o,o)),l=Math.min(l,Ii(e,t,s+.5,2-n-o,o)),l}getWrap(e,t,i){const a=1<<t.z,r=1/a,o=t.x/a,s=Ci(e.x,o,r),n=Ci(e.x,o-1,r),l=Ci(e.x,o+1,r),c=Math.min(s,n,l);return c===l?1:c===n?-1:0}allowVariableZoom(e,t){return Ce(e,t)>4}allowWorldCopies(){return !1}getTileBoundingVolume(e,t,i,a){return this._boundingVolumeCache.getTileBoundingVolume(e,t,i,a)}_computeTileBoundingVolume(e,i,a,r){var o,s;let n=0,l=0;if(null==r?void 0:r.terrain){const c=new t.a2(e.z,i,e.z,e.x,e.y),h=r.terrain.getMinMaxElevation(c);n=null!==(o=h.minElevation)&&void 0!==o?o:Math.min(0,a),l=null!==(s=h.maxElevation)&&void 0!==s?s:Math.max(0,a);}if(n/=t.bE,l/=t.bE,n+=1,l+=1,e.z<=0)return Pi.fromAabb([-l,-l,-l],[l,l,l]);if(1===e.z)return Pi.fromAabb([0===e.x?-l:0,0===e.y?0:-l,-l],[0===e.x?0:l,0===e.y?l:0,l]);{const i=[pi(0,0,e.x,e.y,e.z),pi(t.a5,0,e.x,e.y,e.z),pi(t.a5,t.a5,e.x,e.y,e.z),pi(0,t.a5,e.x,e.y,e.z)],a=[];for(const e of i)a.push(t.a$([],e,l));if(l!==n)for(const e of i)a.push(t.a$([],e,n));0===e.y&&a.push([0,1,0]),e.y===(1<<e.z)-1&&a.push([0,-1,0]);const r=[1,1,1],o=[-1,-1,-1];for(const e of a)for(let t=0;t<3;t++)r[t]=Math.min(r[t],e[t]),o[t]=Math.max(o[t],e[t]);const s=pi(t.a5/2,t.a5/2,e.x,e.y,e.z),c=t.b4([],[0,1,0],s);t.b3(c,c);const h=t.b4([],s,c);t.b3(h,h);const u=t.b4([],i[2],i[1]);t.b3(u,u);const d=t.b4([],i[0],i[3]);t.b3(d,d),a.push(t.a$([],s,l)),e.y>=(1<<e.z)/2&&a.push(t.a$([],pi(t.a5/2,0,e.x,e.y,e.z),l)),e.y<(1<<e.z)/2&&a.push(t.a$([],pi(t.a5/2,t.a5,e.x,e.y,e.z),l));const _=Ei(s,a),p=Ei(h,a),m=[-s[0],-s[1],-s[2],_.max],f=[s[0],s[1],s[2],-_.min],g=[-h[0],-h[1],-h[2],p.max],v=[h[0],h[1],h[2],-p.min],x=[...u,0],b=[...d,0],y=[];return 0===e.y?y.push(t.bD(b,x,m),t.bD(b,x,f)):y.push(t.bD(g,x,m),t.bD(g,x,f),t.bD(g,b,m),t.bD(g,b,f)),e.y===(1<<e.z)-1?y.push(t.bD(b,x,m),t.bD(b,x,f)):y.push(t.bD(v,x,m),t.bD(v,x,f),t.bD(v,b,m),t.bD(v,b,f)),new Pi(y,[m,f,g,v,x,b],r,o)}}}function Ei(e,i){let a=1/0,r=-1/0;for(const o of i){const i=t.b5(e,o);a=Math.min(a,i),r=Math.max(r,i);}return {min:a,max:r}}class Si{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(e){this._helper.setMinZoom(e);}setMaxZoom(e){this._helper.setMaxZoom(e);}setMinPitch(e){this._helper.setMinPitch(e);}setMaxPitch(e){this._helper.setMaxPitch(e);}setRenderWorldCopies(e){this._helper.setRenderWorldCopies(e);}setBearing(e){this._helper.setBearing(e);}setPitch(e){this._helper.setPitch(e);}setRoll(e){this._helper.setRoll(e);}setFov(e){this._helper.setFov(e);}setZoom(e){this._helper.setZoom(e);}setCenter(e){this._helper.setCenter(e);}setElevation(e){this._helper.setElevation(e);}setMinElevationForCurrentTile(e){this._helper.setMinElevationForCurrentTile(e);}setPadding(e){this._helper.setPadding(e);}interpolatePadding(e,t,i){return this._helper.interpolatePadding(e,t,i)}isPaddingEqual(e){return this._helper.isPaddingEqual(e)}resize(e,t){this._helper.resize(e,t);}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(e){this._helper.setMaxBounds(e);}setConstrainOverride(e){this._helper.setConstrainOverride(e);}overrideNearFarZ(e,t){this._helper.overrideNearFarZ(e,t);}clearNearFarZOverride(){this._helper.clearNearFarZOverride();}getCameraQueryGeometry(e){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),e)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get constrainOverride(){return this._helper.constrainOverride}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(e){}constructor(e){this._cachedClippingPlane=t.bF(),this._projectionMatrix=t.bj(),this._globeViewProjMatrix32f=t.bi(),this._globeViewProjMatrixNoCorrection=t.bj(),this._globeViewProjMatrixNoCorrectionInverted=t.bj(),this._globeProjMatrixInverted=t.bj(),this._cameraPosition=t.bz(),this._globeLatitudeErrorCorrectionRadians=0,this.defaultConstrain=(e,i)=>{const a=t.an(e.lat,-t.ao,t.ao),r=t.an(+i,this.minZoom+xi(0,a),this.maxZoom);return {center:new t.V(e.lng,a),zoom:r}},this.applyConstrain=(e,t)=>this._helper.applyConstrain(e,t),this._helper=new Ut({calcMatrices:()=>{this._calcMatrices();},defaultConstrain:(e,t)=>this.defaultConstrain(e,t)},e),this._coveringTilesDetailsProvider=new Mi;}clone(){const e=new Si;return e.apply(this,!1),e}apply(e,t,i){this._globeLatitudeErrorCorrectionRadians=i||0,this._helper.apply(e,t);}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._globeViewProjMatrixNoCorrection}get inverseProjectionMatrix(){return this._globeProjMatrixInverted}get cameraPosition(){const e=t.bz();return e[0]=this._cameraPosition[0],e[1]=this._cameraPosition[1],e[2]=this._cameraPosition[2],e}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}getProjectionData(e){const{overscaledTileID:t,applyGlobeMatrix:i}=e,a=this._helper.getMercatorTileCoordinates(t);return {mainMatrix:this._globeViewProjMatrix32f,tileMercatorCoords:a,clippingPlane:this._cachedClippingPlane,projectionTransition:i?1:0,fallbackMatrix:this._globeViewProjMatrix32f}}_computeClippingPlane(e){const i=this.pitchInRadians,a=this.cameraToCenterDistance/e,r=Math.sin(i)*a,o=Math.cos(i)*a+1,s=1/Math.sqrt(r*r+o*o)*1;let n=-r,l=o;const c=Math.sqrt(n*n+l*l);n/=c,l/=c;const h=[0,n,l];t.bG(h,h,[0,0,0],-this.bearingInRadians),t.bH(h,h,[0,0,0],-1*this.center.lat*Math.PI/180),t.bI(h,h,[0,0,0],this.center.lng*Math.PI/180);const u=1/t.b7(h);return t.a$(h,h,u),[...h,-s*u]}isLocationOccluded(e){return !this.isSurfacePointVisible(mi(e))}transformLightDirection(e){const i=this._helper._center.lng*Math.PI/180,a=this._helper._center.lat*Math.PI/180,r=Math.cos(a),o=[Math.sin(i)*r,Math.sin(a),Math.cos(i)*r],s=[o[2],0,-o[0]],n=[0,0,0];t.b4(n,s,o),t.b3(s,s),t.b3(n,n);const l=[0,0,0];return t.b3(l,[s[0]*e[0]+n[0]*e[1]+o[0]*e[2],s[1]*e[0]+n[1]*e[1]+o[1]*e[2],s[2]*e[0]+n[2]*e[1]+o[2]*e[2]]),l}getPixelScale(){return 1/Math.cos(this._helper._center.lat*Math.PI/180)}getCircleRadiusCorrection(){return Math.cos(this._helper._center.lat*Math.PI/180)}getPitchedTextCorrection(e,i,a){const r=function(e,i,a){const r=1/(1<<a.z);return new t.a9(e/t.a5*r+a.x*r,i/t.a5*r+a.y*r)}(e,i,a.canonical),o=(s=r.y,[t.by(r.x*Math.PI*2+Math.PI,2*Math.PI),2*Math.atan(Math.exp(Math.PI-s*Math.PI*2))-.5*Math.PI]);var s;return this.getCircleRadiusCorrection()/Math.cos(o[1])}projectTileCoordinates(e,i,a,r){const o=a.canonical,s=pi(e,i,o.x,o.y,o.z),n=1+(r?r(e,i):0)/t.bE,l=[s[0]*n,s[1]*n,s[2]*n,1];t.aH(l,l,this._globeViewProjMatrixNoCorrection);const c=this._cachedClippingPlane,h=c[0]*s[0]+c[1]*s[1]+c[2]*s[2]+c[3]<0;return {point:new t.P(l[0]/l[3],l[1]/l[3]),signedDistanceFromCamera:l[3],isOccluded:h}}_calcMatrices(){if(!this._helper._width||!this._helper._height)return;const e=fi(this.worldSize,this.center.lat),i=t.bk(),a=t.bk();this._helper.autoCalculateNearFarZ&&(this._helper._nearZ=.5,this._helper._farZ=this.cameraToCenterDistance+2*e),t.be(i,this.fovInRadians,this.width/this.height,this._helper._nearZ,this._helper._farZ);const r=this.centerOffset;i[8]=2*-r.x/this._helper._width,i[9]=2*r.y/this._helper._height,this._projectionMatrix=t.bf(i),this._globeProjMatrixInverted=t.bk(),t.aB(this._globeProjMatrixInverted,i),t.O(i,i,[0,0,-this.cameraToCenterDistance]),t.bg(i,i,this.rollInRadians),t.bh(i,i,-this.pitchInRadians),t.bg(i,i,this.bearingInRadians),t.O(i,i,[0,0,-e]);const o=t.bz();o[0]=e,o[1]=e,o[2]=e,t.bh(a,i,this.center.lat*Math.PI/180),t.bJ(a,a,-this.center.lng*Math.PI/180),t.Q(a,a,o),this._globeViewProjMatrixNoCorrection=a,t.bh(i,i,this.center.lat*Math.PI/180-this._globeLatitudeErrorCorrectionRadians),t.bJ(i,i,-this.center.lng*Math.PI/180),t.Q(i,i,o),this._globeViewProjMatrix32f=new Float32Array(i),this._globeViewProjMatrixNoCorrectionInverted=t.bk(),t.aB(this._globeViewProjMatrixNoCorrectionInverted,a);const s=t.bz();this._cameraPosition=t.bz(),this._cameraPosition[2]=this.cameraToCenterDistance/e,t.bG(this._cameraPosition,this._cameraPosition,s,-this.rollInRadians),t.bH(this._cameraPosition,this._cameraPosition,s,this.pitchInRadians),t.bG(this._cameraPosition,this._cameraPosition,s,-this.bearingInRadians),t.b0(this._cameraPosition,this._cameraPosition,[0,0,1]),t.bH(this._cameraPosition,this._cameraPosition,s,-this.center.lat*Math.PI/180),t.bI(this._cameraPosition,this._cameraPosition,s,this.center.lng*Math.PI/180),this._cachedClippingPlane=this._computeClippingPlane(e);const n=t.bf(this._globeViewProjMatrixNoCorrectionInverted);t.Q(n,n,[1,1,-1]),this._cachedFrustum=Wt.fromInvProjectionMatrix(n,1,0,this._cachedClippingPlane,!0);}calculateFogMatrix(e){t.w("calculateFogMatrix is not supported on globe projection.");const i=t.bk();return t.ar(i),i}getVisibleUnwrappedCoordinates(e){return [new t.bc(0,e)]}getCameraFrustum(){return this._cachedFrustum}getClippingPlane(){return this._cachedClippingPlane}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(e){e&&t.w("terrain is not fully supported on vertical perspective projection."),this._helper.recalculateZoomAndCenter(0);}maxPitchScaleFactor(){return 1}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(e,i){if(!this._globeViewProjMatrixNoCorrection)return 1;const a=mi(e);t.a$(a,a,1+i/t.bE);const r=t.bF();return t.aH(r,[a[0],a[1],a[2],1],this._globeViewProjMatrixNoCorrection),r[2]/r[3]}populateCache(e){}getBounds(){const e=.5*this.width,i=.5*this.height,a=[new t.P(0,0),new t.P(e,0),new t.P(this.width,0),new t.P(this.width,i),new t.P(this.width,this.height),new t.P(e,this.height),new t.P(0,this.height),new t.P(0,i)],r=[];for(const e of a)r.push(this.unprojectScreenPoint(e));let o=0,s=0,n=0,l=0;const c=this.center;for(const e of r){const i=t.bK(c.lng,e.lng),a=t.bK(c.lat,e.lat);i<s&&(s=i),i>o&&(o=i),a<l&&(l=a),a>n&&(n=a);}const h=[c.lng+s,c.lat+l,c.lng+o,c.lat+n];return this.isSurfacePointOnScreen([0,1,0])&&(h[3]=90,h[0]=-180,h[2]=180),this.isSurfacePointOnScreen([0,-1,0])&&(h[1]=-90,h[0]=-180,h[2]=180),new $(h)}calculateCenterFromCameraLngLatAlt(e,t,i,a){return this._helper.calculateCenterFromCameraLngLatAlt(e,t,i,a)}setLocationAtPoint(e,i){const a=mi(this.unprojectScreenPoint(i)),r=mi(e),o=t.bz();t.bL(o);const s=t.bz();t.bI(s,a,o,-this.center.lng*Math.PI/180),t.bH(s,s,o,this.center.lat*Math.PI/180);const n=r[0]*r[0]+r[2]*r[2],l=s[0]*s[0];if(n<l)return;const c=Math.sqrt(n-l),h=-c,u=t.bM(r[0],r[2],s[0],c),d=t.bM(r[0],r[2],s[0],h),_=t.bz();t.bI(_,r,o,-u);const p=t.bM(_[1],_[2],s[1],s[2]),m=t.bz();t.bI(m,r,o,-d);const f=t.bM(m[1],m[2],s[1],s[2]),g=.5*Math.PI,v=p>=-g&&p<=g,x=f>=-g&&f<=g;let b,y;if(v&&x){const e=this.center.lng*Math.PI/180,i=this.center.lat*Math.PI/180;t.bN(u,e)+t.bN(p,i)<t.bN(d,e)+t.bN(f,i)?(b=u,y=p):(b=d,y=f);}else if(v)b=u,y=p;else {if(!x)return;b=d,y=f;}const w=b/Math.PI*180,T=y/Math.PI*180,P=this.center.lat;this.setCenter(new t.V(w,t.an(T,-90,90))),this.setZoom(this.zoom+xi(P,this.center.lat));}locationToScreenPoint(e,i){const a=mi(e);if(i){const r=i.getElevationForLngLatZoom(e,this._helper._tileZoom);t.a$(a,a,1+r/t.bE);}return this._projectSurfacePointToScreen(a)}_projectSurfacePointToScreen(e){const i=t.bF();return t.aH(i,[...e,1],this._globeViewProjMatrixNoCorrection),i[0]/=i[3],i[1]/=i[3],new t.P((.5*i[0]+.5)*this.width,(.5*-i[1]+.5)*this.height)}screenPointToMercatorCoordinate(e,i){if(i){const t=i.pointCoordinate(e);if(t)return t}return t.a9.fromLngLat(this.unprojectScreenPoint(e))}screenPointToLocation(e,t){var i;return null===(i=this.screenPointToMercatorCoordinate(e,t))||void 0===i?void 0:i.toLngLat()}isPointOnMapSurface(e,t){const i=this._cameraPosition,a=this.getRayDirectionFromPixel(e);return !!this.rayPlanetIntersection(i,a)}getRayDirectionFromPixel(e){const i=t.bF();i[0]=e.x/this.width*2-1,i[1]=-1*(e.y/this.height*2-1),i[2]=1,i[3]=1,t.aH(i,i,this._globeViewProjMatrixNoCorrectionInverted),i[0]/=i[3],i[1]/=i[3],i[2]/=i[3];const a=t.bz();a[0]=i[0]-this._cameraPosition[0],a[1]=i[1]-this._cameraPosition[1],a[2]=i[2]-this._cameraPosition[2];const r=t.bz();return t.b3(r,a),r}isSurfacePointVisible(e){const t=this._cachedClippingPlane;return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]>=0}isSurfacePointOnScreen(e){if(!this.isSurfacePointVisible(e))return !1;const i=t.bF();return t.aH(i,[...e,1],this._globeViewProjMatrixNoCorrection),i[0]/=i[3],i[1]/=i[3],i[2]/=i[3],i[0]>-1&&i[0]<1&&i[1]>-1&&i[1]<1&&i[2]>-1&&i[2]<1}rayPlanetIntersection(e,i){const a=t.b5(e,i),r=t.bz(),o=t.bz();t.a$(o,i,a),t.b2(r,e,o);const s=1-t.b5(r,r);if(s<0)return null;const n=t.b5(e,e)-1,l=-a+(a<0?1:-1)*Math.sqrt(s),c=n/l,h=l;return {tMin:Math.min(c,h),tMax:Math.max(c,h)}}unprojectScreenPoint(e){const i=this._cameraPosition,a=this.getRayDirectionFromPixel(e),r=this.rayPlanetIntersection(i,a);if(r){const e=t.bz();t.b0(e,i,[a[0]*r.tMin,a[1]*r.tMin,a[2]*r.tMin]);const o=t.bz();return t.b3(o,e),gi(o)}const o=this._cachedClippingPlane,s=o[0]*a[0]+o[1]*a[1]+o[2]*a[2],n=-t.bb(o,i)/s,l=t.bz();if(n>0)t.b0(l,i,[a[0]*n,a[1]*n,a[2]*n]);else {const e=t.bz();t.b0(e,i,[2*a[0],2*a[1],2*a[2]]);const r=t.bb(this._cachedClippingPlane,e);t.b2(l,e,[this._cachedClippingPlane[0]*r,this._cachedClippingPlane[1]*r,this._cachedClippingPlane[2]*r]);}const c=function(e){const i=t.bz();return i[0]=e[0]*-e[3],i[1]=e[1]*-e[3],i[2]=e[2]*-e[3],{center:i,radius:Math.sqrt(1-e[3]*e[3])}}(o);return gi(function(e,i,a){const r=t.bz();t.b2(r,a,e);const o=t.bz();return t.bA(o,e,r,i/t.b9(r)),o}(c.center,c.radius,l))}getMatrixForModel(e,i){const a=t.V.convert(e),r=1/t.bE,o=t.bj();return t.bJ(o,o,a.lng/180*Math.PI),t.bh(o,o,-a.lat/180*Math.PI),t.O(o,o,[0,0,1+i/t.bE]),t.bh(o,o,.5*Math.PI),t.Q(o,o,[r,r,r]),o}getProjectionDataForCustomLayer(e=!0){const i=this.getProjectionData({overscaledTileID:new t.a2(0,0,0,0,0),applyGlobeMatrix:e});return i.tileMercatorCoords=[0,0,1,1],i}getFastPathSimpleProjectionMatrix(e){}}class zi{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(e){this._helper.setMinZoom(e);}setMaxZoom(e){this._helper.setMaxZoom(e);}setMinPitch(e){this._helper.setMinPitch(e);}setMaxPitch(e){this._helper.setMaxPitch(e);}setRenderWorldCopies(e){this._helper.setRenderWorldCopies(e);}setBearing(e){this._helper.setBearing(e);}setPitch(e){this._helper.setPitch(e);}setRoll(e){this._helper.setRoll(e);}setFov(e){this._helper.setFov(e);}setZoom(e){this._helper.setZoom(e);}setCenter(e){this._helper.setCenter(e);}setElevation(e){this._helper.setElevation(e);}setMinElevationForCurrentTile(e){this._helper.setMinElevationForCurrentTile(e);}setPadding(e){this._helper.setPadding(e);}interpolatePadding(e,t,i){return this._helper.interpolatePadding(e,t,i)}isPaddingEqual(e){return this._helper.isPaddingEqual(e)}resize(e,t,i=!0){this._helper.resize(e,t,i);}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(e){this._helper.setMaxBounds(e);}setConstrainOverride(e){this._helper.setConstrainOverride(e);}overrideNearFarZ(e,t){this._helper.overrideNearFarZ(e,t);}clearNearFarZOverride(){this._helper.clearNearFarZOverride();}getCameraQueryGeometry(e){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),e)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get constrainOverride(){return this._helper.constrainOverride}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}get isGlobeRendering(){return this._globeness>0}setTransitionState(e,t){this._globeness=e,this._globeLatitudeErrorCorrectionRadians=t,this._calcMatrices(),this._verticalPerspectiveTransform.getCoveringTilesDetailsProvider().prepareNextFrame(),this._mercatorTransform.getCoveringTilesDetailsProvider().prepareNextFrame();}get currentTransform(){return this.isGlobeRendering?this._verticalPerspectiveTransform:this._mercatorTransform}constructor(e){this._globeLatitudeErrorCorrectionRadians=0,this._globeness=1,this.defaultConstrain=(e,t)=>this.currentTransform.defaultConstrain(e,t),this.applyConstrain=(e,t)=>this._helper.applyConstrain(e,t),this._helper=new Ut({calcMatrices:()=>{this._calcMatrices();},defaultConstrain:(e,t)=>this.defaultConstrain(e,t)},e),this._globeness=1,this._mercatorTransform=new $t,this._verticalPerspectiveTransform=new Si;}clone(){const e=new zi;return e._globeness=this._globeness,e._globeLatitudeErrorCorrectionRadians=this._globeLatitudeErrorCorrectionRadians,e.apply(this,!1),e}apply(e,t){this._helper.apply(e,t),this._mercatorTransform.apply(this,!1),this._verticalPerspectiveTransform.apply(this,!1,this._globeLatitudeErrorCorrectionRadians);}get projectionMatrix(){return this.currentTransform.projectionMatrix}get modelViewProjectionMatrix(){return this.currentTransform.modelViewProjectionMatrix}get inverseProjectionMatrix(){return this.currentTransform.inverseProjectionMatrix}get cameraPosition(){return this.currentTransform.cameraPosition}getProjectionData(e){const t=this._mercatorTransform.getProjectionData(e),i=this._verticalPerspectiveTransform.getProjectionData(e);return {mainMatrix:this.isGlobeRendering?i.mainMatrix:t.mainMatrix,clippingPlane:i.clippingPlane,tileMercatorCoords:i.tileMercatorCoords,projectionTransition:e.applyGlobeMatrix?this._globeness:0,fallbackMatrix:t.fallbackMatrix}}isLocationOccluded(e){return this.currentTransform.isLocationOccluded(e)}transformLightDirection(e){return this.currentTransform.transformLightDirection(e)}getPixelScale(){return t.bu(this._mercatorTransform.getPixelScale(),this._verticalPerspectiveTransform.getPixelScale(),this._globeness)}getCircleRadiusCorrection(){return t.bu(this._mercatorTransform.getCircleRadiusCorrection(),this._verticalPerspectiveTransform.getCircleRadiusCorrection(),this._globeness)}getPitchedTextCorrection(e,i,a){const r=this._mercatorTransform.getPitchedTextCorrection(e,i,a),o=this._verticalPerspectiveTransform.getPitchedTextCorrection(e,i,a);return t.bu(r,o,this._globeness)}projectTileCoordinates(e,t,i,a){return this.currentTransform.projectTileCoordinates(e,t,i,a)}_calcMatrices(){this._helper._width&&this._helper._height&&(this._verticalPerspectiveTransform.apply(this,!1,this._globeLatitudeErrorCorrectionRadians),this._helper._nearZ=this._verticalPerspectiveTransform.nearZ,this._helper._farZ=this._verticalPerspectiveTransform.farZ,this._mercatorTransform.apply(this,!0,this.isGlobeRendering),this._helper._nearZ=this._mercatorTransform.nearZ,this._helper._farZ=this._mercatorTransform.farZ);}calculateFogMatrix(e){return this.currentTransform.calculateFogMatrix(e)}getVisibleUnwrappedCoordinates(e){return this.currentTransform.getVisibleUnwrappedCoordinates(e)}getCameraFrustum(){return this.currentTransform.getCameraFrustum()}getClippingPlane(){return this.currentTransform.getClippingPlane()}getCoveringTilesDetailsProvider(){return this.currentTransform.getCoveringTilesDetailsProvider()}recalculateZoomAndCenter(e){this._mercatorTransform.recalculateZoomAndCenter(e),this._verticalPerspectiveTransform.recalculateZoomAndCenter(e);}maxPitchScaleFactor(){return this._mercatorTransform.maxPitchScaleFactor()}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(e,t){return this.currentTransform.lngLatToCameraDepth(e,t)}populateCache(e){this._mercatorTransform.populateCache(e),this._verticalPerspectiveTransform.populateCache(e);}getBounds(){return this.currentTransform.getBounds()}calculateCenterFromCameraLngLatAlt(e,t,i,a){return this._helper.calculateCenterFromCameraLngLatAlt(e,t,i,a)}setLocationAtPoint(e,t){if(!this.isGlobeRendering)return this._mercatorTransform.setLocationAtPoint(e,t),void this.apply(this._mercatorTransform,!1);this._verticalPerspectiveTransform.setLocationAtPoint(e,t),this.apply(this._verticalPerspectiveTransform,!1);}locationToScreenPoint(e,t){return this.currentTransform.locationToScreenPoint(e,t)}screenPointToMercatorCoordinate(e,t){return this.currentTransform.screenPointToMercatorCoordinate(e,t)}screenPointToLocation(e,t){return this.currentTransform.screenPointToLocation(e,t)}isPointOnMapSurface(e,t){return this.currentTransform.isPointOnMapSurface(e,t)}getRayDirectionFromPixel(e){return this._verticalPerspectiveTransform.getRayDirectionFromPixel(e)}getMatrixForModel(e,t){return this.currentTransform.getMatrixForModel(e,t)}getProjectionDataForCustomLayer(e=!0){const t=this._mercatorTransform.getProjectionDataForCustomLayer(e);if(!this.isGlobeRendering)return t;const i=this._verticalPerspectiveTransform.getProjectionDataForCustomLayer(e);return i.fallbackMatrix=t.mainMatrix,i}getFastPathSimpleProjectionMatrix(e){return this.currentTransform.getFastPathSimpleProjectionMatrix(e)}}class Ri{get useGlobeControls(){return !0}handlePanInertia(e,i){const a=bi(e,i);return Math.abs(a.lng-i.center.lng)>180&&(a.lng=i.center.lng+179.5*Math.sign(a.lng-i.center.lng)),{easingCenter:a,easingOffset:new t.P(0,0)}}handleMapControlsRollPitchBearingZoom(e,i){const a=e.around,r=i.screenPointToLocation(a);e.bearingDelta&&i.setBearing(i.bearing+e.bearingDelta),e.pitchDelta&&i.setPitch(i.pitch+e.pitchDelta),e.rollDelta&&i.setRoll(i.roll+e.rollDelta);const o=i.zoom;e.zoomDelta&&i.setZoom(i.zoom+e.zoomDelta);const s=i.zoom-o;if(0===s)return;const n=t.bK(i.center.lng,r.lng),l=n/(Math.abs(n/180)+1),c=t.bK(i.center.lat,r.lat),h=i.getRayDirectionFromPixel(a),u=i.cameraPosition,d=-1*t.b5(u,h),_=t.bz();t.b0(_,u,[h[0]*d,h[1]*d,h[2]*d]);const p=t.b7(_)-1,m=Math.exp(.5*-Math.max(p-.3,0)),f=fi(i.worldSize,i.center.lat)/Math.min(i.width,i.height),g=t.bx(f,.9,.5,1,.25),v=(1-t.aq(-s))*Math.min(m,g),x=i.center.lat,b=i.zoom,y=new t.V(i.center.lng+l*v,t.an(i.center.lat+c*v,-t.ao,t.ao));i.setLocationAtPoint(r,a);const w=i.center,T=t.bx(Math.abs(n),45,85,0,1),P=t.bx(f,.75,.35,0,1),C=Math.pow(Math.max(T,P),.25),I=t.bK(w.lng,y.lng),M=t.bK(w.lat,y.lat);i.setCenter(new t.V(w.lng+I*C,w.lat+M*C).wrap()),i.setZoom(b+xi(x,i.center.lat));}handleMapControlsPan(e,t,i){if(!e.panDelta)return;const a=t.center.lat,r=t.zoom;t.setCenter(bi(e.panDelta,t).wrap()),t.setZoom(r+xi(a,t.center.lat));}cameraForBoxAndBearing(e,i,a,r,o){const s=Kt(e,i,a,r,o),n=i.left/o.width*2-1,l=(o.width-i.right)/o.width*2-1,c=i.top/o.height*-2+1,h=(o.height-i.bottom)/o.height*-2+1,u=t.bK(a.getWest(),a.getEast())<0,d=u?a.getEast():a.getWest(),_=u?a.getWest():a.getEast(),p=Math.max(a.getNorth(),a.getSouth()),m=Math.min(a.getNorth(),a.getSouth()),f=d+.5*t.bK(d,_),g=p+.5*t.bK(p,m),v=o.clone();v.setCenter(s.center),v.setBearing(s.bearing),v.setPitch(0),v.setRoll(0),v.setZoom(s.zoom);const x=v.modelViewProjectionMatrix,b=[mi(a.getNorthWest()),mi(a.getNorthEast()),mi(a.getSouthWest()),mi(a.getSouthEast()),mi(new t.V(_,g)),mi(new t.V(d,g)),mi(new t.V(f,p)),mi(new t.V(f,m))],y=mi(s.center);let w=Number.POSITIVE_INFINITY;for(const e of b)n<0&&(w=Ri.getLesserNonNegativeNonNull(w,Ri.solveVectorScale(e,y,x,"x",n))),l>0&&(w=Ri.getLesserNonNegativeNonNull(w,Ri.solveVectorScale(e,y,x,"x",l))),c>0&&(w=Ri.getLesserNonNegativeNonNull(w,Ri.solveVectorScale(e,y,x,"y",c))),h<0&&(w=Ri.getLesserNonNegativeNonNull(w,Ri.solveVectorScale(e,y,x,"y",h)));if(Number.isFinite(w)&&0!==w)return s.zoom=v.zoom+t.at(w),s;Ht();}handleJumpToCenterZoom(e,i){const a=e.center.lat,r=e.applyConstrain(i.center?t.V.convert(i.center):e.center,e.zoom).center;e.setCenter(r.wrap());const o=void 0!==i.zoom?+i.zoom:e.zoom+xi(a,r.lat);e.zoom!==o&&e.setZoom(o);}handleEaseTo(e,i){const a=e.zoom,r=e.center,o=e.padding,s={roll:e.roll,pitch:e.pitch,bearing:e.bearing},n={roll:void 0===i.roll?e.roll:i.roll,pitch:void 0===i.pitch?e.pitch:i.pitch,bearing:void 0===i.bearing?e.bearing:i.bearing},l=void 0!==i.zoom,c=!e.isPaddingEqual(i.padding);let h=!1;const u=i.center?t.V.convert(i.center):r,d=e.applyConstrain(u,a).center;Zt(e,d);const _=e.clone();_.setCenter(d),_.setZoom(l?+i.zoom:a+xi(r.lat,u.lat)),_.setBearing(i.bearing);const p=new t.P(t.an(e.centerPoint.x+i.offsetAsPoint.x,0,e.width),t.an(e.centerPoint.y+i.offsetAsPoint.y,0,e.height));_.setLocationAtPoint(d,p);const m=(i.offset&&i.offsetAsPoint.mag())>0?_.center:d,f=l?+i.zoom:a+xi(r.lat,m.lat),g=a+xi(r.lat,0),v=f+xi(m.lat,0),x=t.bK(r.lng,m.lng),b=t.bK(r.lat,m.lat),y=t.aq(v-g);return h=f!==a,{easeFunc:a=>{if(t.bo(s,n)||Xt({startEulerAngles:s,endEulerAngles:n,tr:e,k:a,useSlerp:s.roll!=n.roll}),c&&e.interpolatePadding(o,i.padding,a),i.around)t.w("Easing around a point is not supported under globe projection."),e.setLocationAtPoint(i.around,i.aroundPoint);else {const t=v>g?Math.min(2,y):Math.max(.5,y),i=Math.pow(t,1-a),o=wi(r,x,b,a*i);e.setCenter(o.wrap());}if(h){const i=t.G.number(g,v,a)+xi(0,e.center.lat);e.setZoom(i);}},isZooming:h,elevationCenter:m}}handleFlyTo(e,i){const a=void 0!==i.zoom,r=e.center,o=e.zoom,s=e.padding,n=!e.isPaddingEqual(i.padding),l=e.applyConstrain(t.V.convert(i.center||i.locationAtOffset),o).center,c=a?+i.zoom:e.zoom+xi(e.center.lat,l.lat),h=e.clone();h.setCenter(l),h.setZoom(c),h.setBearing(i.bearing);const u=new t.P(t.an(e.centerPoint.x+i.offsetAsPoint.x,0,e.width),t.an(e.centerPoint.y+i.offsetAsPoint.y,0,e.height));h.setLocationAtPoint(l,u);const d=h.center;Zt(e,d);const _=function(e,i,a){const r=mi(i),o=mi(a),s=t.b5(r,o),n=Math.acos(s),l=_i(e);return n/(2*Math.PI)*l}(e,r,d),p=o+xi(r.lat,0),m=c+xi(d.lat,0),f=t.aq(m-p);let g;if("number"==typeof i.minZoom){const a=+i.minZoom+xi(d.lat,0),r=Math.min(a,p,m)+xi(0,d.lat),o=e.applyConstrain(d,r).zoom+xi(d.lat,0);g=t.aq(o-p);}const v=t.bK(r.lng,d.lng),x=t.bK(r.lat,d.lat);return {easeFunc:(a,o,l,h)=>{const u=wi(r,v,x,l);n&&e.interpolatePadding(s,i.padding,a);const _=1===a?d:u;e.setCenter(_.wrap());const m=p+t.at(o);e.setZoom(1===a?c:m+xi(0,_.lat));},scaleOfZoom:f,targetCenter:d,scaleOfMinZoom:g,pixelPathLength:_}}static solveVectorScale(e,t,i,a,r){const o="x"===a?[i[0],i[4],i[8],i[12]]:[i[1],i[5],i[9],i[13]],s=[i[3],i[7],i[11],i[15]],n=e[0]*o[0]+e[1]*o[1]+e[2]*o[2],l=e[0]*s[0]+e[1]*s[1]+e[2]*s[2],c=t[0]*o[0]+t[1]*o[1]+t[2]*o[2],h=t[0]*s[0]+t[1]*s[1]+t[2]*s[2];return c+r*l===n+r*h||s[3]*(n-c)+o[3]*(h-l)+n*h==c*l?null:(c+o[3]-r*h-r*s[3])/(c-n-r*h+r*l)}static getLesserNonNegativeNonNull(e,t){return null!==t&&t>=0&&t<e?t:e}}class Di{constructor(e){this._globe=e,this._mercatorCameraHelper=new Yt,this._verticalPerspectiveCameraHelper=new Ri;}get useGlobeControls(){return this._globe.useGlobeRendering}get currentHelper(){return this.useGlobeControls?this._verticalPerspectiveCameraHelper:this._mercatorCameraHelper}handlePanInertia(e,t){return this.currentHelper.handlePanInertia(e,t)}handleMapControlsRollPitchBearingZoom(e,t){return this.currentHelper.handleMapControlsRollPitchBearingZoom(e,t)}handleMapControlsPan(e,t,i){this.currentHelper.handleMapControlsPan(e,t,i);}cameraForBoxAndBearing(e,t,i,a,r){return this.currentHelper.cameraForBoxAndBearing(e,t,i,a,r)}handleJumpToCenterZoom(e,t){this.currentHelper.handleJumpToCenterZoom(e,t);}handleEaseTo(e,t){return this.currentHelper.handleEaseTo(e,t)}handleFlyTo(e,t){return this.currentHelper.handleFlyTo(e,t)}}const Ai=(e,i)=>t.B(e,i&&i.filter((e=>"source.canvas"!==e.identifier))),Li=t.bO();class ki extends t.E{constructor(e,i={}){var a,r;super(),this._rtlPluginLoaded=()=>{for(const e in this.tileManagers){const t=this.tileManagers[e].getSource().type;"vector"!==t&&"geojson"!==t||this.tileManagers[e].reload();}},this.map=e,this.dispatcher=new N(j(),e._getMapId()),this.dispatcher.registerMessageHandler("GG",((e,t)=>this.getGlyphs(e,t))),this.dispatcher.registerMessageHandler("GI",((e,t)=>this.getImages(e,t))),this.dispatcher.registerMessageHandler("GDA",((e,t)=>this.getDashes(e,t))),this.imageManager=new w,this.imageManager.setEventedParent(this);const o=(null===(a=e._container)||void 0===a?void 0:a.lang)||"undefined"!=typeof document&&(null===(r=document.documentElement)||void 0===r?void 0:r.lang)||void 0;this.glyphManager=new M(e._requestManager,i.localIdeographFontFamily,o),this.lineAtlas=new A(256,512),this.crossTileSymbolIndex=new Rt,this._setInitialValues(),this._resetUpdates(),this.dispatcher.broadcast("SR",t.bP()),ce().on(se,this._rtlPluginLoaded),this.on("data",(e=>{if("source"!==e.dataType||"metadata"!==e.sourceDataType)return;const t=this.tileManagers[e.sourceId];if(!t)return;const i=t.getSource();if(i&&i.vectorLayerIds)for(const e in this._layers){const t=this._layers[e];t.source===i.id&&this._validateLayer(t);}}));}_setInitialValues(){var e;this._spritesImagesIds={},this._layers={},this._order=[],this.tileManagers={},this.zoomHistory=new t.bQ,this._availableImages=[],this._globalState={},this._serializedLayers={},this.stylesheet=null,this.light=null,this.sky=null,this.projection&&(this.projection.destroy(),delete this.projection),this._loaded=!1,this._changed=!1,this._updatedLayers={},this._updatedSources={},this._changedImages={},this._glyphsDidChange=!1,this._updatedPaintProps={},this._layerOrderChanged=!1,this.crossTileSymbolIndex=new((null===(e=this.crossTileSymbolIndex)||void 0===e?void 0:e.constructor)||Object),this.pauseablePlacement=void 0,this.placement=void 0,this.z=0;}setGlobalStateProperty(e,i){var a,r,o;this._checkLoaded();const s=null===i?null!==(o=null===(r=null===(a=this.stylesheet.state)||void 0===a?void 0:a[e])||void 0===r?void 0:r.default)&&void 0!==o?o:null:i;if(t.bR(s,this._globalState[e]))return this;this._globalState[e]=s,this._applyGlobalStateChanges([e]);}getGlobalState(){return this._globalState}setGlobalState(e){this._checkLoaded();const i=[];for(const a in e)!t.bR(this._globalState[a],e[a].default)&&(i.push(a),this._globalState[a]=e[a].default);this._applyGlobalStateChanges(i);}_applyGlobalStateChanges(e){if(0===e.length)return;const t=new Set,i={};for(const a of e){i[a]=this._globalState[a];for(const e in this._layers){const i=this._layers[e],r=i.getLayoutAffectingGlobalStateRefs(),o=i.getPaintAffectingGlobalStateRefs(),s=i.getVisibilityAffectingGlobalStateRefs();if(r.has(a)&&t.add(i.source),o.has(a))for(const{name:e,value:t}of o.get(a))this._updatePaintProperty(i,e,t);(null==s?void 0:s.has(a))&&(i.recalculateVisibility(),this._updateLayer(i));}}this.dispatcher.broadcast("UGS",i);for(const e in this.tileManagers)t.has(e)&&(this._reloadSource(e),this._changed=!0);}loadURL(e,i={},a){this.fire(new t.l("dataloading",{dataType:"style"})),i.validate="boolean"!=typeof i.validate||i.validate;const r=this.map._requestManager.transformRequest(e,"Style");this._loadStyleRequest=new AbortController;const o=this._loadStyleRequest;t.j(r,this._loadStyleRequest).then((e=>{this._loadStyleRequest=null,this._load(e.data,i,a);})).catch((e=>{this._loadStyleRequest=null,e&&!o.signal.aborted&&this.fire(new t.k(e));}));}loadJSON(e,i={},a){this.fire(new t.l("dataloading",{dataType:"style"})),this._frameRequest=new AbortController,n.frameAsync(this._frameRequest).then((()=>{this._frameRequest=null,i.validate=!1!==i.validate,this._load(e,i,a);})).catch((()=>{}));}loadEmpty(){this.fire(new t.l("dataloading",{dataType:"style"})),this._load(Li,{validate:!1});}_load(e,i,a){var r,o;let s=i.transformStyle?i.transformStyle(a,e):e;if(!i.validate||!Ai(this,t.C(s))){s=Object.assign({},s),this._loaded=!0,this.stylesheet=s;for(const e in s.sources)this.addSource(e,s.sources[e],{validate:!1});s.sprite?this._loadSprite(s.sprite):this.imageManager.setLoaded(!0),this.glyphManager.setURL(s.glyphs),this._createLayers(),this.light=new z(this.stylesheet.light),this._setProjectionInternal((null===(r=this.stylesheet.projection)||void 0===r?void 0:r.type)||"mercator"),this.sky=new D(this.stylesheet.sky),this.map.setTerrain(null!==(o=this.stylesheet.terrain)&&void 0!==o?o:null),this.fire(new t.l("data",{dataType:"style"})),this.fire(new t.l("style.load"));}}_createLayers(){var e,i,a;const r=t.bS(this.stylesheet.layers);this.setGlobalState(null!==(e=this.stylesheet.state)&&void 0!==e?e:null),this.dispatcher.broadcast("SL",r),this._order=r.map((e=>e.id)),this._layers={},this._serializedLayers=null;for(const e of r){const r=t.bT(e,this._globalState);if(r.setEventedParent(this,{layer:{id:e.id}}),this._layers[e.id]=r,t.bU(r)&&this.tileManagers[r.source]){const t=null!==(a=null===(i=e.paint)||void 0===i?void 0:i["raster-fade-duration"])&&void 0!==a?a:r.paint.get("raster-fade-duration");this.tileManagers[r.source].setRasterFadeDuration(t);}}}_loadSprite(e,i=!1,a=void 0){this.imageManager.setLoaded(!1);const r=new AbortController;let o;this._spriteRequest=r,function(e,i,a,r){return t._(this,void 0,void 0,(function*(){const o=x(e),s=a>1?"@2x":"",l={},c={};for(const{id:e,url:a}of o){const o=i.transformRequest(b(a,s,".json"),"SpriteJSON");l[e]=t.j(o,r);const n=i.transformRequest(b(a,s,".png"),"SpriteImage");c[e]=g.getImage(n,r);}return yield Promise.all([...Object.values(l),...Object.values(c)]),function(e,i){return t._(this,void 0,void 0,(function*(){const t={};for(const a in e){t[a]={};const r=n.getImageCanvasContext((yield i[a]).data),o=(yield e[a]).data;for(const e in o){const{width:i,height:s,x:n,y:l,sdf:c,pixelRatio:h,stretchX:u,stretchY:d,content:_,textFitWidth:p,textFitHeight:m}=o[e];t[a][e]={data:null,pixelRatio:h,sdf:c,stretchX:u,stretchY:d,content:_,textFitWidth:p,textFitHeight:m,spriteData:{width:i,height:s,x:n,y:l,context:r}};}}return t}))}(l,c)}))}(e,this.map._requestManager,this.map.getPixelRatio(),this._spriteRequest).then((e=>{if(this._spriteRequest=null,e)for(const t in e){this._spritesImagesIds[t]=[];const a=this._spritesImagesIds[t]?this._spritesImagesIds[t].filter((t=>!(t in e))):[];for(const e of a)this.imageManager.removeImage(e),this._changedImages[e]=!0;for(const a in e[t]){const r="default"===t?a:`${t}:${a}`;this._spritesImagesIds[t].push(r),r in this.imageManager.images?this.imageManager.updateImage(r,e[t][a],!1):this.imageManager.addImage(r,e[t][a]),i&&(this._changedImages[r]=!0);}}})).catch((e=>{this._spriteRequest=null,o=e,r.signal.aborted||this.fire(new t.k(o));})).finally((()=>{this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),i&&(this._changed=!0),this.dispatcher.broadcast("SI",this._availableImages),this.fire(new t.l("data",{dataType:"style"})),a&&a(o);}));}_unloadSprite(){for(const e of Object.values(this._spritesImagesIds).flat())this.imageManager.removeImage(e),this._changedImages[e]=!0;this._spritesImagesIds={},this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new t.l("data",{dataType:"style"}));}_validateLayer(e){const i=this.tileManagers[e.source];if(!i)return;const a=e.sourceLayer;if(!a)return;const r=i.getSource();("geojson"===r.type||r.vectorLayerIds&&-1===r.vectorLayerIds.indexOf(a))&&this.fire(new t.k(new Error(`Source layer "${a}" does not exist on source "${r.id}" as specified by style layer "${e.id}".`)));}loaded(){if(!this._loaded)return !1;if(Object.keys(this._updatedSources).length)return !1;for(const e in this.tileManagers)if(!this.tileManagers[e].loaded())return !1;return !!this.imageManager.isLoaded()}_serializeByIds(e,i=!1){const a=this._serializedAllLayers();if(!e||0===e.length)return Object.values(i?t.bV(a):a);const r=[];for(const o of e)if(a[o]){const e=i?t.bV(a[o]):a[o];r.push(e);}return r}_serializedAllLayers(){let e=this._serializedLayers;if(e)return e;e=this._serializedLayers={};const t=Object.keys(this._layers);for(const i of t){const t=this._layers[i];"custom"!==t.type&&(e[i]=t.serialize());}return e}hasTransitions(){var e,t,i;if(null===(e=this.light)||void 0===e?void 0:e.hasTransition())return !0;if(null===(t=this.sky)||void 0===t?void 0:t.hasTransition())return !0;if(null===(i=this.projection)||void 0===i?void 0:i.hasTransition())return !0;for(const e in this.tileManagers)if(this.tileManagers[e].hasTransition())return !0;for(const e in this._layers)if(this._layers[e].hasTransition())return !0;return !1}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading.")}update(e){if(!this._loaded)return;const i=this._changed;if(i){const t=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(t.length||i.length)&&this._updateWorkerLayers(t,i);for(const e in this._updatedSources){const t=this._updatedSources[e];if("reload"===t)this._reloadSource(e);else {if("clear"!==t)throw new Error(`Invalid action ${t}`);this._clearSource(e);}}this._updateTilesForChangedImages(),this._updateTilesForChangedGlyphs();for(const t in this._updatedPaintProps)this._layers[t].updateTransitions(e);this.light.updateTransitions(e),this.sky.updateTransitions(e),this._resetUpdates();}const a={};for(const e in this.tileManagers){const t=this.tileManagers[e];a[e]=t.used,t.used=!1;}for(const t of this._order){const i=this._layers[t];i.recalculate(e,this._availableImages),!i.isHidden(e.zoom)&&i.source&&(this.tileManagers[i.source].used=!0);}for(const e in a){const i=this.tileManagers[e];!!a[e]!=!!i.used&&i.fire(new t.l("data",{sourceDataType:"visibility",dataType:"source",sourceId:e}));}this.light.recalculate(e),this.sky.recalculate(e),this.projection.recalculate(e),this.z=e.zoom,i&&this.fire(new t.l("data",{dataType:"style"}));}_updateTilesForChangedImages(){const e=Object.keys(this._changedImages);if(e.length){for(const t in this.tileManagers)this.tileManagers[t].reloadTilesForDependencies(["icons","patterns"],e);this._changedImages={};}}_updateTilesForChangedGlyphs(){if(this._glyphsDidChange){for(const e in this.tileManagers)this.tileManagers[e].reloadTilesForDependencies(["glyphs"],[""]);this._glyphsDidChange=!1;}}_updateWorkerLayers(e,t){this.dispatcher.broadcast("UL",{layers:this._serializeByIds(e,!1),removedIds:t});}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={},this._glyphsDidChange=!1;}setState(e,i={}){var a;this._checkLoaded();const r=this.serialize();if(e=i.transformStyle?i.transformStyle(r,e):e,(null===(a=i.validate)||void 0===a||a)&&Ai(this,t.C(e)))return !1;(e=t.bV(e)).layers=t.bS(e.layers);const o=t.bW(r,e),s=this._getOperationsToPerform(o);if(s.unimplemented.length>0)throw new Error(`Unimplemented: ${s.unimplemented.join(", ")}.`);if(0===s.operations.length)return !1;for(const e of s.operations)e();return this.stylesheet=e,this._serializedLayers=null,this.fire(new t.l("style.load",{style:this})),!0}_getOperationsToPerform(e){const t=[],i=[];for(const a of e)switch(a.command){case "setCenter":case "setZoom":case "setBearing":case "setPitch":case "setRoll":continue;case "addLayer":t.push((()=>this.addLayer.apply(this,a.args)));break;case "removeLayer":t.push((()=>this.removeLayer.apply(this,a.args)));break;case "setPaintProperty":t.push((()=>this.setPaintProperty.apply(this,a.args)));break;case "setLayoutProperty":t.push((()=>this.setLayoutProperty.apply(this,a.args)));break;case "setFilter":t.push((()=>this.setFilter.apply(this,a.args)));break;case "addSource":t.push((()=>this.addSource.apply(this,a.args)));break;case "removeSource":t.push((()=>this.removeSource.apply(this,a.args)));break;case "setLayerZoomRange":t.push((()=>this.setLayerZoomRange.apply(this,a.args)));break;case "setLight":t.push((()=>this.setLight.apply(this,a.args)));break;case "setGeoJSONSourceData":t.push((()=>this.setGeoJSONSourceData.apply(this,a.args)));break;case "setGlyphs":t.push((()=>this.setGlyphs.apply(this,a.args)));break;case "setSprite":t.push((()=>this.setSprite.apply(this,a.args)));break;case "setTerrain":t.push((()=>this.map.setTerrain.apply(this,a.args)));break;case "setSky":t.push((()=>this.setSky.apply(this,a.args)));break;case "setProjection":this.setProjection.apply(this,a.args);break;case "setGlobalState":t.push((()=>this.setGlobalState.apply(this,a.args)));break;case "setTransition":t.push((()=>{}));break;default:i.push(a.command);}return {operations:t,unimplemented:i}}addImage(e,i){if(this.getImage(e))return this.fire(new t.k(new Error(`An image named "${e}" already exists.`)));this.imageManager.addImage(e,i),this._afterImageUpdated(e);}updateImage(e,t){this.imageManager.updateImage(e,t);}getImage(e){return this.imageManager.getImage(e)}removeImage(e){if(!this.getImage(e))return this.fire(new t.k(new Error(`An image named "${e}" does not exist.`)));this.imageManager.removeImage(e),this._afterImageUpdated(e);}_afterImageUpdated(e){this._availableImages=this.imageManager.listImages(),this._changedImages[e]=!0,this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new t.l("data",{dataType:"style"}));}listImages(){return this._checkLoaded(),this.imageManager.listImages()}addSource(e,i,a={}){if(this._checkLoaded(),void 0!==this.tileManagers[e])throw new Error(`Source "${e}" already exists.`);if(!i.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(i).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(i.type)>=0&&this._validate(t.C.source,`sources.${e}`,i,null,a))return;this.map&&this.map._collectResourceTiming&&(i.collectResourceTiming=!0);const r=this.tileManagers[e]=new ke(e,i,this.dispatcher);r.style=this,r.setEventedParent(this,(()=>({isSourceLoaded:r.loaded(),source:r.serialize(),sourceId:e}))),r.onAdd(this.map),this._changed=!0;}removeSource(e){if(this._checkLoaded(),void 0===this.tileManagers[e])throw new Error("There is no source with this ID");for(const i in this._layers)if(this._layers[i].source===e)return this.fire(new t.k(new Error(`Source "${e}" cannot be removed while layer "${i}" is using it.`)));const i=this.tileManagers[e];delete this.tileManagers[e],delete this._updatedSources[e],i.fire(new t.l("data",{sourceDataType:"metadata",dataType:"source",sourceId:e})),i.setEventedParent(null),i.onRemove(this.map),this._changed=!0;}setGeoJSONSourceData(e,t){if(this._checkLoaded(),void 0===this.tileManagers[e])throw new Error(`There is no source with this ID=${e}`);const i=this.tileManagers[e].getSource();if("geojson"!==i.type)throw new Error(`geojsonSource.type is ${i.type}, which is !== 'geojson`);i.setData(t),this._changed=!0;}getSource(e){return this.tileManagers[e]&&this.tileManagers[e].getSource()}addLayer(e,i,a={}){this._checkLoaded();const r=e.id;if(this.getLayer(r))return void this.fire(new t.k(new Error(`Layer "${r}" already exists on this map.`)));let o;if("custom"===e.type){if(Ai(this,t.bX(e)))return;o=t.bT(e,this._globalState);}else {if("source"in e&&"object"==typeof e.source&&(this.addSource(r,e.source),e=t.bV(e),e=t.e(e,{source:r})),this._validate(t.C.layer,`layers.${r}`,e,{arrayIndex:-1},a))return;o=t.bT(e,this._globalState),this._validateLayer(o),o.setEventedParent(this,{layer:{id:r}});}const s=i?this._order.indexOf(i):this._order.length;if(i&&-1===s)this.fire(new t.k(new Error(`Cannot add layer "${r}" before non-existing layer "${i}".`)));else {if(this._order.splice(s,0,r),this._layerOrderChanged=!0,this._layers[r]=o,this._removedLayers[r]&&o.source&&"custom"!==o.type){const e=this._removedLayers[r];delete this._removedLayers[r],e.type!==o.type?this._updatedSources[o.source]="clear":(this._updatedSources[o.source]="reload",this.tileManagers[o.source].pause());}this._updateLayer(o),o.onAdd&&o.onAdd(this.map);}}moveLayer(e,i){if(this._checkLoaded(),this._changed=!0,!this._layers[e])return void this.fire(new t.k(new Error(`The layer '${e}' does not exist in the map's style and cannot be moved.`)));if(e===i)return;const a=this._order.indexOf(e);this._order.splice(a,1);const r=i?this._order.indexOf(i):this._order.length;i&&-1===r?this.fire(new t.k(new Error(`Cannot move layer "${e}" before non-existing layer "${i}".`))):(this._order.splice(r,0,e),this._layerOrderChanged=!0);}removeLayer(e){this._checkLoaded();const i=this._layers[e];if(!i)return void this.fire(new t.k(new Error(`Cannot remove non-existing layer "${e}".`)));i.setEventedParent(null);const a=this._order.indexOf(e);this._order.splice(a,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[e]=i,delete this._layers[e],this._serializedLayers&&delete this._serializedLayers[e],delete this._updatedLayers[e],delete this._updatedPaintProps[e],i.onRemove&&i.onRemove(this.map);}getLayer(e){return this._layers[e]}getLayersOrder(){return [...this._order]}hasLayer(e){return e in this._layers}setLayerZoomRange(e,i,a){this._checkLoaded();const r=this.getLayer(e);r?r.minzoom===i&&r.maxzoom===a||(null!=i&&(r.minzoom=i),null!=a&&(r.maxzoom=a),this._updateLayer(r)):this.fire(new t.k(new Error(`Cannot set the zoom range of non-existing layer "${e}".`)));}setFilter(e,i,a={}){this._checkLoaded();const r=this.getLayer(e);if(r){if(!t.bR(r.filter,i))return null==i?(r.setFilter(void 0),void this._updateLayer(r)):void(this._validate(t.C.filter,`layers.${r.id}.filter`,i,null,a)||(r.setFilter(t.bV(i)),this._updateLayer(r)))}else this.fire(new t.k(new Error(`Cannot filter non-existing layer "${e}".`)));}getFilter(e){return t.bV(this.getLayer(e).filter)}setLayoutProperty(e,i,a,r={}){this._checkLoaded();const o=this.getLayer(e);o?t.bR(o.getLayoutProperty(i),a)||(o.setLayoutProperty(i,a,r),this._updateLayer(o)):this.fire(new t.k(new Error(`Cannot style non-existing layer "${e}".`)));}getLayoutProperty(e,i){const a=this.getLayer(e);if(a)return a.getLayoutProperty(i);this.fire(new t.k(new Error(`Cannot get style of non-existing layer "${e}".`)));}setPaintProperty(e,i,a,r={}){this._checkLoaded();const o=this.getLayer(e);o?t.bR(o.getPaintProperty(i),a)||this._updatePaintProperty(o,i,a,r):this.fire(new t.k(new Error(`Cannot style non-existing layer "${e}".`)));}_updatePaintProperty(e,i,a,r={}){e.setPaintProperty(i,a,r)&&this._updateLayer(e),t.bU(e)&&"raster-fade-duration"===i&&this.tileManagers[e.source].setRasterFadeDuration(a),this._changed=!0,this._updatedPaintProps[e.id]=!0,this._serializedLayers=null;}getPaintProperty(e,t){return this.getLayer(e).getPaintProperty(t)}setFeatureState(e,i){this._checkLoaded();const a=e.source,r=e.sourceLayer,o=this.tileManagers[a];if(void 0===o)return void this.fire(new t.k(new Error(`The source '${a}' does not exist in the map's style.`)));const s=o.getSource().type;"geojson"===s&&r?this.fire(new t.k(new Error("GeoJSON sources cannot have a sourceLayer parameter."))):"vector"!==s||r?(void 0===e.id&&this.fire(new t.k(new Error("The feature id parameter must be provided."))),o.setFeatureState(r,e.id,i)):this.fire(new t.k(new Error("The sourceLayer parameter must be provided for vector source types.")));}removeFeatureState(e,i){this._checkLoaded();const a=e.source,r=this.tileManagers[a];if(void 0===r)return void this.fire(new t.k(new Error(`The source '${a}' does not exist in the map's style.`)));const o=r.getSource().type,s="vector"===o?e.sourceLayer:void 0;"vector"!==o||s?i&&"string"!=typeof e.id&&"number"!=typeof e.id?this.fire(new t.k(new Error("A feature id is required to remove its specific state property."))):r.removeFeatureState(s,e.id,i):this.fire(new t.k(new Error("The sourceLayer parameter must be provided for vector source types.")));}getFeatureState(e){this._checkLoaded();const i=e.source,a=e.sourceLayer,r=this.tileManagers[i];if(void 0!==r)return "vector"!==r.getSource().type||a?(void 0===e.id&&this.fire(new t.k(new Error("The feature id parameter must be provided."))),r.getFeatureState(a,e.id)):void this.fire(new t.k(new Error("The sourceLayer parameter must be provided for vector source types.")));this.fire(new t.k(new Error(`The source '${i}' does not exist in the map's style.`)));}getTransition(){return t.e({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){if(!this._loaded)return;const e=t.bY(this.tileManagers,(e=>e.serialize())),i=this._serializeByIds(this._order,!0),a=this.map.getTerrain()||void 0,r=this.stylesheet;return t.bZ({version:r.version,name:r.name,metadata:r.metadata,light:r.light,sky:r.sky,center:r.center,zoom:r.zoom,bearing:r.bearing,pitch:r.pitch,sprite:r.sprite,glyphs:r.glyphs,transition:r.transition,projection:r.projection,sources:e,layers:i,terrain:a},(e=>void 0!==e))}_updateLayer(e){this._updatedLayers[e.id]=!0,e.source&&!this._updatedSources[e.source]&&"raster"!==this.tileManagers[e.source].getSource().type&&(this._updatedSources[e.source]="reload",this.tileManagers[e.source].pause()),this._serializedLayers=null,this._changed=!0;}_flattenAndSortRenderedFeatures(e){const t=e=>"fill-extrusion"===this._layers[e].type,i={},a=[];for(let r=this._order.length-1;r>=0;r--){const o=this._order[r];if(t(o)){i[o]=r;for(const t of e){const e=t[o];if(e)for(const t of e)a.push(t);}}}a.sort(((e,t)=>t.intersectionZ-e.intersectionZ));const r=[];for(let o=this._order.length-1;o>=0;o--){const s=this._order[o];if(t(s))for(let e=a.length-1;e>=0;e--){const t=a[e].feature;if(i[t.layer.id]<o)break;r.push(t),a.pop();}else for(const t of e){const e=t[s];if(e)for(const t of e)r.push(t.feature);}}return r}queryRenderedFeatures(e,i,a){i&&i.filter&&this._validate(t.C.filter,"queryRenderedFeatures.filter",i.filter,null,i);const r={};if(i&&i.layers){if(!(Array.isArray(i.layers)||i.layers instanceof Set))return this.fire(new t.k(new Error("parameters.layers must be an Array or a Set of strings"))),[];for(const e of i.layers){const i=this._layers[e];if(!i)return this.fire(new t.k(new Error(`The layer '${e}' does not exist in the map's style and cannot be queried for features.`))),[];r[i.source]=!0;}}const o=[];i.availableImages=this._availableImages;const s=this._serializedAllLayers(),n=i.layers instanceof Set?i.layers:Array.isArray(i.layers)?new Set(i.layers):null,l=Object.assign(Object.assign({},i),{layers:n,globalState:this._globalState});for(const t in this.tileManagers)i.layers&&!r[t]||o.push(U(this.tileManagers[t],this._layers,s,e,l,a,this.map.terrain?(e,t,i)=>this.map.terrain.getElevation(e,t,i):void 0));return this.placement&&o.push(function(e,t,i,a,r,o,s){const n={},l=o.queryRenderedSymbols(a),c=[];for(const e of Object.keys(l).map(Number))c.push(s[e]);c.sort(V);for(const i of c){const a=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],t,i.bucketIndex,i.sourceLayerIndex,{filterSpec:r.filter,globalState:r.globalState},r.layers,r.availableImages,e);for(const e in a){const t=n[e]=n[e]||[],r=a[e];r.sort(((e,t)=>{const a=i.featureSortOrder;if(a){const i=a.indexOf(e.featureIndex);return a.indexOf(t.featureIndex)-i}return t.featureIndex-e.featureIndex}));for(const e of r)t.push(e);}}return function(e,t,i){for(const a in e)for(const r of e[a])q(r,i[t[a].source]);return e}(n,e,i)}(this._layers,s,this.tileManagers,e,l,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(o)}querySourceFeatures(e,i){(null==i?void 0:i.filter)&&this._validate(t.C.filter,"querySourceFeatures.filter",i.filter,null,i);const a=this.tileManagers[e];return a?function(e,t){const i=e.getRenderableIds().map((t=>e.getTileByID(t))),a=[],r={};for(let e=0;e<i.length;e++){const o=i[e],s=o.tileID.canonical.key;r[s]||(r[s]=!0,o.querySourceFeatures(a,t));}return a}(a,i?Object.assign(Object.assign({},i),{globalState:this._globalState}):{globalState:this._globalState}):[]}getLight(){return this.light.getLight()}setLight(e,i={}){this._checkLoaded();const a=this.light.getLight();let r=!1;for(const i in e)if(!t.bR(e[i],a[i])){r=!0;break}if(!r)return;const o={now:c(),transition:t.e({duration:300,delay:0},this.stylesheet.transition)};this.light.setLight(e,i),this.light.updateTransitions(o);}getProjection(){var e;return null===(e=this.stylesheet)||void 0===e?void 0:e.projection}setProjection(e){if(this._checkLoaded(),this.projection){if(this.projection.name===e.type)return;this.projection.destroy(),delete this.projection;}this.stylesheet.projection=e,this._setProjectionInternal(e.type);}getSky(){var e;return null===(e=this.stylesheet)||void 0===e?void 0:e.sky}setSky(e,i={}){this._checkLoaded();const a=this.getSky();let r=!1;if(!e&&!a)return;if(e&&!a)r=!0;else if(!e&&a)r=!0;else for(const i in e)if(!t.bR(e[i],a[i])){r=!0;break}if(!r)return;const o={now:c(),transition:t.e({duration:300,delay:0},this.stylesheet.transition)};this.stylesheet.sky=e,this.sky.setSky(e,i),this.sky.updateTransitions(o);}_setProjectionInternal(e){const i=function(e,i){const a={constrainOverride:i};if(Array.isArray(e)){const t=new di({type:e});return {projection:t,transform:new zi(a),cameraHelper:new Di(t)}}switch(e){case "mercator":return {projection:new jt,transform:new $t(a),cameraHelper:new Yt};case "globe":{const e=new di({type:["interpolate",["linear"],["zoom"],11,"vertical-perspective",12,"mercator"]});return {projection:e,transform:new zi(a),cameraHelper:new Di(e)}}case "vertical-perspective":return {projection:new hi,transform:new Si(a),cameraHelper:new Ri};default:return t.w(`Unknown projection name: ${e}. Falling back to mercator projection.`),{projection:new jt,transform:new $t(a),cameraHelper:new Yt}}}(e,this.map.transformConstrain);this.projection=i.projection,this.map.migrateProjection(i.transform,i.cameraHelper);for(const e in this.tileManagers)this.tileManagers[e].reload();}_validate(e,i,a,r,o={}){return (!o||!1!==o.validate)&&Ai(this,e.call(t.C,t.e({key:i,style:this.serialize(),value:a,styleSpec:t.u},r)))}_remove(e=!0){this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._loadStyleRequest&&(this._loadStyleRequest.abort(),this._loadStyleRequest=null),this._spriteRequest&&(this._spriteRequest.abort(),this._spriteRequest=null),ce().off(se,this._rtlPluginLoaded);for(const e in this._layers)this._layers[e].setEventedParent(null);for(const e in this.tileManagers){const t=this.tileManagers[e];t.setEventedParent(null),t.onRemove(this.map);}this.imageManager.setEventedParent(null),this.setEventedParent(null),e&&this.dispatcher.broadcast("RM",void 0),this.dispatcher.remove(e);}_clearSource(e){this.tileManagers[e].clearTiles();}_reloadSource(e){this.tileManagers[e].resume(),this.tileManagers[e].reload();}_updateSources(e){for(const t in this.tileManagers)this.tileManagers[t].update(e,this.map.terrain);}_generateCollisionBoxes(){for(const e in this.tileManagers)this._reloadSource(e);}_updatePlacement(e,t,i,a,r=!1){let o=!1,s=!1;const n={};for(const t of this._order){const i=this._layers[t];if("symbol"!==i.type)continue;if(!n[i.source]){const e=this.tileManagers[i.source];n[i.source]=e.getRenderableIds(!0).map((t=>e.getTileByID(t))).sort(((e,t)=>t.tileID.overscaledZ-e.tileID.overscaledZ||(e.tileID.isLessThan(t.tileID)?-1:1)));}const a=this.crossTileSymbolIndex.addLayer(i,n[i.source],e.center.lng);o=o||a;}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),((r=r||this._layerOrderChanged||0===i)||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(c(),e.zoom))&&(this.pauseablePlacement=new It(e,this.map.terrain,this._order,r,t,i,a,this.placement),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,n),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(c()),s=!0),o&&this.pauseablePlacement.placement.setStale()),s||o)for(const e of this._order){const t=this._layers[e];"symbol"===t.type&&this.placement.updateLayerOpacities(t,n[t.source]);}return !this.pauseablePlacement.isDone()||this.placement.hasTransitions(c())}_releaseSymbolFadeTiles(){for(const e in this.tileManagers)this.tileManagers[e].releaseSymbolFadeTiles();}getImages(e,i){return t._(this,void 0,void 0,(function*(){const e=yield this.imageManager.getImages(i.icons);this._updateTilesForChangedImages();const t=this.tileManagers[i.source];return t&&t.setDependencies(i.tileID.key,i.type,i.icons),e}))}getGlyphs(e,i){return t._(this,void 0,void 0,(function*(){const e=yield this.glyphManager.getGlyphs(i.stacks),t=this.tileManagers[i.source];return t&&t.setDependencies(i.tileID.key,i.type,[""]),e}))}getGlyphsUrl(){return this.stylesheet.glyphs||null}setGlyphs(e,i={}){this._checkLoaded(),e&&this._validate(t.C.glyphs,"glyphs",e,null,i)||(this._glyphsDidChange=!0,this.stylesheet.glyphs=e,this.glyphManager.entries={},this.glyphManager.setURL(e));}getDashes(e,i){return t._(this,void 0,void 0,(function*(){const e={};for(const[t,a]of Object.entries(i.dashes))e[t]=this.lineAtlas.getDash(a.dasharray,a.round);return e}))}addSprite(e,i,a={},r){this._checkLoaded();const o=[{id:e,url:i}],s=[...x(this.stylesheet.sprite),...o];this._validate(t.C.sprite,"sprite",s,null,a)||(this.stylesheet.sprite=s,this._loadSprite(o,!0,r));}removeSprite(e){this._checkLoaded();const i=x(this.stylesheet.sprite);if(i.find((t=>t.id===e))){if(this._spritesImagesIds[e])for(const t of this._spritesImagesIds[e])this.imageManager.removeImage(t),this._changedImages[t]=!0;i.splice(i.findIndex((t=>t.id===e)),1),this.stylesheet.sprite=i.length>0?i:void 0,delete this._spritesImagesIds[e],this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new t.l("data",{dataType:"style"}));}else this.fire(new t.k(new Error(`Sprite "${e}" doesn't exists on this map.`)));}getSprite(){return x(this.stylesheet.sprite)}setSprite(e,i={},a){this._checkLoaded(),e&&this._validate(t.C.sprite,"sprite",e,null,i)||(this.stylesheet.sprite=e,e?this._loadSprite(e,!0,a):(this._unloadSprite(),a&&a(null)));}destroy(){this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._loadStyleRequest&&(this._loadStyleRequest.abort(),this._loadStyleRequest=null),this._spriteRequest&&(this._spriteRequest.abort(),this._spriteRequest=null);for(const e in this.tileManagers){const t=this.tileManagers[e];t.setEventedParent(null),t.onRemove(this.map);}this.tileManagers={},this.imageManager&&(this.imageManager.setEventedParent(null),this.imageManager.destroy(),this._availableImages=[],this._spritesImagesIds={}),this.glyphManager&&this.glyphManager.destroy();for(const e in this._layers){const t=this._layers[e];t.setEventedParent(null),t.onRemove&&t.onRemove(this.map);}this._setInitialValues(),this.setEventedParent(null),this.dispatcher.unregisterMessageHandler("GG"),this.dispatcher.unregisterMessageHandler("GI"),this.dispatcher.unregisterMessageHandler("GDA"),this.dispatcher.remove(!0),this._listeners={},this._oneTimeListeners={};}}var Fi=t.aU([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);class Bi{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffer=null,this.vao=null;}bind(e,t,i,a,r,o,s,n,l){this.context=e;let c=this.boundPaintVertexBuffers.length!==a.length;for(let e=0;!c&&e<a.length;e++)this.boundPaintVertexBuffers[e]!==a[e]&&(c=!0);!this.vao||this.boundProgram!==t||this.boundLayoutVertexBuffer!==i||c||this.boundIndexBuffer!==r||this.boundVertexOffset!==o||this.boundDynamicVertexBuffer!==s||this.boundDynamicVertexBuffer2!==n||this.boundDynamicVertexBuffer3!==l?this.freshBind(t,i,a,r,o,s,n,l):(e.bindVertexArray.set(this.vao),s&&s.bind(),r&&r.dynamicDraw&&r.bind(),n&&n.bind(),l&&l.bind());}freshBind(e,t,i,a,r,o,s,n){const l=e.numAttributes,c=this.context,h=c.gl;this.vao&&this.destroy(),this.vao=c.createVertexArray(),c.bindVertexArray.set(this.vao),this.boundProgram=e,this.boundLayoutVertexBuffer=t,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=a,this.boundVertexOffset=r,this.boundDynamicVertexBuffer=o,this.boundDynamicVertexBuffer2=s,this.boundDynamicVertexBuffer3=n,t.enableAttributes(h,e);for(const t of i)t.enableAttributes(h,e);o&&o.enableAttributes(h,e),s&&s.enableAttributes(h,e),n&&n.enableAttributes(h,e),t.bind(),t.setVertexAttribPointers(h,e,r);for(const t of i)t.bind(),t.setVertexAttribPointers(h,e,r);o&&(o.bind(),o.setVertexAttribPointers(h,e,r)),a&&a.bind(),s&&(s.bind(),s.setVertexAttribPointers(h,e,r)),n&&(n.bind(),n.setVertexAttribPointers(h,e,r)),c.currentNumAttributes=l;}destroy(){this.vao&&(this.context.deleteVertexArray(this.vao),this.vao=null);}}const Oi=(e,i,a,r,o)=>({u_texture:0,u_ele_delta:e,u_fog_matrix:i,u_fog_color:a?a.properties.get("fog-color"):t.bp.white,u_fog_ground_blend:a?a.properties.get("fog-ground-blend"):1,u_fog_ground_blend_opacity:o?0:a?a.calculateFogBlendOpacity(r):0,u_horizon_color:a?a.properties.get("horizon-color"):t.bp.white,u_horizon_fog_blend:a?a.properties.get("horizon-fog-blend"):1,u_is_globe_mode:o?1:0}),ji={mainMatrix:"u_projection_matrix",tileMercatorCoords:"u_projection_tile_mercator_coords",clippingPlane:"u_projection_clipping_plane",projectionTransition:"u_projection_transition",fallbackMatrix:"u_projection_fallback_matrix"};function Ni(e){const t=[];for(let i=0;i<e.length;i++){if(null===e[i])continue;const a=e[i].split(" ");t.push(a.pop());}return t}class Zi{constructor(e,i,a,r,o,s,n,l,c=[]){const h=e.gl;this.program=h.createProgram();const u=Ni(i.staticAttributes),d=a?a.getBinderAttributes():[],_=u.concat(d),p=At.prelude.staticUniforms?Ni(At.prelude.staticUniforms):[],m=n.staticUniforms?Ni(n.staticUniforms):[],f=i.staticUniforms?Ni(i.staticUniforms):[],g=a?a.getBinderUniforms():[],v=p.concat(m).concat(f).concat(g),x=[];for(const e of v)x.indexOf(e)<0&&x.push(e);const b=a?a.defines():[];oi(h)&&b.unshift("#version 300 es"),o&&b.push("#define OVERDRAW_INSPECTOR;"),s&&b.push("#define TERRAIN3D;"),l&&b.push(l),c&&b.push(...c);let y=b.concat(At.prelude.fragmentSource,n.fragmentSource,i.fragmentSource).join("\n"),w=b.concat(At.prelude.vertexSource,n.vertexSource,i.vertexSource).join("\n");oi(h)||(y=function(e){return e.replace(/\bin\s/g,"varying ").replace("out highp vec4 fragColor;","").replace(/fragColor/g,"gl_FragColor").replace(/texture\(/g,"texture2D(")}(y),w=function(e){return e.replace(/\bin\s/g,"attribute ").replace(/\bout\s/g,"varying ").replace(/texture\(/g,"texture2D(")}(w));const T=h.createShader(h.FRAGMENT_SHADER);if(h.isContextLost())return void(this.failedToCreate=!0);if(h.shaderSource(T,y),h.compileShader(T),!h.getShaderParameter(T,h.COMPILE_STATUS))throw new Error(`Could not compile fragment shader: ${h.getShaderInfoLog(T)}`);h.attachShader(this.program,T);const P=h.createShader(h.VERTEX_SHADER);if(h.isContextLost())return void(this.failedToCreate=!0);if(h.shaderSource(P,w),h.compileShader(P),!h.getShaderParameter(P,h.COMPILE_STATUS))throw new Error(`Could not compile vertex shader: ${h.getShaderInfoLog(P)}`);h.attachShader(this.program,P),this.attributes={};const C={};this.numAttributes=_.length;for(let e=0;e<this.numAttributes;e++)_[e]&&(h.bindAttribLocation(this.program,e,_[e]),this.attributes[_[e]]=e);if(h.linkProgram(this.program),!h.getProgramParameter(this.program,h.LINK_STATUS))throw new Error(`Program failed to link: ${h.getProgramInfoLog(this.program)}`);h.deleteShader(P),h.deleteShader(T);for(let e=0;e<x.length;e++){const t=x[e];if(t&&!C[t]){const e=h.getUniformLocation(this.program,t);e&&(C[t]=e);}}this.fixedUniforms=r(e,C),this.terrainUniforms=((e,i)=>({u_depth:new t.b_(e,i.u_depth),u_terrain:new t.b_(e,i.u_terrain),u_terrain_dim:new t.bq(e,i.u_terrain_dim),u_terrain_matrix:new t.c0(e,i.u_terrain_matrix),u_terrain_unpack:new t.c1(e,i.u_terrain_unpack),u_terrain_exaggeration:new t.bq(e,i.u_terrain_exaggeration)}))(e,C),this.projectionUniforms=((e,i)=>({u_projection_matrix:new t.c0(e,i.u_projection_matrix),u_projection_tile_mercator_coords:new t.c1(e,i.u_projection_tile_mercator_coords),u_projection_clipping_plane:new t.c1(e,i.u_projection_clipping_plane),u_projection_transition:new t.bq(e,i.u_projection_transition),u_projection_fallback_matrix:new t.c0(e,i.u_projection_fallback_matrix)}))(e,C),this.binderUniforms=a?a.getUniforms(e,C):[];}draw(e,t,i,a,r,o,s,n,l,c,h,u,d,_,p,m,f,g,v){const x=e.gl;if(this.failedToCreate)return;if(e.program.set(this.program),e.setDepthMode(i),e.setStencilMode(a),e.setColorMode(r),e.setCullFace(o),n){e.activeTexture.set(x.TEXTURE2),x.bindTexture(x.TEXTURE_2D,n.depthTexture),e.activeTexture.set(x.TEXTURE3),x.bindTexture(x.TEXTURE_2D,n.texture);for(const e in this.terrainUniforms)this.terrainUniforms[e].set(n[e]);}if(l)for(const e in l)this.projectionUniforms[ji[e]].set(l[e]);if(s)for(const e in this.fixedUniforms)this.fixedUniforms[e].set(s[e]);m&&m.setUniforms(e,this.binderUniforms,_,{zoom:p});let b=0;switch(t){case x.LINES:b=2;break;case x.TRIANGLES:b=3;break;case x.LINE_STRIP:b=1;}for(const i of d.get()){const a=i.vaos||(i.vaos={});(a[c]||(a[c]=new Bi)).bind(e,this,h,m?m.getPaintVertexBuffers():[],u,i.vertexOffset,f,g,v),x.drawElements(t,i.primitiveLength*b,x.UNSIGNED_SHORT,i.primitiveOffset*b*2);}}}function Gi(e,i,a){const r=1/t.aN(a,1,i.transform.tileZoom),o=Math.pow(2,a.tileID.overscaledZ),s=a.tileSize*Math.pow(2,i.transform.tileZoom)/o,n=s*(a.tileID.canonical.x+a.tileID.wrap*o),l=s*a.tileID.canonical.y;return {u_image:0,u_texsize:a.imageAtlasTexture.size,u_scale:[r,e.fromScale,e.toScale],u_fade:e.t,u_pixel_coord_upper:[n>>16,l>>16],u_pixel_coord_lower:[65535&n,65535&l]}}const Ui=(e,i,a,r)=>{const o=e.style.light,s=o.properties.get("position"),n=[s.x,s.y,s.z],l=t.c4();"viewport"===o.properties.get("anchor")&&t.c5(l,e.transform.bearingInRadians),t.c6(n,n,l);const c=e.transform.transformLightDirection(n),h=o.properties.get("color");return {u_lightpos:n,u_lightpos_globe:c,u_lightintensity:o.properties.get("intensity"),u_lightcolor:[h.r,h.g,h.b],u_vertical_gradient:+i,u_opacity:a,u_fill_translate:r}},Vi=(e,i,a,r,o,s,n)=>t.e(Ui(e,i,a,r),Gi(s,e,n),{u_height_factor:-Math.pow(2,o.overscaledZ)/n.tileSize/8}),qi=(e,i,a,r)=>t.e(Gi(i,e,a),{u_fill_translate:r}),Wi=(e,t)=>({u_world:e,u_fill_translate:t}),$i=(e,i,a,r,o)=>t.e(qi(e,i,a,o),{u_world:r}),Hi=(e,i,a,r,o)=>{const s=e.transform;let n,l,c=0;if("map"===a.paint.get("circle-pitch-alignment")){const e=t.aN(i,1,s.zoom);n=!0,l=[e,e],c=e/(t.a5*Math.pow(2,i.tileID.overscaledZ))*2*Math.PI*o;}else n=!1,l=s.pixelsToGLUnits;return {u_camera_to_center_distance:s.cameraToCenterDistance,u_scale_with_map:+("map"===a.paint.get("circle-pitch-scale")),u_pitch_with_map:+n,u_device_pixel_ratio:e.pixelRatio,u_extrude_scale:l,u_globe_extrude_scale:c,u_translate:r}},Xi=e=>({u_pixel_extrude_scale:[1/e.width,1/e.height]}),Ki=e=>({u_viewport_size:[e.width,e.height]}),Yi=(e,t=1)=>({u_color:e,u_overlay:0,u_overlay_scale:t}),Qi=(e,i,a,r)=>{const o=t.aN(e,1,i)/(t.a5*Math.pow(2,e.tileID.overscaledZ))*2*Math.PI*r;return {u_extrude_scale:t.aN(e,1,i),u_intensity:a,u_globe_extrude_scale:o}},Ji=(e,i,a,r)=>{const o=t.N();t.c7(o,0,e.width,e.height,0,0,1);const s=e.context.gl;return {u_matrix:o,u_world:[s.drawingBufferWidth,s.drawingBufferHeight],u_image:a,u_color_ramp:r,u_opacity:i.paint.get("heatmap-opacity")}},ea=(e,t,i)=>{const a=i.paint.get("hillshade-accent-color");let r;switch(i.paint.get("hillshade-method")){case "basic":r=4;break;case "combined":r=1;break;case "igor":r=2;break;case "multidirectional":r=3;break;default:r=0;}const o=i.getIlluminationProperties();for(let t=0;t<o.directionRadians.length;t++)"viewport"===i.paint.get("hillshade-illumination-anchor")&&(o.directionRadians[t]+=e.transform.bearingInRadians);return {u_image:0,u_latrange:ia(0,t.tileID),u_exaggeration:i.paint.get("hillshade-exaggeration"),u_altitudes:o.altitudeRadians,u_azimuths:o.directionRadians,u_accent:a,u_method:r,u_highlights:o.highlightColor,u_shadows:o.shadowColor}},ta=(e,i)=>{const a=i.stride,r=t.N();return t.c7(r,0,t.a5,-t.a5,0,0,1),t.O(r,r,[0,-t.a5,0]),{u_matrix:r,u_image:1,u_dimension:[a,a],u_zoom:e.overscaledZ,u_unpack:i.getUnpackVector()}};function ia(e,i){const a=Math.pow(2,i.canonical.z),r=i.canonical.y;return [new t.a9(0,r/a).toLngLat().lat,new t.a9(0,(r+1)/a).toLngLat().lat]}const aa=(e,t,i=0)=>({u_image:0,u_unpack:t.getUnpackVector(),u_dimension:[t.stride,t.stride],u_elevation_stops:1,u_color_stops:4,u_color_ramp_size:i,u_opacity:e.paint.get("color-relief-opacity")}),ra=(e,i,a,r)=>{const o=e.transform;return {u_translation:ha(e,i,a),u_ratio:r/t.aN(i,1,o.zoom),u_device_pixel_ratio:e.pixelRatio,u_units_to_pixels:[1/o.pixelsToGLUnits[0],1/o.pixelsToGLUnits[1]]}},oa=(e,i,a,r,o)=>t.e(ra(e,i,a,r),{u_image:0,u_image_height:o}),sa=(e,i,a,r,o)=>{const s=e.transform,n=ca(i,s);return {u_translation:ha(e,i,a),u_texsize:i.imageAtlasTexture.size,u_ratio:r/t.aN(i,1,s.zoom),u_device_pixel_ratio:e.pixelRatio,u_image:0,u_scale:[n,o.fromScale,o.toScale],u_fade:o.t,u_units_to_pixels:[1/s.pixelsToGLUnits[0],1/s.pixelsToGLUnits[1]]}},na=(e,i,a,r,o)=>{const s=ca(i,e.transform);return t.e(ra(e,i,a,r),{u_tileratio:s,u_crossfade_from:o.fromScale,u_crossfade_to:o.toScale,u_image:0,u_mix:o.t,u_lineatlas_width:e.lineAtlas.width,u_lineatlas_height:e.lineAtlas.height})},la=(e,i,a,r,o,s)=>{const n=ca(i,e.transform);return t.e(ra(e,i,a,r),{u_image:0,u_image_height:s,u_tileratio:n,u_crossfade_from:o.fromScale,u_crossfade_to:o.toScale,u_image_dash:1,u_mix:o.t,u_lineatlas_width:e.lineAtlas.width,u_lineatlas_height:e.lineAtlas.height})};function ca(e,i){return 1/t.aN(e,1,i.tileZoom)}function ha(e,i,a){return t.aO(e.transform,i,a.paint.get("line-translate"),a.paint.get("line-translate-anchor"))}const ua=(e,t,i,a,r)=>{return {u_tl_parent:e,u_scale_parent:t,u_buffer_scale:1,u_fade_t:i.mix,u_opacity:i.opacity*a.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:a.paint.get("raster-brightness-min"),u_brightness_high:a.paint.get("raster-brightness-max"),u_saturation_factor:(s=a.paint.get("raster-saturation"),s>0?1-1/(1.001-s):-s),u_contrast_factor:(o=a.paint.get("raster-contrast"),o>0?1/(1-o):1+o),u_spin_weights:da(a.paint.get("raster-hue-rotate")),u_coords_top:[r[0].x,r[0].y,r[1].x,r[1].y],u_coords_bottom:[r[3].x,r[3].y,r[2].x,r[2].y]};var o,s;};function da(e){e*=Math.PI/180;const t=Math.sin(e),i=Math.cos(e);return [(2*i+1)/3,(-Math.sqrt(3)*t-i+1)/3,(Math.sqrt(3)*t-i+1)/3]}const _a=(e,t,i,a,r,o,s,n,l,c,h,u,d)=>{const _=s.transform;return {u_is_size_zoom_constant:+("constant"===e||"source"===e),u_is_size_feature_constant:+("constant"===e||"camera"===e),u_size_t:t?t.uSizeT:0,u_size:t?t.uSize:0,u_camera_to_center_distance:_.cameraToCenterDistance,u_pitch:_.pitch/360*2*Math.PI,u_rotate_symbol:+i,u_aspect_ratio:_.width/_.height,u_fade_change:s.options.fadeDuration?s.symbolFadeChange:1,u_label_plane_matrix:n,u_coord_matrix:l,u_is_text:+h,u_pitch_with_map:+a,u_is_along_line:r,u_is_variable_anchor:o,u_texsize:u,u_texture:0,u_translation:c,u_pitched_scale:d}},pa=(e,i,a,r,o,s,n,l,c,h,u,d,_,p)=>{const m=n.transform;return t.e(_a(e,i,a,r,o,s,n,l,c,h,u,d,p),{u_gamma_scale:r?Math.cos(m.pitch*Math.PI/180)*m.cameraToCenterDistance:1,u_device_pixel_ratio:n.pixelRatio,u_is_halo:1})},ma=(e,i,a,r,o,s,n,l,c,h,u,d,_)=>t.e(pa(e,i,a,r,o,s,n,l,c,h,!0,u,0,_),{u_texsize_icon:d,u_texture_icon:1}),fa=(e,t)=>({u_opacity:e,u_color:t}),ga=(e,i,a,r,o)=>t.e(function(e,i,a,r){const o=a.imageManager.getPattern(e.from.toString()),s=a.imageManager.getPattern(e.to.toString()),{width:n,height:l}=a.imageManager.getPixelSize(),c=Math.pow(2,r.tileID.overscaledZ),h=r.tileSize*Math.pow(2,a.transform.tileZoom)/c,u=h*(r.tileID.canonical.x+r.tileID.wrap*c),d=h*r.tileID.canonical.y;return {u_image:0,u_pattern_tl_a:o.tl,u_pattern_br_a:o.br,u_pattern_tl_b:s.tl,u_pattern_br_b:s.br,u_texsize:[n,l],u_mix:i.t,u_pattern_size_a:o.displaySize,u_pattern_size_b:s.displaySize,u_scale_a:i.fromScale,u_scale_b:i.toScale,u_tile_units_to_pixels:1/t.aN(r,1,a.transform.tileZoom),u_pixel_coord_upper:[u>>16,d>>16],u_pixel_coord_lower:[65535&u,65535&d]}}(a,o,i,r),{u_opacity:e}),va=(e,t)=>{},xa={fillExtrusion:(e,i)=>({u_lightpos:new t.c2(e,i.u_lightpos),u_lightpos_globe:new t.c2(e,i.u_lightpos_globe),u_lightintensity:new t.bq(e,i.u_lightintensity),u_lightcolor:new t.c2(e,i.u_lightcolor),u_vertical_gradient:new t.bq(e,i.u_vertical_gradient),u_opacity:new t.bq(e,i.u_opacity),u_fill_translate:new t.c3(e,i.u_fill_translate)}),fillExtrusionPattern:(e,i)=>({u_lightpos:new t.c2(e,i.u_lightpos),u_lightpos_globe:new t.c2(e,i.u_lightpos_globe),u_lightintensity:new t.bq(e,i.u_lightintensity),u_lightcolor:new t.c2(e,i.u_lightcolor),u_vertical_gradient:new t.bq(e,i.u_vertical_gradient),u_height_factor:new t.bq(e,i.u_height_factor),u_opacity:new t.bq(e,i.u_opacity),u_fill_translate:new t.c3(e,i.u_fill_translate),u_image:new t.b_(e,i.u_image),u_texsize:new t.c3(e,i.u_texsize),u_pixel_coord_upper:new t.c3(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.c3(e,i.u_pixel_coord_lower),u_scale:new t.c2(e,i.u_scale),u_fade:new t.bq(e,i.u_fade)}),fill:(e,i)=>({u_fill_translate:new t.c3(e,i.u_fill_translate)}),fillPattern:(e,i)=>({u_image:new t.b_(e,i.u_image),u_texsize:new t.c3(e,i.u_texsize),u_pixel_coord_upper:new t.c3(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.c3(e,i.u_pixel_coord_lower),u_scale:new t.c2(e,i.u_scale),u_fade:new t.bq(e,i.u_fade),u_fill_translate:new t.c3(e,i.u_fill_translate)}),fillOutline:(e,i)=>({u_world:new t.c3(e,i.u_world),u_fill_translate:new t.c3(e,i.u_fill_translate)}),fillOutlinePattern:(e,i)=>({u_world:new t.c3(e,i.u_world),u_image:new t.b_(e,i.u_image),u_texsize:new t.c3(e,i.u_texsize),u_pixel_coord_upper:new t.c3(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.c3(e,i.u_pixel_coord_lower),u_scale:new t.c2(e,i.u_scale),u_fade:new t.bq(e,i.u_fade),u_fill_translate:new t.c3(e,i.u_fill_translate)}),circle:(e,i)=>({u_camera_to_center_distance:new t.bq(e,i.u_camera_to_center_distance),u_scale_with_map:new t.b_(e,i.u_scale_with_map),u_pitch_with_map:new t.b_(e,i.u_pitch_with_map),u_extrude_scale:new t.c3(e,i.u_extrude_scale),u_device_pixel_ratio:new t.bq(e,i.u_device_pixel_ratio),u_globe_extrude_scale:new t.bq(e,i.u_globe_extrude_scale),u_translate:new t.c3(e,i.u_translate)}),collisionBox:(e,i)=>({u_pixel_extrude_scale:new t.c3(e,i.u_pixel_extrude_scale)}),collisionCircle:(e,i)=>({u_viewport_size:new t.c3(e,i.u_viewport_size)}),debug:(e,i)=>({u_color:new t.b$(e,i.u_color),u_overlay:new t.b_(e,i.u_overlay),u_overlay_scale:new t.bq(e,i.u_overlay_scale)}),depth:va,clippingMask:va,heatmap:(e,i)=>({u_extrude_scale:new t.bq(e,i.u_extrude_scale),u_intensity:new t.bq(e,i.u_intensity),u_globe_extrude_scale:new t.bq(e,i.u_globe_extrude_scale)}),heatmapTexture:(e,i)=>({u_matrix:new t.c0(e,i.u_matrix),u_world:new t.c3(e,i.u_world),u_image:new t.b_(e,i.u_image),u_color_ramp:new t.b_(e,i.u_color_ramp),u_opacity:new t.bq(e,i.u_opacity)}),hillshade:(e,i)=>({u_image:new t.b_(e,i.u_image),u_latrange:new t.c3(e,i.u_latrange),u_exaggeration:new t.bq(e,i.u_exaggeration),u_altitudes:new t.c9(e,i.u_altitudes),u_azimuths:new t.c9(e,i.u_azimuths),u_accent:new t.b$(e,i.u_accent),u_method:new t.b_(e,i.u_method),u_shadows:new t.c8(e,i.u_shadows),u_highlights:new t.c8(e,i.u_highlights)}),hillshadePrepare:(e,i)=>({u_matrix:new t.c0(e,i.u_matrix),u_image:new t.b_(e,i.u_image),u_dimension:new t.c3(e,i.u_dimension),u_zoom:new t.bq(e,i.u_zoom),u_unpack:new t.c1(e,i.u_unpack)}),colorRelief:(e,i)=>({u_image:new t.b_(e,i.u_image),u_unpack:new t.c1(e,i.u_unpack),u_dimension:new t.c3(e,i.u_dimension),u_elevation_stops:new t.b_(e,i.u_elevation_stops),u_color_stops:new t.b_(e,i.u_color_stops),u_color_ramp_size:new t.b_(e,i.u_color_ramp_size),u_opacity:new t.bq(e,i.u_opacity)}),line:(e,i)=>({u_translation:new t.c3(e,i.u_translation),u_ratio:new t.bq(e,i.u_ratio),u_device_pixel_ratio:new t.bq(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.c3(e,i.u_units_to_pixels)}),lineGradient:(e,i)=>({u_translation:new t.c3(e,i.u_translation),u_ratio:new t.bq(e,i.u_ratio),u_device_pixel_ratio:new t.bq(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.c3(e,i.u_units_to_pixels),u_image:new t.b_(e,i.u_image),u_image_height:new t.bq(e,i.u_image_height)}),linePattern:(e,i)=>({u_translation:new t.c3(e,i.u_translation),u_texsize:new t.c3(e,i.u_texsize),u_ratio:new t.bq(e,i.u_ratio),u_device_pixel_ratio:new t.bq(e,i.u_device_pixel_ratio),u_image:new t.b_(e,i.u_image),u_units_to_pixels:new t.c3(e,i.u_units_to_pixels),u_scale:new t.c2(e,i.u_scale),u_fade:new t.bq(e,i.u_fade)}),lineSDF:(e,i)=>({u_translation:new t.c3(e,i.u_translation),u_ratio:new t.bq(e,i.u_ratio),u_device_pixel_ratio:new t.bq(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.c3(e,i.u_units_to_pixels),u_image:new t.b_(e,i.u_image),u_mix:new t.bq(e,i.u_mix),u_tileratio:new t.bq(e,i.u_tileratio),u_crossfade_from:new t.bq(e,i.u_crossfade_from),u_crossfade_to:new t.bq(e,i.u_crossfade_to),u_lineatlas_width:new t.bq(e,i.u_lineatlas_width),u_lineatlas_height:new t.bq(e,i.u_lineatlas_height)}),lineGradientSDF:(e,i)=>({u_translation:new t.c3(e,i.u_translation),u_ratio:new t.bq(e,i.u_ratio),u_device_pixel_ratio:new t.bq(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.c3(e,i.u_units_to_pixels),u_image:new t.b_(e,i.u_image),u_image_height:new t.bq(e,i.u_image_height),u_tileratio:new t.bq(e,i.u_tileratio),u_crossfade_from:new t.bq(e,i.u_crossfade_from),u_crossfade_to:new t.bq(e,i.u_crossfade_to),u_image_dash:new t.b_(e,i.u_image_dash),u_mix:new t.bq(e,i.u_mix),u_lineatlas_width:new t.bq(e,i.u_lineatlas_width),u_lineatlas_height:new t.bq(e,i.u_lineatlas_height)}),raster:(e,i)=>({u_tl_parent:new t.c3(e,i.u_tl_parent),u_scale_parent:new t.bq(e,i.u_scale_parent),u_buffer_scale:new t.bq(e,i.u_buffer_scale),u_fade_t:new t.bq(e,i.u_fade_t),u_opacity:new t.bq(e,i.u_opacity),u_image0:new t.b_(e,i.u_image0),u_image1:new t.b_(e,i.u_image1),u_brightness_low:new t.bq(e,i.u_brightness_low),u_brightness_high:new t.bq(e,i.u_brightness_high),u_saturation_factor:new t.bq(e,i.u_saturation_factor),u_contrast_factor:new t.bq(e,i.u_contrast_factor),u_spin_weights:new t.c2(e,i.u_spin_weights),u_coords_top:new t.c1(e,i.u_coords_top),u_coords_bottom:new t.c1(e,i.u_coords_bottom)}),symbolIcon:(e,i)=>({u_is_size_zoom_constant:new t.b_(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.b_(e,i.u_is_size_feature_constant),u_size_t:new t.bq(e,i.u_size_t),u_size:new t.bq(e,i.u_size),u_camera_to_center_distance:new t.bq(e,i.u_camera_to_center_distance),u_pitch:new t.bq(e,i.u_pitch),u_rotate_symbol:new t.b_(e,i.u_rotate_symbol),u_aspect_ratio:new t.bq(e,i.u_aspect_ratio),u_fade_change:new t.bq(e,i.u_fade_change),u_label_plane_matrix:new t.c0(e,i.u_label_plane_matrix),u_coord_matrix:new t.c0(e,i.u_coord_matrix),u_is_text:new t.b_(e,i.u_is_text),u_pitch_with_map:new t.b_(e,i.u_pitch_with_map),u_is_along_line:new t.b_(e,i.u_is_along_line),u_is_variable_anchor:new t.b_(e,i.u_is_variable_anchor),u_texsize:new t.c3(e,i.u_texsize),u_texture:new t.b_(e,i.u_texture),u_translation:new t.c3(e,i.u_translation),u_pitched_scale:new t.bq(e,i.u_pitched_scale)}),symbolSDF:(e,i)=>({u_is_size_zoom_constant:new t.b_(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.b_(e,i.u_is_size_feature_constant),u_size_t:new t.bq(e,i.u_size_t),u_size:new t.bq(e,i.u_size),u_camera_to_center_distance:new t.bq(e,i.u_camera_to_center_distance),u_pitch:new t.bq(e,i.u_pitch),u_rotate_symbol:new t.b_(e,i.u_rotate_symbol),u_aspect_ratio:new t.bq(e,i.u_aspect_ratio),u_fade_change:new t.bq(e,i.u_fade_change),u_label_plane_matrix:new t.c0(e,i.u_label_plane_matrix),u_coord_matrix:new t.c0(e,i.u_coord_matrix),u_is_text:new t.b_(e,i.u_is_text),u_pitch_with_map:new t.b_(e,i.u_pitch_with_map),u_is_along_line:new t.b_(e,i.u_is_along_line),u_is_variable_anchor:new t.b_(e,i.u_is_variable_anchor),u_texsize:new t.c3(e,i.u_texsize),u_texture:new t.b_(e,i.u_texture),u_gamma_scale:new t.bq(e,i.u_gamma_scale),u_device_pixel_ratio:new t.bq(e,i.u_device_pixel_ratio),u_is_halo:new t.b_(e,i.u_is_halo),u_translation:new t.c3(e,i.u_translation),u_pitched_scale:new t.bq(e,i.u_pitched_scale)}),symbolTextAndIcon:(e,i)=>({u_is_size_zoom_constant:new t.b_(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.b_(e,i.u_is_size_feature_constant),u_size_t:new t.bq(e,i.u_size_t),u_size:new t.bq(e,i.u_size),u_camera_to_center_distance:new t.bq(e,i.u_camera_to_center_distance),u_pitch:new t.bq(e,i.u_pitch),u_rotate_symbol:new t.b_(e,i.u_rotate_symbol),u_aspect_ratio:new t.bq(e,i.u_aspect_ratio),u_fade_change:new t.bq(e,i.u_fade_change),u_label_plane_matrix:new t.c0(e,i.u_label_plane_matrix),u_coord_matrix:new t.c0(e,i.u_coord_matrix),u_is_text:new t.b_(e,i.u_is_text),u_pitch_with_map:new t.b_(e,i.u_pitch_with_map),u_is_along_line:new t.b_(e,i.u_is_along_line),u_is_variable_anchor:new t.b_(e,i.u_is_variable_anchor),u_texsize:new t.c3(e,i.u_texsize),u_texsize_icon:new t.c3(e,i.u_texsize_icon),u_texture:new t.b_(e,i.u_texture),u_texture_icon:new t.b_(e,i.u_texture_icon),u_gamma_scale:new t.bq(e,i.u_gamma_scale),u_device_pixel_ratio:new t.bq(e,i.u_device_pixel_ratio),u_is_halo:new t.b_(e,i.u_is_halo),u_translation:new t.c3(e,i.u_translation),u_pitched_scale:new t.bq(e,i.u_pitched_scale)}),background:(e,i)=>({u_opacity:new t.bq(e,i.u_opacity),u_color:new t.b$(e,i.u_color)}),backgroundPattern:(e,i)=>({u_opacity:new t.bq(e,i.u_opacity),u_image:new t.b_(e,i.u_image),u_pattern_tl_a:new t.c3(e,i.u_pattern_tl_a),u_pattern_br_a:new t.c3(e,i.u_pattern_br_a),u_pattern_tl_b:new t.c3(e,i.u_pattern_tl_b),u_pattern_br_b:new t.c3(e,i.u_pattern_br_b),u_texsize:new t.c3(e,i.u_texsize),u_mix:new t.bq(e,i.u_mix),u_pattern_size_a:new t.c3(e,i.u_pattern_size_a),u_pattern_size_b:new t.c3(e,i.u_pattern_size_b),u_scale_a:new t.bq(e,i.u_scale_a),u_scale_b:new t.bq(e,i.u_scale_b),u_pixel_coord_upper:new t.c3(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.c3(e,i.u_pixel_coord_lower),u_tile_units_to_pixels:new t.bq(e,i.u_tile_units_to_pixels)}),terrain:(e,i)=>({u_texture:new t.b_(e,i.u_texture),u_ele_delta:new t.bq(e,i.u_ele_delta),u_fog_matrix:new t.c0(e,i.u_fog_matrix),u_fog_color:new t.b$(e,i.u_fog_color),u_fog_ground_blend:new t.bq(e,i.u_fog_ground_blend),u_fog_ground_blend_opacity:new t.bq(e,i.u_fog_ground_blend_opacity),u_horizon_color:new t.b$(e,i.u_horizon_color),u_horizon_fog_blend:new t.bq(e,i.u_horizon_fog_blend),u_is_globe_mode:new t.bq(e,i.u_is_globe_mode)}),terrainDepth:(e,i)=>({u_ele_delta:new t.bq(e,i.u_ele_delta)}),terrainCoords:(e,i)=>({u_texture:new t.b_(e,i.u_texture),u_terrain_coords_id:new t.bq(e,i.u_terrain_coords_id),u_ele_delta:new t.bq(e,i.u_ele_delta)}),projectionErrorMeasurement:(e,i)=>({u_input:new t.bq(e,i.u_input),u_output_expected:new t.bq(e,i.u_output_expected)}),atmosphere:(e,i)=>({u_sun_pos:new t.c2(e,i.u_sun_pos),u_atmosphere_blend:new t.bq(e,i.u_atmosphere_blend),u_globe_position:new t.c2(e,i.u_globe_position),u_globe_radius:new t.bq(e,i.u_globe_radius),u_inv_proj_matrix:new t.c0(e,i.u_inv_proj_matrix)}),sky:(e,i)=>({u_sky_color:new t.b$(e,i.u_sky_color),u_horizon_color:new t.b$(e,i.u_horizon_color),u_horizon:new t.c3(e,i.u_horizon),u_horizon_normal:new t.c3(e,i.u_horizon_normal),u_sky_horizon_blend:new t.bq(e,i.u_sky_horizon_blend),u_sky_blend:new t.bq(e,i.u_sky_blend)})};class ba{constructor(e,t,i){this.context=e;const a=e.gl;this.buffer=a.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),e.bindElementBuffer.set(this.buffer),a.bufferData(a.ELEMENT_ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?a.DYNAMIC_DRAW:a.STATIC_DRAW),this.dynamicDraw||delete t.arrayBuffer;}bind(){this.context.bindElementBuffer.set(this.buffer);}updateData(e){const t=this.context.gl;if(!this.dynamicDraw)throw new Error("Attempted to update data while not in dynamic mode.");this.context.unbindVAO(),this.bind(),t.bufferSubData(t.ELEMENT_ARRAY_BUFFER,0,e.arrayBuffer);}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}const ya={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class wa{constructor(e,t,i,a){this.length=t.length,this.attributes=i,this.itemSize=t.bytesPerElement,this.dynamicDraw=a,this.context=e;const r=e.gl;this.buffer=r.createBuffer(),e.bindVertexBuffer.set(this.buffer),r.bufferData(r.ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?r.DYNAMIC_DRAW:r.STATIC_DRAW),this.dynamicDraw||delete t.arrayBuffer;}bind(){this.context.bindVertexBuffer.set(this.buffer);}updateData(e){if(e.length!==this.length)throw new Error(`Length of new data is ${e.length}, which doesn't match current length of ${this.length}`);const t=this.context.gl;this.bind(),t.bufferSubData(t.ARRAY_BUFFER,0,e.arrayBuffer);}enableAttributes(e,t){for(let i=0;i<this.attributes.length;i++){const a=t.attributes[this.attributes[i].name];void 0!==a&&e.enableVertexAttribArray(a);}}setVertexAttribPointers(e,t,i){for(let a=0;a<this.attributes.length;a++){const r=this.attributes[a],o=t.attributes[r.name];void 0!==o&&e.vertexAttribPointer(o,r.components,e[ya[r.type]],!1,this.itemSize,r.offset+this.itemSize*(i||0));}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}class Ta{constructor(e){this.gl=e.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1;}get(){return this.current}set(e){}getDefault(){return this.default}setDefault(){this.set(this.default);}}class Pa extends Ta{getDefault(){return t.bp.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.clearColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1);}}class Ca extends Ta{getDefault(){return 1}set(e){(e!==this.current||this.dirty)&&(this.gl.clearDepth(e),this.current=e,this.dirty=!1);}}class Ia extends Ta{getDefault(){return 0}set(e){(e!==this.current||this.dirty)&&(this.gl.clearStencil(e),this.current=e,this.dirty=!1);}}class Ma extends Ta{getDefault(){return [!0,!0,!0,!0]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.colorMask(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class Ea extends Ta{getDefault(){return !0}set(e){(e!==this.current||this.dirty)&&(this.gl.depthMask(e),this.current=e,this.dirty=!1);}}class Sa extends Ta{getDefault(){return 255}set(e){(e!==this.current||this.dirty)&&(this.gl.stencilMask(e),this.current=e,this.dirty=!1);}}class za extends Ta{getDefault(){return {func:this.gl.ALWAYS,ref:0,mask:255}}set(e){const t=this.current;(e.func!==t.func||e.ref!==t.ref||e.mask!==t.mask||this.dirty)&&(this.gl.stencilFunc(e.func,e.ref,e.mask),this.current=e,this.dirty=!1);}}class Ra extends Ta{getDefault(){const e=this.gl;return [e.KEEP,e.KEEP,e.KEEP]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||this.dirty)&&(this.gl.stencilOp(e[0],e[1],e[2]),this.current=e,this.dirty=!1);}}class Da extends Ta{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.STENCIL_TEST):t.disable(t.STENCIL_TEST),this.current=e,this.dirty=!1;}}class Aa extends Ta{getDefault(){return [0,1]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.depthRange(e[0],e[1]),this.current=e,this.dirty=!1);}}class La extends Ta{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.DEPTH_TEST):t.disable(t.DEPTH_TEST),this.current=e,this.dirty=!1;}}class ka extends Ta{getDefault(){return this.gl.LESS}set(e){(e!==this.current||this.dirty)&&(this.gl.depthFunc(e),this.current=e,this.dirty=!1);}}class Fa extends Ta{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.BLEND):t.disable(t.BLEND),this.current=e,this.dirty=!1;}}class Ba extends Ta{getDefault(){const e=this.gl;return [e.ONE,e.ZERO]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.blendFunc(e[0],e[1]),this.current=e,this.dirty=!1);}}class Oa extends Ta{getDefault(){return t.bp.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.blendColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1);}}class ja extends Ta{getDefault(){return this.gl.FUNC_ADD}set(e){(e!==this.current||this.dirty)&&(this.gl.blendEquation(e),this.current=e,this.dirty=!1);}}class Na extends Ta{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.CULL_FACE):t.disable(t.CULL_FACE),this.current=e,this.dirty=!1;}}class Za extends Ta{getDefault(){return this.gl.BACK}set(e){(e!==this.current||this.dirty)&&(this.gl.cullFace(e),this.current=e,this.dirty=!1);}}class Ga extends Ta{getDefault(){return this.gl.CCW}set(e){(e!==this.current||this.dirty)&&(this.gl.frontFace(e),this.current=e,this.dirty=!1);}}class Ua extends Ta{getDefault(){return null}set(e){(e!==this.current||this.dirty)&&(this.gl.useProgram(e),this.current=e,this.dirty=!1);}}class Va extends Ta{getDefault(){return this.gl.TEXTURE0}set(e){(e!==this.current||this.dirty)&&(this.gl.activeTexture(e),this.current=e,this.dirty=!1);}}class qa extends Ta{getDefault(){const e=this.gl;return [0,0,e.drawingBufferWidth,e.drawingBufferHeight]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.viewport(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class Wa extends Ta{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindFramebuffer(t.FRAMEBUFFER,e),this.current=e,this.dirty=!1;}}class $a extends Ta{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindRenderbuffer(t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}class Ha extends Ta{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindTexture(t.TEXTURE_2D,e),this.current=e,this.dirty=!1;}}class Xa extends Ta{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindBuffer(t.ARRAY_BUFFER,e),this.current=e,this.dirty=!1;}}class Ka extends Ta{getDefault(){return null}set(e){const t=this.gl;t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,e),this.current=e,this.dirty=!1;}}class Ya extends Ta{getDefault(){return null}set(e){var t;if(e===this.current&&!this.dirty)return;const i=this.gl;oi(i)?i.bindVertexArray(e):null===(t=i.getExtension("OES_vertex_array_object"))||void 0===t||t.bindVertexArrayOES(e),this.current=e,this.dirty=!1;}}class Qa extends Ta{getDefault(){return 4}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_ALIGNMENT,e),this.current=e,this.dirty=!1;}}class Ja extends Ta{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,e),this.current=e,this.dirty=!1;}}class er extends Ta{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,e),this.current=e,this.dirty=!1;}}class tr extends Ta{constructor(e,t){super(e),this.context=e,this.parent=t;}getDefault(){return null}}class ir extends tr{setDirty(){this.dirty=!0;}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,e,0),this.current=e,this.dirty=!1;}}class ar extends tr{set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}class rr extends tr{set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}const or="Framebuffer is not complete";class sr{constructor(e,t,i,a,r){this.context=e,this.width=t,this.height=i;const o=e.gl,s=this.framebuffer=o.createFramebuffer();if(this.colorAttachment=new ir(e,s),a)this.depthAttachment=r?new rr(e,s):new ar(e,s);else if(r)throw new Error("Stencil cannot be set without depth");if(o.checkFramebufferStatus(o.FRAMEBUFFER)!==o.FRAMEBUFFER_COMPLETE)throw new Error(or)}destroy(){const e=this.context.gl,t=this.colorAttachment.get();if(t&&e.deleteTexture(t),this.depthAttachment){const t=this.depthAttachment.get();t&&e.deleteRenderbuffer(t);}e.deleteFramebuffer(this.framebuffer);}}class nr{constructor(e){var t,i;if(this.gl=e,this.clearColor=new Pa(this),this.clearDepth=new Ca(this),this.clearStencil=new Ia(this),this.colorMask=new Ma(this),this.depthMask=new Ea(this),this.stencilMask=new Sa(this),this.stencilFunc=new za(this),this.stencilOp=new Ra(this),this.stencilTest=new Da(this),this.depthRange=new Aa(this),this.depthTest=new La(this),this.depthFunc=new ka(this),this.blend=new Fa(this),this.blendFunc=new Ba(this),this.blendColor=new Oa(this),this.blendEquation=new ja(this),this.cullFace=new Na(this),this.cullFaceSide=new Za(this),this.frontFace=new Ga(this),this.program=new Ua(this),this.activeTexture=new Va(this),this.viewport=new qa(this),this.bindFramebuffer=new Wa(this),this.bindRenderbuffer=new $a(this),this.bindTexture=new Ha(this),this.bindVertexBuffer=new Xa(this),this.bindElementBuffer=new Ka(this),this.bindVertexArray=new Ya(this),this.pixelStoreUnpack=new Qa(this),this.pixelStoreUnpackPremultiplyAlpha=new Ja(this),this.pixelStoreUnpackFlipY=new er(this),this.extTextureFilterAnisotropic=e.getExtension("EXT_texture_filter_anisotropic")||e.getExtension("MOZ_EXT_texture_filter_anisotropic")||e.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=e.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.maxTextureSize=e.getParameter(e.MAX_TEXTURE_SIZE),oi(e)){this.HALF_FLOAT=e.HALF_FLOAT;const a=e.getExtension("EXT_color_buffer_half_float");this.RGBA16F=null!==(t=e.RGBA16F)&&void 0!==t?t:null==a?void 0:a.RGBA16F_EXT,this.RGB16F=null!==(i=e.RGB16F)&&void 0!==i?i:null==a?void 0:a.RGB16F_EXT,e.getExtension("EXT_color_buffer_float");}else {e.getExtension("EXT_color_buffer_half_float"),e.getExtension("OES_texture_half_float_linear");const t=e.getExtension("OES_texture_half_float");this.HALF_FLOAT=null==t?void 0:t.HALF_FLOAT_OES;}}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault();}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.bindVertexArray.dirty=!0,this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0;}createIndexBuffer(e,t){return new ba(this,e,t)}createVertexBuffer(e,t,i){return new wa(this,e,t,i)}createRenderbuffer(e,t,i){const a=this.gl,r=a.createRenderbuffer();return this.bindRenderbuffer.set(r),a.renderbufferStorage(a.RENDERBUFFER,e,t,i),this.bindRenderbuffer.set(null),r}createFramebuffer(e,t,i,a){return new sr(this,e,t,i,a)}clear({color:e,depth:t,stencil:i}){const a=this.gl;let r=0;e&&(r|=a.COLOR_BUFFER_BIT,this.clearColor.set(e),this.colorMask.set([!0,!0,!0,!0])),void 0!==t&&(r|=a.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(t),this.depthMask.set(!0)),void 0!==i&&(r|=a.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),a.clear(r);}setCullFace(e){!1===e.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(e.mode),this.frontFace.set(e.frontFace));}setDepthMode(e){e.func!==this.gl.ALWAYS||e.mask?(this.depthTest.set(!0),this.depthFunc.set(e.func),this.depthMask.set(e.mask),this.depthRange.set(e.range)):this.depthTest.set(!1);}setStencilMode(e){e.test.func!==this.gl.ALWAYS||e.mask?(this.stencilTest.set(!0),this.stencilMask.set(e.mask),this.stencilOp.set([e.fail,e.depthFail,e.pass]),this.stencilFunc.set({func:e.test.func,ref:e.ref,mask:e.test.mask})):this.stencilTest.set(!1);}setColorMode(e){t.bR(e.blendFunction,Qt.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(e.blendFunction),this.blendColor.set(e.blendColor)),this.colorMask.set(e.mask);}createVertexArray(){var e;return oi(this.gl)?this.gl.createVertexArray():null===(e=this.gl.getExtension("OES_vertex_array_object"))||void 0===e?void 0:e.createVertexArrayOES()}deleteVertexArray(e){var t;return oi(this.gl)?this.gl.deleteVertexArray(e):null===(t=this.gl.getExtension("OES_vertex_array_object"))||void 0===t?void 0:t.deleteVertexArrayOES(e)}unbindVAO(){this.bindVertexArray.set(null);}}let lr;function cr(e,i,a,r,o){const s=e.context,n=e.transform,l=s.gl,c=e.useProgram("collisionBox"),h=[];let u=0,d=0;for(let t=0;t<r.length;t++){const _=r[t],p=i.getTile(_).getBucket(a);if(!p)continue;const m=o?p.textCollisionBox:p.iconCollisionBox,f=p.collisionCircleArray;f.length>0&&(h.push({circleArray:f,circleOffset:d,coord:_}),u+=f.length/4,d=u),m&&c.draw(s,l.LINES,ti.disabled,ai.disabled,e.colorModeForRenderPass(),ei.disabled,Xi(e.transform),e.style.map.terrain&&e.style.map.terrain.getTerrainData(_),n.getProjectionData({overscaledTileID:_,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),a.id,m.layoutVertexBuffer,m.indexBuffer,m.segments,null,e.transform.zoom,null,null,m.collisionVertexBuffer);}if(!o||!h.length)return;const _=e.useProgram("collisionCircle"),p=new t.ca;p.resize(4*u),p._trim();let m=0;for(const e of h)for(let t=0;t<e.circleArray.length/4;t++){const i=4*t,a=e.circleArray[i+0],r=e.circleArray[i+1],o=e.circleArray[i+2],s=e.circleArray[i+3];p.emplace(m++,a,r,o,s,0),p.emplace(m++,a,r,o,s,1),p.emplace(m++,a,r,o,s,2),p.emplace(m++,a,r,o,s,3);}(!lr||lr.length<2*u)&&(lr=function(e){const i=2*e,a=new t.cc;a.resize(i),a._trim();for(let e=0;e<i;e++){const t=6*e;a.uint16[t+0]=4*e+0,a.uint16[t+1]=4*e+1,a.uint16[t+2]=4*e+2,a.uint16[t+3]=4*e+2,a.uint16[t+4]=4*e+3,a.uint16[t+5]=4*e+0;}return a}(u));const f=s.createIndexBuffer(lr,!0),g=s.createVertexBuffer(p,t.cb.members,!0);for(const i of h){const r=Ki(e.transform);_.draw(s,l.TRIANGLES,ti.disabled,ai.disabled,e.colorModeForRenderPass(),ei.disabled,r,e.style.map.terrain&&e.style.map.terrain.getTerrainData(i.coord),null,a.id,g,f,t.aX.simpleSegment(0,2*i.circleOffset,i.circleArray.length,i.circleArray.length/2),null,e.transform.zoom,null,null,null);}g.destroy(),f.destroy();}const hr=t.ar(new Float32Array(16));function ur(e,i,a,r,o,s){const{horizontalAlign:n,verticalAlign:l}=t.aS(e);return new t.P((-(n-.5)*i/o+r[0])*s,(-(l-.5)*a/o+r[1])*s)}function dr(e,i,a,r,o,s){const n=i.tileAnchorPoint.add(new t.P(i.translation[0],i.translation[1]));if(i.pitchWithMap){let e=r.mult(s);a||(e=e.rotate(-o));const t=n.add(e);return Ge(t.x,t.y,i.pitchedLabelPlaneMatrix,i.getElevation).point}if(a){const t=Ye(i.tileAnchorPoint.x+1,i.tileAnchorPoint.y,i).point.sub(e),a=Math.atan(t.y/t.x)+(t.x<0?Math.PI:0);return e.add(r.rotate(a))}return e.add(r)}function _r(e,i,a,r,o,s,n,l,c,h,u,d){const _=e.text.placedSymbolArray,p=e.text.dynamicLayoutVertexArray,m=e.icon.dynamicLayoutVertexArray,f={};p.clear();for(let m=0;m<_.length;m++){const g=_.get(m),v=g.hidden||!g.crossTileID||e.allowVerticalPlacement&&!g.placedOrientation?null:r[g.crossTileID];if(v){const r=new t.P(g.anchorX,g.anchorY),_={getElevation:d,width:o.width,height:o.height,pitchedLabelPlaneMatrix:s,pitchWithMap:a,transform:o,tileAnchorPoint:r,translation:h,unwrappedTileID:u},m=a?Je(r.x,r.y,_):Ye(r.x,r.y,_),x=Ue(o.cameraToCenterDistance,m.signedDistanceFromCamera);let b=t.aA(e.textSizeData,l,g)*x/t.aM;a&&(b*=e.tilePixelRatio/n);const{width:y,height:w,anchor:T,textOffset:P,textBoxScale:C}=v,I=ur(T,y,w,P,C,b),M=o.getPitchedTextCorrection(r.x+h[0],r.y+h[1],u),E=dr(m.point,_,i,I,-o.bearingInRadians,M),S=e.allowVerticalPlacement&&g.placedOrientation===t.az.vertical?Math.PI/2:0;for(let e=0;e<g.numGlyphs;e++)t.aG(p,E,S);c&&g.associatedIconIndex>=0&&(f[g.associatedIconIndex]={shiftedAnchor:E,angle:S});}else rt(g.numGlyphs,p);}if(c){m.clear();const i=e.icon.placedSymbolArray;for(let e=0;e<i.length;e++){const a=i.get(e);if(a.hidden)rt(a.numGlyphs,m);else {const i=f[e];if(i)for(let e=0;e<a.numGlyphs;e++)t.aG(m,i.shiftedAnchor,i.angle);else rt(a.numGlyphs,m);}}e.icon.dynamicLayoutVertexBuffer.updateData(m);}e.text.dynamicLayoutVertexBuffer.updateData(p);}function pr(e,t,i){return i.iconsInText&&t?"symbolTextAndIcon":e?"symbolSDF":"symbolIcon"}function mr(e,i,a,r,o,s,n,l,c,h,u,d,_){const p=e.context,m=p.gl,f=e.transform,g="map"===l,v="map"===c,x="viewport"!==l&&"point"!==a.layout.get("symbol-placement"),b=g&&!v&&!x,y=!a.layout.get("symbol-sort-key").isConstant();let w=!1;const T=e.getDepthModeForSublayer(0,ti.ReadOnly),P=a._unevaluatedLayout.hasValue("text-variable-anchor")||a._unevaluatedLayout.hasValue("text-variable-anchor-offset"),C=[],I=f.getCircleRadiusCorrection();for(const l of r){const r=i.getTile(l),c=r.getBucket(a);if(!c)continue;const u=o?c.text:c.icon;if(!u||!u.segments.get().length||!u.hasVisibleVertices)continue;const d=u.programConfigurations.get(a.id),p=o||c.sdfIcons,T=o?c.textSizeData:c.iconSizeData,M=v||0!==f.pitch,E=e.useProgram(pr(p,o,c),d),S=t.ay(T,f.zoom),z=e.style.map.terrain&&e.style.map.terrain.getTerrainData(l);let R,D,A,L,k=[0,0],F=null;if(o)D=r.glyphAtlasTexture,A=m.LINEAR,R=r.glyphAtlasTexture.size,c.iconsInText&&(k=r.imageAtlasTexture.size,F=r.imageAtlasTexture,L=M||e.options.rotating||e.options.zooming||"composite"===T.kind||"camera"===T.kind?m.LINEAR:m.NEAREST);else {const t=1!==a.layout.get("icon-size").constantOr(0)||c.iconsNeedLinear;D=r.imageAtlasTexture,A=p||e.options.rotating||e.options.zooming||t||M?m.LINEAR:m.NEAREST,R=r.imageAtlasTexture.size;}const B=t.aN(r,1,e.transform.zoom),O=je(g,e.transform,B),j=t.N();t.aB(j,O);const N=Ne(v,g,e.transform,B),Z=t.aO(f,r,s,n),G=f.getProjectionData({overscaledTileID:l,applyGlobeMatrix:!_,applyTerrainMatrix:!0}),U=P&&c.hasTextData(),V="none"!==a.layout.get("icon-text-fit")&&U&&c.hasIconData();if(x){const t=e.style.map.terrain?(t,i)=>e.style.map.terrain.getElevation(l,t,i):null,i="map"===a.layout.get("text-rotation-alignment");qe(c,e,o,O,j,v,h,i,l.toUnwrapped(),f.width,f.height,Z,t);}const q=o&&P||V,W=x||q?hr:v?O:e.transform.clipSpaceToPixelsMatrix,$=p&&0!==a.paint.get(o?"text-halo-width":"icon-halo-width").constantOr(1);let H;H=p?c.iconsInText?ma(T.kind,S,b,v,x,q,e,W,N,Z,R,k,I):pa(T.kind,S,b,v,x,q,e,W,N,Z,o,R,0,I):_a(T.kind,S,b,v,x,q,e,W,N,Z,o,R,I);const X={program:E,buffers:u,uniformValues:H,projectionData:G,atlasTexture:D,atlasTextureIcon:F,atlasInterpolation:A,atlasInterpolationIcon:L,isSDF:p,hasHalo:$};if(y&&c.canOverlap){w=!0;const e=u.segments.get();for(const i of e)C.push({segments:new t.aX([i]),sortKey:i.sortKey,state:X,terrainData:z});}else C.push({segments:u.segments,sortKey:0,state:X,terrainData:z});}w&&C.sort(((e,t)=>e.sortKey-t.sortKey));for(const t of C){const i=t.state;if(p.activeTexture.set(m.TEXTURE0),i.atlasTexture.bind(i.atlasInterpolation,m.CLAMP_TO_EDGE),i.atlasTextureIcon&&(p.activeTexture.set(m.TEXTURE1),i.atlasTextureIcon&&i.atlasTextureIcon.bind(i.atlasInterpolationIcon,m.CLAMP_TO_EDGE)),i.isSDF){const r=i.uniformValues;i.hasHalo&&(r.u_is_halo=1,fr(i.buffers,t.segments,a,e,i.program,T,u,d,r,i.projectionData,t.terrainData)),r.u_is_halo=0;}fr(i.buffers,t.segments,a,e,i.program,T,u,d,i.uniformValues,i.projectionData,t.terrainData);}}function fr(e,t,i,a,r,o,s,n,l,c,h){const u=a.context;r.draw(u,u.gl.TRIANGLES,o,s,n,ei.backCCW,l,h,c,i.id,e.layoutVertexBuffer,e.indexBuffer,t,i.paint,a.transform.zoom,e.programConfigurations.get(i.id),e.dynamicLayoutVertexBuffer,e.opacityVertexBuffer);}function gr(e,i,a,r,o){const s=e.context,n=s.gl,l=ai.disabled,c=new Qt([n.ONE,n.ONE],t.bp.transparent,[!0,!0,!0,!0]),h=i.getBucket(a);if(!h)return;const u=r.key;let d=a.heatmapFbos.get(u);d||(d=xr(s,i.tileSize,i.tileSize),a.heatmapFbos.set(u,d)),s.bindFramebuffer.set(d.framebuffer),s.viewport.set([0,0,i.tileSize,i.tileSize]),s.clear({color:t.bp.transparent});const _=h.programConfigurations.get(a.id),p=e.useProgram("heatmap",_,!o),m=e.transform.getProjectionData({overscaledTileID:i.tileID,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),f=e.style.map.terrain.getTerrainData(r);p.draw(s,n.TRIANGLES,ti.disabled,l,c,ei.disabled,Qi(i,e.transform.zoom,a.paint.get("heatmap-intensity"),1),f,m,a.id,h.layoutVertexBuffer,h.indexBuffer,h.segments,a.paint,e.transform.zoom,_);}function vr(e,t,i,a,r){const o=e.context,s=o.gl,n=e.transform;o.setColorMode(e.colorModeForRenderPass());const l=br(o,t),c=i.key,h=t.heatmapFbos.get(c);if(!h)return;o.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_2D,h.colorAttachment.get()),o.activeTexture.set(s.TEXTURE1),l.bind(s.LINEAR,s.CLAMP_TO_EDGE);const u=n.getProjectionData({overscaledTileID:i,applyTerrainMatrix:r,applyGlobeMatrix:!a});e.useProgram("heatmapTexture").draw(o,s.TRIANGLES,ti.disabled,ai.disabled,e.colorModeForRenderPass(),ei.disabled,Ji(e,t,0,1),null,u,t.id,e.rasterBoundsBuffer,e.quadTriangleIndexBuffer,e.rasterBoundsSegments,t.paint,n.zoom),h.destroy(),t.heatmapFbos.delete(c);}function xr(e,t,i){var a,r;const o=e.gl,s=o.createTexture();o.bindTexture(o.TEXTURE_2D,s),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_S,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_T,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MIN_FILTER,o.LINEAR),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MAG_FILTER,o.LINEAR);const n=null!==(a=e.HALF_FLOAT)&&void 0!==a?a:o.UNSIGNED_BYTE,l=null!==(r=e.RGBA16F)&&void 0!==r?r:o.RGBA;o.texImage2D(o.TEXTURE_2D,0,l,t,i,0,o.RGBA,n,null);const c=e.createFramebuffer(t,i,!1,!1);return c.colorAttachment.set(s),c}function br(e,i){return i.colorRampTexture||(i.colorRampTexture=new t.T(e,i.colorRamp,e.gl.RGBA)),i.colorRampTexture}function yr(e,i,a,r,o,s,n,l){let c=256;if(o.stepInterpolant){const r=i.getSource().maxzoom,o=n.canonical.z===r?Math.ceil(1<<e.transform.maxZoom-n.canonical.z):1;c=t.an(t.ce(s.maxLineLength/t.a5*1024*o),256,a.maxTextureSize);}return l.gradient=t.cf({expression:o.gradientExpression(),evaluationKey:"lineProgress",resolution:c,image:l.gradient||void 0,clips:s.lineClipsArray}),l.texture?l.texture.update(l.gradient):l.texture=new t.T(a,l.gradient,r.RGBA),l.version=o.gradientVersion,l.texture}function wr(e,t,i,a,r){e.activeTexture.set(t.TEXTURE0),i.imageAtlasTexture.bind(t.LINEAR,t.CLAMP_TO_EDGE),a.updatePaintBuffers(r);}function Tr(e,t,i,a,r,o){(r||e.lineAtlas.dirty)&&(t.activeTexture.set(i.TEXTURE0),e.lineAtlas.bind(t)),a.updatePaintBuffers(o);}function Pr(e,t,i,a,r,o,s){const n=o.gradients[r.id];let l=n.texture;r.gradientVersion!==n.version&&(l=yr(e,t,i,a,r,o,s,n)),i.activeTexture.set(a.TEXTURE0),l.bind(r.stepInterpolant?a.NEAREST:a.LINEAR,a.CLAMP_TO_EDGE);}function Cr(e,t,i,a,r,o,s,n,l){const c=o.gradients[r.id];let h=c.texture;r.gradientVersion!==c.version&&(h=yr(e,t,i,a,r,o,s,c)),i.activeTexture.set(a.TEXTURE0),h.bind(r.stepInterpolant?a.NEAREST:a.LINEAR,a.CLAMP_TO_EDGE),i.activeTexture.set(a.TEXTURE1),e.lineAtlas.bind(i),n.updatePaintBuffers(l);}function Ir(e,t,i,a,r){if(!i||!a||!a.imageAtlas)return;const o=a.imageAtlas.patternPositions;let s=o[i.to.toString()],n=o[i.from.toString()];if(!s&&n&&(s=n),!n&&s&&(n=s),!s||!n){const e=r.getPaintProperty(t);s=o[e],n=o[e];}s&&n&&e.setConstantPatternPositions(s,n);}function Mr(e,i,a,r,o,s,n,l){const c=e.context.gl,h="fill-pattern",u=a.paint.get(h),d=u&&u.constantOr(1),_=a.getCrossfadeParameters();let p,m,f,g,v;const x=e.transform,b=a.paint.get("fill-translate"),y=a.paint.get("fill-translate-anchor");n?(m=d&&!a.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",p=c.LINES):(m=d?"fillPattern":"fill",p=c.TRIANGLES);const w=u.constantOr(null);for(const u of r){const r=i.getTile(u);if(d&&!r.patternsLoaded())continue;const T=r.getBucket(a);if(!T)continue;const P=T.programConfigurations.get(a.id),C=e.useProgram(m,P),I=e.style.map.terrain&&e.style.map.terrain.getTerrainData(u);d&&(e.context.activeTexture.set(c.TEXTURE0),r.imageAtlasTexture.bind(c.LINEAR,c.CLAMP_TO_EDGE),P.updatePaintBuffers(_)),Ir(P,h,w,r,a);const M=x.getProjectionData({overscaledTileID:u,applyGlobeMatrix:!l,applyTerrainMatrix:!0}),E=t.aO(x,r,b,y);if(n){g=T.indexBuffer2,v=T.segments2;const t=[c.drawingBufferWidth,c.drawingBufferHeight];f="fillOutlinePattern"===m&&d?$i(e,_,r,t,E):Wi(t,E);}else g=T.indexBuffer,v=T.segments,f=d?qi(e,_,r,E):{u_fill_translate:E};const S=e.stencilModeForClipping(u);C.draw(e.context,p,o,S,s,ei.backCCW,f,I,M,a.id,T.layoutVertexBuffer,g,v,a.paint,e.transform.zoom,P);}}function Er(e,i,a,r,o,s,n,l){const c=e.context,h=c.gl,u="fill-extrusion-pattern",d=a.paint.get(u),_=d.constantOr(1),p=a.getCrossfadeParameters(),m=a.paint.get("fill-extrusion-opacity"),f=d.constantOr(null),g=e.transform;for(const d of r){const r=i.getTile(d),v=r.getBucket(a);if(!v)continue;const x=e.style.map.terrain&&e.style.map.terrain.getTerrainData(d),b=v.programConfigurations.get(a.id),y=e.useProgram(_?"fillExtrusionPattern":"fillExtrusion",b);_&&(e.context.activeTexture.set(h.TEXTURE0),r.imageAtlasTexture.bind(h.LINEAR,h.CLAMP_TO_EDGE),b.updatePaintBuffers(p));const w=g.getProjectionData({overscaledTileID:d,applyGlobeMatrix:!l,applyTerrainMatrix:!0});Ir(b,u,f,r,a);const T=t.aO(g,r,a.paint.get("fill-extrusion-translate"),a.paint.get("fill-extrusion-translate-anchor")),P=a.paint.get("fill-extrusion-vertical-gradient"),C=_?Vi(e,P,m,T,d,p,r):Ui(e,P,m,T);y.draw(c,c.gl.TRIANGLES,o,s,n,ei.backCCW,C,x,w,a.id,v.layoutVertexBuffer,v.indexBuffer,v.segments,a.paint,e.transform.zoom,b,e.style.map.terrain&&v.centroidVertexBuffer);}}function Sr(e,t,i,a,r,o,s,n,l){var c;const h=e.style.projection,u=e.context,d=e.transform,_=u.gl,p=[`#define NUM_ILLUMINATION_SOURCES ${i.paint.get("hillshade-highlight-color").values.length}`],m=e.useProgram("hillshade",null,!1,p),f=!e.options.moving;for(const p of a){const a=t.getTile(p),g=a.fbo;if(!g)continue;const v=h.getMeshFromTileID(u,p.canonical,n,!0,"raster"),x=null===(c=e.style.map.terrain)||void 0===c?void 0:c.getTerrainData(p);u.activeTexture.set(_.TEXTURE0),_.bindTexture(_.TEXTURE_2D,g.colorAttachment.get());const b=d.getProjectionData({overscaledTileID:p,aligned:f,applyGlobeMatrix:!l,applyTerrainMatrix:!0});m.draw(u,_.TRIANGLES,o,r[p.overscaledZ],s,ei.backCCW,ea(e,a,i),x,b,i.id,v.vertexBuffer,v.indexBuffer,v.segments);}}function zr(e,i,a,r,o,s,n,l,c){var h;const u=e.style.projection,d=e.context,_=e.transform,p=d.gl,m=e.useProgram("colorRelief"),f=!e.options.moving;let g=!0,v=0;for(const x of r){const r=i.getTile(x),b=r.dem;if(g){const e=p.getParameter(p.MAX_TEXTURE_SIZE),{elevationTexture:t,colorTexture:i}=a.getColorRampTextures(d,e,b.getUnpackVector());d.activeTexture.set(p.TEXTURE1),t.bind(p.NEAREST,p.CLAMP_TO_EDGE),d.activeTexture.set(p.TEXTURE4),i.bind(p.LINEAR,p.CLAMP_TO_EDGE),g=!1,v=t.size[0];}if(!b||!b.data)continue;const y=b.stride,w=b.getPixels();if(d.activeTexture.set(p.TEXTURE0),d.pixelStoreUnpackPremultiplyAlpha.set(!1),r.demTexture=r.demTexture||e.getTileTexture(y),r.demTexture){const e=r.demTexture;e.update(w,{premultiply:!1}),e.bind(p.LINEAR,p.CLAMP_TO_EDGE);}else r.demTexture=new t.T(d,w,p.RGBA,{premultiply:!1}),r.demTexture.bind(p.LINEAR,p.CLAMP_TO_EDGE);const T=u.getMeshFromTileID(d,x.canonical,l,!0,"raster"),P=null===(h=e.style.map.terrain)||void 0===h?void 0:h.getTerrainData(x),C=_.getProjectionData({overscaledTileID:x,aligned:f,applyGlobeMatrix:!c,applyTerrainMatrix:!0});m.draw(d,p.TRIANGLES,s,o[x.overscaledZ],n,ei.backCCW,aa(a,r.dem,v),P,C,a.id,T.vertexBuffer,T.indexBuffer,T.segments);}}const Rr=[new t.P(0,0),new t.P(t.a5,0),new t.P(t.a5,t.a5),new t.P(0,t.a5)];function Dr(e,t,i,a,r,o,s,n,l=!1,c=!1){const h=a[a.length-1].overscaledZ,u=e.context,d=u.gl,_=e.useProgram("raster"),p=e.transform,m=e.style.projection,f=e.colorModeForRenderPass(),g=!e.options.moving,v=i.paint.get("raster-opacity"),x=i.paint.get("raster-resampling"),b=i.paint.get("raster-fade-duration"),y=!!e.style.map.terrain;for(const w of a){const a=e.getDepthModeForSublayer(w.overscaledZ-h,1===v?ti.ReadWrite:ti.ReadOnly,d.LESS),T=t.getTile(w),P="nearest"===x?d.NEAREST:d.LINEAR;u.activeTexture.set(d.TEXTURE0),T.texture.bind(P,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST),u.activeTexture.set(d.TEXTURE1);const{parentTile:C,parentScaleBy:I,parentTopLeft:M,fadeValues:E}=Ar(T,t,b,y);T.fadeOpacity=E.tileOpacity,C?(C.fadeOpacity=E.parentTileOpacity,C.texture.bind(P,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST)):T.texture.bind(P,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST),T.texture.useMipmap&&u.extTextureFilterAnisotropic&&e.transform.pitch>20&&d.texParameterf(d.TEXTURE_2D,u.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,u.extTextureFilterAnisotropicMax);const S=e.style.map.terrain&&e.style.map.terrain.getTerrainData(w),z=p.getProjectionData({overscaledTileID:w,aligned:g,applyGlobeMatrix:!c,applyTerrainMatrix:!0}),R=ua(M,I,E.fadeMix,i,n),D=m.getMeshFromTileID(u,w.canonical,o,s,"raster");_.draw(u,d.TRIANGLES,a,r?r[w.overscaledZ]:ai.disabled,f,l?ei.frontCCW:ei.backCCW,R,S,z,i.id,D.vertexBuffer,D.indexBuffer,D.segments);}}function Ar(e,i,a,r){const o={parentTile:null,parentScaleBy:1,parentTopLeft:[0,0],fadeValues:{tileOpacity:1,parentTileOpacity:1,fadeMix:{opacity:1,mix:0}}};if(0===a||r)return o;if(e.fadingParentID){const r=i.getLoadedTile(e.fadingParentID);if(!r)return o;const s=Math.pow(2,r.tileID.overscaledZ-e.tileID.overscaledZ),n=[e.tileID.canonical.x*s%1,e.tileID.canonical.y*s%1],l=function(e,i,a){const r=c(),o=(r-i.timeAdded)/a,s=e.fadingDirection===ue.Incoming,n=t.an((r-e.timeAdded)/a,0,1),l=t.an(1-o,0,1),h=s?n:l;return {tileOpacity:h,parentTileOpacity:s?l:n,fadeMix:{opacity:1,mix:1-h}}}(e,r,a);return {parentTile:r,parentScaleBy:s,parentTopLeft:n,fadeValues:l}}if(e.selfFading){const i=function(e,i){const a=(c()-e.timeAdded)/i,r=t.an(a,0,1);return {tileOpacity:r,fadeMix:{opacity:r,mix:0}}}(e,a);return {parentTile:null,parentScaleBy:1,parentTopLeft:[0,0],fadeValues:i}}return o}const Lr=new t.bp(1,0,0,1),kr=new t.bp(0,1,0,1),Fr=new t.bp(0,0,1,1),Br=new t.bp(1,0,1,1),Or=new t.bp(0,1,1,1);function jr(e,t,i,a){Zr(e,0,t+i/2,e.transform.width,i,a);}function Nr(e,t,i,a){Zr(e,t-i/2,0,i,e.transform.height,a);}function Zr(e,t,i,a,r,o){const s=e.context,n=s.gl;n.enable(n.SCISSOR_TEST),n.scissor(t*e.pixelRatio,i*e.pixelRatio,a*e.pixelRatio,r*e.pixelRatio),s.clear({color:o}),n.disable(n.SCISSOR_TEST);}function Gr(e,i,a){const r=e.context,o=r.gl,s=e.useProgram("debug"),n=ti.disabled,l=ai.disabled,c=e.colorModeForRenderPass(),h="$debug",u=e.style.map.terrain&&e.style.map.terrain.getTerrainData(a);r.activeTexture.set(o.TEXTURE0);const d=i.getTileByID(a.key).latestRawTileData,_=Math.floor((d&&d.byteLength||0)/1024),p=i.getTile(a).tileSize,m=512/Math.min(p,512)*(a.overscaledZ/e.transform.zoom)*.5;let f=a.canonical.toString();a.overscaledZ!==a.canonical.z&&(f+=` => ${a.overscaledZ}`),function(e,t){e.initDebugOverlayCanvas();const i=e.debugOverlayCanvas,a=e.context.gl,r=e.debugOverlayCanvas.getContext("2d");r.clearRect(0,0,i.width,i.height),r.shadowColor="white",r.shadowBlur=2,r.lineWidth=1.5,r.strokeStyle="white",r.textBaseline="top",r.font="bold 36px Open Sans, sans-serif",r.fillText(t,5,5),r.strokeText(t,5,5),e.debugOverlayTexture.update(i),e.debugOverlayTexture.bind(a.LINEAR,a.CLAMP_TO_EDGE);}(e,`${f} ${_}kB`);const g=e.transform.getProjectionData({overscaledTileID:a,applyGlobeMatrix:!0,applyTerrainMatrix:!0});s.draw(r,o.TRIANGLES,n,l,Qt.alphaBlended,ei.disabled,Yi(t.bp.transparent,m),null,g,h,e.debugBuffer,e.quadTriangleIndexBuffer,e.debugSegments),s.draw(r,o.LINE_STRIP,n,l,c,ei.disabled,Yi(t.bp.red),u,g,h,e.debugBuffer,e.tileBorderIndexBuffer,e.debugSegments);}function Ur(e,t,i,a){const{isRenderingGlobe:r}=a,o=e.context,s=o.gl,n=e.transform,l=e.colorModeForRenderPass(),c=e.getDepthModeFor3D(),h=e.useProgram("terrain");o.bindFramebuffer.set(null),o.viewport.set([0,0,e.width,e.height]);for(const a of i){const i=t.getTerrainMesh(a.tileID),u=e.renderToTexture.getTexture(a),d=t.getTerrainData(a.tileID);o.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_2D,u.texture);const _=t.getMeshFrameDelta(n.zoom),p=n.calculateFogMatrix(a.tileID.toUnwrapped()),m=Oi(_,p,e.style.sky,n.pitch,r),f=n.getProjectionData({overscaledTileID:a.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});h.draw(o,s.TRIANGLES,c,ai.disabled,l,ei.backCCW,m,d,f,"terrain",i.vertexBuffer,i.indexBuffer,i.segments);}}function Vr(e,i){if(!i.mesh){const a=new t.aW;a.emplaceBack(-1,-1),a.emplaceBack(1,-1),a.emplaceBack(1,1),a.emplaceBack(-1,1);const r=new t.aY;r.emplaceBack(0,1,2),r.emplaceBack(0,2,3),i.mesh=new kt(e.createVertexBuffer(a,Ft.members),e.createIndexBuffer(r),t.aX.simpleSegment(0,0,a.length,r.length));}return i.mesh}class qr{constructor(e,i){this.context=new nr(e),this.transform=i,this._tileTextures={},this.terrainFacilitator={dirty:!0,matrix:t.ar(new Float64Array(16)),renderTime:0},this.setup(),this.numSublayers=ke.maxOverzooming+ke.maxUnderzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.crossTileSymbolIndex=new Rt;}resize(e,t,i){if(this.width=Math.floor(e*i),this.height=Math.floor(t*i),this.pixelRatio=i,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const e of this.style._order)this.style._layers[e].resize();}setup(){const e=this.context,i=new t.aW;i.emplaceBack(0,0),i.emplaceBack(t.a5,0),i.emplaceBack(0,t.a5),i.emplaceBack(t.a5,t.a5),this.tileExtentBuffer=e.createVertexBuffer(i,Ft.members),this.tileExtentSegments=t.aX.simpleSegment(0,0,4,2);const a=new t.aW;a.emplaceBack(0,0),a.emplaceBack(t.a5,0),a.emplaceBack(0,t.a5),a.emplaceBack(t.a5,t.a5),this.debugBuffer=e.createVertexBuffer(a,Ft.members),this.debugSegments=t.aX.simpleSegment(0,0,4,5);const r=new t.ch;r.emplaceBack(0,0,0,0),r.emplaceBack(t.a5,0,t.a5,0),r.emplaceBack(0,t.a5,0,t.a5),r.emplaceBack(t.a5,t.a5,t.a5,t.a5),this.rasterBoundsBuffer=e.createVertexBuffer(r,Fi.members),this.rasterBoundsSegments=t.aX.simpleSegment(0,0,4,2);const o=new t.aW;o.emplaceBack(0,0),o.emplaceBack(t.a5,0),o.emplaceBack(0,t.a5),o.emplaceBack(t.a5,t.a5),this.rasterBoundsBufferPosOnly=e.createVertexBuffer(o,Ft.members),this.rasterBoundsSegmentsPosOnly=t.aX.simpleSegment(0,0,4,5);const s=new t.aW;s.emplaceBack(0,0),s.emplaceBack(1,0),s.emplaceBack(0,1),s.emplaceBack(1,1),this.viewportBuffer=e.createVertexBuffer(s,Ft.members),this.viewportSegments=t.aX.simpleSegment(0,0,4,2);const n=new t.ci;n.emplaceBack(0),n.emplaceBack(1),n.emplaceBack(3),n.emplaceBack(2),n.emplaceBack(0),this.tileBorderIndexBuffer=e.createIndexBuffer(n);const l=new t.aY;l.emplaceBack(1,0,2),l.emplaceBack(1,2,3),this.quadTriangleIndexBuffer=e.createIndexBuffer(l);const c=this.context.gl;this.stencilClearMode=new ai({func:c.ALWAYS,mask:0},0,255,c.ZERO,c.ZERO,c.ZERO),this.tileExtentMesh=new kt(this.tileExtentBuffer,this.quadTriangleIndexBuffer,this.tileExtentSegments);}clearStencil(){const e=this.context,i=e.gl;this.nextStencilID=1,this.currentStencilSource=void 0;const a=t.N();t.c7(a,0,this.width,this.height,0,0,1),t.Q(a,a,[i.drawingBufferWidth,i.drawingBufferHeight,0]);const r={mainMatrix:a,tileMercatorCoords:[0,0,1,1],clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:a};this.useProgram("clippingMask",null,!0).draw(e,i.TRIANGLES,ti.disabled,this.stencilClearMode,Qt.disabled,ei.disabled,null,null,r,"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments);}_renderTileClippingMasks(e,t,i){if(this.currentStencilSource===e.source||!e.isTileClipped()||!t||!t.length)return;this.currentStencilSource=e.source,this.nextStencilID+t.length>256&&this.clearStencil();const a=this.context;a.setColorMode(Qt.disabled),a.setDepthMode(ti.disabled);const r={};for(const e of t)r[e.key]=this.nextStencilID++;this._renderTileMasks(r,t,i,!0),this._renderTileMasks(r,t,i,!1),this._tileClippingMaskIDs=r;}_renderTileMasks(e,t,i,a){const r=this.context,o=r.gl,s=this.style.projection,n=this.transform,l=this.useProgram("clippingMask");for(const c of t){const t=e[c.key],h=this.style.map.terrain&&this.style.map.terrain.getTerrainData(c),u=s.getMeshFromTileID(this.context,c.canonical,a,!0,"stencil"),d=n.getProjectionData({overscaledTileID:c,applyGlobeMatrix:!i,applyTerrainMatrix:!0});l.draw(r,o.TRIANGLES,ti.disabled,new ai({func:o.ALWAYS,mask:0},t,255,o.KEEP,o.KEEP,o.REPLACE),Qt.disabled,i?ei.disabled:ei.backCCW,null,h,d,"$clipping",u.vertexBuffer,u.indexBuffer,u.segments);}}_renderTilesDepthBuffer(){const e=this.context,t=e.gl,i=this.style.projection,a=this.transform,r=this.useProgram("depth"),o=this.getDepthModeFor3D(),s=Ie(a,{tileSize:a.tileSize});for(const n of s){const s=this.style.map.terrain&&this.style.map.terrain.getTerrainData(n),l=i.getMeshFromTileID(this.context,n.canonical,!0,!0,"raster"),c=a.getProjectionData({overscaledTileID:n,applyGlobeMatrix:!0,applyTerrainMatrix:!0});r.draw(e,t.TRIANGLES,o,ai.disabled,Qt.disabled,ei.backCCW,null,s,c,"$clipping",l.vertexBuffer,l.indexBuffer,l.segments);}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const e=this.nextStencilID++,t=this.context.gl;return new ai({func:t.NOTEQUAL,mask:255},e,255,t.KEEP,t.KEEP,t.REPLACE)}stencilModeForClipping(e){const t=this.context.gl;return new ai({func:t.EQUAL,mask:255},this._tileClippingMaskIDs[e.key],0,t.KEEP,t.KEEP,t.REPLACE)}getStencilConfigForOverlapAndUpdateStencilID(e){const t=this.context.gl,i=e.sort(((e,t)=>t.overscaledZ-e.overscaledZ)),a=i[i.length-1].overscaledZ,r=i[0].overscaledZ-a+1;if(r>1){this.currentStencilSource=void 0,this.nextStencilID+r>256&&this.clearStencil();const e={};for(let i=0;i<r;i++)e[i+a]=new ai({func:t.GEQUAL,mask:255},i+this.nextStencilID,255,t.KEEP,t.KEEP,t.REPLACE);return this.nextStencilID+=r,[e,i]}return [{[a]:ai.disabled},i]}stencilConfigForOverlapTwoPass(e){const t=this.context.gl,i=e.sort(((e,t)=>t.overscaledZ-e.overscaledZ)),a=i[i.length-1].overscaledZ,r=i[0].overscaledZ-a+1;if(this.clearStencil(),r>1){const e={},o={};for(let i=0;i<r;i++)e[i+a]=new ai({func:t.GREATER,mask:255},r+1+i,255,t.KEEP,t.KEEP,t.REPLACE),o[i+a]=new ai({func:t.GREATER,mask:255},1+i,255,t.KEEP,t.KEEP,t.REPLACE);return this.nextStencilID=2*r+1,[e,o,i]}return this.nextStencilID=3,[{[a]:new ai({func:t.GREATER,mask:255},2,255,t.KEEP,t.KEEP,t.REPLACE)},{[a]:new ai({func:t.GREATER,mask:255},1,255,t.KEEP,t.KEEP,t.REPLACE)},i]}colorModeForRenderPass(){const e=this.context.gl;if(this._showOverdrawInspector){const i=1/8;return new Qt([e.CONSTANT_COLOR,e.ONE],new t.bp(i,i,i,0),[!0,!0,!0,!0])}return "opaque"===this.renderPass?Qt.unblended:Qt.alphaBlended}getDepthModeForSublayer(e,t,i){if(!this.opaquePassEnabledForLayer())return ti.disabled;const a=1-((1+this.currentLayer)*this.numSublayers+e)*this.depthEpsilon;return new ti(i||this.context.gl.LEQUAL,t,[a,a])}getDepthModeFor3D(){return new ti(this.context.gl.LEQUAL,ti.ReadWrite,this.depthRangeFor3D)}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(e,i){var a,r;this.style=e,this.options=i,this.lineAtlas=e.lineAtlas,this.imageManager=e.imageManager,this.glyphManager=e.glyphManager,this.symbolFadeChange=e.placement.symbolFadeChange(c()),this.imageManager.beginFrame();const o=this.style._order,s=this.style.tileManagers,n={},l={},h={},u={isRenderingToTexture:!1,isRenderingGlobe:(null===(a=e.projection)||void 0===a?void 0:a.transitionState)>0};for(const e in s){const t=s[e];t.used&&t.prepare(this.context),n[e]=t.getVisibleCoordinates(!1),l[e]=n[e].slice().reverse(),h[e]=t.getVisibleCoordinates(!0).reverse();}this.opaquePassCutoff=1/0;for(let e=0;e<o.length;e++)if(this.style._layers[o[e]].is3D()){this.opaquePassCutoff=e;break}this.maybeDrawDepthAndCoords(!1),this.renderToTexture&&(this.renderToTexture.prepareForRender(this.style,this.transform.zoom),this.opaquePassCutoff=0),this.renderPass="offscreen";for(const e of o){const t=this.style._layers[e];if(!t.hasOffscreenPass()||t.isHidden(this.transform.zoom))continue;const i=l[t.source];("custom"===t.type||i.length)&&this.renderLayer(this,s[t.source],t,i,u);}if(null===(r=this.style.projection)||void 0===r||r.updateGPUdependent({context:this.context,useProgram:e=>this.useProgram(e)}),this.context.viewport.set([0,0,this.width,this.height]),this.context.bindFramebuffer.set(null),this.context.clear({color:i.showOverdrawInspector?t.bp.black:t.bp.transparent,depth:1}),this.clearStencil(),this.style.sky&&function(e,t){const i=e.context,a=i.gl,r=((e,t,i)=>{const a=Math.cos(t.rollInRadians),r=Math.sin(t.rollInRadians),o=ge(t),s=t.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}).projectionTransition;return {u_sky_color:e.properties.get("sky-color"),u_horizon_color:e.properties.get("horizon-color"),u_horizon:[(t.width/2-o*r)*i,(t.height/2+o*a)*i],u_horizon_normal:[-r,a],u_sky_horizon_blend:e.properties.get("sky-horizon-blend")*t.height/2*i,u_sky_blend:s}})(t,e.style.map.transform,e.pixelRatio),o=new ti(a.LEQUAL,ti.ReadWrite,[0,1]),s=ai.disabled,n=e.colorModeForRenderPass(),l=e.useProgram("sky"),c=Vr(i,t);l.draw(i,a.TRIANGLES,o,s,n,ei.disabled,r,null,void 0,"sky",c.vertexBuffer,c.indexBuffer,c.segments);}(this,this.style.sky),this._showOverdrawInspector=i.showOverdrawInspector,this.depthRangeFor3D=[0,1-(e._order.length+2)*this.numSublayers*this.depthEpsilon],!this.renderToTexture)for(this.renderPass="opaque",this.currentLayer=o.length-1;this.currentLayer>=0;this.currentLayer--){const e=this.style._layers[o[this.currentLayer]],t=s[e.source],i=n[e.source];this._renderTileClippingMasks(e,i,!1),this.renderLayer(this,t,e,i,u);}this.renderPass="translucent";let d=!1;for(this.currentLayer=0;this.currentLayer<o.length;this.currentLayer++){const e=this.style._layers[o[this.currentLayer]],t=s[e.source];if(this.renderToTexture&&this.renderToTexture.renderLayer(e,u))continue;this.opaquePassEnabledForLayer()||d||(d=!0,u.isRenderingGlobe&&!this.style.map.terrain&&this._renderTilesDepthBuffer());const i=("symbol"===e.type?h:l)[e.source];this._renderTileClippingMasks(e,n[e.source],!!this.renderToTexture),this.renderLayer(this,t,e,i,u);}if(u.isRenderingGlobe&&function(e,i,a){const r=e.context,o=r.gl,s=e.useProgram("atmosphere"),n=new ti(o.LEQUAL,ti.ReadOnly,[0,1]),l=e.transform,c=function(e,i){const a=e.properties.get("position"),r=[-a.x,-a.y,-a.z],o=t.ar(new Float64Array(16));return "map"===e.properties.get("anchor")&&(t.bg(o,o,i.rollInRadians),t.bh(o,o,-i.pitchInRadians),t.bg(o,o,i.bearingInRadians),t.bh(o,o,i.center.lat*Math.PI/180),t.bJ(o,o,-i.center.lng*Math.PI/180)),t.cg(r,r,o),r}(a,e.transform),h=l.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),u=i.properties.get("atmosphere-blend")*h.projectionTransition;if(0===u)return;const d=fi(l.worldSize,l.center.lat),_=l.inverseProjectionMatrix,p=new Float64Array(4);p[3]=1,t.aH(p,p,l.modelViewProjectionMatrix),p[0]/=p[3],p[1]/=p[3],p[2]/=p[3],p[3]=1,t.aH(p,p,_),p[0]/=p[3],p[1]/=p[3],p[2]/=p[3],p[3]=1;const m=((e,t,i,a,r)=>({u_sun_pos:e,u_atmosphere_blend:t,u_globe_position:i,u_globe_radius:a,u_inv_proj_matrix:r}))(c,u,[p[0],p[1],p[2]],d,_),f=Vr(r,i);s.draw(r,o.TRIANGLES,n,ai.disabled,Qt.alphaBlended,ei.disabled,m,null,null,"atmosphere",f.vertexBuffer,f.indexBuffer,f.segments);}(this,this.style.sky,this.style.light),this.options.showTileBoundaries){const e=function(e,t){let i=null;const a=Object.values(e._layers).flatMap((i=>i.source&&!i.isHidden(t)?[e.tileManagers[i.source]]:[])),r=a.filter((e=>"vector"===e.getSource().type)),o=a.filter((e=>"vector"!==e.getSource().type)),s=e=>{(!i||i.getSource().maxzoom<e.getSource().maxzoom)&&(i=e);};return r.forEach((e=>s(e))),i||o.forEach((e=>s(e))),i}(this.style,this.transform.zoom);e&&function(e,t,i){for(let a=0;a<i.length;a++)Gr(e,t,i[a]);}(this,e,e.getVisibleCoordinates());}this.options.showPadding&&function(e){const t=e.transform.padding;jr(e,e.transform.height-(t.top||0),3,Lr),jr(e,t.bottom||0,3,kr),Nr(e,t.left||0,3,Fr),Nr(e,e.transform.width-(t.right||0),3,Br);const i=e.transform.centerPoint;!function(e,t,i,a){Zr(e,t-1,i-10,2,20,a),Zr(e,t-10,i-1,20,2,a);}(e,i.x,e.transform.height-i.y,Or);}(this),this.context.setDefault();}maybeDrawDepthAndCoords(e){if(!this.style||!this.style.map||!this.style.map.terrain)return;const i=this.terrainFacilitator.matrix,a=this.transform.modelViewProjectionMatrix;let r=this.terrainFacilitator.dirty;r||(r=e?!t.cj(i,a):!t.ck(i,a)),r||(r=this.style.map.terrain.tileManager.anyTilesAfterTime(this.terrainFacilitator.renderTime)),r&&(t.cl(i,a),this.terrainFacilitator.renderTime=Date.now(),this.terrainFacilitator.dirty=!1,function(e,i){const a=e.context,r=a.gl,o=e.transform,s=Qt.unblended,n=new ti(r.LEQUAL,ti.ReadWrite,[0,1]),l=i.tileManager.getRenderableTiles(),c=e.useProgram("terrainDepth");a.bindFramebuffer.set(i.getFramebuffer("depth").framebuffer),a.viewport.set([0,0,e.width/devicePixelRatio,e.height/devicePixelRatio]),a.clear({color:t.bp.transparent,depth:1});for(const e of l){const t=i.getTerrainMesh(e.tileID),l=i.getTerrainData(e.tileID),h=o.getProjectionData({overscaledTileID:e.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0}),u={u_ele_delta:i.getMeshFrameDelta(o.zoom)};c.draw(a,r.TRIANGLES,n,ai.disabled,s,ei.backCCW,u,l,h,"terrain",t.vertexBuffer,t.indexBuffer,t.segments);}a.bindFramebuffer.set(null),a.viewport.set([0,0,e.width,e.height]);}(this,this.style.map.terrain),function(e,i){const a=e.context,r=a.gl,o=e.transform,s=Qt.unblended,n=new ti(r.LEQUAL,ti.ReadWrite,[0,1]),l=i.getCoordsTexture(),c=i.tileManager.getRenderableTiles(),h=e.useProgram("terrainCoords");a.bindFramebuffer.set(i.getFramebuffer("coords").framebuffer),a.viewport.set([0,0,e.width/devicePixelRatio,e.height/devicePixelRatio]),a.clear({color:t.bp.transparent,depth:1}),i.coordsIndex=[];for(const e of c){const t=i.getTerrainMesh(e.tileID),c=i.getTerrainData(e.tileID);a.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,l.texture);const u={u_terrain_coords_id:(255-i.coordsIndex.length)/255,u_texture:0,u_ele_delta:i.getMeshFrameDelta(o.zoom)},d=o.getProjectionData({overscaledTileID:e.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});h.draw(a,r.TRIANGLES,n,ai.disabled,s,ei.backCCW,u,c,d,"terrain",t.vertexBuffer,t.indexBuffer,t.segments),i.coordsIndex.push(e.tileID.key);}a.bindFramebuffer.set(null),a.viewport.set([0,0,e.width,e.height]);}(this,this.style.map.terrain));}renderLayer(e,i,a,r,o){a.isHidden(this.transform.zoom)||("background"===a.type||"custom"===a.type||(r||[]).length)&&(this.id=a.id,t.cm(a)?function(e,i,a,r,o,s){if("translucent"!==e.renderPass)return;const{isRenderingToTexture:n}=s,l=ai.disabled,c=e.colorModeForRenderPass();(a._unevaluatedLayout.hasValue("text-variable-anchor")||a._unevaluatedLayout.hasValue("text-variable-anchor-offset"))&&function(e,i,a,r,o,s,n,l,c){const h=i.transform,u=i.style.map.terrain,d="map"===o,_="map"===s;for(const o of e){const e=r.getTile(o),s=e.getBucket(a);if(!s||!s.text||!s.text.segments.get().length)continue;const p=t.ay(s.textSizeData,h.zoom),m=t.aN(e,1,i.transform.zoom),f=je(d,i.transform,m),g="none"!==a.layout.get("icon-text-fit")&&s.hasIconData();if(p){const i=Math.pow(2,h.zoom-e.tileID.overscaledZ),a=u?(e,t)=>u.getElevation(o,e,t):null;_r(s,d,_,c,h,f,i,p,g,t.aO(h,e,n,l),o.toUnwrapped(),a);}}}(r,e,a,i,a.layout.get("text-rotation-alignment"),a.layout.get("text-pitch-alignment"),a.paint.get("text-translate"),a.paint.get("text-translate-anchor"),o),0!==a.paint.get("icon-opacity").constantOr(1)&&mr(e,i,a,r,!1,a.paint.get("icon-translate"),a.paint.get("icon-translate-anchor"),a.layout.get("icon-rotation-alignment"),a.layout.get("icon-pitch-alignment"),a.layout.get("icon-keep-upright"),l,c,n),0!==a.paint.get("text-opacity").constantOr(1)&&mr(e,i,a,r,!0,a.paint.get("text-translate"),a.paint.get("text-translate-anchor"),a.layout.get("text-rotation-alignment"),a.layout.get("text-pitch-alignment"),a.layout.get("text-keep-upright"),l,c,n),i.map.showCollisionBoxes&&(cr(e,i,a,r,!0),cr(e,i,a,r,!1));}(e,i,a,r,this.style.placement.variableOffsets,o):t.cn(a)?function(e,i,a,r,o){if("translucent"!==e.renderPass)return;const{isRenderingToTexture:s}=o,n=a.paint.get("circle-opacity"),l=a.paint.get("circle-stroke-width"),c=a.paint.get("circle-stroke-opacity"),h=!a.layout.get("circle-sort-key").isConstant();if(0===n.constantOr(1)&&(0===l.constantOr(1)||0===c.constantOr(1)))return;const u=e.context,d=u.gl,_=e.transform,p=e.getDepthModeForSublayer(0,ti.ReadOnly),m=ai.disabled,f=e.colorModeForRenderPass(),g=[],v=_.getCircleRadiusCorrection();for(let o=0;o<r.length;o++){const n=r[o],l=i.getTile(n),c=l.getBucket(a);if(!c)continue;const u=a.paint.get("circle-translate"),d=a.paint.get("circle-translate-anchor"),p=t.aO(_,l,u,d),m=c.programConfigurations.get(a.id),f=e.useProgram("circle",m),x=c.layoutVertexBuffer,b=c.indexBuffer,y=e.style.map.terrain&&e.style.map.terrain.getTerrainData(n),w={programConfiguration:m,program:f,layoutVertexBuffer:x,indexBuffer:b,uniformValues:Hi(e,l,a,p,v),terrainData:y,projectionData:_.getProjectionData({overscaledTileID:n,applyGlobeMatrix:!s,applyTerrainMatrix:!0})};if(h){const e=c.segments.get();for(const i of e)g.push({segments:new t.aX([i]),sortKey:i.sortKey,state:w});}else g.push({segments:c.segments,sortKey:0,state:w});}h&&g.sort(((e,t)=>e.sortKey-t.sortKey));for(const t of g){const{programConfiguration:i,program:r,layoutVertexBuffer:o,indexBuffer:s,uniformValues:n,terrainData:l,projectionData:c}=t.state;r.draw(u,d.TRIANGLES,p,m,f,ei.backCCW,n,l,c,a.id,o,s,t.segments,a.paint,e.transform.zoom,i);}}(e,i,a,r,o):t.co(a)?function(e,i,a,r,o){if(0===a.paint.get("heatmap-opacity"))return;const s=e.context,{isRenderingToTexture:n,isRenderingGlobe:l}=o;if(e.style.map.terrain){for(const t of r){const r=i.getTile(t);i.hasRenderableParent(t)||("offscreen"===e.renderPass?gr(e,r,a,t,l):"translucent"===e.renderPass&&vr(e,a,t,n,l));}s.viewport.set([0,0,e.width,e.height]);}else "offscreen"===e.renderPass?function(e,i,a,r){const o=e.context,s=o.gl,n=e.transform,l=ai.disabled,c=new Qt([s.ONE,s.ONE],t.bp.transparent,[!0,!0,!0,!0]);((function(e,i,a){const r=e.gl;e.activeTexture.set(r.TEXTURE1),e.viewport.set([0,0,i.width/4,i.height/4]);let o=a.heatmapFbos.get(t.cd);o?(r.bindTexture(r.TEXTURE_2D,o.colorAttachment.get()),e.bindFramebuffer.set(o.framebuffer)):(o=xr(e,i.width/4,i.height/4),a.heatmapFbos.set(t.cd,o));}))(o,e,a),o.clear({color:t.bp.transparent});for(let t=0;t<r.length;t++){const h=r[t];if(i.hasRenderableParent(h))continue;const u=i.getTile(h),d=u.getBucket(a);if(!d)continue;const _=d.programConfigurations.get(a.id),p=e.useProgram("heatmap",_),m=n.getProjectionData({overscaledTileID:h,applyGlobeMatrix:!0,applyTerrainMatrix:!1}),f=n.getCircleRadiusCorrection();p.draw(o,s.TRIANGLES,ti.disabled,l,c,ei.backCCW,Qi(u,n.zoom,a.paint.get("heatmap-intensity"),f),null,m,a.id,d.layoutVertexBuffer,d.indexBuffer,d.segments,a.paint,n.zoom,_);}o.viewport.set([0,0,e.width,e.height]);}(e,i,a,r):"translucent"===e.renderPass&&function(e,i){const a=e.context,r=a.gl;a.setColorMode(e.colorModeForRenderPass());const o=i.heatmapFbos.get(t.cd);o&&(a.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,o.colorAttachment.get()),a.activeTexture.set(r.TEXTURE1),br(a,i).bind(r.LINEAR,r.CLAMP_TO_EDGE),e.useProgram("heatmapTexture").draw(a,r.TRIANGLES,ti.disabled,ai.disabled,e.colorModeForRenderPass(),ei.disabled,Ji(e,i,0,1),null,null,i.id,e.viewportBuffer,e.quadTriangleIndexBuffer,e.viewportSegments,i.paint,e.transform.zoom));}(e,a);}(e,i,a,r,o):t.cp(a)?function(e,t,i,a,r){if("translucent"!==e.renderPass)return;const{isRenderingToTexture:o}=r,s=i.paint.get("line-opacity"),n=i.paint.get("line-width");if(0===s.constantOr(1)||0===n.constantOr(1))return;const l=e.getDepthModeForSublayer(0,ti.ReadOnly),c=e.colorModeForRenderPass(),h=i.paint.get("line-dasharray"),u=h.constantOr(1),d=i.paint.get("line-pattern"),_=d.constantOr(1),p=i.paint.get("line-gradient"),m=i.getCrossfadeParameters();let f;f=_?"linePattern":u&&p?"lineGradientSDF":u?"lineSDF":p?"lineGradient":"line";const g=e.context,v=g.gl,x=e.transform;let b=!0;for(const r of a){const a=t.getTile(r);if(_&&!a.patternsLoaded())continue;const s=a.getBucket(i);if(!s)continue;const n=s.programConfigurations.get(i.id),y=e.context.program.get(),w=e.useProgram(f,n),T=b||w.program!==y,P=e.style.map.terrain&&e.style.map.terrain.getTerrainData(r),C=d.constantOr(null),I=h&&h.constantOr(null);if(C&&a.imageAtlas){const e=a.imageAtlas,t=e.patternPositions[C.to.toString()],i=e.patternPositions[C.from.toString()];t&&i&&n.setConstantPatternPositions(t,i);}else if(I){const t="round"===i.layout.get("line-cap"),a=e.lineAtlas.getDash(I.to,t),r=e.lineAtlas.getDash(I.from,t);n.setConstantDashPositions(a,r);}const M=x.getProjectionData({overscaledTileID:r,applyGlobeMatrix:!o,applyTerrainMatrix:!0}),E=x.getPixelScale();let S;_?(S=sa(e,a,i,E,m),wr(g,v,a,n,m)):u&&p?(S=la(e,a,i,E,m,s.lineClipsArray.length),Cr(e,t,g,v,i,s,r,n,m)):u?(S=na(e,a,i,E,m),Tr(e,g,v,n,T,m)):p?(S=oa(e,a,i,E,s.lineClipsArray.length),Pr(e,t,g,v,i,s,r)):S=ra(e,a,i,E);const z=e.stencilModeForClipping(r);w.draw(g,v.TRIANGLES,l,z,c,ei.disabled,S,P,M,i.id,s.layoutVertexBuffer,s.indexBuffer,s.segments,i.paint,e.transform.zoom,n,s.layoutVertexBuffer2),b=!1;}}(e,i,a,r,o):t.cq(a)?function(e,i,a,r,o){const s=a.paint.get("fill-color"),n=a.paint.get("fill-opacity");if(0===n.constantOr(1))return;const{isRenderingToTexture:l}=o,c=e.colorModeForRenderPass(),h=a.paint.get("fill-pattern"),u=e.opaquePassEnabledForLayer()&&!h.constantOr(1)&&1===s.constantOr(t.bp.transparent).a&&1===n.constantOr(0)?"opaque":"translucent";if(e.renderPass===u){const t=e.getDepthModeForSublayer(1,"opaque"===e.renderPass?ti.ReadWrite:ti.ReadOnly);Mr(e,i,a,r,t,c,!1,l);}if("translucent"===e.renderPass&&a.paint.get("fill-antialias")){const t=e.getDepthModeForSublayer(a.getPaintProperty("fill-outline-color")?2:0,ti.ReadOnly);Mr(e,i,a,r,t,c,!0,l);}}(e,i,a,r,o):t.cr(a)?function(e,t,i,a,r){const o=i.paint.get("fill-extrusion-opacity");if(0===o)return;const{isRenderingToTexture:s}=r;if("translucent"===e.renderPass){const r=new ti(e.context.gl.LEQUAL,ti.ReadWrite,e.depthRangeFor3D);if(1!==o||i.paint.get("fill-extrusion-pattern").constantOr(1))Er(e,t,i,a,r,ai.disabled,Qt.disabled,s),Er(e,t,i,a,r,e.stencilModeFor3D(),e.colorModeForRenderPass(),s);else {const o=e.colorModeForRenderPass();Er(e,t,i,a,r,ai.disabled,o,s);}}}(e,i,a,r,o):t.cs(a)?function(e,i,a,r,o){if("offscreen"!==e.renderPass&&"translucent"!==e.renderPass)return;const{isRenderingToTexture:s}=o,n=e.context,l=e.style.projection.useSubdivision,c=e.getDepthModeForSublayer(0,ti.ReadOnly),h=e.colorModeForRenderPass();if("offscreen"===e.renderPass)!function(e,i,a,r,o,s,n){const l=e.context,c=l.gl;for(const h of a){const a=i.getTile(h),u=a.dem;if(!u||!u.data)continue;if(!a.needsHillshadePrepare)continue;const d=u.dim,_=u.stride,p=u.getPixels();if(l.activeTexture.set(c.TEXTURE1),l.pixelStoreUnpackPremultiplyAlpha.set(!1),a.demTexture=a.demTexture||e.getTileTexture(_),a.demTexture){const e=a.demTexture;e.update(p,{premultiply:!1}),e.bind(c.NEAREST,c.CLAMP_TO_EDGE);}else a.demTexture=new t.T(l,p,c.RGBA,{premultiply:!1}),a.demTexture.bind(c.NEAREST,c.CLAMP_TO_EDGE);l.activeTexture.set(c.TEXTURE0);let m=a.fbo;if(!m){const e=new t.T(l,{width:d,height:d,data:null},c.RGBA);e.bind(c.LINEAR,c.CLAMP_TO_EDGE),m=a.fbo=l.createFramebuffer(d,d,!0,!1),m.colorAttachment.set(e.texture);}l.bindFramebuffer.set(m.framebuffer),l.viewport.set([0,0,d,d]),e.useProgram("hillshadePrepare").draw(l,c.TRIANGLES,o,s,n,ei.disabled,ta(a.tileID,u),null,null,r.id,e.rasterBoundsBuffer,e.quadTriangleIndexBuffer,e.rasterBoundsSegments),a.needsHillshadePrepare=!1;}}(e,i,r,a,c,ai.disabled,h),n.viewport.set([0,0,e.width,e.height]);else if("translucent"===e.renderPass)if(l){const[t,o,n]=e.stencilConfigForOverlapTwoPass(r);Sr(e,i,a,n,t,c,h,!1,s),Sr(e,i,a,n,o,c,h,!0,s);}else {const[t,o]=e.getStencilConfigForOverlapAndUpdateStencilID(r);Sr(e,i,a,o,t,c,h,!1,s);}}(e,i,a,r,o):t.ct(a)?function(e,t,i,a,r){if("translucent"!==e.renderPass)return;if(!a.length)return;const{isRenderingToTexture:o}=r,s=e.style.projection.useSubdivision,n=e.getDepthModeForSublayer(0,ti.ReadOnly),l=e.colorModeForRenderPass();if(s){const[r,s,c]=e.stencilConfigForOverlapTwoPass(a);zr(e,t,i,c,r,n,l,!1,o),zr(e,t,i,c,s,n,l,!0,o);}else {const[r,s]=e.getStencilConfigForOverlapAndUpdateStencilID(a);zr(e,t,i,s,r,n,l,!1,o);}}(e,i,a,r,o):t.bU(a)?function(e,t,i,a,r){if("translucent"!==e.renderPass)return;if(0===i.paint.get("raster-opacity"))return;if(!a.length)return;const{isRenderingToTexture:o}=r,s=t.getSource(),n=e.style.projection.useSubdivision;if(s instanceof te)Dr(e,t,i,a,null,!1,!1,s.tileCoords,s.flippedWindingOrder,o);else if(n){const[r,s,n]=e.stencilConfigForOverlapTwoPass(a);Dr(e,t,i,n,r,!1,!0,Rr,!1,o),Dr(e,t,i,n,s,!0,!0,Rr,!1,o);}else {const[r,s]=e.getStencilConfigForOverlapAndUpdateStencilID(a);Dr(e,t,i,s,r,!1,!0,Rr,!1,o);}}(e,i,a,r,o):t.cu(a)?function(e,t,i,a,r){const o=i.paint.get("background-color"),s=i.paint.get("background-opacity");if(0===s)return;const{isRenderingToTexture:n}=r,l=e.context,c=l.gl,h=e.style.projection,u=e.transform,d=u.tileSize,_=i.paint.get("background-pattern");if(e.isPatternMissing(_))return;const p=!_&&1===o.a&&1===s&&e.opaquePassEnabledForLayer()?"opaque":"translucent";if(e.renderPass!==p)return;const m=ai.disabled,f=e.getDepthModeForSublayer(0,"opaque"===p?ti.ReadWrite:ti.ReadOnly),g=e.colorModeForRenderPass(),v=e.useProgram(_?"backgroundPattern":"background"),x=a||Ie(u,{tileSize:d,terrain:e.style.map.terrain});_&&(l.activeTexture.set(c.TEXTURE0),e.imageManager.bind(e.context));const b=i.getCrossfadeParameters();for(const t of x){const a=u.getProjectionData({overscaledTileID:t,applyGlobeMatrix:!n,applyTerrainMatrix:!0}),r=_?ga(s,e,_,{tileID:t,tileSize:d},b):fa(s,o),p=e.style.map.terrain&&e.style.map.terrain.getTerrainData(t),x=h.getMeshFromTileID(l,t.canonical,!1,!0,"raster");v.draw(l,c.TRIANGLES,f,m,g,ei.backCCW,r,p,a,i.id,x.vertexBuffer,x.indexBuffer,x.segments);}}(e,0,a,r,o):t.cv(a)&&function(e,t,i,a){const{isRenderingGlobe:r}=a,o=e.context,s=i.implementation,n=e.style.projection,l=e.transform,c=l.getProjectionDataForCustomLayer(r),h={farZ:l.farZ,nearZ:l.nearZ,fov:l.fov*Math.PI/180,modelViewProjectionMatrix:l.modelViewProjectionMatrix,projectionMatrix:l.projectionMatrix,shaderData:{variantName:n.shaderVariantName,vertexShaderPrelude:`const float PI = 3.141592653589793;\nuniform mat4 u_projection_matrix;\n${n.shaderPreludeCode.vertexSource}`,define:n.shaderDefine},defaultProjectionData:c},u=s.renderingMode?s.renderingMode:"2d";if("offscreen"===e.renderPass){const t=s.prerender;t&&(e.setCustomLayerDefaults(),o.setColorMode(e.colorModeForRenderPass()),t.call(s,o.gl,h),o.setDirty(),e.setBaseState());}else if("translucent"===e.renderPass){e.setCustomLayerDefaults(),o.setColorMode(e.colorModeForRenderPass()),o.setStencilMode(ai.disabled);const t="3d"===u?e.getDepthModeFor3D():e.getDepthModeForSublayer(0,ti.ReadOnly);o.setDepthMode(t),s.render(o.gl,h),o.setDirty(),e.setBaseState(),o.bindFramebuffer.set(null);}}(e,0,a,o));}saveTileTexture(e){const t=this._tileTextures[e.size[0]];t?t.push(e):this._tileTextures[e.size[0]]=[e];}getTileTexture(e){const t=this._tileTextures[e];return t&&t.length>0?t.pop():null}isPatternMissing(e){if(!e)return !1;if(!e.from||!e.to)return !0;const t=this.imageManager.getPattern(e.from.toString()),i=this.imageManager.getPattern(e.to.toString());return !t||!i}useProgram(e,t,i=!1,a=[]){this.cache=this.cache||{};const r=!!this.style.map.terrain,o=this.style.projection,s=i?At.projectionMercator:o.shaderPreludeCode,n=i?Bt:o.shaderDefine,l=e+(t?t.cacheKey:"")+`/${i?Ot:o.shaderVariantName}`+(this._showOverdrawInspector?"/overdraw":"")+(r?"/terrain":"")+(a?`/${a.join("/")}`:"");return this.cache[l]||(this.cache[l]=new Zi(this.context,At[e],t,xa[e],this._showOverdrawInspector,r,s,n,a)),this.cache[l]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault();}setBaseState(){const e=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(e.FUNC_ADD);}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new t.T(this.context,this.debugOverlayCanvas,this.context.gl.RGBA));}destroy(){var e,t;if(this._tileTextures){for(const e in this._tileTextures){const t=this._tileTextures[e];if(t)for(const e of t)e.destroy();}this._tileTextures={};}if(this.tileExtentBuffer&&this.tileExtentBuffer.destroy(),this.debugBuffer&&this.debugBuffer.destroy(),this.rasterBoundsBuffer&&this.rasterBoundsBuffer.destroy(),this.rasterBoundsBufferPosOnly&&this.rasterBoundsBufferPosOnly.destroy(),this.viewportBuffer&&this.viewportBuffer.destroy(),this.tileBorderIndexBuffer&&this.tileBorderIndexBuffer.destroy(),this.quadTriangleIndexBuffer&&this.quadTriangleIndexBuffer.destroy(),this.tileExtentMesh&&(null===(e=this.tileExtentMesh.vertexBuffer)||void 0===e||e.destroy()),this.tileExtentMesh&&(null===(t=this.tileExtentMesh.indexBuffer)||void 0===t||t.destroy()),this.debugOverlayTexture&&this.debugOverlayTexture.destroy(),this.cache){for(const e in this.cache){const t=this.cache[e];t&&t.program&&this.context.gl.deleteProgram(t.program);}this.cache={};}this.context&&this.context.setDefault();}overLimit(){const{drawingBufferWidth:e,drawingBufferHeight:t}=this.context.gl;return this.width!==e||this.height!==t}}function Wr(e,t){let i,a=!1,r=null,o=null;const s=()=>{r=null,a&&(e.apply(o,i),r=setTimeout(s,t),a=!1);};return (...e)=>(a=!0,o=this,i=e,r||s(),r)}class $r{constructor(e){this._getCurrentHash=()=>{const e=window.location.hash.replace("#","");if(this._hashName){let t;return e.split("&").map((e=>e.split("="))).forEach((e=>{e[0]===this._hashName&&(t=e);})),(t&&t[1]||"").split("/")}return e.split("/")},this._onHashChange=()=>{const e=this._getCurrentHash();if(!this._isValidHash(e))return !1;const t=this._map.dragRotate.isEnabled()&&this._map.touchZoomRotate.isEnabled()?+(e[3]||0):this._map.getBearing();return this._map.jumpTo({center:[+e[2],+e[1]],zoom:+e[0],bearing:t,pitch:+(e[4]||0)}),!0},this._updateHashUnthrottled=()=>{const e=window.location.href.replace(/(#.*)?$/,this.getHashString());window.history.replaceState(window.history.state,null,e);},this._removeHash=()=>{const e=this._getCurrentHash();if(0===e.length)return;const t=e.join("/");let i=t;i.split("&").length>0&&(i=i.split("&")[0]),this._hashName&&(i=`${this._hashName}=${t}`);let a=window.location.hash.replace(i,"");a.startsWith("#&")?a=a.slice(0,1)+a.slice(2):"#"===a&&(a="");let r=window.location.href.replace(/(#.+)?$/,a);r=r.replace("&&","&"),window.history.replaceState(window.history.state,null,r);},this._updateHash=Wr(this._updateHashUnthrottled,300),this._hashName=e&&encodeURIComponent(e);}addTo(e){return this._map=e,addEventListener("hashchange",this._onHashChange,!1),this._map.on("moveend",this._updateHash),this}remove(){return removeEventListener("hashchange",this._onHashChange,!1),this._map.off("moveend",this._updateHash),clearTimeout(this._updateHash()),this._removeHash(),delete this._map,this}getHashString(e){const t=this._map.getCenter(),i=Math.round(100*this._map.getZoom())/100,a=Math.ceil((i*Math.LN2+Math.log(512/360/.5))/Math.LN10),r=Math.pow(10,a),o=Math.round(t.lng*r)/r,s=Math.round(t.lat*r)/r,n=this._map.getBearing(),l=this._map.getPitch();let c="";if(c+=e?`/${o}/${s}/${i}`:`${i}/${s}/${o}`,(n||l)&&(c+="/"+Math.round(10*n)/10),l&&(c+=`/${Math.round(l)}`),this._hashName){const e=this._hashName;let t=!1;const i=window.location.hash.slice(1).split("&").map((i=>{const a=i.split("=")[0];return a===e?(t=!0,`${a}=${c}`):i})).filter((e=>e));return t||i.push(`${e}=${c}`),`#${i.join("&")}`}return `#${c}`}_isValidHash(e){if(e.length<3||e.some(isNaN))return !1;try{new t.V(+e[2],+e[1]);}catch(e){return !1}const i=+e[0],a=+(e[3]||0),r=+(e[4]||0);return i>=this._map.getMinZoom()&&i<=this._map.getMaxZoom()&&a>=-180&&a<=180&&r>=this._map.getMinPitch()&&r<=this._map.getMaxPitch()}}const Hr={linearity:.3,easing:t.cw(0,0,.3,1)},Xr=t.e({deceleration:2500,maxSpeed:1400},Hr),Kr=t.e({deceleration:20,maxSpeed:1400},Hr),Yr=t.e({deceleration:1e3,maxSpeed:360},Hr),Qr=t.e({deceleration:1e3,maxSpeed:90},Hr),Jr=t.e({deceleration:1e3,maxSpeed:360},Hr);class eo{constructor(e){this._map=e,this.clear();}clear(){this._inertiaBuffer=[];}record(e){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:c(),settings:e});}_drainInertiaBuffer(){const e=this._inertiaBuffer,t=c();for(;e.length>0&&t-e[0].time>160;)e.shift();}_onMoveEnd(e){if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const i={zoom:0,bearing:0,pitch:0,roll:0,pan:new t.P(0,0),pinchAround:void 0,around:void 0};for(const{settings:e}of this._inertiaBuffer)i.zoom+=e.zoomDelta||0,i.bearing+=e.bearingDelta||0,i.pitch+=e.pitchDelta||0,i.roll+=e.rollDelta||0,e.panDelta&&i.pan._add(e.panDelta),e.around&&(i.around=e.around),e.pinchAround&&(i.pinchAround=e.pinchAround);const a=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,r={};if(i.pan.mag()){const o=io(i.pan.mag(),a,t.e({},Xr,e||{})),s=i.pan.mult(o.amount/i.pan.mag()),n=this._map.cameraHelper.handlePanInertia(s,this._map.transform);r.center=n.easingCenter,r.offset=n.easingOffset,to(r,o);}if(i.zoom){const e=io(i.zoom,a,Kr);r.zoom=this._map.transform.zoom+e.amount,to(r,e);}if(i.bearing){const e=io(i.bearing,a,Yr);r.bearing=this._map.transform.bearing+t.an(e.amount,-179,179),to(r,e);}if(i.pitch){const e=io(i.pitch,a,Qr);r.pitch=this._map.transform.pitch+e.amount,to(r,e);}if(i.roll){const e=io(i.roll,a,Jr);r.roll=this._map.transform.roll+t.an(e.amount,-179,179),to(r,e);}if(r.zoom||r.bearing){const e=void 0===i.pinchAround?i.around:i.pinchAround;r.around=e?this._map.unproject(e):this._map.getCenter();}return this.clear(),t.e(r,{noMoveStart:!0})}}function to(e,t){(!e.duration||e.duration<t.duration)&&(e.duration=t.duration,e.easing=t.easing);}function io(e,i,a){const{maxSpeed:r,linearity:o,deceleration:s}=a,n=t.an(e*o/(i/1e3),-r,r),l=Math.abs(n)/(s*o);return {easing:a.easing,duration:1e3*l,amount:n*(l/2)}}class ao extends t.l{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,i,a,r={}){a=a instanceof MouseEvent?a:new MouseEvent(e,a);const o=h.mousePos(i.getCanvas(),a),s=i.unproject(o);super(e,t.e({point:o,lngLat:s,originalEvent:a},r)),this._defaultPrevented=!1,this.target=i;}}class ro extends t.l{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,i,a){const r="touchend"===e?a.changedTouches:a.touches,o=h.touchPos(i.getCanvasContainer(),r),s=o.map((e=>i.unproject(e))),n=o.reduce(((e,t,i,a)=>e.add(t.div(a.length))),new t.P(0,0));super(e,{points:o,point:n,lngLats:s,lngLat:i.unproject(n),originalEvent:a}),this._defaultPrevented=!1;}}class oo extends t.l{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,t,i){super(e,{originalEvent:i}),this._defaultPrevented=!1;}}class so{constructor(e,t){this._map=e,this._clickTolerance=t.clickTolerance;}reset(){delete this._mousedownPos;}wheel(e){return this._firePreventable(new oo(e.type,this._map,e))}mousedown(e,t){return this._mousedownPos=t,this._firePreventable(new ao(e.type,this._map,e))}mouseup(e){this._map.fire(new ao(e.type,this._map,e));}click(e,t){this._mousedownPos&&this._mousedownPos.dist(t)>=this._clickTolerance||this._map.fire(new ao(e.type,this._map,e));}dblclick(e){return this._firePreventable(new ao(e.type,this._map,e))}mouseover(e){this._map.fire(new ao(e.type,this._map,e));}mouseout(e){this._map.fire(new ao(e.type,this._map,e));}touchstart(e){return this._firePreventable(new ro(e.type,this._map,e))}touchmove(e){this._map.fire(new ro(e.type,this._map,e));}touchend(e){this._map.fire(new ro(e.type,this._map,e));}touchcancel(e){this._map.fire(new ro(e.type,this._map,e));}_firePreventable(e){if(this._map.fire(e),e.defaultPrevented)return {}}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class no{constructor(e){this._map=e;}reset(){this._delayContextMenu=!1,this._ignoreContextMenu=!0,delete this._contextMenuEvent;}mousemove(e){this._map.fire(new ao(e.type,this._map,e));}mousedown(){this._delayContextMenu=!0,this._ignoreContextMenu=!1;}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new ao("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent);}contextmenu(e){this._delayContextMenu?this._contextMenuEvent=e:this._ignoreContextMenu||this._map.fire(new ao(e.type,this._map,e)),this._map.listens("contextmenu")&&e.preventDefault();}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class lo{constructor(e){this._map=e;}get transform(){return this._map._requestedCameraState||this._map.transform}get center(){return {lng:this.transform.center.lng,lat:this.transform.center.lat}}get zoom(){return this.transform.zoom}get pitch(){return this.transform.pitch}get bearing(){return this.transform.bearing}unproject(e){return this.transform.screenPointToLocation(t.P.convert(e),this._map.terrain)}}class co{constructor(e,t){this._map=e,this._tr=new lo(e),this._el=e.getCanvasContainer(),this._container=e.getContainer(),this._clickTolerance=t.clickTolerance||1;}isEnabled(){return !!this._enabled}isActive(){return !!this._active}enable(){this.isEnabled()||(this._enabled=!0);}disable(){this.isEnabled()&&(this._enabled=!1);}mousedown(e,t){this.isEnabled()&&e.shiftKey&&0===e.button&&(h.disableDrag(),this._startPos=this._lastPos=t,this._active=!0);}mousemoveWindow(e,t){if(!this._active)return;const i=t;if(this._lastPos.equals(i)||!this._box&&i.dist(this._startPos)<this._clickTolerance)return;const a=this._startPos;this._lastPos=i,this._box||(this._box=h.create("div","maplibregl-boxzoom",this._container),this._container.classList.add("maplibregl-crosshair"),this._fireEvent("boxzoomstart",e));const r=Math.min(a.x,i.x),o=Math.max(a.x,i.x),s=Math.min(a.y,i.y),n=Math.max(a.y,i.y);h.setTransform(this._box,`translate(${r}px,${s}px)`),this._box.style.width=o-r+"px",this._box.style.height=n-s+"px";}mouseupWindow(e,i){if(!this._active)return;if(0!==e.button)return;const a=this._startPos,r=i;if(this.reset(),h.suppressClick(),a.x!==r.x||a.y!==r.y)return this._map.fire(new t.l("boxzoomend",{originalEvent:e})),{cameraAnimation:e=>e.fitScreenCoordinates(a,r,this._tr.bearing,{linear:!0})};this._fireEvent("boxzoomcancel",e);}keydown(e){this._active&&27===e.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",e));}reset(){this._active=!1,this._container.classList.remove("maplibregl-crosshair"),this._box&&(h.remove(this._box),this._box=null),h.enableDrag(),delete this._startPos,delete this._lastPos;}_fireEvent(e,i){return this._map.fire(new t.l(e,{originalEvent:i}))}}function ho(e,t){if(e.length!==t.length)throw new Error(`The number of touches and points are not equal - touches ${e.length}, points ${t.length}`);const i={};for(let a=0;a<e.length;a++)i[e[a].identifier]=t[a];return i}class uo{constructor(e){this.reset(),this.numTouches=e.numTouches;}reset(){delete this.centroid,delete this.startTime,delete this.touches,this.aborted=!1;}touchstart(e,i,a){(this.centroid||a.length>this.numTouches)&&(this.aborted=!0),this.aborted||(void 0===this.startTime&&(this.startTime=e.timeStamp),a.length===this.numTouches&&(this.centroid=function(e){const i=new t.P(0,0);for(const t of e)i._add(t);return i.div(e.length)}(i),this.touches=ho(a,i)));}touchmove(e,t,i){if(this.aborted||!this.centroid)return;const a=ho(i,t);for(const e in this.touches){const t=a[e];(!t||t.dist(this.touches[e])>30)&&(this.aborted=!0);}}touchend(e,t,i){if((!this.centroid||e.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const e=!this.aborted&&this.centroid;if(this.reset(),e)return e}}}class _o{constructor(e){this.singleTap=new uo(e),this.numTaps=e.numTaps,this.reset();}reset(){this.lastTime=1/0,delete this.lastTap,this.count=0,this.singleTap.reset();}touchstart(e,t,i){this.singleTap.touchstart(e,t,i);}touchmove(e,t,i){this.singleTap.touchmove(e,t,i);}touchend(e,t,i){const a=this.singleTap.touchend(e,t,i);if(a){const t=e.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(a)<30;if(t&&i||this.reset(),this.count++,this.lastTime=e.timeStamp,this.lastTap=a,this.count===this.numTaps)return this.reset(),a}}}class po{constructor(e){this._tr=new lo(e),this._zoomIn=new _o({numTouches:1,numTaps:2}),this._zoomOut=new _o({numTouches:2,numTaps:1}),this.reset();}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset();}touchstart(e,t,i){this._zoomIn.touchstart(e,t,i),this._zoomOut.touchstart(e,t,i);}touchmove(e,t,i){this._zoomIn.touchmove(e,t,i),this._zoomOut.touchmove(e,t,i);}touchend(e,t,i){const a=this._zoomIn.touchend(e,t,i),r=this._zoomOut.touchend(e,t,i),o=this._tr;return a?(this._active=!0,e.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:o.zoom+1,around:o.unproject(a)},{originalEvent:e})}):r?(this._active=!0,e.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:o.zoom-1,around:o.unproject(r)},{originalEvent:e})}):void 0}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class mo{constructor(e){this._enabled=!!e.enable,this._moveStateManager=e.moveStateManager,this._clickTolerance=e.clickTolerance||1,this._moveFunction=e.move,this._activateOnStart=!!e.activateOnStart,e.assignEvents(this),this.reset();}reset(e){this._active=!1,this._moved=!1,delete this._lastPoint,this._moveStateManager.endMove(e);}_move(...e){const t=this._moveFunction(...e);if(t.bearingDelta||t.pitchDelta||t.rollDelta||t.around||t.panDelta)return this._active=!0,t}dragStart(e,t){this.isEnabled()&&!this._lastPoint&&this._moveStateManager.isValidStartEvent(e)&&(this._moveStateManager.startMove(e),this._lastPoint=Array.isArray(t)?t[0]:t,this._activateOnStart&&this._lastPoint&&(this._active=!0));}dragMove(e,t){if(!this.isEnabled())return;const i=this._lastPoint;if(!i)return;if(e.preventDefault(),!this._moveStateManager.isValidMoveEvent(e))return void this.reset(e);const a=Array.isArray(t)?t[0]:t;return !this._moved&&a.dist(i)<this._clickTolerance?void 0:(this._moved=!0,this._lastPoint=a,this._move(i,a))}dragEnd(e){this.isEnabled()&&this._lastPoint&&this._moveStateManager.isValidEndEvent(e)&&(this._moved&&h.suppressClick(),this.reset(e));}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}getClickTolerance(){return this._clickTolerance}}const fo=0,go=2,vo={[fo]:1,[go]:2};class xo{constructor(e){this._correctEvent=e.checkCorrectEvent;}startMove(e){const t=h.mouseButton(e);this._eventButton=t;}endMove(e){delete this._eventButton;}isValidStartEvent(e){return this._correctEvent(e)}isValidMoveEvent(e){return !function(e,t){const i=vo[t];return void 0===e.buttons||(e.buttons&i)!==i}(e,this._eventButton)}isValidEndEvent(e){return h.mouseButton(e)===this._eventButton}}class bo{constructor(){this._firstTouch=void 0;}_isOneFingerTouch(e){return 1===e.targetTouches.length}_isSameTouchEvent(e){return e.targetTouches[0].identifier===this._firstTouch}startMove(e){this._firstTouch=e.targetTouches[0].identifier;}endMove(e){delete this._firstTouch;}isValidStartEvent(e){return this._isOneFingerTouch(e)}isValidMoveEvent(e){return this._isOneFingerTouch(e)&&this._isSameTouchEvent(e)}isValidEndEvent(e){return this._isOneFingerTouch(e)&&this._isSameTouchEvent(e)}}class yo{constructor(e=new xo({checkCorrectEvent:()=>!0}),t=new bo){this.mouseMoveStateManager=e,this.oneFingerTouchMoveStateManager=t;}_executeRelevantHandler(e,t,i){return e instanceof MouseEvent?t(e):"undefined"!=typeof TouchEvent&&e instanceof TouchEvent?i(e):void 0}startMove(e){this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.startMove(e)),(e=>this.oneFingerTouchMoveStateManager.startMove(e)));}endMove(e){this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.endMove(e)),(e=>this.oneFingerTouchMoveStateManager.endMove(e)));}isValidStartEvent(e){return this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.isValidStartEvent(e)),(e=>this.oneFingerTouchMoveStateManager.isValidStartEvent(e)))}isValidMoveEvent(e){return this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.isValidMoveEvent(e)),(e=>this.oneFingerTouchMoveStateManager.isValidMoveEvent(e)))}isValidEndEvent(e){return this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.isValidEndEvent(e)),(e=>this.oneFingerTouchMoveStateManager.isValidEndEvent(e)))}}const wo=e=>{e.mousedown=e.dragStart,e.mousemoveWindow=e.dragMove,e.mouseup=e.dragEnd,e.contextmenu=e=>{e.preventDefault();};};class To{constructor(e,t){this._clickTolerance=e.clickTolerance||1,this._map=t,this.reset();}reset(){this._active=!1,this._touches={},this._sum=new t.P(0,0);}_shouldBePrevented(e){return e<(this._map.cooperativeGestures.isEnabled()?2:1)}touchstart(e,t,i){return this._calculateTransform(e,t,i)}touchmove(e,t,i){if(this._active){if(!this._shouldBePrevented(i.length))return e.preventDefault(),this._calculateTransform(e,t,i);this._map.cooperativeGestures.notifyGestureBlocked("touch_pan",e);}}touchend(e,t,i){this._calculateTransform(e,t,i),this._active&&this._shouldBePrevented(i.length)&&this.reset();}touchcancel(){this.reset();}_calculateTransform(e,i,a){a.length>0&&(this._active=!0);const r=ho(a,i),o=new t.P(0,0),s=new t.P(0,0);let n=0;for(const e in r){const t=r[e],i=this._touches[e];i&&(o._add(t),s._add(t.sub(i)),n++,r[e]=t);}if(this._touches=r,this._shouldBePrevented(n)||!s.mag())return;const l=s.div(n);return this._sum._add(l),this._sum.mag()<this._clickTolerance?void 0:{around:o.div(n),panDelta:l}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Po{constructor(){this.reset();}reset(){this._active=!1,delete this._firstTwoTouches;}touchstart(e,t,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([t[0],t[1]]));}touchmove(e,t,i){if(!this._firstTwoTouches)return;e.preventDefault();const[a,r]=this._firstTwoTouches,o=Co(i,t,a),s=Co(i,t,r);if(!o||!s)return;const n=this._aroundCenter?null:o.add(s).div(2);return this._move([o,s],n,e)}touchend(e,t,i){if(!this._firstTwoTouches)return;const[a,r]=this._firstTwoTouches,o=Co(i,t,a),s=Co(i,t,r);o&&s||(this._active&&h.suppressClick(),this.reset());}touchcancel(){this.reset();}enable(e){this._enabled=!0,this._aroundCenter=!!e&&"center"===e.around;}disable(){this._enabled=!1,this.reset();}isEnabled(){return !!this._enabled}isActive(){return !!this._active}}function Co(e,t,i){for(let a=0;a<e.length;a++)if(e[a].identifier===i)return t[a]}function Io(e,t){return Math.log(e/t)/Math.LN2}class Mo extends Po{reset(){super.reset(),delete this._distance,delete this._startDistance;}_start(e){this._startDistance=this._distance=e[0].dist(e[1]);}_move(e,t){const i=this._distance;if(this._distance=e[0].dist(e[1]),this._active||!(Math.abs(Io(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:Io(this._distance,i),pinchAround:t}}}function Eo(e,t){return 180*e.angleWith(t)/Math.PI}class So extends Po{reset(){super.reset(),delete this._minDiameter,delete this._startVector,delete this._vector;}_start(e){this._startVector=this._vector=e[0].sub(e[1]),this._minDiameter=e[0].dist(e[1]);}_move(e,t,i){const a=this._vector;if(this._vector=e[0].sub(e[1]),this._active||!this._isBelowThreshold(this._vector))return this._active=!0,{bearingDelta:Eo(this._vector,a),pinchAround:t}}_isBelowThreshold(e){this._minDiameter=Math.min(this._minDiameter,e.mag());const t=25/(Math.PI*this._minDiameter)*360,i=Eo(e,this._startVector);return Math.abs(i)<t}}function zo(e){return Math.abs(e.y)>Math.abs(e.x)}class Ro extends Po{constructor(e){super(),this._currentTouchCount=0,this._map=e;}reset(){super.reset(),this._valid=void 0,delete this._firstMove,delete this._lastPoints;}touchstart(e,t,i){super.touchstart(e,t,i),this._currentTouchCount=i.length;}_start(e){this._lastPoints=e,zo(e[0].sub(e[1]))&&(this._valid=!1);}_move(e,t,i){if(this._map.cooperativeGestures.isEnabled()&&this._currentTouchCount<3)return;const a=e[0].sub(this._lastPoints[0]),r=e[1].sub(this._lastPoints[1]);return this._valid=this.gestureBeginsVertically(a,r,i.timeStamp),this._valid?(this._lastPoints=e,this._active=!0,{pitchDelta:(a.y+r.y)/2*-.5}):void 0}gestureBeginsVertically(e,t,i){if(void 0!==this._valid)return this._valid;const a=e.mag()>=2,r=t.mag()>=2;if(!a&&!r)return;if(!a||!r)return void 0===this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const o=e.y>0==t.y>0;return zo(e)&&zo(t)&&o}}const Do={panStep:100,bearingStep:15,pitchStep:10};class Ao{constructor(e){this._tr=new lo(e);const t=Do;this._panStep=t.panStep,this._bearingStep=t.bearingStep,this._pitchStep=t.pitchStep,this._rotationDisabled=!1;}reset(){this._active=!1;}keydown(e){if(e.altKey||e.ctrlKey||e.metaKey)return;let t=0,i=0,a=0,r=0,o=0;switch(e.keyCode){case 61:case 107:case 171:case 187:t=1;break;case 189:case 109:case 173:t=-1;break;case 37:e.shiftKey?i=-1:(e.preventDefault(),r=-1);break;case 39:e.shiftKey?i=1:(e.preventDefault(),r=1);break;case 38:e.shiftKey?a=1:(e.preventDefault(),o=-1);break;case 40:e.shiftKey?a=-1:(e.preventDefault(),o=1);break;default:return}return this._rotationDisabled&&(i=0,a=0),{cameraAnimation:s=>{const n=this._tr;s.easeTo({duration:300,easeId:"keyboardHandler",easing:Lo,zoom:t?Math.round(n.zoom)+t*(e.shiftKey?2:1):n.zoom,bearing:n.bearing+i*this._bearingStep,pitch:n.pitch+a*this._pitchStep,offset:[-r*this._panStep,-o*this._panStep],center:n.center},{originalEvent:e});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0;}enableRotation(){this._rotationDisabled=!1;}}function Lo(e){return e*(2-e)}const ko=4.000244140625,Fo=1/450;class Bo{constructor(e,t){this._onTimeout=e=>{this._type="wheel",this._delta-=this._lastValue,this._active||this._start(e);},this._map=e,this._tr=new lo(e),this._triggerRenderFrame=t,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=Fo;}setZoomRate(e){this._defaultZoomRate=e;}setWheelZoomRate(e){this._wheelZoomRate=e;}isEnabled(){return !!this._enabled}isActive(){return !!this._active||void 0!==this._finishTimeout}isZooming(){return !!this._zooming}enable(e){this.isEnabled()||(this._enabled=!0,this._aroundCenter=!!e&&"center"===e.around);}disable(){this.isEnabled()&&(this._enabled=!1);}_shouldBePrevented(e){return !!this._map.cooperativeGestures.isEnabled()&&!(e.ctrlKey||this._map.cooperativeGestures.isBypassed(e))}wheel(e){if(!this.isEnabled())return;if(this._shouldBePrevented(e))return void this._map.cooperativeGestures.notifyGestureBlocked("wheel_zoom",e);let t=e.deltaMode===WheelEvent.DOM_DELTA_LINE?40*e.deltaY:e.deltaY;const i=c(),a=i-(this._lastWheelEventTime||0);this._lastWheelEventTime=i,0!==t&&t%ko==0?this._type="wheel":0!==t&&Math.abs(t)<4?this._type="trackpad":a>400?(this._type=null,this._lastValue=t,this._timeout=setTimeout(this._onTimeout,40,e)):this._type||(this._type=Math.abs(a*t)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,t+=this._lastValue)),e.shiftKey&&t&&(t/=4),this._type&&(this._lastWheelEvent=e,this._delta-=t,this._active||this._start(e)),e.preventDefault();}_start(e){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const i=h.mousePos(this._map.getCanvas(),e),a=this._tr;this._aroundPoint=this._aroundCenter?a.transform.locationToScreenPoint(t.V.convert(a.center)):i,this._frameId||(this._frameId=!0,this._triggerRenderFrame());}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const e=this._tr.transform;if("number"==typeof this._lastExpectedZoom){const t=e.zoom-this._lastExpectedZoom;"number"==typeof this._startZoom&&(this._startZoom+=t),"number"==typeof this._targetZoom&&(this._targetZoom+=t);}if(0!==this._delta){const i="wheel"===this._type&&Math.abs(this._delta)>ko?this._wheelZoomRate:this._defaultZoomRate;let a=2/(1+Math.exp(-Math.abs(this._delta*i)));this._delta<0&&0!==a&&(a=1/a);const r="number"!=typeof this._targetZoom?e.scale:t.aq(this._targetZoom);this._targetZoom=e.applyConstrain(e.getCameraLngLat(),t.at(r*a)).zoom,"wheel"===this._type&&(this._startZoom=e.zoom,this._easing=this._smoothOutEasing(200)),this._delta=0;}const i="number"!=typeof this._targetZoom?e.zoom:this._targetZoom,a=this._startZoom,r=this._easing;let o,s=!1;if("wheel"===this._type&&a&&r){const e=c()-this._lastWheelEventTime,n=Math.min((e+5)/200,1),l=r(n);o=t.G.number(a,i,l),n<1?this._frameId||(this._frameId=!0):s=!0;}else o=i,s=!0;return this._active=!0,s&&(this._active=!1,this._finishTimeout=setTimeout((()=>{this._zooming=!1,this._triggerRenderFrame(),delete this._targetZoom,delete this._lastExpectedZoom,delete this._finishTimeout;}),200)),this._lastExpectedZoom=o,{noInertia:!0,needsRenderFrame:!s,zoomDelta:o-e.zoom,around:this._aroundPoint,originalEvent:this._lastWheelEvent}}_smoothOutEasing(e){let i=t.cy;if(this._prevEase){const e=this._prevEase,a=(c()-e.start)/e.duration,r=e.easing(a+.01)-e.easing(a),o=.27/Math.sqrt(r*r+1e-4)*.01,s=Math.sqrt(.0729-o*o);i=t.cw(o,s,.25,1);}return this._prevEase={start:c(),duration:e,easing:i},i}reset(){this._active=!1,this._zooming=!1,delete this._targetZoom,delete this._lastExpectedZoom,this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);}}class Oo{constructor(e,t){this._clickZoom=e,this._tapZoom=t;}enable(){this._clickZoom.enable(),this._tapZoom.enable();}disable(){this._clickZoom.disable(),this._tapZoom.disable();}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class jo{constructor(e){this._tr=new lo(e),this.reset();}reset(){this._active=!1;}dblclick(e,t){return e.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:this._tr.zoom+(e.shiftKey?-1:1),around:this._tr.unproject(t)},{originalEvent:e});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class No{constructor(){this._tap=new _o({numTouches:1,numTaps:1}),this.reset();}reset(){this._active=!1,delete this._swipePoint,delete this._swipeTouch,delete this._tapTime,delete this._tapPoint,this._tap.reset();}touchstart(e,t,i){if(!this._swipePoint)if(this._tapTime){const a=t[0],r=e.timeStamp-this._tapTime<500,o=this._tapPoint.dist(a)<30;r&&o?i.length>0&&(this._swipePoint=a,this._swipeTouch=i[0].identifier):this.reset();}else this._tap.touchstart(e,t,i);}touchmove(e,t,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const a=t[0],r=a.y-this._swipePoint.y;return this._swipePoint=a,e.preventDefault(),this._active=!0,{zoomDelta:r/128}}}else this._tap.touchmove(e,t,i);}touchend(e,t,i){if(this._tapTime)this._swipePoint&&0===i.length&&this.reset();else {const a=this._tap.touchend(e,t,i);a&&(this._tapTime=e.timeStamp,this._tapPoint=a);}}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Zo{constructor(e,t,i){this._el=e,this._mousePan=t,this._touchPan=i;}enable(e){this._inertiaOptions=e||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("maplibregl-touch-drag-pan");}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("maplibregl-touch-drag-pan");}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class Go{constructor(e,t,i,a){this._pitchWithRotate=e.pitchWithRotate,this._rollEnabled=e.rollEnabled,this._mouseRotate=t,this._mousePitch=i,this._mouseRoll=a;}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable(),this._rollEnabled&&this._mouseRoll.enable();}disable(){this._mouseRotate.disable(),this._mousePitch.disable(),this._mouseRoll.disable();}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())&&(!this._rollEnabled||this._mouseRoll.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()||this._mouseRoll.isActive()}}class Uo{constructor(e,t,i,a){this._el=e,this._touchZoom=t,this._touchRotate=i,this._tapDragZoom=a,this._rotationDisabled=!1,this._enabled=!0;}enable(e){this._touchZoom.enable(e),this._rotationDisabled||this._touchRotate.enable(e),this._tapDragZoom.enable(),this._el.classList.add("maplibregl-touch-zoom-rotate");}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("maplibregl-touch-zoom-rotate");}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable();}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable();}}class Vo{constructor(e,t){this._bypassKey=-1!==navigator.userAgent.indexOf("Mac")?"metaKey":"ctrlKey",this._map=e,this._options=t,this._enabled=!1;}isActive(){return !1}reset(){}_setupUI(){if(this._container)return;const e=this._map.getCanvasContainer();e.classList.add("maplibregl-cooperative-gestures"),this._container=h.create("div","maplibregl-cooperative-gesture-screen",e);let t=this._map._getUIString("CooperativeGesturesHandler.WindowsHelpText");"metaKey"===this._bypassKey&&(t=this._map._getUIString("CooperativeGesturesHandler.MacHelpText"));const i=this._map._getUIString("CooperativeGesturesHandler.MobileHelpText"),a=document.createElement("div");a.className="maplibregl-desktop-message",a.textContent=t,this._container.appendChild(a);const r=document.createElement("div");r.className="maplibregl-mobile-message",r.textContent=i,this._container.appendChild(r),this._container.setAttribute("aria-hidden","true");}_destroyUI(){this._container&&(h.remove(this._container),this._map.getCanvasContainer().classList.remove("maplibregl-cooperative-gestures")),delete this._container;}enable(){this._setupUI(),this._enabled=!0;}disable(){this._enabled=!1,this._destroyUI();}isEnabled(){return this._enabled}isBypassed(e){return e[this._bypassKey]}notifyGestureBlocked(e,i){this._enabled&&(this._map.fire(new t.l("cooperativegestureprevented",{gestureType:e,originalEvent:i})),this._container.classList.add("maplibregl-show"),setTimeout((()=>{this._container.classList.remove("maplibregl-show");}),100));}}const qo=e=>e.zoom||e.drag||e.roll||e.pitch||e.rotate;class Wo extends t.l{}function $o(e){return e.panDelta&&e.panDelta.mag()||e.zoomDelta||e.bearingDelta||e.pitchDelta||e.rollDelta}class Ho{constructor(e,i){this.handleWindowEvent=e=>{this.handleEvent(e,`${e.type}Window`);},this.handleEvent=(e,i)=>{if("blur"===e.type)return void this.stop(!0);this._updatingCamera=!0;const a="renderFrame"===e.type?void 0:e,r={needsRenderFrame:!1},o={},s={};for(const{handlerName:n,handler:l,allowed:c}of this._handlers){if(!l.isEnabled())continue;let u;if(this._blockedByActive(s,c,n))l.reset();else if(l[i||e.type]){if(t.cz(e,i||e.type)){const t=h.mousePos(this._map.getCanvas(),e);u=l[i||e.type](e,t);}else if(t.cA(e,i||e.type)){const t=this._getMapTouches(e.touches),a=h.touchPos(this._map.getCanvas(),t);u=l[i||e.type](e,a,t);}else t.cB(i||e.type)||(u=l[i||e.type](e));this.mergeHandlerResult(r,o,u,n,a),u&&u.needsRenderFrame&&this._triggerRenderFrame();}(u||l.isActive())&&(s[n]=l);}const n={};for(const e in this._previousActiveHandlers)s[e]||(n[e]=a);this._previousActiveHandlers=s,(Object.keys(n).length||$o(r))&&(this._changes.push([r,o,n]),this._triggerRenderFrame()),(Object.keys(s).length||$o(r))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:l}=r;l&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],l(this._map));},this._map=e,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new eo(e),this._bearingSnap=i.bearingSnap,this._previousActiveHandlers={},this._eventsInProgress={},this._addDefaultHandlers(i);const a=this._el;this._listeners=[[a,"touchstart",{passive:!0}],[a,"touchmove",{passive:!1}],[a,"touchend",void 0],[a,"touchcancel",void 0],[a,"mousedown",void 0],[a,"mousemove",void 0],[a,"mouseup",void 0],[document,"mousemove",{capture:!0}],[document,"mouseup",void 0],[a,"mouseover",void 0],[a,"mouseout",void 0],[a,"dblclick",void 0],[a,"click",void 0],[a,"keydown",{capture:!1}],[a,"keyup",void 0],[a,"wheel",{passive:!1}],[a,"contextmenu",void 0],[window,"blur",void 0]];for(const[e,t,i]of this._listeners)h.addEventListener(e,t,e===document?this.handleWindowEvent:this.handleEvent,i);}destroy(){for(const[e,t,i]of this._listeners)h.removeEventListener(e,t,e===document?this.handleWindowEvent:this.handleEvent,i);}_addDefaultHandlers(e){const i=this._map,a=i.getCanvasContainer();this._add("mapEvent",new so(i,e));const r=i.boxZoom=new co(i,e);this._add("boxZoom",r),e.interactive&&e.boxZoom&&r.enable();const o=i.cooperativeGestures=new Vo(i,e.cooperativeGestures);this._add("cooperativeGestures",o),e.cooperativeGestures&&o.enable();const s=new po(i),n=new jo(i);i.doubleClickZoom=new Oo(n,s),this._add("tapZoom",s),this._add("clickZoom",n),e.interactive&&e.doubleClickZoom&&i.doubleClickZoom.enable();const l=new No;this._add("tapDragZoom",l);const c=i.touchPitch=new Ro(i);this._add("touchPitch",c),e.interactive&&e.touchPitch&&i.touchPitch.enable(e.touchPitch);const u=()=>i.project(i.getCenter()),d=function({enable:e,clickTolerance:i,aroundCenter:a=!0,minPixelCenterThreshold:r=100,rotateDegreesPerPixelMoved:o=.8},s){const n=new xo({checkCorrectEvent:e=>0===h.mouseButton(e)&&e.ctrlKey||2===h.mouseButton(e)&&!e.ctrlKey});return new mo({clickTolerance:i,move:(e,i)=>{const n=s();if(a&&Math.abs(n.y-e.y)>r)return {bearingDelta:t.cx(new t.P(e.x,i.y),i,n)};let l=(i.x-e.x)*o;return a&&i.y<n.y&&(l=-l),{bearingDelta:l}},moveStateManager:n,enable:e,assignEvents:wo})}(e,u),_=function({enable:e,clickTolerance:t,pitchDegreesPerPixelMoved:i=-.5}){const a=new xo({checkCorrectEvent:e=>0===h.mouseButton(e)&&e.ctrlKey||2===h.mouseButton(e)});return new mo({clickTolerance:t,move:(e,t)=>({pitchDelta:(t.y-e.y)*i}),moveStateManager:a,enable:e,assignEvents:wo})}(e),p=function({enable:e,clickTolerance:t,rollDegreesPerPixelMoved:i=.3},a){const r=new xo({checkCorrectEvent:e=>2===h.mouseButton(e)&&e.ctrlKey});return new mo({clickTolerance:t,move:(e,t)=>{const r=a();let o=(t.x-e.x)*i;return t.y<r.y&&(o=-o),{rollDelta:o}},moveStateManager:r,enable:e,assignEvents:wo})}(e,u);i.dragRotate=new Go(e,d,_,p),this._add("mouseRotate",d,["mousePitch"]),this._add("mousePitch",_,["mouseRotate","mouseRoll"]),this._add("mouseRoll",p,["mousePitch"]),e.interactive&&e.dragRotate&&i.dragRotate.enable();const m=function({enable:e,clickTolerance:t}){const i=new xo({checkCorrectEvent:e=>0===h.mouseButton(e)&&!e.ctrlKey});return new mo({clickTolerance:t,move:(e,t)=>({around:t,panDelta:t.sub(e)}),activateOnStart:!0,moveStateManager:i,enable:e,assignEvents:wo})}(e),f=new To(e,i);i.dragPan=new Zo(a,m,f),this._add("mousePan",m),this._add("touchPan",f,["touchZoom","touchRotate"]),e.interactive&&e.dragPan&&i.dragPan.enable(e.dragPan);const g=new So,v=new Mo;i.touchZoomRotate=new Uo(a,v,g,l),this._add("touchRotate",g,["touchPan","touchZoom"]),this._add("touchZoom",v,["touchPan","touchRotate"]),e.interactive&&e.touchZoomRotate&&i.touchZoomRotate.enable(e.touchZoomRotate),this._add("blockableMapEvent",new no(i));const x=i.scrollZoom=new Bo(i,(()=>this._triggerRenderFrame()));this._add("scrollZoom",x,["mousePan"]),e.interactive&&e.scrollZoom&&i.scrollZoom.enable(e.scrollZoom);const b=i.keyboard=new Ao(i);this._add("keyboard",b),e.interactive&&e.keyboard&&i.keyboard.enable();}_add(e,t,i){this._handlers.push({handlerName:e,handler:t,allowed:i}),this._handlersById[e]=t;}stop(e){if(!this._updatingCamera){for(const{handler:e}of this._handlers)e.reset();this._inertia.clear(),this._fireEvents({},{},e),this._changes=[];}}isActive(){for(const{handler:e}of this._handlers)if(e.isActive())return !0;return !1}isZooming(){return !!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return !!this._eventsInProgress.rotate}isMoving(){return Boolean(qo(this._eventsInProgress))||this.isZooming()}_blockedByActive(e,t,i){for(const a in e)if(a!==i&&(!t||t.indexOf(a)<0))return !0;return !1}_getMapTouches(e){const t=[];for(const i of e)this._el.contains(i.target)&&t.push(i);return t}mergeHandlerResult(e,i,a,r,o){if(!a)return;t.e(e,a);const s={handlerName:r,originalEvent:a.originalEvent||o};void 0!==a.zoomDelta&&(i.zoom=s),void 0!==a.panDelta&&(i.drag=s),void 0!==a.rollDelta&&(i.roll=s),void 0!==a.pitchDelta&&(i.pitch=s),void 0!==a.bearingDelta&&(i.rotate=s);}_applyChanges(){const e={},i={},a={};for(const[r,o,s]of this._changes)r.panDelta&&(e.panDelta=(e.panDelta||new t.P(0,0))._add(r.panDelta)),r.zoomDelta&&(e.zoomDelta=(e.zoomDelta||0)+r.zoomDelta),r.bearingDelta&&(e.bearingDelta=(e.bearingDelta||0)+r.bearingDelta),r.pitchDelta&&(e.pitchDelta=(e.pitchDelta||0)+r.pitchDelta),r.rollDelta&&(e.rollDelta=(e.rollDelta||0)+r.rollDelta),void 0!==r.around&&(e.around=r.around),void 0!==r.pinchAround&&(e.pinchAround=r.pinchAround),r.noInertia&&(e.noInertia=r.noInertia),t.e(i,o),t.e(a,s);this._updateMapTransform(e,i,a),this._changes=[];}_updateMapTransform(e,t,i){const a=this._map,r=a._getTransformForUpdate(),o=a.terrain;if(!($o(e)||o&&this._terrainMovement))return this._fireEvents(t,i,!0);a._stop(!0);let{panDelta:s,zoomDelta:n,bearingDelta:l,pitchDelta:c,rollDelta:h,around:u,pinchAround:d}=e;void 0!==d&&(u=d),u=u||a.transform.centerPoint,o&&!r.isPointOnMapSurface(u)&&(u=r.centerPoint);const _={panDelta:s,zoomDelta:n,rollDelta:h,pitchDelta:c,bearingDelta:l,around:u};this._map.cameraHelper.useGlobeControls&&!r.isPointOnMapSurface(u)&&(u=r.centerPoint);const p=u.distSqr(r.centerPoint)<.01?r.center:r.screenPointToLocation(s?u.sub(s):u);this._handleMapControls({terrain:o,tr:r,deltasForHelper:_,preZoomAroundLoc:p,combinedEventsInProgress:t,panDelta:s}),a._applyUpdatedTransform(r),this._map._update(),e.noInertia||this._inertia.record(e),this._fireEvents(t,i,!0);}_handleMapControls({terrain:e,tr:t,deltasForHelper:i,preZoomAroundLoc:a,combinedEventsInProgress:r,panDelta:o}){const s=this._map.cameraHelper;if(s.handleMapControlsRollPitchBearingZoom(i,t),e)return s.useGlobeControls?(this._terrainMovement||!r.drag&&!r.zoom||(this._terrainMovement=!0,this._map._elevationFreeze=!0),void s.handleMapControlsPan(i,t,a)):this._terrainMovement||!r.drag&&!r.zoom?void(r.drag&&this._terrainMovement&&o?t.setCenter(t.screenPointToLocation(t.centerPoint.sub(o))):s.handleMapControlsPan(i,t,a)):(this._terrainMovement=!0,this._map._elevationFreeze=!0,void s.handleMapControlsPan(i,t,a));s.handleMapControlsPan(i,t,a);}_fireEvents(e,i,a){const r=qo(this._eventsInProgress),o=qo(e),s={};for(const t in e){const{originalEvent:i}=e[t];this._eventsInProgress[t]||(s[`${t}start`]=i),this._eventsInProgress[t]=e[t];}!r&&o&&this._fireEvent("movestart",o.originalEvent);for(const e in s)this._fireEvent(e,s[e]);o&&this._fireEvent("move",o.originalEvent);for(const t in e){const{originalEvent:i}=e[t];this._fireEvent(t,i);}const l={};let c;for(const e in this._eventsInProgress){const{handlerName:t,originalEvent:a}=this._eventsInProgress[e];this._handlersById[t].isActive()||(delete this._eventsInProgress[e],c=i[t]||a,l[`${e}end`]=c);}for(const e in l)this._fireEvent(e,l[e]);const h=qo(this._eventsInProgress),u=(r||o)&&!h;if(u&&this._terrainMovement){this._map._elevationFreeze=!1,this._terrainMovement=!1;const e=this._map._getTransformForUpdate();this._map.getCenterClampedToGround()&&e.recalculateZoomAndCenter(this._map.terrain),this._map._applyUpdatedTransform(e);}if(a&&u){this._updatingCamera=!0;const e=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),i=e=>0!==e&&-this._bearingSnap<e&&e<this._bearingSnap;!e||!e.essential&&n.prefersReducedMotion?(this._map.fire(new t.l("moveend",{originalEvent:c})),i(this._map.getBearing())&&this._map.resetNorth()):(i(e.bearing||this._map.getBearing())&&(e.bearing=0),e.freezeElevation=!0,this._map.easeTo(e,{originalEvent:c})),this._updatingCamera=!1;}}_fireEvent(e,i){this._map.fire(new t.l(e,i?{originalEvent:i}:{}));}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add((e=>{delete this._frameId,this.handleEvent(new Wo("renderFrame",{timeStamp:e})),this._applyChanges();}))}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame());}}class Xo extends t.E{constructor(e,t,i){super(),this._renderFrameCallback=()=>{const e=Math.min((c()-this._easeStart)/this._easeOptions.duration,1);this._onEaseFrame(this._easeOptions.easing(e)),e<1&&this._easeFrameId?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop();},this._moving=!1,this._zooming=!1,this.transform=e,this._bearingSnap=i.bearingSnap,this.cameraHelper=t,this.on("moveend",(()=>{delete this._requestedCameraState;}));}migrateProjection(e,t){e.apply(this.transform,!0),this.transform=e,this.cameraHelper=t;}getCenter(){return new t.V(this.transform.center.lng,this.transform.center.lat)}setCenter(e,t){return this.jumpTo({center:e},t)}getCenterElevation(){return this.transform.elevation}setCenterElevation(e,t){return this.jumpTo({elevation:e},t),this}getCenterClampedToGround(){return this._centerClampedToGround}setCenterClampedToGround(e){this._centerClampedToGround=e;}panBy(e,i,a){return e=t.P.convert(e).mult(-1),this.panTo(this.transform.center,t.e({offset:e},i),a)}panTo(e,i,a){return this.easeTo(t.e({center:e},i),a)}getZoom(){return this.transform.zoom}setZoom(e,t){return this.jumpTo({zoom:e},t),this}zoomTo(e,i,a){return this.easeTo(t.e({zoom:e},i),a)}zoomIn(e,t){return this.zoomTo(this.getZoom()+1,e,t),this}zoomOut(e,t){return this.zoomTo(this.getZoom()-1,e,t),this}getVerticalFieldOfView(){return this.transform.fov}setVerticalFieldOfView(e,i){return e!=this.transform.fov&&(this.transform.setFov(e),this.fire(new t.l("movestart",i)).fire(new t.l("move",i)).fire(new t.l("moveend",i))),this}getBearing(){return this.transform.bearing}setBearing(e,t){return this.jumpTo({bearing:e},t),this}getPadding(){return this.transform.padding}setPadding(e,t){return this.jumpTo({padding:e},t),this}rotateTo(e,i,a){return this.easeTo(t.e({bearing:e},i),a)}resetNorth(e,i){return this.rotateTo(0,t.e({duration:1e3},e),i),this}resetNorthPitch(e,i){return this.easeTo(t.e({bearing:0,pitch:0,roll:0,duration:1e3},e),i),this}snapToNorth(e,t){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(e,t):this}getPitch(){return this.transform.pitch}setPitch(e,t){return this.jumpTo({pitch:e},t),this}getRoll(){return this.transform.roll}setRoll(e,t){return this.jumpTo({roll:e},t),this}cameraForBounds(e,t){e=$.convert(e).adjustAntiMeridian();const i=t&&t.bearing||0;return this._cameraForBoxAndBearing(e.getNorthWest(),e.getSouthEast(),i,t)}_cameraForBoxAndBearing(e,i,a,r){const o={top:0,bottom:0,right:0,left:0};if("number"==typeof(r=t.e({padding:o,offset:[0,0],maxZoom:this.transform.maxZoom},r)).padding){const e=r.padding;r.padding={top:e,bottom:e,right:e,left:e};}const s=t.e(o,r.padding);r.padding=s;const n=this.transform,l=new $(e,i);return this.cameraHelper.cameraForBoxAndBearing(r,s,l,a,n)}fitBounds(e,t,i){return this._fitInternal(this.cameraForBounds(e,t),t,i)}fitScreenCoordinates(e,i,a,r,o){return this._fitInternal(this._cameraForBoxAndBearing(this.transform.screenPointToLocation(t.P.convert(e)),this.transform.screenPointToLocation(t.P.convert(i)),a,r),r,o)}_fitInternal(e,i,a){return e?(delete(i=t.e(e,i)).padding,i.linear?this.easeTo(i,a):this.flyTo(i,a)):this}jumpTo(e,i){this.stop();const a=this._getTransformForUpdate();let r=!1,o=!1,s=!1;const n=a.zoom;this.cameraHelper.handleJumpToCenterZoom(a,e);const l=a.zoom!==n;return "elevation"in e&&a.elevation!==+e.elevation&&a.setElevation(+e.elevation),"bearing"in e&&a.bearing!==+e.bearing&&(r=!0,a.setBearing(+e.bearing)),"pitch"in e&&a.pitch!==+e.pitch&&(o=!0,a.setPitch(+e.pitch)),"roll"in e&&a.roll!==+e.roll&&(s=!0,a.setRoll(+e.roll)),null==e.padding||a.isPaddingEqual(e.padding)||a.setPadding(e.padding),this._applyUpdatedTransform(a),this.fire(new t.l("movestart",i)).fire(new t.l("move",i)),l&&this.fire(new t.l("zoomstart",i)).fire(new t.l("zoom",i)).fire(new t.l("zoomend",i)),r&&this.fire(new t.l("rotatestart",i)).fire(new t.l("rotate",i)).fire(new t.l("rotateend",i)),o&&this.fire(new t.l("pitchstart",i)).fire(new t.l("pitch",i)).fire(new t.l("pitchend",i)),s&&this.fire(new t.l("rollstart",i)).fire(new t.l("roll",i)).fire(new t.l("rollend",i)),this.fire(new t.l("moveend",i))}calculateCameraOptionsFromTo(e,i,a,r=0){const o=t.a9.fromLngLat(e,i),s=t.a9.fromLngLat(a,r),n=s.x-o.x,l=s.y-o.y,c=s.z-o.z,h=Math.hypot(n,l,c);if(0===h)throw new Error("Can't calculate camera options with same From and To");const u=Math.hypot(n,l),d=t.at(this.transform.cameraToCenterDistance/h/this.transform.tileSize),_=180*Math.atan2(n,-l)/Math.PI;let p=180*Math.acos(u/h)/Math.PI;return p=c<0?90-p:90+p,{center:s.toLngLat(),elevation:r,zoom:d,pitch:p,bearing:_}}calculateCameraOptionsFromCameraLngLatAltRotation(e,t,i,a,r){const o=this.transform.calculateCenterFromCameraLngLatAlt(e,t,i,a);return {center:o.center,elevation:o.elevation,zoom:o.zoom,bearing:i,pitch:a,roll:r}}easeTo(e,i){this._stop(!1,e.easeId),(!1===(e=t.e({offset:[0,0],duration:500,easing:t.cy},e)).animate||!e.essential&&n.prefersReducedMotion)&&(e.duration=0);const a=this._getTransformForUpdate(),r=this.getBearing(),o=a.pitch,s=a.roll,l="bearing"in e?this._normalizeBearing(e.bearing,r):r,c="pitch"in e?+e.pitch:o,h="roll"in e?this._normalizeBearing(e.roll,s):s,u="padding"in e?e.padding:a.padding,d=t.P.convert(e.offset);let _,p;e.around&&(_=t.V.convert(e.around),p=a.locationToScreenPoint(_));const m={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching,rolling:this._rolling},f=this.cameraHelper.handleEaseTo(a,{bearing:l,pitch:c,roll:h,padding:u,around:_,aroundPoint:p,offsetAsPoint:d,offset:e.offset,zoom:e.zoom,center:e.center});return this._rotating=this._rotating||r!==l,this._pitching=this._pitching||c!==o,this._rolling=this._rolling||h!==s,this._padding=!a.isPaddingEqual(u),this._zooming=this._zooming||f.isZooming,this._easeId=e.easeId,this._prepareEase(i,e.noMoveStart,m),this.terrain&&this._prepareElevation(f.elevationCenter),this._ease((t=>{f.easeFunc(t),this.terrain&&!e.freezeElevation&&this._updateElevation(t),this._applyUpdatedTransform(a),this._fireMoveEvents(i);}),(t=>{this.terrain&&e.freezeElevation&&this._finalizeElevation(),this._afterEase(i,t);}),e),this}_prepareEase(e,i,a={}){this._moving=!0,i||a.moving||this.fire(new t.l("movestart",e)),this._zooming&&!a.zooming&&this.fire(new t.l("zoomstart",e)),this._rotating&&!a.rotating&&this.fire(new t.l("rotatestart",e)),this._pitching&&!a.pitching&&this.fire(new t.l("pitchstart",e)),this._rolling&&!a.rolling&&this.fire(new t.l("rollstart",e));}_prepareElevation(e){this._elevationCenter=e,this._elevationStart=this.transform.elevation,this._elevationTarget=this.terrain.getElevationForLngLatZoom(e,this.transform.tileZoom),this._elevationFreeze=!0;}_updateElevation(e){void 0!==this._elevationStart&&void 0!==this._elevationCenter||this._prepareElevation(this.transform.center),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom));const i=this.terrain.getElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom);if(e<1&&i!==this._elevationTarget){const t=this._elevationTarget-this._elevationStart;this._elevationStart+=e*(t-(i-(t*e+this._elevationStart))/(1-e)),this._elevationTarget=i;}this.transform.setElevation(t.G.number(this._elevationStart,this._elevationTarget,e));}_finalizeElevation(){this._elevationFreeze=!1,this.getCenterClampedToGround()&&this.transform.recalculateZoomAndCenter(this.terrain);}_getTransformForUpdate(){return this.transformCameraUpdate||this.terrain?(this._requestedCameraState||(this._requestedCameraState=this.transform.clone()),this._requestedCameraState):this.transform}_elevateCameraIfInsideTerrain(e){if(!this.terrain&&e.elevation>=0&&e.pitch<=90)return {};const t=e.getCameraLngLat(),i=e.getCameraAltitude(),a=this.terrain?this.terrain.getElevationForLngLatZoom(t,e.zoom):0;if(i<a){const i=this.calculateCameraOptionsFromTo(t,a,e.center,e.elevation);return {pitch:i.pitch,zoom:i.zoom}}return {}}_applyUpdatedTransform(e){const t=[];if(t.push((e=>this._elevateCameraIfInsideTerrain(e))),this.transformCameraUpdate&&t.push((e=>this.transformCameraUpdate(e))),!t.length)return;const i=e.clone();for(const e of t){const t=i.clone(),{center:a,zoom:r,roll:o,pitch:s,bearing:n,elevation:l}=e(t);a&&t.setCenter(a),void 0!==l&&t.setElevation(l),void 0!==r&&t.setZoom(r),void 0!==o&&t.setRoll(o),void 0!==s&&t.setPitch(s),void 0!==n&&t.setBearing(n),i.apply(t,!1);}this.transform.apply(i,!1);}_fireMoveEvents(e){this.fire(new t.l("move",e)),this._zooming&&this.fire(new t.l("zoom",e)),this._rotating&&this.fire(new t.l("rotate",e)),this._pitching&&this.fire(new t.l("pitch",e)),this._rolling&&this.fire(new t.l("roll",e));}_afterEase(e,i){if(this._easeId&&i&&this._easeId===i)return;delete this._easeId;const a=this._zooming,r=this._rotating,o=this._pitching,s=this._rolling;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._rolling=!1,this._padding=!1,a&&this.fire(new t.l("zoomend",e)),r&&this.fire(new t.l("rotateend",e)),o&&this.fire(new t.l("pitchend",e)),s&&this.fire(new t.l("rollend",e)),this.fire(new t.l("moveend",e));}flyTo(e,i){if(!e.essential&&n.prefersReducedMotion){const a=t.U(e,["center","zoom","bearing","pitch","roll","elevation","padding"]);return this.jumpTo(a,i)}this.stop(),e=t.e({offset:[0,0],speed:1.2,curve:1.42,easing:t.cy},e);const a=this._getTransformForUpdate(),r=a.bearing,o=a.pitch,s=a.roll,l=a.padding,c="bearing"in e?this._normalizeBearing(e.bearing,r):r,h="pitch"in e?+e.pitch:o,u="roll"in e?this._normalizeBearing(e.roll,s):s,d="padding"in e?e.padding:a.padding,_=t.P.convert(e.offset);let p=a.centerPoint.add(_);const m=a.screenPointToLocation(p),f=this.cameraHelper.handleFlyTo(a,{bearing:c,pitch:h,roll:u,padding:d,locationAtOffset:m,offsetAsPoint:_,center:e.center,minZoom:e.minZoom,zoom:e.zoom});let g=e.curve;const v=Math.max(a.width,a.height),x=v/f.scaleOfZoom,b=f.pixelPathLength;"number"==typeof f.scaleOfMinZoom&&(g=Math.sqrt(v/f.scaleOfMinZoom/b*2));const y=g*g;function w(e){const t=(x*x-v*v+(e?-1:1)*y*y*b*b)/(2*(e?x:v)*y*b);return Math.log(Math.sqrt(t*t+1)-t)}function T(e){return (Math.exp(e)-Math.exp(-e))/2}function P(e){return (Math.exp(e)+Math.exp(-e))/2}const C=w(!1);let I=function(e){return P(C)/P(C+g*e)},M=function(e){return v*((P(C)*(T(t=C+g*e)/P(t))-T(C))/y)/b;var t;},E=(w(!0)-C)/g;if(Math.abs(b)<2e-6||!isFinite(E)){if(Math.abs(v-x)<1e-6)return this.easeTo(e,i);const t=x<v?-1:1;E=Math.abs(Math.log(x/v))/g,M=()=>0,I=e=>Math.exp(t*g*e);}return e.duration="duration"in e?+e.duration:1e3*E/("screenSpeed"in e?+e.screenSpeed/g:+e.speed),e.maxDuration&&e.duration>e.maxDuration&&(e.duration=0),this._zooming=!0,this._rotating=r!==c,this._pitching=h!==o,this._rolling=u!==s,this._padding=!a.isPaddingEqual(d),this._prepareEase(i,!1),this.terrain&&this._prepareElevation(f.targetCenter),this._ease((n=>{const m=n*E,g=1/I(m),v=M(m);this._rotating&&a.setBearing(t.G.number(r,c,n)),this._pitching&&a.setPitch(t.G.number(o,h,n)),this._rolling&&a.setRoll(t.G.number(s,u,n)),this._padding&&(a.interpolatePadding(l,d,n),p=a.centerPoint.add(_)),f.easeFunc(n,g,v,p),this.terrain&&!e.freezeElevation&&this._updateElevation(n),this._applyUpdatedTransform(a),this._fireMoveEvents(i);}),(()=>{this.terrain&&e.freezeElevation&&this._finalizeElevation(),this._afterEase(i);}),e),this}isEasing(){return !!this._easeFrameId}stop(){return this._stop()}_stop(e,t){var i;if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),delete this._easeFrameId,delete this._onEaseFrame),this._onEaseEnd){const e=this._onEaseEnd;delete this._onEaseEnd,e.call(this,t);}return e||null===(i=this.handlers)||void 0===i||i.stop(!1),this}_ease(e,t,i){!1===i.animate||0===i.duration?(e(1),t()):(this._easeStart=c(),this._easeOptions=i,this._onEaseFrame=e,this._onEaseEnd=t,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback));}_normalizeBearing(e,i){e=t.W(e,-180,180);const a=Math.abs(e-i);return Math.abs(e-360-i)<a&&(e-=360),Math.abs(e+360-i)<a&&(e+=360),e}queryTerrainElevation(e){return this.terrain?this.terrain.getElevationForLngLat(t.V.convert(e),this.transform):null}}const Ko={compact:!0,customAttribution:'<a href="https://maplibre.org/" target="_blank">MapLibre</a>'};class Yo{constructor(e=Ko){this._toggleAttribution=()=>{this._container.classList.contains("maplibregl-compact")&&(this._container.classList.contains("maplibregl-compact-show")?(this._container.setAttribute("open",""),this._container.classList.remove("maplibregl-compact-show")):(this._container.classList.add("maplibregl-compact-show"),this._container.removeAttribute("open")));},this._updateData=e=>{!e||"metadata"!==e.sourceDataType&&"visibility"!==e.sourceDataType&&"style"!==e.dataType&&"terrain"!==e.type||this._updateAttributions();},this._updateCompact=()=>{this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1===this._compact?this._container.setAttribute("open",""):this._container.classList.contains("maplibregl-compact")||this._container.classList.contains("maplibregl-attrib-empty")||(this._container.setAttribute("open",""),this._container.classList.add("maplibregl-compact","maplibregl-compact-show")):(this._container.setAttribute("open",""),this._container.classList.contains("maplibregl-compact")&&this._container.classList.remove("maplibregl-compact","maplibregl-compact-show"));},this._updateCompactMinimize=()=>{this._container.classList.contains("maplibregl-compact")&&this._container.classList.contains("maplibregl-compact-show")&&this._container.classList.remove("maplibregl-compact-show");},this.options=e;}getDefaultPosition(){return "bottom-right"}onAdd(e){return this._map=e,this._compact=this.options.compact,this._container=h.create("details","maplibregl-ctrl maplibregl-ctrl-attrib"),this._compactButton=h.create("summary","maplibregl-ctrl-attrib-button",this._container),this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=h.create("div","maplibregl-ctrl-attrib-inner",this._container),this._updateAttributions(),this._updateCompact(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("terrain",this._updateData),this._map.on("resize",this._updateCompact),this._map.on("drag",this._updateCompactMinimize),this._container}onRemove(){h.remove(this._container),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("terrain",this._updateData),this._map.off("resize",this._updateCompact),this._map.off("drag",this._updateCompactMinimize),this._map=void 0,this._compact=void 0,this._attribHTML=void 0;}_setElementTitle(e,t){const i=this._map._getUIString(`AttributionControl.${t}`);e.title=i,e.setAttribute("aria-label",i);}_updateAttributions(){if(!this._map.style)return;let e=[];if(this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?e=e.concat(this.options.customAttribution.map((e=>"string"!=typeof e?"":e))):"string"==typeof this.options.customAttribution&&e.push(this.options.customAttribution)),this._map.style.stylesheet){const e=this._map.style.stylesheet;this.styleOwner=e.owner,this.styleId=e.id;}const t=this._map.style.tileManagers;for(const i in t){const a=t[i];if(a.used||a.usedForTerrain){const t=a.getSource();t.attribution&&e.indexOf(t.attribution)<0&&e.push(t.attribution);}}e=e.filter((e=>String(e).trim())),e.sort(((e,t)=>e.length-t.length)),e=e.filter(((t,i)=>{for(let a=i+1;a<e.length;a++)if(e[a].indexOf(t)>=0)return !1;return !0}));const i=e.join(" | ");i!==this._attribHTML&&(this._attribHTML=i,e.length?(this._innerContainer.innerHTML=h.sanitize(i),this._container.classList.remove("maplibregl-attrib-empty")):this._container.classList.add("maplibregl-attrib-empty"),this._updateCompact(),this._editLink=null);}}class Qo{constructor(e={}){this._updateCompact=()=>{const e=this._container.children;if(e.length){const t=e[0];this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1!==this._compact&&t.classList.add("maplibregl-compact"):t.classList.remove("maplibregl-compact");}},this.options=e;}getDefaultPosition(){return "bottom-left"}onAdd(e){this._map=e,this._compact=this.options&&this.options.compact,this._container=h.create("div","maplibregl-ctrl");const t=h.create("a","maplibregl-ctrl-logo");return t.target="_blank",t.rel="noopener nofollow",t.href="https://maplibre.org/",t.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),t.setAttribute("rel","noopener nofollow"),this._container.appendChild(t),this._container.style.display="block",this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){h.remove(this._container),this._map.off("resize",this._updateCompact),this._map=void 0,this._compact=void 0;}}class Jo{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1;}add(e){const t=++this._id;return this._queue.push({callback:e,id:t,cancelled:!1}),t}remove(e){const t=this._currentlyRunning,i=t?this._queue.concat(t):this._queue;for(const t of i)if(t.id===e)return void(t.cancelled=!0)}run(e=0){if(this._currentlyRunning)throw new Error("Attempting to run(), but is already running.");const t=this._currentlyRunning=this._queue;this._queue=[];for(const i of t)if(!i.cancelled&&(i.callback(e),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1;}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[];}}var es=t.aU([{name:"a_pos3d",type:"Int16",components:3}]);class ts extends t.E{constructor(e){super(),this._lastTilesetChange=c(),this.tileManager=e,this._tiles={},this._renderableTilesKeys=[],this._sourceTileCache={},this.minzoom=0,this.maxzoom=22,this.deltaZoom=1,this.tileSize=e._source.tileSize*2**this.deltaZoom,e.usedForTerrain=!0,e.tileSize=this.tileSize;}destruct(){this.tileManager.usedForTerrain=!1,this.tileManager.tileSize=null;}getSource(){return this.tileManager._source}update(e,i){this.tileManager.update(e,i),this._renderableTilesKeys=[];const a={};for(const r of Ie(e,{tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,reparseOverscaled:!1,terrain:i,calculateTileZoom:this.tileManager._source.calculateTileZoom}))a[r.key]=!0,this._renderableTilesKeys.push(r.key),this._tiles[r.key]||(r.terrainRttPosMatrix32f=new Float64Array(16),t.c7(r.terrainRttPosMatrix32f,0,t.a5,t.a5,0,0,1),this._tiles[r.key]=new de(r,this.tileSize),this._lastTilesetChange=c());for(const e in this._tiles)a[e]||delete this._tiles[e];}freeRtt(e){for(const t in this._tiles){const i=this._tiles[t];(!e||i.tileID.equals(e)||i.tileID.isChildOf(e)||e.isChildOf(i.tileID))&&(i.rtt=[]);}}getRenderableTiles(){return this._renderableTilesKeys.map((e=>this.getTileByID(e)))}getTileByID(e){return this._tiles[e]}getTerrainCoords(e,t){return t?this._getTerrainCoordsForTileRanges(e,t):this._getTerrainCoordsForRegularTile(e)}_getTerrainCoordsForRegularTile(e){const i={};for(const a of this._renderableTilesKeys){const r=this._tiles[a].tileID,o=e.clone(),s=t.bk();if(r.canonical.equals(e.canonical))t.c7(s,0,t.a5,t.a5,0,0,1);else if(r.canonical.isChildOf(e.canonical)){const i=r.canonical.z-e.canonical.z,a=r.canonical.x-(r.canonical.x>>i<<i),o=r.canonical.y-(r.canonical.y>>i<<i),n=t.a5>>i;t.c7(s,0,n,n,0,0,1),t.O(s,s,[-a*n,-o*n,0]);}else {if(!e.canonical.isChildOf(r.canonical))continue;{const i=e.canonical.z-r.canonical.z,a=e.canonical.x-(e.canonical.x>>i<<i),o=e.canonical.y-(e.canonical.y>>i<<i),n=t.a5>>i;t.c7(s,0,t.a5,t.a5,0,0,1),t.O(s,s,[a*n,o*n,0]),t.Q(s,s,[1/2**i,1/2**i,0]);}}o.terrainRttPosMatrix32f=new Float32Array(s),i[a]=o;}return i}_getTerrainCoordsForTileRanges(e,i){const a={};for(const r of this._renderableTilesKeys){const o=this._tiles[r].tileID;if(!this._isWithinTileRanges(o,i))continue;const s=e.clone(),n=t.bk();if(o.canonical.z===e.canonical.z){const i=e.canonical.x-o.canonical.x+e.wrap*(1<<e.canonical.z),a=e.canonical.y-o.canonical.y;t.c7(n,0,t.a5,t.a5,0,0,1),t.O(n,n,[i*t.a5,a*t.a5,0]);}else if(o.canonical.z>e.canonical.z){const i=o.canonical.z-e.canonical.z,a=o.canonical.x-(o.canonical.x>>i<<i)+e.wrap*(1<<o.canonical.z),r=o.canonical.y-(o.canonical.y>>i<<i),s=e.canonical.x-(o.canonical.x>>i),l=e.canonical.y-(o.canonical.y>>i),c=t.a5>>i;t.c7(n,0,c,c,0,0,1),t.O(n,n,[-a*c+s*t.a5,-r*c+l*t.a5,0]);}else {const i=e.canonical.z-o.canonical.z,a=e.canonical.x-(e.canonical.x>>i<<i)+e.wrap*(1<<e.canonical.z),r=e.canonical.y-(e.canonical.y>>i<<i),s=(e.canonical.x>>i)-o.canonical.x,l=(e.canonical.y>>i)-o.canonical.y,c=t.a5<<i;t.c7(n,0,c,c,0,0,1),t.O(n,n,[a*t.a5+s*c,r*t.a5+l*c,0]);}s.terrainRttPosMatrix32f=new Float32Array(n),a[r]=s;}return a}getSourceTile(e,t){const i=this.tileManager._source;let a=e.overscaledZ-this.deltaZoom;if(a>i.maxzoom&&(a=i.maxzoom),a<i.minzoom)return;this._sourceTileCache[e.key]||(this._sourceTileCache[e.key]=e.scaledTo(a).key);let r=this.findTileInCaches(this._sourceTileCache[e.key]);if(!(null==r?void 0:r.dem)&&t)for(;a>=i.minzoom&&!(null==r?void 0:r.dem);)r=this.findTileInCaches(e.scaledTo(a--).key);return r}findTileInCaches(e){let t=this.tileManager.getTileByID(e);return t||(t=this.tileManager._outOfViewCache.getByKey(e),t)}anyTilesAfterTime(e=Date.now()){return this._lastTilesetChange>=e}_isWithinTileRanges(e,t){const i=t[e.canonical.z];return !!i&&(e.wrap>i.minWrap||e.wrap<i.maxWrap||e.canonical.x>=i.minTileXWrapped&&e.canonical.x<=i.maxTileXWrapped&&e.canonical.y>=i.minTileY&&e.canonical.y<=i.maxTileY)}}class is{constructor(e,t,i){this._meshCache={},this.painter=e,this.tileManager=new ts(t),this.options=i,this.exaggeration="number"==typeof i.exaggeration?i.exaggeration:1,this.qualityFactor=2,this.meshSize=128,this._demMatrixCache={},this.coordsIndex=[],this._coordsTextureSize=1024;}getDEMElevation(e,i,a,r=t.a5){var o;if(!(i>=0&&i<r&&a>=0&&a<r))return 0;const s=this.getTerrainData(e),n=null===(o=s.tile)||void 0===o?void 0:o.dem;if(!n)return 0;const l=t.cC([],[i/r*t.a5,a/r*t.a5],s.u_terrain_matrix),c=[l[0]*n.dim,l[1]*n.dim],h=Math.floor(c[0]),u=Math.floor(c[1]),d=c[0]-h,_=c[1]-u;return n.get(h,u)*(1-d)*(1-_)+n.get(h+1,u)*d*(1-_)+n.get(h,u+1)*(1-d)*_+n.get(h+1,u+1)*d*_}getElevationForLngLatZoom(e,i){if(!t.cD(i,e.wrap()))return 0;const{tileID:a,mercatorX:r,mercatorY:o}=this._getOverscaledTileIDFromLngLatZoom(e,i);return this.getElevation(a,r%t.a5,o%t.a5,t.a5)}getElevationForLngLat(e,t){const i=Ie(t,{maxzoom:this.tileManager.maxzoom,minzoom:this.tileManager.minzoom,tileSize:512,terrain:this});let a=0;for(const e of i)e.canonical.z>a&&(a=Math.min(e.canonical.z,this.tileManager.maxzoom));return this.getElevationForLngLatZoom(e,a)}getElevation(e,i,a,r=t.a5){return this.getDEMElevation(e,i,a,r)*this.exaggeration}getTerrainData(e){if(!this._emptyDemTexture){const e=this.painter.context,i=new t.R({width:1,height:1},new Uint8Array(4));this._emptyDepthTexture=new t.T(e,i,e.gl.RGBA,{premultiply:!1}),this._emptyDemUnpack=[0,0,0,0],this._emptyDemTexture=new t.T(e,new t.R({width:1,height:1}),e.gl.RGBA,{premultiply:!1}),this._emptyDemTexture.bind(e.gl.NEAREST,e.gl.CLAMP_TO_EDGE),this._emptyDemMatrix=t.ar([]);}const i=this.tileManager.getSourceTile(e,!0);if(i&&i.dem&&(!i.demTexture||i.needsTerrainPrepare)){const e=this.painter.context;i.demTexture=this.painter.getTileTexture(i.dem.stride),i.demTexture?i.demTexture.update(i.dem.getPixels(),{premultiply:!1}):i.demTexture=new t.T(e,i.dem.getPixels(),e.gl.RGBA,{premultiply:!1}),i.demTexture.bind(e.gl.NEAREST,e.gl.CLAMP_TO_EDGE),i.needsTerrainPrepare=!1;}const a=i&&i.toString()+i.tileID.key+e.key;if(a&&!this._demMatrixCache[a]){const a=this.tileManager.getSource().maxzoom;let r=e.canonical.z-i.tileID.canonical.z;e.overscaledZ>e.canonical.z&&(e.canonical.z>=a?r=e.canonical.z-a:t.w("cannot calculate elevation if elevation maxzoom > source.maxzoom"));const o=e.canonical.x-(e.canonical.x>>r<<r),s=e.canonical.y-(e.canonical.y>>r<<r),n=t.cE(new Float64Array(16),[1/(t.a5<<r),1/(t.a5<<r),0]);t.O(n,n,[o*t.a5,s*t.a5,0]),this._demMatrixCache[e.key]={matrix:n,coord:e};}return {u_depth:2,u_terrain:3,u_terrain_dim:i&&i.dem&&i.dem.dim||1,u_terrain_matrix:a?this._demMatrixCache[e.key].matrix:this._emptyDemMatrix,u_terrain_unpack:i&&i.dem&&i.dem.getUnpackVector()||this._emptyDemUnpack,u_terrain_exaggeration:this.exaggeration,texture:(i&&i.demTexture||this._emptyDemTexture).texture,depthTexture:(this._fboDepthTexture||this._emptyDepthTexture).texture,tile:i}}getFramebuffer(e){const i=this.painter,a=i.width/devicePixelRatio,r=i.height/devicePixelRatio;return !this._fbo||this._fbo.width===a&&this._fbo.height===r||(this._fbo.destroy(),this._fboCoordsTexture.destroy(),this._fboDepthTexture.destroy(),delete this._fbo,delete this._fboDepthTexture,delete this._fboCoordsTexture),this._fboCoordsTexture||(this._fboCoordsTexture=new t.T(i.context,{width:a,height:r,data:null},i.context.gl.RGBA,{premultiply:!1}),this._fboCoordsTexture.bind(i.context.gl.NEAREST,i.context.gl.CLAMP_TO_EDGE)),this._fboDepthTexture||(this._fboDepthTexture=new t.T(i.context,{width:a,height:r,data:null},i.context.gl.RGBA,{premultiply:!1}),this._fboDepthTexture.bind(i.context.gl.NEAREST,i.context.gl.CLAMP_TO_EDGE)),this._fbo||(this._fbo=i.context.createFramebuffer(a,r,!0,!1),this._fbo.depthAttachment.set(i.context.createRenderbuffer(i.context.gl.DEPTH_COMPONENT16,a,r))),this._fbo.colorAttachment.set("coords"===e?this._fboCoordsTexture.texture:this._fboDepthTexture.texture),this._fbo}getCoordsTexture(){const e=this.painter.context;if(this._coordsTexture)return this._coordsTexture;const i=new Uint8Array(this._coordsTextureSize*this._coordsTextureSize*4);for(let e=0,t=0;e<this._coordsTextureSize;e++)for(let a=0;a<this._coordsTextureSize;a++,t+=4)i[t+0]=255&a,i[t+1]=255&e,i[t+2]=a>>8<<4|e>>8,i[t+3]=0;const a=new t.R({width:this._coordsTextureSize,height:this._coordsTextureSize},new Uint8Array(i.buffer)),r=new t.T(e,a,e.gl.RGBA,{premultiply:!1});return r.bind(e.gl.NEAREST,e.gl.CLAMP_TO_EDGE),this._coordsTexture=r,r}pointCoordinate(e){this.painter.maybeDrawDepthAndCoords(!0);const i=new Uint8Array(4),a=this.painter.context,r=a.gl,o=Math.round(e.x*this.painter.pixelRatio/devicePixelRatio),s=Math.round(e.y*this.painter.pixelRatio/devicePixelRatio),n=Math.round(this.painter.height/devicePixelRatio);a.bindFramebuffer.set(this.getFramebuffer("coords").framebuffer),r.readPixels(o,n-s-1,1,1,r.RGBA,r.UNSIGNED_BYTE,i),a.bindFramebuffer.set(null);const l=i[0]+(i[2]>>4<<8),c=i[1]+((15&i[2])<<8),h=this.coordsIndex[255-i[3]],u=h&&this.tileManager.getTileByID(h);if(!u)return null;const d=this._coordsTextureSize,_=(1<<u.tileID.canonical.z)*d;return new t.a9((u.tileID.canonical.x*d+l)/_+u.tileID.wrap,(u.tileID.canonical.y*d+c)/_,this.getElevation(u.tileID,l,c,d))}depthAtPoint(e){const t=new Uint8Array(4),i=this.painter.context,a=i.gl;return i.bindFramebuffer.set(this.getFramebuffer("depth").framebuffer),a.readPixels(e.x,this.painter.height/devicePixelRatio-e.y-1,1,1,a.RGBA,a.UNSIGNED_BYTE,t),i.bindFramebuffer.set(null),(t[0]/16777216+t[1]/65536+t[2]/256+t[3])/256}getTerrainMesh(e){var i;const a=(null===(i=this.painter.style.projection)||void 0===i?void 0:i.transitionState)>0,r=a&&0===e.canonical.y,o=a&&e.canonical.y===(1<<e.canonical.z)-1,s=`m_${r?"n":""}_${o?"s":""}`;if(this._meshCache[s])return this._meshCache[s];const n=this.painter.context,l=new t.cF,c=new t.aY,h=this.meshSize,u=t.a5/h,d=h*h;for(let e=0;e<=h;e++)for(let t=0;t<=h;t++)l.emplaceBack(t*u,e*u,0);for(let e=0;e<d;e+=h+1)for(let t=0;t<h;t++)c.emplaceBack(t+e,h+t+e+1,h+t+e+2),c.emplaceBack(t+e,h+t+e+2,t+e+1);const _=l.length,p=_+(h+1),m=(h+1)*h,f=r?t.br:0,g=r?0:1,v=o?t.bs:t.a5,x=o?0:1;for(let e=0;e<=h;e++)l.emplaceBack(e*u,f,g);for(let e=0;e<=h;e++)l.emplaceBack(e*u,v,x);for(let e=0;e<h;e++)c.emplaceBack(m+e,p+e,p+e+1),c.emplaceBack(m+e,p+e+1,m+e+1),c.emplaceBack(0+e,_+e+1,_+e),c.emplaceBack(0+e,0+e+1,_+e+1);const b=l.length,y=b+2*(h+1);for(const e of [0,1])for(let i=0;i<=h;i++)for(const a of [0,1])l.emplaceBack(e*t.a5,i*u,a);for(let e=0;e<2*h;e+=2)c.emplaceBack(b+e,b+e+1,b+e+3),c.emplaceBack(b+e,b+e+3,b+e+2),c.emplaceBack(y+e,y+e+3,y+e+1),c.emplaceBack(y+e,y+e+2,y+e+3);const w=new kt(n.createVertexBuffer(l,es.members),n.createIndexBuffer(c),t.aX.simpleSegment(0,0,l.length,c.length));return this._meshCache[s]=w,w}getMeshFrameDelta(e){return 2*Math.PI*t.bE/Math.pow(2,Math.max(e,0))/5}getMinTileElevationForLngLatZoom(e,i){var a;if(!t.cD(i,e.wrap()))return 0;const{tileID:r}=this._getOverscaledTileIDFromLngLatZoom(e,i);return null!==(a=this.getMinMaxElevation(r).minElevation)&&void 0!==a?a:0}getMinMaxElevation(e){const t=this.getTerrainData(e).tile,i={minElevation:null,maxElevation:null};return t&&t.dem&&(i.minElevation=t.dem.min*this.exaggeration,i.maxElevation=t.dem.max*this.exaggeration),i}_getOverscaledTileIDFromLngLatZoom(e,i){const a=t.a9.fromLngLat(e.wrap()),r=(1<<i)*t.a5,o=a.x*r,s=a.y*r,n=Math.floor(o/t.a5),l=Math.floor(s/t.a5);return {tileID:new t.a2(i,0,i,n,l),mercatorX:o,mercatorY:s}}}class as{constructor(e,t,i){this._context=e,this._size=t,this._tileSize=i,this._objects=[],this._recentlyUsed=[],this._stamp=0;}destruct(){for(const e of this._objects)e.texture.destroy(),e.fbo.destroy();}_createObject(e){const i=this._context.createFramebuffer(this._tileSize,this._tileSize,!0,!0),a=new t.T(this._context,{width:this._tileSize,height:this._tileSize,data:null},this._context.gl.RGBA);return a.bind(this._context.gl.LINEAR,this._context.gl.CLAMP_TO_EDGE),this._context.extTextureFilterAnisotropic&&this._context.gl.texParameterf(this._context.gl.TEXTURE_2D,this._context.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,this._context.extTextureFilterAnisotropicMax),i.depthAttachment.set(this._context.createRenderbuffer(this._context.gl.DEPTH_STENCIL,this._tileSize,this._tileSize)),i.colorAttachment.set(a.texture),{id:e,fbo:i,texture:a,stamp:-1,inUse:!1}}getObjectForId(e){return this._objects[e]}useObject(e){e.inUse=!0,this._recentlyUsed=this._recentlyUsed.filter((t=>e.id!==t)),this._recentlyUsed.push(e.id);}stampObject(e){e.stamp=++this._stamp;}getOrCreateFreeObject(){for(const e of this._recentlyUsed)if(!this._objects[e].inUse)return this._objects[e];if(this._objects.length>=this._size)throw new Error("No free RenderPool available, call freeAllObjects() required!");const e=this._createObject(this._objects.length);return this._objects.push(e),e}freeObject(e){e.inUse=!1;}freeAllObjects(){for(const e of this._objects)this.freeObject(e);}isFull(){return !(this._objects.length<this._size)&&!1===this._objects.some((e=>!e.inUse))}}const rs={background:!0,fill:!0,line:!0,raster:!0,hillshade:!0,"color-relief":!0};class os{constructor(e,t){this.painter=e,this.terrain=t,this.pool=new as(e.context,30,t.tileManager.tileSize*t.qualityFactor);}destruct(){this.pool.destruct();}getTexture(e){return this.pool.getObjectForId(e.rtt[this._stacks.length-1].id).texture}prepareForRender(e,t){this._stacks=[],this._prevType=null,this._rttTiles=[],this._renderableTiles=this.terrain.tileManager.getRenderableTiles(),this._renderableLayerIds=e._order.filter((i=>!e._layers[i].isHidden(t))),this._coordsAscending={};for(const t in e.tileManagers){this._coordsAscending[t]={};const i=e.tileManagers[t].getVisibleCoordinates(),a=e.tileManagers[t].getSource(),r=a instanceof te?a.terrainTileRanges:null;for(const e of i){const i=this.terrain.tileManager.getTerrainCoords(e,r);for(const e in i)this._coordsAscending[t][e]||(this._coordsAscending[t][e]=[]),this._coordsAscending[t][e].push(i[e]);}}this._coordsAscendingStr={};for(const t of e._order){const i=e._layers[t],a=i.source;if(rs[i.type]&&!this._coordsAscendingStr[a]){this._coordsAscendingStr[a]={};for(const e in this._coordsAscending[a])this._coordsAscendingStr[a][e]=this._coordsAscending[a][e].map((e=>e.key)).sort().join();}}for(const e of this._renderableTiles)for(const t in this._coordsAscendingStr){const i=this._coordsAscendingStr[t][e.tileID.key];i&&i!==e.rttCoords[t]&&(e.rtt=[]);}}renderLayer(e,i){if(e.isHidden(this.painter.transform.zoom))return !1;const a=Object.assign(Object.assign({},i),{isRenderingToTexture:!0}),r=e.type,o=this.painter,s=this._renderableLayerIds[this._renderableLayerIds.length-1]===e.id;if(rs[r]&&(this._prevType&&rs[this._prevType]||this._stacks.push([]),this._prevType=r,this._stacks[this._stacks.length-1].push(e.id),!s))return !0;if(rs[this._prevType]||rs[r]&&s){this._prevType=r;const e=this._stacks.length-1,i=this._stacks[e]||[];for(const r of this._renderableTiles){if(this.pool.isFull()&&(Ur(this.painter,this.terrain,this._rttTiles,a),this._rttTiles=[],this.pool.freeAllObjects()),this._rttTiles.push(r),r.rtt[e]){const t=this.pool.getObjectForId(r.rtt[e].id);if(t.stamp===r.rtt[e].stamp){this.pool.useObject(t);continue}}const s=this.pool.getOrCreateFreeObject();this.pool.useObject(s),this.pool.stampObject(s),r.rtt[e]={id:s.id,stamp:s.stamp},o.context.bindFramebuffer.set(s.fbo.framebuffer),o.context.clear({color:t.bp.transparent,stencil:0}),o.currentStencilSource=void 0;for(let e=0;e<i.length;e++){const t=o.style._layers[i[e]],n=t.source?this._coordsAscending[t.source][r.tileID.key]:[r.tileID];o.context.viewport.set([0,0,s.fbo.width,s.fbo.height]),o._renderTileClippingMasks(t,n,!0),o.renderLayer(o,o.style.tileManagers[t.source],t,n,a),t.source&&(r.rttCoords[t.source]=this._coordsAscendingStr[t.source][r.tileID.key]);}}return Ur(this.painter,this.terrain,this._rttTiles,a),this._rttTiles=[],this.pool.freeAllObjects(),rs[r]}return !1}}const ss={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"MapLibre logo","Map.Title":"Map","Marker.Title":"Map marker","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","Popup.Close":"Close popup","ScaleControl.Feet":"ft","ScaleControl.Meters":"m","ScaleControl.Kilometers":"km","ScaleControl.Miles":"mi","ScaleControl.NauticalMiles":"nm","GlobeControl.Enable":"Enable globe","GlobeControl.Disable":"Disable globe","TerrainControl.Enable":"Enable terrain","TerrainControl.Disable":"Disable terrain","CooperativeGesturesHandler.WindowsHelpText":"Use Ctrl + scroll to zoom the map","CooperativeGesturesHandler.MacHelpText":"Use ⌘ + scroll to zoom the map","CooperativeGesturesHandler.MobileHelpText":"Use two fingers to move the map"},ns=i,ls={hash:!1,interactive:!0,bearingSnap:7,attributionControl:Ko,maplibreLogo:!1,refreshExpiredTiles:!0,canvasContextAttributes:{antialias:!1,preserveDrawingBuffer:!1,powerPreference:"high-performance",failIfMajorPerformanceCaveat:!1,desynchronized:!1,contextType:void 0},scrollZoom:!0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:60,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,cooperativeGestures:!1,trackResize:!0,center:[0,0],elevation:0,zoom:0,bearing:0,pitch:0,roll:0,renderWorldCopies:!0,maxTileCacheSize:null,maxTileCacheZoomLevels:t.c.MAX_TILE_CACHE_ZOOM_LEVELS,transformRequest:null,transformCameraUpdate:null,transformConstrain:null,fadeDuration:300,crossSourceCollisions:!0,clickTolerance:3,localIdeographFontFamily:"sans-serif",pitchWithRotate:!0,rollEnabled:!1,reduceMotion:void 0,validateStyle:!0,maxCanvasSize:[4096,4096],cancelPendingTileRequestsWhileZooming:!0,centerClampedToGround:!0,experimentalZoomLevelsToOverscale:void 0},cs={showCompass:!0,showZoom:!0,visualizePitch:!1,visualizeRoll:!0};class hs{constructor(e,i,a=!1){this.mousedown=e=>{this.startMove(e,h.mousePos(this.element,e)),h.addEventListener(window,"mousemove",this.mousemove),h.addEventListener(window,"mouseup",this.mouseup);},this.mousemove=e=>{this.move(e,h.mousePos(this.element,e));},this.mouseup=e=>{this._rotatePitchHandler.dragEnd(e),this.offTemp();},this.touchstart=e=>{1!==e.targetTouches.length?this.reset():(this._startPos=this._lastPos=h.touchPos(this.element,e.targetTouches)[0],this.startMove(e,this._startPos),h.addEventListener(window,"touchmove",this.touchmove,{passive:!1}),h.addEventListener(window,"touchend",this.touchend));},this.touchmove=e=>{1!==e.targetTouches.length?this.reset():(this._lastPos=h.touchPos(this.element,e.targetTouches)[0],this.move(e,this._lastPos));},this.touchend=e=>{0===e.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),delete this._startPos,delete this._lastPos,this.offTemp();},this.reset=()=>{this._rotatePitchHandler.reset(),delete this._startPos,delete this._lastPos,this.offTemp();},this._clickTolerance=10,this.element=i;const r=new yo;this._rotatePitchHandler=new mo({clickTolerance:3,move:(e,r)=>{const o=i.getBoundingClientRect(),s=new t.P((o.bottom-o.top)/2,(o.right-o.left)/2);return {bearingDelta:t.cx(new t.P(e.x,r.y),r,s),pitchDelta:a?-.5*(r.y-e.y):void 0}},moveStateManager:r,enable:!0,assignEvents:()=>{}}),this.map=e,h.addEventListener(i,"mousedown",this.mousedown),h.addEventListener(i,"touchstart",this.touchstart,{passive:!1}),h.addEventListener(i,"touchcancel",this.reset);}startMove(e,t){this._rotatePitchHandler.dragStart(e,t),h.disableDrag();}move(e,t){const i=this.map,{bearingDelta:a,pitchDelta:r}=this._rotatePitchHandler.dragMove(e,t)||{};a&&i.setBearing(i.getBearing()+a),r&&i.setPitch(i.getPitch()+r);}off(){const e=this.element;h.removeEventListener(e,"mousedown",this.mousedown),h.removeEventListener(e,"touchstart",this.touchstart,{passive:!1}),h.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),h.removeEventListener(window,"touchend",this.touchend),h.removeEventListener(e,"touchcancel",this.reset),this.offTemp();}offTemp(){h.enableDrag(),h.removeEventListener(window,"mousemove",this.mousemove),h.removeEventListener(window,"mouseup",this.mouseup),h.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),h.removeEventListener(window,"touchend",this.touchend);}}let us;function ds(e,i,a,r=!1){if(r||!a.getCoveringTilesDetailsProvider().allowWorldCopies())return null==e?void 0:e.wrap();const o=new t.V(e.lng,e.lat);if(e=new t.V(e.lng,e.lat),i){const r=new t.V(e.lng-360,e.lat),o=new t.V(e.lng+360,e.lat),s=a.locationToScreenPoint(e).distSqr(i);a.locationToScreenPoint(r).distSqr(i)<s?e=r:a.locationToScreenPoint(o).distSqr(i)<s&&(e=o);}for(;Math.abs(e.lng-a.center.lng)>180;){const t=a.locationToScreenPoint(e);if(t.x>=0&&t.y>=0&&t.x<=a.width&&t.y<=a.height)break;e.lng>a.center.lng?e.lng-=360:e.lng+=360;}return e.lng!==o.lng&&a.isPointOnMapSurface(a.locationToScreenPoint(e))?e:o}const _s={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};function ps(e,t,i){const a=e.classList;for(const e in _s)a.remove(`maplibregl-${i}-anchor-${e}`);a.add(`maplibregl-${i}-anchor-${t}`);}class ms extends t.E{constructor(e){if(super(),this._onKeyPress=e=>{const t=e.code,i=e.charCode||e.keyCode;"Space"!==t&&"Enter"!==t&&32!==i&&13!==i||this.togglePopup();},this._onMapClick=e=>{const t=e.originalEvent.target,i=this._element;this._popup&&(t===i||i.contains(t))&&this.togglePopup();},this._update=e=>{if(!this._map)return;const t=this._map.loaded()&&!this._map.isMoving();("terrain"===(null==e?void 0:e.type)||"render"===(null==e?void 0:e.type)&&!t)&&this._map.once("render",this._update),this._lngLat=ds(this._lngLat,this._flatPos,this._map.transform),this._flatPos=this._pos=this._map.project(this._lngLat)._add(this._offset),this._map.terrain&&(this._flatPos=this._map.transform.locationToScreenPoint(this._lngLat)._add(this._offset));let i="";"viewport"===this._rotationAlignment||"auto"===this._rotationAlignment?i=`rotateZ(${this._rotation}deg)`:"map"===this._rotationAlignment&&(i=`rotateZ(${this._rotation-this._map.getBearing()}deg)`);let a="";"viewport"===this._pitchAlignment||"auto"===this._pitchAlignment?a="rotateX(0deg)":"map"===this._pitchAlignment&&(a=`rotateX(${this._map.getPitch()}deg)`),this._subpixelPositioning||e&&"moveend"!==e.type||(this._pos=this._pos.round()),h.setTransform(this._element,`${_s[this._anchor]} translate(${this._pos.x}px, ${this._pos.y}px) ${a} ${i}`),n.frameAsync(new AbortController).then((()=>{this._updateOpacity(e&&"moveend"===e.type);})).catch((()=>{}));},this._onMove=e=>{if(!this._isDragging){const t=this._clickTolerance||this._map._clickTolerance;this._isDragging=e.point.dist(this._pointerdownPos)>=t;}this._isDragging&&(this._pos=e.point.sub(this._positionDelta),this._lngLat=this._map.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new t.l("dragstart"))),this.fire(new t.l("drag")));},this._onUp=()=>{this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1,this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),"active"===this._state&&this.fire(new t.l("dragend")),this._state="inactive";},this._addDragHandler=e=>{this._element.contains(e.originalEvent.target)&&(e.preventDefault(),this._positionDelta=e.point.sub(this._pos).add(this._offset),this._pointerdownPos=e.point,this._state="pending",this._map.on("mousemove",this._onMove),this._map.on("touchmove",this._onMove),this._map.once("mouseup",this._onUp),this._map.once("touchend",this._onUp));},this._anchor=e&&e.anchor||"center",this._color=e&&e.color||"#3FB1CE",this._scale=e&&e.scale||1,this._draggable=e&&e.draggable||!1,this._clickTolerance=e&&e.clickTolerance||0,this._subpixelPositioning=e&&e.subpixelPositioning||!1,this._isDragging=!1,this._state="inactive",this._rotation=e&&e.rotation||0,this._rotationAlignment=e&&e.rotationAlignment||"auto",this._pitchAlignment=e&&e.pitchAlignment&&"auto"!==e.pitchAlignment?e.pitchAlignment:this._rotationAlignment,this.setOpacity(null==e?void 0:e.opacity,null==e?void 0:e.opacityWhenCovered),e&&e.element)this._element=e.element,this._offset=t.P.convert(e&&e.offset||[0,0]);else {this._defaultMarker=!0,this._element=h.create("div");const i=h.createNS("http://www.w3.org/2000/svg","svg"),a=41,r=27;i.setAttributeNS(null,"display","block"),i.setAttributeNS(null,"height",`${a}px`),i.setAttributeNS(null,"width",`${r}px`),i.setAttributeNS(null,"viewBox",`0 0 ${r} ${a}`);const o=h.createNS("http://www.w3.org/2000/svg","g");o.setAttributeNS(null,"stroke","none"),o.setAttributeNS(null,"stroke-width","1"),o.setAttributeNS(null,"fill","none"),o.setAttributeNS(null,"fill-rule","evenodd");const s=h.createNS("http://www.w3.org/2000/svg","g");s.setAttributeNS(null,"fill-rule","nonzero");const n=h.createNS("http://www.w3.org/2000/svg","g");n.setAttributeNS(null,"transform","translate(3.0, 29.0)"),n.setAttributeNS(null,"fill","#000000");const l=[{rx:"10.5",ry:"5.25002273"},{rx:"10.5",ry:"5.25002273"},{rx:"9.5",ry:"4.77275007"},{rx:"8.5",ry:"4.29549936"},{rx:"7.5",ry:"3.81822308"},{rx:"6.5",ry:"3.34094679"},{rx:"5.5",ry:"2.86367051"},{rx:"4.5",ry:"2.38636864"}];for(const e of l){const t=h.createNS("http://www.w3.org/2000/svg","ellipse");t.setAttributeNS(null,"opacity","0.04"),t.setAttributeNS(null,"cx","10.5"),t.setAttributeNS(null,"cy","5.80029008"),t.setAttributeNS(null,"rx",e.rx),t.setAttributeNS(null,"ry",e.ry),n.appendChild(t);}const c=h.createNS("http://www.w3.org/2000/svg","g");c.setAttributeNS(null,"fill",this._color);const u=h.createNS("http://www.w3.org/2000/svg","path");u.setAttributeNS(null,"d","M27,13.5 C27,19.074644 20.250001,27.000002 14.75,34.500002 C14.016665,35.500004 12.983335,35.500004 12.25,34.500002 C6.7499993,27.000002 0,19.222562 0,13.5 C0,6.0441559 6.0441559,0 13.5,0 C20.955844,0 27,6.0441559 27,13.5 Z"),c.appendChild(u);const d=h.createNS("http://www.w3.org/2000/svg","g");d.setAttributeNS(null,"opacity","0.25"),d.setAttributeNS(null,"fill","#000000");const _=h.createNS("http://www.w3.org/2000/svg","path");_.setAttributeNS(null,"d","M13.5,0 C6.0441559,0 0,6.0441559 0,13.5 C0,19.222562 6.7499993,27 12.25,34.5 C13,35.522727 14.016664,35.500004 14.75,34.5 C20.250001,27 27,19.074644 27,13.5 C27,6.0441559 20.955844,0 13.5,0 Z M13.5,1 C20.415404,1 26,6.584596 26,13.5 C26,15.898657 24.495584,19.181431 22.220703,22.738281 C19.945823,26.295132 16.705119,30.142167 13.943359,33.908203 C13.743445,34.180814 13.612715,34.322738 13.5,34.441406 C13.387285,34.322738 13.256555,34.180814 13.056641,33.908203 C10.284481,30.127985 7.4148684,26.314159 5.015625,22.773438 C2.6163816,19.232715 1,15.953538 1,13.5 C1,6.584596 6.584596,1 13.5,1 Z"),d.appendChild(_);const p=h.createNS("http://www.w3.org/2000/svg","g");p.setAttributeNS(null,"transform","translate(6.0, 7.0)"),p.setAttributeNS(null,"fill","#FFFFFF");const m=h.createNS("http://www.w3.org/2000/svg","g");m.setAttributeNS(null,"transform","translate(8.0, 8.0)");const f=h.createNS("http://www.w3.org/2000/svg","circle");f.setAttributeNS(null,"fill","#000000"),f.setAttributeNS(null,"opacity","0.25"),f.setAttributeNS(null,"cx","5.5"),f.setAttributeNS(null,"cy","5.5"),f.setAttributeNS(null,"r","5.4999962");const g=h.createNS("http://www.w3.org/2000/svg","circle");g.setAttributeNS(null,"fill","#FFFFFF"),g.setAttributeNS(null,"cx","5.5"),g.setAttributeNS(null,"cy","5.5"),g.setAttributeNS(null,"r","5.4999962"),m.appendChild(f),m.appendChild(g),s.appendChild(n),s.appendChild(c),s.appendChild(d),s.appendChild(p),s.appendChild(m),i.appendChild(s),i.setAttributeNS(null,"height",a*this._scale+"px"),i.setAttributeNS(null,"width",r*this._scale+"px"),this._element.appendChild(i),this._offset=t.P.convert(e&&e.offset||[0,-14]);}if(this._element.classList.add("maplibregl-marker"),this._element.addEventListener("dragstart",(e=>{e.preventDefault();})),this._element.addEventListener("mousedown",(e=>{e.preventDefault();})),ps(this._element,this._anchor,"marker"),e&&e.className)for(const t of e.className.split(" "))this._element.classList.add(t);this._popup=null;}addTo(e){return this.remove(),this._map=e,this._element.hasAttribute("aria-label")||this._element.setAttribute("aria-label",e._getUIString("Marker.Title")),this._element.hasAttribute("role")||this._element.setAttribute("role","button"),e.getCanvasContainer().appendChild(this._element),e.on("move",this._update),e.on("moveend",this._update),e.on("terrain",this._update),e.on("projectiontransition",this._update),this.setDraggable(this._draggable),this._update(),this._map.on("click",this._onMapClick),this}remove(){return this._opacityTimeout&&(clearTimeout(this._opacityTimeout),delete this._opacityTimeout),this._map&&(this._map.off("click",this._onMapClick),this._map.off("move",this._update),this._map.off("moveend",this._update),this._map.off("terrain",this._update),this._map.off("projectiontransition",this._update),this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler),this._map.off("mouseup",this._onUp),this._map.off("touchend",this._onUp),this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),delete this._map),h.remove(this._element),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(e){return this._lngLat=t.V.convert(e),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(),this}getElement(){return this._element}setPopup(e){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),e){if(!("offset"in e.options)){const t=38.1,i=13.5,a=Math.abs(i)/Math.SQRT2;e.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-t],"bottom-left":[a,-1*(t-i+a)],"bottom-right":[-a,-1*(t-i+a)],left:[i,-1*(t-i)],right:[-i,-1*(t-i)]}:this._offset;}this._popup=e,this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress);}return this}setSubpixelPositioning(e){return this._subpixelPositioning=e,this}getPopup(){return this._popup}togglePopup(){const e=this._popup;return this._element.style.opacity===this._opacityWhenCovered?this:e?(e.isOpen()?e.remove():(e.setLngLat(this._lngLat),e.addTo(this._map)),this):this}_updateOpacity(e=!1){var i,a;const r=null===(i=this._map)||void 0===i?void 0:i.terrain,o=this._map.transform.isLocationOccluded(this._lngLat);if(!r||o){const e=o?this._opacityWhenCovered:this._opacity;return void(this._element.style.opacity!==e&&(this._element.style.opacity=e))}if(e)this._opacityTimeout=null;else {if(this._opacityTimeout)return;this._opacityTimeout=setTimeout((()=>{this._opacityTimeout=null;}),100);}const s=this._map,n=s.terrain.depthAtPoint(this._pos),l=s.terrain.getElevationForLngLat(this._lngLat,s.transform);if(s.transform.lngLatToCameraDepth(this._lngLat,l)-n<.006)return void(this._element.style.opacity=this._opacity);const c=-this._offset.y/s.transform.pixelsPerMeter,h=Math.sin(s.getPitch()*Math.PI/180)*c,u=s.terrain.depthAtPoint(new t.P(this._pos.x,this._pos.y-this._offset.y)),d=s.transform.lngLatToCameraDepth(this._lngLat,l+h)-u>.006;(null===(a=this._popup)||void 0===a?void 0:a.isOpen())&&d&&this._popup.remove(),this._element.style.opacity=d?this._opacityWhenCovered:this._opacity;}getOffset(){return this._offset}setOffset(e){return this._offset=t.P.convert(e),this._update(),this}addClassName(e){this._element.classList.add(e);}removeClassName(e){this._element.classList.remove(e);}toggleClassName(e){return this._element.classList.toggle(e)}setDraggable(e){return this._draggable=!!e,this._map&&(e?(this._map.on("mousedown",this._addDragHandler),this._map.on("touchstart",this._addDragHandler)):(this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(e){return this._rotation=e||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(e){return this._rotationAlignment=e||"auto",this._update(),this}getRotationAlignment(){return this._rotationAlignment}setPitchAlignment(e){return this._pitchAlignment=e&&"auto"!==e?e:this._rotationAlignment,this._update(),this}getPitchAlignment(){return this._pitchAlignment}setOpacity(e,t){return (void 0===this._opacity||void 0===e&&void 0===t)&&(this._opacity="1",this._opacityWhenCovered="0.2"),void 0!==e&&(this._opacity=e),void 0!==t&&(this._opacityWhenCovered=t),this._map&&this._updateOpacity(!0),this}}const fs={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0};let gs=0,vs=!1;const xs={maxWidth:100,unit:"metric"};function bs(e,t,i){const a=i&&i.maxWidth||100,r=e._container.clientHeight/2,o=e._container.clientWidth/2,s=e.unproject([o-a/2,r]),n=e.unproject([o+a/2,r]),l=Math.round(e.project(n).x-e.project(s).x),c=Math.min(a,l,e._container.clientWidth),h=s.distanceTo(n);if(i&&"imperial"===i.unit){const i=3.2808*h;i>5280?ys(t,c,i/5280,e._getUIString("ScaleControl.Miles")):ys(t,c,i,e._getUIString("ScaleControl.Feet"));}else i&&"nautical"===i.unit?ys(t,c,h/1852,e._getUIString("ScaleControl.NauticalMiles")):h>=1e3?ys(t,c,h/1e3,e._getUIString("ScaleControl.Kilometers")):ys(t,c,h,e._getUIString("ScaleControl.Meters"));}function ys(e,t,i,a){const r=function(e){const t=Math.pow(10,`${Math.floor(e)}`.length-1);let i=e/t;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(e){const t=Math.pow(10,Math.ceil(-Math.log(e)/Math.LN10));return Math.round(e*t)/t}(i),t*i}(i);e.style.width=t*(r/i)+"px",e.innerHTML=`${r}&nbsp;${a}`;}const ws={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px",subpixelPositioning:!1,locationOccludedOpacity:void 0,padding:void 0},Ts=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", ");function Ps(e){if(e){if("number"==typeof e){const i=Math.round(Math.abs(e)/Math.SQRT2);return {center:new t.P(0,0),top:new t.P(0,e),"top-left":new t.P(i,i),"top-right":new t.P(-i,i),bottom:new t.P(0,-e),"bottom-left":new t.P(i,-i),"bottom-right":new t.P(-i,-i),left:new t.P(e,0),right:new t.P(-e,0)}}if(e instanceof t.P||Array.isArray(e)){const i=t.P.convert(e);return {center:i,top:i,"top-left":i,"top-right":i,bottom:i,"bottom-left":i,"bottom-right":i,left:i,right:i}}return {center:t.P.convert(e.center||[0,0]),top:t.P.convert(e.top||[0,0]),"top-left":t.P.convert(e["top-left"]||[0,0]),"top-right":t.P.convert(e["top-right"]||[0,0]),bottom:t.P.convert(e.bottom||[0,0]),"bottom-left":t.P.convert(e["bottom-left"]||[0,0]),"bottom-right":t.P.convert(e["bottom-right"]||[0,0]),left:t.P.convert(e.left||[0,0]),right:t.P.convert(e.right||[0,0])}}return Ps(new t.P(0,0))}const Cs=i;e.AJAXError=t.cI,e.Event=t.l,e.Evented=t.E,e.LngLat=t.V,e.MercatorCoordinate=t.a9,e.Point=t.P,e.addProtocol=t.cJ,e.config=t.c,e.removeProtocol=t.cK,e.AttributionControl=Yo,e.BoxZoomHandler=co,e.CanvasSource=ae,e.CooperativeGesturesHandler=Vo,e.DoubleClickZoomHandler=Oo,e.DragPanHandler=Zo,e.DragRotateHandler=Go,e.EdgeInsets=Nt,e.FullscreenControl=class extends t.E{constructor(e={}){super(),this._onFullscreenChange=()=>{var e;let t=window.document.fullscreenElement||window.document.mozFullScreenElement||window.document.webkitFullscreenElement||window.document.msFullscreenElement;for(;null===(e=null==t?void 0:t.shadowRoot)||void 0===e?void 0:e.fullscreenElement;)t=t.shadowRoot.fullscreenElement;t===this._container!==this._fullscreen&&this._handleFullscreenChange();},this._onClickFullscreen=()=>{this._isFullscreen()?this._exitFullscreen():this._requestFullscreen();},this._fullscreen=!1,e&&e.container&&(e.container instanceof HTMLElement?this._container=e.container:t.w("Full screen control 'container' must be a DOM element.")),"onfullscreenchange"in document?this._fullscreenchange="fullscreenchange":"onmozfullscreenchange"in document?this._fullscreenchange="mozfullscreenchange":"onwebkitfullscreenchange"in document?this._fullscreenchange="webkitfullscreenchange":"onmsfullscreenchange"in document&&(this._fullscreenchange="MSFullscreenChange");}onAdd(e){return this._map=e,this._container||(this._container=this._map.getContainer()),this._controlContainer=h.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),this._controlContainer}onRemove(){h.remove(this._controlContainer),this._map=null,window.document.removeEventListener(this._fullscreenchange,this._onFullscreenChange);}_setupUI(){const e=this._fullscreenButton=h.create("button","maplibregl-ctrl-fullscreen",this._controlContainer);h.create("span","maplibregl-ctrl-icon",e).setAttribute("aria-hidden","true"),e.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),window.document.addEventListener(this._fullscreenchange,this._onFullscreenChange);}_updateTitle(){const e=this._getTitle();this._fullscreenButton.setAttribute("aria-label",e),this._fullscreenButton.title=e;}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_handleFullscreenChange(){this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("maplibregl-ctrl-shrink"),this._fullscreenButton.classList.toggle("maplibregl-ctrl-fullscreen"),this._updateTitle(),this._fullscreen?(this.fire(new t.l("fullscreenstart")),this._prevCooperativeGesturesEnabled=this._map.cooperativeGestures.isEnabled(),this._map.cooperativeGestures.disable()):(this.fire(new t.l("fullscreenend")),this._prevCooperativeGesturesEnabled&&this._map.cooperativeGestures.enable());}_exitFullscreen(){window.document.exitFullscreen?window.document.exitFullscreen():window.document.mozCancelFullScreen?window.document.mozCancelFullScreen():window.document.msExitFullscreen?window.document.msExitFullscreen():window.document.webkitCancelFullScreen?window.document.webkitCancelFullScreen():this._togglePseudoFullScreen();}_requestFullscreen(){this._container.requestFullscreen?this._container.requestFullscreen():this._container.mozRequestFullScreen?this._container.mozRequestFullScreen():this._container.msRequestFullscreen?this._container.msRequestFullscreen():this._container.webkitRequestFullscreen?this._container.webkitRequestFullscreen():this._togglePseudoFullScreen();}_togglePseudoFullScreen(){this._container.classList.toggle("maplibregl-pseudo-fullscreen"),this._handleFullscreenChange(),this._map.resize();}},e.GeoJSONSource=ee,e.GeolocateControl=class extends t.E{constructor(e){super(),this._onSuccess=e=>{if(this._map){if(this._isOutOfMapMaxBounds(e))return this._setErrorState(),this.fire(new t.l("outofmaxbounds",e)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=e,this._watchState){case "WAITING_ACTIVE":case "ACTIVE_LOCK":case "ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case "BACKGROUND":case "BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background");break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(e),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(e),this.options.showUserLocation&&this._dotElement.classList.remove("maplibregl-user-location-dot-stale"),this.fire(new t.l("geolocate",e)),this._finish();}},this._updateCamera=e=>{const i=new t.V(e.coords.longitude,e.coords.latitude),a=e.coords.accuracy,r=this._map.getBearing(),o=t.e({bearing:r},this.options.fitBoundsOptions),s=$.fromLngLat(i,a);this._map.fitBounds(s,o,{geolocateSource:!0});},this._updateMarker=e=>{if(e){const i=new t.V(e.coords.longitude,e.coords.latitude);this._accuracyCircleMarker.setLngLat(i).addTo(this._map),this._userLocationDotMarker.setLngLat(i).addTo(this._map),this._accuracy=e.coords.accuracy,this._updateCircleRadiusIfNeeded();}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove();},this._onUpdate=()=>{this._updateCircleRadiusIfNeeded();},this._onError=e=>{if(this._map){if(1===e.code){this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const e=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e),void 0!==this._geolocationWatchID&&this._clearWatch();}else {if(3===e.code&&vs)return;this._setErrorState();}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("maplibregl-user-location-dot-stale"),this.fire(new t.l("error",e)),this._finish();}},this._finish=()=>{this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0;},this._setupUI=()=>{this._map&&(this._container.addEventListener("contextmenu",(e=>e.preventDefault())),this._geolocateButton=h.create("button","maplibregl-ctrl-geolocate",this._container),h.create("span","maplibregl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden","true"),this._geolocateButton.type="button",this._geolocateButton.disabled=!0);},this._finishSetupUI=e=>{if(this._map){if(!1===e){t.w("Geolocation support is not available so the GeolocateControl will be disabled.");const e=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e);}else {const e=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.disabled=!1,this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e);}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=h.create("div","maplibregl-user-location-dot"),this._userLocationDotMarker=new ms({element:this._dotElement}),this._circleElement=h.create("div","maplibregl-user-location-accuracy-circle"),this._accuracyCircleMarker=new ms({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onUpdate),this._map.on("move",this._onUpdate),this._map.on("rotate",this._onUpdate),this._map.on("pitch",this._onUpdate)),this._geolocateButton.addEventListener("click",(()=>this.trigger())),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",(e=>{const i=(null==e?void 0:e[0])instanceof ResizeObserverEntry;e.geolocateSource||"ACTIVE_LOCK"!==this._watchState||i||this._map.isZooming()||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this.fire(new t.l("trackuserlocationend")),this.fire(new t.l("userlocationlostfocus")));}));}},this.options=t.e({},fs,e);}onAdd(e){return this._map=e,this._container=h.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),function(){return t._(this,arguments,void 0,(function*(e=!1){if(void 0!==us&&!e)return us;if(void 0===window.navigator.permissions)return us=!!window.navigator.geolocation,us;try{const e=yield window.navigator.permissions.query({name:"geolocation"});us="denied"!==e.state;}catch(e){us=!!window.navigator.geolocation;}return us}))}().then((e=>this._finishSetupUI(e))),this._container}onRemove(){void 0!==this._geolocationWatchID&&(window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),h.remove(this._container),this._map.off("zoom",this._onUpdate),this._map.off("move",this._onUpdate),this._map.off("rotate",this._onUpdate),this._map.off("pitch",this._onUpdate),this._map=void 0,gs=0,vs=!1;}_isOutOfMapMaxBounds(e){const t=this._map.getMaxBounds(),i=e.coords;return t&&(i.longitude<t.getWest()||i.longitude>t.getEast()||i.latitude<t.getSouth()||i.latitude>t.getNorth())}_setErrorState(){switch(this._watchState){case "WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error");break;case "ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case "BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case "ACTIVE_ERROR":case "BACKGROUND_ERROR":case "OFF":case void 0:break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}}_updateCircleRadiusIfNeeded(){const e=this._userLocationDotMarker.getLngLat();if(!(this.options.showUserLocation&&this.options.showAccuracyCircle&&this._accuracy&&e))return;const t=this._map.project(e),i=this._map.unproject([t.x+100,t.y]),a=e.distanceTo(i)/100,r=2*this._accuracy/a;this._circleElement.style.width=`${r.toFixed(2)}px`,this._circleElement.style.height=`${r.toFixed(2)}px`;}trigger(){if(!this._setup)return t.w("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case "OFF":this._watchState="WAITING_ACTIVE",this.fire(new t.l("trackuserlocationstart"));break;case "WAITING_ACTIVE":case "ACTIVE_LOCK":case "ACTIVE_ERROR":case "BACKGROUND_ERROR":gs--,vs=!1,this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this.fire(new t.l("trackuserlocationend"));break;case "BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new t.l("trackuserlocationstart")),this.fire(new t.l("userlocationfocus"));break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}switch(this._watchState){case "WAITING_ACTIVE":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case "ACTIVE_LOCK":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case "OFF":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let e;this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),gs++,gs>1?(e={maximumAge:6e5,timeout:0},vs=!0):(e=this.options.positionOptions,vs=!1),this._geolocationWatchID=window.navigator.geolocation.watchPosition(this._onSuccess,this._onError,e);}}else window.navigator.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return !0}_clearWatch(){window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null);}},e.GlobeControl=class{constructor(){this._toggleProjection=()=>{var e;const t=null===(e=this._map.getProjection())||void 0===e?void 0:e.type;this._map.setProjection("mercator"!==t&&t?{type:"mercator"}:{type:"globe"}),this._updateGlobeIcon();},this._updateGlobeIcon=()=>{var e;this._globeButton.classList.remove("maplibregl-ctrl-globe"),this._globeButton.classList.remove("maplibregl-ctrl-globe-enabled"),"globe"===(null===(e=this._map.getProjection())||void 0===e?void 0:e.type)?(this._globeButton.classList.add("maplibregl-ctrl-globe-enabled"),this._globeButton.title=this._map._getUIString("GlobeControl.Disable")):(this._globeButton.classList.add("maplibregl-ctrl-globe"),this._globeButton.title=this._map._getUIString("GlobeControl.Enable"));};}onAdd(e){return this._map=e,this._container=h.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._globeButton=h.create("button","maplibregl-ctrl-globe",this._container),h.create("span","maplibregl-ctrl-icon",this._globeButton).setAttribute("aria-hidden","true"),this._globeButton.type="button",this._globeButton.addEventListener("click",this._toggleProjection),this._updateGlobeIcon(),this._map.on("styledata",this._updateGlobeIcon),this._container}onRemove(){h.remove(this._container),this._map.off("styledata",this._updateGlobeIcon),this._globeButton.removeEventListener("click",this._toggleProjection),this._map=void 0;}},e.Hash=$r,e.ImageSource=te,e.KeyboardHandler=Ao,e.LngLatBounds=$,e.LogoControl=Qo,e.Map=class extends Xo{constructor(e){var i,a;t.cG.mark(t.cH.create);const r=Object.assign(Object.assign(Object.assign({},ls),e),{canvasContextAttributes:Object.assign(Object.assign({},ls.canvasContextAttributes),e.canvasContextAttributes)});if(null!=r.minZoom&&null!=r.maxZoom&&r.minZoom>r.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=r.minPitch&&null!=r.maxPitch&&r.minPitch>r.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=r.minPitch&&r.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=r.maxPitch&&r.maxPitch>180)throw new Error("maxPitch must be less than or equal to 180");const o=new $t,s=new Yt;if(void 0!==r.minZoom&&o.setMinZoom(r.minZoom),void 0!==r.maxZoom&&o.setMaxZoom(r.maxZoom),void 0!==r.minPitch&&o.setMinPitch(r.minPitch),void 0!==r.maxPitch&&o.setMaxPitch(r.maxPitch),void 0!==r.renderWorldCopies&&o.setRenderWorldCopies(r.renderWorldCopies),null!==r.transformConstrain&&o.setConstrainOverride(r.transformConstrain),super(o,s,{bearingSnap:r.bearingSnap}),this._idleTriggered=!1,this._crossFadingFactor=1,this._renderTaskQueue=new Jo,this._controls=[],this._mapId=t.af(),this._lostContextStyle={style:null,images:null},this._contextLost=e=>{e.preventDefault(),this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this.painter.destroy();for(const e of Object.values(this.style._layers))if("custom"===e.type&&console.warn(`Custom layer with id '${e.id}' cannot be restored after WebGL context loss. You will need to re-add it manually after context restoration.`),e._listeners)for(const[t]of Object.entries(e._listeners))console.warn(`Custom layer with id '${e.id}' had event listeners for event '${t}' which cannot be restored after WebGL context loss. You will need to re-add them manually after context restoration.`);this._lostContextStyle=this._getStyleAndImages(),this.style.destroy(),this.style=null,this.fire(new t.l("webglcontextlost",{originalEvent:e}));},this._contextRestored=e=>{this._lostContextStyle.style&&this.setStyle(this._lostContextStyle.style,{diff:!1}),this._lostContextStyle.images&&(this.style.imageManager.images=this._lostContextStyle.images),this._lostContextStyle={style:null,images:null},this._setupPainter(),this.resize(),this._update(),this._resizeInternal(),this.fire(new t.l("webglcontextrestored",{originalEvent:e}));},this._onMapScroll=e=>{if(e.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1},this._onWindowOnline=()=>{this._update();},this._interactive=r.interactive,this._maxTileCacheSize=r.maxTileCacheSize,this._maxTileCacheZoomLevels=r.maxTileCacheZoomLevels,this._canvasContextAttributes=Object.assign({},r.canvasContextAttributes),this._trackResize=!0===r.trackResize,this._bearingSnap=r.bearingSnap,this._centerClampedToGround=r.centerClampedToGround,this._refreshExpiredTiles=!0===r.refreshExpiredTiles,this._fadeDuration=r.fadeDuration,this._crossSourceCollisions=!0===r.crossSourceCollisions,this._collectResourceTiming=!0===r.collectResourceTiming,this._locale=Object.assign(Object.assign({},ss),r.locale),this._clickTolerance=r.clickTolerance,this._overridePixelRatio=r.pixelRatio,this._maxCanvasSize=r.maxCanvasSize,this._zoomLevelsToOverscale=r.experimentalZoomLevelsToOverscale,this.transformCameraUpdate=r.transformCameraUpdate,this.transformConstrain=r.transformConstrain,this.cancelPendingTileRequestsWhileZooming=!0===r.cancelPendingTileRequestsWhileZooming,void 0!==r.reduceMotion&&(n.prefersReducedMotion=r.reduceMotion),this._imageQueueHandle=g.addThrottleControl((()=>this.isMoving())),this._requestManager=new v(r.transformRequest),"string"==typeof r.container){if(this._container=document.getElementById(r.container),!this._container)throw new Error(`Container '${r.container}' not found.`)}else {if(!(r.container instanceof HTMLElement))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=r.container;}if(r.maxBounds&&this.setMaxBounds(r.maxBounds),this._setupContainer(),this._setupPainter(),this.on("move",(()=>this._update(!1))),this.on("moveend",(()=>this._update(!1))),this.on("zoom",(()=>this._update(!0))),this.on("terrain",(()=>{this.painter.terrainFacilitator.dirty=!0,this._update(!0);})),this.once("idle",(()=>{this._idleTriggered=!0;})),"undefined"!=typeof window){addEventListener("online",this._onWindowOnline,!1);let e=!1;const t=Wr((e=>{this._trackResize&&!this._removed&&(this.resize(e),this.redraw());}),50);this._resizeObserver=new ResizeObserver((i=>{e?t(i):e=!0;})),this._resizeObserver.observe(this._container);}this.handlers=new Ho(this,r),this._hash=r.hash&&new $r("string"==typeof r.hash&&r.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:r.center,elevation:r.elevation,zoom:r.zoom,bearing:r.bearing,pitch:r.pitch,roll:r.roll}),r.bounds&&(this.resize(),this.fitBounds(r.bounds,t.e({},r.fitBoundsOptions,{duration:0}))));const l="string"==typeof r.style||!("globe"===(null===(a=null===(i=r.style)||void 0===i?void 0:i.projection)||void 0===a?void 0:a.type));this.resize(null,l),this._localIdeographFontFamily=r.localIdeographFontFamily,this._validateStyle=r.validateStyle,r.style&&this.setStyle(r.style,{localIdeographFontFamily:r.localIdeographFontFamily}),r.attributionControl&&this.addControl(new Yo("boolean"==typeof r.attributionControl?void 0:r.attributionControl)),r.maplibreLogo&&this.addControl(new Qo,r.logoPosition),this.on("style.load",(()=>{if(l||this._resizeTransform(),this.transform.unmodified){const e=t.U(this.style.stylesheet,["center","zoom","bearing","pitch","roll"]);this.jumpTo(e);}})),this.on("data",(e=>{this._update("style"===e.dataType),this.fire(new t.l(`${e.dataType}data`,e));})),this.on("dataloading",(e=>{this.fire(new t.l(`${e.dataType}dataloading`,e));})),this.on("dataabort",(e=>{this.fire(new t.l("sourcedataabort",e));}));}_getMapId(){return this._mapId}setGlobalStateProperty(e,t){return this.style.setGlobalStateProperty(e,t),this._update(!0)}getGlobalState(){return this.style.getGlobalState()}addControl(e,i){if(void 0===i&&(i=e.getDefaultPosition?e.getDefaultPosition():"top-right"),!e||!e.onAdd)return this.fire(new t.k(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const a=e.onAdd(this);this._controls.push(e);const r=this._controlPositions[i];return -1!==i.indexOf("bottom")?r.insertBefore(a,r.firstChild):r.appendChild(a),this}removeControl(e){if(!e||!e.onRemove)return this.fire(new t.k(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const i=this._controls.indexOf(e);return i>-1&&this._controls.splice(i,1),e.onRemove(this),this}hasControl(e){return this._controls.indexOf(e)>-1}coveringTiles(e){return Ie(this.transform,e)}calculateCameraOptionsFromTo(e,t,i,a){return null==a&&this.terrain&&(a=this.terrain.getElevationForLngLat(i,this.transform)),super.calculateCameraOptionsFromTo(e,t,i,a)}resize(e,i=!0){if(null!==this._lostContextStyle.style)return this;this._resizeInternal(i);const a=!this._moving;return a&&(this.stop(),this.fire(new t.l("movestart",e)).fire(new t.l("move",e))),this.fire(new t.l("resize",e)),a&&this.fire(new t.l("moveend",e)),this}_resizeInternal(e=!0){const[t,i]=this._containerDimensions(),a=this._getClampedPixelRatio(t,i);if(this._resizeCanvas(t,i,a),this.painter.resize(t,i,a),this.painter.overLimit()){const e=this.painter.context.gl;this._maxCanvasSize=[e.drawingBufferWidth,e.drawingBufferHeight];const a=this._getClampedPixelRatio(t,i);this._resizeCanvas(t,i,a),this.painter.resize(t,i,a);}this._resizeTransform(e);}_resizeTransform(e=!0){var t;const[i,a]=this._containerDimensions();this.transform.resize(i,a,e),null===(t=this._requestedCameraState)||void 0===t||t.resize(i,a,e);}_getClampedPixelRatio(e,t){const{0:i,1:a}=this._maxCanvasSize,r=this.getPixelRatio(),o=e*r,s=t*r;return Math.min(o>i?i/o:1,s>a?a/s:1)*r}getPixelRatio(){var e;return null!==(e=this._overridePixelRatio)&&void 0!==e?e:devicePixelRatio}setPixelRatio(e){this._overridePixelRatio=e,this.resize();}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()}setMaxBounds(e){return this.transform.setMaxBounds($.convert(e)),this._update()}setMinZoom(e){if((e=null==e?-2:e)>=-2&&e<=this.transform.maxZoom){const t=this._getTransformForUpdate();return t.setMinZoom(e),this._applyUpdatedTransform(t),this._update(),this}throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(e){if((e=null==e?22:e)>=this.transform.minZoom){const t=this._getTransformForUpdate();return t.setMaxZoom(e),this._applyUpdatedTransform(t),this._update(),this}throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(e){if((e=null==e?0:e)<0)throw new Error("minPitch must be greater than or equal to 0");if(e>=0&&e<=this.transform.maxPitch)return this.transform.setMinPitch(e),this._update(),this.getPitch()<e&&this.setPitch(e),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(e){if((e=null==e?60:e)>180)throw new Error("maxPitch must be less than or equal to 180");if(e>=this.transform.minPitch)return this.transform.setMaxPitch(e),this._update(),this.getPitch()>e&&this.setPitch(e),this;throw new Error("maxPitch must be greater than the current minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(e){return this.transform.setRenderWorldCopies(e),this._update()}setTransformConstrain(e){return this.transform.setConstrainOverride(e),this._update()}project(e){return this.transform.locationToScreenPoint(t.V.convert(e),this.style&&this.terrain)}unproject(e){return this.transform.screenPointToLocation(t.P.convert(e),this.terrain)}isMoving(){var e;return this._moving||(null===(e=this.handlers)||void 0===e?void 0:e.isMoving())}isZooming(){var e;return this._zooming||(null===(e=this.handlers)||void 0===e?void 0:e.isZooming())}isRotating(){var e;return this._rotating||(null===(e=this.handlers)||void 0===e?void 0:e.isRotating())}_createDelegatedListener(e,t,i){if("mouseenter"===e||"mouseover"===e){let a=!1;const r=r=>{const o=t.filter((e=>this.getLayer(e))),s=0!==o.length?this.queryRenderedFeatures(r.point,{layers:o}):[];s.length?a||(a=!0,i.call(this,new ao(e,this,r.originalEvent,{features:s}))):a=!1;};return {layers:t,listener:i,delegates:{mousemove:r,mouseout:()=>{a=!1;}}}}if("mouseleave"===e||"mouseout"===e){let a=!1;const r=r=>{const o=t.filter((e=>this.getLayer(e)));(0!==o.length?this.queryRenderedFeatures(r.point,{layers:o}):[]).length?a=!0:a&&(a=!1,i.call(this,new ao(e,this,r.originalEvent)));},o=t=>{a&&(a=!1,i.call(this,new ao(e,this,t.originalEvent)));};return {layers:t,listener:i,delegates:{mousemove:r,mouseout:o}}}{const a=e=>{const a=t.filter((e=>this.getLayer(e))),r=0!==a.length?this.queryRenderedFeatures(e.point,{layers:a}):[];r.length&&(e.features=r,i.call(this,e),delete e.features);};return {layers:t,listener:i,delegates:{[e]:a}}}}_saveDelegatedListener(e,t){this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[e]=this._delegatedListeners[e]||[],this._delegatedListeners[e].push(t);}_removeDelegatedListener(e,t,i){if(!this._delegatedListeners||!this._delegatedListeners[e])return;const a=this._delegatedListeners[e];for(let e=0;e<a.length;e++){const r=a[e];if(r.listener===i&&r.layers.length===t.length&&r.layers.every((e=>t.includes(e)))){for(const e in r.delegates)this.off(e,r.delegates[e]);return void a.splice(e,1)}}}on(e,t,i){if(void 0===i)return super.on(e,t);const a="string"==typeof t?[t]:t,r=this._createDelegatedListener(e,a,i);this._saveDelegatedListener(e,r);for(const e in r.delegates)this.on(e,r.delegates[e]);return {unsubscribe:()=>{this._removeDelegatedListener(e,a,i);}}}once(e,t,i){if(void 0===i)return super.once(e,t);const a="string"==typeof t?[t]:t,r=this._createDelegatedListener(e,a,i);for(const t in r.delegates){const o=r.delegates[t];r.delegates[t]=(...t)=>{this._removeDelegatedListener(e,a,i),o(...t);};}this._saveDelegatedListener(e,r);for(const e in r.delegates)this.once(e,r.delegates[e]);return this}off(e,t,i){return void 0===i?super.off(e,t):(this._removeDelegatedListener(e,"string"==typeof t?[t]:t,i),this)}queryRenderedFeatures(e,i){if(!this.style)return [];let a;const r=e instanceof t.P||Array.isArray(e),o=r?e:[[0,0],[this.transform.width,this.transform.height]];if(i=i||(r?{}:e)||{},o instanceof t.P||"number"==typeof o[0])a=[t.P.convert(o)];else {const e=t.P.convert(o[0]),i=t.P.convert(o[1]);a=[e,new t.P(i.x,e.y),i,new t.P(e.x,i.y),e];}return this.style.queryRenderedFeatures(a,i,this.transform)}querySourceFeatures(e,t){return this.style.querySourceFeatures(e,t)}setStyle(e,i){return !1!==(i=t.e({},{localIdeographFontFamily:this._localIdeographFontFamily,validate:this._validateStyle},i)).diff&&i.localIdeographFontFamily===this._localIdeographFontFamily&&this.style&&e?(this._diffStyle(e,i),this):(this._localIdeographFontFamily=i.localIdeographFontFamily,this._updateStyle(e,i))}setTransformRequest(e){return this._requestManager.setTransformRequest(e),this}_getUIString(e){const t=this._locale[e];if(null==t)throw new Error(`Missing UI string '${e}'`);return t}_updateStyle(e,t){var i,a;if(t.transformStyle&&this.style&&!this.style._loaded)return void this.style.once("style.load",(()=>this._updateStyle(e,t)));const r=this.style&&t.transformStyle?this.style.serialize():void 0;return this.style&&(this.style.setEventedParent(null),this.style._remove(!e)),e?(this.style=new ki(this,t||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof e?this.style.loadURL(e,t,r):this.style.loadJSON(e,t,r),this):(null===(a=null===(i=this.style)||void 0===i?void 0:i.projection)||void 0===a||a.destroy(),delete this.style,this)}_lazyInitEmptyStyle(){this.style||(this.style=new ki(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty());}_diffStyle(e,i){if("string"==typeof e){const a=this._requestManager.transformRequest(e,"Style");t.j(a,new AbortController).then((e=>{this._updateDiff(e.data,i);})).catch((e=>{e&&this.fire(new t.k(e));}));}else "object"==typeof e&&this._updateDiff(e,i);}_updateDiff(e,i){try{this.style.setState(e,i)&&this._update(!0);}catch(a){t.w(`Unable to perform style diff: ${a.message||a.error||a}.  Rebuilding the style from scratch.`),this._updateStyle(e,i);}}getStyle(){if(this.style)return this.style.serialize()}_getStyleAndImages(){return this.style?{style:this.style.serialize(),images:this.style.imageManager.cloneImages()}:{style:null,images:{}}}isStyleLoaded(){return this.style?this.style.loaded():t.w("There is no style added to the map.")}addSource(e,t){return this._lazyInitEmptyStyle(),this.style.addSource(e,t),this._update(!0)}isSourceLoaded(e){const i=this.style&&this.style.tileManagers[e];if(void 0!==i)return i.loaded();this.fire(new t.k(new Error(`There is no tile manager with ID '${e}'`)));}setTerrain(e){if(this.style._checkLoaded(),this._terrainDataCallback&&this.style.off("data",this._terrainDataCallback),e){const i=this.style.tileManagers[e.source];if(!i)throw new Error(`cannot load terrain, because there exists no source with ID: ${e.source}`);null===this.terrain&&i.reload();for(const i in this.style._layers){const a=this.style._layers[i];"hillshade"===a.type&&a.source===e.source&&t.w("You are using the same source for a hillshade layer and for 3D terrain. Please consider using two separate sources to improve rendering quality."),"color-relief"===a.type&&a.source===e.source&&t.w("You are using the same source for a color-relief layer and for 3D terrain. Please consider using two separate sources to improve rendering quality.");}this.terrain=new is(this.painter,i,e),this.painter.renderToTexture=new os(this.painter,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._terrainDataCallback=t=>{var i;"style"===t.dataType?this.terrain.tileManager.freeRtt():"source"===t.dataType&&t.tile&&(t.sourceId!==e.source||this._elevationFreeze||(this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))),"image"===(null===(i=t.source)||void 0===i?void 0:i.type)?this.terrain.tileManager.freeRtt():this.terrain.tileManager.freeRtt(t.tile.tileID));},this.style.on("data",this._terrainDataCallback);}else this.terrain&&this.terrain.tileManager.destruct(),this.terrain=null,this.painter.renderToTexture&&this.painter.renderToTexture.destruct(),this.painter.renderToTexture=null,this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0);return this.fire(new t.l("terrain",{terrain:e})),this}getTerrain(){var e,t;return null!==(t=null===(e=this.terrain)||void 0===e?void 0:e.options)&&void 0!==t?t:null}areTilesLoaded(){const e=this.style&&this.style.tileManagers;for(const t of Object.values(e))if(!t.areTilesLoaded())return !1;return !0}removeSource(e){return this.style.removeSource(e),this._update(!0)}getSource(e){return this.style.getSource(e)}setSourceTileLodParams(e,t,i){if(i){const a=this.getSource(i);if(!a)throw new Error(`There is no source with ID "${i}", cannot set LOD parameters`);a.calculateTileZoom=Te(Math.max(1,e),Math.max(1,t));}else for(const i in this.style.tileManagers)this.style.tileManagers[i].getSource().calculateTileZoom=Te(Math.max(1,e),Math.max(1,t));return this._update(!0),this}refreshTiles(e,i){const a=this.style.tileManagers[e];if(!a)throw new Error(`There is no tile manager with ID "${e}", cannot refresh tile`);void 0===i?a.reload(!0):a.refreshTiles(i.map((e=>new t.ac(e.z,e.x,e.y))));}addImage(e,i,a={}){const{pixelRatio:r=1,sdf:o=!1,stretchX:s,stretchY:l,content:c,textFitWidth:h,textFitHeight:u}=a;if(this._lazyInitEmptyStyle(),!(i instanceof HTMLImageElement||t.b(i))){if(void 0===i.width||void 0===i.height)return this.fire(new t.k(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));{const{width:a,height:n,data:d}=i,_=i;return this.style.addImage(e,{data:new t.R({width:a,height:n},new Uint8Array(d)),pixelRatio:r,stretchX:s,stretchY:l,content:c,textFitWidth:h,textFitHeight:u,sdf:o,version:0,userImage:_}),_.onAdd&&_.onAdd(this,e),this}}{const{width:a,height:d,data:_}=n.getImageData(i);this.style.addImage(e,{data:new t.R({width:a,height:d},_),pixelRatio:r,stretchX:s,stretchY:l,content:c,textFitWidth:h,textFitHeight:u,sdf:o,version:0});}}updateImage(e,i){const a=this.style.getImage(e);if(!a)return this.fire(new t.k(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const r=i instanceof HTMLImageElement||t.b(i)?n.getImageData(i):i,{width:o,height:s,data:l}=r;if(void 0===o||void 0===s)return this.fire(new t.k(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));if(o!==a.data.width||s!==a.data.height)return this.fire(new t.k(new Error("The width and height of the updated image must be that same as the previous version of the image")));const c=!(i instanceof HTMLImageElement||t.b(i));return a.data.replace(l,c),this.style.updateImage(e,a),this}getImage(e){return this.style.getImage(e)}hasImage(e){return e?!!this.style.getImage(e):(this.fire(new t.k(new Error("Missing required image id"))),!1)}removeImage(e){this.style.removeImage(e);}loadImage(e){return g.getImage(this._requestManager.transformRequest(e,"Image"),new AbortController)}listImages(){return this.style.listImages()}addLayer(e,t){return this._lazyInitEmptyStyle(),this.style.addLayer(e,t),this._update(!0)}moveLayer(e,t){return this.style.moveLayer(e,t),this._update(!0)}removeLayer(e){return this.style.removeLayer(e),this._update(!0)}getLayer(e){return this.style.getLayer(e)}getLayersOrder(){return this.style.getLayersOrder()}setLayerZoomRange(e,t,i){return this.style.setLayerZoomRange(e,t,i),this._update(!0)}setFilter(e,t,i={}){return this.style.setFilter(e,t,i),this._update(!0)}getFilter(e){return this.style.getFilter(e)}setPaintProperty(e,t,i,a={}){return this.style.setPaintProperty(e,t,i,a),this._update(!0)}getPaintProperty(e,t){return this.style.getPaintProperty(e,t)}setLayoutProperty(e,t,i,a={}){return this.style.setLayoutProperty(e,t,i,a),this._update(!0)}getLayoutProperty(e,t){return this.style.getLayoutProperty(e,t)}setGlyphs(e,t={}){return this._lazyInitEmptyStyle(),this.style.setGlyphs(e,t),this._update(!0)}getGlyphs(){return this.style.getGlyphsUrl()}addSprite(e,t,i={}){return this._lazyInitEmptyStyle(),this.style.addSprite(e,t,i,(e=>{e||this._update(!0);})),this}removeSprite(e){return this._lazyInitEmptyStyle(),this.style.removeSprite(e),this._update(!0)}getSprite(){return this.style.getSprite()}setSprite(e,t={}){return this._lazyInitEmptyStyle(),this.style.setSprite(e,t,(e=>{e||this._update(!0);})),this}setLight(e,t={}){return this._lazyInitEmptyStyle(),this.style.setLight(e,t),this._update(!0)}getLight(){return this.style.getLight()}setSky(e,t={}){return this._lazyInitEmptyStyle(),this.style.setSky(e,t),this._update(!0)}getSky(){return this.style.getSky()}setFeatureState(e,t){return this.style.setFeatureState(e,t),this._update()}removeFeatureState(e,t){return this.style.removeFeatureState(e,t),this._update()}getFeatureState(e){return this.style.getFeatureState(e)}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}_containerDimensions(){let e=0,t=0;return this._container&&(e=this._container.clientWidth||400,t=this._container.clientHeight||300),[e,t]}_setupContainer(){const e=this._container;e.classList.add("maplibregl-map");const t=this._canvasContainer=h.create("div","maplibregl-canvas-container",e);this._interactive&&t.classList.add("maplibregl-interactive"),this._canvas=h.create("canvas","maplibregl-canvas",t),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex",this._interactive?"0":"-1"),this._canvas.setAttribute("aria-label",this._getUIString("Map.Title")),this._canvas.setAttribute("role","region");const i=this._containerDimensions(),a=this._getClampedPixelRatio(i[0],i[1]);this._resizeCanvas(i[0],i[1],a);const r=this._controlContainer=h.create("div","maplibregl-control-container",e),o=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach((e=>{o[e]=h.create("div",`maplibregl-ctrl-${e} `,r);})),this._container.addEventListener("scroll",this._onMapScroll,!1);}_resizeCanvas(e,t,i){this._canvas.width=Math.floor(i*e),this._canvas.height=Math.floor(i*t),this._canvas.style.width=`${e}px`,this._canvas.style.height=`${t}px`;}_setupPainter(){const e=Object.assign(Object.assign({},this._canvasContextAttributes),{alpha:!0,depth:!0,stencil:!0,premultipliedAlpha:!0});let t=null;this._canvas.addEventListener("webglcontextcreationerror",(i=>{t={requestedAttributes:e},i&&(t.statusMessage=i.statusMessage,t.type=i.type);}),{once:!0});let i=null;if(i=this._canvasContextAttributes.contextType?this._canvas.getContext(this._canvasContextAttributes.contextType,e):this._canvas.getContext("webgl2",e)||this._canvas.getContext("webgl",e),!i){const e="Failed to initialize WebGL";throw t?(t.message=e,new Error(JSON.stringify(t))):new Error(e)}this.painter=new qr(i,this.transform),u.testSupport(i);}migrateProjection(e,i){super.migrateProjection(e,i),this.painter.transform=e,this.fire(new t.l("projectiontransition",{newProjection:this.style.projection.name}));}loaded(){return !this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(e){return this.style&&this.style._loaded?(this._styleDirty=this._styleDirty||e,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(e){return this._update(),this._renderTaskQueue.add(e)}_cancelRenderFrame(e){this._renderTaskQueue.remove(e);}_render(e){var i,a,r,o,s;const n=this._idleTriggered?this._fadeDuration:0,l=(null===(i=this.style.projection)||void 0===i?void 0:i.transitionState)>0;if(this.painter.context.setDirty(),this.painter.setBaseState(),this._renderTaskQueue.run(e),this._removed)return;let h=!1;if(this.style&&this._styleDirty){this._styleDirty=!1;const e=this.transform.zoom,i=c();this.style.zoomHistory.update(e,i);const a=new t.H(e,{now:i,fadeDuration:n,zoomHistory:this.style.zoomHistory,transition:this.style.getTransition()}),r=a.crossFadingFactor();1===r&&r===this._crossFadingFactor||(h=!0,this._crossFadingFactor=r),this.style.update(a);}const u=(null===(a=this.style.projection)||void 0===a?void 0:a.transitionState)>0!==l;null===(r=this.style.projection)||void 0===r||r.setErrorQueryLatitudeDegrees(this.transform.center.lat),this.transform.setTransitionState(null===(o=this.style.projection)||void 0===o?void 0:o.transitionState,null===(s=this.style.projection)||void 0===s?void 0:s.latitudeErrorCorrectionRadians),this.style&&(this._sourcesDirty||u)&&(this._sourcesDirty=!1,this.style._updateSources(this.transform)),this.terrain?(this.terrain.tileManager.update(this.transform,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),!this._elevationFreeze&&this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))):(this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0)),this._placementDirty=this.style&&this.style._updatePlacement(this.transform,this.showCollisionBoxes,n,this._crossSourceCollisions,u),this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showOverdrawInspector:this._showOverdrawInspector,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeDuration:n,showPadding:this.showPadding}),this.fire(new t.l("render")),this.loaded()&&!this._loaded&&(this._loaded=!0,t.cG.mark(t.cH.load),this.fire(new t.l("load"))),this.style&&(this.style.hasTransitions()||h)&&(this._styleDirty=!0),this.style&&!this._placementDirty&&this.style._releaseSymbolFadeTiles();const d=this._source