from collections.abc import Iterator, Sequence
import enum
from typing import overload


class Block:
    def __init__(self, arg: str, /) -> None: ...

    @property
    def name(self) -> str: ...

    @name.setter
    def name(self, arg: str, /) -> None: ...

    def __iter__(self) -> Iterator[Item]: ...

    def __getitem__(self, index: int) -> Item: ...

    def find_pair(self, tag: str) -> object: ...

    def find_pair_item(self, tag: str) -> Item: ...

    def find_value(self, tag: str) -> str: ...

    def find_loop(self, tag: str) -> Column: ...

    def find_loop_item(self, tag: str) -> Item: ...

    def find_values(self, tag: str) -> Column: ...

    @overload
    def find(self, prefix: str, tags: Sequence[str]) -> Table: ...

    @overload
    def find(self, tags: Sequence[str]) -> Table: ...

    def find_or_add(self, prefix: str, tags: Sequence[str]) -> Table: ...

    def add_item(self, item: Item, pos: int = -1) -> Item: ...

    def find_frame(self, name: str) -> Block: ...

    def item_as_table(self, arg: Item, /) -> Table: ...

    def get_index(self, tag: str) -> int: ...

    def set_pair(self, tag: str, value: str) -> None: ...

    def set_pairs(self, prefix: str, data: dict, raw: bool = False) -> None: ...

    def init_loop(self, prefix: str, tags: Sequence[str]) -> Loop: ...

    def move_item(self, old_pos: int, new_pos: int) -> None: ...

    def find_mmcif_category(self, category: str) -> Table:
        """Returns Table with all items in the category."""

    def get_mmcif_category_names(self) -> list[str]:
        """For mmCIF files only. Returns list of all category prefixes (_x.)"""

    def init_mmcif_loop(self, cat: str, tags: Sequence[str]) -> Loop: ...

    def set_mmcif_category(self, name: str, data: dict, raw: bool = False) -> None: ...

    def get_mmcif_category(self, name: str, raw: bool = False) -> dict: ...

    def write_file(self, filename: str, options: WriteOptions = ...) -> None:
        """Write data to a CIF file."""

    def as_string(self, options: WriteOptions = ...) -> str:
        """Returns a string in CIF format."""

    def check_empty_loops(self, arg: str, /) -> None: ...

    def __getstate__(self) -> bytes: ...

    def __setstate__(self, arg: bytes, /) -> None: ...

    def __repr__(self) -> str: ...

class Item:
    def erase(self) -> None: ...

    @property
    def line_number(self) -> int: ...

    @property
    def pair(self) -> object: ...

    @property
    def loop(self) -> Loop: ...

    @property
    def frame(self) -> Block: ...

class Loop:
    def __init__(self) -> None: ...

    def width(self) -> int:
        """Returns number of columns"""

    def length(self) -> int:
        """Returns number of rows"""

    @property
    def tags(self) -> list[str]: ...

    @property
    def values(self) -> list[str]: ...

    def __getitem__(self, arg: tuple[int, int], /) -> str: ...

    def __setitem__(self, arg0: tuple[int, int], arg1: str, /) -> None: ...

    def add_row(self, new_values: Sequence[str], pos: int = -1) -> None: ...

    def add_columns(self, column_names: Sequence[str], value: str, pos: int = -1) -> None: ...

    def remove_column(self, arg: str, /) -> None: ...

    def set_all_values(self, columns: Sequence[Sequence[str]]) -> None: ...

    def __repr__(self) -> str: ...

class Column:
    def __init__(self) -> None: ...

    def get_loop(self) -> Loop: ...

    @property
    def tag(self) -> str: ...

    @tag.setter
    def tag(self, arg: str, /) -> None: ...

    def __iter__(self) -> Iterator[str]: ...

    def __bool__(self) -> bool: ...

    def __len__(self) -> int: ...

    def __getitem__(self, arg: int, /) -> str: ...

    def __setitem__(self, arg0: int, arg1: str, /) -> None: ...

    def erase(self) -> None: ...

    def __repr__(self) -> str: ...

    def str(self, index: int) -> str: ...

class Table:
    class Row:
        @property
        def row_index(self) -> int: ...

        def __len__(self) -> int: ...

        @overload
        def __getitem__(self, arg: int, /) -> str: ...

        @overload
        def __getitem__(self, arg: str, /) -> str: ...

        @overload
        def __setitem__(self, arg0: int, arg1: str, /) -> None: ...

        @overload
        def __setitem__(self, arg0: str, arg1: str, /) -> None: ...

        def get(self, index: int) -> str: ...

        def has(self, index: int) -> bool: ...

        def __iter__(self) -> Iterator[str]: ...

        def __repr__(self) -> str: ...

        def str(self, arg: int, /) -> str: ...

    def width(self) -> int: ...

    @property
    def prefix_length(self) -> int: ...

    @property
    def loop(self) -> Loop: ...

    def get_prefix(self) -> str: ...

    def has_column(self, arg: int, /) -> bool: ...

    def column(self, n: int) -> Column: ...

    def find_row(self, arg: str, /) -> Table.Row: ...

    def find_column(self, tag: str) -> Column: ...

    def erase(self) -> None: ...

    def ensure_loop(self) -> None: ...

    def append_row(self, new_values: Sequence[str]) -> None: ...

    def remove_row(self, row_index: int) -> None: ...

    def move_row(self, old_pos: int, new_pos: int) -> None: ...

    @property
    def tags(self) -> Table.Row: ...

    def __iter__(self) -> Iterator[Table.Row]: ...

    def __getitem__(self, arg: int, /) -> Table.Row: ...

    @overload
    def __delitem__(self, arg: int, /) -> None: ...

    @overload
    def __delitem__(self, arg: slice, /) -> None: ...

    def __bool__(self) -> bool: ...

    def __len__(self) -> int: ...

    def __repr__(self) -> str: ...

class Style(enum.Enum):
    Simple = 0

    NoBlankLines = 1

    PreferPairs = 2

    Pdbx = 3

    Indent35 = 4

    Aligned = 5

class WriteOptions:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, arg: Style, /) -> None: ...

    @property
    def prefer_pairs(self) -> bool: ...

    @prefer_pairs.setter
    def prefer_pairs(self, arg: bool, /) -> None: ...

    @property
    def compact(self) -> bool: ...

    @compact.setter
    def compact(self, arg: bool, /) -> None: ...

    @property
    def misuse_hash(self) -> bool: ...

    @misuse_hash.setter
    def misuse_hash(self, arg: bool, /) -> None: ...

    @property
    def align_pairs(self) -> int: ...

    @align_pairs.setter
    def align_pairs(self, arg: int, /) -> None: ...

    @property
    def align_loops(self) -> int: ...

    @align_loops.setter
    def align_loops(self, arg: int, /) -> None: ...

    def __repr__(self) -> str: ...

class Document:
    def __init__(self) -> None: ...

    @property
    def source(self) -> str: ...

    @source.setter
    def source(self, arg: str, /) -> None: ...

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[Block]: ...

    @overload
    def __getitem__(self, name: str) -> Block: ...

    @overload
    def __getitem__(self, index: int) -> Block: ...

    @overload
    def __getitem__(self, arg: slice, /) -> list: ...

    def __contains__(self, name: str) -> bool: ...

    def __delitem__(self, index: int) -> None: ...

    def add_copied_block(self, block: Block, pos: int = -1) -> Block: ...

    def add_new_block(self, name: str, pos: int = -1) -> Block: ...

    def clear(self) -> None: ...

    def parse_string(self, arg: str, /) -> None: ...

    def parse_file(self, arg: str, /) -> None: ...

    def check_for_missing_values(self) -> None: ...

    def check_for_duplicates(self) -> None: ...

    def sole_block(self) -> Block:
        """Returns the only block if there is exactly one"""

    def find_block(self, name: str) -> Block: ...

    def write_file(self, filename: str, options: WriteOptions = ...) -> None:
        """Write data to a CIF file."""

    def as_string(self, options: WriteOptions = ...) -> str:
        """Returns a string in CIF format."""

    def as_json(self, mmjson: bool = False, lowercase_names: bool = True) -> str:
        """Returns JSON representation in a string."""

    def __getstate__(self) -> bytes: ...

    def __setstate__(self, arg: bytes, /) -> None: ...

    def __repr__(self) -> str: ...

def quote(string: str) -> str: ...

def quote_list(arg: list, /) -> list[str]: ...

class Ddl:
    def __init__(self, logger: object, print_unknown_tags: bool = True, use_regex: bool = True, use_context: bool = True, use_linked_groups: bool = True, use_mandatory: bool = True, use_unique_keys: bool = True) -> None: ...

    @property
    def use_deposition_checks(self) -> bool: ...

    @use_deposition_checks.setter
    def use_deposition_checks(self, arg: bool, /) -> None: ...

    def set_logger(self, arg: object, /) -> None: ...

    def read_ddl(self, doc: Document) -> None: ...

    def validate_cif(self, arg: Document, /) -> bool: ...

def read_file(filename: str, check_level: int = 1) -> Document:
    """Reads a CIF file copying data into Document."""

def read(filename: str) -> Document:
    """Reads normal or gzipped CIF file."""

@overload
def read_string(string: str, check_level: int = 1) -> Document:
    """Reads a string as a CIF file."""

@overload
def read_string(data: bytes, check_level: int = 1) -> Document:
    """Reads bytes as a CIF file."""

def read_mmjson(filename: str) -> Document:
    """Reads normal or gzipped mmJSON file."""

@overload
def read_mmjson_string(arg: str, /) -> Document: ...

@overload
def read_mmjson_string(arg: bytes, /) -> Document: ...

def as_string(value: str) -> str:
    """Get string content (no quotes) from raw string."""

def as_number(value: str, default: float = float('nan')) -> float:
    """Returns float number from string"""

@overload
def as_int(value: str) -> int:
    """Returns int number from string value."""

@overload
def as_int(value: str, default: int) -> int:
    """Returns int number from string value or the second arg if null."""

def is_null(value: str) -> bool: ...
