#! /bin/bash
# Convert the man pages to HTML using pandoc.

set -e

cd $(dirname $0)

FILES=" sq.1 sq-encrypt.1 sq-decrypt.1 sq-sign.1 sq-verify.1 sq-download.1 sq-inspect.1 sq-cert.1 sq-cert-import.1 sq-cert-export.1 sq-cert-list.1 sq-cert-lint.1 sq-key.1 sq-key-list.1 sq-key-generate.1 sq-key-rotate.1 sq-key-import.1 sq-key-export.1 sq-key-delete.1 sq-key-password.1 sq-key-expire.1 sq-key-revoke.1 sq-key-userid.1 sq-key-userid-add.1 sq-key-userid-revoke.1 sq-key-subkey.1 sq-key-subkey-add.1 sq-key-subkey-export.1 sq-key-subkey-delete.1 sq-key-subkey-password.1 sq-key-subkey-expire.1 sq-key-subkey-revoke.1 sq-key-subkey-bind.1 sq-key-approvals.1 sq-key-approvals-list.1 sq-key-approvals-update.1 sq-pki.1 sq-pki-authenticate.1 sq-pki-lookup.1 sq-pki-identify.1 sq-pki-vouch.1 sq-pki-vouch-add.1 sq-pki-vouch-authorize.1 sq-pki-vouch-list.1 sq-pki-vouch-replay.1 sq-pki-link.1 sq-pki-link-add.1 sq-pki-link-authorize.1 sq-pki-link-retract.1 sq-pki-link-list.1 sq-pki-path.1 sq-network.1 sq-network-search.1 sq-network-keyserver.1 sq-network-keyserver-search.1 sq-network-keyserver-publish.1 sq-network-wkd.1 sq-network-wkd-search.1 sq-network-wkd-publish.1 sq-network-dane.1 sq-network-dane-search.1 sq-network-dane-generate.1 sq-keyring.1 sq-keyring-list.1 sq-keyring-split.1 sq-keyring-merge.1 sq-keyring-filter.1 sq-packet.1 sq-packet-armor.1 sq-packet-dearmor.1 sq-packet-dump.1 sq-packet-decrypt.1 sq-packet-split.1 sq-packet-join.1 sq-config.1 sq-config-get.1 sq-config-inspect.1 sq-config-inspect-paths.1 sq-config-inspect-network.1 sq-config-inspect-policy.1 sq-config-template.1 sq-version.1"

case "$1" in
  --generate)
    for man_page in $FILES
    do
      BINARY=sq pandoc -s $man_page -L man-pandoc.lua -H man-pandoc.inc.html -o $man_page.html
    done
    ;;
  --man-files)
    for man_page in $FILES
    do
      echo $man_page
    done
    ;;
  --man-root)
    for man_page in $FILES
    do
      echo $man_page
      break
    done
    ;;
  --html-files)
    for man_page in $FILES
    do
      echo $man_page.html
    done
    ;;
  --html-root)
    for man_page in $FILES
    do
      echo $man_page.html
      break
    done
    ;;
  *)
    echo "Usage: $0 --generate|--man-files|--man-root|--html-files|--html-root"
    exit 1
    ;;
esac
