# find

> Пошук файлів або каталогів в дереві каталогів, рекурсивно.
> Більше інформації: <https://manned.org/find>.

- Знайти файли за розширенням:

`find {{кореневий_шлях}} -name '{{*.ext}}'`

- Знайти файли, що відповідають декільком шаблонам шляху/імен:

`find {{кореневий_шлях}} -path '{{**/path/**/*.ext}}' -or -name '{{*шаблон*}}'`

- Знайти каталоги, що відповідають заданому імені, у режимі без урахування регістру:

`find {{кореневий_шлях}} -type d -iname '{{*lib*}}'`

- Знайти файли, що відповідають заданому шаблону, за винятком певних шляхів:

`find {{кореневий_шлях}} -name '{{*.py}}' -not -path '{{*/site-packages/*}}'`

- Знайти файли, що відповідають заданому діапазону розмірів, обмеживши рекурсивну глибину до "1":

`find {{кореневий_шлях}} -maxdepth 1 -size {{+500k}} -size {{-10M}}`

- Виконати команду для кожного файлу (використовуйте `{}` в команді, щоб отримати доступ до імені файлу):

`find {{кореневий_шлях}} -name '{{*.ext}}' -exec {{wc -l}} {} \;`

- Знайти всі файли, змінені сьогодні, і передати результати одній команді як аргументи:

`find {{кореневий_шлях}} -daystart -mtime {{-1}} -exec {{tar -cvf archive.tar}} {} \+`

- Знайти порожні файли (0 байт) або каталоги та докладно видалити їх:

`find {{кореневий_шлях}} -type {{f|d}} -empty -delete -print`
