# bzegrep

> `egrep`을 사용하여 `bzip2` 압축 파일에서 확장 정규식 패턴을 찾음.
> 더 많은 정보: <https://manned.org/bzegrep>.

- 압축 파일에서 확장된 정규식 (`?`, `+`, `{}`, `()` 및 `|` 지원)을 검색 (대소문자 구분):

`bzegrep "{{검색_패턴}}" {{경로/대상/파일}}`

- 압축 파일에서 확장된 정규식 (`?`, `+`, `{}`, `()` 및 `|` 지원)을 검색 (대소문자 구분하지 않음)::

`bzegrep --ignore-case "{{검색_패턴}}" {{경로/대상/파일}}`

- 패턴과 일치하지 않는 라인 검색:

`bzegrep --invert-match "{{검색_패턴}}" {{경로/대상/파일}}`

- 각 일치 항목의 파일 이름과 줄 번호를 인쇄:

`bzegrep --with-filename --line-number "{{검색_패턴}}" {{경로/대상/파일}}`

- 패턴과 일치하는 줄을 검색하여 일치하는 텍스트만 인쇄:

`bzegrep --only-matching "{{검색_패턴}}" {{경로/대상/파일}}`

- bzip2으로 압축된 tar 아카이브에서 파일을 반복적으로 검색하여 패턴을 찾음:

`bzegrep --recursive "{{검색_패턴}}" {{경로/대상/파일}}`
