/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Native;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.Z3ReferenceQueue;
import java.lang.ref.ReferenceQueue;

public class FuncInterp<R extends Sort>
extends Z3Object {
    public int getNumEntries() {
        return Native.funcInterpGetNumEntries(this.getContext().nCtx(), this.getNativeObject());
    }

    public Entry<R>[] getEntries() {
        int n = this.getNumEntries();
        Entry[] entryArray = new Entry[n];
        for (int i = 0; i < n; ++i) {
            entryArray[i] = new Entry(this.getContext(), Native.funcInterpGetEntry(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return entryArray;
    }

    public Expr<R> getElse() {
        return Expr.create(this.getContext(), Native.funcInterpGetElse(this.getContext().nCtx(), this.getNativeObject()));
    }

    public int getArity() {
        return Native.funcInterpGetArity(this.getContext().nCtx(), this.getNativeObject());
    }

    public String toString() {
        Object object = "";
        object = (String)object + "[";
        for (Entry<R> entry : this.getEntries()) {
            int n = entry.getNumArgs();
            if (n > 1) {
                object = (String)object + "[";
            }
            Expr<?>[] exprArray = entry.getArgs();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    object = (String)object + ", ";
                }
                object = (String)object + String.valueOf(exprArray[i]);
            }
            if (n > 1) {
                object = (String)object + "]";
            }
            object = (String)object + " -> " + String.valueOf(entry.getValue()) + ", ";
        }
        object = (String)object + "else -> " + String.valueOf(this.getElse());
        object = (String)object + "]";
        return object;
    }

    FuncInterp(Context context, long l) {
        super(context, l);
    }

    @Override
    void incRef() {
        Native.funcInterpIncRef(this.getContext().nCtx(), this.getNativeObject());
    }

    @Override
    void addToReferenceQueue() {
        this.getContext().getReferenceQueue().storeReference(this, (funcInterp, referenceQueue) -> new FuncInterpRef((FuncInterp<?>)funcInterp, (ReferenceQueue<Z3Object>)referenceQueue));
    }

    private static class FuncInterpRef
    extends Z3ReferenceQueue.Reference<FuncInterp<?>> {
        private FuncInterpRef(FuncInterp<?> funcInterp, ReferenceQueue<Z3Object> referenceQueue) {
            super(funcInterp, referenceQueue);
        }

        @Override
        void decRef(Context context, long l) {
            Native.funcInterpDecRef(context.nCtx(), l);
        }
    }

    public static class Entry<R extends Sort>
    extends Z3Object {
        public Expr<R> getValue() {
            return Expr.create(this.getContext(), Native.funcEntryGetValue(this.getContext().nCtx(), this.getNativeObject()));
        }

        public int getNumArgs() {
            return Native.funcEntryGetNumArgs(this.getContext().nCtx(), this.getNativeObject());
        }

        public Expr<?>[] getArgs() {
            int n = this.getNumArgs();
            Expr[] exprArray = new Expr[n];
            for (int i = 0; i < n; ++i) {
                exprArray[i] = Expr.create(this.getContext(), Native.funcEntryGetArg(this.getContext().nCtx(), this.getNativeObject(), i));
            }
            return exprArray;
        }

        public String toString() {
            int n = this.getNumArgs();
            Object object = "[";
            Expr<?>[] exprArray = this.getArgs();
            for (int i = 0; i < n; ++i) {
                object = (String)object + String.valueOf(exprArray[i]) + ", ";
            }
            return (String)object + String.valueOf(this.getValue()) + "]";
        }

        Entry(Context context, long l) {
            super(context, l);
        }

        @Override
        void incRef() {
            Native.funcEntryIncRef(this.getContext().nCtx(), this.getNativeObject());
        }

        @Override
        void addToReferenceQueue() {
            this.getContext().getReferenceQueue().storeReference(this, (entry, referenceQueue) -> new FuncEntryRef((Entry<?>)entry, (ReferenceQueue<Z3Object>)referenceQueue));
        }

        private static class FuncEntryRef
        extends Z3ReferenceQueue.Reference<Entry<?>> {
            private FuncEntryRef(Entry<?> entry, ReferenceQueue<Z3Object> referenceQueue) {
                super(entry, referenceQueue);
            }

            @Override
            void decRef(Context context, long l) {
                Native.funcEntryDecRef(context.nCtx(), l);
            }
        }
    }
}

