module KRB;

export {

	const error_msg: table[count] of string = {
		[0] = "KDC_ERR_NONE",
		[1] = "KDC_ERR_NAME_EXP",
		[2] = "KDC_ERR_SERVICE_EXP",
		[3] = "KDC_ERR_BAD_PVNO",
		[4] = "KDC_ERR_C_OLD_MAST_KVNO",
		[5] = "KDC_ERR_S_OLD_MAST_KVNO",
		[6] = "KDC_ERR_C_PRINCIPAL_UNKNOWN",
		[7] = "KDC_ERR_S_PRINCIPAL_UNKNOWN",
		[8] = "KDC_ERR_PRINCIPAL_NOT_UNIQUE",
		[9] = "KDC_ERR_NULL_KEY",
		[10] = "KDC_ERR_CANNOT_POSTDATE",
		[11] = "KDC_ERR_NEVER_VALID",
		[12] = "KDC_ERR_POLICY",
		[13] = "KDC_ERR_BADOPTION",
		[14] = "KDC_ERR_ETYPE_NOSUPP",
		[15] = "KDC_ERR_SUMTYPE_NOSUPP",
		[16] = "KDC_ERR_PADATA_TYPE_NOSUPP",
		[17] = "KDC_ERR_TRTYPE_NOSUPP",
		[18] = "KDC_ERR_CLIENT_REVOKED",
		[19] = "KDC_ERR_SERVICE_REVOKED",
		[20] = "KDC_ERR_TGT_REVOKED",
		[21] = "KDC_ERR_CLIENT_NOTYET",
		[22] = "KDC_ERR_SERVICE_NOTYET",
		[23] = "KDC_ERR_KEY_EXPIRED",
		[24] = "KDC_ERR_PREAUTH_FAILED",
		[25] = "KDC_ERR_PREAUTH_REQUIRED",
		[26] = "KDC_ERR_SERVER_NOMATCH",
		[27] = "KDC_ERR_MUST_USE_USER2USER",
		[28] = "KDC_ERR_PATH_NOT_ACCEPTED",
		[29] = "KDC_ERR_SVC_UNAVAILABLE",
		[31] = "KRB_AP_ERR_BAD_INTEGRITY",
		[32] = "KRB_AP_ERR_TKT_EXPIRED",
		[33] = "KRB_AP_ERR_TKT_NYV",
		[34] = "KRB_AP_ERR_REPEAT",
		[35] = "KRB_AP_ERR_NOT_US",
		[36] = "KRB_AP_ERR_BADMATCH",
		[37] = "KRB_AP_ERR_SKEW",
		[38] = "KRB_AP_ERR_BADADDR",
		[39] = "KRB_AP_ERR_BADVERSION",
		[40] = "KRB_AP_ERR_MSG_TYPE",
		[41] = "KRB_AP_ERR_MODIFIED",
		[42] = "KRB_AP_ERR_BADORDER",
		[44] = "KRB_AP_ERR_BADKEYVER",
		[45] = "KRB_AP_ERR_NOKEY",
		[46] = "KRB_AP_ERR_MUT_FAIL",
		[47] = "KRB_AP_ERR_BADDIRECTION",
		[48] = "KRB_AP_ERR_METHOD",
		[49] = "KRB_AP_ERR_BADSEQ",
		[50] = "KRB_AP_ERR_INAPP_CKSUM",
		[51] = "KRB_AP_PATH_NOT_ACCEPTED",
		[52] = "KRB_ERR_RESPONSE_TOO_BIG",
		[60] = "KRB_ERR_GENERIC",
		[61] = "KRB_ERR_FIELD_TOOLONG",
		[62] = "KDC_ERROR_CLIENT_NOT_TRUSTED",
		[63] = "KDC_ERROR_KDC_NOT_TRUSTED",
		[64] = "KDC_ERROR_INVALID_SIG",
		[65] = "KDC_ERR_KEY_TOO_WEAK",
		[66] = "KDC_ERR_CERTIFICATE_MISMATCH",
		[67] = "KRB_AP_ERR_NO_TGT",
		[68] = "KDC_ERR_WRONG_REALM",
		[69] = "KRB_AP_ERR_USER_TO_USER_REQUIRED",
		[70] = "KDC_ERR_CANT_VERIFY_CERTIFICATE",
		[71] = "KDC_ERR_INVALID_CERTIFICATE",
		[72] = "KDC_ERR_REVOKED_CERTIFICATE",
		[73] = "KDC_ERR_REVOCATION_STATUS_UNKNOWN",
		[74] = "KDC_ERR_REVOCATION_STATUS_UNAVAILABLE",
		[75] = "KDC_ERR_CLIENT_NAME_MISMATCH",
		[76] = "KDC_ERR_KDC_NAME_MISMATCH",
	} &default=function(i: count): string { return fmt("unknown-%d", i); };

	const cipher_name: table[count] of string = {
		[1] = "des-cbc-crc",
		[2] = "des-cbc-md4",
		[3] = "des-cbc-md5",
		[5] = "des3-cbc-md5",
		[7] = "des3-cbc-sha1",
		[9] = "dsaWithSHA1-CmsOID",
		[10] = "md5WithRSAEncryption-CmsOID",
		[11] = "sha1WithRSAEncryption-CmsOID",
		[12] = "rc2CBC-EnvOID",
		[13] = "rsaEncryption-EnvOID",
		[14] = "rsaES-OAEP-ENV-OID",
		[15] = "des-ede3-cbc-Env-OID",
		[16] = "des3-cbc-sha1-kd",
		[17] = "aes128-cts-hmac-sha1-96",
		[18] = "aes256-cts-hmac-sha1-96",
		[23] = "rc4-hmac",
		[24] = "rc4-hmac-exp",
		[25] = "camellia128-cts-cmac",
		[26] = "camellia256-cts-cmac",
		[65] = "subkey-keymaterial",
	} &default=function(i: count): string { return fmt("unknown-%d", i); };

}
