// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the distribution tenants in your Amazon Web Services account.
func (c *Client) ListDistributionTenants(ctx context.Context, params *ListDistributionTenantsInput, optFns ...func(*Options)) (*ListDistributionTenantsOutput, error) {
	if params == nil {
		params = &ListDistributionTenantsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDistributionTenants", params, optFns, c.addOperationListDistributionTenantsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDistributionTenantsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDistributionTenantsInput struct {

	// Filter by the associated distribution ID or connection group ID.
	AssociationFilter *types.DistributionTenantAssociationFilter

	// The marker for the next set of results.
	Marker *string

	// The maximum number of distribution tenants to return.
	MaxItems *int32

	noSmithyDocumentSerde
}

type ListDistributionTenantsOutput struct {

	// The list of distribution tenants that you retrieved.
	DistributionTenantList []types.DistributionTenantSummary

	// A token used for pagination of results returned in the response. You can use
	// the token from the previous request to define where the current request should
	// begin.
	NextMarker *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDistributionTenantsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpListDistributionTenants{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpListDistributionTenants{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDistributionTenants"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDistributionTenants(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListDistributionTenantsPaginatorOptions is the paginator options for
// ListDistributionTenants
type ListDistributionTenantsPaginatorOptions struct {
	// The maximum number of distribution tenants to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDistributionTenantsPaginator is a paginator for ListDistributionTenants
type ListDistributionTenantsPaginator struct {
	options   ListDistributionTenantsPaginatorOptions
	client    ListDistributionTenantsAPIClient
	params    *ListDistributionTenantsInput
	nextToken *string
	firstPage bool
}

// NewListDistributionTenantsPaginator returns a new
// ListDistributionTenantsPaginator
func NewListDistributionTenantsPaginator(client ListDistributionTenantsAPIClient, params *ListDistributionTenantsInput, optFns ...func(*ListDistributionTenantsPaginatorOptions)) *ListDistributionTenantsPaginator {
	if params == nil {
		params = &ListDistributionTenantsInput{}
	}

	options := ListDistributionTenantsPaginatorOptions{}
	if params.MaxItems != nil {
		options.Limit = *params.MaxItems
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDistributionTenantsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDistributionTenantsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDistributionTenants page.
func (p *ListDistributionTenantsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDistributionTenantsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxItems = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDistributionTenants(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextMarker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDistributionTenantsAPIClient is a client that implements the
// ListDistributionTenants operation.
type ListDistributionTenantsAPIClient interface {
	ListDistributionTenants(context.Context, *ListDistributionTenantsInput, ...func(*Options)) (*ListDistributionTenantsOutput, error)
}

var _ ListDistributionTenantsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDistributionTenants(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDistributionTenants",
	}
}
