// Code generated by smithy-go-codegen DO NOT EDIT.

package costexplorer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/costexplorer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves key factors driving cost changes between two time periods within the
// last 13 months, such as usage changes, discount changes, and commitment-based
// savings. If you have enabled multi-year data at monthly granularity, you can go
// back up to 38 months.
func (c *Client) GetCostComparisonDrivers(ctx context.Context, params *GetCostComparisonDriversInput, optFns ...func(*Options)) (*GetCostComparisonDriversOutput, error) {
	if params == nil {
		params = &GetCostComparisonDriversInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCostComparisonDrivers", params, optFns, c.addOperationGetCostComparisonDriversMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCostComparisonDriversOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCostComparisonDriversInput struct {

	// The reference time period for comparison. This time period serves as the
	// baseline against which other cost and usage data will be compared. The interval
	// must start and end on the first day of a month, with a duration of exactly one
	// month.
	//
	// This member is required.
	BaselineTimePeriod *types.DateInterval

	// The comparison time period for analysis. This time period's cost and usage data
	// will be compared against the baseline time period. The interval must start and
	// end on the first day of a month, with a duration of exactly one month.
	//
	// This member is required.
	ComparisonTimePeriod *types.DateInterval

	// The cost and usage metric to compare. Valid values are AmortizedCost ,
	// BlendedCost , NetAmortizedCost , NetUnblendedCost , NormalizedUsageAmount ,
	// UnblendedCost , and UsageQuantity .
	//
	// This member is required.
	MetricForComparison *string

	// The Amazon Resource Name (ARN) that uniquely identifies a specific billing
	// view. The ARN is used to specify which particular billing view you want to
	// interact with or retrieve information from when making API calls related to
	// Amazon Web Services Billing and Cost Management features. The BillingViewArn can
	// be retrieved by calling the ListBillingViews API.
	BillingViewArn *string

	// Use Expression to filter in various Cost Explorer APIs.
	//
	// Not all Expression types are supported in each API. Refer to the documentation
	// for each specific API to see what is supported.
	//
	// There are two patterns:
	//
	//   - Simple dimension values.
	//
	//   - There are three types of simple dimension values: CostCategories , Tags ,
	//   and Dimensions .
	//
	//   - Specify the CostCategories field to define a filter that acts on Cost
	//   Categories.
	//
	//   - Specify the Tags field to define a filter that acts on Cost Allocation Tags.
	//
	//   - Specify the Dimensions field to define a filter that acts on the [DimensionValues]
	//   DimensionValues .
	//
	//   - For each filter type, you can set the dimension name and values for the
	//   filters that you plan to use.
	//
	//   - For example, you can filter for REGION==us-east-1 OR REGION==us-west-1 . For
	//   GetRightsizingRecommendation , the Region is a full name (for example,
	//   REGION==US East (N. Virginia) .
	//
	//   - The corresponding Expression for this example is as follows: {
	//   "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] } }
	//
	//   - As shown in the previous example, lists of dimension values are combined
	//   with OR when applying the filter.
	//
	//   - You can also set different match options to further control how the filter
	//   behaves. Not all APIs support match options. Refer to the documentation for each
	//   specific API to see what is supported.
	//
	//   - For example, you can filter for linked account names that start with "a".
	//
	//   - The corresponding Expression for this example is as follows: {
	//   "Dimensions": { "Key": "LINKED_ACCOUNT_NAME", "MatchOptions": [ "STARTS_WITH" ],
	//   "Values": [ "a" ] } }
	//
	//   - Compound Expression types with logical operations.
	//
	//   - You can use multiple Expression types and the logical operators AND/OR/NOT
	//   to create a list of one or more Expression objects. By doing this, you can
	//   filter by more advanced options.
	//
	//   - For example, you can filter by ((REGION == us-east-1 OR REGION ==
	//   us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer) .
	//
	//   - The corresponding Expression for this example is as follows: { "And": [
	//   {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1"
	//   ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not":
	//   {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] }
	//
	// Because each Expression can have only one operator, the service returns an error
	//   if more than one is specified. The following example shows an Expression
	//   object that creates an error: { "And": [ ... ], "Dimensions": { "Key":
	//   "USAGE_TYPE", "Values": [ "DataTransfer" ] } }
	//
	// The following is an example of the corresponding error message: "Expression has
	//   more than one roots. Only one root operator is allowed for each expression: And,
	//   Or, Not, Dimensions, Tags, CostCategories"
	//
	// For the GetRightsizingRecommendation action, a combination of OR and NOT isn't
	// supported. OR isn't supported between different dimensions, or dimensions and
	// tags. NOT operators aren't supported. Dimensions are also limited to
	// LINKED_ACCOUNT , REGION , or RIGHTSIZING_TYPE .
	//
	// For the GetReservationPurchaseRecommendation action, only NOT is supported. AND
	// and OR aren't supported. Dimensions are limited to LINKED_ACCOUNT .
	//
	// [DimensionValues]: https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DimensionValues.html
	Filter *types.Expression

	// You can group results using the attributes DIMENSION , TAG , and COST_CATEGORY .
	// Note that SERVICE and USAGE_TYPE dimensions are automatically included in the
	// cost comparison drivers analysis.
	GroupBy []types.GroupDefinition

	// The maximum number of results that are returned for the request.
	MaxResults *int32

	// The token to retrieve the next set of paginated results.
	NextPageToken *string

	noSmithyDocumentSerde
}

type GetCostComparisonDriversOutput struct {

	// An array of comparison results showing factors that drive significant cost
	// differences between BaselineTimePeriod and ComparisonTimePeriod .
	CostComparisonDrivers []types.CostComparisonDriver

	// The token to retrieve the next set of paginated results.
	NextPageToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCostComparisonDriversMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetCostComparisonDrivers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetCostComparisonDrivers{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCostComparisonDrivers"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetCostComparisonDriversValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCostComparisonDrivers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// GetCostComparisonDriversPaginatorOptions is the paginator options for
// GetCostComparisonDrivers
type GetCostComparisonDriversPaginatorOptions struct {
	// The maximum number of results that are returned for the request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetCostComparisonDriversPaginator is a paginator for GetCostComparisonDrivers
type GetCostComparisonDriversPaginator struct {
	options   GetCostComparisonDriversPaginatorOptions
	client    GetCostComparisonDriversAPIClient
	params    *GetCostComparisonDriversInput
	nextToken *string
	firstPage bool
}

// NewGetCostComparisonDriversPaginator returns a new
// GetCostComparisonDriversPaginator
func NewGetCostComparisonDriversPaginator(client GetCostComparisonDriversAPIClient, params *GetCostComparisonDriversInput, optFns ...func(*GetCostComparisonDriversPaginatorOptions)) *GetCostComparisonDriversPaginator {
	if params == nil {
		params = &GetCostComparisonDriversInput{}
	}

	options := GetCostComparisonDriversPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetCostComparisonDriversPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextPageToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetCostComparisonDriversPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetCostComparisonDrivers page.
func (p *GetCostComparisonDriversPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetCostComparisonDriversOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextPageToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetCostComparisonDrivers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextPageToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetCostComparisonDriversAPIClient is a client that implements the
// GetCostComparisonDrivers operation.
type GetCostComparisonDriversAPIClient interface {
	GetCostComparisonDrivers(context.Context, *GetCostComparisonDriversInput, ...func(*Options)) (*GetCostComparisonDriversOutput, error)
}

var _ GetCostComparisonDriversAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetCostComparisonDrivers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCostComparisonDrivers",
	}
}
