// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Describes a custom algorithm.
type Algorithm struct {

	// The Amazon Resource Name (ARN) of the algorithm.
	AlgorithmArn *string

	// The URI of the Docker container for the algorithm image.
	AlgorithmImage *AlgorithmImage

	// The date and time (in Unix time) that the algorithm was created.
	CreationDateTime *time.Time

	// Specifies the default hyperparameters, their ranges, and whether they are
	// tunable. A tunable hyperparameter can have its value determined during
	// hyperparameter optimization (HPO).
	DefaultHyperParameterRanges *DefaultHyperParameterRanges

	// Specifies the default hyperparameters.
	DefaultHyperParameters map[string]string

	// Specifies the default maximum number of training jobs and parallel training
	// jobs.
	DefaultResourceConfig map[string]string

	// The date and time (in Unix time) that the algorithm was last updated.
	LastUpdatedDateTime *time.Time

	// The name of the algorithm.
	Name *string

	// The Amazon Resource Name (ARN) of the role.
	RoleArn *string

	// The training input mode.
	TrainingInputMode *string

	noSmithyDocumentSerde
}

// Describes an algorithm image.
type AlgorithmImage struct {

	// The URI of the Docker container for the algorithm image.
	//
	// This member is required.
	DockerURI *string

	// The name of the algorithm image.
	Name *string

	noSmithyDocumentSerde
}

// When the solution performs AutoML ( performAutoML is true in [CreateSolution]), Amazon
// Personalize determines which recipe, from the specified list, optimizes the
// given metric. Amazon Personalize then uses that recipe for the solution.
//
// [CreateSolution]: https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html
type AutoMLConfig struct {

	// The metric to optimize.
	MetricName *string

	// The list of candidate recipes.
	RecipeList []string

	noSmithyDocumentSerde
}

// When the solution performs AutoML ( performAutoML is true in [CreateSolution]), specifies the
// recipe that best optimized the specified metric.
//
// [CreateSolution]: https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html
type AutoMLResult struct {

	// The Amazon Resource Name (ARN) of the best recipe.
	BestRecipeArn *string

	noSmithyDocumentSerde
}

// The automatic training configuration to use when performAutoTraining is true.
type AutoTrainingConfig struct {

	// Specifies how often to automatically train new solution versions. Specify a
	// rate expression in rate(value unit) format. For value, specify a number between
	// 1 and 30. For unit, specify day or days . For example, to automatically create a
	// new solution version every 5 days, specify rate(5 days) . The default is every 7
	// days.
	//
	// For more information about auto training, see [Creating and configuring a solution].
	//
	// [Creating and configuring a solution]: https://docs.aws.amazon.com/personalize/latest/dg/customizing-solution-config.html
	SchedulingExpression *string

	noSmithyDocumentSerde
}

// Contains information on a batch inference job.
type BatchInferenceJob struct {

	// The Amazon Resource Name (ARN) of the batch inference job.
	BatchInferenceJobArn *string

	// A string to string map of the configuration details of a batch inference job.
	BatchInferenceJobConfig *BatchInferenceJobConfig

	// The job's mode.
	BatchInferenceJobMode BatchInferenceJobMode

	// The time at which the batch inference job was created.
	CreationDateTime *time.Time

	// If the batch inference job failed, the reason for the failure.
	FailureReason *string

	// The ARN of the filter used on the batch inference job.
	FilterArn *string

	// The Amazon S3 path that leads to the input data used to generate the batch
	// inference job.
	JobInput *BatchInferenceJobInput

	// The name of the batch inference job.
	JobName *string

	// The Amazon S3 bucket that contains the output data generated by the batch
	// inference job.
	JobOutput *BatchInferenceJobOutput

	// The time at which the batch inference job was last updated.
	LastUpdatedDateTime *time.Time

	// The number of recommendations generated by the batch inference job. This number
	// includes the error messages generated for failed input records.
	NumResults *int32

	// The ARN of the Amazon Identity and Access Management (IAM) role that requested
	// the batch inference job.
	RoleArn *string

	// The Amazon Resource Name (ARN) of the solution version from which the batch
	// inference job was created.
	SolutionVersionArn *string

	// The status of the batch inference job. The status is one of the following
	// values:
	//
	//   - PENDING
	//
	//   - IN PROGRESS
	//
	//   - ACTIVE
	//
	//   - CREATE FAILED
	Status *string

	// The job's theme generation settings.
	ThemeGenerationConfig *ThemeGenerationConfig

	noSmithyDocumentSerde
}

// The configuration details of a batch inference job.
type BatchInferenceJobConfig struct {

	// A string to string map specifying the exploration configuration
	// hyperparameters, including explorationWeight and explorationItemAgeCutOff , you
	// want to use to configure the amount of item exploration Amazon Personalize uses
	// when recommending items. See [User-Personalization].
	//
	// [User-Personalization]: https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html
	ItemExplorationConfig map[string]string

	noSmithyDocumentSerde
}

// The input configuration of a batch inference job.
type BatchInferenceJobInput struct {

	// The URI of the Amazon S3 location that contains your input data. The Amazon S3
	// bucket must be in the same region as the API endpoint you are calling.
	//
	// This member is required.
	S3DataSource *S3DataConfig

	noSmithyDocumentSerde
}

// The output configuration parameters of a batch inference job.
type BatchInferenceJobOutput struct {

	// Information on the Amazon S3 bucket in which the batch inference job's output
	// is stored.
	//
	// This member is required.
	S3DataDestination *S3DataConfig

	noSmithyDocumentSerde
}

// A truncated version of the [BatchInferenceJob]. The [ListBatchInferenceJobs] operation returns a list of batch inference
// job summaries.
//
// [BatchInferenceJob]: https://docs.aws.amazon.com/personalize/latest/dg/API_BatchInferenceJob.html
// [ListBatchInferenceJobs]: https://docs.aws.amazon.com/personalize/latest/dg/API_ListBatchInferenceJobs.html
type BatchInferenceJobSummary struct {

	// The Amazon Resource Name (ARN) of the batch inference job.
	BatchInferenceJobArn *string

	// The job's mode.
	BatchInferenceJobMode BatchInferenceJobMode

	// The time at which the batch inference job was created.
	CreationDateTime *time.Time

	// If the batch inference job failed, the reason for the failure.
	FailureReason *string

	// The name of the batch inference job.
	JobName *string

	// The time at which the batch inference job was last updated.
	LastUpdatedDateTime *time.Time

	// The ARN of the solution version used by the batch inference job.
	SolutionVersionArn *string

	// The status of the batch inference job. The status is one of the following
	// values:
	//
	//   - PENDING
	//
	//   - IN PROGRESS
	//
	//   - ACTIVE
	//
	//   - CREATE FAILED
	Status *string

	noSmithyDocumentSerde
}

// Contains information on a batch segment job.
type BatchSegmentJob struct {

	// The Amazon Resource Name (ARN) of the batch segment job.
	BatchSegmentJobArn *string

	// The time at which the batch segment job was created.
	CreationDateTime *time.Time

	// If the batch segment job failed, the reason for the failure.
	FailureReason *string

	// The ARN of the filter used on the batch segment job.
	FilterArn *string

	// The Amazon S3 path that leads to the input data used to generate the batch
	// segment job.
	JobInput *BatchSegmentJobInput

	// The name of the batch segment job.
	JobName *string

	// The Amazon S3 bucket that contains the output data generated by the batch
	// segment job.
	JobOutput *BatchSegmentJobOutput

	// The time at which the batch segment job last updated.
	LastUpdatedDateTime *time.Time

	// The number of predicted users generated by the batch segment job for each line
	// of input data. The maximum number of users per segment is 5 million.
	NumResults *int32

	// The ARN of the Amazon Identity and Access Management (IAM) role that requested
	// the batch segment job.
	RoleArn *string

	// The Amazon Resource Name (ARN) of the solution version used by the batch
	// segment job to generate batch segments.
	SolutionVersionArn *string

	// The status of the batch segment job. The status is one of the following values:
	//
	//   - PENDING
	//
	//   - IN PROGRESS
	//
	//   - ACTIVE
	//
	//   - CREATE FAILED
	Status *string

	noSmithyDocumentSerde
}

// The input configuration of a batch segment job.
type BatchSegmentJobInput struct {

	// The configuration details of an Amazon S3 input or output bucket.
	//
	// This member is required.
	S3DataSource *S3DataConfig

	noSmithyDocumentSerde
}

// The output configuration parameters of a batch segment job.
type BatchSegmentJobOutput struct {

	// The configuration details of an Amazon S3 input or output bucket.
	//
	// This member is required.
	S3DataDestination *S3DataConfig

	noSmithyDocumentSerde
}

// A truncated version of the [BatchSegmentJob] datatype. [ListBatchSegmentJobs] operation returns a list of batch
// segment job summaries.
//
// [ListBatchSegmentJobs]: https://docs.aws.amazon.com/personalize/latest/dg/API_ListBatchSegmentJobs.html
// [BatchSegmentJob]: https://docs.aws.amazon.com/personalize/latest/dg/API_BatchSegmentJob.html
type BatchSegmentJobSummary struct {

	// The Amazon Resource Name (ARN) of the batch segment job.
	BatchSegmentJobArn *string

	// The time at which the batch segment job was created.
	CreationDateTime *time.Time

	// If the batch segment job failed, the reason for the failure.
	FailureReason *string

	// The name of the batch segment job.
	JobName *string

	// The time at which the batch segment job was last updated.
	LastUpdatedDateTime *time.Time

	// The Amazon Resource Name (ARN) of the solution version used by the batch
	// segment job to generate batch segments.
	SolutionVersionArn *string

	// The status of the batch segment job. The status is one of the following values:
	//
	//   - PENDING
	//
	//   - IN PROGRESS
	//
	//   - ACTIVE
	//
	//   - CREATE FAILED
	Status *string

	noSmithyDocumentSerde
}

// An object that describes the deployment of a solution version. For more
// information on campaigns, see [CreateCampaign].
//
// [CreateCampaign]: https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html
type Campaign struct {

	// The Amazon Resource Name (ARN) of the campaign.
	CampaignArn *string

	// The configuration details of a campaign.
	CampaignConfig *CampaignConfig

	// The date and time (in Unix format) that the campaign was created.
	CreationDateTime *time.Time

	// If a campaign fails, the reason behind the failure.
	FailureReason *string

	// The date and time (in Unix format) that the campaign was last updated.
	LastUpdatedDateTime *time.Time

	// Provides a summary of the properties of a campaign update. For a complete
	// listing, call the [DescribeCampaign]API.
	//
	// [DescribeCampaign]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html
	LatestCampaignUpdate *CampaignUpdateSummary

	// Specifies the requested minimum provisioned transactions (recommendations) per
	// second. A high minProvisionedTPS will increase your bill. We recommend starting
	// with 1 for minProvisionedTPS (the default). Track your usage using Amazon
	// CloudWatch metrics, and increase the minProvisionedTPS as necessary.
	MinProvisionedTPS *int32

	// The name of the campaign.
	Name *string

	// The Amazon Resource Name (ARN) of the solution version the campaign uses.
	SolutionVersionArn *string

	// The status of the campaign.
	//
	// A campaign can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//   - DELETE PENDING > DELETE IN_PROGRESS
	Status *string

	noSmithyDocumentSerde
}

// The configuration details of a campaign.
type CampaignConfig struct {

	// Whether metadata with recommendations is enabled for the campaign. If enabled,
	// you can specify the columns from your Items dataset in your request for
	// recommendations. Amazon Personalize returns this data for each item in the
	// recommendation response. For information about enabling metadata for a campaign,
	// see [Enabling metadata in recommendations for a campaign].
	//
	// If you enable metadata in recommendations, you will incur additional costs. For
	// more information, see [Amazon Personalize pricing].
	//
	// [Enabling metadata in recommendations for a campaign]: https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata
	// [Amazon Personalize pricing]: https://aws.amazon.com/personalize/pricing/
	EnableMetadataWithRecommendations *bool

	// Specifies the exploration configuration hyperparameters, including
	// explorationWeight and explorationItemAgeCutOff , you want to use to configure
	// the amount of item exploration Amazon Personalize uses when recommending items.
	// Provide itemExplorationConfig data only if your solution uses the [User-Personalization] recipe.
	//
	// [User-Personalization]: https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html
	ItemExplorationConfig map[string]string

	// Whether the campaign automatically updates to use the latest solution version
	// (trained model) of a solution. If you specify True , you must specify the ARN of
	// your solution for the SolutionVersionArn parameter. It must be in
	// SolutionArn/$LATEST format. The default is False and you must manually update
	// the campaign to deploy the latest solution version.
	//
	// For more information about automatic campaign updates, see [Enabling automatic campaign updates].
	//
	// [Enabling automatic campaign updates]: https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update
	SyncWithLatestSolutionVersion *bool

	noSmithyDocumentSerde
}

// Provides a summary of the properties of a campaign. For a complete listing,
// call the [DescribeCampaign]API.
//
// [DescribeCampaign]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html
type CampaignSummary struct {

	// The Amazon Resource Name (ARN) of the campaign.
	CampaignArn *string

	// The date and time (in Unix time) that the campaign was created.
	CreationDateTime *time.Time

	// If a campaign fails, the reason behind the failure.
	FailureReason *string

	// The date and time (in Unix time) that the campaign was last updated.
	LastUpdatedDateTime *time.Time

	// The name of the campaign.
	Name *string

	// The status of the campaign.
	//
	// A campaign can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//   - DELETE PENDING > DELETE IN_PROGRESS
	Status *string

	noSmithyDocumentSerde
}

// Provides a summary of the properties of a campaign update. For a complete
// listing, call the [DescribeCampaign]API.
//
// [DescribeCampaign]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html
type CampaignUpdateSummary struct {

	// The configuration details of a campaign.
	CampaignConfig *CampaignConfig

	// The date and time (in Unix time) that the campaign update was created.
	CreationDateTime *time.Time

	// If a campaign update fails, the reason behind the failure.
	FailureReason *string

	// The date and time (in Unix time) that the campaign update was last updated.
	LastUpdatedDateTime *time.Time

	// Specifies the requested minimum provisioned transactions (recommendations) per
	// second that Amazon Personalize will support.
	MinProvisionedTPS *int32

	// The Amazon Resource Name (ARN) of the deployed solution version.
	SolutionVersionArn *string

	// The status of the campaign update.
	//
	// A campaign update can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//   - DELETE PENDING > DELETE IN_PROGRESS
	Status *string

	noSmithyDocumentSerde
}

// Provides the name and range of a categorical hyperparameter.
type CategoricalHyperParameterRange struct {

	// The name of the hyperparameter.
	Name *string

	// A list of the categories for the hyperparameter.
	Values []string

	noSmithyDocumentSerde
}

// Provides the name and range of a continuous hyperparameter.
type ContinuousHyperParameterRange struct {

	// The maximum allowable value for the hyperparameter.
	MaxValue float64

	// The minimum allowable value for the hyperparameter.
	MinValue float64

	// The name of the hyperparameter.
	Name *string

	noSmithyDocumentSerde
}

// Describes a job that deletes all references to specific users from an Amazon
// Personalize dataset group in batches. For information about creating a data
// deletion job, see [Deleting users].
//
// [Deleting users]: https://docs.aws.amazon.com/personalize/latest/dg/delete-records.html
type DataDeletionJob struct {

	// The creation date and time (in Unix time) of the data deletion job.
	CreationDateTime *time.Time

	// The Amazon Resource Name (ARN) of the data deletion job.
	DataDeletionJobArn *string

	// Describes the data source that contains the data to upload to a dataset, or the
	// list of records to delete from Amazon Personalize.
	DataSource *DataSource

	// The Amazon Resource Name (ARN) of the dataset group the job deletes records
	// from.
	DatasetGroupArn *string

	// If a data deletion job fails, provides the reason why.
	FailureReason *string

	// The name of the data deletion job.
	JobName *string

	// The date and time (in Unix time) the data deletion job was last updated.
	LastUpdatedDateTime *time.Time

	// The number of records deleted by a COMPLETED job.
	NumDeleted *int32

	// The Amazon Resource Name (ARN) of the IAM role that has permissions to read
	// from the Amazon S3 data source.
	RoleArn *string

	// The status of the data deletion job.
	//
	// A data deletion job can have one of the following statuses:
	//
	//   - PENDING > IN_PROGRESS > COMPLETED -or- FAILED
	Status *string

	noSmithyDocumentSerde
}

// Provides a summary of the properties of a data deletion job. For a complete
// listing, call the [DescribeDataDeletionJob]API operation.
//
// [DescribeDataDeletionJob]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataDeletionJob.html
type DataDeletionJobSummary struct {

	// The creation date and time (in Unix time) of the data deletion job.
	CreationDateTime *time.Time

	// The Amazon Resource Name (ARN) of the data deletion job.
	DataDeletionJobArn *string

	// The Amazon Resource Name (ARN) of the dataset group the job deleted records
	// from.
	DatasetGroupArn *string

	// If a data deletion job fails, provides the reason why.
	FailureReason *string

	// The name of the data deletion job.
	JobName *string

	// The date and time (in Unix time) the data deletion job was last updated.
	LastUpdatedDateTime *time.Time

	// The status of the data deletion job.
	//
	// A data deletion job can have one of the following statuses:
	//
	//   - PENDING > IN_PROGRESS > COMPLETED -or- FAILED
	Status *string

	noSmithyDocumentSerde
}

// Provides metadata for a dataset.
type Dataset struct {

	// The creation date and time (in Unix time) of the dataset.
	CreationDateTime *time.Time

	// The Amazon Resource Name (ARN) of the dataset that you want metadata for.
	DatasetArn *string

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string

	// One of the following values:
	//
	//   - Interactions
	//
	//   - Items
	//
	//   - Users
	//
	//   - Actions
	//
	//   - Action_Interactions
	DatasetType *string

	// A time stamp that shows when the dataset was updated.
	LastUpdatedDateTime *time.Time

	// Describes the latest update to the dataset.
	LatestDatasetUpdate *DatasetUpdateSummary

	// The name of the dataset.
	Name *string

	// The ARN of the associated schema.
	SchemaArn *string

	// The status of the dataset.
	//
	// A dataset can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//   - DELETE PENDING > DELETE IN_PROGRESS
	Status *string

	// The ID of the event tracker for an Action interactions dataset. You specify the
	// tracker's ID in the PutActionInteractions API operation. Amazon Personalize
	// uses it to direct new data to the Action interactions dataset in your dataset
	// group.
	TrackingId *string

	noSmithyDocumentSerde
}

// Describes a job that exports a dataset to an Amazon S3 bucket. For more
// information, see [CreateDatasetExportJob].
//
// A dataset export job can be in one of the following states:
//
//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
// [CreateDatasetExportJob]: https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html
type DatasetExportJob struct {

	// The creation date and time (in Unix time) of the dataset export job.
	CreationDateTime *time.Time

	// The Amazon Resource Name (ARN) of the dataset to export.
	DatasetArn *string

	// The Amazon Resource Name (ARN) of the dataset export job.
	DatasetExportJobArn *string

	// If a dataset export job fails, provides the reason why.
	FailureReason *string

	// The data to export, based on how you imported the data. You can choose to
	// export BULK data that you imported using a dataset import job, PUT data that
	// you imported incrementally (using the console, PutEvents, PutUsers and PutItems
	// operations), or ALL for both types. The default value is PUT .
	IngestionMode IngestionMode

	// The name of the export job.
	JobName *string

	// The path to the Amazon S3 bucket where the job's output is stored. For example:
	//
	//     s3://bucket-name/folder-name/
	JobOutput *DatasetExportJobOutput

	// The date and time (in Unix time) the status of the dataset export job was last
	// updated.
	LastUpdatedDateTime *time.Time

	// The Amazon Resource Name (ARN) of the IAM service role that has permissions to
	// add data to your output Amazon S3 bucket.
	RoleArn *string

	// The status of the dataset export job.
	//
	// A dataset export job can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string

	noSmithyDocumentSerde
}

// The output configuration parameters of a dataset export job.
type DatasetExportJobOutput struct {

	// The configuration details of an Amazon S3 input or output bucket.
	//
	// This member is required.
	S3DataDestination *S3DataConfig

	noSmithyDocumentSerde
}

// Provides a summary of the properties of a dataset export job. For a complete
// listing, call the [DescribeDatasetExportJob]API.
//
// [DescribeDatasetExportJob]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetExportJob.html
type DatasetExportJobSummary struct {

	// The date and time (in Unix time) that the dataset export job was created.
	CreationDateTime *time.Time

	// The Amazon Resource Name (ARN) of the dataset export job.
	DatasetExportJobArn *string

	// If a dataset export job fails, the reason behind the failure.
	FailureReason *string

	// The name of the dataset export job.
	JobName *string

	// The date and time (in Unix time) that the dataset export job status was last
	// updated.
	LastUpdatedDateTime *time.Time

	// The status of the dataset export job.
	//
	// A dataset export job can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string

	noSmithyDocumentSerde
}

// A dataset group is a collection of related datasets (Item interactions, Users,
// Items, Actions, Action interactions). You create a dataset group by calling [CreateDatasetGroup].
// You then create a dataset and add it to a dataset group by calling [CreateDataset]. The
// dataset group is used to create and train a solution by calling [CreateSolution]. A dataset
// group can contain only one of each type of dataset.
//
// You can specify an Key Management Service (KMS) key to encrypt the datasets in
// the group.
//
// [CreateDataset]: https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html
// [CreateSolution]: https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html
// [CreateDatasetGroup]: https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html
type DatasetGroup struct {

	// The creation date and time (in Unix time) of the dataset group.
	CreationDateTime *time.Time

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string

	// The domain of a Domain dataset group.
	Domain Domain

	// If creating a dataset group fails, provides the reason why.
	FailureReason *string

	// The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to
	// encrypt the datasets.
	KmsKeyArn *string

	// The last update date and time (in Unix time) of the dataset group.
	LastUpdatedDateTime *time.Time

	// The name of the dataset group.
	Name *string

	// The ARN of the Identity and Access Management (IAM) role that has permissions
	// to access the Key Management Service (KMS) key. Supplying an IAM role is only
	// valid when also specifying a KMS key.
	RoleArn *string

	// The current status of the dataset group.
	//
	// A dataset group can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//   - DELETE PENDING
	Status *string

	noSmithyDocumentSerde
}

// Provides a summary of the properties of a dataset group. For a complete
// listing, call the [DescribeDatasetGroup]API.
//
// [DescribeDatasetGroup]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html
type DatasetGroupSummary struct {

	// The date and time (in Unix time) that the dataset group was created.
	CreationDateTime *time.Time

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string

	// The domain of a Domain dataset group.
	Domain Domain

	// If creating a dataset group fails, the reason behind the failure.
	FailureReason *string

	// The date and time (in Unix time) that the dataset group was last updated.
	LastUpdatedDateTime *time.Time

	// The name of the dataset group.
	Name *string

	// The status of the dataset group.
	//
	// A dataset group can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//   - DELETE PENDING
	Status *string

	noSmithyDocumentSerde
}

// Describes a job that imports training data from a data source (Amazon S3
// bucket) to an Amazon Personalize dataset. For more information, see [CreateDatasetImportJob].
//
// A dataset import job can be in one of the following states:
//
//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
// [CreateDatasetImportJob]: https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html
type DatasetImportJob struct {

	// The creation date and time (in Unix time) of the dataset import job.
	CreationDateTime *time.Time

	// The Amazon S3 bucket that contains the training data to import.
	DataSource *DataSource

	// The Amazon Resource Name (ARN) of the dataset that receives the imported data.
	DatasetArn *string

	// The ARN of the dataset import job.
	DatasetImportJobArn *string

	// If a dataset import job fails, provides the reason why.
	FailureReason *string

	// The import mode used by the dataset import job to import new records.
	ImportMode ImportMode

	// The name of the import job.
	JobName *string

	// The date and time (in Unix time) the dataset was last updated.
	LastUpdatedDateTime *time.Time

	// Whether the job publishes metrics to Amazon S3 for a metric attribution.
	PublishAttributionMetricsToS3 *bool

	// The ARN of the IAM role that has permissions to read from the Amazon S3 data
	// source.
	RoleArn *string

	// The status of the dataset import job.
	//
	// A dataset import job can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string

	noSmithyDocumentSerde
}

// Provides a summary of the properties of a dataset import job. For a complete
// listing, call the [DescribeDatasetImportJob]API.
//
// [DescribeDatasetImportJob]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html
type DatasetImportJobSummary struct {

	// The date and time (in Unix time) that the dataset import job was created.
	CreationDateTime *time.Time

	// The Amazon Resource Name (ARN) of the dataset import job.
	DatasetImportJobArn *string

	// If a dataset import job fails, the reason behind the failure.
	FailureReason *string

	// The import mode the dataset import job used to update the data in the dataset.
	// For more information see [Updating existing bulk data].
	//
	// [Updating existing bulk data]: https://docs.aws.amazon.com/personalize/latest/dg/updating-existing-bulk-data.html
	ImportMode ImportMode

	// The name of the dataset import job.
	JobName *string

	// The date and time (in Unix time) that the dataset import job status was last
	// updated.
	LastUpdatedDateTime *time.Time

	// The status of the dataset import job.
	//
	// A dataset import job can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string

	noSmithyDocumentSerde
}

// Describes the schema for a dataset. For more information on schemas, see [CreateSchema].
//
// [CreateSchema]: https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html
type DatasetSchema struct {

	// The date and time (in Unix time) that the schema was created.
	CreationDateTime *time.Time

	// The domain of a schema that you created for a dataset in a Domain dataset group.
	Domain Domain

	// The date and time (in Unix time) that the schema was last updated.
	LastUpdatedDateTime *time.Time

	// The name of the schema.
	Name *string

	// The schema.
	Schema *string

	// The Amazon Resource Name (ARN) of the schema.
	SchemaArn *string

	noSmithyDocumentSerde
}

// Provides a summary of the properties of a dataset schema. For a complete
// listing, call the [DescribeSchema]API.
//
// [DescribeSchema]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSchema.html
type DatasetSchemaSummary struct {

	// The date and time (in Unix time) that the schema was created.
	CreationDateTime *time.Time

	// The domain of a schema that you created for a dataset in a Domain dataset group.
	Domain Domain

	// The date and time (in Unix time) that the schema was last updated.
	LastUpdatedDateTime *time.Time

	// The name of the schema.
	Name *string

	// The Amazon Resource Name (ARN) of the schema.
	SchemaArn *string

	noSmithyDocumentSerde
}

// Provides a summary of the properties of a dataset. For a complete listing, call
// the [DescribeDataset]API.
//
// [DescribeDataset]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html
type DatasetSummary struct {

	// The date and time (in Unix time) that the dataset was created.
	CreationDateTime *time.Time

	// The Amazon Resource Name (ARN) of the dataset.
	DatasetArn *string

	// The dataset type. One of the following values:
	//
	//   - Interactions
	//
	//   - Items
	//
	//   - Users
	//
	//   - Event-Interactions
	DatasetType *string

	// The date and time (in Unix time) that the dataset was last updated.
	LastUpdatedDateTime *time.Time

	// The name of the dataset.
	Name *string

	// The status of the dataset.
	//
	// A dataset can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//   - DELETE PENDING > DELETE IN_PROGRESS
	Status *string

	noSmithyDocumentSerde
}

// Describes an update to a dataset.
type DatasetUpdateSummary struct {

	// The creation date and time (in Unix time) of the dataset update.
	CreationDateTime *time.Time

	// If updating a dataset fails, provides the reason why.
	FailureReason *string

	// The last update date and time (in Unix time) of the dataset.
	LastUpdatedDateTime *time.Time

	// The Amazon Resource Name (ARN) of the schema that replaced the previous schema
	// of the dataset.
	SchemaArn *string

	// The status of the dataset update.
	Status *string

	noSmithyDocumentSerde
}

// Describes the data source that contains the data to upload to a dataset, or the
// list of records to delete from Amazon Personalize.
type DataSource struct {

	// For dataset import jobs, the path to the Amazon S3 bucket where the data that
	// you want to upload to your dataset is stored. For data deletion jobs, the path
	// to the Amazon S3 bucket that stores the list of records to delete.
	//
	// For example:
	//
	//     s3://bucket-name/folder-name/fileName.csv
	//
	// If your CSV files are in a folder in your Amazon S3 bucket and you want your
	// import job or data deletion job to consider multiple files, you can specify the
	// path to the folder. With a data deletion job, Amazon Personalize uses all files
	// in the folder and any sub folder. Use the following syntax with a / after the
	// folder name:
	//
	//     s3://bucket-name/folder-name/
	DataLocation *string

	noSmithyDocumentSerde
}

// Provides the name and default range of a categorical hyperparameter and whether
// the hyperparameter is tunable. A tunable hyperparameter can have its value
// determined during hyperparameter optimization (HPO).
type DefaultCategoricalHyperParameterRange struct {

	// Whether the hyperparameter is tunable.
	IsTunable bool

	// The name of the hyperparameter.
	Name *string

	// A list of the categories for the hyperparameter.
	Values []string

	noSmithyDocumentSerde
}

// Provides the name and default range of a continuous hyperparameter and whether
// the hyperparameter is tunable. A tunable hyperparameter can have its value
// determined during hyperparameter optimization (HPO).
type DefaultContinuousHyperParameterRange struct {

	// Whether the hyperparameter is tunable.
	IsTunable bool

	// The maximum allowable value for the hyperparameter.
	MaxValue float64

	// The minimum allowable value for the hyperparameter.
	MinValue float64

	// The name of the hyperparameter.
	Name *string

	noSmithyDocumentSerde
}

// Specifies the hyperparameters and their default ranges. Hyperparameters can be
// categorical, continuous, or integer-valued.
type DefaultHyperParameterRanges struct {

	// The categorical hyperparameters and their default ranges.
	CategoricalHyperParameterRanges []DefaultCategoricalHyperParameterRange

	// The continuous hyperparameters and their default ranges.
	ContinuousHyperParameterRanges []DefaultContinuousHyperParameterRange

	// The integer-valued hyperparameters and their default ranges.
	IntegerHyperParameterRanges []DefaultIntegerHyperParameterRange

	noSmithyDocumentSerde
}

// Provides the name and default range of a integer-valued hyperparameter and
// whether the hyperparameter is tunable. A tunable hyperparameter can have its
// value determined during hyperparameter optimization (HPO).
type DefaultIntegerHyperParameterRange struct {

	// Indicates whether the hyperparameter is tunable.
	IsTunable bool

	// The maximum allowable value for the hyperparameter.
	MaxValue int32

	// The minimum allowable value for the hyperparameter.
	MinValue int32

	// The name of the hyperparameter.
	Name *string

	noSmithyDocumentSerde
}

// Describes the parameters of events, which are used in solution creation.
type EventParameters struct {

	// The name of the event type to be considered for solution creation.
	EventType *string

	// The threshold of the event type. Only events with a value greater or equal to
	// this threshold will be considered for solution creation.
	EventValueThreshold *float64

	// The weight of the event type. A higher weight means higher importance of the
	// event type for the created solution.
	Weight *float64

	noSmithyDocumentSerde
}

// Describes the configuration of events, which are used in solution creation.
type EventsConfig struct {

	// A list of event parameters, which includes event types and their event value
	// thresholds and weights.
	EventParametersList []EventParameters

	noSmithyDocumentSerde
}

// Provides information about an event tracker.
type EventTracker struct {

	// The Amazon Web Services account that owns the event tracker.
	AccountId *string

	// The date and time (in Unix format) that the event tracker was created.
	CreationDateTime *time.Time

	// The Amazon Resource Name (ARN) of the dataset group that receives the event
	// data.
	DatasetGroupArn *string

	// The ARN of the event tracker.
	EventTrackerArn *string

	// The date and time (in Unix time) that the event tracker was last updated.
	LastUpdatedDateTime *time.Time

	// The name of the event tracker.
	Name *string

	// The status of the event tracker.
	//
	// An event tracker can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//   - DELETE PENDING > DELETE IN_PROGRESS
	Status *string

	// The ID of the event tracker. Include this ID in requests to the [PutEvents] API.
	//
	// [PutEvents]: https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html
	TrackingId *string

	noSmithyDocumentSerde
}

// Provides a summary of the properties of an event tracker. For a complete
// listing, call the [DescribeEventTracker]API.
//
// [DescribeEventTracker]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html
type EventTrackerSummary struct {

	// The date and time (in Unix time) that the event tracker was created.
	CreationDateTime *time.Time

	// The Amazon Resource Name (ARN) of the event tracker.
	EventTrackerArn *string

	// The date and time (in Unix time) that the event tracker was last updated.
	LastUpdatedDateTime *time.Time

	// The name of the event tracker.
	Name *string

	// The status of the event tracker.
	//
	// An event tracker can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//   - DELETE PENDING > DELETE IN_PROGRESS
	Status *string

	noSmithyDocumentSerde
}

// Provides feature transformation information. Feature transformation is the
// process of modifying raw input data into a form more suitable for model
// training.
type FeatureTransformation struct {

	// The creation date and time (in Unix time) of the feature transformation.
	CreationDateTime *time.Time

	// Provides the default parameters for feature transformation.
	DefaultParameters map[string]string

	// The Amazon Resource Name (ARN) of the FeatureTransformation object.
	FeatureTransformationArn *string

	// The last update date and time (in Unix time) of the feature transformation.
	LastUpdatedDateTime *time.Time

	// The name of the feature transformation.
	Name *string

	// The status of the feature transformation.
	//
	// A feature transformation can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string

	noSmithyDocumentSerde
}

// A string to string map of the configuration details for theme generation.
type FieldsForThemeGeneration struct {

	// The name of the Items dataset column that stores the name of each item in the
	// dataset.
	//
	// This member is required.
	ItemName *string

	noSmithyDocumentSerde
}

// Contains information on a recommendation filter, including its ARN, status, and
// filter expression.
type Filter struct {

	// The time at which the filter was created.
	CreationDateTime *time.Time

	// The ARN of the dataset group to which the filter belongs.
	DatasetGroupArn *string

	// If the filter failed, the reason for its failure.
	FailureReason *string

	// The ARN of the filter.
	FilterArn *string

	// Specifies the type of item interactions to filter out of recommendation
	// results. The filter expression must follow specific format rules. For
	// information about filter expression structure and syntax, see [Filter expressions].
	//
	// [Filter expressions]: https://docs.aws.amazon.com/personalize/latest/dg/filter-expressions.html
	FilterExpression *string

	// The time at which the filter was last updated.
	LastUpdatedDateTime *time.Time

	// The name of the filter.
	Name *string

	// The status of the filter.
	Status *string

	noSmithyDocumentSerde
}

// A short summary of a filter's attributes.
type FilterSummary struct {

	// The time at which the filter was created.
	CreationDateTime *time.Time

	// The ARN of the dataset group to which the filter belongs.
	DatasetGroupArn *string

	// If the filter failed, the reason for the failure.
	FailureReason *string

	// The ARN of the filter.
	FilterArn *string

	// The time at which the filter was last updated.
	LastUpdatedDateTime *time.Time

	// The name of the filter.
	Name *string

	// The status of the filter.
	Status *string

	noSmithyDocumentSerde
}

// Describes the properties for hyperparameter optimization (HPO).
type HPOConfig struct {

	// The hyperparameters and their allowable ranges.
	AlgorithmHyperParameterRanges *HyperParameterRanges

	// The metric to optimize during HPO.
	//
	// Amazon Personalize doesn't support configuring the hpoObjective at this time.
	HpoObjective *HPOObjective

	// Describes the resource configuration for HPO.
	HpoResourceConfig *HPOResourceConfig

	noSmithyDocumentSerde
}

// The metric to optimize during hyperparameter optimization (HPO).
//
// Amazon Personalize doesn't support configuring the hpoObjective at this time.
type HPOObjective struct {

	// The name of the metric.
	MetricName *string

	// A regular expression for finding the metric in the training job logs.
	MetricRegex *string

	// The type of the metric. Valid values are Maximize and Minimize .
	Type *string

	noSmithyDocumentSerde
}

// Describes the resource configuration for hyperparameter optimization (HPO).
type HPOResourceConfig struct {

	// The maximum number of training jobs when you create a solution version. The
	// maximum value for maxNumberOfTrainingJobs is 40 .
	MaxNumberOfTrainingJobs *string

	// The maximum number of parallel training jobs when you create a solution
	// version. The maximum value for maxParallelTrainingJobs is 10 .
	MaxParallelTrainingJobs *string

	noSmithyDocumentSerde
}

// Specifies the hyperparameters and their ranges. Hyperparameters can be
// categorical, continuous, or integer-valued.
type HyperParameterRanges struct {

	// The categorical hyperparameters and their ranges.
	CategoricalHyperParameterRanges []CategoricalHyperParameterRange

	// The continuous hyperparameters and their ranges.
	ContinuousHyperParameterRanges []ContinuousHyperParameterRange

	// The integer-valued hyperparameters and their ranges.
	IntegerHyperParameterRanges []IntegerHyperParameterRange

	noSmithyDocumentSerde
}

// Provides the name and range of an integer-valued hyperparameter.
type IntegerHyperParameterRange struct {

	// The maximum allowable value for the hyperparameter.
	MaxValue int32

	// The minimum allowable value for the hyperparameter.
	MinValue int32

	// The name of the hyperparameter.
	Name *string

	noSmithyDocumentSerde
}

// Contains information on a metric that a metric attribution reports on. For more
// information, see [Measuring impact of recommendations].
//
// [Measuring impact of recommendations]: https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html
type MetricAttribute struct {

	// The metric's event type.
	//
	// This member is required.
	EventType *string

	// The attribute's expression. Available functions are SUM() or SAMPLECOUNT() . For
	// SUM() functions, provide the dataset type (either Interactions or Items) and
	// column to sum as a parameter. For example SUM(Items.PRICE).
	//
	// This member is required.
	Expression *string

	// The metric's name. The name helps you identify the metric in Amazon CloudWatch
	// or Amazon S3.
	//
	// This member is required.
	MetricName *string

	noSmithyDocumentSerde
}

// Contains information on a metric attribution. A metric attribution creates
// reports on the data that you import into Amazon Personalize. Depending on how
// you import the data, you can view reports in Amazon CloudWatch or Amazon S3. For
// more information, see [Measuring impact of recommendations].
//
// [Measuring impact of recommendations]: https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html
type MetricAttribution struct {

	// The metric attribution's creation date time.
	CreationDateTime *time.Time

	// The metric attribution's dataset group Amazon Resource Name (ARN).
	DatasetGroupArn *string

	// The metric attribution's failure reason.
	FailureReason *string

	// The metric attribution's last updated date time.
	LastUpdatedDateTime *time.Time

	// The metric attribution's Amazon Resource Name (ARN).
	MetricAttributionArn *string

	// The metric attribution's output configuration.
	MetricsOutputConfig *MetricAttributionOutput

	// The metric attribution's name.
	Name *string

	// The metric attribution's status.
	Status *string

	noSmithyDocumentSerde
}

// The output configuration details for a metric attribution.
type MetricAttributionOutput struct {

	// The Amazon Resource Name (ARN) of the IAM service role that has permissions to
	// add data to your output Amazon S3 bucket and add metrics to Amazon CloudWatch.
	// For more information, see [Measuring impact of recommendations].
	//
	// [Measuring impact of recommendations]: https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html
	//
	// This member is required.
	RoleArn *string

	// The configuration details of an Amazon S3 input or output bucket.
	S3DataDestination *S3DataConfig

	noSmithyDocumentSerde
}

// Provides a summary of the properties of a metric attribution. For a complete
// listing, call the [DescribeMetricAttribution].
//
// [DescribeMetricAttribution]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeMetricAttribution.html
type MetricAttributionSummary struct {

	// The metric attribution's creation date time.
	CreationDateTime *time.Time

	// The metric attribution's failure reason.
	FailureReason *string

	// The metric attribution's last updated date time.
	LastUpdatedDateTime *time.Time

	// The metric attribution's Amazon Resource Name (ARN).
	MetricAttributionArn *string

	// The name of the metric attribution.
	Name *string

	// The metric attribution's status.
	Status *string

	noSmithyDocumentSerde
}

// Describes the additional objective for the solution, such as maximizing
// streaming minutes or increasing revenue. For more information see [Optimizing a solution].
//
// [Optimizing a solution]: https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html
type OptimizationObjective struct {

	// The numerical metadata column in an Items dataset related to the optimization
	// objective. For example, VIDEO_LENGTH (to maximize streaming minutes), or PRICE
	// (to maximize revenue).
	ItemAttribute *string

	// Specifies how Amazon Personalize balances the importance of your optimization
	// objective versus relevance.
	ObjectiveSensitivity ObjectiveSensitivity

	noSmithyDocumentSerde
}

// Provides information about a recipe. Each recipe provides an algorithm that
// Amazon Personalize uses in model training when you use the [CreateSolution]operation.
//
// [CreateSolution]: https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html
type Recipe struct {

	// The Amazon Resource Name (ARN) of the algorithm that Amazon Personalize uses to
	// train the model.
	AlgorithmArn *string

	// The date and time (in Unix format) that the recipe was created.
	CreationDateTime *time.Time

	// The description of the recipe.
	Description *string

	// The ARN of the FeatureTransformation object.
	FeatureTransformationArn *string

	// The date and time (in Unix format) that the recipe was last updated.
	LastUpdatedDateTime *time.Time

	// The name of the recipe.
	Name *string

	// The Amazon Resource Name (ARN) of the recipe.
	RecipeArn *string

	// One of the following values:
	//
	//   - PERSONALIZED_RANKING
	//
	//   - RELATED_ITEMS
	//
	//   - USER_PERSONALIZATION
	RecipeType *string

	// The status of the recipe.
	Status *string

	noSmithyDocumentSerde
}

// Provides a summary of the properties of a recipe. For a complete listing, call
// the [DescribeRecipe]API.
//
// [DescribeRecipe]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecipe.html
type RecipeSummary struct {

	// The date and time (in Unix time) that the recipe was created.
	CreationDateTime *time.Time

	// The domain of the recipe (if the recipe is a Domain dataset group use case).
	Domain Domain

	// The date and time (in Unix time) that the recipe was last updated.
	LastUpdatedDateTime *time.Time

	// The name of the recipe.
	Name *string

	// The Amazon Resource Name (ARN) of the recipe.
	RecipeArn *string

	// The status of the recipe.
	Status *string

	noSmithyDocumentSerde
}

// Describes a recommendation generator for a Domain dataset group. You create a
// recommender in a Domain dataset group for a specific domain use case (domain
// recipe), and specify the recommender in a [GetRecommendations]request.
//
// [GetRecommendations]: https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html
type Recommender struct {

	// The date and time (in Unix format) that the recommender was created.
	CreationDateTime *time.Time

	// The Amazon Resource Name (ARN) of the Domain dataset group that contains the
	// recommender.
	DatasetGroupArn *string

	// If a recommender fails, the reason behind the failure.
	FailureReason *string

	// The date and time (in Unix format) that the recommender was last updated.
	LastUpdatedDateTime *time.Time

	// Provides a summary of the latest updates to the recommender.
	LatestRecommenderUpdate *RecommenderUpdateSummary

	// Provides evaluation metrics that help you determine the performance of a
	// recommender. For more information, see [Evaluating a recommender].
	//
	// [Evaluating a recommender]: https://docs.aws.amazon.com/personalize/latest/dg/evaluating-recommenders.html
	ModelMetrics map[string]float64

	// The name of the recommender.
	Name *string

	// The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case)
	// that the recommender was created for.
	RecipeArn *string

	// The Amazon Resource Name (ARN) of the recommender.
	RecommenderArn *string

	// The configuration details of the recommender.
	RecommenderConfig *RecommenderConfig

	// The status of the recommender.
	//
	// A recommender can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//   - STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START
	//   IN_PROGRESS > ACTIVE
	//
	//   - DELETE PENDING > DELETE IN_PROGRESS
	Status *string

	noSmithyDocumentSerde
}

// The configuration details of the recommender.
type RecommenderConfig struct {

	// Whether metadata with recommendations is enabled for the recommender. If
	// enabled, you can specify the columns from your Items dataset in your request for
	// recommendations. Amazon Personalize returns this data for each item in the
	// recommendation response. For information about enabling metadata for a
	// recommender, see [Enabling metadata in recommendations for a recommender].
	//
	// If you enable metadata in recommendations, you will incur additional costs. For
	// more information, see [Amazon Personalize pricing].
	//
	// [Enabling metadata in recommendations for a recommender]: https://docs.aws.amazon.com/personalize/latest/dg/creating-recommenders.html#create-recommender-return-metadata
	// [Amazon Personalize pricing]: https://aws.amazon.com/personalize/pricing/
	EnableMetadataWithRecommendations *bool

	// Specifies the exploration configuration hyperparameters, including
	// explorationWeight and explorationItemAgeCutOff , you want to use to configure
	// the amount of item exploration Amazon Personalize uses when recommending items.
	// Provide itemExplorationConfig data only if your recommenders generate
	// personalized recommendations for a user (not popular items or similar items).
	ItemExplorationConfig map[string]string

	// Specifies the requested minimum provisioned recommendation requests per second
	// that Amazon Personalize will support. A high minRecommendationRequestsPerSecond
	// will increase your bill. We recommend starting with 1 for
	// minRecommendationRequestsPerSecond (the default). Track your usage using Amazon
	// CloudWatch metrics, and increase the minRecommendationRequestsPerSecond as
	// necessary.
	MinRecommendationRequestsPerSecond *int32

	//  Specifies the training data configuration to use when creating a domain
	// recommender.
	TrainingDataConfig *TrainingDataConfig

	noSmithyDocumentSerde
}

// Provides a summary of the properties of the recommender.
type RecommenderSummary struct {

	// The date and time (in Unix format) that the recommender was created.
	CreationDateTime *time.Time

	// The Amazon Resource Name (ARN) of the Domain dataset group that contains the
	// recommender.
	DatasetGroupArn *string

	// The date and time (in Unix format) that the recommender was last updated.
	LastUpdatedDateTime *time.Time

	// The name of the recommender.
	Name *string

	// The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case)
	// that the recommender was created for.
	RecipeArn *string

	// The Amazon Resource Name (ARN) of the recommender.
	RecommenderArn *string

	// The configuration details of the recommender.
	RecommenderConfig *RecommenderConfig

	// The status of the recommender. A recommender can be in one of the following
	// states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//   - STOP PENDING > STOP IN_PROGRESS > INACTIVE > START PENDING > START
	//   IN_PROGRESS > ACTIVE
	//
	//   - DELETE PENDING > DELETE IN_PROGRESS
	Status *string

	noSmithyDocumentSerde
}

// Provides a summary of the properties of a recommender update. For a complete
// listing, call the [DescribeRecommender]API.
//
// [DescribeRecommender]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html
type RecommenderUpdateSummary struct {

	// The date and time (in Unix format) that the recommender update was created.
	CreationDateTime *time.Time

	// If a recommender update fails, the reason behind the failure.
	FailureReason *string

	// The date and time (in Unix time) that the recommender update was last updated.
	LastUpdatedDateTime *time.Time

	// The configuration details of the recommender update.
	RecommenderConfig *RecommenderConfig

	// The status of the recommender update. A recommender update can be in one of the
	// following states:
	//
	// CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string

	noSmithyDocumentSerde
}

// The configuration details of an Amazon S3 input or output bucket.
type S3DataConfig struct {

	// The file path of the Amazon S3 bucket.
	//
	// This member is required.
	Path *string

	// The Amazon Resource Name (ARN) of the Key Management Service (KMS) key that
	// Amazon Personalize uses to encrypt or decrypt the input and output files.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// By default, all new solutions use automatic training. With automatic training,
// you incur training costs while your solution is active. To avoid unnecessary
// costs, when you are finished you can [update the solution]to turn off automatic training. For
// information about training costs, see [Amazon Personalize pricing].
//
// An object that provides information about a solution. A solution includes the
// custom recipe, customized parameters, and trained models (Solution Versions)
// that Amazon Personalize uses to generate recommendations.
//
// After you create a solution, you can’t change its configuration. If you need to
// make changes, you can [clone the solution]with the Amazon Personalize console or create a new one.
//
// [clone the solution]: https://docs.aws.amazon.com/personalize/latest/dg/cloning-solution.html
// [update the solution]: https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateSolution.html
// [Amazon Personalize pricing]: https://aws.amazon.com/personalize/pricing/
type Solution struct {

	// When performAutoML is true, specifies the best recipe found.
	AutoMLResult *AutoMLResult

	// The creation date and time (in Unix time) of the solution.
	CreationDateTime *time.Time

	// The Amazon Resource Name (ARN) of the dataset group that provides the training
	// data.
	DatasetGroupArn *string

	// The event type (for example, 'click' or 'like') that is used for training the
	// model. If no eventType is provided, Amazon Personalize uses all interactions
	// for training with equal weight regardless of type.
	EventType *string

	// The date and time (in Unix time) that the solution was last updated.
	LastUpdatedDateTime *time.Time

	// Provides a summary of the latest updates to the solution.
	LatestSolutionUpdate *SolutionUpdateSummary

	// Describes the latest version of the solution, including the status and the ARN.
	LatestSolutionVersion *SolutionVersionSummary

	// The name of the solution.
	Name *string

	// We don't recommend enabling automated machine learning. Instead, match your use
	// case to the available Amazon Personalize recipes. For more information, see [Determining your use case.]
	//
	// When true, Amazon Personalize performs a search for the best
	// USER_PERSONALIZATION recipe from the list specified in the solution
	// configuration ( recipeArn must not be specified). When false (the default),
	// Amazon Personalize uses recipeArn for training.
	//
	// [Determining your use case.]: https://docs.aws.amazon.com/personalize/latest/dg/determining-use-case.html
	PerformAutoML bool

	// Specifies whether the solution automatically creates solution versions. The
	// default is True and the solution automatically creates new solution versions
	// every 7 days.
	//
	// For more information about auto training, see [Creating and configuring a solution].
	//
	// [Creating and configuring a solution]: https://docs.aws.amazon.com/personalize/latest/dg/customizing-solution-config.html
	PerformAutoTraining *bool

	// Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The
	// default is false .
	PerformHPO bool

	// The ARN of the recipe used to create the solution. This is required when
	// performAutoML is false.
	RecipeArn *string

	// The ARN of the solution.
	SolutionArn *string

	// Describes the configuration properties for the solution.
	SolutionConfig *SolutionConfig

	// The status of the solution.
	//
	// A solution can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//   - DELETE PENDING > DELETE IN_PROGRESS
	Status *string

	noSmithyDocumentSerde
}

// Describes the configuration properties for the solution.
type SolutionConfig struct {

	// Lists the algorithm hyperparameters and their values.
	AlgorithmHyperParameters map[string]string

	// The [AutoMLConfig] object containing a list of recipes to search when AutoML is performed.
	//
	// [AutoMLConfig]: https://docs.aws.amazon.com/personalize/latest/dg/API_AutoMLConfig.html
	AutoMLConfig *AutoMLConfig

	// Specifies the automatic training configuration to use.
	AutoTrainingConfig *AutoTrainingConfig

	// Only events with a value greater than or equal to this threshold are used for
	// training a model.
	EventValueThreshold *string

	// Describes the configuration of an event, which includes a list of event
	// parameters. You can specify up to 10 event parameters. Events are used in
	// solution creation.
	EventsConfig *EventsConfig

	// Lists the feature transformation parameters.
	FeatureTransformationParameters map[string]string

	// Describes the properties for hyperparameter optimization (HPO).
	HpoConfig *HPOConfig

	// Describes the additional objective for the solution, such as maximizing
	// streaming minutes or increasing revenue. For more information see [Optimizing a solution].
	//
	// [Optimizing a solution]: https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html
	OptimizationObjective *OptimizationObjective

	//  Specifies the training data configuration to use when creating a custom
	// solution version (trained model).
	TrainingDataConfig *TrainingDataConfig

	noSmithyDocumentSerde
}

// Provides a summary of the properties of a solution. For a complete listing,
// call the [DescribeSolution]API.
//
// [DescribeSolution]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html
type SolutionSummary struct {

	// The date and time (in Unix time) that the solution was created.
	CreationDateTime *time.Time

	// The date and time (in Unix time) that the solution was last updated.
	LastUpdatedDateTime *time.Time

	// The name of the solution.
	Name *string

	// The Amazon Resource Name (ARN) of the recipe used by the solution.
	RecipeArn *string

	// The Amazon Resource Name (ARN) of the solution.
	SolutionArn *string

	// The status of the solution.
	//
	// A solution can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	//
	//   - DELETE PENDING > DELETE IN_PROGRESS
	Status *string

	noSmithyDocumentSerde
}

// The configuration details of the solution update.
type SolutionUpdateConfig struct {

	// The automatic training configuration to use when performAutoTraining is true.
	AutoTrainingConfig *AutoTrainingConfig

	// Describes the configuration of an event, which includes a list of event
	// parameters. You can specify up to 10 event parameters. Events are used in
	// solution creation.
	EventsConfig *EventsConfig

	noSmithyDocumentSerde
}

// Provides a summary of the properties of a solution update. For a complete
// listing, call the [DescribeSolution]API.
//
// [DescribeSolution]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html
type SolutionUpdateSummary struct {

	// The date and time (in Unix format) that the solution update was created.
	CreationDateTime *time.Time

	// If a solution update fails, the reason behind the failure.
	FailureReason *string

	// The date and time (in Unix time) that the solution update was last updated.
	LastUpdatedDateTime *time.Time

	// Whether the solution automatically creates solution versions.
	PerformAutoTraining *bool

	// The configuration details of the solution.
	SolutionUpdateConfig *SolutionUpdateConfig

	// The status of the solution update. A solution update can be in one of the
	// following states:
	//
	// CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string

	noSmithyDocumentSerde
}

// An object that provides information about a specific version of a [Solution] in a Custom
// dataset group.
//
// [Solution]: https://docs.aws.amazon.com/personalize/latest/dg/API_Solution.html
type SolutionVersion struct {

	// The date and time (in Unix time) that this version of the solution was created.
	CreationDateTime *time.Time

	// The Amazon Resource Name (ARN) of the dataset group providing the training data.
	DatasetGroupArn *string

	// The event type (for example, 'click' or 'like') that is used for training the
	// model.
	EventType *string

	// If training a solution version fails, the reason for the failure.
	FailureReason *string

	// The date and time (in Unix time) that the solution was last updated.
	LastUpdatedDateTime *time.Time

	// The name of the solution version.
	Name *string

	// When true, Amazon Personalize searches for the most optimal recipe according to
	// the solution configuration. When false (the default), Amazon Personalize uses
	// recipeArn .
	PerformAutoML bool

	// Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The
	// default is false .
	PerformHPO bool

	// The ARN of the recipe used in the solution.
	RecipeArn *string

	// The ARN of the solution.
	SolutionArn *string

	// Describes the configuration properties for the solution.
	SolutionConfig *SolutionConfig

	// The ARN of the solution version.
	SolutionVersionArn *string

	// The status of the solution version.
	//
	// A solution version can be in one of the following states:
	//
	//   - CREATE PENDING
	//
	//   - CREATE IN_PROGRESS
	//
	//   - ACTIVE
	//
	//   - CREATE FAILED
	//
	//   - CREATE STOPPING
	//
	//   - CREATE STOPPED
	Status *string

	// The time used to train the model. You are billed for the time it takes to train
	// a model. This field is visible only after Amazon Personalize successfully trains
	// a model.
	TrainingHours *float64

	// The scope of training to be performed when creating the solution version. A FULL
	// training considers all of the data in your dataset group. An UPDATE processes
	// only the data that has changed since the latest training. Only solution versions
	// created with the User-Personalization recipe can use UPDATE .
	TrainingMode TrainingMode

	// Whether the solution version was created automatically or manually.
	TrainingType TrainingType

	// If hyperparameter optimization was performed, contains the hyperparameter
	// values of the best performing model.
	TunedHPOParams *TunedHPOParams

	noSmithyDocumentSerde
}

// Provides a summary of the properties of a solution version. For a complete
// listing, call the [DescribeSolutionVersion]API.
//
// [DescribeSolutionVersion]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html
type SolutionVersionSummary struct {

	// The date and time (in Unix time) that this version of a solution was created.
	CreationDateTime *time.Time

	// If a solution version fails, the reason behind the failure.
	FailureReason *string

	// The date and time (in Unix time) that the solution version was last updated.
	LastUpdatedDateTime *time.Time

	// The Amazon Resource Name (ARN) of the solution version.
	SolutionVersionArn *string

	// The status of the solution version.
	//
	// A solution version can be in one of the following states:
	//
	//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
	Status *string

	// The scope of training to be performed when creating the solution version. A FULL
	// training considers all of the data in your dataset group. An UPDATE processes
	// only the data that has changed since the latest training. Only solution versions
	// created with the User-Personalization recipe can use UPDATE .
	TrainingMode TrainingMode

	// Whether the solution version was created automatically or manually.
	TrainingType TrainingType

	noSmithyDocumentSerde
}

// The optional metadata that you apply to resources to help you categorize and
// organize them. Each tag consists of a key and an optional value, both of which
// you define. For more information see [Tagging Amazon Personalize resources].
//
// [Tagging Amazon Personalize resources]: https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html
type Tag struct {

	// One part of a key-value pair that makes up a tag. A key is a general label that
	// acts like a category for more specific tag values.
	//
	// This member is required.
	TagKey *string

	// The optional part of a key-value pair that makes up a tag. A value acts as a
	// descriptor within a tag category (key).
	//
	// This member is required.
	TagValue *string

	noSmithyDocumentSerde
}

// The configuration details for generating themes with a batch inference job.
type ThemeGenerationConfig struct {

	// Fields used to generate descriptive themes for a batch inference job.
	//
	// This member is required.
	FieldsForThemeGeneration *FieldsForThemeGeneration

	noSmithyDocumentSerde
}

// The training data configuration to use when creating a domain recommender or
// custom solution version (trained model).
type TrainingDataConfig struct {

	// Specifies the columns to exclude from training. Each key is a dataset type, and
	// each value is a list of columns. Exclude columns to control what data Amazon
	// Personalize uses to generate recommendations.
	//
	// For example, you might have a column that you want to use only to filter
	// recommendations. You can exclude this column from training and Amazon
	// Personalize considers it only when filtering.
	ExcludedDatasetColumns map[string][]string

	noSmithyDocumentSerde
}

// If hyperparameter optimization (HPO) was performed, contains the hyperparameter
// values of the best performing model.
type TunedHPOParams struct {

	// A list of the hyperparameter values of the best performing model.
	AlgorithmHyperParameters map[string]string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
