// Code generated by smithy-go-codegen DO NOT EDIT.

package ssmsap

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ssmsap/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the configuration check operations performed by AWS Systems Manager for
// SAP.
func (c *Client) ListConfigurationCheckOperations(ctx context.Context, params *ListConfigurationCheckOperationsInput, optFns ...func(*Options)) (*ListConfigurationCheckOperationsOutput, error) {
	if params == nil {
		params = &ListConfigurationCheckOperationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListConfigurationCheckOperations", params, optFns, c.addOperationListConfigurationCheckOperationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListConfigurationCheckOperationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListConfigurationCheckOperationsInput struct {

	// The ID of the application.
	//
	// This member is required.
	ApplicationId *string

	// The filters of an operation.
	Filters []types.Filter

	// The mode for listing configuration check operations. Defaults to
	// "LATEST_PER_CHECK".
	//
	//   - LATEST_PER_CHECK - Will list the latest configuration check operation per
	//   check type.
	//
	//   - ALL_OPERATIONS - Will list all configuration check operations performed on
	//   the application.
	ListMode types.ConfigurationCheckOperationListingMode

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListConfigurationCheckOperationsOutput struct {

	// The configuration check operations performed by AWS Systems Manager for SAP.
	ConfigurationCheckOperations []types.ConfigurationCheckOperation

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListConfigurationCheckOperationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListConfigurationCheckOperations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListConfigurationCheckOperations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListConfigurationCheckOperations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListConfigurationCheckOperationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListConfigurationCheckOperations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListConfigurationCheckOperationsPaginatorOptions is the paginator options for
// ListConfigurationCheckOperations
type ListConfigurationCheckOperationsPaginatorOptions struct {
	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListConfigurationCheckOperationsPaginator is a paginator for
// ListConfigurationCheckOperations
type ListConfigurationCheckOperationsPaginator struct {
	options   ListConfigurationCheckOperationsPaginatorOptions
	client    ListConfigurationCheckOperationsAPIClient
	params    *ListConfigurationCheckOperationsInput
	nextToken *string
	firstPage bool
}

// NewListConfigurationCheckOperationsPaginator returns a new
// ListConfigurationCheckOperationsPaginator
func NewListConfigurationCheckOperationsPaginator(client ListConfigurationCheckOperationsAPIClient, params *ListConfigurationCheckOperationsInput, optFns ...func(*ListConfigurationCheckOperationsPaginatorOptions)) *ListConfigurationCheckOperationsPaginator {
	if params == nil {
		params = &ListConfigurationCheckOperationsInput{}
	}

	options := ListConfigurationCheckOperationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListConfigurationCheckOperationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListConfigurationCheckOperationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListConfigurationCheckOperations page.
func (p *ListConfigurationCheckOperationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListConfigurationCheckOperationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListConfigurationCheckOperations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListConfigurationCheckOperationsAPIClient is a client that implements the
// ListConfigurationCheckOperations operation.
type ListConfigurationCheckOperationsAPIClient interface {
	ListConfigurationCheckOperations(context.Context, *ListConfigurationCheckOperationsInput, ...func(*Options)) (*ListConfigurationCheckOperationsOutput, error)
}

var _ ListConfigurationCheckOperationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListConfigurationCheckOperations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListConfigurationCheckOperations",
	}
}
