// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1beta/control.proto

package discoveryenginepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines circumstances to be checked before allowing a behavior
type Condition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Search only
	// A list of terms to match the query on.
	//
	// Maximum of 10 query terms.
	QueryTerms []*Condition_QueryTerm `protobuf:"bytes,2,rep,name=query_terms,json=queryTerms,proto3" json:"query_terms,omitempty"`
	// Range of time(s) specifying when condition is active.
	//
	// Maximum of 10 time ranges.
	ActiveTimeRange []*Condition_TimeRange `protobuf:"bytes,3,rep,name=active_time_range,json=activeTimeRange,proto3" json:"active_time_range,omitempty"`
}

func (x *Condition) Reset() {
	*x = Condition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Condition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Condition) ProtoMessage() {}

func (x *Condition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Condition.ProtoReflect.Descriptor instead.
func (*Condition) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_control_proto_rawDescGZIP(), []int{0}
}

func (x *Condition) GetQueryTerms() []*Condition_QueryTerm {
	if x != nil {
		return x.QueryTerms
	}
	return nil
}

func (x *Condition) GetActiveTimeRange() []*Condition_TimeRange {
	if x != nil {
		return x.ActiveTimeRange
	}
	return nil
}

// Defines a conditioned behavior to employ during serving.
// Must be attached to a
// [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig] to be
// considered at serving time. Permitted actions dependent on `SolutionType`.
type Control struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Actions are restricted by Vertical and Solution
	//
	// Required.
	//
	// Types that are assignable to Action:
	//
	//	*Control_BoostAction_
	//	*Control_FilterAction_
	//	*Control_RedirectAction_
	//	*Control_SynonymsAction_
	Action isControl_Action `protobuf_oneof:"action"`
	// Immutable. Fully qualified name
	// `projects/*/locations/global/dataStore/*/controls/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Human readable name. The identifier used in UI views.
	//
	// Must be UTF-8 encoded string. Length limit is 128 characters.
	// Otherwise an INVALID ARGUMENT error is thrown.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. List of all
	// [ServingConfig][google.cloud.discoveryengine.v1beta.ServingConfig] ids this
	// control is attached to. May take up to 10 minutes to update after changes.
	AssociatedServingConfigIds []string `protobuf:"bytes,3,rep,name=associated_serving_config_ids,json=associatedServingConfigIds,proto3" json:"associated_serving_config_ids,omitempty"`
	// Required. Immutable. What solution the control belongs to.
	//
	// Must be compatible with vertical of resource.
	// Otherwise an INVALID ARGUMENT error is thrown.
	SolutionType SolutionType `protobuf:"varint,4,opt,name=solution_type,json=solutionType,proto3,enum=google.cloud.discoveryengine.v1beta.SolutionType" json:"solution_type,omitempty"`
	// Specifies the use case for the control.
	// Affects what condition fields can be set.
	// Only applies to
	// [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
	// Currently only allow one use case per control.
	// Must be set when solution_type is
	// [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
	UseCases []SearchUseCase `protobuf:"varint,8,rep,packed,name=use_cases,json=useCases,proto3,enum=google.cloud.discoveryengine.v1beta.SearchUseCase" json:"use_cases,omitempty"`
	// Determines when the associated action will trigger.
	//
	// Omit to always apply the action.
	// Currently only a single condition may be specified.
	// Otherwise an INVALID ARGUMENT error is thrown.
	Conditions []*Condition `protobuf:"bytes,5,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (x *Control) Reset() {
	*x = Control{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Control) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Control) ProtoMessage() {}

func (x *Control) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Control.ProtoReflect.Descriptor instead.
func (*Control) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_control_proto_rawDescGZIP(), []int{1}
}

func (m *Control) GetAction() isControl_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (x *Control) GetBoostAction() *Control_BoostAction {
	if x, ok := x.GetAction().(*Control_BoostAction_); ok {
		return x.BoostAction
	}
	return nil
}

func (x *Control) GetFilterAction() *Control_FilterAction {
	if x, ok := x.GetAction().(*Control_FilterAction_); ok {
		return x.FilterAction
	}
	return nil
}

func (x *Control) GetRedirectAction() *Control_RedirectAction {
	if x, ok := x.GetAction().(*Control_RedirectAction_); ok {
		return x.RedirectAction
	}
	return nil
}

func (x *Control) GetSynonymsAction() *Control_SynonymsAction {
	if x, ok := x.GetAction().(*Control_SynonymsAction_); ok {
		return x.SynonymsAction
	}
	return nil
}

func (x *Control) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Control) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Control) GetAssociatedServingConfigIds() []string {
	if x != nil {
		return x.AssociatedServingConfigIds
	}
	return nil
}

func (x *Control) GetSolutionType() SolutionType {
	if x != nil {
		return x.SolutionType
	}
	return SolutionType_SOLUTION_TYPE_UNSPECIFIED
}

func (x *Control) GetUseCases() []SearchUseCase {
	if x != nil {
		return x.UseCases
	}
	return nil
}

func (x *Control) GetConditions() []*Condition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

type isControl_Action interface {
	isControl_Action()
}

type Control_BoostAction_ struct {
	// Defines a boost-type control
	BoostAction *Control_BoostAction `protobuf:"bytes,6,opt,name=boost_action,json=boostAction,proto3,oneof"`
}

type Control_FilterAction_ struct {
	// Defines a filter-type control
	// Currently not supported by Recommendation
	FilterAction *Control_FilterAction `protobuf:"bytes,7,opt,name=filter_action,json=filterAction,proto3,oneof"`
}

type Control_RedirectAction_ struct {
	// Defines a redirect-type control.
	RedirectAction *Control_RedirectAction `protobuf:"bytes,9,opt,name=redirect_action,json=redirectAction,proto3,oneof"`
}

type Control_SynonymsAction_ struct {
	// Treats a group of terms as synonyms of one another.
	SynonymsAction *Control_SynonymsAction `protobuf:"bytes,10,opt,name=synonyms_action,json=synonymsAction,proto3,oneof"`
}

func (*Control_BoostAction_) isControl_Action() {}

func (*Control_FilterAction_) isControl_Action() {}

func (*Control_RedirectAction_) isControl_Action() {}

func (*Control_SynonymsAction_) isControl_Action() {}

// Matcher for search request query
type Condition_QueryTerm struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The specific query value to match against
	//
	// Must be lowercase, must be UTF-8.
	// Can have at most 3 space separated terms if full_match is true.
	// Cannot be an empty string.
	// Maximum length of 5000 characters.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Whether the search query needs to exactly match the query term.
	FullMatch bool `protobuf:"varint,2,opt,name=full_match,json=fullMatch,proto3" json:"full_match,omitempty"`
}

func (x *Condition_QueryTerm) Reset() {
	*x = Condition_QueryTerm{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Condition_QueryTerm) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Condition_QueryTerm) ProtoMessage() {}

func (x *Condition_QueryTerm) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Condition_QueryTerm.ProtoReflect.Descriptor instead.
func (*Condition_QueryTerm) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_control_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Condition_QueryTerm) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *Condition_QueryTerm) GetFullMatch() bool {
	if x != nil {
		return x.FullMatch
	}
	return false
}

// Used for time-dependent conditions.
type Condition_TimeRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start of time range.
	//
	// Range is inclusive.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End of time range.
	//
	// Range is inclusive.
	// Must be in the future.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *Condition_TimeRange) Reset() {
	*x = Condition_TimeRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Condition_TimeRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Condition_TimeRange) ProtoMessage() {}

func (x *Condition_TimeRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Condition_TimeRange.ProtoReflect.Descriptor instead.
func (*Condition_TimeRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_control_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Condition_TimeRange) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Condition_TimeRange) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Adjusts order of products in returned list.
type Control_BoostAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Strength of the boost, which should be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0 (No-op).
	Boost float32 `protobuf:"fixed32,1,opt,name=boost,proto3" json:"boost,omitempty"`
	// Required. Specifies which products to apply the boost to.
	//
	// If no filter is provided all products will be boosted (No-op).
	// Syntax documentation:
	// https://cloud.google.com/retail/docs/filter-and-order
	// Maximum length is 5000 characters.
	// Otherwise an INVALID ARGUMENT error is thrown.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Required. Specifies which data store's documents can be boosted by this
	// control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/default_data_store
	DataStore string `protobuf:"bytes,3,opt,name=data_store,json=dataStore,proto3" json:"data_store,omitempty"`
}

func (x *Control_BoostAction) Reset() {
	*x = Control_BoostAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Control_BoostAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Control_BoostAction) ProtoMessage() {}

func (x *Control_BoostAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Control_BoostAction.ProtoReflect.Descriptor instead.
func (*Control_BoostAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_control_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Control_BoostAction) GetBoost() float32 {
	if x != nil {
		return x.Boost
	}
	return 0
}

func (x *Control_BoostAction) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *Control_BoostAction) GetDataStore() string {
	if x != nil {
		return x.DataStore
	}
	return ""
}

// Specified which products may be included in results.
// Uses same filter as boost.
type Control_FilterAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A filter to apply on the matching condition results.
	//
	// Required
	// Syntax documentation:
	// https://cloud.google.com/retail/docs/filter-and-order
	// Maximum length is 5000 characters. Otherwise an INVALID
	// ARGUMENT error is thrown.
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// Required. Specifies which data store's documents can be filtered by this
	// control. Full data store name e.g.
	// projects/123/locations/global/collections/default_collection/dataStores/default_data_store
	DataStore string `protobuf:"bytes,2,opt,name=data_store,json=dataStore,proto3" json:"data_store,omitempty"`
}

func (x *Control_FilterAction) Reset() {
	*x = Control_FilterAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Control_FilterAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Control_FilterAction) ProtoMessage() {}

func (x *Control_FilterAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Control_FilterAction.ProtoReflect.Descriptor instead.
func (*Control_FilterAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_control_proto_rawDescGZIP(), []int{1, 1}
}

func (x *Control_FilterAction) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *Control_FilterAction) GetDataStore() string {
	if x != nil {
		return x.DataStore
	}
	return ""
}

// Redirects a shopper to the provided URI.
type Control_RedirectAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The URI to which the shopper will be redirected.
	//
	// Required.
	// URI must have length equal or less than 2000 characters.
	// Otherwise an INVALID ARGUMENT error is thrown.
	RedirectUri string `protobuf:"bytes,1,opt,name=redirect_uri,json=redirectUri,proto3" json:"redirect_uri,omitempty"`
}

func (x *Control_RedirectAction) Reset() {
	*x = Control_RedirectAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Control_RedirectAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Control_RedirectAction) ProtoMessage() {}

func (x *Control_RedirectAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Control_RedirectAction.ProtoReflect.Descriptor instead.
func (*Control_RedirectAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_control_proto_rawDescGZIP(), []int{1, 2}
}

func (x *Control_RedirectAction) GetRedirectUri() string {
	if x != nil {
		return x.RedirectUri
	}
	return ""
}

// Creates a set of terms that will act as synonyms of one another.
//
// Example: "happy" will also be considered as "glad", "glad" will also be
// considered as "happy".
type Control_SynonymsAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines a set of synonyms.
	// Can specify up to 100 synonyms.
	// Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
	// thrown.
	Synonyms []string `protobuf:"bytes,1,rep,name=synonyms,proto3" json:"synonyms,omitempty"`
}

func (x *Control_SynonymsAction) Reset() {
	*x = Control_SynonymsAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Control_SynonymsAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Control_SynonymsAction) ProtoMessage() {}

func (x *Control_SynonymsAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Control_SynonymsAction.ProtoReflect.Descriptor instead.
func (*Control_SynonymsAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_control_proto_rawDescGZIP(), []int{1, 3}
}

func (x *Control_SynonymsAction) GetSynonyms() []string {
	if x != nil {
		return x.Synonyms
	}
	return nil
}

var File_google_cloud_discoveryengine_v1beta_control_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1beta_control_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8d, 0x03, 0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74,
	0x65, 0x72, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x54, 0x65, 0x72, 0x6d, 0x52, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x54, 0x65, 0x72, 0x6d, 0x73,
	0x12, 0x64, 0x0a, 0x11, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x1a, 0x40, 0x0a, 0x09, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54,
	0x65, 0x72, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x75, 0x6c,
	0x6c, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x66,
	0x75, 0x6c, 0x6c, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x1a, 0x7d, 0x0a, 0x09, 0x54, 0x69, 0x6d, 0x65,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x83, 0x0c, 0x0a, 0x07, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x12, 0x5d, 0x0a, 0x0c, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0b, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x60, 0x0a, 0x0d, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x66, 0x0a, 0x0f, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x52, 0x65, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x72, 0x65,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x66, 0x0a, 0x0f,
	0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x2e, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x1d, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x1a, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x73, 0x12, 0x5e, 0x0a,
	0x0d, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52,
	0x0c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4f, 0x0a,
	0x09, 0x75, 0x73, 0x65, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x55, 0x73, 0x65,
	0x43, 0x61, 0x73, 0x65, 0x52, 0x08, 0x75, 0x73, 0x65, 0x43, 0x61, 0x73, 0x65, 0x73, 0x12, 0x4e,
	0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x96,
	0x01, 0x0a, 0x0b, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19,
	0x0a, 0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x4f, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2a, 0x0a, 0x28, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x09, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x1a, 0x7c, 0x0a, 0x0c, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x4f, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x0a, 0x28, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x1a, 0x38, 0x0a, 0x0e, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x72, 0x65, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x55, 0x72, 0x69, 0x1a,
	0x2c, 0x0a, 0x0e, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x08, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x3a, 0xd3, 0x02,
	0xea, 0x41, 0xcf, 0x02, 0x0a, 0x26, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x52, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73,
	0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x2f, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x7d,
	0x12, 0x6b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x7d, 0x12, 0x64, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x7d,
	0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x7d, 0x42, 0x08, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x93, 0x02,
	0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0c, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x51, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x0f, 0x44,
	0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0xaa, 0x02,
	0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31,
	0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1beta_control_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1beta_control_proto_rawDescData = file_google_cloud_discoveryengine_v1beta_control_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1beta_control_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1beta_control_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1beta_control_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1beta_control_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1beta_control_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_discoveryengine_v1beta_control_proto_goTypes = []interface{}{
	(*Condition)(nil),              // 0: google.cloud.discoveryengine.v1beta.Condition
	(*Control)(nil),                // 1: google.cloud.discoveryengine.v1beta.Control
	(*Condition_QueryTerm)(nil),    // 2: google.cloud.discoveryengine.v1beta.Condition.QueryTerm
	(*Condition_TimeRange)(nil),    // 3: google.cloud.discoveryengine.v1beta.Condition.TimeRange
	(*Control_BoostAction)(nil),    // 4: google.cloud.discoveryengine.v1beta.Control.BoostAction
	(*Control_FilterAction)(nil),   // 5: google.cloud.discoveryengine.v1beta.Control.FilterAction
	(*Control_RedirectAction)(nil), // 6: google.cloud.discoveryengine.v1beta.Control.RedirectAction
	(*Control_SynonymsAction)(nil), // 7: google.cloud.discoveryengine.v1beta.Control.SynonymsAction
	(SolutionType)(0),              // 8: google.cloud.discoveryengine.v1beta.SolutionType
	(SearchUseCase)(0),             // 9: google.cloud.discoveryengine.v1beta.SearchUseCase
	(*timestamppb.Timestamp)(nil),  // 10: google.protobuf.Timestamp
}
var file_google_cloud_discoveryengine_v1beta_control_proto_depIdxs = []int32{
	2,  // 0: google.cloud.discoveryengine.v1beta.Condition.query_terms:type_name -> google.cloud.discoveryengine.v1beta.Condition.QueryTerm
	3,  // 1: google.cloud.discoveryengine.v1beta.Condition.active_time_range:type_name -> google.cloud.discoveryengine.v1beta.Condition.TimeRange
	4,  // 2: google.cloud.discoveryengine.v1beta.Control.boost_action:type_name -> google.cloud.discoveryengine.v1beta.Control.BoostAction
	5,  // 3: google.cloud.discoveryengine.v1beta.Control.filter_action:type_name -> google.cloud.discoveryengine.v1beta.Control.FilterAction
	6,  // 4: google.cloud.discoveryengine.v1beta.Control.redirect_action:type_name -> google.cloud.discoveryengine.v1beta.Control.RedirectAction
	7,  // 5: google.cloud.discoveryengine.v1beta.Control.synonyms_action:type_name -> google.cloud.discoveryengine.v1beta.Control.SynonymsAction
	8,  // 6: google.cloud.discoveryengine.v1beta.Control.solution_type:type_name -> google.cloud.discoveryengine.v1beta.SolutionType
	9,  // 7: google.cloud.discoveryengine.v1beta.Control.use_cases:type_name -> google.cloud.discoveryengine.v1beta.SearchUseCase
	0,  // 8: google.cloud.discoveryengine.v1beta.Control.conditions:type_name -> google.cloud.discoveryengine.v1beta.Condition
	10, // 9: google.cloud.discoveryengine.v1beta.Condition.TimeRange.start_time:type_name -> google.protobuf.Timestamp
	10, // 10: google.cloud.discoveryengine.v1beta.Condition.TimeRange.end_time:type_name -> google.protobuf.Timestamp
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1beta_control_proto_init() }
func file_google_cloud_discoveryengine_v1beta_control_proto_init() {
	if File_google_cloud_discoveryengine_v1beta_control_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1beta_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Condition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Control); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Condition_QueryTerm); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Condition_TimeRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Control_BoostAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Control_FilterAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Control_RedirectAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Control_SynonymsAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*Control_BoostAction_)(nil),
		(*Control_FilterAction_)(nil),
		(*Control_RedirectAction_)(nil),
		(*Control_SynonymsAction_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1beta_control_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1beta_control_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1beta_control_proto_depIdxs,
		MessageInfos:      file_google_cloud_discoveryengine_v1beta_control_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1beta_control_proto = out.File
	file_google_cloud_discoveryengine_v1beta_control_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1beta_control_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1beta_control_proto_depIdxs = nil
}
