// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/oslogin/v1beta/oslogin.proto

package osloginpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	commonpb "cloud.google.com/go/oslogin/common/commonpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The login profile view limits the user content retrieved.
type LoginProfileView int32

const (
	// The default login profile view. The API defaults to the BASIC view.
	LoginProfileView_LOGIN_PROFILE_VIEW_UNSPECIFIED LoginProfileView = 0
	// Includes POSIX and SSH key information.
	LoginProfileView_BASIC LoginProfileView = 1
	// Include security key information for the user.
	LoginProfileView_SECURITY_KEY LoginProfileView = 2
)

// Enum value maps for LoginProfileView.
var (
	LoginProfileView_name = map[int32]string{
		0: "LOGIN_PROFILE_VIEW_UNSPECIFIED",
		1: "BASIC",
		2: "SECURITY_KEY",
	}
	LoginProfileView_value = map[string]int32{
		"LOGIN_PROFILE_VIEW_UNSPECIFIED": 0,
		"BASIC":                          1,
		"SECURITY_KEY":                   2,
	}
)

func (x LoginProfileView) Enum() *LoginProfileView {
	p := new(LoginProfileView)
	*p = x
	return p
}

func (x LoginProfileView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoginProfileView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oslogin_v1beta_oslogin_proto_enumTypes[0].Descriptor()
}

func (LoginProfileView) Type() protoreflect.EnumType {
	return &file_google_cloud_oslogin_v1beta_oslogin_proto_enumTypes[0]
}

func (x LoginProfileView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoginProfileView.Descriptor instead.
func (LoginProfileView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescGZIP(), []int{0}
}

// The user profile information used for logging in to a virtual machine on
// Google Compute Engine.
type LoginProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A unique user ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The list of POSIX accounts associated with the user.
	PosixAccounts []*commonpb.PosixAccount `protobuf:"bytes,2,rep,name=posix_accounts,json=posixAccounts,proto3" json:"posix_accounts,omitempty"`
	// A map from SSH public key fingerprint to the associated key object.
	SshPublicKeys map[string]*commonpb.SshPublicKey `protobuf:"bytes,3,rep,name=ssh_public_keys,json=sshPublicKeys,proto3" json:"ssh_public_keys,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The registered security key credentials for a user.
	SecurityKeys []*SecurityKey `protobuf:"bytes,5,rep,name=security_keys,json=securityKeys,proto3" json:"security_keys,omitempty"`
}

func (x *LoginProfile) Reset() {
	*x = LoginProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoginProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginProfile) ProtoMessage() {}

func (x *LoginProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginProfile.ProtoReflect.Descriptor instead.
func (*LoginProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescGZIP(), []int{0}
}

func (x *LoginProfile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LoginProfile) GetPosixAccounts() []*commonpb.PosixAccount {
	if x != nil {
		return x.PosixAccounts
	}
	return nil
}

func (x *LoginProfile) GetSshPublicKeys() map[string]*commonpb.SshPublicKey {
	if x != nil {
		return x.SshPublicKeys
	}
	return nil
}

func (x *LoginProfile) GetSecurityKeys() []*SecurityKey {
	if x != nil {
		return x.SecurityKeys
	}
	return nil
}

// A request message for creating an SSH public key.
type CreateSshPublicKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique ID for the user in format `users/{user}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The SSH public key and expiration time.
	SshPublicKey *commonpb.SshPublicKey `protobuf:"bytes,2,opt,name=ssh_public_key,json=sshPublicKey,proto3" json:"ssh_public_key,omitempty"`
}

func (x *CreateSshPublicKeyRequest) Reset() {
	*x = CreateSshPublicKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSshPublicKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSshPublicKeyRequest) ProtoMessage() {}

func (x *CreateSshPublicKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSshPublicKeyRequest.ProtoReflect.Descriptor instead.
func (*CreateSshPublicKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescGZIP(), []int{1}
}

func (x *CreateSshPublicKeyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSshPublicKeyRequest) GetSshPublicKey() *commonpb.SshPublicKey {
	if x != nil {
		return x.SshPublicKey
	}
	return nil
}

// A request message for deleting a POSIX account entry.
type DeletePosixAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A reference to the POSIX account to update. POSIX accounts are
	// identified by the project ID they are associated with. A reference to the
	// POSIX account is in format `users/{user}/projects/{project}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeletePosixAccountRequest) Reset() {
	*x = DeletePosixAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePosixAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePosixAccountRequest) ProtoMessage() {}

func (x *DeletePosixAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePosixAccountRequest.ProtoReflect.Descriptor instead.
func (*DeletePosixAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescGZIP(), []int{2}
}

func (x *DeletePosixAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request message for deleting an SSH public key.
type DeleteSshPublicKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The fingerprint of the public key to update. Public keys are
	// identified by their SHA-256 fingerprint. The fingerprint of the public key
	// is in format `users/{user}/sshPublicKeys/{fingerprint}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSshPublicKeyRequest) Reset() {
	*x = DeleteSshPublicKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSshPublicKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSshPublicKeyRequest) ProtoMessage() {}

func (x *DeleteSshPublicKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSshPublicKeyRequest.ProtoReflect.Descriptor instead.
func (*DeleteSshPublicKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteSshPublicKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request message for retrieving the login profile information for a user.
type GetLoginProfileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique ID for the user in format `users/{user}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The project ID of the Google Cloud Platform project.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// A system ID for filtering the results of the request.
	SystemId string `protobuf:"bytes,3,opt,name=system_id,json=systemId,proto3" json:"system_id,omitempty"`
	// The view configures whether to retrieve security keys information.
	View LoginProfileView `protobuf:"varint,4,opt,name=view,proto3,enum=google.cloud.oslogin.v1beta.LoginProfileView" json:"view,omitempty"`
}

func (x *GetLoginProfileRequest) Reset() {
	*x = GetLoginProfileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLoginProfileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLoginProfileRequest) ProtoMessage() {}

func (x *GetLoginProfileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLoginProfileRequest.ProtoReflect.Descriptor instead.
func (*GetLoginProfileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescGZIP(), []int{4}
}

func (x *GetLoginProfileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetLoginProfileRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetLoginProfileRequest) GetSystemId() string {
	if x != nil {
		return x.SystemId
	}
	return ""
}

func (x *GetLoginProfileRequest) GetView() LoginProfileView {
	if x != nil {
		return x.View
	}
	return LoginProfileView_LOGIN_PROFILE_VIEW_UNSPECIFIED
}

// A request message for retrieving an SSH public key.
type GetSshPublicKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The fingerprint of the public key to retrieve. Public keys are
	// identified by their SHA-256 fingerprint. The fingerprint of the public key
	// is in format `users/{user}/sshPublicKeys/{fingerprint}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSshPublicKeyRequest) Reset() {
	*x = GetSshPublicKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSshPublicKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSshPublicKeyRequest) ProtoMessage() {}

func (x *GetSshPublicKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSshPublicKeyRequest.ProtoReflect.Descriptor instead.
func (*GetSshPublicKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescGZIP(), []int{5}
}

func (x *GetSshPublicKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request message for importing an SSH public key.
type ImportSshPublicKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique ID for the user in format `users/{user}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The SSH public key and expiration time.
	SshPublicKey *commonpb.SshPublicKey `protobuf:"bytes,2,opt,name=ssh_public_key,json=sshPublicKey,proto3" json:"ssh_public_key,omitempty"`
	// The project ID of the Google Cloud Platform project.
	ProjectId string `protobuf:"bytes,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The view configures whether to retrieve security keys information.
	View LoginProfileView `protobuf:"varint,4,opt,name=view,proto3,enum=google.cloud.oslogin.v1beta.LoginProfileView" json:"view,omitempty"`
	// Optional. The regions to which to assert that the key was written.
	// If unspecified, defaults to all regions.
	// Regions are listed at https://cloud.google.com/about/locations#region.
	Regions []string `protobuf:"bytes,5,rep,name=regions,proto3" json:"regions,omitempty"`
}

func (x *ImportSshPublicKeyRequest) Reset() {
	*x = ImportSshPublicKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportSshPublicKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportSshPublicKeyRequest) ProtoMessage() {}

func (x *ImportSshPublicKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportSshPublicKeyRequest.ProtoReflect.Descriptor instead.
func (*ImportSshPublicKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescGZIP(), []int{6}
}

func (x *ImportSshPublicKeyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ImportSshPublicKeyRequest) GetSshPublicKey() *commonpb.SshPublicKey {
	if x != nil {
		return x.SshPublicKey
	}
	return nil
}

func (x *ImportSshPublicKeyRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ImportSshPublicKeyRequest) GetView() LoginProfileView {
	if x != nil {
		return x.View
	}
	return LoginProfileView_LOGIN_PROFILE_VIEW_UNSPECIFIED
}

func (x *ImportSshPublicKeyRequest) GetRegions() []string {
	if x != nil {
		return x.Regions
	}
	return nil
}

// A response message for importing an SSH public key.
type ImportSshPublicKeyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The login profile information for the user.
	LoginProfile *LoginProfile `protobuf:"bytes,1,opt,name=login_profile,json=loginProfile,proto3" json:"login_profile,omitempty"`
	// Detailed information about import results.
	Details string `protobuf:"bytes,2,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *ImportSshPublicKeyResponse) Reset() {
	*x = ImportSshPublicKeyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportSshPublicKeyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportSshPublicKeyResponse) ProtoMessage() {}

func (x *ImportSshPublicKeyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportSshPublicKeyResponse.ProtoReflect.Descriptor instead.
func (*ImportSshPublicKeyResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescGZIP(), []int{7}
}

func (x *ImportSshPublicKeyResponse) GetLoginProfile() *LoginProfile {
	if x != nil {
		return x.LoginProfile
	}
	return nil
}

func (x *ImportSshPublicKeyResponse) GetDetails() string {
	if x != nil {
		return x.Details
	}
	return ""
}

// A request message for updating an SSH public key.
type UpdateSshPublicKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The fingerprint of the public key to update. Public keys are
	// identified by their SHA-256 fingerprint. The fingerprint of the public key
	// is in format `users/{user}/sshPublicKeys/{fingerprint}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The SSH public key and expiration time.
	SshPublicKey *commonpb.SshPublicKey `protobuf:"bytes,2,opt,name=ssh_public_key,json=sshPublicKey,proto3" json:"ssh_public_key,omitempty"`
	// Mask to control which fields get updated. Updates all if not present.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSshPublicKeyRequest) Reset() {
	*x = UpdateSshPublicKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSshPublicKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSshPublicKeyRequest) ProtoMessage() {}

func (x *UpdateSshPublicKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSshPublicKeyRequest.ProtoReflect.Descriptor instead.
func (*UpdateSshPublicKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateSshPublicKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateSshPublicKeyRequest) GetSshPublicKey() *commonpb.SshPublicKey {
	if x != nil {
		return x.SshPublicKey
	}
	return nil
}

func (x *UpdateSshPublicKeyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The credential information for a Google registered security key.
type SecurityKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Public key text in SSH format, defined by
	// [RFC4253]("https://www.ietf.org/rfc/rfc4253.txt") section 6.6.
	PublicKey string `protobuf:"bytes,1,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Hardware-backed private key text in SSH format.
	PrivateKey string `protobuf:"bytes,2,opt,name=private_key,json=privateKey,proto3" json:"private_key,omitempty"`
	// The FIDO protocol type used to register this credential.
	//
	// Types that are assignable to ProtocolType:
	//
	//	*SecurityKey_UniversalTwoFactor
	//	*SecurityKey_WebAuthn
	ProtocolType isSecurityKey_ProtocolType `protobuf_oneof:"protocol_type"`
	// The security key nickname explicitly set by the user.
	DeviceNickname *string `protobuf:"bytes,5,opt,name=device_nickname,json=deviceNickname,proto3,oneof" json:"device_nickname,omitempty"`
}

func (x *SecurityKey) Reset() {
	*x = SecurityKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecurityKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityKey) ProtoMessage() {}

func (x *SecurityKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityKey.ProtoReflect.Descriptor instead.
func (*SecurityKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescGZIP(), []int{9}
}

func (x *SecurityKey) GetPublicKey() string {
	if x != nil {
		return x.PublicKey
	}
	return ""
}

func (x *SecurityKey) GetPrivateKey() string {
	if x != nil {
		return x.PrivateKey
	}
	return ""
}

func (m *SecurityKey) GetProtocolType() isSecurityKey_ProtocolType {
	if m != nil {
		return m.ProtocolType
	}
	return nil
}

func (x *SecurityKey) GetUniversalTwoFactor() *UniversalTwoFactor {
	if x, ok := x.GetProtocolType().(*SecurityKey_UniversalTwoFactor); ok {
		return x.UniversalTwoFactor
	}
	return nil
}

func (x *SecurityKey) GetWebAuthn() *WebAuthn {
	if x, ok := x.GetProtocolType().(*SecurityKey_WebAuthn); ok {
		return x.WebAuthn
	}
	return nil
}

func (x *SecurityKey) GetDeviceNickname() string {
	if x != nil && x.DeviceNickname != nil {
		return *x.DeviceNickname
	}
	return ""
}

type isSecurityKey_ProtocolType interface {
	isSecurityKey_ProtocolType()
}

type SecurityKey_UniversalTwoFactor struct {
	// The U2F protocol type.
	UniversalTwoFactor *UniversalTwoFactor `protobuf:"bytes,3,opt,name=universal_two_factor,json=universalTwoFactor,proto3,oneof"`
}

type SecurityKey_WebAuthn struct {
	// The Web Authentication protocol type.
	WebAuthn *WebAuthn `protobuf:"bytes,4,opt,name=web_authn,json=webAuthn,proto3,oneof"`
}

func (*SecurityKey_UniversalTwoFactor) isSecurityKey_ProtocolType() {}

func (*SecurityKey_WebAuthn) isSecurityKey_ProtocolType() {}

// Security key information specific to the U2F protocol.
type UniversalTwoFactor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Application ID for the U2F protocol.
	AppId string `protobuf:"bytes,1,opt,name=app_id,json=appId,proto3" json:"app_id,omitempty"`
}

func (x *UniversalTwoFactor) Reset() {
	*x = UniversalTwoFactor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UniversalTwoFactor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UniversalTwoFactor) ProtoMessage() {}

func (x *UniversalTwoFactor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UniversalTwoFactor.ProtoReflect.Descriptor instead.
func (*UniversalTwoFactor) Descriptor() ([]byte, []int) {
	return file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescGZIP(), []int{10}
}

func (x *UniversalTwoFactor) GetAppId() string {
	if x != nil {
		return x.AppId
	}
	return ""
}

// Security key information specific to the Web Authentication protocol.
type WebAuthn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Relying party ID for Web Authentication.
	RpId string `protobuf:"bytes,1,opt,name=rp_id,json=rpId,proto3" json:"rp_id,omitempty"`
}

func (x *WebAuthn) Reset() {
	*x = WebAuthn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebAuthn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebAuthn) ProtoMessage() {}

func (x *WebAuthn) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebAuthn.ProtoReflect.Descriptor instead.
func (*WebAuthn) Descriptor() ([]byte, []int) {
	return file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescGZIP(), []int{11}
}

func (x *WebAuthn) GetRpId() string {
	if x != nil {
		return x.RpId
	}
	return ""
}

type SignSshPublicKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SSH public key to sign.
	SshPublicKey string `protobuf:"bytes,1,opt,name=ssh_public_key,json=sshPublicKey,proto3" json:"ssh_public_key,omitempty"`
	// The parent project and zone for the signing request. This is needed to
	// properly ensure per-organization ISS processing and potentially to provide
	// for the possibility of zone-specific certificates used in the signing
	// process.
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *SignSshPublicKeyRequest) Reset() {
	*x = SignSshPublicKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignSshPublicKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignSshPublicKeyRequest) ProtoMessage() {}

func (x *SignSshPublicKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignSshPublicKeyRequest.ProtoReflect.Descriptor instead.
func (*SignSshPublicKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescGZIP(), []int{12}
}

func (x *SignSshPublicKeyRequest) GetSshPublicKey() string {
	if x != nil {
		return x.SshPublicKey
	}
	return ""
}

func (x *SignSshPublicKeyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

type SignSshPublicKeyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The signed SSH public key to use in the SSH handshake.
	SignedSshPublicKey string `protobuf:"bytes,1,opt,name=signed_ssh_public_key,json=signedSshPublicKey,proto3" json:"signed_ssh_public_key,omitempty"`
}

func (x *SignSshPublicKeyResponse) Reset() {
	*x = SignSshPublicKeyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignSshPublicKeyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignSshPublicKeyResponse) ProtoMessage() {}

func (x *SignSshPublicKeyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignSshPublicKeyResponse.ProtoReflect.Descriptor instead.
func (*SignSshPublicKeyResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescGZIP(), []int{13}
}

func (x *SignSshPublicKeyResponse) GetSignedSshPublicKey() string {
	if x != nil {
		return x.SignedSshPublicKey
	}
	return ""
}

var File_google_cloud_oslogin_v1beta_oslogin_proto protoreflect.FileDescriptor

var file_google_cloud_oslogin_v1beta_oslogin_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x6f, 0x73,
	0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69,
	0x6e, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9b, 0x03, 0x0a, 0x0c, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x50,
	0x0a, 0x0e, 0x70, 0x6f, 0x73, 0x69, 0x78, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x6f, 0x73, 0x69, 0x78, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x52, 0x0d, 0x70, 0x6f, 0x73, 0x69, 0x78, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x12, 0x64, 0x0a, 0x0f, 0x73, 0x73, 0x68, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b,
	0x65, 0x79, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x2e, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65,
	0x79, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x73, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x4d, 0x0a, 0x0d, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c,
	0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x4b, 0x65, 0x79, 0x52, 0x0c, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x4b, 0x65, 0x79, 0x73, 0x1a, 0x6b, 0x0a, 0x12, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3f, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f,
	0x67, 0x69, 0x6e, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x53, 0x73, 0x68, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xb6, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x73, 0x68,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x54, 0x0a, 0x0e, 0x73, 0x73, 0x68, 0x5f, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c,
	0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x53, 0x73, 0x68, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73,
	0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x22, 0x5c, 0x0a, 0x19, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f, 0x73, 0x69, 0x78, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23,
	0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x73, 0x69, 0x78, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5c, 0x0a, 0x19, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x6f, 0x73,
	0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65,
	0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd0, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x4c,
	0x6f, 0x67, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x37, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x55, 0x73, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x12, 0x41, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x59, 0x0a, 0x16, 0x47, 0x65,
	0x74, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x6f, 0x73, 0x6c, 0x6f,
	0x67, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb4, 0x02, 0x0a, 0x19, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x28, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x54, 0x0a, 0x0e, 0x73, 0x73, 0x68, 0x5f, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c,
	0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x53, 0x73, 0x68, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73,
	0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x41, 0x0a, 0x04, 0x76, 0x69,
	0x65, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x1d, 0x0a,
	0x07, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x07, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x86, 0x01, 0x0a,
	0x1a, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x4b, 0x65, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x0d, 0x6c,
	0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x0c, 0x6c,
	0x6f, 0x67, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xef, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x6f, 0x73, 0x6c, 0x6f, 0x67,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x0e, 0x73, 0x73, 0x68, 0x5f, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f,
	0x67, 0x69, 0x6e, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x53, 0x73, 0x68, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x73,
	0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xcb, 0x02, 0x0a, 0x0b, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x4b, 0x65, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x63, 0x0a, 0x14, 0x75, 0x6e, 0x69, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x6c, 0x5f, 0x74, 0x77, 0x6f, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x55, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x61, 0x6c, 0x54, 0x77, 0x6f,
	0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x12, 0x75, 0x6e, 0x69, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x6c, 0x54, 0x77, 0x6f, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x44, 0x0a, 0x09,
	0x77, 0x65, 0x62, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x65,
	0x62, 0x41, 0x75, 0x74, 0x68, 0x6e, 0x48, 0x00, 0x52, 0x08, 0x77, 0x65, 0x62, 0x41, 0x75, 0x74,
	0x68, 0x6e, 0x12, 0x2c, 0x0a, 0x0f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x69, 0x63,
	0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0e, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x69, 0x63, 0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01,
	0x42, 0x0f, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x69, 0x63,
	0x6b, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x2b, 0x0a, 0x12, 0x55, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x6c, 0x54, 0x77, 0x6f, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x15, 0x0a, 0x06, 0x61,
	0x70, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x61, 0x70, 0x70,
	0x49, 0x64, 0x22, 0x1f, 0x0a, 0x08, 0x57, 0x65, 0x62, 0x41, 0x75, 0x74, 0x68, 0x6e, 0x12, 0x13,
	0x0a, 0x05, 0x72, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72,
	0x70, 0x49, 0x64, 0x22, 0x57, 0x0a, 0x17, 0x53, 0x69, 0x67, 0x6e, 0x53, 0x73, 0x68, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24,
	0x0a, 0x0e, 0x73, 0x73, 0x68, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x4b, 0x65, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x4d, 0x0a, 0x18,
	0x53, 0x69, 0x67, 0x6e, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x15, 0x73, 0x69, 0x67, 0x6e,
	0x65, 0x64, 0x5f, 0x73, 0x73, 0x68, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x53,
	0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x2a, 0x53, 0x0a, 0x10, 0x4c,
	0x6f, 0x67, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12,
	0x22, 0x0a, 0x1e, 0x4c, 0x4f, 0x47, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45,
	0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x10,
	0x0a, 0x0c, 0x53, 0x45, 0x43, 0x55, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x02,
	0x32, 0xf2, 0x0e, 0x0a, 0x0e, 0x4f, 0x73, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0xcf, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x73,
	0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53,
	0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x22, 0x56, 0xda,
	0x41, 0x15, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x73, 0x68, 0x5f, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x3a, 0x0e, 0x73,
	0x73, 0x68, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x22, 0x26, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x75,
	0x73, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x96, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x50, 0x6f, 0x73, 0x69, 0x78, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f,
	0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x50, 0x6f, 0x73, 0x69, 0x78, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x30, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x2a, 0x21, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x75, 0x73, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9b,
	0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x35, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x28, 0x2a, 0x26, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x73, 0x68, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa5, 0x01, 0x0a,
	0x0f, 0x47, 0x65, 0x74, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47,
	0x65, 0x74, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x22, 0x32, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x12,
	0x23, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x75,
	0x73, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x12, 0xa8, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x53, 0x73, 0x68, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c,
	0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x53, 0x73, 0x68, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x22, 0x35, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x28, 0x12, 0x26, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0x85, 0x02, 0x0a, 0x12, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x73, 0x68, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7e, 0xda, 0x41, 0x15, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x73, 0x73, 0x68, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65,
	0x79, 0xda, 0x41, 0x20, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x73, 0x68, 0x5f, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x2c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x0e, 0x73, 0x73, 0x68, 0x5f,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x75, 0x73, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x73, 0x68, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0xef, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65,
	0x79, 0x22, 0x76, 0xda, 0x41, 0x13, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x73, 0x73, 0x68, 0x5f, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0xda, 0x41, 0x1f, 0x6e, 0x61, 0x6d, 0x65,
	0x2c, 0x73, 0x73, 0x68, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x38, 0x3a, 0x0e, 0x73, 0x73, 0x68, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65,
	0x79, 0x32, 0x26, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa9, 0x02, 0x0a, 0x10, 0x53, 0x69,
	0x67, 0x6e, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x69, 0x67,
	0x6e, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x4b, 0x65, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa7, 0x01, 0xda, 0x41,
	0x15, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x73, 0x68, 0x5f, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x88, 0x01, 0x3a, 0x01, 0x2a,
	0x5a, 0x45, 0x3a, 0x01, 0x2a, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x69, 0x67, 0x6e, 0x53, 0x73, 0x68, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x7a, 0x6f, 0x6e, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x69, 0x67, 0x6e, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x4b, 0x65, 0x79, 0x1a, 0xdd, 0x01, 0xca, 0x41, 0x16, 0x6f, 0x73, 0x6c, 0x6f, 0x67,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0xc0, 0x01, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x72, 0x65, 0x61,
	0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x42, 0xc9, 0x01, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x6c, 0x6f, 0x67,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0c, 0x4f, 0x73, 0x4c, 0x6f, 0x67,
	0x69, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x39, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6f,
	0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x6f, 0x73, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x70, 0x62, 0x3b, 0x6f, 0x73, 0x6c, 0x6f, 0x67,
	0x69, 0x6e, 0x70, 0x62, 0xaa, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x4f, 0x73, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x2e, 0x56, 0x31, 0x42, 0x65,
	0x74, 0x61, 0xca, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x4f, 0x73, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0xea, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x4f, 0x73, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescOnce sync.Once
	file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescData = file_google_cloud_oslogin_v1beta_oslogin_proto_rawDesc
)

func file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescGZIP() []byte {
	file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescOnce.Do(func() {
		file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescData)
	})
	return file_google_cloud_oslogin_v1beta_oslogin_proto_rawDescData
}

var file_google_cloud_oslogin_v1beta_oslogin_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_cloud_oslogin_v1beta_oslogin_proto_goTypes = []interface{}{
	(LoginProfileView)(0),              // 0: google.cloud.oslogin.v1beta.LoginProfileView
	(*LoginProfile)(nil),               // 1: google.cloud.oslogin.v1beta.LoginProfile
	(*CreateSshPublicKeyRequest)(nil),  // 2: google.cloud.oslogin.v1beta.CreateSshPublicKeyRequest
	(*DeletePosixAccountRequest)(nil),  // 3: google.cloud.oslogin.v1beta.DeletePosixAccountRequest
	(*DeleteSshPublicKeyRequest)(nil),  // 4: google.cloud.oslogin.v1beta.DeleteSshPublicKeyRequest
	(*GetLoginProfileRequest)(nil),     // 5: google.cloud.oslogin.v1beta.GetLoginProfileRequest
	(*GetSshPublicKeyRequest)(nil),     // 6: google.cloud.oslogin.v1beta.GetSshPublicKeyRequest
	(*ImportSshPublicKeyRequest)(nil),  // 7: google.cloud.oslogin.v1beta.ImportSshPublicKeyRequest
	(*ImportSshPublicKeyResponse)(nil), // 8: google.cloud.oslogin.v1beta.ImportSshPublicKeyResponse
	(*UpdateSshPublicKeyRequest)(nil),  // 9: google.cloud.oslogin.v1beta.UpdateSshPublicKeyRequest
	(*SecurityKey)(nil),                // 10: google.cloud.oslogin.v1beta.SecurityKey
	(*UniversalTwoFactor)(nil),         // 11: google.cloud.oslogin.v1beta.UniversalTwoFactor
	(*WebAuthn)(nil),                   // 12: google.cloud.oslogin.v1beta.WebAuthn
	(*SignSshPublicKeyRequest)(nil),    // 13: google.cloud.oslogin.v1beta.SignSshPublicKeyRequest
	(*SignSshPublicKeyResponse)(nil),   // 14: google.cloud.oslogin.v1beta.SignSshPublicKeyResponse
	nil,                                // 15: google.cloud.oslogin.v1beta.LoginProfile.SshPublicKeysEntry
	(*commonpb.PosixAccount)(nil),      // 16: google.cloud.oslogin.common.PosixAccount
	(*commonpb.SshPublicKey)(nil),      // 17: google.cloud.oslogin.common.SshPublicKey
	(*fieldmaskpb.FieldMask)(nil),      // 18: google.protobuf.FieldMask
	(*emptypb.Empty)(nil),              // 19: google.protobuf.Empty
}
var file_google_cloud_oslogin_v1beta_oslogin_proto_depIdxs = []int32{
	16, // 0: google.cloud.oslogin.v1beta.LoginProfile.posix_accounts:type_name -> google.cloud.oslogin.common.PosixAccount
	15, // 1: google.cloud.oslogin.v1beta.LoginProfile.ssh_public_keys:type_name -> google.cloud.oslogin.v1beta.LoginProfile.SshPublicKeysEntry
	10, // 2: google.cloud.oslogin.v1beta.LoginProfile.security_keys:type_name -> google.cloud.oslogin.v1beta.SecurityKey
	17, // 3: google.cloud.oslogin.v1beta.CreateSshPublicKeyRequest.ssh_public_key:type_name -> google.cloud.oslogin.common.SshPublicKey
	0,  // 4: google.cloud.oslogin.v1beta.GetLoginProfileRequest.view:type_name -> google.cloud.oslogin.v1beta.LoginProfileView
	17, // 5: google.cloud.oslogin.v1beta.ImportSshPublicKeyRequest.ssh_public_key:type_name -> google.cloud.oslogin.common.SshPublicKey
	0,  // 6: google.cloud.oslogin.v1beta.ImportSshPublicKeyRequest.view:type_name -> google.cloud.oslogin.v1beta.LoginProfileView
	1,  // 7: google.cloud.oslogin.v1beta.ImportSshPublicKeyResponse.login_profile:type_name -> google.cloud.oslogin.v1beta.LoginProfile
	17, // 8: google.cloud.oslogin.v1beta.UpdateSshPublicKeyRequest.ssh_public_key:type_name -> google.cloud.oslogin.common.SshPublicKey
	18, // 9: google.cloud.oslogin.v1beta.UpdateSshPublicKeyRequest.update_mask:type_name -> google.protobuf.FieldMask
	11, // 10: google.cloud.oslogin.v1beta.SecurityKey.universal_two_factor:type_name -> google.cloud.oslogin.v1beta.UniversalTwoFactor
	12, // 11: google.cloud.oslogin.v1beta.SecurityKey.web_authn:type_name -> google.cloud.oslogin.v1beta.WebAuthn
	17, // 12: google.cloud.oslogin.v1beta.LoginProfile.SshPublicKeysEntry.value:type_name -> google.cloud.oslogin.common.SshPublicKey
	2,  // 13: google.cloud.oslogin.v1beta.OsLoginService.CreateSshPublicKey:input_type -> google.cloud.oslogin.v1beta.CreateSshPublicKeyRequest
	3,  // 14: google.cloud.oslogin.v1beta.OsLoginService.DeletePosixAccount:input_type -> google.cloud.oslogin.v1beta.DeletePosixAccountRequest
	4,  // 15: google.cloud.oslogin.v1beta.OsLoginService.DeleteSshPublicKey:input_type -> google.cloud.oslogin.v1beta.DeleteSshPublicKeyRequest
	5,  // 16: google.cloud.oslogin.v1beta.OsLoginService.GetLoginProfile:input_type -> google.cloud.oslogin.v1beta.GetLoginProfileRequest
	6,  // 17: google.cloud.oslogin.v1beta.OsLoginService.GetSshPublicKey:input_type -> google.cloud.oslogin.v1beta.GetSshPublicKeyRequest
	7,  // 18: google.cloud.oslogin.v1beta.OsLoginService.ImportSshPublicKey:input_type -> google.cloud.oslogin.v1beta.ImportSshPublicKeyRequest
	9,  // 19: google.cloud.oslogin.v1beta.OsLoginService.UpdateSshPublicKey:input_type -> google.cloud.oslogin.v1beta.UpdateSshPublicKeyRequest
	13, // 20: google.cloud.oslogin.v1beta.OsLoginService.SignSshPublicKey:input_type -> google.cloud.oslogin.v1beta.SignSshPublicKeyRequest
	17, // 21: google.cloud.oslogin.v1beta.OsLoginService.CreateSshPublicKey:output_type -> google.cloud.oslogin.common.SshPublicKey
	19, // 22: google.cloud.oslogin.v1beta.OsLoginService.DeletePosixAccount:output_type -> google.protobuf.Empty
	19, // 23: google.cloud.oslogin.v1beta.OsLoginService.DeleteSshPublicKey:output_type -> google.protobuf.Empty
	1,  // 24: google.cloud.oslogin.v1beta.OsLoginService.GetLoginProfile:output_type -> google.cloud.oslogin.v1beta.LoginProfile
	17, // 25: google.cloud.oslogin.v1beta.OsLoginService.GetSshPublicKey:output_type -> google.cloud.oslogin.common.SshPublicKey
	8,  // 26: google.cloud.oslogin.v1beta.OsLoginService.ImportSshPublicKey:output_type -> google.cloud.oslogin.v1beta.ImportSshPublicKeyResponse
	17, // 27: google.cloud.oslogin.v1beta.OsLoginService.UpdateSshPublicKey:output_type -> google.cloud.oslogin.common.SshPublicKey
	14, // 28: google.cloud.oslogin.v1beta.OsLoginService.SignSshPublicKey:output_type -> google.cloud.oslogin.v1beta.SignSshPublicKeyResponse
	21, // [21:29] is the sub-list for method output_type
	13, // [13:21] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_oslogin_v1beta_oslogin_proto_init() }
func file_google_cloud_oslogin_v1beta_oslogin_proto_init() {
	if File_google_cloud_oslogin_v1beta_oslogin_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoginProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSshPublicKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePosixAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSshPublicKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLoginProfileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSshPublicKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportSshPublicKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportSshPublicKeyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSshPublicKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecurityKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UniversalTwoFactor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WebAuthn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignSshPublicKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignSshPublicKeyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*SecurityKey_UniversalTwoFactor)(nil),
		(*SecurityKey_WebAuthn)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_oslogin_v1beta_oslogin_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_oslogin_v1beta_oslogin_proto_goTypes,
		DependencyIndexes: file_google_cloud_oslogin_v1beta_oslogin_proto_depIdxs,
		EnumInfos:         file_google_cloud_oslogin_v1beta_oslogin_proto_enumTypes,
		MessageInfos:      file_google_cloud_oslogin_v1beta_oslogin_proto_msgTypes,
	}.Build()
	File_google_cloud_oslogin_v1beta_oslogin_proto = out.File
	file_google_cloud_oslogin_v1beta_oslogin_proto_rawDesc = nil
	file_google_cloud_oslogin_v1beta_oslogin_proto_goTypes = nil
	file_google_cloud_oslogin_v1beta_oslogin_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// OsLoginServiceClient is the client API for OsLoginService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type OsLoginServiceClient interface {
	// Create an SSH public key
	CreateSshPublicKey(ctx context.Context, in *CreateSshPublicKeyRequest, opts ...grpc.CallOption) (*commonpb.SshPublicKey, error)
	// Deletes a POSIX account.
	DeletePosixAccount(ctx context.Context, in *DeletePosixAccountRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes an SSH public key.
	DeleteSshPublicKey(ctx context.Context, in *DeleteSshPublicKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Retrieves the profile information used for logging in to a virtual machine
	// on Google Compute Engine.
	GetLoginProfile(ctx context.Context, in *GetLoginProfileRequest, opts ...grpc.CallOption) (*LoginProfile, error)
	// Retrieves an SSH public key.
	GetSshPublicKey(ctx context.Context, in *GetSshPublicKeyRequest, opts ...grpc.CallOption) (*commonpb.SshPublicKey, error)
	// Adds an SSH public key and returns the profile information. Default POSIX
	// account information is set when no username and UID exist as part of the
	// login profile.
	ImportSshPublicKey(ctx context.Context, in *ImportSshPublicKeyRequest, opts ...grpc.CallOption) (*ImportSshPublicKeyResponse, error)
	// Updates an SSH public key and returns the profile information. This method
	// supports patch semantics.
	UpdateSshPublicKey(ctx context.Context, in *UpdateSshPublicKeyRequest, opts ...grpc.CallOption) (*commonpb.SshPublicKey, error)
	// Signs an SSH public key for a user to authenticate to an instance.
	SignSshPublicKey(ctx context.Context, in *SignSshPublicKeyRequest, opts ...grpc.CallOption) (*SignSshPublicKeyResponse, error)
}

type osLoginServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewOsLoginServiceClient(cc grpc.ClientConnInterface) OsLoginServiceClient {
	return &osLoginServiceClient{cc}
}

func (c *osLoginServiceClient) CreateSshPublicKey(ctx context.Context, in *CreateSshPublicKeyRequest, opts ...grpc.CallOption) (*commonpb.SshPublicKey, error) {
	out := new(commonpb.SshPublicKey)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/CreateSshPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) DeletePosixAccount(ctx context.Context, in *DeletePosixAccountRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/DeletePosixAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) DeleteSshPublicKey(ctx context.Context, in *DeleteSshPublicKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/DeleteSshPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) GetLoginProfile(ctx context.Context, in *GetLoginProfileRequest, opts ...grpc.CallOption) (*LoginProfile, error) {
	out := new(LoginProfile)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/GetLoginProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) GetSshPublicKey(ctx context.Context, in *GetSshPublicKeyRequest, opts ...grpc.CallOption) (*commonpb.SshPublicKey, error) {
	out := new(commonpb.SshPublicKey)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/GetSshPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) ImportSshPublicKey(ctx context.Context, in *ImportSshPublicKeyRequest, opts ...grpc.CallOption) (*ImportSshPublicKeyResponse, error) {
	out := new(ImportSshPublicKeyResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/ImportSshPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) UpdateSshPublicKey(ctx context.Context, in *UpdateSshPublicKeyRequest, opts ...grpc.CallOption) (*commonpb.SshPublicKey, error) {
	out := new(commonpb.SshPublicKey)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/UpdateSshPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) SignSshPublicKey(ctx context.Context, in *SignSshPublicKeyRequest, opts ...grpc.CallOption) (*SignSshPublicKeyResponse, error) {
	out := new(SignSshPublicKeyResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/SignSshPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// OsLoginServiceServer is the server API for OsLoginService service.
type OsLoginServiceServer interface {
	// Create an SSH public key
	CreateSshPublicKey(context.Context, *CreateSshPublicKeyRequest) (*commonpb.SshPublicKey, error)
	// Deletes a POSIX account.
	DeletePosixAccount(context.Context, *DeletePosixAccountRequest) (*emptypb.Empty, error)
	// Deletes an SSH public key.
	DeleteSshPublicKey(context.Context, *DeleteSshPublicKeyRequest) (*emptypb.Empty, error)
	// Retrieves the profile information used for logging in to a virtual machine
	// on Google Compute Engine.
	GetLoginProfile(context.Context, *GetLoginProfileRequest) (*LoginProfile, error)
	// Retrieves an SSH public key.
	GetSshPublicKey(context.Context, *GetSshPublicKeyRequest) (*commonpb.SshPublicKey, error)
	// Adds an SSH public key and returns the profile information. Default POSIX
	// account information is set when no username and UID exist as part of the
	// login profile.
	ImportSshPublicKey(context.Context, *ImportSshPublicKeyRequest) (*ImportSshPublicKeyResponse, error)
	// Updates an SSH public key and returns the profile information. This method
	// supports patch semantics.
	UpdateSshPublicKey(context.Context, *UpdateSshPublicKeyRequest) (*commonpb.SshPublicKey, error)
	// Signs an SSH public key for a user to authenticate to an instance.
	SignSshPublicKey(context.Context, *SignSshPublicKeyRequest) (*SignSshPublicKeyResponse, error)
}

// UnimplementedOsLoginServiceServer can be embedded to have forward compatible implementations.
type UnimplementedOsLoginServiceServer struct {
}

func (*UnimplementedOsLoginServiceServer) CreateSshPublicKey(context.Context, *CreateSshPublicKeyRequest) (*commonpb.SshPublicKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSshPublicKey not implemented")
}
func (*UnimplementedOsLoginServiceServer) DeletePosixAccount(context.Context, *DeletePosixAccountRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePosixAccount not implemented")
}
func (*UnimplementedOsLoginServiceServer) DeleteSshPublicKey(context.Context, *DeleteSshPublicKeyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSshPublicKey not implemented")
}
func (*UnimplementedOsLoginServiceServer) GetLoginProfile(context.Context, *GetLoginProfileRequest) (*LoginProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLoginProfile not implemented")
}
func (*UnimplementedOsLoginServiceServer) GetSshPublicKey(context.Context, *GetSshPublicKeyRequest) (*commonpb.SshPublicKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSshPublicKey not implemented")
}
func (*UnimplementedOsLoginServiceServer) ImportSshPublicKey(context.Context, *ImportSshPublicKeyRequest) (*ImportSshPublicKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportSshPublicKey not implemented")
}
func (*UnimplementedOsLoginServiceServer) UpdateSshPublicKey(context.Context, *UpdateSshPublicKeyRequest) (*commonpb.SshPublicKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSshPublicKey not implemented")
}
func (*UnimplementedOsLoginServiceServer) SignSshPublicKey(context.Context, *SignSshPublicKeyRequest) (*SignSshPublicKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SignSshPublicKey not implemented")
}

func RegisterOsLoginServiceServer(s *grpc.Server, srv OsLoginServiceServer) {
	s.RegisterService(&_OsLoginService_serviceDesc, srv)
}

func _OsLoginService_CreateSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).CreateSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/CreateSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).CreateSshPublicKey(ctx, req.(*CreateSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_DeletePosixAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePosixAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).DeletePosixAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/DeletePosixAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).DeletePosixAccount(ctx, req.(*DeletePosixAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_DeleteSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).DeleteSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/DeleteSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).DeleteSshPublicKey(ctx, req.(*DeleteSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_GetLoginProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLoginProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).GetLoginProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/GetLoginProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).GetLoginProfile(ctx, req.(*GetLoginProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_GetSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).GetSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/GetSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).GetSshPublicKey(ctx, req.(*GetSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_ImportSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).ImportSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/ImportSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).ImportSshPublicKey(ctx, req.(*ImportSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_UpdateSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).UpdateSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/UpdateSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).UpdateSshPublicKey(ctx, req.(*UpdateSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_SignSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).SignSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/SignSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).SignSshPublicKey(ctx, req.(*SignSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OsLoginService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.oslogin.v1beta.OsLoginService",
	HandlerType: (*OsLoginServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSshPublicKey",
			Handler:    _OsLoginService_CreateSshPublicKey_Handler,
		},
		{
			MethodName: "DeletePosixAccount",
			Handler:    _OsLoginService_DeletePosixAccount_Handler,
		},
		{
			MethodName: "DeleteSshPublicKey",
			Handler:    _OsLoginService_DeleteSshPublicKey_Handler,
		},
		{
			MethodName: "GetLoginProfile",
			Handler:    _OsLoginService_GetLoginProfile_Handler,
		},
		{
			MethodName: "GetSshPublicKey",
			Handler:    _OsLoginService_GetSshPublicKey_Handler,
		},
		{
			MethodName: "ImportSshPublicKey",
			Handler:    _OsLoginService_ImportSshPublicKey_Handler,
		},
		{
			MethodName: "UpdateSshPublicKey",
			Handler:    _OsLoginService_UpdateSshPublicKey_Handler,
		},
		{
			MethodName: "SignSshPublicKey",
			Handler:    _OsLoginService_SignSshPublicKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/oslogin/v1beta/oslogin.proto",
}
