<!--
SPDX-License-Identifier: Apache-2.0
SPDX-FileCopyrightText: Zygmunt Krynicki
-->
# Package Network Proxy

## Early-Access

This feature is in early-access and may change from release to release.
Currently this feature is only available as a part of the snap package.
Upstream version of apt-cacher-ng contains bugs related to UNIX sockets.
[Debian Bug 1027167](https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=1027167)

## Architecture

The `apt-cacher-ng` service is configured to listen on a UNIX socket
`$SNAP_COMMON/apt-cacher-ng.sock`. QEMU is configured to forward TCP requests
to 10.2.0.100 on port 3142 to a `nc` (netcat) command running on the host.
Netcat is used to re-direct this request to the aforementioned UNIX socket.
Port 3142 is the default port for apt-cacher-ng.

Virtual machines are customized with `cloud-init` to resolve the hostname
`apt-proxy` to `10.0.2.100`. This convention is used by `auto-apt-proxy`
program that, once installed in the virtual machine, completes the automatic
discovery.

## Storage

Cache is present in `$SNAP_COMMON/cache` while logs are in `$SNAP_COMMON/logs`.
At the moment there is no mechanism to reclaimed used storage.

## Usage

For Debian-based systems configuration is fully automatic. A bundled copy of
`auto-apt-proxy` is injected into the image during first-boot, with a pair of
`cloud-init` files.

Older Ubuntu systems seem to dislike the proxy together with Extended Security
Maintenance (ESM) archives. The following `.image-garden.mk` snippet seems to
resolve that.

```make
define UBUNTU_16.04_CLOUD_INIT_USER_DATA_TEMPLATE
$(CLOUD_INIT_USER_DATA_TEMPLATE)
# Work around ESM not working in the initial image. After packages are updated
# the two ESM files go away automatically. While those are present updating
# packages fails on HTTP 503 error.
- rm -f /etc/apt/sources.list.d/ubuntu-esm-infra.list /etc/apt/sources.list.d/ubuntu-esm-apps.list
package_update: true
package_upgrade: true
endef
```
