---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, résolution d'une police, résolution des caractères, 
              polices bitmap
---

# Que sont les "résolutions" ?

Le mot "résolution" est un mot qui s'emploie sans se soucier de ses multiples sens 
dans le domaine du matériel informatique. Le mot suggère une mesure 
de ce qu'un observateur (peut-être l'œil humain) peut distinguer. Pourtant, 
nous voyons régulièrement des publicités pour des imprimantes 
dont la résolution est de [1200 dpi](wpfr:Point_par_pouce) --- bien plus fine 
que ce que l'œil humain peut distinguer sans aide. Les publicités parlent ici 
de la précision avec laquelle l'imprimante peut placer des points sur l'image imprimée, 
ce qui affecte la finesse de la représentation des polices 
et la précision du placement des glyphes et autres marques sur la page.

En fait, il existe deux types de "résolution" sur la page imprimée 
que nous devons prendre en compte pour les besoins de TeX ou LaTeX :

- la précision de positionnement ;
- la qualité des polices.

Dans le cas où la sortie TeX ou LaTeX est envoyée directement à une imprimante, 
dans le langage "natif" de l'imprimante, il est clair que le processeur DVI 
doit connaître tous ces détails et doit tenir compte des deux types de résolution.

Dans le cas où la sortie est envoyée vers un format intermédiaire, 
qui a un potentiel d'impression (ou d'affichage), nous ne savons pas 
comment le traducteur final, qui se connecte directement à l'imprimante (ou à l'écran), 
a connaissance des propriétés de l'appareil : le processeur DVI n'a pas besoin 
de le savoir et ne doit pas prétendre le deviner.

Les sorties PostScript et PDF entrent dans cette catégorie. 
Bien que PostScript soit de nos jours moins fréquemment utilisé 
pour la distribution de documents, il est régulièrement utilisé 
comme source de conversion en PDF. Et le PDF est le moteur d'un énorme développement
de la distribution de documents.

Par conséquent, nous avons besoin de processeurs DVI qui produisent une sortie PostScript 
ou PDF "indépendante de la résolution". Bien entendu, l’indépendance doit s’étendre 
aux deux formes d’indépendance décrites ci-dessus.

L'indépendance des polices en matière de résolution a longtemps été imposée au monde 
par la faiblesse d'Acrobat Reader d'Adobe à gérer les polices matricielles : 
quelques questions de cette FAQ traite ce sujet, telle 
"[](/5_fichiers/formats/pdf/generer_un_fichier_pdf_de_qualite)".

L'indépendance par rapport à la résolution du positionnement est plus gênante : 
`dvips` est quelque peu connu pour insister sur un positionnement en lien avec la précision 
de la résolution déclarée de l'imprimante. Une approche couramment utilisée consiste donc 
à déclarer une résolution de 8 000 ("meilleure que n'importe quel appareil"). 
Cette méthode s'avère raisonnablement efficace même si elle présente 
[des problèmes](/2_programmation/erreurs/m/mismatched_mode_ljfour_and_resolution_8000).


:::{sources}
[What are « resolutions »?](faquk:FAQ-resolns)
:::