/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicReference;
import org.ops4j.pax.web.service.spi.model.events.WebApplicationEvent;
import org.ops4j.pax.web.service.spi.model.events.WebApplicationEventListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventAdminHandler
implements WebApplicationEventListener,
ServiceTrackerCustomizer<EventAdmin, EventAdmin> {
    private static final Logger LOG = LoggerFactory.getLogger(EventAdminHandler.class);
    private final AtomicReference<EventAdmin> eventAdminReference = new AtomicReference();
    private final BundleContext bundleContext;

    public EventAdminHandler(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void webEvent(WebApplicationEvent event) {
        EventAdmin eventAdmin = this.eventAdminReference.get();
        if (eventAdmin != null) {
            String topic = event.getType().getTopic();
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            ((Dictionary)properties).put("bundle", event.getBundle());
            ((Dictionary)properties).put("bundle.symbolicName", event.getBundleName());
            ((Dictionary)properties).put("bundle.id", event.getBundleId());
            ((Dictionary)properties).put("bundle.version", event.getBundleVersion());
            ((Dictionary)properties).put("context.path", event.getContextPath());
            ((Dictionary)properties).put("timestamp", event.getTimestamp());
            ((Dictionary)properties).put("extender.bundle", event.getExtenderBundle());
            ((Dictionary)properties).put("extender.bundle.id", event.getExtenderBundleId());
            ((Dictionary)properties).put("extender.bundle.symbolicName", event.getExtenderBundleName());
            ((Dictionary)properties).put("extender.bundle.version", event.getExtenderBundleVersion());
            if (event.getException() != null) {
                ((Dictionary)properties).put("exception", event.getException());
            }
            if (event.getCollisionIds() != null) {
                ((Dictionary)properties).put("collision", event.getContextPath());
                ((Dictionary)properties).put("collision.bundles", event.getCollisionIds());
            }
            Event ev = new Event(topic, properties);
            eventAdmin.postEvent(ev);
        }
    }

    public EventAdmin addingService(ServiceReference<EventAdmin> reference) {
        if (reference.isAssignableTo(this.bundleContext.getBundle(), "org.osgi.service.event.EventAdmin")) {
            EventAdmin eventService = (EventAdmin)this.bundleContext.getService(reference);
            if (eventService != null) {
                EventAdmin old = this.eventAdminReference.getAndSet(eventService);
                if (old != null) {
                    LOG.debug("replace old EventAdmin instance {} by an instance of {}", (Object)old.getClass().getName(), (Object)eventService.getClass().getName());
                }
                return eventService;
            }
        } else {
            LOG.warn("An EventAdmin service was found, but it is not assignable to this bundle, make sure to have a compatible org.osgi.service.event package exported.");
        }
        return null;
    }

    public void modifiedService(ServiceReference<EventAdmin> reference, EventAdmin service) {
    }

    public void removedService(ServiceReference<EventAdmin> reference, EventAdmin service) {
        this.bundleContext.ungetService(reference);
        this.eventAdminReference.compareAndSet(service, null);
    }
}

