/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.eclipse.xtext.generator.trace.AbstractStatefulTraceRegion;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegionWithLineInformation;

public class TraceRegion
extends AbstractStatefulTraceRegion {
    public TraceRegion(int myOffset, int myLength, int myLineNumber, int myEndLineNumber, boolean useForDebugging, int associatedOffset, int associatedLength, int associatedLineNumber, int associatedEndLineNumber, AbstractTraceRegion parent, SourceRelativeURI associatedPath) {
        this(myOffset, myLength, myLineNumber, myEndLineNumber, useForDebugging, new LocationData(associatedOffset, associatedLength, associatedLineNumber, associatedEndLineNumber, associatedPath), parent);
    }

    public TraceRegion(int myOffset, int myLength, int myLineNumber, int myEndLineNumber, boolean useForDebugging, ILocationData locationData, AbstractTraceRegion parent) {
        super((ITextRegionWithLineInformation)new TextRegionWithLineInformation(myOffset, myLength, myLineNumber, myEndLineNumber), useForDebugging, locationData, parent);
        if (myOffset == myLength && myOffset == 0) {
            throw new IllegalArgumentException();
        }
        if (parent == null ? locationData.getSrcRelativePath() == null : parent.getAssociatedSrcRelativePath() == null && locationData.getSrcRelativePath() == null) {
            throw new IllegalArgumentException("associatedPath may not be null");
        }
    }

    @Deprecated
    public TraceRegion(int myOffset, int myLength, int myLineNumber, int myEndLineNumber, boolean useForDebugging, List<ILocationData> allLocationData, AbstractTraceRegion parent) {
        this(myOffset, myLength, myLineNumber, myEndLineNumber, useForDebugging, (Collection<? extends ILocationData>)allLocationData, parent);
    }

    public TraceRegion(int myOffset, int myLength, int myLineNumber, int myEndLineNumber, boolean useForDebugging, Collection<? extends ILocationData> allLocationData, AbstractTraceRegion parent) {
        super((ITextRegionWithLineInformation)new TextRegionWithLineInformation(myOffset, myLength, myLineNumber, myEndLineNumber), useForDebugging, Lists.newArrayList(allLocationData), parent);
        if (parent == null) {
            for (ILocationData iLocationData : allLocationData) {
                if (iLocationData.getSrcRelativePath() != null) continue;
                throw new IllegalArgumentException("associatedPath may not be null");
            }
        } else {
            boolean bl;
            boolean bl2 = false;
            boolean notNullSeen = false;
            for (ILocationData iLocationData : allLocationData) {
                if (iLocationData.getSrcRelativePath() == null) {
                    bl = true;
                } else {
                    notNullSeen = true;
                }
                if (!bl || !notNullSeen) continue;
                throw new IllegalArgumentException("list of locations is inconsistent");
            }
            if (parent.getAssociatedSrcRelativePath() == null && bl) {
                throw new IllegalArgumentException("list of locations is inconsistent with parent");
            }
        }
    }
}

