// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package mailmanageriface provides an interface to enable mocking the MailManager service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package mailmanageriface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/mailmanager"
)

// MailManagerAPI provides an interface to enable mocking the
// mailmanager.MailManager service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// MailManager.
//	func myFunc(svc mailmanageriface.MailManagerAPI) bool {
//	    // Make svc.CreateAddonInstance request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := mailmanager.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockMailManagerClient struct {
//	    mailmanageriface.MailManagerAPI
//	}
//	func (m *mockMailManagerClient) CreateAddonInstance(input *mailmanager.CreateAddonInstanceInput) (*mailmanager.CreateAddonInstanceOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockMailManagerClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type MailManagerAPI interface {
	CreateAddonInstance(*mailmanager.CreateAddonInstanceInput) (*mailmanager.CreateAddonInstanceOutput, error)
	CreateAddonInstanceWithContext(aws.Context, *mailmanager.CreateAddonInstanceInput, ...request.Option) (*mailmanager.CreateAddonInstanceOutput, error)
	CreateAddonInstanceRequest(*mailmanager.CreateAddonInstanceInput) (*request.Request, *mailmanager.CreateAddonInstanceOutput)

	CreateAddonSubscription(*mailmanager.CreateAddonSubscriptionInput) (*mailmanager.CreateAddonSubscriptionOutput, error)
	CreateAddonSubscriptionWithContext(aws.Context, *mailmanager.CreateAddonSubscriptionInput, ...request.Option) (*mailmanager.CreateAddonSubscriptionOutput, error)
	CreateAddonSubscriptionRequest(*mailmanager.CreateAddonSubscriptionInput) (*request.Request, *mailmanager.CreateAddonSubscriptionOutput)

	CreateArchive(*mailmanager.CreateArchiveInput) (*mailmanager.CreateArchiveOutput, error)
	CreateArchiveWithContext(aws.Context, *mailmanager.CreateArchiveInput, ...request.Option) (*mailmanager.CreateArchiveOutput, error)
	CreateArchiveRequest(*mailmanager.CreateArchiveInput) (*request.Request, *mailmanager.CreateArchiveOutput)

	CreateIngressPoint(*mailmanager.CreateIngressPointInput) (*mailmanager.CreateIngressPointOutput, error)
	CreateIngressPointWithContext(aws.Context, *mailmanager.CreateIngressPointInput, ...request.Option) (*mailmanager.CreateIngressPointOutput, error)
	CreateIngressPointRequest(*mailmanager.CreateIngressPointInput) (*request.Request, *mailmanager.CreateIngressPointOutput)

	CreateRelay(*mailmanager.CreateRelayInput) (*mailmanager.CreateRelayOutput, error)
	CreateRelayWithContext(aws.Context, *mailmanager.CreateRelayInput, ...request.Option) (*mailmanager.CreateRelayOutput, error)
	CreateRelayRequest(*mailmanager.CreateRelayInput) (*request.Request, *mailmanager.CreateRelayOutput)

	CreateRuleSet(*mailmanager.CreateRuleSetInput) (*mailmanager.CreateRuleSetOutput, error)
	CreateRuleSetWithContext(aws.Context, *mailmanager.CreateRuleSetInput, ...request.Option) (*mailmanager.CreateRuleSetOutput, error)
	CreateRuleSetRequest(*mailmanager.CreateRuleSetInput) (*request.Request, *mailmanager.CreateRuleSetOutput)

	CreateTrafficPolicy(*mailmanager.CreateTrafficPolicyInput) (*mailmanager.CreateTrafficPolicyOutput, error)
	CreateTrafficPolicyWithContext(aws.Context, *mailmanager.CreateTrafficPolicyInput, ...request.Option) (*mailmanager.CreateTrafficPolicyOutput, error)
	CreateTrafficPolicyRequest(*mailmanager.CreateTrafficPolicyInput) (*request.Request, *mailmanager.CreateTrafficPolicyOutput)

	DeleteAddonInstance(*mailmanager.DeleteAddonInstanceInput) (*mailmanager.DeleteAddonInstanceOutput, error)
	DeleteAddonInstanceWithContext(aws.Context, *mailmanager.DeleteAddonInstanceInput, ...request.Option) (*mailmanager.DeleteAddonInstanceOutput, error)
	DeleteAddonInstanceRequest(*mailmanager.DeleteAddonInstanceInput) (*request.Request, *mailmanager.DeleteAddonInstanceOutput)

	DeleteAddonSubscription(*mailmanager.DeleteAddonSubscriptionInput) (*mailmanager.DeleteAddonSubscriptionOutput, error)
	DeleteAddonSubscriptionWithContext(aws.Context, *mailmanager.DeleteAddonSubscriptionInput, ...request.Option) (*mailmanager.DeleteAddonSubscriptionOutput, error)
	DeleteAddonSubscriptionRequest(*mailmanager.DeleteAddonSubscriptionInput) (*request.Request, *mailmanager.DeleteAddonSubscriptionOutput)

	DeleteArchive(*mailmanager.DeleteArchiveInput) (*mailmanager.DeleteArchiveOutput, error)
	DeleteArchiveWithContext(aws.Context, *mailmanager.DeleteArchiveInput, ...request.Option) (*mailmanager.DeleteArchiveOutput, error)
	DeleteArchiveRequest(*mailmanager.DeleteArchiveInput) (*request.Request, *mailmanager.DeleteArchiveOutput)

	DeleteIngressPoint(*mailmanager.DeleteIngressPointInput) (*mailmanager.DeleteIngressPointOutput, error)
	DeleteIngressPointWithContext(aws.Context, *mailmanager.DeleteIngressPointInput, ...request.Option) (*mailmanager.DeleteIngressPointOutput, error)
	DeleteIngressPointRequest(*mailmanager.DeleteIngressPointInput) (*request.Request, *mailmanager.DeleteIngressPointOutput)

	DeleteRelay(*mailmanager.DeleteRelayInput) (*mailmanager.DeleteRelayOutput, error)
	DeleteRelayWithContext(aws.Context, *mailmanager.DeleteRelayInput, ...request.Option) (*mailmanager.DeleteRelayOutput, error)
	DeleteRelayRequest(*mailmanager.DeleteRelayInput) (*request.Request, *mailmanager.DeleteRelayOutput)

	DeleteRuleSet(*mailmanager.DeleteRuleSetInput) (*mailmanager.DeleteRuleSetOutput, error)
	DeleteRuleSetWithContext(aws.Context, *mailmanager.DeleteRuleSetInput, ...request.Option) (*mailmanager.DeleteRuleSetOutput, error)
	DeleteRuleSetRequest(*mailmanager.DeleteRuleSetInput) (*request.Request, *mailmanager.DeleteRuleSetOutput)

	DeleteTrafficPolicy(*mailmanager.DeleteTrafficPolicyInput) (*mailmanager.DeleteTrafficPolicyOutput, error)
	DeleteTrafficPolicyWithContext(aws.Context, *mailmanager.DeleteTrafficPolicyInput, ...request.Option) (*mailmanager.DeleteTrafficPolicyOutput, error)
	DeleteTrafficPolicyRequest(*mailmanager.DeleteTrafficPolicyInput) (*request.Request, *mailmanager.DeleteTrafficPolicyOutput)

	GetAddonInstance(*mailmanager.GetAddonInstanceInput) (*mailmanager.GetAddonInstanceOutput, error)
	GetAddonInstanceWithContext(aws.Context, *mailmanager.GetAddonInstanceInput, ...request.Option) (*mailmanager.GetAddonInstanceOutput, error)
	GetAddonInstanceRequest(*mailmanager.GetAddonInstanceInput) (*request.Request, *mailmanager.GetAddonInstanceOutput)

	GetAddonSubscription(*mailmanager.GetAddonSubscriptionInput) (*mailmanager.GetAddonSubscriptionOutput, error)
	GetAddonSubscriptionWithContext(aws.Context, *mailmanager.GetAddonSubscriptionInput, ...request.Option) (*mailmanager.GetAddonSubscriptionOutput, error)
	GetAddonSubscriptionRequest(*mailmanager.GetAddonSubscriptionInput) (*request.Request, *mailmanager.GetAddonSubscriptionOutput)

	GetArchive(*mailmanager.GetArchiveInput) (*mailmanager.GetArchiveOutput, error)
	GetArchiveWithContext(aws.Context, *mailmanager.GetArchiveInput, ...request.Option) (*mailmanager.GetArchiveOutput, error)
	GetArchiveRequest(*mailmanager.GetArchiveInput) (*request.Request, *mailmanager.GetArchiveOutput)

	GetArchiveExport(*mailmanager.GetArchiveExportInput) (*mailmanager.GetArchiveExportOutput, error)
	GetArchiveExportWithContext(aws.Context, *mailmanager.GetArchiveExportInput, ...request.Option) (*mailmanager.GetArchiveExportOutput, error)
	GetArchiveExportRequest(*mailmanager.GetArchiveExportInput) (*request.Request, *mailmanager.GetArchiveExportOutput)

	GetArchiveMessage(*mailmanager.GetArchiveMessageInput) (*mailmanager.GetArchiveMessageOutput, error)
	GetArchiveMessageWithContext(aws.Context, *mailmanager.GetArchiveMessageInput, ...request.Option) (*mailmanager.GetArchiveMessageOutput, error)
	GetArchiveMessageRequest(*mailmanager.GetArchiveMessageInput) (*request.Request, *mailmanager.GetArchiveMessageOutput)

	GetArchiveMessageContent(*mailmanager.GetArchiveMessageContentInput) (*mailmanager.GetArchiveMessageContentOutput, error)
	GetArchiveMessageContentWithContext(aws.Context, *mailmanager.GetArchiveMessageContentInput, ...request.Option) (*mailmanager.GetArchiveMessageContentOutput, error)
	GetArchiveMessageContentRequest(*mailmanager.GetArchiveMessageContentInput) (*request.Request, *mailmanager.GetArchiveMessageContentOutput)

	GetArchiveSearch(*mailmanager.GetArchiveSearchInput) (*mailmanager.GetArchiveSearchOutput, error)
	GetArchiveSearchWithContext(aws.Context, *mailmanager.GetArchiveSearchInput, ...request.Option) (*mailmanager.GetArchiveSearchOutput, error)
	GetArchiveSearchRequest(*mailmanager.GetArchiveSearchInput) (*request.Request, *mailmanager.GetArchiveSearchOutput)

	GetArchiveSearchResults(*mailmanager.GetArchiveSearchResultsInput) (*mailmanager.GetArchiveSearchResultsOutput, error)
	GetArchiveSearchResultsWithContext(aws.Context, *mailmanager.GetArchiveSearchResultsInput, ...request.Option) (*mailmanager.GetArchiveSearchResultsOutput, error)
	GetArchiveSearchResultsRequest(*mailmanager.GetArchiveSearchResultsInput) (*request.Request, *mailmanager.GetArchiveSearchResultsOutput)

	GetIngressPoint(*mailmanager.GetIngressPointInput) (*mailmanager.GetIngressPointOutput, error)
	GetIngressPointWithContext(aws.Context, *mailmanager.GetIngressPointInput, ...request.Option) (*mailmanager.GetIngressPointOutput, error)
	GetIngressPointRequest(*mailmanager.GetIngressPointInput) (*request.Request, *mailmanager.GetIngressPointOutput)

	GetRelay(*mailmanager.GetRelayInput) (*mailmanager.GetRelayOutput, error)
	GetRelayWithContext(aws.Context, *mailmanager.GetRelayInput, ...request.Option) (*mailmanager.GetRelayOutput, error)
	GetRelayRequest(*mailmanager.GetRelayInput) (*request.Request, *mailmanager.GetRelayOutput)

	GetRuleSet(*mailmanager.GetRuleSetInput) (*mailmanager.GetRuleSetOutput, error)
	GetRuleSetWithContext(aws.Context, *mailmanager.GetRuleSetInput, ...request.Option) (*mailmanager.GetRuleSetOutput, error)
	GetRuleSetRequest(*mailmanager.GetRuleSetInput) (*request.Request, *mailmanager.GetRuleSetOutput)

	GetTrafficPolicy(*mailmanager.GetTrafficPolicyInput) (*mailmanager.GetTrafficPolicyOutput, error)
	GetTrafficPolicyWithContext(aws.Context, *mailmanager.GetTrafficPolicyInput, ...request.Option) (*mailmanager.GetTrafficPolicyOutput, error)
	GetTrafficPolicyRequest(*mailmanager.GetTrafficPolicyInput) (*request.Request, *mailmanager.GetTrafficPolicyOutput)

	ListAddonInstances(*mailmanager.ListAddonInstancesInput) (*mailmanager.ListAddonInstancesOutput, error)
	ListAddonInstancesWithContext(aws.Context, *mailmanager.ListAddonInstancesInput, ...request.Option) (*mailmanager.ListAddonInstancesOutput, error)
	ListAddonInstancesRequest(*mailmanager.ListAddonInstancesInput) (*request.Request, *mailmanager.ListAddonInstancesOutput)

	ListAddonInstancesPages(*mailmanager.ListAddonInstancesInput, func(*mailmanager.ListAddonInstancesOutput, bool) bool) error
	ListAddonInstancesPagesWithContext(aws.Context, *mailmanager.ListAddonInstancesInput, func(*mailmanager.ListAddonInstancesOutput, bool) bool, ...request.Option) error

	ListAddonSubscriptions(*mailmanager.ListAddonSubscriptionsInput) (*mailmanager.ListAddonSubscriptionsOutput, error)
	ListAddonSubscriptionsWithContext(aws.Context, *mailmanager.ListAddonSubscriptionsInput, ...request.Option) (*mailmanager.ListAddonSubscriptionsOutput, error)
	ListAddonSubscriptionsRequest(*mailmanager.ListAddonSubscriptionsInput) (*request.Request, *mailmanager.ListAddonSubscriptionsOutput)

	ListAddonSubscriptionsPages(*mailmanager.ListAddonSubscriptionsInput, func(*mailmanager.ListAddonSubscriptionsOutput, bool) bool) error
	ListAddonSubscriptionsPagesWithContext(aws.Context, *mailmanager.ListAddonSubscriptionsInput, func(*mailmanager.ListAddonSubscriptionsOutput, bool) bool, ...request.Option) error

	ListArchiveExports(*mailmanager.ListArchiveExportsInput) (*mailmanager.ListArchiveExportsOutput, error)
	ListArchiveExportsWithContext(aws.Context, *mailmanager.ListArchiveExportsInput, ...request.Option) (*mailmanager.ListArchiveExportsOutput, error)
	ListArchiveExportsRequest(*mailmanager.ListArchiveExportsInput) (*request.Request, *mailmanager.ListArchiveExportsOutput)

	ListArchiveExportsPages(*mailmanager.ListArchiveExportsInput, func(*mailmanager.ListArchiveExportsOutput, bool) bool) error
	ListArchiveExportsPagesWithContext(aws.Context, *mailmanager.ListArchiveExportsInput, func(*mailmanager.ListArchiveExportsOutput, bool) bool, ...request.Option) error

	ListArchiveSearches(*mailmanager.ListArchiveSearchesInput) (*mailmanager.ListArchiveSearchesOutput, error)
	ListArchiveSearchesWithContext(aws.Context, *mailmanager.ListArchiveSearchesInput, ...request.Option) (*mailmanager.ListArchiveSearchesOutput, error)
	ListArchiveSearchesRequest(*mailmanager.ListArchiveSearchesInput) (*request.Request, *mailmanager.ListArchiveSearchesOutput)

	ListArchiveSearchesPages(*mailmanager.ListArchiveSearchesInput, func(*mailmanager.ListArchiveSearchesOutput, bool) bool) error
	ListArchiveSearchesPagesWithContext(aws.Context, *mailmanager.ListArchiveSearchesInput, func(*mailmanager.ListArchiveSearchesOutput, bool) bool, ...request.Option) error

	ListArchives(*mailmanager.ListArchivesInput) (*mailmanager.ListArchivesOutput, error)
	ListArchivesWithContext(aws.Context, *mailmanager.ListArchivesInput, ...request.Option) (*mailmanager.ListArchivesOutput, error)
	ListArchivesRequest(*mailmanager.ListArchivesInput) (*request.Request, *mailmanager.ListArchivesOutput)

	ListArchivesPages(*mailmanager.ListArchivesInput, func(*mailmanager.ListArchivesOutput, bool) bool) error
	ListArchivesPagesWithContext(aws.Context, *mailmanager.ListArchivesInput, func(*mailmanager.ListArchivesOutput, bool) bool, ...request.Option) error

	ListIngressPoints(*mailmanager.ListIngressPointsInput) (*mailmanager.ListIngressPointsOutput, error)
	ListIngressPointsWithContext(aws.Context, *mailmanager.ListIngressPointsInput, ...request.Option) (*mailmanager.ListIngressPointsOutput, error)
	ListIngressPointsRequest(*mailmanager.ListIngressPointsInput) (*request.Request, *mailmanager.ListIngressPointsOutput)

	ListIngressPointsPages(*mailmanager.ListIngressPointsInput, func(*mailmanager.ListIngressPointsOutput, bool) bool) error
	ListIngressPointsPagesWithContext(aws.Context, *mailmanager.ListIngressPointsInput, func(*mailmanager.ListIngressPointsOutput, bool) bool, ...request.Option) error

	ListRelays(*mailmanager.ListRelaysInput) (*mailmanager.ListRelaysOutput, error)
	ListRelaysWithContext(aws.Context, *mailmanager.ListRelaysInput, ...request.Option) (*mailmanager.ListRelaysOutput, error)
	ListRelaysRequest(*mailmanager.ListRelaysInput) (*request.Request, *mailmanager.ListRelaysOutput)

	ListRelaysPages(*mailmanager.ListRelaysInput, func(*mailmanager.ListRelaysOutput, bool) bool) error
	ListRelaysPagesWithContext(aws.Context, *mailmanager.ListRelaysInput, func(*mailmanager.ListRelaysOutput, bool) bool, ...request.Option) error

	ListRuleSets(*mailmanager.ListRuleSetsInput) (*mailmanager.ListRuleSetsOutput, error)
	ListRuleSetsWithContext(aws.Context, *mailmanager.ListRuleSetsInput, ...request.Option) (*mailmanager.ListRuleSetsOutput, error)
	ListRuleSetsRequest(*mailmanager.ListRuleSetsInput) (*request.Request, *mailmanager.ListRuleSetsOutput)

	ListRuleSetsPages(*mailmanager.ListRuleSetsInput, func(*mailmanager.ListRuleSetsOutput, bool) bool) error
	ListRuleSetsPagesWithContext(aws.Context, *mailmanager.ListRuleSetsInput, func(*mailmanager.ListRuleSetsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*mailmanager.ListTagsForResourceInput) (*mailmanager.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *mailmanager.ListTagsForResourceInput, ...request.Option) (*mailmanager.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*mailmanager.ListTagsForResourceInput) (*request.Request, *mailmanager.ListTagsForResourceOutput)

	ListTrafficPolicies(*mailmanager.ListTrafficPoliciesInput) (*mailmanager.ListTrafficPoliciesOutput, error)
	ListTrafficPoliciesWithContext(aws.Context, *mailmanager.ListTrafficPoliciesInput, ...request.Option) (*mailmanager.ListTrafficPoliciesOutput, error)
	ListTrafficPoliciesRequest(*mailmanager.ListTrafficPoliciesInput) (*request.Request, *mailmanager.ListTrafficPoliciesOutput)

	ListTrafficPoliciesPages(*mailmanager.ListTrafficPoliciesInput, func(*mailmanager.ListTrafficPoliciesOutput, bool) bool) error
	ListTrafficPoliciesPagesWithContext(aws.Context, *mailmanager.ListTrafficPoliciesInput, func(*mailmanager.ListTrafficPoliciesOutput, bool) bool, ...request.Option) error

	StartArchiveExport(*mailmanager.StartArchiveExportInput) (*mailmanager.StartArchiveExportOutput, error)
	StartArchiveExportWithContext(aws.Context, *mailmanager.StartArchiveExportInput, ...request.Option) (*mailmanager.StartArchiveExportOutput, error)
	StartArchiveExportRequest(*mailmanager.StartArchiveExportInput) (*request.Request, *mailmanager.StartArchiveExportOutput)

	StartArchiveSearch(*mailmanager.StartArchiveSearchInput) (*mailmanager.StartArchiveSearchOutput, error)
	StartArchiveSearchWithContext(aws.Context, *mailmanager.StartArchiveSearchInput, ...request.Option) (*mailmanager.StartArchiveSearchOutput, error)
	StartArchiveSearchRequest(*mailmanager.StartArchiveSearchInput) (*request.Request, *mailmanager.StartArchiveSearchOutput)

	StopArchiveExport(*mailmanager.StopArchiveExportInput) (*mailmanager.StopArchiveExportOutput, error)
	StopArchiveExportWithContext(aws.Context, *mailmanager.StopArchiveExportInput, ...request.Option) (*mailmanager.StopArchiveExportOutput, error)
	StopArchiveExportRequest(*mailmanager.StopArchiveExportInput) (*request.Request, *mailmanager.StopArchiveExportOutput)

	StopArchiveSearch(*mailmanager.StopArchiveSearchInput) (*mailmanager.StopArchiveSearchOutput, error)
	StopArchiveSearchWithContext(aws.Context, *mailmanager.StopArchiveSearchInput, ...request.Option) (*mailmanager.StopArchiveSearchOutput, error)
	StopArchiveSearchRequest(*mailmanager.StopArchiveSearchInput) (*request.Request, *mailmanager.StopArchiveSearchOutput)

	TagResource(*mailmanager.TagResourceInput) (*mailmanager.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *mailmanager.TagResourceInput, ...request.Option) (*mailmanager.TagResourceOutput, error)
	TagResourceRequest(*mailmanager.TagResourceInput) (*request.Request, *mailmanager.TagResourceOutput)

	UntagResource(*mailmanager.UntagResourceInput) (*mailmanager.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *mailmanager.UntagResourceInput, ...request.Option) (*mailmanager.UntagResourceOutput, error)
	UntagResourceRequest(*mailmanager.UntagResourceInput) (*request.Request, *mailmanager.UntagResourceOutput)

	UpdateArchive(*mailmanager.UpdateArchiveInput) (*mailmanager.UpdateArchiveOutput, error)
	UpdateArchiveWithContext(aws.Context, *mailmanager.UpdateArchiveInput, ...request.Option) (*mailmanager.UpdateArchiveOutput, error)
	UpdateArchiveRequest(*mailmanager.UpdateArchiveInput) (*request.Request, *mailmanager.UpdateArchiveOutput)

	UpdateIngressPoint(*mailmanager.UpdateIngressPointInput) (*mailmanager.UpdateIngressPointOutput, error)
	UpdateIngressPointWithContext(aws.Context, *mailmanager.UpdateIngressPointInput, ...request.Option) (*mailmanager.UpdateIngressPointOutput, error)
	UpdateIngressPointRequest(*mailmanager.UpdateIngressPointInput) (*request.Request, *mailmanager.UpdateIngressPointOutput)

	UpdateRelay(*mailmanager.UpdateRelayInput) (*mailmanager.UpdateRelayOutput, error)
	UpdateRelayWithContext(aws.Context, *mailmanager.UpdateRelayInput, ...request.Option) (*mailmanager.UpdateRelayOutput, error)
	UpdateRelayRequest(*mailmanager.UpdateRelayInput) (*request.Request, *mailmanager.UpdateRelayOutput)

	UpdateRuleSet(*mailmanager.UpdateRuleSetInput) (*mailmanager.UpdateRuleSetOutput, error)
	UpdateRuleSetWithContext(aws.Context, *mailmanager.UpdateRuleSetInput, ...request.Option) (*mailmanager.UpdateRuleSetOutput, error)
	UpdateRuleSetRequest(*mailmanager.UpdateRuleSetInput) (*request.Request, *mailmanager.UpdateRuleSetOutput)

	UpdateTrafficPolicy(*mailmanager.UpdateTrafficPolicyInput) (*mailmanager.UpdateTrafficPolicyOutput, error)
	UpdateTrafficPolicyWithContext(aws.Context, *mailmanager.UpdateTrafficPolicyInput, ...request.Option) (*mailmanager.UpdateTrafficPolicyOutput, error)
	UpdateTrafficPolicyRequest(*mailmanager.UpdateTrafficPolicyInput) (*request.Request, *mailmanager.UpdateTrafficPolicyOutput)
}

var _ MailManagerAPI = (*mailmanager.MailManager)(nil)
