<?php
// This file was auto-generated from sdk-root/src/data/groundstation/2019-05-23/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2019-05-23', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 'groundstation', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceFullName' => 'AWS Ground Station', 'serviceId' => 'GroundStation', 'signatureVersion' => 'v4', 'signingName' => 'groundstation', 'uid' => 'groundstation-2019-05-23', ], 'operations' => [ 'CancelContact' => [ 'name' => 'CancelContact', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/contact/{contactId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CancelContactRequest', ], 'output' => [ 'shape' => 'ContactIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'CreateConfig' => [ 'name' => 'CreateConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/config', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateConfigRequest', ], 'output' => [ 'shape' => 'ConfigIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'CreateDataflowEndpointGroup' => [ 'name' => 'CreateDataflowEndpointGroup', 'http' => [ 'method' => 'POST', 'requestUri' => '/dataflowEndpointGroup', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateDataflowEndpointGroupRequest', ], 'output' => [ 'shape' => 'DataflowEndpointGroupIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'CreateDataflowEndpointGroupV2' => [ 'name' => 'CreateDataflowEndpointGroupV2', 'http' => [ 'method' => 'POST', 'requestUri' => '/dataflowEndpointGroupV2', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateDataflowEndpointGroupV2Request', ], 'output' => [ 'shape' => 'CreateDataflowEndpointGroupV2Response', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'CreateEphemeris' => [ 'name' => 'CreateEphemeris', 'http' => [ 'method' => 'POST', 'requestUri' => '/ephemeris', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateEphemerisRequest', ], 'output' => [ 'shape' => 'EphemerisIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'CreateMissionProfile' => [ 'name' => 'CreateMissionProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/missionprofile', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateMissionProfileRequest', ], 'output' => [ 'shape' => 'MissionProfileIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'DeleteConfig' => [ 'name' => 'DeleteConfig', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/config/{configType}/{configId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteConfigRequest', ], 'output' => [ 'shape' => 'ConfigIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteDataflowEndpointGroup' => [ 'name' => 'DeleteDataflowEndpointGroup', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/dataflowEndpointGroup/{dataflowEndpointGroupId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteDataflowEndpointGroupRequest', ], 'output' => [ 'shape' => 'DataflowEndpointGroupIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteEphemeris' => [ 'name' => 'DeleteEphemeris', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/ephemeris/{ephemerisId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteEphemerisRequest', ], 'output' => [ 'shape' => 'EphemerisIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ResourceInUseException', ], ], 'idempotent' => true, ], 'DeleteMissionProfile' => [ 'name' => 'DeleteMissionProfile', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/missionprofile/{missionProfileId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteMissionProfileRequest', ], 'output' => [ 'shape' => 'MissionProfileIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DescribeContact' => [ 'name' => 'DescribeContact', 'http' => [ 'method' => 'GET', 'requestUri' => '/contact/{contactId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeContactRequest', ], 'output' => [ 'shape' => 'DescribeContactResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'DescribeEphemeris' => [ 'name' => 'DescribeEphemeris', 'http' => [ 'method' => 'GET', 'requestUri' => '/ephemeris/{ephemerisId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeEphemerisRequest', ], 'output' => [ 'shape' => 'DescribeEphemerisResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetAgentConfiguration' => [ 'name' => 'GetAgentConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/agent/{agentId}/configuration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAgentConfigurationRequest', ], 'output' => [ 'shape' => 'GetAgentConfigurationResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetAgentTaskResponseUrl' => [ 'name' => 'GetAgentTaskResponseUrl', 'http' => [ 'method' => 'GET', 'requestUri' => '/agentResponseUrl/{agentId}/{taskId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAgentTaskResponseUrlRequest', ], 'output' => [ 'shape' => 'GetAgentTaskResponseUrlResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetConfig' => [ 'name' => 'GetConfig', 'http' => [ 'method' => 'GET', 'requestUri' => '/config/{configType}/{configId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetConfigRequest', ], 'output' => [ 'shape' => 'GetConfigResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetDataflowEndpointGroup' => [ 'name' => 'GetDataflowEndpointGroup', 'http' => [ 'method' => 'GET', 'requestUri' => '/dataflowEndpointGroup/{dataflowEndpointGroupId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDataflowEndpointGroupRequest', ], 'output' => [ 'shape' => 'GetDataflowEndpointGroupResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetMinuteUsage' => [ 'name' => 'GetMinuteUsage', 'http' => [ 'method' => 'POST', 'requestUri' => '/minute-usage', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMinuteUsageRequest', ], 'output' => [ 'shape' => 'GetMinuteUsageResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetMissionProfile' => [ 'name' => 'GetMissionProfile', 'http' => [ 'method' => 'GET', 'requestUri' => '/missionprofile/{missionProfileId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMissionProfileRequest', ], 'output' => [ 'shape' => 'GetMissionProfileResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetSatellite' => [ 'name' => 'GetSatellite', 'http' => [ 'method' => 'GET', 'requestUri' => '/satellite/{satelliteId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSatelliteRequest', ], 'output' => [ 'shape' => 'GetSatelliteResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListConfigs' => [ 'name' => 'ListConfigs', 'http' => [ 'method' => 'GET', 'requestUri' => '/config', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListConfigsRequest', ], 'output' => [ 'shape' => 'ListConfigsResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListContacts' => [ 'name' => 'ListContacts', 'http' => [ 'method' => 'POST', 'requestUri' => '/contacts', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListContactsRequest', ], 'output' => [ 'shape' => 'ListContactsResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListDataflowEndpointGroups' => [ 'name' => 'ListDataflowEndpointGroups', 'http' => [ 'method' => 'GET', 'requestUri' => '/dataflowEndpointGroup', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDataflowEndpointGroupsRequest', ], 'output' => [ 'shape' => 'ListDataflowEndpointGroupsResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListEphemerides' => [ 'name' => 'ListEphemerides', 'http' => [ 'method' => 'POST', 'requestUri' => '/ephemerides', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListEphemeridesRequest', ], 'output' => [ 'shape' => 'ListEphemeridesResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListGroundStations' => [ 'name' => 'ListGroundStations', 'http' => [ 'method' => 'GET', 'requestUri' => '/groundstation', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListGroundStationsRequest', ], 'output' => [ 'shape' => 'ListGroundStationsResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListMissionProfiles' => [ 'name' => 'ListMissionProfiles', 'http' => [ 'method' => 'GET', 'requestUri' => '/missionprofile', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListMissionProfilesRequest', ], 'output' => [ 'shape' => 'ListMissionProfilesResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListSatellites' => [ 'name' => 'ListSatellites', 'http' => [ 'method' => 'GET', 'requestUri' => '/satellite', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSatellitesRequest', ], 'output' => [ 'shape' => 'ListSatellitesResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'RegisterAgent' => [ 'name' => 'RegisterAgent', 'http' => [ 'method' => 'POST', 'requestUri' => '/agent', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RegisterAgentRequest', ], 'output' => [ 'shape' => 'RegisterAgentResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ReserveContact' => [ 'name' => 'ReserveContact', 'http' => [ 'method' => 'POST', 'requestUri' => '/contact', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ReserveContactRequest', ], 'output' => [ 'shape' => 'ContactIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceLimitExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateAgentStatus' => [ 'name' => 'UpdateAgentStatus', 'http' => [ 'method' => 'PUT', 'requestUri' => '/agent/{agentId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateAgentStatusRequest', ], 'output' => [ 'shape' => 'UpdateAgentStatusResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateConfig' => [ 'name' => 'UpdateConfig', 'http' => [ 'method' => 'PUT', 'requestUri' => '/config/{configType}/{configId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateConfigRequest', ], 'output' => [ 'shape' => 'ConfigIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateEphemeris' => [ 'name' => 'UpdateEphemeris', 'http' => [ 'method' => 'PUT', 'requestUri' => '/ephemeris/{ephemerisId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateEphemerisRequest', ], 'output' => [ 'shape' => 'EphemerisIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateMissionProfile' => [ 'name' => 'UpdateMissionProfile', 'http' => [ 'method' => 'PUT', 'requestUri' => '/missionprofile/{missionProfileId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateMissionProfileRequest', ], 'output' => [ 'shape' => 'MissionProfileIdResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'DependencyException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'AWSRegion' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[\\w-]+', ], 'AgentCpuCoresList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Integer', ], 'max' => 256, 'min' => 0, ], 'AgentDetails' => [ 'type' => 'structure', 'required' => [ 'agentVersion', 'instanceId', 'instanceType', 'componentVersions', ], 'members' => [ 'agentVersion' => [ 'shape' => 'VersionString', ], 'instanceId' => [ 'shape' => 'InstanceId', ], 'instanceType' => [ 'shape' => 'InstanceType', ], 'reservedCpuCores' => [ 'shape' => 'AgentCpuCoresList', ], 'agentCpuCores' => [ 'shape' => 'AgentCpuCoresList', ], 'componentVersions' => [ 'shape' => 'ComponentVersionList', ], ], ], 'AgentStatus' => [ 'type' => 'string', 'enum' => [ 'SUCCESS', 'FAILED', 'ACTIVE', 'INACTIVE', ], ], 'AggregateStatus' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'AgentStatus', ], 'signatureMap' => [ 'shape' => 'SignatureMap', ], ], ], 'AngleUnits' => [ 'type' => 'string', 'enum' => [ 'DEGREE_ANGLE', 'RADIAN', ], ], 'AntennaDemodDecodeDetails' => [ 'type' => 'structure', 'members' => [ 'outputNode' => [ 'shape' => 'String', ], ], ], 'AntennaDownlinkConfig' => [ 'type' => 'structure', 'required' => [ 'spectrumConfig', ], 'members' => [ 'spectrumConfig' => [ 'shape' => 'SpectrumConfig', ], ], ], 'AntennaDownlinkDemodDecodeConfig' => [ 'type' => 'structure', 'required' => [ 'spectrumConfig', 'demodulationConfig', 'decodeConfig', ], 'members' => [ 'spectrumConfig' => [ 'shape' => 'SpectrumConfig', ], 'demodulationConfig' => [ 'shape' => 'DemodulationConfig', ], 'decodeConfig' => [ 'shape' => 'DecodeConfig', ], ], ], 'AntennaUplinkConfig' => [ 'type' => 'structure', 'required' => [ 'spectrumConfig', 'targetEirp', ], 'members' => [ 'transmitDisabled' => [ 'shape' => 'Boolean', ], 'spectrumConfig' => [ 'shape' => 'UplinkSpectrumConfig', ], 'targetEirp' => [ 'shape' => 'Eirp', ], ], ], 'AnyArn' => [ 'type' => 'string', 'max' => 1024, 'min' => 5, 'pattern' => '(arn:aws:)[\\s\\S]{0,1024}', ], 'AuditResults' => [ 'type' => 'string', 'enum' => [ 'HEALTHY', 'UNHEALTHY', ], ], 'AwsGroundStationAgentEndpoint' => [ 'type' => 'structure', 'required' => [ 'name', 'egressAddress', 'ingressAddress', ], 'members' => [ 'name' => [ 'shape' => 'SafeName', ], 'egressAddress' => [ 'shape' => 'ConnectionDetails', ], 'ingressAddress' => [ 'shape' => 'RangedConnectionDetails', ], 'agentStatus' => [ 'shape' => 'AgentStatus', ], 'auditResults' => [ 'shape' => 'AuditResults', ], ], ], 'AzElEphemeris' => [ 'type' => 'structure', 'required' => [ 'groundStation', 'data', ], 'members' => [ 'groundStation' => [ 'shape' => 'GroundStationName', ], 'data' => [ 'shape' => 'AzElSegmentsData', ], ], ], 'AzElEphemerisFilter' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'Uuid', ], ], ], 'AzElProgramTrackSettings' => [ 'type' => 'structure', 'required' => [ 'ephemerisId', ], 'members' => [ 'ephemerisId' => [ 'shape' => 'Uuid', ], ], ], 'AzElSegment' => [ 'type' => 'structure', 'required' => [ 'referenceEpoch', 'validTimeRange', 'azElList', ], 'members' => [ 'referenceEpoch' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'validTimeRange' => [ 'shape' => 'ISO8601TimeRange', ], 'azElList' => [ 'shape' => 'TimeAzElList', ], ], ], 'AzElSegmentList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AzElSegment', ], 'max' => 100, 'min' => 1, ], 'AzElSegments' => [ 'type' => 'structure', 'required' => [ 'angleUnit', 'azElSegmentList', ], 'members' => [ 'angleUnit' => [ 'shape' => 'AngleUnits', ], 'azElSegmentList' => [ 'shape' => 'AzElSegmentList', ], ], ], 'AzElSegmentsData' => [ 'type' => 'structure', 'members' => [ 's3Object' => [ 'shape' => 'S3Object', ], 'azElData' => [ 'shape' => 'AzElSegments', ], ], 'union' => true, ], 'BandwidthUnits' => [ 'type' => 'string', 'enum' => [ 'GHz', 'MHz', 'kHz', ], ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'BucketArn' => [ 'type' => 'string', ], 'CancelContactRequest' => [ 'type' => 'structure', 'required' => [ 'contactId', ], 'members' => [ 'contactId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'contactId', ], ], ], 'CapabilityArn' => [ 'type' => 'string', ], 'CapabilityArnList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CapabilityArn', ], 'max' => 20, 'min' => 1, ], 'CapabilityHealth' => [ 'type' => 'string', 'enum' => [ 'HEALTHY', 'UNHEALTHY', ], ], 'CapabilityHealthReason' => [ 'type' => 'string', 'enum' => [ 'NO_REGISTERED_AGENT', 'INVALID_IP_OWNERSHIP', 'NOT_AUTHORIZED_TO_CREATE_SLR', 'UNVERIFIED_IP_OWNERSHIP', 'INITIALIZING_DATAPLANE', 'DATAPLANE_FAILURE', 'HEALTHY', ], ], 'CapabilityHealthReasonList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CapabilityHealthReason', ], 'max' => 500, 'min' => 0, ], 'ComponentStatusData' => [ 'type' => 'structure', 'required' => [ 'componentType', 'capabilityArn', 'status', 'dataflowId', ], 'members' => [ 'componentType' => [ 'shape' => 'ComponentTypeString', ], 'capabilityArn' => [ 'shape' => 'CapabilityArn', ], 'status' => [ 'shape' => 'AgentStatus', ], 'bytesSent' => [ 'shape' => 'Long', ], 'bytesReceived' => [ 'shape' => 'Long', ], 'packetsDropped' => [ 'shape' => 'Long', ], 'dataflowId' => [ 'shape' => 'Uuid', ], ], ], 'ComponentStatusList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ComponentStatusData', ], 'max' => 20, 'min' => 0, ], 'ComponentTypeString' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_]{1,64}', ], 'ComponentVersion' => [ 'type' => 'structure', 'required' => [ 'componentType', 'versions', ], 'members' => [ 'componentType' => [ 'shape' => 'ComponentTypeString', ], 'versions' => [ 'shape' => 'VersionStringList', ], ], ], 'ComponentVersionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ComponentVersion', ], 'max' => 20, 'min' => 1, ], 'ConfigArn' => [ 'type' => 'string', 'max' => 424, 'min' => 82, 'pattern' => 'arn:aws:groundstation:[-a-z0-9]{1,50}:[0-9]{12}:config/[a-z0-9]+(-[a-z0-9]+){0,4}/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}(/.{1,256})?', ], 'ConfigCapabilityType' => [ 'type' => 'string', 'enum' => [ 'antenna-downlink', 'antenna-downlink-demod-decode', 'tracking', 'dataflow-endpoint', 'antenna-uplink', 'uplink-echo', 's3-recording', ], ], 'ConfigDetails' => [ 'type' => 'structure', 'members' => [ 'endpointDetails' => [ 'shape' => 'EndpointDetails', ], 'antennaDemodDecodeDetails' => [ 'shape' => 'AntennaDemodDecodeDetails', ], 's3RecordingDetails' => [ 'shape' => 'S3RecordingDetails', ], ], 'union' => true, ], 'ConfigIdResponse' => [ 'type' => 'structure', 'members' => [ 'configId' => [ 'shape' => 'String', ], 'configType' => [ 'shape' => 'ConfigCapabilityType', ], 'configArn' => [ 'shape' => 'ConfigArn', ], ], ], 'ConfigList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConfigListItem', ], ], 'ConfigListItem' => [ 'type' => 'structure', 'members' => [ 'configId' => [ 'shape' => 'String', ], 'configType' => [ 'shape' => 'ConfigCapabilityType', ], 'configArn' => [ 'shape' => 'ConfigArn', ], 'name' => [ 'shape' => 'String', ], ], ], 'ConfigTypeData' => [ 'type' => 'structure', 'members' => [ 'antennaDownlinkConfig' => [ 'shape' => 'AntennaDownlinkConfig', ], 'trackingConfig' => [ 'shape' => 'TrackingConfig', ], 'dataflowEndpointConfig' => [ 'shape' => 'DataflowEndpointConfig', ], 'antennaDownlinkDemodDecodeConfig' => [ 'shape' => 'AntennaDownlinkDemodDecodeConfig', ], 'antennaUplinkConfig' => [ 'shape' => 'AntennaUplinkConfig', ], 'uplinkEchoConfig' => [ 'shape' => 'UplinkEchoConfig', ], 's3RecordingConfig' => [ 'shape' => 'S3RecordingConfig', ], ], 'union' => true, ], 'ConnectionDetails' => [ 'type' => 'structure', 'required' => [ 'socketAddress', ], 'members' => [ 'socketAddress' => [ 'shape' => 'SocketAddress', ], 'mtu' => [ 'shape' => 'Integer', ], ], ], 'ContactData' => [ 'type' => 'structure', 'members' => [ 'contactId' => [ 'shape' => 'Uuid', ], 'missionProfileArn' => [ 'shape' => 'MissionProfileArn', ], 'satelliteArn' => [ 'shape' => 'satelliteArn', ], 'startTime' => [ 'shape' => 'Timestamp', ], 'endTime' => [ 'shape' => 'Timestamp', ], 'prePassStartTime' => [ 'shape' => 'Timestamp', ], 'postPassEndTime' => [ 'shape' => 'Timestamp', ], 'groundStation' => [ 'shape' => 'String', ], 'contactStatus' => [ 'shape' => 'ContactStatus', ], 'errorMessage' => [ 'shape' => 'String', ], 'maximumElevation' => [ 'shape' => 'Elevation', ], 'region' => [ 'shape' => 'String', ], 'tags' => [ 'shape' => 'TagsMap', ], 'visibilityStartTime' => [ 'shape' => 'Timestamp', ], 'visibilityEndTime' => [ 'shape' => 'Timestamp', ], 'ephemeris' => [ 'shape' => 'EphemerisResponseData', ], ], ], 'ContactIdResponse' => [ 'type' => 'structure', 'members' => [ 'contactId' => [ 'shape' => 'Uuid', ], ], ], 'ContactList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ContactData', ], ], 'ContactStatus' => [ 'type' => 'string', 'enum' => [ 'SCHEDULING', 'FAILED_TO_SCHEDULE', 'SCHEDULED', 'CANCELLED', 'AWS_CANCELLED', 'PREPASS', 'PASS', 'POSTPASS', 'COMPLETED', 'FAILED', 'AVAILABLE', 'CANCELLING', 'AWS_FAILED', ], ], 'CreateConfigRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'configData', ], 'members' => [ 'name' => [ 'shape' => 'SafeName', ], 'configData' => [ 'shape' => 'ConfigTypeData', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateDataflowEndpointGroupRequest' => [ 'type' => 'structure', 'required' => [ 'endpointDetails', ], 'members' => [ 'endpointDetails' => [ 'shape' => 'EndpointDetailsList', ], 'tags' => [ 'shape' => 'TagsMap', ], 'contactPrePassDurationSeconds' => [ 'shape' => 'DataflowEndpointGroupDurationInSeconds', ], 'contactPostPassDurationSeconds' => [ 'shape' => 'DataflowEndpointGroupDurationInSeconds', ], ], ], 'CreateDataflowEndpointGroupV2Request' => [ 'type' => 'structure', 'required' => [ 'endpoints', ], 'members' => [ 'endpoints' => [ 'shape' => 'CreateEndpointDetailsList', ], 'contactPrePassDurationSeconds' => [ 'shape' => 'DataflowEndpointGroupDurationInSeconds', ], 'contactPostPassDurationSeconds' => [ 'shape' => 'DataflowEndpointGroupDurationInSeconds', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateDataflowEndpointGroupV2Response' => [ 'type' => 'structure', 'members' => [ 'dataflowEndpointGroupId' => [ 'shape' => 'Uuid', ], ], ], 'CreateEndpointDetails' => [ 'type' => 'structure', 'members' => [ 'uplinkAwsGroundStationAgentEndpoint' => [ 'shape' => 'UplinkAwsGroundStationAgentEndpoint', ], 'downlinkAwsGroundStationAgentEndpoint' => [ 'shape' => 'DownlinkAwsGroundStationAgentEndpoint', ], ], 'union' => true, ], 'CreateEndpointDetailsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CreateEndpointDetails', ], 'max' => 12, 'min' => 1, ], 'CreateEphemerisRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'satelliteId' => [ 'shape' => 'Uuid', ], 'enabled' => [ 'shape' => 'Boolean', ], 'priority' => [ 'shape' => 'CustomerEphemerisPriority', ], 'expirationTime' => [ 'shape' => 'Timestamp', ], 'name' => [ 'shape' => 'SafeName', ], 'kmsKeyArn' => [ 'shape' => 'KeyArn', ], 'ephemeris' => [ 'shape' => 'EphemerisData', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateMissionProfileRequest' => [ 'type' => 'structure', 'required' => [ 'name', 'minimumViableContactDurationSeconds', 'dataflowEdges', 'trackingConfigArn', ], 'members' => [ 'name' => [ 'shape' => 'SafeName', ], 'contactPrePassDurationSeconds' => [ 'shape' => 'DurationInSeconds', ], 'contactPostPassDurationSeconds' => [ 'shape' => 'DurationInSeconds', ], 'minimumViableContactDurationSeconds' => [ 'shape' => 'PositiveDurationInSeconds', ], 'dataflowEdges' => [ 'shape' => 'DataflowEdgeList', ], 'trackingConfigArn' => [ 'shape' => 'ConfigArn', ], 'tags' => [ 'shape' => 'TagsMap', ], 'streamsKmsKey' => [ 'shape' => 'KmsKey', ], 'streamsKmsRole' => [ 'shape' => 'RoleArn', ], ], ], 'Criticality' => [ 'type' => 'string', 'enum' => [ 'REQUIRED', 'PREFERRED', 'REMOVED', ], ], 'CustomerEphemerisPriority' => [ 'type' => 'integer', 'box' => true, 'max' => 99999, 'min' => 1, ], 'DataflowDetail' => [ 'type' => 'structure', 'members' => [ 'source' => [ 'shape' => 'Source', ], 'destination' => [ 'shape' => 'Destination', ], 'errorMessage' => [ 'shape' => 'String', ], ], ], 'DataflowEdge' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConfigArn', ], 'max' => 2, 'min' => 2, ], 'DataflowEdgeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataflowEdge', ], 'max' => 500, 'min' => 0, ], 'DataflowEndpoint' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'SafeName', ], 'address' => [ 'shape' => 'SocketAddress', ], 'status' => [ 'shape' => 'EndpointStatus', ], 'mtu' => [ 'shape' => 'DataflowEndpointMtuInteger', ], ], ], 'DataflowEndpointConfig' => [ 'type' => 'structure', 'required' => [ 'dataflowEndpointName', ], 'members' => [ 'dataflowEndpointName' => [ 'shape' => 'String', ], 'dataflowEndpointRegion' => [ 'shape' => 'String', ], ], ], 'DataflowEndpointGroupArn' => [ 'type' => 'string', 'max' => 146, 'min' => 97, 'pattern' => 'arn:aws:groundstation:[-a-z0-9]{1,50}:[0-9]{12}:dataflow-endpoint-group/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}', ], 'DataflowEndpointGroupDurationInSeconds' => [ 'type' => 'integer', 'box' => true, 'max' => 480, 'min' => 30, ], 'DataflowEndpointGroupIdResponse' => [ 'type' => 'structure', 'members' => [ 'dataflowEndpointGroupId' => [ 'shape' => 'Uuid', ], ], ], 'DataflowEndpointGroupList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataflowEndpointListItem', ], ], 'DataflowEndpointListItem' => [ 'type' => 'structure', 'members' => [ 'dataflowEndpointGroupId' => [ 'shape' => 'Uuid', ], 'dataflowEndpointGroupArn' => [ 'shape' => 'DataflowEndpointGroupArn', ], ], ], 'DataflowEndpointMtuInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 1500, 'min' => 1400, ], 'DataflowList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataflowDetail', ], ], 'DecodeConfig' => [ 'type' => 'structure', 'required' => [ 'unvalidatedJSON', ], 'members' => [ 'unvalidatedJSON' => [ 'shape' => 'JsonString', ], ], ], 'DeleteConfigRequest' => [ 'type' => 'structure', 'required' => [ 'configId', 'configType', ], 'members' => [ 'configId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'configId', ], 'configType' => [ 'shape' => 'ConfigCapabilityType', 'location' => 'uri', 'locationName' => 'configType', ], ], ], 'DeleteDataflowEndpointGroupRequest' => [ 'type' => 'structure', 'required' => [ 'dataflowEndpointGroupId', ], 'members' => [ 'dataflowEndpointGroupId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'dataflowEndpointGroupId', ], ], ], 'DeleteEphemerisRequest' => [ 'type' => 'structure', 'required' => [ 'ephemerisId', ], 'members' => [ 'ephemerisId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'ephemerisId', ], ], ], 'DeleteMissionProfileRequest' => [ 'type' => 'structure', 'required' => [ 'missionProfileId', ], 'members' => [ 'missionProfileId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'missionProfileId', ], ], ], 'DemodulationConfig' => [ 'type' => 'structure', 'required' => [ 'unvalidatedJSON', ], 'members' => [ 'unvalidatedJSON' => [ 'shape' => 'JsonString', ], ], ], 'DependencyException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], 'parameterName' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 531, ], 'exception' => true, 'fault' => true, ], 'DescribeContactRequest' => [ 'type' => 'structure', 'required' => [ 'contactId', ], 'members' => [ 'contactId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'contactId', ], ], ], 'DescribeContactResponse' => [ 'type' => 'structure', 'members' => [ 'contactId' => [ 'shape' => 'Uuid', ], 'missionProfileArn' => [ 'shape' => 'MissionProfileArn', ], 'satelliteArn' => [ 'shape' => 'satelliteArn', ], 'startTime' => [ 'shape' => 'Timestamp', ], 'endTime' => [ 'shape' => 'Timestamp', ], 'prePassStartTime' => [ 'shape' => 'Timestamp', ], 'postPassEndTime' => [ 'shape' => 'Timestamp', ], 'groundStation' => [ 'shape' => 'String', ], 'contactStatus' => [ 'shape' => 'ContactStatus', ], 'errorMessage' => [ 'shape' => 'String', ], 'maximumElevation' => [ 'shape' => 'Elevation', ], 'tags' => [ 'shape' => 'TagsMap', ], 'region' => [ 'shape' => 'String', ], 'dataflowList' => [ 'shape' => 'DataflowList', ], 'visibilityStartTime' => [ 'shape' => 'Timestamp', ], 'visibilityEndTime' => [ 'shape' => 'Timestamp', ], 'trackingOverrides' => [ 'shape' => 'TrackingOverrides', ], 'ephemeris' => [ 'shape' => 'EphemerisResponseData', ], ], ], 'DescribeEphemerisRequest' => [ 'type' => 'structure', 'required' => [ 'ephemerisId', ], 'members' => [ 'ephemerisId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'ephemerisId', ], ], ], 'DescribeEphemerisResponse' => [ 'type' => 'structure', 'members' => [ 'ephemerisId' => [ 'shape' => 'Uuid', ], 'satelliteId' => [ 'shape' => 'Uuid', ], 'status' => [ 'shape' => 'EphemerisStatus', ], 'priority' => [ 'shape' => 'EphemerisPriority', ], 'creationTime' => [ 'shape' => 'Timestamp', ], 'enabled' => [ 'shape' => 'Boolean', ], 'name' => [ 'shape' => 'SafeName', ], 'tags' => [ 'shape' => 'TagsMap', ], 'suppliedData' => [ 'shape' => 'EphemerisTypeDescription', ], 'invalidReason' => [ 'shape' => 'EphemerisInvalidReason', ], 'errorReasons' => [ 'shape' => 'EphemerisErrorReasonList', ], ], ], 'Destination' => [ 'type' => 'structure', 'members' => [ 'configType' => [ 'shape' => 'ConfigCapabilityType', ], 'configId' => [ 'shape' => 'Uuid', ], 'configDetails' => [ 'shape' => 'ConfigDetails', ], 'dataflowDestinationRegion' => [ 'shape' => 'String', ], ], ], 'DiscoveryData' => [ 'type' => 'structure', 'required' => [ 'publicIpAddresses', 'privateIpAddresses', 'capabilityArns', ], 'members' => [ 'publicIpAddresses' => [ 'shape' => 'IpAddressList', ], 'privateIpAddresses' => [ 'shape' => 'IpAddressList', ], 'capabilityArns' => [ 'shape' => 'CapabilityArnList', ], ], ], 'Double' => [ 'type' => 'double', 'box' => true, ], 'DownlinkAwsGroundStationAgentEndpoint' => [ 'type' => 'structure', 'required' => [ 'name', 'dataflowDetails', ], 'members' => [ 'name' => [ 'shape' => 'SafeName', ], 'dataflowDetails' => [ 'shape' => 'DownlinkDataflowDetails', ], ], ], 'DownlinkAwsGroundStationAgentEndpointDetails' => [ 'type' => 'structure', 'required' => [ 'name', 'dataflowDetails', ], 'members' => [ 'name' => [ 'shape' => 'SafeName', ], 'dataflowDetails' => [ 'shape' => 'DownlinkDataflowDetails', ], 'agentStatus' => [ 'shape' => 'AgentStatus', ], 'auditResults' => [ 'shape' => 'AuditResults', ], ], ], 'DownlinkConnectionDetails' => [ 'type' => 'structure', 'required' => [ 'agentIpAndPortAddress', 'egressAddressAndPort', ], 'members' => [ 'agentIpAndPortAddress' => [ 'shape' => 'RangedConnectionDetails', ], 'egressAddressAndPort' => [ 'shape' => 'ConnectionDetails', ], ], ], 'DownlinkDataflowDetails' => [ 'type' => 'structure', 'members' => [ 'agentConnectionDetails' => [ 'shape' => 'DownlinkConnectionDetails', ], ], 'union' => true, ], 'DurationInSeconds' => [ 'type' => 'integer', 'box' => true, 'max' => 21600, 'min' => 0, ], 'Eirp' => [ 'type' => 'structure', 'required' => [ 'value', 'units', ], 'members' => [ 'value' => [ 'shape' => 'Double', ], 'units' => [ 'shape' => 'EirpUnits', ], ], ], 'EirpUnits' => [ 'type' => 'string', 'enum' => [ 'dBW', ], ], 'Elevation' => [ 'type' => 'structure', 'required' => [ 'value', 'unit', ], 'members' => [ 'value' => [ 'shape' => 'Double', ], 'unit' => [ 'shape' => 'AngleUnits', ], ], ], 'EndpointDetails' => [ 'type' => 'structure', 'members' => [ 'securityDetails' => [ 'shape' => 'SecurityDetails', ], 'endpoint' => [ 'shape' => 'DataflowEndpoint', ], 'awsGroundStationAgentEndpoint' => [ 'shape' => 'AwsGroundStationAgentEndpoint', ], 'uplinkAwsGroundStationAgentEndpoint' => [ 'shape' => 'UplinkAwsGroundStationAgentEndpointDetails', ], 'downlinkAwsGroundStationAgentEndpoint' => [ 'shape' => 'DownlinkAwsGroundStationAgentEndpointDetails', ], 'healthStatus' => [ 'shape' => 'CapabilityHealth', ], 'healthReasons' => [ 'shape' => 'CapabilityHealthReasonList', ], ], ], 'EndpointDetailsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EndpointDetails', ], 'max' => 500, 'min' => 0, ], 'EndpointStatus' => [ 'type' => 'string', 'enum' => [ 'created', 'creating', 'deleted', 'deleting', 'failed', ], ], 'EphemeridesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EphemerisItem', ], 'max' => 500, 'min' => 1, ], 'EphemerisData' => [ 'type' => 'structure', 'members' => [ 'tle' => [ 'shape' => 'TLEEphemeris', ], 'oem' => [ 'shape' => 'OEMEphemeris', ], 'azEl' => [ 'shape' => 'AzElEphemeris', ], ], 'union' => true, ], 'EphemerisDescription' => [ 'type' => 'structure', 'members' => [ 'sourceS3Object' => [ 'shape' => 'S3Object', ], 'ephemerisData' => [ 'shape' => 'UnboundedString', ], ], ], 'EphemerisErrorCode' => [ 'type' => 'string', 'enum' => [ 'INTERNAL_ERROR', 'MISMATCHED_SATCAT_ID', 'OEM_VERSION_UNSUPPORTED', 'ORIGINATOR_MISSING', 'CREATION_DATE_MISSING', 'OBJECT_NAME_MISSING', 'OBJECT_ID_MISSING', 'REF_FRAME_UNSUPPORTED', 'REF_FRAME_EPOCH_UNSUPPORTED', 'TIME_SYSTEM_UNSUPPORTED', 'CENTER_BODY_UNSUPPORTED', 'INTERPOLATION_MISSING', 'INTERPOLATION_DEGREE_INVALID', 'AZ_EL_SEGMENT_LIST_MISSING', 'INSUFFICIENT_TIME_AZ_EL', 'START_TIME_IN_FUTURE', 'END_TIME_IN_PAST', 'EXPIRATION_TIME_TOO_EARLY', 'START_TIME_METADATA_TOO_EARLY', 'STOP_TIME_METADATA_TOO_LATE', 'AZ_EL_SEGMENT_END_TIME_BEFORE_START_TIME', 'AZ_EL_SEGMENT_TIMES_OVERLAP', 'AZ_EL_SEGMENTS_OUT_OF_ORDER', 'TIME_AZ_EL_ITEMS_OUT_OF_ORDER', 'MEAN_MOTION_INVALID', 'TIME_AZ_EL_AZ_RADIAN_RANGE_INVALID', 'TIME_AZ_EL_EL_RADIAN_RANGE_INVALID', 'TIME_AZ_EL_AZ_DEGREE_RANGE_INVALID', 'TIME_AZ_EL_EL_DEGREE_RANGE_INVALID', 'TIME_AZ_EL_ANGLE_UNITS_INVALID', 'INSUFFICIENT_KMS_PERMISSIONS', 'FILE_FORMAT_INVALID', 'AZ_EL_SEGMENT_REFERENCE_EPOCH_INVALID', 'AZ_EL_SEGMENT_START_TIME_INVALID', 'AZ_EL_SEGMENT_END_TIME_INVALID', 'AZ_EL_SEGMENT_VALID_TIME_RANGE_INVALID', 'AZ_EL_SEGMENT_END_TIME_TOO_LATE', 'AZ_EL_TOTAL_DURATION_EXCEEDED', ], ], 'EphemerisErrorReason' => [ 'type' => 'structure', 'required' => [ 'errorCode', 'errorMessage', ], 'members' => [ 'errorCode' => [ 'shape' => 'EphemerisErrorCode', ], 'errorMessage' => [ 'shape' => 'ErrorString', ], ], ], 'EphemerisErrorReasonList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EphemerisErrorReason', ], 'max' => 50, 'min' => 1, ], 'EphemerisFilter' => [ 'type' => 'structure', 'members' => [ 'azEl' => [ 'shape' => 'AzElEphemerisFilter', ], ], 'union' => true, ], 'EphemerisIdResponse' => [ 'type' => 'structure', 'members' => [ 'ephemerisId' => [ 'shape' => 'Uuid', ], ], ], 'EphemerisInvalidReason' => [ 'type' => 'string', 'enum' => [ 'METADATA_INVALID', 'TIME_RANGE_INVALID', 'TRAJECTORY_INVALID', 'KMS_KEY_INVALID', 'VALIDATION_ERROR', ], ], 'EphemerisItem' => [ 'type' => 'structure', 'members' => [ 'ephemerisId' => [ 'shape' => 'Uuid', ], 'ephemerisType' => [ 'shape' => 'EphemerisType', ], 'status' => [ 'shape' => 'EphemerisStatus', ], 'priority' => [ 'shape' => 'EphemerisPriority', ], 'enabled' => [ 'shape' => 'Boolean', ], 'creationTime' => [ 'shape' => 'Timestamp', ], 'name' => [ 'shape' => 'SafeName', ], 'sourceS3Object' => [ 'shape' => 'S3Object', ], ], ], 'EphemerisMetaData' => [ 'type' => 'structure', 'required' => [ 'source', ], 'members' => [ 'source' => [ 'shape' => 'EphemerisSource', ], 'ephemerisId' => [ 'shape' => 'Uuid', ], 'epoch' => [ 'shape' => 'Timestamp', ], 'name' => [ 'shape' => 'SafeName', ], ], ], 'EphemerisPriority' => [ 'type' => 'integer', 'box' => true, 'max' => 99999, 'min' => 0, ], 'EphemerisResponseData' => [ 'type' => 'structure', 'required' => [ 'ephemerisType', ], 'members' => [ 'ephemerisId' => [ 'shape' => 'Uuid', ], 'ephemerisType' => [ 'shape' => 'EphemerisType', ], ], ], 'EphemerisSource' => [ 'type' => 'string', 'enum' => [ 'CUSTOMER_PROVIDED', 'SPACE_TRACK', ], ], 'EphemerisStatus' => [ 'type' => 'string', 'enum' => [ 'VALIDATING', 'INVALID', 'ERROR', 'ENABLED', 'DISABLED', 'EXPIRED', ], ], 'EphemerisStatusList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EphemerisStatus', ], 'max' => 500, 'min' => 0, ], 'EphemerisType' => [ 'type' => 'string', 'enum' => [ 'TLE', 'OEM', 'AZ_EL', 'SERVICE_MANAGED', ], ], 'EphemerisTypeDescription' => [ 'type' => 'structure', 'members' => [ 'tle' => [ 'shape' => 'EphemerisDescription', ], 'oem' => [ 'shape' => 'EphemerisDescription', ], 'azEl' => [ 'shape' => 'EphemerisDescription', ], ], 'union' => true, ], 'ErrorString' => [ 'type' => 'string', 'max' => 1000, 'min' => 0, ], 'Frequency' => [ 'type' => 'structure', 'required' => [ 'value', 'units', ], 'members' => [ 'value' => [ 'shape' => 'Double', ], 'units' => [ 'shape' => 'FrequencyUnits', ], ], ], 'FrequencyBandwidth' => [ 'type' => 'structure', 'required' => [ 'value', 'units', ], 'members' => [ 'value' => [ 'shape' => 'Double', ], 'units' => [ 'shape' => 'BandwidthUnits', ], ], ], 'FrequencyUnits' => [ 'type' => 'string', 'enum' => [ 'GHz', 'MHz', 'kHz', ], ], 'GetAgentConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', ], 'members' => [ 'agentId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'agentId', ], ], ], 'GetAgentConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'agentId' => [ 'shape' => 'Uuid', ], 'taskingDocument' => [ 'shape' => 'String', ], ], ], 'GetAgentTaskResponseUrlRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'taskId', ], 'members' => [ 'agentId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'agentId', ], 'taskId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'taskId', ], ], ], 'GetAgentTaskResponseUrlResponse' => [ 'type' => 'structure', 'required' => [ 'agentId', 'taskId', 'presignedLogUrl', ], 'members' => [ 'agentId' => [ 'shape' => 'Uuid', ], 'taskId' => [ 'shape' => 'Uuid', ], 'presignedLogUrl' => [ 'shape' => 'String', ], ], ], 'GetConfigRequest' => [ 'type' => 'structure', 'required' => [ 'configId', 'configType', ], 'members' => [ 'configId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'configId', ], 'configType' => [ 'shape' => 'ConfigCapabilityType', 'location' => 'uri', 'locationName' => 'configType', ], ], ], 'GetConfigResponse' => [ 'type' => 'structure', 'required' => [ 'configId', 'configArn', 'name', 'configData', ], 'members' => [ 'configId' => [ 'shape' => 'String', ], 'configArn' => [ 'shape' => 'ConfigArn', ], 'name' => [ 'shape' => 'String', ], 'configType' => [ 'shape' => 'ConfigCapabilityType', ], 'configData' => [ 'shape' => 'ConfigTypeData', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'GetDataflowEndpointGroupRequest' => [ 'type' => 'structure', 'required' => [ 'dataflowEndpointGroupId', ], 'members' => [ 'dataflowEndpointGroupId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'dataflowEndpointGroupId', ], ], ], 'GetDataflowEndpointGroupResponse' => [ 'type' => 'structure', 'members' => [ 'dataflowEndpointGroupId' => [ 'shape' => 'Uuid', ], 'dataflowEndpointGroupArn' => [ 'shape' => 'DataflowEndpointGroupArn', ], 'endpointsDetails' => [ 'shape' => 'EndpointDetailsList', ], 'tags' => [ 'shape' => 'TagsMap', ], 'contactPrePassDurationSeconds' => [ 'shape' => 'DataflowEndpointGroupDurationInSeconds', ], 'contactPostPassDurationSeconds' => [ 'shape' => 'DataflowEndpointGroupDurationInSeconds', ], ], ], 'GetMinuteUsageRequest' => [ 'type' => 'structure', 'required' => [ 'month', 'year', ], 'members' => [ 'month' => [ 'shape' => 'Month', ], 'year' => [ 'shape' => 'Year', ], ], ], 'GetMinuteUsageResponse' => [ 'type' => 'structure', 'members' => [ 'isReservedMinutesCustomer' => [ 'shape' => 'Boolean', ], 'totalReservedMinuteAllocation' => [ 'shape' => 'Integer', ], 'upcomingMinutesScheduled' => [ 'shape' => 'Integer', ], 'totalScheduledMinutes' => [ 'shape' => 'Integer', ], 'estimatedMinutesRemaining' => [ 'shape' => 'Integer', ], ], ], 'GetMissionProfileRequest' => [ 'type' => 'structure', 'required' => [ 'missionProfileId', ], 'members' => [ 'missionProfileId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'missionProfileId', ], ], ], 'GetMissionProfileResponse' => [ 'type' => 'structure', 'members' => [ 'missionProfileId' => [ 'shape' => 'Uuid', ], 'missionProfileArn' => [ 'shape' => 'MissionProfileArn', ], 'name' => [ 'shape' => 'SafeName', ], 'region' => [ 'shape' => 'AWSRegion', ], 'contactPrePassDurationSeconds' => [ 'shape' => 'DurationInSeconds', ], 'contactPostPassDurationSeconds' => [ 'shape' => 'DurationInSeconds', ], 'minimumViableContactDurationSeconds' => [ 'shape' => 'PositiveDurationInSeconds', ], 'dataflowEdges' => [ 'shape' => 'DataflowEdgeList', ], 'trackingConfigArn' => [ 'shape' => 'ConfigArn', ], 'tags' => [ 'shape' => 'TagsMap', ], 'streamsKmsKey' => [ 'shape' => 'KmsKey', ], 'streamsKmsRole' => [ 'shape' => 'RoleArn', ], ], ], 'GetSatelliteRequest' => [ 'type' => 'structure', 'required' => [ 'satelliteId', ], 'members' => [ 'satelliteId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'satelliteId', ], ], ], 'GetSatelliteResponse' => [ 'type' => 'structure', 'members' => [ 'satelliteId' => [ 'shape' => 'Uuid', ], 'satelliteArn' => [ 'shape' => 'satelliteArn', ], 'noradSatelliteID' => [ 'shape' => 'noradSatelliteID', ], 'groundStations' => [ 'shape' => 'GroundStationIdList', ], 'currentEphemeris' => [ 'shape' => 'EphemerisMetaData', ], ], ], 'GroundStationData' => [ 'type' => 'structure', 'members' => [ 'groundStationId' => [ 'shape' => 'GroundStationName', ], 'groundStationName' => [ 'shape' => 'GroundStationName', ], 'region' => [ 'shape' => 'AWSRegion', ], ], ], 'GroundStationIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GroundStationName', ], 'max' => 500, 'min' => 0, ], 'GroundStationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GroundStationData', ], ], 'GroundStationName' => [ 'type' => 'string', 'max' => 500, 'min' => 4, 'pattern' => '[ a-zA-Z0-9-._:=]{4,256}', ], 'ISO8601TimeRange' => [ 'type' => 'structure', 'required' => [ 'startTime', 'endTime', ], 'members' => [ 'startTime' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'endTime' => [ 'shape' => 'SyntheticTimestamp_date_time', ], ], ], 'InstanceId' => [ 'type' => 'string', 'max' => 64, 'min' => 10, 'pattern' => '[a-z0-9-]{10,64}', ], 'InstanceType' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[a-z0-9.-]{1,64}', ], 'Integer' => [ 'type' => 'integer', 'box' => true, ], 'IntegerRange' => [ 'type' => 'structure', 'required' => [ 'minimum', 'maximum', ], 'members' => [ 'minimum' => [ 'shape' => 'Integer', ], 'maximum' => [ 'shape' => 'Integer', ], ], ], 'InvalidParameterException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], 'parameterName' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 431, 'senderFault' => true, ], 'exception' => true, ], 'IpAddressList' => [ 'type' => 'list', 'member' => [ 'shape' => 'IpV4Address', ], 'max' => 20, 'min' => 1, ], 'IpV4Address' => [ 'type' => 'string', 'max' => 16, 'min' => 7, 'pattern' => '\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}', ], 'JsonString' => [ 'type' => 'string', 'max' => 8192, 'min' => 2, 'pattern' => '[{}\\[\\]:.,"0-9A-Za-z\\-_\\s]{2,8192}', ], 'KeyAliasArn' => [ 'type' => 'string', 'max' => 512, 'min' => 1, 'pattern' => 'arn:aws[a-zA-Z-]{0,16}:kms:[-a-z0-9]{1,50}:[0-9]{12}:((alias/[a-zA-Z0-9:/_-]{1,256}))', ], 'KeyAliasName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => 'alias/[a-zA-Z0-9:/_-]+', ], 'KeyArn' => [ 'type' => 'string', ], 'KmsKey' => [ 'type' => 'structure', 'members' => [ 'kmsKeyArn' => [ 'shape' => 'KeyArn', ], 'kmsAliasArn' => [ 'shape' => 'KeyAliasArn', ], 'kmsAliasName' => [ 'shape' => 'KeyAliasName', ], ], 'union' => true, ], 'ListConfigsRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'PaginationMaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListConfigsResponse' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'PaginationToken', ], 'configList' => [ 'shape' => 'ConfigList', ], ], ], 'ListContactsRequest' => [ 'type' => 'structure', 'required' => [ 'statusList', 'startTime', 'endTime', ], 'members' => [ 'maxResults' => [ 'shape' => 'PaginationMaxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], 'statusList' => [ 'shape' => 'StatusList', ], 'startTime' => [ 'shape' => 'Timestamp', ], 'endTime' => [ 'shape' => 'Timestamp', ], 'groundStation' => [ 'shape' => 'GroundStationName', ], 'satelliteArn' => [ 'shape' => 'satelliteArn', ], 'missionProfileArn' => [ 'shape' => 'MissionProfileArn', ], 'ephemeris' => [ 'shape' => 'EphemerisFilter', ], ], ], 'ListContactsResponse' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'PaginationToken', ], 'contactList' => [ 'shape' => 'ContactList', ], ], ], 'ListDataflowEndpointGroupsRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'PaginationMaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListDataflowEndpointGroupsResponse' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'PaginationToken', ], 'dataflowEndpointGroupList' => [ 'shape' => 'DataflowEndpointGroupList', ], ], ], 'ListEphemeridesRequest' => [ 'type' => 'structure', 'required' => [ 'startTime', 'endTime', ], 'members' => [ 'satelliteId' => [ 'shape' => 'Uuid', ], 'ephemerisType' => [ 'shape' => 'EphemerisType', ], 'startTime' => [ 'shape' => 'Timestamp', ], 'endTime' => [ 'shape' => 'Timestamp', ], 'statusList' => [ 'shape' => 'EphemerisStatusList', ], 'maxResults' => [ 'shape' => 'PaginationMaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListEphemeridesResponse' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'PaginationToken', ], 'ephemerides' => [ 'shape' => 'EphemeridesList', ], ], ], 'ListGroundStationsRequest' => [ 'type' => 'structure', 'members' => [ 'satelliteId' => [ 'shape' => 'Uuid', 'location' => 'querystring', 'locationName' => 'satelliteId', ], 'maxResults' => [ 'shape' => 'PaginationMaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListGroundStationsResponse' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'PaginationToken', ], 'groundStationList' => [ 'shape' => 'GroundStationList', ], ], ], 'ListMissionProfilesRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'PaginationMaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListMissionProfilesResponse' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'PaginationToken', ], 'missionProfileList' => [ 'shape' => 'MissionProfileList', ], ], ], 'ListSatellitesRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'PaginationMaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListSatellitesResponse' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'PaginationToken', ], 'satellites' => [ 'shape' => 'SatelliteList', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'AnyArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'Long' => [ 'type' => 'long', 'box' => true, ], 'MissionProfileArn' => [ 'type' => 'string', 'max' => 138, 'min' => 89, 'pattern' => 'arn:aws:groundstation:[-a-z0-9]{1,50}:[0-9]{12}:mission-profile/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}', ], 'MissionProfileIdResponse' => [ 'type' => 'structure', 'members' => [ 'missionProfileId' => [ 'shape' => 'Uuid', ], ], ], 'MissionProfileList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MissionProfileListItem', ], ], 'MissionProfileListItem' => [ 'type' => 'structure', 'members' => [ 'missionProfileId' => [ 'shape' => 'Uuid', ], 'missionProfileArn' => [ 'shape' => 'MissionProfileArn', ], 'region' => [ 'shape' => 'AWSRegion', ], 'name' => [ 'shape' => 'SafeName', ], ], ], 'Month' => [ 'type' => 'integer', 'box' => true, 'max' => 12, 'min' => 1, ], 'OEMEphemeris' => [ 'type' => 'structure', 'members' => [ 's3Object' => [ 'shape' => 'S3Object', ], 'oemData' => [ 'shape' => 'UnboundedString', ], ], ], 'PaginationMaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'PaginationToken' => [ 'type' => 'string', 'max' => 1000, 'min' => 3, 'pattern' => '[A-Za-z0-9-/+_.=]+', ], 'Polarization' => [ 'type' => 'string', 'enum' => [ 'RIGHT_HAND', 'LEFT_HAND', 'NONE', ], ], 'PositiveDurationInSeconds' => [ 'type' => 'integer', 'box' => true, 'max' => 21600, 'min' => 1, ], 'ProgramTrackSettings' => [ 'type' => 'structure', 'members' => [ 'azEl' => [ 'shape' => 'AzElProgramTrackSettings', ], ], 'union' => true, ], 'RangedConnectionDetails' => [ 'type' => 'structure', 'required' => [ 'socketAddress', ], 'members' => [ 'socketAddress' => [ 'shape' => 'RangedSocketAddress', ], 'mtu' => [ 'shape' => 'RangedConnectionDetailsMtuInteger', ], ], ], 'RangedConnectionDetailsMtuInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 1500, 'min' => 1400, ], 'RangedSocketAddress' => [ 'type' => 'structure', 'required' => [ 'name', 'portRange', ], 'members' => [ 'name' => [ 'shape' => 'IpV4Address', ], 'portRange' => [ 'shape' => 'IntegerRange', ], ], ], 'RegisterAgentRequest' => [ 'type' => 'structure', 'required' => [ 'discoveryData', 'agentDetails', ], 'members' => [ 'discoveryData' => [ 'shape' => 'DiscoveryData', ], 'agentDetails' => [ 'shape' => 'AgentDetails', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'RegisterAgentResponse' => [ 'type' => 'structure', 'members' => [ 'agentId' => [ 'shape' => 'Uuid', ], ], ], 'ReserveContactRequest' => [ 'type' => 'structure', 'required' => [ 'missionProfileArn', 'startTime', 'endTime', 'groundStation', ], 'members' => [ 'missionProfileArn' => [ 'shape' => 'MissionProfileArn', ], 'satelliteArn' => [ 'shape' => 'satelliteArn', ], 'startTime' => [ 'shape' => 'Timestamp', ], 'endTime' => [ 'shape' => 'Timestamp', ], 'groundStation' => [ 'shape' => 'GroundStationName', ], 'tags' => [ 'shape' => 'TagsMap', ], 'trackingOverrides' => [ 'shape' => 'TrackingOverrides', ], ], ], 'ResourceInUseException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'ResourceLimitExceededException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], 'parameterName' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 434, 'senderFault' => true, ], 'exception' => true, ], 'RoleArn' => [ 'type' => 'string', ], 'S3BucketName' => [ 'type' => 'string', 'max' => 63, 'min' => 3, 'pattern' => '[a-z0-9.-]{3,63}', ], 'S3KeyPrefix' => [ 'type' => 'string', 'max' => 900, 'min' => 1, 'pattern' => '([a-zA-Z0-9_\\-=/]|\\{satellite_id\\}|\\{config\\-name}|\\{s3\\-config-id}|\\{year\\}|\\{month\\}|\\{day\\}){1,900}', ], 'S3Object' => [ 'type' => 'structure', 'members' => [ 'bucket' => [ 'shape' => 'S3BucketName', ], 'key' => [ 'shape' => 'S3ObjectKey', ], 'version' => [ 'shape' => 'S3VersionId', ], ], ], 'S3ObjectKey' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => '[a-zA-Z0-9!*\'\\)\\(./_-]{1,1024}', ], 'S3RecordingConfig' => [ 'type' => 'structure', 'required' => [ 'bucketArn', 'roleArn', ], 'members' => [ 'bucketArn' => [ 'shape' => 'BucketArn', ], 'roleArn' => [ 'shape' => 'RoleArn', ], 'prefix' => [ 'shape' => 'S3KeyPrefix', ], ], ], 'S3RecordingDetails' => [ 'type' => 'structure', 'members' => [ 'bucketArn' => [ 'shape' => 'BucketArn', ], 'keyTemplate' => [ 'shape' => 'String', ], ], ], 'S3VersionId' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => '[\\s\\S]{1,1024}', ], 'SafeName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[ a-zA-Z0-9_:-]{1,256}', ], 'SatelliteList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SatelliteListItem', ], ], 'SatelliteListItem' => [ 'type' => 'structure', 'members' => [ 'satelliteId' => [ 'shape' => 'Uuid', ], 'satelliteArn' => [ 'shape' => 'satelliteArn', ], 'noradSatelliteID' => [ 'shape' => 'noradSatelliteID', ], 'groundStations' => [ 'shape' => 'GroundStationIdList', ], 'currentEphemeris' => [ 'shape' => 'EphemerisMetaData', ], ], ], 'SecurityDetails' => [ 'type' => 'structure', 'required' => [ 'subnetIds', 'securityGroupIds', 'roleArn', ], 'members' => [ 'subnetIds' => [ 'shape' => 'SubnetList', ], 'securityGroupIds' => [ 'shape' => 'SecurityGroupIdList', ], 'roleArn' => [ 'shape' => 'RoleArn', ], ], ], 'SecurityGroupIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], 'parameterName' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'SignatureMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'Boolean', ], ], 'SocketAddress' => [ 'type' => 'structure', 'required' => [ 'name', 'port', ], 'members' => [ 'name' => [ 'shape' => 'String', ], 'port' => [ 'shape' => 'Integer', ], ], ], 'Source' => [ 'type' => 'structure', 'members' => [ 'configType' => [ 'shape' => 'ConfigCapabilityType', ], 'configId' => [ 'shape' => 'String', ], 'configDetails' => [ 'shape' => 'ConfigDetails', ], 'dataflowSourceRegion' => [ 'shape' => 'String', ], ], ], 'SpectrumConfig' => [ 'type' => 'structure', 'required' => [ 'centerFrequency', 'bandwidth', ], 'members' => [ 'centerFrequency' => [ 'shape' => 'Frequency', ], 'bandwidth' => [ 'shape' => 'FrequencyBandwidth', ], 'polarization' => [ 'shape' => 'Polarization', ], ], ], 'StatusList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ContactStatus', ], 'max' => 500, 'min' => 0, ], 'String' => [ 'type' => 'string', ], 'SubnetList' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'SyntheticTimestamp_date_time' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'TLEData' => [ 'type' => 'structure', 'required' => [ 'tleLine1', 'tleLine2', 'validTimeRange', ], 'members' => [ 'tleLine1' => [ 'shape' => 'TleLineOne', ], 'tleLine2' => [ 'shape' => 'TleLineTwo', ], 'validTimeRange' => [ 'shape' => 'TimeRange', ], ], ], 'TLEDataList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TLEData', ], 'max' => 500, 'min' => 1, ], 'TLEEphemeris' => [ 'type' => 'structure', 'members' => [ 's3Object' => [ 'shape' => 'S3Object', ], 'tleData' => [ 'shape' => 'TLEDataList', ], ], ], 'TagKeys' => [ 'type' => 'list', 'member' => [ 'shape' => 'UnboundedString', ], 'max' => 500, 'min' => 0, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'AnyArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'TagsMap', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagsMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'TimeAzEl' => [ 'type' => 'structure', 'required' => [ 'dt', 'az', 'el', ], 'members' => [ 'dt' => [ 'shape' => 'Double', ], 'az' => [ 'shape' => 'Double', ], 'el' => [ 'shape' => 'Double', ], ], ], 'TimeAzElList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TimeAzEl', ], 'min' => 5, ], 'TimeRange' => [ 'type' => 'structure', 'required' => [ 'startTime', 'endTime', ], 'members' => [ 'startTime' => [ 'shape' => 'Timestamp', ], 'endTime' => [ 'shape' => 'Timestamp', ], ], ], 'Timestamp' => [ 'type' => 'timestamp', ], 'TleLineOne' => [ 'type' => 'string', 'max' => 69, 'min' => 69, 'pattern' => '1 [ 0-9]{5}[A-Z] [ 0-9]{5}[ A-Z]{3} [ 0-9]{5}[.][ 0-9]{8} (?:(?:[ 0+-][.][ 0-9]{8})|(?: [ +-][.][ 0-9]{7})) [ +-][ 0-9]{5}[+-][ 0-9] [ +-][ 0-9]{5}[+-][ 0-9] [ 0-9] [ 0-9]{4}[ 0-9]', ], 'TleLineTwo' => [ 'type' => 'string', 'max' => 69, 'min' => 69, 'pattern' => '2 [ 0-9]{5} [ 0-9]{3}[.][ 0-9]{4} [ 0-9]{3}[.][ 0-9]{4} [ 0-9]{7} [ 0-9]{3}[.][ 0-9]{4} [ 0-9]{3}[.][ 0-9]{4} [ 0-9]{2}[.][ 0-9]{13}[ 0-9]', ], 'TrackingConfig' => [ 'type' => 'structure', 'required' => [ 'autotrack', ], 'members' => [ 'autotrack' => [ 'shape' => 'Criticality', ], ], ], 'TrackingOverrides' => [ 'type' => 'structure', 'required' => [ 'programTrackSettings', ], 'members' => [ 'programTrackSettings' => [ 'shape' => 'ProgramTrackSettings', ], ], ], 'UnboundedString' => [ 'type' => 'string', 'min' => 1, 'pattern' => '[\\s\\S]+', ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'AnyArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeys', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateAgentStatusRequest' => [ 'type' => 'structure', 'required' => [ 'agentId', 'taskId', 'aggregateStatus', 'componentStatuses', ], 'members' => [ 'agentId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'agentId', ], 'taskId' => [ 'shape' => 'Uuid', ], 'aggregateStatus' => [ 'shape' => 'AggregateStatus', ], 'componentStatuses' => [ 'shape' => 'ComponentStatusList', ], ], ], 'UpdateAgentStatusResponse' => [ 'type' => 'structure', 'required' => [ 'agentId', ], 'members' => [ 'agentId' => [ 'shape' => 'Uuid', ], ], ], 'UpdateConfigRequest' => [ 'type' => 'structure', 'required' => [ 'configId', 'name', 'configType', 'configData', ], 'members' => [ 'configId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'configId', ], 'name' => [ 'shape' => 'SafeName', ], 'configType' => [ 'shape' => 'ConfigCapabilityType', 'location' => 'uri', 'locationName' => 'configType', ], 'configData' => [ 'shape' => 'ConfigTypeData', ], ], ], 'UpdateEphemerisRequest' => [ 'type' => 'structure', 'required' => [ 'ephemerisId', 'enabled', ], 'members' => [ 'ephemerisId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'ephemerisId', ], 'enabled' => [ 'shape' => 'Boolean', ], 'name' => [ 'shape' => 'SafeName', ], 'priority' => [ 'shape' => 'EphemerisPriority', ], ], ], 'UpdateMissionProfileRequest' => [ 'type' => 'structure', 'required' => [ 'missionProfileId', ], 'members' => [ 'missionProfileId' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'missionProfileId', ], 'name' => [ 'shape' => 'SafeName', ], 'contactPrePassDurationSeconds' => [ 'shape' => 'DurationInSeconds', ], 'contactPostPassDurationSeconds' => [ 'shape' => 'DurationInSeconds', ], 'minimumViableContactDurationSeconds' => [ 'shape' => 'PositiveDurationInSeconds', ], 'dataflowEdges' => [ 'shape' => 'DataflowEdgeList', ], 'trackingConfigArn' => [ 'shape' => 'ConfigArn', ], 'streamsKmsKey' => [ 'shape' => 'KmsKey', ], 'streamsKmsRole' => [ 'shape' => 'RoleArn', ], ], ], 'UplinkAwsGroundStationAgentEndpoint' => [ 'type' => 'structure', 'required' => [ 'name', 'dataflowDetails', ], 'members' => [ 'name' => [ 'shape' => 'SafeName', ], 'dataflowDetails' => [ 'shape' => 'UplinkDataflowDetails', ], ], ], 'UplinkAwsGroundStationAgentEndpointDetails' => [ 'type' => 'structure', 'required' => [ 'name', 'dataflowDetails', ], 'members' => [ 'name' => [ 'shape' => 'SafeName', ], 'dataflowDetails' => [ 'shape' => 'UplinkDataflowDetails', ], 'agentStatus' => [ 'shape' => 'AgentStatus', ], 'auditResults' => [ 'shape' => 'AuditResults', ], ], ], 'UplinkConnectionDetails' => [ 'type' => 'structure', 'required' => [ 'ingressAddressAndPort', 'agentIpAndPortAddress', ], 'members' => [ 'ingressAddressAndPort' => [ 'shape' => 'ConnectionDetails', ], 'agentIpAndPortAddress' => [ 'shape' => 'RangedConnectionDetails', ], ], ], 'UplinkDataflowDetails' => [ 'type' => 'structure', 'members' => [ 'agentConnectionDetails' => [ 'shape' => 'UplinkConnectionDetails', ], ], 'union' => true, ], 'UplinkEchoConfig' => [ 'type' => 'structure', 'required' => [ 'enabled', 'antennaUplinkConfigArn', ], 'members' => [ 'enabled' => [ 'shape' => 'Boolean', ], 'antennaUplinkConfigArn' => [ 'shape' => 'ConfigArn', ], ], ], 'UplinkSpectrumConfig' => [ 'type' => 'structure', 'required' => [ 'centerFrequency', ], 'members' => [ 'centerFrequency' => [ 'shape' => 'Frequency', ], 'polarization' => [ 'shape' => 'Polarization', ], ], ], 'Uuid' => [ 'type' => 'string', 'max' => 36, 'min' => 36, 'pattern' => '[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}', ], 'VersionString' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '(0|[1-9]\\d*)(\\.(0|[1-9]\\d*))*', ], 'VersionStringList' => [ 'type' => 'list', 'member' => [ 'shape' => 'VersionString', ], 'max' => 20, 'min' => 1, ], 'Year' => [ 'type' => 'integer', 'box' => true, 'max' => 3000, 'min' => 2018, ], 'noradSatelliteID' => [ 'type' => 'integer', 'max' => 99999, 'min' => 0, ], 'satelliteArn' => [ 'type' => 'string', 'max' => 132, 'min' => 82, 'pattern' => 'arn:aws:groundstation:([-a-z0-9]{1,50})?:[0-9]{12}:satellite/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}', ], ],];
