﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/autoscaling/AutoScaling_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace AutoScaling {
namespace Model {

/**
 * <p>Describes an enabled Auto Scaling group metric.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnabledMetric">AWS
 * API Reference</a></p>
 */
class EnabledMetric {
 public:
  AWS_AUTOSCALING_API EnabledMetric() = default;
  AWS_AUTOSCALING_API EnabledMetric(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_AUTOSCALING_API EnabledMetric& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_AUTOSCALING_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_AUTOSCALING_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>One of the following metrics:</p> <ul> <li> <p> <code>GroupMinSize</code>
   * </p> </li> <li> <p> <code>GroupMaxSize</code> </p> </li> <li> <p>
   * <code>GroupDesiredCapacity</code> </p> </li> <li> <p>
   * <code>GroupInServiceInstances</code> </p> </li> <li> <p>
   * <code>GroupPendingInstances</code> </p> </li> <li> <p>
   * <code>GroupStandbyInstances</code> </p> </li> <li> <p>
   * <code>GroupTerminatingInstances</code> </p> </li> <li> <p>
   * <code>GroupTotalInstances</code> </p> </li> <li> <p>
   * <code>GroupInServiceCapacity</code> </p> </li> <li> <p>
   * <code>GroupPendingCapacity</code> </p> </li> <li> <p>
   * <code>GroupStandbyCapacity</code> </p> </li> <li> <p>
   * <code>GroupTerminatingCapacity</code> </p> </li> <li> <p>
   * <code>GroupTotalCapacity</code> </p> </li> <li> <p>
   * <code>WarmPoolDesiredCapacity</code> </p> </li> <li> <p>
   * <code>WarmPoolWarmedCapacity</code> </p> </li> <li> <p>
   * <code>WarmPoolPendingCapacity</code> </p> </li> <li> <p>
   * <code>WarmPoolTerminatingCapacity</code> </p> </li> <li> <p>
   * <code>WarmPoolTotalCapacity</code> </p> </li> <li> <p>
   * <code>GroupAndWarmPoolDesiredCapacity</code> </p> </li> <li> <p>
   * <code>GroupAndWarmPoolTotalCapacity</code> </p> </li> </ul> <p>For more
   * information, see <a
   * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-metrics.html">Amazon
   * CloudWatch metrics for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto
   * Scaling User Guide</i>.</p>
   */
  inline const Aws::String& GetMetric() const { return m_metric; }
  inline bool MetricHasBeenSet() const { return m_metricHasBeenSet; }
  template <typename MetricT = Aws::String>
  void SetMetric(MetricT&& value) {
    m_metricHasBeenSet = true;
    m_metric = std::forward<MetricT>(value);
  }
  template <typename MetricT = Aws::String>
  EnabledMetric& WithMetric(MetricT&& value) {
    SetMetric(std::forward<MetricT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The granularity of the metric. The only valid value is
   * <code>1Minute</code>.</p>
   */
  inline const Aws::String& GetGranularity() const { return m_granularity; }
  inline bool GranularityHasBeenSet() const { return m_granularityHasBeenSet; }
  template <typename GranularityT = Aws::String>
  void SetGranularity(GranularityT&& value) {
    m_granularityHasBeenSet = true;
    m_granularity = std::forward<GranularityT>(value);
  }
  template <typename GranularityT = Aws::String>
  EnabledMetric& WithGranularity(GranularityT&& value) {
    SetGranularity(std::forward<GranularityT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_metric;

  Aws::String m_granularity;
  bool m_metricHasBeenSet = false;
  bool m_granularityHasBeenSet = false;
};

}  // namespace Model
}  // namespace AutoScaling
}  // namespace Aws
