﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/chime-sdk-identity/model/EndpointStatus.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace ChimeSDKIdentity {
namespace Model {
namespace EndpointStatusMapper {

static const int ACTIVE_HASH = HashingUtils::HashString("ACTIVE");
static const int INACTIVE_HASH = HashingUtils::HashString("INACTIVE");

EndpointStatus GetEndpointStatusForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == ACTIVE_HASH) {
    return EndpointStatus::ACTIVE;
  } else if (hashCode == INACTIVE_HASH) {
    return EndpointStatus::INACTIVE;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<EndpointStatus>(hashCode);
  }

  return EndpointStatus::NOT_SET;
}

Aws::String GetNameForEndpointStatus(EndpointStatus enumValue) {
  switch (enumValue) {
    case EndpointStatus::NOT_SET:
      return {};
    case EndpointStatus::ACTIVE:
      return "ACTIVE";
    case EndpointStatus::INACTIVE:
      return "INACTIVE";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace EndpointStatusMapper
}  // namespace Model
}  // namespace ChimeSDKIdentity
}  // namespace Aws
