﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codecommit/CodeCommitErrors.h>
#include <aws/core/client/AWSError.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Client;
using namespace Aws::Utils;
using namespace Aws::CodeCommit;

namespace Aws {
namespace CodeCommit {
namespace CodeCommitErrorMapper {

static const int REPOSITORY_TRIGGERS_LIST_REQUIRED_HASH = HashingUtils::HashString("RepositoryTriggersListRequiredException");
static const int PULL_REQUEST_DOES_NOT_EXIST_HASH = HashingUtils::HashString("PullRequestDoesNotExistException");
static const int BRANCH_NAME_EXISTS_HASH = HashingUtils::HashString("BranchNameExistsException");
static const int FILE_ENTRY_REQUIRED_HASH = HashingUtils::HashString("FileEntryRequiredException");
static const int INVALID_CONFLICT_RESOLUTION_STRATEGY_HASH = HashingUtils::HashString("InvalidConflictResolutionStrategyException");
static const int PATH_DOES_NOT_EXIST_HASH = HashingUtils::HashString("PathDoesNotExistException");
static const int FILE_DOES_NOT_EXIST_HASH = HashingUtils::HashString("FileDoesNotExistException");
static const int INVALID_PULL_REQUEST_ID_HASH = HashingUtils::HashString("InvalidPullRequestIdException");
static const int COMMIT_MESSAGE_LENGTH_EXCEEDED_HASH = HashingUtils::HashString("CommitMessageLengthExceededException");
static const int REVISION_ID_REQUIRED_HASH = HashingUtils::HashString("RevisionIdRequiredException");
static const int COMMENT_CONTENT_REQUIRED_HASH = HashingUtils::HashString("CommentContentRequiredException");
static const int INVALID_MAX_MERGE_HUNKS_HASH = HashingUtils::HashString("InvalidMaxMergeHunksException");
static const int REACTION_VALUE_REQUIRED_HASH = HashingUtils::HashString("ReactionValueRequiredException");
static const int INVALID_CONTINUATION_TOKEN_HASH = HashingUtils::HashString("InvalidContinuationTokenException");
static const int MERGE_OPTION_REQUIRED_HASH = HashingUtils::HashString("MergeOptionRequiredException");
static const int INVALID_AUTHOR_ARN_HASH = HashingUtils::HashString("InvalidAuthorArnException");
static const int INVALID_TARGET_BRANCH_HASH = HashingUtils::HashString("InvalidTargetBranchException");
static const int INVALID_COMMIT_ID_HASH = HashingUtils::HashString("InvalidCommitIdException");
static const int MULTIPLE_REPOSITORIES_IN_PULL_REQUEST_HASH = HashingUtils::HashString("MultipleRepositoriesInPullRequestException");
static const int INVALID_REPLACEMENT_CONTENT_HASH = HashingUtils::HashString("InvalidReplacementContentException");
static const int APPROVAL_RULE_TEMPLATE_NAME_ALREADY_EXISTS_HASH =
    HashingUtils::HashString("ApprovalRuleTemplateNameAlreadyExistsException");
static const int INVALID_ACTOR_ARN_HASH = HashingUtils::HashString("InvalidActorArnException");
static const int INVALID_REPOSITORY_TRIGGER_EVENTS_HASH = HashingUtils::HashString("InvalidRepositoryTriggerEventsException");
static const int COMMIT_DOES_NOT_EXIST_HASH = HashingUtils::HashString("CommitDoesNotExistException");
static const int INVALID_REACTION_USER_ARN_HASH = HashingUtils::HashString("InvalidReactionUserArnException");
static const int BRANCH_DOES_NOT_EXIST_HASH = HashingUtils::HashString("BranchDoesNotExistException");
static const int TAGS_MAP_REQUIRED_HASH = HashingUtils::HashString("TagsMapRequiredException");
static const int REPOSITORY_TRIGGER_DESTINATION_ARN_REQUIRED_HASH =
    HashingUtils::HashString("RepositoryTriggerDestinationArnRequiredException");
static const int REPOSITORY_TRIGGER_EVENTS_LIST_REQUIRED_HASH = HashingUtils::HashString("RepositoryTriggerEventsListRequiredException");
static const int REPOSITORY_TRIGGER_BRANCH_NAME_LIST_REQUIRED_HASH =
    HashingUtils::HashString("RepositoryTriggerBranchNameListRequiredException");
static const int INVALID_PULL_REQUEST_STATUS_HASH = HashingUtils::HashString("InvalidPullRequestStatusException");
static const int INVALID_APPROVAL_RULE_NAME_HASH = HashingUtils::HashString("InvalidApprovalRuleNameException");
static const int COMMIT_IDS_LIST_REQUIRED_HASH = HashingUtils::HashString("CommitIdsListRequiredException");
static const int INVALID_BLOB_ID_HASH = HashingUtils::HashString("InvalidBlobIdException");
static const int DIRECTORY_NAME_CONFLICTS_WITH_FILE_NAME_HASH = HashingUtils::HashString("DirectoryNameConflictsWithFileNameException");
static const int TAG_POLICY_HASH = HashingUtils::HashString("TagPolicyException");
static const int INVALID_COMMIT_HASH = HashingUtils::HashString("InvalidCommitException");
static const int APPROVAL_RULE_CONTENT_REQUIRED_HASH = HashingUtils::HashString("ApprovalRuleContentRequiredException");
static const int REPOSITORY_TRIGGER_NAME_REQUIRED_HASH = HashingUtils::HashString("RepositoryTriggerNameRequiredException");
static const int NUMBER_OF_RULES_EXCEEDED_HASH = HashingUtils::HashString("NumberOfRulesExceededException");
static const int MAXIMUM_BRANCHES_EXCEEDED_HASH = HashingUtils::HashString("MaximumBranchesExceededException");
static const int INVALID_PARENT_COMMIT_ID_HASH = HashingUtils::HashString("InvalidParentCommitIdException");
static const int CLIENT_REQUEST_TOKEN_REQUIRED_HASH = HashingUtils::HashString("ClientRequestTokenRequiredException");
static const int INVALID_APPROVAL_RULE_TEMPLATE_DESCRIPTION_HASH =
    HashingUtils::HashString("InvalidApprovalRuleTemplateDescriptionException");
static const int INVALID_APPROVAL_RULE_TEMPLATE_NAME_HASH = HashingUtils::HashString("InvalidApprovalRuleTemplateNameException");
static const int PARENT_COMMIT_ID_OUTDATED_HASH = HashingUtils::HashString("ParentCommitIdOutdatedException");
static const int SOURCE_FILE_OR_CONTENT_REQUIRED_HASH = HashingUtils::HashString("SourceFileOrContentRequiredException");
static const int APPROVAL_RULE_NAME_REQUIRED_HASH = HashingUtils::HashString("ApprovalRuleNameRequiredException");
static const int REPOSITORY_DOES_NOT_EXIST_HASH = HashingUtils::HashString("RepositoryDoesNotExistException");
static const int DEFAULT_BRANCH_CANNOT_BE_DELETED_HASH = HashingUtils::HashString("DefaultBranchCannotBeDeletedException");
static const int OVERRIDE_ALREADY_SET_HASH = HashingUtils::HashString("OverrideAlreadySetException");
static const int INVALID_PULL_REQUEST_STATUS_UPDATE_HASH = HashingUtils::HashString("InvalidPullRequestStatusUpdateException");
static const int ENCRYPTION_KEY_DISABLED_HASH = HashingUtils::HashString("EncryptionKeyDisabledException");
static const int APPROVAL_RULE_TEMPLATE_DOES_NOT_EXIST_HASH = HashingUtils::HashString("ApprovalRuleTemplateDoesNotExistException");
static const int INVALID_APPROVAL_STATE_HASH = HashingUtils::HashString("InvalidApprovalStateException");
static const int TITLE_REQUIRED_HASH = HashingUtils::HashString("TitleRequiredException");
static const int ENCRYPTION_KEY_INVALID_ID_HASH = HashingUtils::HashString("EncryptionKeyInvalidIdException");
static const int MAXIMUM_RULE_TEMPLATES_ASSOCIATED_WITH_REPOSITORY_HASH =
    HashingUtils::HashString("MaximumRuleTemplatesAssociatedWithRepositoryException");
static const int TARGETS_REQUIRED_HASH = HashingUtils::HashString("TargetsRequiredException");
static const int COMMENT_NOT_CREATED_BY_CALLER_HASH = HashingUtils::HashString("CommentNotCreatedByCallerException");
static const int INVALID_REVISION_ID_HASH = HashingUtils::HashString("InvalidRevisionIdException");
static const int NAME_LENGTH_EXCEEDED_HASH = HashingUtils::HashString("NameLengthExceededException");
static const int MAXIMUM_CONFLICT_RESOLUTION_ENTRIES_EXCEEDED_HASH =
    HashingUtils::HashString("MaximumConflictResolutionEntriesExceededException");
static const int COMMENT_DELETED_HASH = HashingUtils::HashString("CommentDeletedException");
static const int COMMIT_ID_REQUIRED_HASH = HashingUtils::HashString("CommitIdRequiredException");
static const int RESTRICTED_SOURCE_FILE_HASH = HashingUtils::HashString("RestrictedSourceFileException");
static const int IDEMPOTENCY_PARAMETER_MISMATCH_HASH = HashingUtils::HashString("IdempotencyParameterMismatchException");
static const int MAXIMUM_ITEMS_TO_COMPARE_EXCEEDED_HASH = HashingUtils::HashString("MaximumItemsToCompareExceededException");
static const int PARENT_COMMIT_ID_REQUIRED_HASH = HashingUtils::HashString("ParentCommitIdRequiredException");
static const int INVALID_REPOSITORY_TRIGGER_DESTINATION_ARN_HASH =
    HashingUtils::HashString("InvalidRepositoryTriggerDestinationArnException");
static const int APPROVAL_RULE_TEMPLATE_CONTENT_REQUIRED_HASH = HashingUtils::HashString("ApprovalRuleTemplateContentRequiredException");
static const int INVALID_SORT_BY_HASH = HashingUtils::HashString("InvalidSortByException");
static const int INVALID_RELATIVE_FILE_VERSION_ENUM_HASH = HashingUtils::HashString("InvalidRelativeFileVersionEnumException");
static const int INVALID_CLIENT_REQUEST_TOKEN_HASH = HashingUtils::HashString("InvalidClientRequestTokenException");
static const int APPROVAL_RULE_TEMPLATE_NAME_REQUIRED_HASH = HashingUtils::HashString("ApprovalRuleTemplateNameRequiredException");
static const int INVALID_RULE_CONTENT_SHA256_HASH = HashingUtils::HashString("InvalidRuleContentSha256Exception");
static const int BRANCH_NAME_REQUIRED_HASH = HashingUtils::HashString("BranchNameRequiredException");
static const int FILE_CONTENT_REQUIRED_HASH = HashingUtils::HashString("FileContentRequiredException");
static const int MAXIMUM_FILE_CONTENT_TO_LOAD_EXCEEDED_HASH = HashingUtils::HashString("MaximumFileContentToLoadExceededException");
static const int SAME_PATH_REQUEST_HASH = HashingUtils::HashString("SamePathRequestException");
static const int INVALID_DESCRIPTION_HASH = HashingUtils::HashString("InvalidDescriptionException");
static const int INVALID_REPLACEMENT_TYPE_HASH = HashingUtils::HashString("InvalidReplacementTypeException");
static const int ENCRYPTION_KEY_ACCESS_DENIED_HASH = HashingUtils::HashString("EncryptionKeyAccessDeniedException");
static const int ENCRYPTION_KEY_INVALID_USAGE_HASH = HashingUtils::HashString("EncryptionKeyInvalidUsageException");
static const int INVALID_RESOURCE_ARN_HASH = HashingUtils::HashString("InvalidResourceArnException");
static const int INVALID_APPROVAL_RULE_CONTENT_HASH = HashingUtils::HashString("InvalidApprovalRuleContentException");
static const int INVALID_CONFLICT_RESOLUTION_HASH = HashingUtils::HashString("InvalidConflictResolutionException");
static const int BLOB_ID_REQUIRED_HASH = HashingUtils::HashString("BlobIdRequiredException");
static const int REPOSITORY_NAMES_REQUIRED_HASH = HashingUtils::HashString("RepositoryNamesRequiredException");
static const int COMMENT_CONTENT_SIZE_LIMIT_EXCEEDED_HASH = HashingUtils::HashString("CommentContentSizeLimitExceededException");
static const int INVALID_TARGET_HASH = HashingUtils::HashString("InvalidTargetException");
static const int REFERENCE_DOES_NOT_EXIST_HASH = HashingUtils::HashString("ReferenceDoesNotExistException");
static const int CANNOT_MODIFY_APPROVAL_RULE_FROM_TEMPLATE_HASH = HashingUtils::HashString("CannotModifyApprovalRuleFromTemplateException");
static const int BRANCH_NAME_IS_TAG_NAME_HASH = HashingUtils::HashString("BranchNameIsTagNameException");
static const int REPOSITORY_NAME_REQUIRED_HASH = HashingUtils::HashString("RepositoryNameRequiredException");
static const int INVALID_APPROVAL_RULE_TEMPLATE_CONTENT_HASH = HashingUtils::HashString("InvalidApprovalRuleTemplateContentException");
static const int APPROVAL_RULE_DOES_NOT_EXIST_HASH = HashingUtils::HashString("ApprovalRuleDoesNotExistException");
static const int PULL_REQUEST_STATUS_REQUIRED_HASH = HashingUtils::HashString("PullRequestStatusRequiredException");
static const int APPROVAL_RULE_NAME_ALREADY_EXISTS_HASH = HashingUtils::HashString("ApprovalRuleNameAlreadyExistsException");
static const int INVALID_MAX_RESULTS_HASH = HashingUtils::HashString("InvalidMaxResultsException");
static const int TIP_OF_SOURCE_REFERENCE_IS_DIFFERENT_HASH = HashingUtils::HashString("TipOfSourceReferenceIsDifferentException");
static const int MAXIMUM_NUMBER_OF_APPROVALS_EXCEEDED_HASH = HashingUtils::HashString("MaximumNumberOfApprovalsExceededException");
static const int REPOSITORY_NAME_EXISTS_HASH = HashingUtils::HashString("RepositoryNameExistsException");
static const int PULL_REQUEST_CANNOT_BE_APPROVED_BY_AUTHOR_HASH = HashingUtils::HashString("PullRequestCannotBeApprovedByAuthorException");
static const int FILE_MODE_REQUIRED_HASH = HashingUtils::HashString("FileModeRequiredException");
static const int ENCRYPTION_INTEGRITY_CHECKS_FAILED_HASH = HashingUtils::HashString("EncryptionIntegrityChecksFailedException");
static const int REFERENCE_TYPE_NOT_SUPPORTED_HASH = HashingUtils::HashString("ReferenceTypeNotSupportedException");
static const int INVALID_REPOSITORY_TRIGGER_REGION_HASH = HashingUtils::HashString("InvalidRepositoryTriggerRegionException");
static const int APPROVAL_STATE_REQUIRED_HASH = HashingUtils::HashString("ApprovalStateRequiredException");
static const int INVALID_EMAIL_HASH = HashingUtils::HashString("InvalidEmailException");
static const int INVALID_DESTINATION_COMMIT_SPECIFIER_HASH = HashingUtils::HashString("InvalidDestinationCommitSpecifierException");
static const int COMMIT_ID_DOES_NOT_EXIST_HASH = HashingUtils::HashString("CommitIdDoesNotExistException");
static const int PARENT_COMMIT_DOES_NOT_EXIST_HASH = HashingUtils::HashString("ParentCommitDoesNotExistException");
static const int TAG_KEYS_LIST_REQUIRED_HASH = HashingUtils::HashString("TagKeysListRequiredException");
static const int INVALID_ORDER_HASH = HashingUtils::HashString("InvalidOrderException");
static const int INVALID_REPOSITORY_TRIGGER_CUSTOM_DATA_HASH = HashingUtils::HashString("InvalidRepositoryTriggerCustomDataException");
static const int INVALID_REFERENCE_NAME_HASH = HashingUtils::HashString("InvalidReferenceNameException");
static const int PULL_REQUEST_ALREADY_CLOSED_HASH = HashingUtils::HashString("PullRequestAlreadyClosedException");
static const int INVALID_SYSTEM_TAG_USAGE_HASH = HashingUtils::HashString("InvalidSystemTagUsageException");
static const int OVERRIDE_STATUS_REQUIRED_HASH = HashingUtils::HashString("OverrideStatusRequiredException");
static const int INVALID_TAG_KEYS_LIST_HASH = HashingUtils::HashString("InvalidTagKeysListException");
static const int INVALID_MERGE_OPTION_HASH = HashingUtils::HashString("InvalidMergeOptionException");
static const int COMMENT_ID_REQUIRED_HASH = HashingUtils::HashString("CommentIdRequiredException");
static const int REPOSITORY_NOT_ASSOCIATED_WITH_PULL_REQUEST_HASH =
    HashingUtils::HashString("RepositoryNotAssociatedWithPullRequestException");
static const int INVALID_SOURCE_COMMIT_SPECIFIER_HASH = HashingUtils::HashString("InvalidSourceCommitSpecifierException");
static const int FILE_PATH_CONFLICTS_WITH_SUBMODULE_PATH_HASH = HashingUtils::HashString("FilePathConflictsWithSubmodulePathException");
static const int RESOURCE_ARN_REQUIRED_HASH = HashingUtils::HashString("ResourceArnRequiredException");
static const int INVALID_FILE_MODE_HASH = HashingUtils::HashString("InvalidFileModeException");
static const int INVALID_REPOSITORY_TRIGGER_NAME_HASH = HashingUtils::HashString("InvalidRepositoryTriggerNameException");
static const int INVALID_TITLE_HASH = HashingUtils::HashString("InvalidTitleException");
static const int SOURCE_AND_DESTINATION_ARE_SAME_HASH = HashingUtils::HashString("SourceAndDestinationAreSameException");
static const int PATH_REQUIRED_HASH = HashingUtils::HashString("PathRequiredException");
static const int INVALID_DELETION_PARAMETER_HASH = HashingUtils::HashString("InvalidDeletionParameterException");
static const int INVALID_TAGS_MAP_HASH = HashingUtils::HashString("InvalidTagsMapException");
static const int OPERATION_NOT_ALLOWED_HASH = HashingUtils::HashString("OperationNotAllowedException");
static const int INVALID_FILE_LOCATION_HASH = HashingUtils::HashString("InvalidFileLocationException");
static const int INVALID_BRANCH_NAME_HASH = HashingUtils::HashString("InvalidBranchNameException");
static const int MAXIMUM_FILE_ENTRIES_EXCEEDED_HASH = HashingUtils::HashString("MaximumFileEntriesExceededException");
static const int MAXIMUM_REPOSITORY_NAMES_EXCEEDED_HASH = HashingUtils::HashString("MaximumRepositoryNamesExceededException");
static const int MAXIMUM_OPEN_PULL_REQUESTS_EXCEEDED_HASH = HashingUtils::HashString("MaximumOpenPullRequestsExceededException");
static const int ENCRYPTION_KEY_NOT_FOUND_HASH = HashingUtils::HashString("EncryptionKeyNotFoundException");
static const int REFERENCE_NAME_REQUIRED_HASH = HashingUtils::HashString("ReferenceNameRequiredException");
static const int INVALID_OVERRIDE_STATUS_HASH = HashingUtils::HashString("InvalidOverrideStatusException");
static const int TOO_MANY_TAGS_HASH = HashingUtils::HashString("TooManyTagsException");
static const int REPLACEMENT_CONTENT_REQUIRED_HASH = HashingUtils::HashString("ReplacementContentRequiredException");
static const int REVISION_NOT_CURRENT_HASH = HashingUtils::HashString("RevisionNotCurrentException");
static const int COMMIT_REQUIRED_HASH = HashingUtils::HashString("CommitRequiredException");
static const int ENCRYPTION_KEY_UNAVAILABLE_HASH = HashingUtils::HashString("EncryptionKeyUnavailableException");
static const int PULL_REQUEST_APPROVAL_RULES_NOT_SATISFIED_HASH = HashingUtils::HashString("PullRequestApprovalRulesNotSatisfiedException");
static const int MULTIPLE_CONFLICT_RESOLUTION_ENTRIES_HASH = HashingUtils::HashString("MultipleConflictResolutionEntriesException");
static const int INVALID_MAX_CONFLICT_FILES_HASH = HashingUtils::HashString("InvalidMaxConflictFilesException");
static const int COMMENT_DOES_NOT_EXIST_HASH = HashingUtils::HashString("CommentDoesNotExistException");
static const int INVALID_COMMENT_ID_HASH = HashingUtils::HashString("InvalidCommentIdException");
static const int TARGET_REQUIRED_HASH = HashingUtils::HashString("TargetRequiredException");
static const int FILE_CONTENT_SIZE_LIMIT_EXCEEDED_HASH = HashingUtils::HashString("FileContentSizeLimitExceededException");
static const int INVALID_PULL_REQUEST_EVENT_TYPE_HASH = HashingUtils::HashString("InvalidPullRequestEventTypeException");
static const int REPOSITORY_LIMIT_EXCEEDED_HASH = HashingUtils::HashString("RepositoryLimitExceededException");
static const int INVALID_REPOSITORY_NAME_HASH = HashingUtils::HashString("InvalidRepositoryNameException");
static const int INVALID_REPOSITORY_DESCRIPTION_HASH = HashingUtils::HashString("InvalidRepositoryDescriptionException");
static const int FOLDER_DOES_NOT_EXIST_HASH = HashingUtils::HashString("FolderDoesNotExistException");
static const int INVALID_PATH_HASH = HashingUtils::HashString("InvalidPathException");
static const int ACTOR_DOES_NOT_EXIST_HASH = HashingUtils::HashString("ActorDoesNotExistException");
static const int NO_CHANGE_HASH = HashingUtils::HashString("NoChangeException");
static const int REPLACEMENT_TYPE_REQUIRED_HASH = HashingUtils::HashString("ReplacementTypeRequiredException");
static const int MANUAL_MERGE_REQUIRED_HASH = HashingUtils::HashString("ManualMergeRequiredException");
static const int FILE_TOO_LARGE_HASH = HashingUtils::HashString("FileTooLargeException");
static const int MAXIMUM_REPOSITORY_TRIGGERS_EXCEEDED_HASH = HashingUtils::HashString("MaximumRepositoryTriggersExceededException");
static const int INVALID_CONFLICT_DETAIL_LEVEL_HASH = HashingUtils::HashString("InvalidConflictDetailLevelException");
static const int BLOB_ID_DOES_NOT_EXIST_HASH = HashingUtils::HashString("BlobIdDoesNotExistException");
static const int INVALID_REACTION_VALUE_HASH = HashingUtils::HashString("InvalidReactionValueException");
static const int PUT_FILE_ENTRY_CONFLICT_HASH = HashingUtils::HashString("PutFileEntryConflictException");
static const int REACTION_LIMIT_EXCEEDED_HASH = HashingUtils::HashString("ReactionLimitExceededException");
static const int CANNOT_DELETE_APPROVAL_RULE_FROM_TEMPLATE_HASH = HashingUtils::HashString("CannotDeleteApprovalRuleFromTemplateException");
static const int AUTHOR_DOES_NOT_EXIST_HASH = HashingUtils::HashString("AuthorDoesNotExistException");
static const int FILE_NAME_CONFLICTS_WITH_DIRECTORY_NAME_HASH = HashingUtils::HashString("FileNameConflictsWithDirectoryNameException");
static const int FOLDER_CONTENT_SIZE_LIMIT_EXCEEDED_HASH = HashingUtils::HashString("FolderContentSizeLimitExceededException");
static const int INVALID_TARGETS_HASH = HashingUtils::HashString("InvalidTargetsException");
static const int NUMBER_OF_RULE_TEMPLATES_EXCEEDED_HASH = HashingUtils::HashString("NumberOfRuleTemplatesExceededException");
static const int INVALID_REPOSITORY_TRIGGER_BRANCH_NAME_HASH = HashingUtils::HashString("InvalidRepositoryTriggerBranchNameException");
static const int COMMIT_IDS_LIMIT_EXCEEDED_HASH = HashingUtils::HashString("CommitIdsLimitExceededException");
static const int TIPS_DIVERGENCE_EXCEEDED_HASH = HashingUtils::HashString("TipsDivergenceExceededException");
static const int PULL_REQUEST_ID_REQUIRED_HASH = HashingUtils::HashString("PullRequestIdRequiredException");
static const int INVALID_FILE_POSITION_HASH = HashingUtils::HashString("InvalidFilePositionException");
static const int FILE_CONTENT_AND_SOURCE_FILE_SPECIFIED_HASH = HashingUtils::HashString("FileContentAndSourceFileSpecifiedException");
static const int CONCURRENT_REFERENCE_UPDATE_HASH = HashingUtils::HashString("ConcurrentReferenceUpdateException");
static const int BEFORE_COMMIT_ID_AND_AFTER_COMMIT_ID_ARE_SAME_HASH =
    HashingUtils::HashString("BeforeCommitIdAndAfterCommitIdAreSameException");
static const int APPROVAL_RULE_TEMPLATE_IN_USE_HASH = HashingUtils::HashString("ApprovalRuleTemplateInUseException");
static const int SAME_FILE_CONTENT_HASH = HashingUtils::HashString("SameFileContentException");
static const int ENCRYPTION_KEY_REQUIRED_HASH = HashingUtils::HashString("EncryptionKeyRequiredException");

/*
The if-else chains in this file are converted into a jump table by the compiler,
which allows constant time lookup. The chain has been broken into helper functions
because MSVC has a maximum of 122 chained if-else blocks.
*/

static bool GetErrorForNameHelper0(int hashCode, AWSError<CoreErrors>& error) {
  if (hashCode == REPOSITORY_TRIGGERS_LIST_REQUIRED_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REPOSITORY_TRIGGERS_LIST_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == PULL_REQUEST_DOES_NOT_EXIST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::PULL_REQUEST_DOES_NOT_EXIST), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == BRANCH_NAME_EXISTS_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::BRANCH_NAME_EXISTS), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == FILE_ENTRY_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::FILE_ENTRY_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_CONFLICT_RESOLUTION_STRATEGY_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_CONFLICT_RESOLUTION_STRATEGY), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == PATH_DOES_NOT_EXIST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::PATH_DOES_NOT_EXIST), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == FILE_DOES_NOT_EXIST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::FILE_DOES_NOT_EXIST), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_PULL_REQUEST_ID_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_PULL_REQUEST_ID), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == COMMIT_MESSAGE_LENGTH_EXCEEDED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::COMMIT_MESSAGE_LENGTH_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REVISION_ID_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REVISION_ID_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == COMMENT_CONTENT_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::COMMENT_CONTENT_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_MAX_MERGE_HUNKS_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_MAX_MERGE_HUNKS), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REACTION_VALUE_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REACTION_VALUE_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_CONTINUATION_TOKEN_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_CONTINUATION_TOKEN), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == MERGE_OPTION_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::MERGE_OPTION_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_AUTHOR_ARN_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_AUTHOR_ARN), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_TARGET_BRANCH_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_TARGET_BRANCH), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_COMMIT_ID_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_COMMIT_ID), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == MULTIPLE_REPOSITORIES_IN_PULL_REQUEST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::MULTIPLE_REPOSITORIES_IN_PULL_REQUEST),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_REPLACEMENT_CONTENT_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_REPLACEMENT_CONTENT), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == APPROVAL_RULE_TEMPLATE_NAME_ALREADY_EXISTS_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::APPROVAL_RULE_TEMPLATE_NAME_ALREADY_EXISTS),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_ACTOR_ARN_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_ACTOR_ARN), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_REPOSITORY_TRIGGER_EVENTS_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_REPOSITORY_TRIGGER_EVENTS), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == COMMIT_DOES_NOT_EXIST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::COMMIT_DOES_NOT_EXIST), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_REACTION_USER_ARN_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_REACTION_USER_ARN), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == BRANCH_DOES_NOT_EXIST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::BRANCH_DOES_NOT_EXIST), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == TAGS_MAP_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::TAGS_MAP_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REPOSITORY_TRIGGER_DESTINATION_ARN_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REPOSITORY_TRIGGER_DESTINATION_ARN_REQUIRED),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REPOSITORY_TRIGGER_EVENTS_LIST_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REPOSITORY_TRIGGER_EVENTS_LIST_REQUIRED),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REPOSITORY_TRIGGER_BRANCH_NAME_LIST_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REPOSITORY_TRIGGER_BRANCH_NAME_LIST_REQUIRED),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_PULL_REQUEST_STATUS_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_PULL_REQUEST_STATUS), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_APPROVAL_RULE_NAME_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_APPROVAL_RULE_NAME), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == COMMIT_IDS_LIST_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::COMMIT_IDS_LIST_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_BLOB_ID_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_BLOB_ID), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == DIRECTORY_NAME_CONFLICTS_WITH_FILE_NAME_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::DIRECTORY_NAME_CONFLICTS_WITH_FILE_NAME),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == TAG_POLICY_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::TAG_POLICY), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_COMMIT_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_COMMIT), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == APPROVAL_RULE_CONTENT_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::APPROVAL_RULE_CONTENT_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REPOSITORY_TRIGGER_NAME_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REPOSITORY_TRIGGER_NAME_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == NUMBER_OF_RULES_EXCEEDED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::NUMBER_OF_RULES_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == MAXIMUM_BRANCHES_EXCEEDED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::MAXIMUM_BRANCHES_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_PARENT_COMMIT_ID_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_PARENT_COMMIT_ID), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == CLIENT_REQUEST_TOKEN_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::CLIENT_REQUEST_TOKEN_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_APPROVAL_RULE_TEMPLATE_DESCRIPTION_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_APPROVAL_RULE_TEMPLATE_DESCRIPTION),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_APPROVAL_RULE_TEMPLATE_NAME_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_APPROVAL_RULE_TEMPLATE_NAME), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == PARENT_COMMIT_ID_OUTDATED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::PARENT_COMMIT_ID_OUTDATED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == SOURCE_FILE_OR_CONTENT_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::SOURCE_FILE_OR_CONTENT_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == APPROVAL_RULE_NAME_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::APPROVAL_RULE_NAME_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REPOSITORY_DOES_NOT_EXIST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REPOSITORY_DOES_NOT_EXIST), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == DEFAULT_BRANCH_CANNOT_BE_DELETED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::DEFAULT_BRANCH_CANNOT_BE_DELETED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == OVERRIDE_ALREADY_SET_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::OVERRIDE_ALREADY_SET), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_PULL_REQUEST_STATUS_UPDATE_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_PULL_REQUEST_STATUS_UPDATE), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == ENCRYPTION_KEY_DISABLED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::ENCRYPTION_KEY_DISABLED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == APPROVAL_RULE_TEMPLATE_DOES_NOT_EXIST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::APPROVAL_RULE_TEMPLATE_DOES_NOT_EXIST),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_APPROVAL_STATE_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_APPROVAL_STATE), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == TITLE_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::TITLE_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == ENCRYPTION_KEY_INVALID_ID_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::ENCRYPTION_KEY_INVALID_ID), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == MAXIMUM_RULE_TEMPLATES_ASSOCIATED_WITH_REPOSITORY_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::MAXIMUM_RULE_TEMPLATES_ASSOCIATED_WITH_REPOSITORY),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == TARGETS_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::TARGETS_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == COMMENT_NOT_CREATED_BY_CALLER_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::COMMENT_NOT_CREATED_BY_CALLER), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_REVISION_ID_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_REVISION_ID), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == NAME_LENGTH_EXCEEDED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::NAME_LENGTH_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == MAXIMUM_CONFLICT_RESOLUTION_ENTRIES_EXCEEDED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::MAXIMUM_CONFLICT_RESOLUTION_ENTRIES_EXCEEDED),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == COMMENT_DELETED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::COMMENT_DELETED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == COMMIT_ID_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::COMMIT_ID_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == RESTRICTED_SOURCE_FILE_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::RESTRICTED_SOURCE_FILE), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == IDEMPOTENCY_PARAMETER_MISMATCH_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::IDEMPOTENCY_PARAMETER_MISMATCH), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == MAXIMUM_ITEMS_TO_COMPARE_EXCEEDED_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::MAXIMUM_ITEMS_TO_COMPARE_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == PARENT_COMMIT_ID_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::PARENT_COMMIT_ID_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_REPOSITORY_TRIGGER_DESTINATION_ARN_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_REPOSITORY_TRIGGER_DESTINATION_ARN),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == APPROVAL_RULE_TEMPLATE_CONTENT_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::APPROVAL_RULE_TEMPLATE_CONTENT_REQUIRED),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_SORT_BY_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_SORT_BY), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_RELATIVE_FILE_VERSION_ENUM_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_RELATIVE_FILE_VERSION_ENUM), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_CLIENT_REQUEST_TOKEN_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_CLIENT_REQUEST_TOKEN), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == APPROVAL_RULE_TEMPLATE_NAME_REQUIRED_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::APPROVAL_RULE_TEMPLATE_NAME_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_RULE_CONTENT_SHA256_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_RULE_CONTENT_SHA256), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == BRANCH_NAME_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::BRANCH_NAME_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == FILE_CONTENT_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::FILE_CONTENT_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == MAXIMUM_FILE_CONTENT_TO_LOAD_EXCEEDED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::MAXIMUM_FILE_CONTENT_TO_LOAD_EXCEEDED),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == SAME_PATH_REQUEST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::SAME_PATH_REQUEST), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_DESCRIPTION_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_DESCRIPTION), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_REPLACEMENT_TYPE_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_REPLACEMENT_TYPE), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == ENCRYPTION_KEY_ACCESS_DENIED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::ENCRYPTION_KEY_ACCESS_DENIED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == ENCRYPTION_KEY_INVALID_USAGE_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::ENCRYPTION_KEY_INVALID_USAGE), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_RESOURCE_ARN_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_RESOURCE_ARN), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_APPROVAL_RULE_CONTENT_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_APPROVAL_RULE_CONTENT), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_CONFLICT_RESOLUTION_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_CONFLICT_RESOLUTION), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == BLOB_ID_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::BLOB_ID_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REPOSITORY_NAMES_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REPOSITORY_NAMES_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == COMMENT_CONTENT_SIZE_LIMIT_EXCEEDED_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::COMMENT_CONTENT_SIZE_LIMIT_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_TARGET_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_TARGET), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REFERENCE_DOES_NOT_EXIST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REFERENCE_DOES_NOT_EXIST), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == CANNOT_MODIFY_APPROVAL_RULE_FROM_TEMPLATE_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::CANNOT_MODIFY_APPROVAL_RULE_FROM_TEMPLATE),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == BRANCH_NAME_IS_TAG_NAME_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::BRANCH_NAME_IS_TAG_NAME), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REPOSITORY_NAME_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REPOSITORY_NAME_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_APPROVAL_RULE_TEMPLATE_CONTENT_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_APPROVAL_RULE_TEMPLATE_CONTENT),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == APPROVAL_RULE_DOES_NOT_EXIST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::APPROVAL_RULE_DOES_NOT_EXIST), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == PULL_REQUEST_STATUS_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::PULL_REQUEST_STATUS_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == APPROVAL_RULE_NAME_ALREADY_EXISTS_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::APPROVAL_RULE_NAME_ALREADY_EXISTS), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_MAX_RESULTS_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_MAX_RESULTS), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == TIP_OF_SOURCE_REFERENCE_IS_DIFFERENT_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::TIP_OF_SOURCE_REFERENCE_IS_DIFFERENT), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == MAXIMUM_NUMBER_OF_APPROVALS_EXCEEDED_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::MAXIMUM_NUMBER_OF_APPROVALS_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REPOSITORY_NAME_EXISTS_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REPOSITORY_NAME_EXISTS), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == PULL_REQUEST_CANNOT_BE_APPROVED_BY_AUTHOR_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::PULL_REQUEST_CANNOT_BE_APPROVED_BY_AUTHOR),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == FILE_MODE_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::FILE_MODE_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == ENCRYPTION_INTEGRITY_CHECKS_FAILED_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::ENCRYPTION_INTEGRITY_CHECKS_FAILED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REFERENCE_TYPE_NOT_SUPPORTED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REFERENCE_TYPE_NOT_SUPPORTED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_REPOSITORY_TRIGGER_REGION_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_REPOSITORY_TRIGGER_REGION), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == APPROVAL_STATE_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::APPROVAL_STATE_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_EMAIL_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_EMAIL), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_DESTINATION_COMMIT_SPECIFIER_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_DESTINATION_COMMIT_SPECIFIER), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == COMMIT_ID_DOES_NOT_EXIST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::COMMIT_ID_DOES_NOT_EXIST), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == PARENT_COMMIT_DOES_NOT_EXIST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::PARENT_COMMIT_DOES_NOT_EXIST), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == TAG_KEYS_LIST_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::TAG_KEYS_LIST_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_ORDER_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_ORDER), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_REPOSITORY_TRIGGER_CUSTOM_DATA_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_REPOSITORY_TRIGGER_CUSTOM_DATA),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_REFERENCE_NAME_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_REFERENCE_NAME), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == PULL_REQUEST_ALREADY_CLOSED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::PULL_REQUEST_ALREADY_CLOSED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_SYSTEM_TAG_USAGE_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_SYSTEM_TAG_USAGE), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == OVERRIDE_STATUS_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::OVERRIDE_STATUS_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_TAG_KEYS_LIST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_TAG_KEYS_LIST), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_MERGE_OPTION_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_MERGE_OPTION), RetryableType::NOT_RETRYABLE);
    return true;
  }
  return false;
}

static bool GetErrorForNameHelper1(int hashCode, AWSError<CoreErrors>& error) {
  if (hashCode == COMMENT_ID_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::COMMENT_ID_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REPOSITORY_NOT_ASSOCIATED_WITH_PULL_REQUEST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REPOSITORY_NOT_ASSOCIATED_WITH_PULL_REQUEST),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_SOURCE_COMMIT_SPECIFIER_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_SOURCE_COMMIT_SPECIFIER), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == FILE_PATH_CONFLICTS_WITH_SUBMODULE_PATH_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::FILE_PATH_CONFLICTS_WITH_SUBMODULE_PATH),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == RESOURCE_ARN_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::RESOURCE_ARN_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_FILE_MODE_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_FILE_MODE), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_REPOSITORY_TRIGGER_NAME_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_REPOSITORY_TRIGGER_NAME), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_TITLE_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_TITLE), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == SOURCE_AND_DESTINATION_ARE_SAME_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::SOURCE_AND_DESTINATION_ARE_SAME), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == PATH_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::PATH_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_DELETION_PARAMETER_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_DELETION_PARAMETER), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_TAGS_MAP_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_TAGS_MAP), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == OPERATION_NOT_ALLOWED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::OPERATION_NOT_ALLOWED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_FILE_LOCATION_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_FILE_LOCATION), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_BRANCH_NAME_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_BRANCH_NAME), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == MAXIMUM_FILE_ENTRIES_EXCEEDED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::MAXIMUM_FILE_ENTRIES_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == MAXIMUM_REPOSITORY_NAMES_EXCEEDED_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::MAXIMUM_REPOSITORY_NAMES_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == MAXIMUM_OPEN_PULL_REQUESTS_EXCEEDED_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::MAXIMUM_OPEN_PULL_REQUESTS_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == ENCRYPTION_KEY_NOT_FOUND_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::ENCRYPTION_KEY_NOT_FOUND), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REFERENCE_NAME_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REFERENCE_NAME_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_OVERRIDE_STATUS_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_OVERRIDE_STATUS), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == TOO_MANY_TAGS_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::TOO_MANY_TAGS), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REPLACEMENT_CONTENT_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REPLACEMENT_CONTENT_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REVISION_NOT_CURRENT_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REVISION_NOT_CURRENT), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == COMMIT_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::COMMIT_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == ENCRYPTION_KEY_UNAVAILABLE_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::ENCRYPTION_KEY_UNAVAILABLE), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == PULL_REQUEST_APPROVAL_RULES_NOT_SATISFIED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::PULL_REQUEST_APPROVAL_RULES_NOT_SATISFIED),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == MULTIPLE_CONFLICT_RESOLUTION_ENTRIES_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::MULTIPLE_CONFLICT_RESOLUTION_ENTRIES), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_MAX_CONFLICT_FILES_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_MAX_CONFLICT_FILES), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == COMMENT_DOES_NOT_EXIST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::COMMENT_DOES_NOT_EXIST), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_COMMENT_ID_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_COMMENT_ID), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == TARGET_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::TARGET_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == FILE_CONTENT_SIZE_LIMIT_EXCEEDED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::FILE_CONTENT_SIZE_LIMIT_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_PULL_REQUEST_EVENT_TYPE_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_PULL_REQUEST_EVENT_TYPE), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REPOSITORY_LIMIT_EXCEEDED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REPOSITORY_LIMIT_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_REPOSITORY_NAME_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_REPOSITORY_NAME), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_REPOSITORY_DESCRIPTION_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_REPOSITORY_DESCRIPTION), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == FOLDER_DOES_NOT_EXIST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::FOLDER_DOES_NOT_EXIST), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_PATH_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_PATH), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == ACTOR_DOES_NOT_EXIST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::ACTOR_DOES_NOT_EXIST), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == NO_CHANGE_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::NO_CHANGE), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REPLACEMENT_TYPE_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REPLACEMENT_TYPE_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == MANUAL_MERGE_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::MANUAL_MERGE_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == FILE_TOO_LARGE_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::FILE_TOO_LARGE), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == MAXIMUM_REPOSITORY_TRIGGERS_EXCEEDED_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::MAXIMUM_REPOSITORY_TRIGGERS_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_CONFLICT_DETAIL_LEVEL_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_CONFLICT_DETAIL_LEVEL), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == BLOB_ID_DOES_NOT_EXIST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::BLOB_ID_DOES_NOT_EXIST), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_REACTION_VALUE_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_REACTION_VALUE), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == PUT_FILE_ENTRY_CONFLICT_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::PUT_FILE_ENTRY_CONFLICT), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == REACTION_LIMIT_EXCEEDED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::REACTION_LIMIT_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == CANNOT_DELETE_APPROVAL_RULE_FROM_TEMPLATE_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::CANNOT_DELETE_APPROVAL_RULE_FROM_TEMPLATE),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == AUTHOR_DOES_NOT_EXIST_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::AUTHOR_DOES_NOT_EXIST), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == FILE_NAME_CONFLICTS_WITH_DIRECTORY_NAME_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::FILE_NAME_CONFLICTS_WITH_DIRECTORY_NAME),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == FOLDER_CONTENT_SIZE_LIMIT_EXCEEDED_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::FOLDER_CONTENT_SIZE_LIMIT_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_TARGETS_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_TARGETS), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == NUMBER_OF_RULE_TEMPLATES_EXCEEDED_HASH) {
    error =
        AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::NUMBER_OF_RULE_TEMPLATES_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_REPOSITORY_TRIGGER_BRANCH_NAME_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_REPOSITORY_TRIGGER_BRANCH_NAME),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == COMMIT_IDS_LIMIT_EXCEEDED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::COMMIT_IDS_LIMIT_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == TIPS_DIVERGENCE_EXCEEDED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::TIPS_DIVERGENCE_EXCEEDED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == PULL_REQUEST_ID_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::PULL_REQUEST_ID_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == INVALID_FILE_POSITION_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::INVALID_FILE_POSITION), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == FILE_CONTENT_AND_SOURCE_FILE_SPECIFIED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::FILE_CONTENT_AND_SOURCE_FILE_SPECIFIED),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == CONCURRENT_REFERENCE_UPDATE_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::CONCURRENT_REFERENCE_UPDATE), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == BEFORE_COMMIT_ID_AND_AFTER_COMMIT_ID_ARE_SAME_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::BEFORE_COMMIT_ID_AND_AFTER_COMMIT_ID_ARE_SAME),
                                 RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == APPROVAL_RULE_TEMPLATE_IN_USE_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::APPROVAL_RULE_TEMPLATE_IN_USE), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == SAME_FILE_CONTENT_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::SAME_FILE_CONTENT), RetryableType::NOT_RETRYABLE);
    return true;
  } else if (hashCode == ENCRYPTION_KEY_REQUIRED_HASH) {
    error = AWSError<CoreErrors>(static_cast<CoreErrors>(CodeCommitErrors::ENCRYPTION_KEY_REQUIRED), RetryableType::NOT_RETRYABLE);
    return true;
  }
  return false;
}

AWSError<CoreErrors> GetErrorForName(const char* errorName) {
  int hashCode = HashingUtils::HashString(errorName);
  AWSError<CoreErrors> error;
  if (GetErrorForNameHelper0(hashCode, error)) {
    return error;
  } else if (GetErrorForNameHelper1(hashCode, error)) {
    return error;
  }
  return AWSError<CoreErrors>(CoreErrors::UNKNOWN, false);
}

}  // namespace CodeCommitErrorMapper
}  // namespace CodeCommit
}  // namespace Aws
