//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvopenglbufferpool?language=objc)
#[doc(alias = "CVOpenGLBufferPoolRef")]
#[repr(C)]
pub struct CVOpenGLBufferPool {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CVOpenGLBufferPool {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CVOpenGLBufferPool"> for CVOpenGLBufferPool {}
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvopenglbufferpoolminimumbuffercountkey?language=objc)
    #[deprecated = "OpenGL/OpenGLES is no longer supported. Use Metal APIs instead. (Define COREVIDEO_SILENCE_GL_DEPRECATION to silence these warnings)"]
    pub static kCVOpenGLBufferPoolMinimumBufferCountKey: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvopenglbufferpoolmaximumbufferagekey?language=objc)
    #[deprecated = "OpenGL/OpenGLES is no longer supported. Use Metal APIs instead. (Define COREVIDEO_SILENCE_GL_DEPRECATION to silence these warnings)"]
    pub static kCVOpenGLBufferPoolMaximumBufferAgeKey: &'static CFString;
}

unsafe impl ConcreteType for CVOpenGLBufferPool {
    #[doc(alias = "CVOpenGLBufferPoolGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CVOpenGLBufferPoolGetTypeID() -> CFTypeID;
        }
        unsafe { CVOpenGLBufferPoolGetTypeID() }
    }
}

impl CVOpenGLBufferPool {
    /// Creates a new OpenGL Buffer pool.
    ///
    /// Equivalent to CFRelease, but NULL safe
    ///
    /// Parameter `allocator`: The CFAllocatorRef to use for allocating this buffer pool.  May be NULL.
    ///
    /// Parameter `poolAttributes`: A CFDictionaryRef containing the attributes to be used for the pool itself.
    ///
    /// Parameter `openGLBufferAttributes`: A CFDictionaryRef containing the attributes to be used for creating new OpenGLBuffers within the pool.
    ///
    /// Parameter `poolOut`: The newly created pool will be placed here
    ///
    /// Returns: Returns kCVReturnSuccess on success
    ///
    /// # Safety
    ///
    /// - `pool_attributes` generics must be of the correct type.
    /// - `open_gl_buffer_attributes` generics must be of the correct type.
    /// - `pool_out` must be a valid pointer.
    #[doc(alias = "CVOpenGLBufferPoolCreate")]
    #[cfg(feature = "CVReturn")]
    #[deprecated = "OpenGL/OpenGLES is no longer supported. Use Metal APIs instead. (Define COREVIDEO_SILENCE_GL_DEPRECATION to silence these warnings)"]
    #[inline]
    pub unsafe fn create(
        allocator: Option<&CFAllocator>,
        pool_attributes: Option<&CFDictionary>,
        open_gl_buffer_attributes: Option<&CFDictionary>,
        pool_out: NonNull<*mut CVOpenGLBufferPool>,
    ) -> CVReturn {
        extern "C-unwind" {
            fn CVOpenGLBufferPoolCreate(
                allocator: Option<&CFAllocator>,
                pool_attributes: Option<&CFDictionary>,
                open_gl_buffer_attributes: Option<&CFDictionary>,
                pool_out: NonNull<*mut CVOpenGLBufferPool>,
            ) -> CVReturn;
        }
        unsafe {
            CVOpenGLBufferPoolCreate(
                allocator,
                pool_attributes,
                open_gl_buffer_attributes,
                pool_out,
            )
        }
    }

    /// Returns the pool attributes dictionary for a CVOpenGLBufferPool
    ///
    /// Parameter `pool`: The CVOpenGLBufferPoolRef to retrieve the attributes from
    ///
    /// Returns: Returns the pool attributes dictionary, or NULL on failure.
    #[doc(alias = "CVOpenGLBufferPoolGetAttributes")]
    #[deprecated = "OpenGL/OpenGLES is no longer supported. Use Metal APIs instead. (Define COREVIDEO_SILENCE_GL_DEPRECATION to silence these warnings)"]
    #[inline]
    pub fn attributes(&self) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CVOpenGLBufferPoolGetAttributes(
                pool: &CVOpenGLBufferPool,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CVOpenGLBufferPoolGetAttributes(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns the attributes of OpenGL buffers that will be created from this pool.
    ///
    /// This function is provided for those cases where you may need to know some information about the buffers that
    /// will be created up front.
    ///
    /// Parameter `pool`: The CVOpenGLBufferPoolRef to retrieve the attributes from
    ///
    /// Returns: Returns the OpenGL buffer attributes dictionary, or NULL on failure.
    #[doc(alias = "CVOpenGLBufferPoolGetOpenGLBufferAttributes")]
    #[deprecated = "OpenGL/OpenGLES is no longer supported. Use Metal APIs instead. (Define COREVIDEO_SILENCE_GL_DEPRECATION to silence these warnings)"]
    #[inline]
    pub fn open_gl_buffer_attributes(&self) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CVOpenGLBufferPoolGetOpenGLBufferAttributes(
                pool: &CVOpenGLBufferPool,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CVOpenGLBufferPoolGetOpenGLBufferAttributes(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Creates a new OpenGLBuffer object from the pool.
    ///
    /// The function creates a new CVOpenGLBuffer with the default attachments using the OpenGL buffer attributes specifed during pool creation.
    ///
    /// Parameter `allocator`: The CFAllocatorRef to use for creating the OpenGL buffer.  May be NULL.
    ///
    /// Parameter `openGLBufferPool`: The CVOpenGLBufferPool that should create the new CVOpenGLBuffer.
    ///
    /// Parameter `openGLBufferOut`: The newly created OpenGL buffer will be placed here
    ///
    /// Returns: Returns kCVReturnSuccess on success
    ///
    /// # Safety
    ///
    /// `open_gl_buffer_out` must be a valid pointer.
    #[doc(alias = "CVOpenGLBufferPoolCreateOpenGLBuffer")]
    #[cfg(all(
        feature = "CVBuffer",
        feature = "CVImageBuffer",
        feature = "CVOpenGLBuffer",
        feature = "CVReturn"
    ))]
    #[deprecated = "OpenGL/OpenGLES is no longer supported. Use Metal APIs instead. (Define COREVIDEO_SILENCE_GL_DEPRECATION to silence these warnings)"]
    #[inline]
    pub unsafe fn create_open_gl_buffer(
        allocator: Option<&CFAllocator>,
        open_gl_buffer_pool: &CVOpenGLBufferPool,
        open_gl_buffer_out: NonNull<*mut CVOpenGLBuffer>,
    ) -> CVReturn {
        extern "C-unwind" {
            fn CVOpenGLBufferPoolCreateOpenGLBuffer(
                allocator: Option<&CFAllocator>,
                open_gl_buffer_pool: &CVOpenGLBufferPool,
                open_gl_buffer_out: NonNull<*mut CVOpenGLBuffer>,
            ) -> CVReturn;
        }
        unsafe {
            CVOpenGLBufferPoolCreateOpenGLBuffer(allocator, open_gl_buffer_pool, open_gl_buffer_out)
        }
    }
}

extern "C-unwind" {
    #[cfg(feature = "CVReturn")]
    #[deprecated = "renamed to `CVOpenGLBufferPool::create`"]
    pub fn CVOpenGLBufferPoolCreate(
        allocator: Option<&CFAllocator>,
        pool_attributes: Option<&CFDictionary>,
        open_gl_buffer_attributes: Option<&CFDictionary>,
        pool_out: NonNull<*mut CVOpenGLBufferPool>,
    ) -> CVReturn;
}

#[deprecated = "renamed to `CVOpenGLBufferPool::attributes`"]
#[inline]
pub extern "C-unwind" fn CVOpenGLBufferPoolGetAttributes(
    pool: &CVOpenGLBufferPool,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CVOpenGLBufferPoolGetAttributes(
            pool: &CVOpenGLBufferPool,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CVOpenGLBufferPoolGetAttributes(pool) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CVOpenGLBufferPool::open_gl_buffer_attributes`"]
#[inline]
pub extern "C-unwind" fn CVOpenGLBufferPoolGetOpenGLBufferAttributes(
    pool: &CVOpenGLBufferPool,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CVOpenGLBufferPoolGetOpenGLBufferAttributes(
            pool: &CVOpenGLBufferPool,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CVOpenGLBufferPoolGetOpenGLBufferAttributes(pool) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[cfg(all(
        feature = "CVBuffer",
        feature = "CVImageBuffer",
        feature = "CVOpenGLBuffer",
        feature = "CVReturn"
    ))]
    #[deprecated = "renamed to `CVOpenGLBufferPool::create_open_gl_buffer`"]
    pub fn CVOpenGLBufferPoolCreateOpenGLBuffer(
        allocator: Option<&CFAllocator>,
        open_gl_buffer_pool: &CVOpenGLBufferPool,
        open_gl_buffer_out: NonNull<*mut CVOpenGLBuffer>,
    ) -> CVReturn;
}
