// Cannot implicitly shard accessed collections because of following errmsg: A single
// update/delete on a sharded collection must contain an exact match on _id or contain the shard
// key.
// @tags: [assumes_unsharded_collection, requires_multi_updates, requires_non_retryable_writes]

// Test new (optional) update syntax
// SERVER-4176
let t = db.updatei;

// Using a multi update

t.drop();

for (let i = 0; i < 10; i++) {
    t.save({_id: i, k: "x", a: []});
}

t.update({k: "x"}, {$push: {a: "y"}}, {multi: true});
t.find({k: "x"}).forEach(function(z) {
    assert.eq(["y"], z.a, "multi update using object arg");
});

t.drop();

// Using a single update

for (let i = 0; i < 10; i++) {
    t.save({_id: i, k: "x", a: []});
}

t.update({k: "x"}, {$push: {a: "y"}}, {multi: false});
assert.eq(1, t.find({"a": "y"}).count(), "update using object arg");

t.drop();

// Using upsert, found

for (let i = 0; i < 10; i++) {
    t.save({_id: i, k: "x", a: []});
}

t.update({k: "x"}, {$push: {a: "y"}}, {upsert: true});
assert.eq(1, t.find({"k": "x", "a": "y"}).count(), "upsert (found) using object arg");

t.drop();

// Using upsert + multi, found

for (let i = 0; i < 10; i++) {
    t.save({_id: i, k: "x", a: []});
}

t.update({k: "x"}, {$push: {a: "y"}}, {upsert: true, multi: true});
t.find({k: "x"}).forEach(function(z) {
    assert.eq(["y"], z.a, "multi + upsert (found) using object arg");
});

t.drop();

// Using upsert, not found

for (let i = 0; i < 10; i++) {
    t.save({_id: i, k: "x", a: []});
}

t.update({k: "y"}, {$push: {a: "y"}}, {upsert: true});
assert.eq(1, t.find({"k": "y", "a": "y"}).count(), "upsert (not found) using object arg");

t.drop();

// Without upsert, found

for (let i = 0; i < 10; i++) {
    t.save({_id: i, k: "x", a: []});
}

t.update({k: "x"}, {$push: {a: "y"}}, {upsert: false});
assert.eq(1, t.find({"a": "y"}).count(), "no upsert (found) using object arg");

t.drop();

// Without upsert, not found

for (let i = 0; i < 10; i++) {
    t.save({_id: i, k: "x", a: []});
}

t.update({k: "y"}, {$push: {a: "y"}}, {upsert: false});
assert.eq(0, t.find({"a": "y"}).count(), "no upsert (not found) using object arg");

t.drop();
