// Code generated by ifacemaker; DO NOT EDIT.

package hcloud

import (
	"context"
)

// IImageClient ...
type IImageClient interface {
	// GetByID retrieves an image by its ID. If the image does not exist, nil is returned.
	GetByID(ctx context.Context, id int64) (*Image, *Response, error)
	// GetByName retrieves an image by its name. If the image does not exist, nil is returned.
	//
	// Deprecated: Use [ImageClient.GetByNameAndArchitecture] instead.
	GetByName(ctx context.Context, name string) (*Image, *Response, error)
	// GetByNameAndArchitecture retrieves an image by its name and architecture. If the image does not exist,
	// nil is returned.
	// In contrast to [ImageClient.Get], this method also returns deprecated images. Depending on your needs you should
	// check for this in your calling method.
	GetByNameAndArchitecture(ctx context.Context, name string, architecture Architecture) (*Image, *Response, error)
	// Get retrieves an image by its ID if the input can be parsed as an integer, otherwise it
	// retrieves an image by its name. If the image does not exist, nil is returned.
	//
	// Deprecated: Use [ImageClient.GetForArchitecture] instead.
	Get(ctx context.Context, idOrName string) (*Image, *Response, error)
	// GetForArchitecture retrieves an image by its ID if the input can be parsed as an integer, otherwise it
	// retrieves an image by its name and architecture. If the image does not exist, nil is returned.
	//
	// In contrast to [ImageClient.Get], this method also returns deprecated images. Depending on your needs you should
	// check for this in your calling method.
	GetForArchitecture(ctx context.Context, idOrName string, architecture Architecture) (*Image, *Response, error)
	// List returns a list of images for a specific page.
	//
	// Please note that filters specified in opts are not taken into account
	// when their value corresponds to their zero value or when they are empty.
	List(ctx context.Context, opts ImageListOpts) ([]*Image, *Response, error)
	// All returns all images.
	All(ctx context.Context) ([]*Image, error)
	// AllWithOpts returns all images for the given options.
	AllWithOpts(ctx context.Context, opts ImageListOpts) ([]*Image, error)
	// Delete deletes an image.
	Delete(ctx context.Context, image *Image) (*Response, error)
	// Update updates an image.
	Update(ctx context.Context, image *Image, opts ImageUpdateOpts) (*Image, *Response, error)
	// ChangeProtection changes the resource protection level of an image.
	ChangeProtection(ctx context.Context, image *Image, opts ImageChangeProtectionOpts) (*Action, *Response, error)
}
