/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.gateway.inspections;

import com.intellij.clouds.docker.gateway.DockerGatewayBundle;
import com.intellij.clouds.docker.gateway.utils.UtilsKt;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/clouds/docker/gateway/inspections/DevcontainerFolderInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "isAvailableForFile", "findDevContainerFolder", "Ljava/nio/file/Path;", "path", "intellij.clouds.docker.gateway"})
@SourceDebugExtension(value={"SMAP\nDevcontainerFolderInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerFolderInspection.kt\ncom/intellij/clouds/docker/gateway/inspections/DevcontainerFolderInspection\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,41:1\n37#2,2:42\n183#3,2:44\n*S KotlinDebug\n*F\n+ 1 DevcontainerFolderInspection.kt\ncom/intellij/clouds/docker/gateway/inspections/DevcontainerFolderInspection\n*L\n29#1:42,2\n39#1:44,2\n*E\n"})
public final class DevcontainerFolderInspection
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        ProblemsHolder problemsHolder = new ProblemsHolder(manager, file, isOnTheFly);
        Path path = file.getVirtualFile().toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        Path devcontainerFolder = this.findDevContainerFolder(path);
        if (devcontainerFolder == null) {
            problemsHolder.registerProblem((PsiElement)file, DockerGatewayBundle.message("devcontainer.inspection.message.missing.parent.devcontainer.folder", new Object[0]), new LocalQuickFix[0]);
        } else {
            Path path2 = devcontainerFolder.getParent();
            if (path2 == null) {
                return null;
            }
            Path parent = path2;
            Path path3 = this.findDevContainerFolder(parent);
            if (path3 != null) {
                Path it = path3;
                boolean bl = false;
                Object[] objectArray = new Object[]{it};
                problemsHolder.registerProblem((PsiElement)file, DockerGatewayBundle.message("devcontainer.inspection.message.ambiguous.dev.container.context", objectArray), new LocalQuickFix[0]);
            }
        }
        List list = problemsHolder.getResults();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResults(...)");
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ProblemDescriptor[0]);
    }

    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilsKt.isDevcontainerFile(file);
    }

    private final Path findDevContainerFolder(Path path) {
        Object v0;
        block2: {
            if (Intrinsics.areEqual((Object)PathsKt.getName((Path)path), (Object)".devcontainer.json")) {
                return path.getParent();
            }
            Sequence $this$firstOrNull$iv = SequencesKt.generateSequence((Object)path, DevcontainerFolderInspection::findDevContainerFolder$lambda$0);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PathsKt.getName((Path)it), (Object)".devcontainer")) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    private static final Path findDevContainerFolder$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }
}

