/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.LineInfo;
import com.jetbrains.jdi.MethodImpl;
import com.jetbrains.jdi.MirrorImpl;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.jetbrains.jdi.SDE;
import com.jetbrains.jdi.StratumLineInfo;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.util.concurrent.CompletableFuture;

public class LocationImpl
extends MirrorImpl
implements Location {
    private final ReferenceTypeImpl declaringType;
    private volatile Method method;
    private final long methodRef;
    private final long codeIndex;
    private LineInfo baseLineInfo = null;
    private LineInfo otherLineInfo = null;

    LocationImpl(VirtualMachine vm, Method method, long codeIndex) {
        super(vm);
        this.method = method;
        this.codeIndex = method.isNative() ? -1L : codeIndex;
        this.declaringType = (ReferenceTypeImpl)method.declaringType();
        this.methodRef = ((MethodImpl)method).ref();
    }

    LocationImpl(VirtualMachine vm, ReferenceTypeImpl declaringType, long methodRef, long codeIndex) {
        super(vm);
        this.method = null;
        this.codeIndex = codeIndex;
        this.declaringType = declaringType;
        this.methodRef = methodRef;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        if (!this.declaringType().equals(other.declaringType())) {
            return false;
        }
        if (other instanceof LocationImpl ? this.methodRef != ((LocationImpl)other).methodRef : !this.method().equals(other.method())) {
            return false;
        }
        return this.codeIndex() == other.codeIndex() && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.declaringType.hashCode();
        result = 31 * result + (int)(this.methodRef ^ this.methodRef >>> 32);
        result = 31 * result + (int)(this.codeIndex ^ this.codeIndex >>> 32);
        return result;
    }

    @Override
    public int compareTo(Location other) {
        int rc = this.method().compareTo(other.method());
        if (rc == 0) {
            long diff = this.codeIndex() - other.codeIndex();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
        return rc;
    }

    @Override
    public ReferenceType declaringType() {
        return this.declaringType;
    }

    @Override
    public Method method() {
        if (this.method == null) {
            this.method = this.declaringType.getMethodMirror(this.methodRef);
        }
        return this.method;
    }

    public CompletableFuture<Method> methodAsync() {
        if (this.method == null) {
            return this.declaringType.getMethodMirrorAsync(this.methodRef).thenApply(m -> {
                this.method = m;
                return this.method;
            });
        }
        return CompletableFuture.completedFuture(this.method);
    }

    public long methodRef() {
        return this.methodRef;
    }

    @Override
    public long codeIndex() {
        return this.codeIndex;
    }

    LineInfo getBaseLineInfo(SDE.Stratum stratum) {
        if (this.baseLineInfo != null) {
            return this.baseLineInfo;
        }
        MethodImpl methodImpl = (MethodImpl)this.method();
        LineInfo lineInfo = methodImpl.codeIndexToLineInfo(stratum, this.codeIndex());
        this.addBaseLineInfo(lineInfo);
        return lineInfo;
    }

    LineInfo getLineInfo(SDE.Stratum stratum) {
        if (stratum.isJava()) {
            return this.getBaseLineInfo(stratum);
        }
        LineInfo lineInfo = this.otherLineInfo;
        if (lineInfo != null && stratum.id().equals(lineInfo.liStratum())) {
            return lineInfo;
        }
        int baseLineNumber = this.lineNumber("Java");
        SDE.LineStratum lineStratum = stratum.lineStratum(this.declaringType, baseLineNumber);
        if (lineStratum != null && lineStratum.lineNumber() != -1) {
            lineInfo = new StratumLineInfo(stratum.id(), lineStratum.lineNumber(), lineStratum.sourceName(), lineStratum.sourcePath());
        } else {
            MethodImpl methodImpl = (MethodImpl)this.method();
            lineInfo = methodImpl.codeIndexToLineInfo(stratum, this.codeIndex());
        }
        this.addStratumLineInfo(lineInfo);
        return lineInfo;
    }

    void addStratumLineInfo(LineInfo lineInfo) {
        this.otherLineInfo = lineInfo;
    }

    void addBaseLineInfo(LineInfo lineInfo) {
        this.baseLineInfo = lineInfo;
    }

    @Override
    public String sourceName() throws AbsentInformationException {
        return this.sourceName(this.vm.getDefaultStratum());
    }

    @Override
    public String sourceName(String stratumID) throws AbsentInformationException {
        return this.sourceName(this.declaringType.stratum(stratumID));
    }

    String sourceName(SDE.Stratum stratum) throws AbsentInformationException {
        return this.getLineInfo(stratum).liSourceName();
    }

    @Override
    public String sourcePath() throws AbsentInformationException {
        return this.sourcePath(this.vm.getDefaultStratum());
    }

    @Override
    public String sourcePath(String stratumID) throws AbsentInformationException {
        return this.sourcePath(this.declaringType.stratum(stratumID));
    }

    String sourcePath(SDE.Stratum stratum) throws AbsentInformationException {
        return this.getLineInfo(stratum).liSourcePath();
    }

    @Override
    public int lineNumber() {
        return this.lineNumber(this.vm.getDefaultStratum());
    }

    @Override
    public int lineNumber(String stratumID) {
        return this.lineNumber(this.declaringType.stratum(stratumID));
    }

    int lineNumber(SDE.Stratum stratum) {
        return this.getLineInfo(stratum).liLineNumber();
    }

    @Override
    public String toString() {
        if (this.lineNumber() == -1) {
            return this.method().toString() + "+" + this.codeIndex();
        }
        return this.declaringType().name() + ":" + this.lineNumber();
    }
}

